/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.taskdefs.XSLTLiaison;
import org.apache.tools.ant.util.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.w3c.dom.Document;

public abstract class AbstractXSLTLiaisonTest {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    protected XSLTLiaison liaison;
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        this.liaison = this.createLiaison();
    }

    protected abstract XSLTLiaison createLiaison() throws Exception;

    protected File getFile(String name) throws FileNotFoundException {
        URL url = this.getClass().getResource(name);
        if (url == null) {
            throw new FileNotFoundException("Unable to load '" + name + "' from classpath");
        }
        return new File(FILE_UTILS.fromURI(url.toExternalForm()));
    }

    @Test
    public void testTransform() throws Exception {
        File xsl = this.getFile("/taskdefs/optional/xsltliaison-in.xsl");
        this.liaison.setStylesheet(xsl);
        this.liaison.addParam("param", "value");
        File in = this.getFile("/taskdefs/optional/xsltliaison-in.xml");
        File out = this.testFolder.newFile("xsltliaison.tmp");
        this.liaison.transform(in, out);
    }

    @Test
    public void testEncoding() throws Exception {
        File xsl = this.getFile("/taskdefs/optional/xsltliaison-encoding-in.xsl");
        this.liaison.setStylesheet(xsl);
        File in = this.getFile("/taskdefs/optional/xsltliaison-encoding-in.xml");
        File out = this.testFolder.newFile("xsltliaison-encoding.tmp");
        this.liaison.transform(in, out);
        Document doc = this.parseXML(out);
        Assert.assertEquals((Object)"root", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"message", (Object)doc.getDocumentElement().getFirstChild().getNodeName());
        Assert.assertEquals((Object)"\u00e9\u00e0\u00e8\u00ef\u00f9", (Object)doc.getDocumentElement().getFirstChild().getFirstChild().getNodeValue());
    }

    public Document parseXML(File file) throws Exception {
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dbuilder = dbfactory.newDocumentBuilder();
        return dbuilder.parse(file);
    }
}

