﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoTRequest.h>
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/iot/model/CertificateStatus.h>

#include <utility>

namespace Aws {
namespace IoT {
namespace Model {

/**
 */
class RegisterCertificateWithoutCARequest : public IoTRequest {
 public:
  AWS_IOT_API RegisterCertificateWithoutCARequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "RegisterCertificateWithoutCA"; }

  AWS_IOT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The certificate data, in PEM format.</p>
   */
  inline const Aws::String& GetCertificatePem() const { return m_certificatePem; }
  inline bool CertificatePemHasBeenSet() const { return m_certificatePemHasBeenSet; }
  template <typename CertificatePemT = Aws::String>
  void SetCertificatePem(CertificatePemT&& value) {
    m_certificatePemHasBeenSet = true;
    m_certificatePem = std::forward<CertificatePemT>(value);
  }
  template <typename CertificatePemT = Aws::String>
  RegisterCertificateWithoutCARequest& WithCertificatePem(CertificatePemT&& value) {
    SetCertificatePem(std::forward<CertificatePemT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the register certificate request.</p>
   */
  inline CertificateStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(CertificateStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline RegisterCertificateWithoutCARequest& WithStatus(CertificateStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_certificatePem;

  CertificateStatus m_status{CertificateStatus::NOT_SET};
  bool m_certificatePemHasBeenSet = false;
  bool m_statusHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
