/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import groovy.lang.Closure;
import javax.inject.Inject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.plugin.software.internal.SoftwareFeatureApplicator;
import org.gradle.plugin.software.internal.SoftwareFeatureImplementation;
import org.gradle.plugin.software.internal.SoftwareFeatureRegistry;
import org.gradle.plugin.software.internal.SoftwareFeatureSupportInternal;
import org.gradle.plugin.software.internal.TargetTypeInformationChecks;
import org.gradle.util.internal.ConfigureUtil;
import org.jspecify.annotations.Nullable;

public abstract class SoftwareFeaturesDynamicObject
extends AbstractDynamicObject {
    private final DynamicObjectAware target;
    private final SoftwareFeatureSupportInternal.ProjectFeatureDefinitionContext context;
    public static final String CONTEXT_METHOD_NAME = "$.softwareFeatureContext";

    @Inject
    public SoftwareFeaturesDynamicObject(DynamicObjectAware target, SoftwareFeatureSupportInternal.ProjectFeatureDefinitionContext context) {
        this.target = target;
        this.context = context;
    }

    public String getDisplayName() {
        return "software features";
    }

    public boolean hasMethod(String name, Object ... arguments) {
        return this.isSoftwareFeatureConfigureMethod(name, arguments);
    }

    private boolean isSoftwareFeatureConfigureMethod(String name, @Nullable Object[] arguments) {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof Closure)) {
            return false;
        }
        SoftwareFeatureImplementation<?, ?> feature = this.getSoftwareTypeRegistry().getSoftwareFeatureImplementations().get(name);
        if (feature == null) {
            return false;
        }
        return TargetTypeInformationChecks.isValidBindingType(feature.getTargetDefinitionType(), this.target.getClass());
    }

    public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
        if (name.equals(CONTEXT_METHOD_NAME) && arguments.length == 0) {
            return DynamicInvokeResult.found((Object)this.context);
        }
        if (this.isSoftwareFeatureConfigureMethod(name, arguments)) {
            Object softwareFeatureConfigurationModel = this.getSoftwareFeatureApplicator().applyFeatureTo(this.target, this.getSoftwareTypeRegistry().getSoftwareFeatureImplementations().get(name));
            return DynamicInvokeResult.found((Object)ConfigureUtil.configure((Closure)((Closure)arguments[0]), softwareFeatureConfigurationModel));
        }
        return DynamicInvokeResult.notFound();
    }

    @Inject
    protected abstract SoftwareFeatureRegistry getSoftwareTypeRegistry();

    @Inject
    protected abstract SoftwareFeatureApplicator getSoftwareFeatureApplicator();
}

