/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import jdk.jfr.Event;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.EventControl;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.handlers.EventHandler;

final class SettingsManager {
    private Map<String, InternalSetting> availableSettings = new LinkedHashMap<String, InternalSetting>();

    SettingsManager() {
    }

    void setSettings(List<Map<String, String>> list) {
        this.availableSettings = this.createSettingsMap(list);
        List<EventControl> list2 = MetadataRepository.getInstance().getEventControls();
        if (!JVM.getJVM().isRecording()) {
            for (EventControl eventControl3 : list2) {
                eventControl3.disable();
            }
        } else {
            if (Logger.shouldLog(LogTag.JFR_SETTING, LogLevel.INFO)) {
                Collections.sort(list2, (eventControl, eventControl2) -> eventControl.getEventType().getName().compareTo(eventControl2.getEventType().getName()));
            }
            for (EventControl eventControl4 : list2) {
                this.setEventControl(eventControl4);
            }
        }
        if (JVM.getJVM().getAllowedToDoEventRetransforms()) {
            this.updateRetransform(JVM.getJVM().getAllEventClasses());
        }
    }

    public void updateRetransform(List<Class<? extends Event>> list) {
        ArrayList<Class<? extends Event>> arrayList = new ArrayList<Class<? extends Event>>();
        for (Class<? extends Event> clazz : list) {
            PlatformEventType platformEventType;
            EventHandler eventHandler = Utils.getHandler(clazz);
            if (eventHandler == null || !(platformEventType = eventHandler.getPlatformEventType()).isMarkedForInstrumentation()) continue;
            arrayList.add(clazz);
            platformEventType.markForInstrumentation(false);
            platformEventType.setInstrumented();
        }
        if (!arrayList.isEmpty()) {
            JVM.getJVM().retransformClasses(arrayList.toArray(new Class[0]));
        }
    }

    private Map<String, InternalSetting> createSettingsMap(List<Map<String, String>> list) {
        LinkedHashMap<String, InternalSetting> linkedHashMap = new LinkedHashMap<String, InternalSetting>(list.size());
        for (Map<String, String> map : list) {
            for (InternalSetting internalSetting : this.makeInternalSettings(map)) {
                InternalSetting internalSetting2 = (InternalSetting)linkedHashMap.get(internalSetting.getSettingsId());
                if (internalSetting2 == null) {
                    linkedHashMap.put(internalSetting.getSettingsId(), internalSetting);
                    continue;
                }
                internalSetting2.add(internalSetting);
            }
        }
        return linkedHashMap;
    }

    private Collection<InternalSetting> makeInternalSettings(Map<String, String> map) {
        LinkedHashMap<String, InternalSetting> linkedHashMap = new LinkedHashMap<String, InternalSetting>();
        for (Map.Entry<String, String> object : map.entrySet()) {
            String string = object.getKey();
            String string2 = object.getValue();
            int n = string.indexOf("#");
            if (n <= 1 || n >= string.length() - 2) continue;
            String string3 = string.substring(0, n);
            string3 = Utils.upgradeLegacyJDKEvent(string3);
            InternalSetting internalSetting = (InternalSetting)linkedHashMap.get(string3);
            String string4 = string.substring(n + 1).trim();
            if (internalSetting == null) {
                internalSetting = new InternalSetting(string3);
                linkedHashMap.put(string3, internalSetting);
            }
            internalSetting.add(string4, string2);
        }
        for (InternalSetting internalSetting : linkedHashMap.values()) {
            internalSetting.finish();
        }
        return linkedHashMap.values();
    }

    void setEventControl(EventControl eventControl) {
        InternalSetting internalSetting = this.getInternalSetting(eventControl);
        Logger.log(LogTag.JFR_SETTING, LogLevel.INFO, "Applied settings for " + eventControl.getEventType().getLogName() + " {");
        for (Map.Entry<String, Control> entry : eventControl.getEntries()) {
            String string;
            Set<String> set = null;
            String string2 = entry.getKey();
            if (internalSetting != null) {
                set = internalSetting.getValues(string2);
            }
            Control control = entry.getValue();
            if (set != null) {
                Object object;
                control.apply(set);
                string = control.getLastValue();
                if (!Logger.shouldLog(LogTag.JFR_SETTING, LogLevel.INFO) || !Utils.isSettingVisible(control, eventControl.getEventType().hasEventHook())) continue;
                if (set.size() > 1) {
                    object = new StringJoiner(", ", "{", "}");
                    for (String string3 : set) {
                        ((StringJoiner)object).add("\"" + string3 + "\"");
                    }
                    String string4 = "  " + string2 + "= " + ((StringJoiner)object).toString() + " => \"" + string + "\"";
                    Logger.log(LogTag.JFR_SETTING, LogLevel.INFO, string4);
                    continue;
                }
                object = "  " + string2 + "=\"" + control.getLastValue() + "\"";
                Logger.log(LogTag.JFR_SETTING, LogLevel.INFO, (String)object);
                continue;
            }
            control.setDefault();
            if (!Logger.shouldLog(LogTag.JFR_SETTING, LogLevel.INFO)) continue;
            string = "  " + string2 + "=\"" + control.getLastValue() + "\"";
            Logger.log(LogTag.JFR_SETTING, LogLevel.INFO, string);
        }
        eventControl.writeActiveSettingEvent();
        Logger.log(LogTag.JFR_SETTING, LogLevel.INFO, "}");
    }

    private InternalSetting getInternalSetting(EventControl eventControl) {
        String string = eventControl.getEventType().getName();
        InternalSetting internalSetting = this.availableSettings.get(string);
        InternalSetting internalSetting2 = this.availableSettings.get(eventControl.getSettingsId());
        if (internalSetting == null && internalSetting2 == null) {
            return null;
        }
        if (internalSetting2 == null) {
            return internalSetting;
        }
        if (internalSetting == null) {
            return internalSetting2;
        }
        InternalSetting internalSetting3 = new InternalSetting(internalSetting.getSettingsId());
        internalSetting3.add(internalSetting);
        internalSetting3.add(internalSetting2);
        return internalSetting3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (InternalSetting internalSetting : this.availableSettings.values()) {
            stringBuilder.append(internalSetting.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    boolean isEnabled(String string) {
        InternalSetting internalSetting = this.availableSettings.get(string);
        if (internalSetting == null) {
            return false;
        }
        return internalSetting.isEnabled();
    }

    private static class InternalSetting {
        private final String identifier;
        private Map<String, Set<String>> enabledMap = new LinkedHashMap<String, Set<String>>(5);
        private Map<String, Set<String>> allMap = new LinkedHashMap<String, Set<String>>(5);
        private boolean enabled;

        public InternalSetting(String string) {
            this.identifier = string;
        }

        public Set<String> getValues(String string) {
            if (this.enabled) {
                return this.enabledMap.get(string);
            }
            return this.allMap.get(string);
        }

        public void add(String string, String string2) {
            if ("enabled".equals(string) && "true".equals(string2)) {
                this.enabled = true;
                this.allMap = null;
            }
            this.addToMap(this.enabledMap, string, string2);
            if (this.allMap != null) {
                this.addToMap(this.allMap, string, string2);
            }
        }

        private void addToMap(Map<String, Set<String>> map, String string, String string2) {
            Set<String> set = map.get(string);
            if (set == null) {
                set = new HashSet<String>(5);
                map.put(string, set);
            }
            set.add(string2);
        }

        public String getSettingsId() {
            return this.identifier;
        }

        public void add(InternalSetting internalSetting) {
            for (Map.Entry<String, Set<String>> entry : internalSetting.enabledMap.entrySet()) {
                for (String string : entry.getValue()) {
                    this.add(entry.getKey(), string);
                }
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.identifier);
            stringBuilder.append(": ");
            stringBuilder.append(this.enabledMap.toString());
            return stringBuilder.toString();
        }

        public void finish() {
            if (!this.enabled) {
                HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>(2);
                HashSet<String> hashSet = new HashSet<String>(2);
                hashSet.add("false");
                hashMap.put("enabled", hashSet);
                this.enabledMap = hashMap;
            }
        }
    }
}

