/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import org.jsampler.CC;
import org.jsampler.view.JSChannelsPane;
import org.jsampler.view.fantasia.ChannelsBar;
import org.jsampler.view.fantasia.ChannelsPane;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.basic.FantasiaPanel;
import org.jsampler.view.fantasia.basic.FantasiaToggleButtonsPanel;
import org.jsampler.view.fantasia.basic.PixmapButton;
import org.jsampler.view.fantasia.basic.PixmapPane;

public class MainPane
extends FantasiaPanel {
    private final ChannelsBar channelsBar;
    private final ButtonsPanel buttonsPanel;
    private final Vector<ChannelsPanel> channelsPanes = new Vector();
    final JScrollPane scrollPane = new JScrollPane();
    private final EventHandler eventHandler = new EventHandler();

    public MainPane() {
        Object object;
        this.setOpaque(false);
        int n = CC.preferences().getIntProperty("channelLanes.count");
        for (int i = 0; i < n; ++i) {
            object = FantasiaI18n.i18n.getButtonLabel("MainPane.ButtonsPanel.tt", i + 1);
            this.channelsPanes.add(new ChannelsPanel((String)object));
        }
        this.buttonsPanel = new ButtonsPanel(n);
        if (n == 1) {
            this.buttonsPanel.setVisible(false);
        }
        this.channelsBar = new ChannelsBar(this.buttonsPanel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        object = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        FantasiaPanel fantasiaPanel = new FantasiaPanel();
        fantasiaPanel.setOpaque(false);
        fantasiaPanel.setLayout(new BoxLayout(fantasiaPanel, 0));
        fantasiaPanel.add(this.channelsBar);
        fantasiaPanel.add(Box.createGlue());
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)object).fill = 2;
        gridBagLayout.setConstraints(fantasiaPanel, (GridBagConstraints)object);
        this.add(fantasiaPanel);
        JScrollPane jScrollPane = this.scrollPane;
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setOpaque(false);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setMinimumSize(new Dimension(400, jViewport.getMinimumSize().height));
        jViewport.setOpaque(false);
        jScrollPane.setMaximumSize(new Dimension(jScrollPane.getMaximumSize().width, Short.MAX_VALUE));
        jScrollPane.getVerticalScrollBar().setBorder(BorderFactory.createEmptyBorder(7, 4, 0, 1));
        jScrollPane.setPreferredSize(new Dimension(420, jScrollPane.getPreferredSize().height));
        jScrollPane.getVerticalScrollBar().addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 4L) {
                    return;
                }
                MainPane.this.onScrollBarVisibilityChanged();
            }
        });
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)object).fill = 1;
        gridBagLayout.setConstraints(jScrollPane, (GridBagConstraints)object);
        this.add(jScrollPane);
        this.setMaximumSize(new Dimension(420, Short.MAX_VALUE));
    }

    public JSChannelsPane addChannelsPane() {
        String string = FantasiaI18n.i18n.getButtonLabel("MainPane.ButtonsPanel.tt", this.channelsPanes.size() + 1);
        ChannelsPanel channelsPanel = new ChannelsPanel(string);
        this.channelsPanes.add(channelsPanel);
        return channelsPanel.getChannelsPane();
    }

    private void onScrollBarVisibilityChanged() {
        int n = 420;
        int n2 = this.scrollPane.getPreferredSize().height;
        int n3 = this.scrollPane.getVerticalScrollBar().getPreferredSize().width;
        if (this.scrollPane.getVerticalScrollBar().isVisible()) {
            n += n3;
        }
        this.scrollPane.setMinimumSize(new Dimension(n, this.scrollPane.getPreferredSize().height));
        this.scrollPane.setPreferredSize(new Dimension(n, n2));
        this.scrollPane.setMaximumSize(new Dimension(n, Short.MAX_VALUE));
        this.setMaximumSize(new Dimension(n, Short.MAX_VALUE));
        if (CC.getMainFrame() != null && !CC.getMainFrame().isResizable()) {
            n = CC.getMainFrame().getPreferredSize().width;
            CC.getMainFrame().setSize(n, CC.getMainFrame().getHeight());
        }
        this.revalidate();
    }

    public void scrollToBottom() {
        int n = this.scrollPane.getViewport().getView().getHeight();
        this.scrollPane.getViewport().scrollRectToVisible(new Rectangle(0, n - 2, 1, 1));
    }

    public JSChannelsPane getChannelsPane(int n) {
        return this.channelsPanes.get(n).getChannelsPane();
    }

    public int getChannelsPaneCount() {
        return this.channelsPanes.size();
    }

    public void removeChannelsPane(int n) {
        this.channelsPanes.remove(n);
    }

    public void setSelectedChannelsPane(JSChannelsPane jSChannelsPane) {
        ChannelsPanel channelsPanel = null;
        for (int i = 0; i < this.getChannelsPaneCount(); ++i) {
            if (this.channelsPanes.get(i).getChannelsPane() != jSChannelsPane) continue;
            channelsPanel = this.channelsPanes.get(i);
            if (((JToggleButton)this.buttonsPanel.buttons.get(i)).isSelected()) break;
            ((JToggleButton)this.buttonsPanel.buttons.get(i)).setSelected(true);
            break;
        }
        if (channelsPanel == null) {
            CC.getLogger().warning("Unknown channels pane");
            return;
        }
        this.scrollPane.getViewport().setView(channelsPanel);
    }

    public JSChannelsPane getSelectedChannelsPane() {
        for (int i = 0; i < this.getChannelsPaneCount(); ++i) {
            if (!((JToggleButton)this.buttonsPanel.buttons.get(i)).isSelected()) continue;
            return this.channelsPanes.get(i).getChannelsPane();
        }
        return null;
    }

    public ButtonsPanel getButtonsPanel() {
        return this.buttonsPanel;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = Res.gfxChannelsBg.getIconHeight();
        if (n < 1) {
            return;
        }
        for (int i = 0; i < this.getHeight(); i += n) {
            Res.gfxChannelsBg.paintIcon(this, graphics, 0, i);
        }
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    class NewChannelPane
    extends PixmapPane
    implements ActionListener {
        private final PixmapButton btnNew;

        NewChannelPane() {
            super(Res.gfxCreateChannel);
            this.btnNew = new PixmapButton(Res.gfxPowerOff);
            this.setPixmapInsets(new Insets(3, 3, 3, 3));
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createRigidArea(new Dimension(3, 0)));
            this.add(this.btnNew);
            this.add(Box.createRigidArea(new Dimension(4, 0)));
            this.add(this.createVSeparator());
            this.add(Box.createRigidArea(new Dimension(275, 0)));
            this.add(this.createVSeparator());
            this.add(Box.createRigidArea(new Dimension(29, 0)));
            this.add(this.createVSeparator());
            this.add(Box.createRigidArea(new Dimension(40, 0)));
            this.add(this.createVSeparator());
            this.setPreferredSize(new Dimension(420, 29));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.btnNew.setPressedIcon(Res.gfxPowerOn);
            this.btnNew.addActionListener(this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() != 1) {
                        return;
                    }
                    CC.getSamplerModel().addBackendChannel();
                }
            });
            this.setCursor(Cursor.getPredefinedCursor(12));
            String string = FantasiaI18n.i18n.getLabel("MainPane.NewChannelPane.newChannel");
            this.btnNew.setToolTipText(string);
            this.setToolTipText(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CC.getSamplerModel().addBackendChannel();
        }

        private JPanel createVSeparator() {
            PixmapPane pixmapPane = new PixmapPane(Res.gfxVLine);
            pixmapPane.setOpaque(false);
            pixmapPane.setPreferredSize(new Dimension(2, 29));
            pixmapPane.setMinimumSize(pixmapPane.getPreferredSize());
            pixmapPane.setMaximumSize(pixmapPane.getPreferredSize());
            return pixmapPane;
        }
    }

    public class ButtonsPanel
    extends FantasiaToggleButtonsPanel
    implements ActionListener {
        public ButtonsPanel(int n) {
            super(n, true);
            this.setButtonNumber(n);
        }

        @Override
        public void setButtonNumber(int n) {
            int n2;
            if (n > 8) {
                return;
            }
            int n3 = n == 7 ? 98 : 96;
            int n4 = n3 / n;
            for (n2 = 0; n2 < this.buttons.size(); ++n2) {
                ((JToggleButton)this.buttons.get(n2)).removeActionListener(this);
            }
            super.setButtonNumber(n);
            for (n2 = 0; n2 < n; ++n2) {
                JToggleButton jToggleButton = (JToggleButton)this.buttons.get(n2);
                jToggleButton.setText(String.valueOf(n2 + 1));
                jToggleButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                jToggleButton.addActionListener(this);
                jToggleButton.setMinimumSize(new Dimension(n4, jToggleButton.getPreferredSize().height));
                jToggleButton.setPreferredSize(jToggleButton.getMinimumSize());
                jToggleButton.setMaximumSize(jToggleButton.getMinimumSize());
                String string = "MainPane.ButtonsPanel.tt";
                jToggleButton.setToolTipText(FantasiaI18n.i18n.getButtonLabel(string, n2 + 1));
            }
            this.setMaximumSize(this.getPreferredSize());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (!abstractButton.isSelected()) {
                return;
            }
            int n = this.buttons.indexOf(abstractButton);
            if (n == -1) {
                return;
            }
            ChannelsPanel channelsPanel = (ChannelsPanel)MainPane.this.channelsPanes.get(n);
            CC.getMainFrame().setSelectedChannelsPane(channelsPanel.getChannelsPane());
        }
    }

    private class ChannelsPanel
    extends FantasiaPanel {
        private final JSChannelsPane channelsPane;

        ChannelsPanel(String string) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainPane.this.scrollToBottom();
                }
            };
            this.channelsPane = new ChannelsPane(string, actionListener);
            this.setLayout(new BoxLayout(this, 1));
            this.channelsPane.setAlignmentX(0.0f);
            this.add(this.channelsPane);
            NewChannelPane newChannelPane = new NewChannelPane();
            newChannelPane.setAlignmentX(0.0f);
            this.add(newChannelPane);
            this.add(Box.createGlue());
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(7, 0, 0, 0));
            this.setMinimumSize(new Dimension(420, this.getMinimumSize().height));
            this.setAlignmentX(0.0f);
            this.addMouseListener(MainPane.this.getHandler());
        }

        public JSChannelsPane getChannelsPane() {
            return this.channelsPane;
        }
    }

    private class EventHandler
    extends MouseAdapter {
        private EventHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            CC.getMainFrame().getSelectedChannelsPane().setSelectedChannel(null);
        }
    }
}

