# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_nickel_global_optspecs
	string join \n color= error-format= metrics h/help V/version
end

function __fish_nickel_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_nickel_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_nickel_using_subcommand
	set -l cmd (__fish_nickel_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c nickel -n "__fish_nickel_needs_command" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_needs_command" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_needs_command" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_needs_command" -s h -l help -d 'Print help'
complete -c nickel -n "__fish_nickel_needs_command" -s V -l version -d 'Print version'
complete -c nickel -n "__fish_nickel_needs_command" -f -a "eval" -d 'Evaluates a Nickel program and pretty-prints the result'
complete -c nickel -n "__fish_nickel_needs_command" -f -a "pprint-ast" -d 'Converts the parsed representation (AST) back to Nickel source code and prints it. Used for debugging purpose'
complete -c nickel -n "__fish_nickel_needs_command" -f -a "export" -d 'Evaluates a Nickel program and serializes the result to a given format'
complete -c nickel -n "__fish_nickel_needs_command" -f -a "query" -d 'Prints the metadata attached to an attribute, given as a path'
complete -c nickel -n "__fish_nickel_needs_command" -f -a "typecheck" -d 'Typechecks the program but does not run it'
complete -c nickel -n "__fish_nickel_needs_command" -f -a "convert" -d 'Converts from a plain-data format to Nickel'
complete -c nickel -n "__fish_nickel_needs_command" -f -a "package" -d 'Performs packaging and dependency-resolution operations'
complete -c nickel -n "__fish_nickel_needs_command" -f -a "repl" -d 'Starts a REPL session'
complete -c nickel -n "__fish_nickel_needs_command" -f -a "doc" -d 'Generates the documentation files for the a specified nickel file'
complete -c nickel -n "__fish_nickel_needs_command" -f -a "test" -d 'Tests the documentation examples in the specified nickel file'
complete -c nickel -n "__fish_nickel_needs_command" -f -a "format" -d 'Formats Nickel files'
complete -c nickel -n "__fish_nickel_needs_command" -f -a "gen-completions" -d 'Generate shell completion files'
complete -c nickel -n "__fish_nickel_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nickel -n "__fish_nickel_using_subcommand eval" -l apply-contract -d 'Validates the final configuration against a contract specified as a Nickel file. If this argument is used multiple times, all specified contracts will be applied sequentially' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand eval" -l stdin-format -d 'Specify the format of the input from stdin' -r -f -a "nickel\t''
json\t''
yaml\t''
toml\t''
nix\t''
text\t''"
complete -c nickel -n "__fish_nickel_using_subcommand eval" -s I -l import-path -d 'Adds a directory to the list of paths to search for imports in' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand eval" -l field -d 'Only query or act on a specific field of the configuration. For example, `nickel export config.ncl --field machines.servers.remote_builder` will only evaluate and export the content of the `remote_builder` field' -r
complete -c nickel -n "__fish_nickel_using_subcommand eval" -l manifest-path -d 'Path to a package lock file' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand eval" -l package-cache-dir -d 'Filesystem location for caching fetched packages' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand eval" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand eval" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand eval" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand eval" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nickel -n "__fish_nickel_using_subcommand pprint-ast" -l apply-contract -d 'Validates the final configuration against a contract specified as a Nickel file. If this argument is used multiple times, all specified contracts will be applied sequentially' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand pprint-ast" -s I -l import-path -d 'Adds a directory to the list of paths to search for imports in' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand pprint-ast" -l manifest-path -d 'Path to a package lock file' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand pprint-ast" -l package-cache-dir -d 'Filesystem location for caching fetched packages' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand pprint-ast" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand pprint-ast" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand pprint-ast" -l transform -d 'Performs code transformations before printing'
complete -c nickel -n "__fish_nickel_using_subcommand pprint-ast" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand pprint-ast" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nickel -n "__fish_nickel_using_subcommand export" -s f -l format -r -f -a "text\t'Evaluate a Nickel expression to a string and write that text to the output Note: `raw` is a deprecated alias for `text`; prefer `text` instead'
json\t''
yaml\t''
yaml-documents\t'Like `Yaml`, but generates multiple YAML documents in a single file, separated by `---`. The output data must be a list: each list element is converted into its own document'
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand export" -s o -l output -d 'Output file. Standard output by default' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand export" -l apply-contract -d 'Validates the final configuration against a contract specified as a Nickel file. If this argument is used multiple times, all specified contracts will be applied sequentially' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand export" -l stdin-format -d 'Specify the format of the input from stdin' -r -f -a "nickel\t''
json\t''
yaml\t''
toml\t''
nix\t''
text\t''"
complete -c nickel -n "__fish_nickel_using_subcommand export" -s I -l import-path -d 'Adds a directory to the list of paths to search for imports in' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand export" -l field -d 'Only query or act on a specific field of the configuration. For example, `nickel export config.ncl --field machines.servers.remote_builder` will only evaluate and export the content of the `remote_builder` field' -r
complete -c nickel -n "__fish_nickel_using_subcommand export" -l manifest-path -d 'Path to a package lock file' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand export" -l package-cache-dir -d 'Filesystem location for caching fetched packages' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand export" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand export" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand export" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand export" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nickel -n "__fish_nickel_using_subcommand query" -s f -l format -d 'Export the value and all metadata of selected field in the specified format. Value is exported in its string representation, capped at 80 characters' -r -f -a "markdown\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand query" -s o -l output -d 'Output file. Standard output by default' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand query" -l apply-contract -d 'Validates the final configuration against a contract specified as a Nickel file. If this argument is used multiple times, all specified contracts will be applied sequentially' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand query" -l stdin-format -d 'Specify the format of the input from stdin' -r -f -a "nickel\t''
json\t''
yaml\t''
toml\t''
nix\t''
text\t''"
complete -c nickel -n "__fish_nickel_using_subcommand query" -s I -l import-path -d 'Adds a directory to the list of paths to search for imports in' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand query" -l field -d 'Only query or act on a specific field of the configuration. For example, `nickel export config.ncl --field machines.servers.remote_builder` will only evaluate and export the content of the `remote_builder` field' -r
complete -c nickel -n "__fish_nickel_using_subcommand query" -l manifest-path -d 'Path to a package lock file' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand query" -l package-cache-dir -d 'Filesystem location for caching fetched packages' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand query" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand query" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand query" -l doc
complete -c nickel -n "__fish_nickel_using_subcommand query" -l contract
complete -c nickel -n "__fish_nickel_using_subcommand query" -l type
complete -c nickel -n "__fish_nickel_using_subcommand query" -l default
complete -c nickel -n "__fish_nickel_using_subcommand query" -l value
complete -c nickel -n "__fish_nickel_using_subcommand query" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand query" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nickel -n "__fish_nickel_using_subcommand typecheck" -l apply-contract -d 'Validates the final configuration against a contract specified as a Nickel file. If this argument is used multiple times, all specified contracts will be applied sequentially' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand typecheck" -s I -l import-path -d 'Adds a directory to the list of paths to search for imports in' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand typecheck" -l manifest-path -d 'Path to a package lock file' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand typecheck" -l package-cache-dir -d 'Filesystem location for caching fetched packages' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand typecheck" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand typecheck" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand typecheck" -l strict-typechecking -d 'Start the type-checker in strict mode, so that the entire input is treated as a typed block'
complete -c nickel -n "__fish_nickel_using_subcommand typecheck" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand typecheck" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nickel -n "__fish_nickel_using_subcommand convert" -l stdin-format -d 'Specify the format of the input from stdin' -r -f -a "nickel\t''
json\t''
yaml\t''
toml\t''
nix\t''
text\t''"
complete -c nickel -n "__fish_nickel_using_subcommand convert" -s o -l output -d 'Output file. Standard output by default' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand convert" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand convert" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand convert" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand convert" -s h -l help -d 'Print help'
complete -c nickel -n "__fish_nickel_using_subcommand package; and not __fish_seen_subcommand_from lock debug-resolution download-deps publish help" -l manifest-path -d 'The location of the package\'s manifest file' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand package; and not __fish_seen_subcommand_from lock debug-resolution download-deps publish help" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand package; and not __fish_seen_subcommand_from lock debug-resolution download-deps publish help" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand package; and not __fish_seen_subcommand_from lock debug-resolution download-deps publish help" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand package; and not __fish_seen_subcommand_from lock debug-resolution download-deps publish help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nickel -n "__fish_nickel_using_subcommand package; and not __fish_seen_subcommand_from lock debug-resolution download-deps publish help" -f -a "lock" -d 'Generate a lock file for a package'
complete -c nickel -n "__fish_nickel_using_subcommand package; and not __fish_seen_subcommand_from lock debug-resolution download-deps publish help" -f -a "debug-resolution" -d 'Make a package map and print it out. For internal debugging'
complete -c nickel -n "__fish_nickel_using_subcommand package; and not __fish_seen_subcommand_from lock debug-resolution download-deps publish help" -f -a "download-deps" -d 'Download all of a package\'s non-local dependencies into the given directory'
complete -c nickel -n "__fish_nickel_using_subcommand package; and not __fish_seen_subcommand_from lock debug-resolution download-deps publish help" -f -a "publish" -d 'Modify a local copy of the index, by adding a new version of a package'
complete -c nickel -n "__fish_nickel_using_subcommand package; and not __fish_seen_subcommand_from lock debug-resolution download-deps publish help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from lock" -l manifest-path -d 'The location of the package\'s manifest file' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from lock" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from lock" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from lock" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from lock" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from debug-resolution" -l manifest-path -d 'The location of the package\'s manifest file' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from debug-resolution" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from debug-resolution" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from debug-resolution" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from debug-resolution" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from download-deps" -l out-dir -r -F
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from download-deps" -l manifest-path -d 'The location of the package\'s manifest file' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from download-deps" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from download-deps" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from download-deps" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from download-deps" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from publish" -l index -d 'The location of the index to modify' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from publish" -l package-id -d 'The package id (like "github:nickel-lang/json-schema-lib") that you want to publish' -r
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from publish" -l manifest-path -d 'The location of the package\'s manifest file' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from publish" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from publish" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from publish" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from publish" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from help" -f -a "lock" -d 'Generate a lock file for a package'
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from help" -f -a "debug-resolution" -d 'Make a package map and print it out. For internal debugging'
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from help" -f -a "download-deps" -d 'Download all of a package\'s non-local dependencies into the given directory'
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from help" -f -a "publish" -d 'Modify a local copy of the index, by adding a new version of a package'
complete -c nickel -n "__fish_nickel_using_subcommand package; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nickel -n "__fish_nickel_using_subcommand repl" -l history-file -r -F
complete -c nickel -n "__fish_nickel_using_subcommand repl" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand repl" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand repl" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand repl" -s h -l help -d 'Print help'
complete -c nickel -n "__fish_nickel_using_subcommand doc" -s o -l output -d 'The path of the generated documentation file. Default to `~/.nickel/doc/<input-file>.md` for input `<input-file>.ncl`, or to `~/.nickel/doc/out.md` if the input is read from stdin' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand doc" -l format -d 'The output format for the generated documentation' -r -f -a "json\t''
markdown\t''"
complete -c nickel -n "__fish_nickel_using_subcommand doc" -l apply-contract -d 'Validates the final configuration against a contract specified as a Nickel file. If this argument is used multiple times, all specified contracts will be applied sequentially' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand doc" -s I -l import-path -d 'Adds a directory to the list of paths to search for imports in' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand doc" -l field -d 'Only query or act on a specific field of the configuration. For example, `nickel export config.ncl --field machines.servers.remote_builder` will only evaluate and export the content of the `remote_builder` field' -r
complete -c nickel -n "__fish_nickel_using_subcommand doc" -l manifest-path -d 'Path to a package lock file' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand doc" -l package-cache-dir -d 'Filesystem location for caching fetched packages' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand doc" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand doc" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand doc" -l stdout -d 'Write documentation to stdout. Takes precedence over `output`'
complete -c nickel -n "__fish_nickel_using_subcommand doc" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand doc" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nickel -n "__fish_nickel_using_subcommand test" -l apply-contract -d 'Validates the final configuration against a contract specified as a Nickel file. If this argument is used multiple times, all specified contracts will be applied sequentially' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand test" -s I -l import-path -d 'Adds a directory to the list of paths to search for imports in' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand test" -l field -d 'Only query or act on a specific field of the configuration. For example, `nickel export config.ncl --field machines.servers.remote_builder` will only evaluate and export the content of the `remote_builder` field' -r
complete -c nickel -n "__fish_nickel_using_subcommand test" -l manifest-path -d 'Path to a package lock file' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand test" -l package-cache-dir -d 'Filesystem location for caching fetched packages' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand test" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand test" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand test" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand test" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nickel -n "__fish_nickel_using_subcommand format" -l apply-contract -d 'Validates the final configuration against a contract specified as a Nickel file. If this argument is used multiple times, all specified contracts will be applied sequentially' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand format" -s I -l import-path -d 'Adds a directory to the list of paths to search for imports in' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand format" -l manifest-path -d 'Path to a package lock file' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand format" -l package-cache-dir -d 'Filesystem location for caching fetched packages' -r -F
complete -c nickel -n "__fish_nickel_using_subcommand format" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand format" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand format" -l check -d 'Do not change the input files, instead return non-zero if any of the input file is badly formatted'
complete -c nickel -n "__fish_nickel_using_subcommand format" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand format" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nickel -n "__fish_nickel_using_subcommand gen-completions" -l color -d 'Configure when to output messages in color' -r -f -a "auto\t''
always\t''
never\t''"
complete -c nickel -n "__fish_nickel_using_subcommand gen-completions" -l error-format -d 'Output error messages in a specific format. The schema of serialized errors reflects the way they are currently rendered. This schema is not guaranteed to be stable yet' -r -f -a "text\t''
json\t''
yaml\t''
toml\t''"
complete -c nickel -n "__fish_nickel_using_subcommand gen-completions" -l metrics -d 'Print all recorded metrics at the very end of the program'
complete -c nickel -n "__fish_nickel_using_subcommand gen-completions" -s h -l help -d 'Print help'
complete -c nickel -n "__fish_nickel_using_subcommand help; and not __fish_seen_subcommand_from eval pprint-ast export query typecheck convert package repl doc test format gen-completions help" -f -a "eval" -d 'Evaluates a Nickel program and pretty-prints the result'
complete -c nickel -n "__fish_nickel_using_subcommand help; and not __fish_seen_subcommand_from eval pprint-ast export query typecheck convert package repl doc test format gen-completions help" -f -a "pprint-ast" -d 'Converts the parsed representation (AST) back to Nickel source code and prints it. Used for debugging purpose'
complete -c nickel -n "__fish_nickel_using_subcommand help; and not __fish_seen_subcommand_from eval pprint-ast export query typecheck convert package repl doc test format gen-completions help" -f -a "export" -d 'Evaluates a Nickel program and serializes the result to a given format'
complete -c nickel -n "__fish_nickel_using_subcommand help; and not __fish_seen_subcommand_from eval pprint-ast export query typecheck convert package repl doc test format gen-completions help" -f -a "query" -d 'Prints the metadata attached to an attribute, given as a path'
complete -c nickel -n "__fish_nickel_using_subcommand help; and not __fish_seen_subcommand_from eval pprint-ast export query typecheck convert package repl doc test format gen-completions help" -f -a "typecheck" -d 'Typechecks the program but does not run it'
complete -c nickel -n "__fish_nickel_using_subcommand help; and not __fish_seen_subcommand_from eval pprint-ast export query typecheck convert package repl doc test format gen-completions help" -f -a "convert" -d 'Converts from a plain-data format to Nickel'
complete -c nickel -n "__fish_nickel_using_subcommand help; and not __fish_seen_subcommand_from eval pprint-ast export query typecheck convert package repl doc test format gen-completions help" -f -a "package" -d 'Performs packaging and dependency-resolution operations'
complete -c nickel -n "__fish_nickel_using_subcommand help; and not __fish_seen_subcommand_from eval pprint-ast export query typecheck convert package repl doc test format gen-completions help" -f -a "repl" -d 'Starts a REPL session'
complete -c nickel -n "__fish_nickel_using_subcommand help; and not __fish_seen_subcommand_from eval pprint-ast export query typecheck convert package repl doc test format gen-completions help" -f -a "doc" -d 'Generates the documentation files for the a specified nickel file'
complete -c nickel -n "__fish_nickel_using_subcommand help; and not __fish_seen_subcommand_from eval pprint-ast export query typecheck convert package repl doc test format gen-completions help" -f -a "test" -d 'Tests the documentation examples in the specified nickel file'
complete -c nickel -n "__fish_nickel_using_subcommand help; and not __fish_seen_subcommand_from eval pprint-ast export query typecheck convert package repl doc test format gen-completions help" -f -a "format" -d 'Formats Nickel files'
complete -c nickel -n "__fish_nickel_using_subcommand help; and not __fish_seen_subcommand_from eval pprint-ast export query typecheck convert package repl doc test format gen-completions help" -f -a "gen-completions" -d 'Generate shell completion files'
complete -c nickel -n "__fish_nickel_using_subcommand help; and not __fish_seen_subcommand_from eval pprint-ast export query typecheck convert package repl doc test format gen-completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nickel -n "__fish_nickel_using_subcommand help; and __fish_seen_subcommand_from package" -f -a "lock" -d 'Generate a lock file for a package'
complete -c nickel -n "__fish_nickel_using_subcommand help; and __fish_seen_subcommand_from package" -f -a "debug-resolution" -d 'Make a package map and print it out. For internal debugging'
complete -c nickel -n "__fish_nickel_using_subcommand help; and __fish_seen_subcommand_from package" -f -a "download-deps" -d 'Download all of a package\'s non-local dependencies into the given directory'
complete -c nickel -n "__fish_nickel_using_subcommand help; and __fish_seen_subcommand_from package" -f -a "publish" -d 'Modify a local copy of the index, by adding a new version of a package'
