/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.backward_codecs.KNN10010Codec;

import java.util.Optional;
import lombok.Generated;
import org.apache.lucene.backward_codecs.lucene101.Lucene101Codec;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.knn.index.codec.KNN10010Codec.KNN10010DerivedSourceStoredFieldsFormat;
import org.opensearch.knn.index.codec.KNN80Codec.KNN80CompoundFormat;
import org.opensearch.knn.index.codec.KNN80Codec.KNN80DocValuesFormat;
import org.opensearch.knn.index.codec.KNN9120Codec.KNN9120PerFieldKnnVectorsFormat;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceReadersSupplier;

public class KNN10010Codec
extends FilterCodec {
    private static final String NAME = "KNN10010Codec";
    private static final Codec DEFAULT_DELEGATE = new Lucene101Codec();
    private static final PerFieldKnnVectorsFormat DEFAULT_KNN_VECTOR_FORMAT = new KNN9120PerFieldKnnVectorsFormat(Optional.empty());
    private final PerFieldKnnVectorsFormat perFieldKnnVectorsFormat;
    private final StoredFieldsFormat storedFieldsFormat;
    private final MapperService mapperService;

    public KNN10010Codec() {
        this(DEFAULT_DELEGATE, DEFAULT_KNN_VECTOR_FORMAT, null);
    }

    public KNN10010Codec(Codec delegate, PerFieldKnnVectorsFormat knnVectorsFormat, MapperService mapperService) {
        super(NAME, delegate);
        this.perFieldKnnVectorsFormat = knnVectorsFormat;
        this.mapperService = mapperService;
        this.storedFieldsFormat = this.getStoredFieldsFormat();
    }

    public DocValuesFormat docValuesFormat() {
        return new KNN80DocValuesFormat(this.delegate.docValuesFormat());
    }

    public CompoundFormat compoundFormat() {
        return new KNN80CompoundFormat(this.delegate.compoundFormat());
    }

    public KnnVectorsFormat knnVectorsFormat() {
        return this.perFieldKnnVectorsFormat;
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    private StoredFieldsFormat getStoredFieldsFormat() {
        DerivedSourceReadersSupplier derivedSourceReadersSupplier = new DerivedSourceReadersSupplier(segmentReadState -> {
            if (segmentReadState.fieldInfos.hasVectorValues()) {
                return this.knnVectorsFormat().fieldsReader(segmentReadState);
            }
            return null;
        }, segmentReadState -> {
            if (segmentReadState.fieldInfos.hasDocValues()) {
                return this.docValuesFormat().fieldsProducer(segmentReadState);
            }
            return null;
        });
        return new KNN10010DerivedSourceStoredFieldsFormat(this.delegate.storedFieldsFormat(), derivedSourceReadersSupplier, this.mapperService);
    }

    @Generated
    public static KNN10010CodecBuilder builder() {
        return new KNN10010CodecBuilder();
    }

    @Generated
    public static class KNN10010CodecBuilder {
        @Generated
        private Codec delegate;
        @Generated
        private PerFieldKnnVectorsFormat knnVectorsFormat;
        @Generated
        private MapperService mapperService;

        @Generated
        KNN10010CodecBuilder() {
        }

        @Generated
        public KNN10010CodecBuilder delegate(Codec delegate) {
            this.delegate = delegate;
            return this;
        }

        @Generated
        public KNN10010CodecBuilder knnVectorsFormat(PerFieldKnnVectorsFormat knnVectorsFormat) {
            this.knnVectorsFormat = knnVectorsFormat;
            return this;
        }

        @Generated
        public KNN10010CodecBuilder mapperService(MapperService mapperService) {
            this.mapperService = mapperService;
            return this;
        }

        @Generated
        public KNN10010Codec build() {
            return new KNN10010Codec(this.delegate, this.knnVectorsFormat, this.mapperService);
        }

        @Generated
        public String toString() {
            return "KNN10010Codec.KNN10010CodecBuilder(delegate=" + String.valueOf(this.delegate) + ", knnVectorsFormat=" + String.valueOf(this.knnVectorsFormat) + ", mapperService=" + String.valueOf(this.mapperService) + ")";
        }
    }
}

