/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.memorycontainer.MemoryType;
import org.opensearch.search.builder.SearchSourceBuilder;

public class MLSearchMemoriesInput
implements ToXContentObject,
Writeable {
    private String memoryContainerId;
    private MemoryType memoryType;
    private SearchSourceBuilder searchSourceBuilder;

    public MLSearchMemoriesInput(String memoryContainerId, MemoryType memoryType, SearchSourceBuilder searchSourceBuilder) {
        if (searchSourceBuilder == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        this.memoryContainerId = memoryContainerId;
        this.memoryType = memoryType;
        this.searchSourceBuilder = searchSourceBuilder;
    }

    public MLSearchMemoriesInput(StreamInput in) throws IOException {
        this.memoryContainerId = in.readOptionalString();
        this.memoryType = in.readBoolean() ? (MemoryType)in.readEnum(MemoryType.class) : null;
        this.searchSourceBuilder = new SearchSourceBuilder(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.memoryContainerId);
        out.writeBoolean(this.memoryType != null);
        if (this.memoryType != null) {
            out.writeEnum((Enum)this.memoryType);
        }
        this.searchSourceBuilder.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.memoryContainerId != null) {
            builder.field("memory_container_id", this.memoryContainerId);
        }
        if (this.memoryType != null) {
            builder.field("memory_type", this.memoryType.getValue());
        }
        builder.field("query", (ToXContent)this.searchSourceBuilder);
        builder.endObject();
        return builder;
    }

    @Generated
    public static MLSearchMemoriesInputBuilder builder() {
        return new MLSearchMemoriesInputBuilder();
    }

    @Generated
    public String getMemoryContainerId() {
        return this.memoryContainerId;
    }

    @Generated
    public MemoryType getMemoryType() {
        return this.memoryType;
    }

    @Generated
    public SearchSourceBuilder getSearchSourceBuilder() {
        return this.searchSourceBuilder;
    }

    @Generated
    public void setMemoryContainerId(String memoryContainerId) {
        this.memoryContainerId = memoryContainerId;
    }

    @Generated
    public void setMemoryType(MemoryType memoryType) {
        this.memoryType = memoryType;
    }

    @Generated
    public void setSearchSourceBuilder(SearchSourceBuilder searchSourceBuilder) {
        this.searchSourceBuilder = searchSourceBuilder;
    }

    @Generated
    public static class MLSearchMemoriesInputBuilder {
        @Generated
        private String memoryContainerId;
        @Generated
        private MemoryType memoryType;
        @Generated
        private SearchSourceBuilder searchSourceBuilder;

        @Generated
        MLSearchMemoriesInputBuilder() {
        }

        @Generated
        public MLSearchMemoriesInputBuilder memoryContainerId(String memoryContainerId) {
            this.memoryContainerId = memoryContainerId;
            return this;
        }

        @Generated
        public MLSearchMemoriesInputBuilder memoryType(MemoryType memoryType) {
            this.memoryType = memoryType;
            return this;
        }

        @Generated
        public MLSearchMemoriesInputBuilder searchSourceBuilder(SearchSourceBuilder searchSourceBuilder) {
            this.searchSourceBuilder = searchSourceBuilder;
            return this;
        }

        @Generated
        public MLSearchMemoriesInput build() {
            return new MLSearchMemoriesInput(this.memoryContainerId, this.memoryType, this.searchSourceBuilder);
        }

        @Generated
        public String toString() {
            return "MLSearchMemoriesInput.MLSearchMemoriesInputBuilder(memoryContainerId=" + this.memoryContainerId + ", memoryType=" + String.valueOf((Object)this.memoryType) + ", searchSourceBuilder=" + String.valueOf(this.searchSourceBuilder) + ")";
        }
    }
}

