/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.JsonbException;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Type;
import java.util.OptionalLong;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeDeserializer;

public class OptionalLongTypeDeserializer
extends AbstractValueTypeDeserializer<OptionalLong> {
    public OptionalLongTypeDeserializer(Customization customization) {
        super(OptionalLong.class, customization);
    }

    @Override
    public OptionalLong deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
        JsonParser.Event next = ((JsonbParser)parser).moveToValue();
        if (next == JsonParser.Event.VALUE_NULL) {
            return OptionalLong.empty();
        }
        return this.deserialize(parser.getString(), (Unmarshaller)ctx, rtType);
    }

    @Override
    protected OptionalLong deserialize(String jsonValue, Unmarshaller unmarshaller, Type rtType) {
        try {
            return OptionalLong.of(Long.parseLong(jsonValue));
        }
        catch (NumberFormatException e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.DESERIALIZE_VALUE_ERROR, OptionalLong.class));
        }
    }
}

