/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.indices.ResolveIndexResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class ResolveIndexRequest
extends RequestBase
implements ToCopyableBuilder<Builder, ResolveIndexRequest> {
    @Nonnull
    private final List<ExpandWildcard> expandWildcards;
    @Nonnull
    private final List<String> name;
    public static final Endpoint<ResolveIndexRequest, ResolveIndexResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ResolveIndexRequest, ResolveIndexResponse>(request -> "GET", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_resolve/index/");
        SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.name), buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, ResolveIndexResponse._DESERIALIZER);

    private ResolveIndexRequest(Builder builder) {
        super(builder);
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.name = ApiTypeHelper.unmodifiableRequired(builder.name, (Object)this, "name");
    }

    public static ResolveIndexRequest of(Function<Builder, ObjectBuilder<ResolveIndexRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nonnull
    public final List<String> name() {
        return this.name;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (ApiTypeHelper.isDefined(this.expandWildcards)) {
            params.put("expand_wildcards", this.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.expandWildcards);
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolveIndexRequest other = (ResolveIndexRequest)o;
        return Objects.equals(this.expandWildcards, other.expandWildcards) && this.name.equals(other.name);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ResolveIndexRequest> {
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        private List<String> name;

        public Builder() {
        }

        private Builder(ResolveIndexRequest o) {
            super(o);
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.name = Builder._listCopy(o.name);
        }

        private Builder(Builder o) {
            super(o);
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.name = Builder._listCopy(o.name);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        @Nonnull
        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        @Nonnull
        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        @Override
        @Nonnull
        public ResolveIndexRequest build() {
            this._checkSingleUse();
            return new ResolveIndexRequest(this);
        }
    }
}

