/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityPortion;
import net.sourceforge.plantuml.abel.LineConfigurable;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.klimt.UGroup;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Stencil;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UComment;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Kal;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.svek.image.EntityImageClassHeader;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.LineLocation;

public class EntityImageClass
extends AbstractEntityImage
implements Stencil,
WithPorts {
    private final TextBlock body;
    private final EntityImageClassHeader header;
    private final Url url;
    private final double roundCorner;
    private final LineConfigurable lineConfig;

    public EntityImageClass(Entity entity, PortionShower portionShower) {
        super(entity);
        this.lineConfig = entity;
        this.roundCorner = this.getStyle().value(PName.RoundCorner).asDouble();
        boolean showMethods = portionShower.showPortion(EntityPortion.METHOD, entity);
        boolean showFields = portionShower.showPortion(EntityPortion.FIELD, entity);
        this.body = entity.getBodier().getBody(this.getSkinParam(), showMethods, showFields, entity.getStereotype(), this.getStyle(), null);
        this.header = new EntityImageClassHeader(entity, portionShower);
        this.url = entity.getUrl99();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double paramSameClassWidth;
        double minClassWidth;
        XDimension2D dimHeader = this.header.calculateDimension(stringBounder);
        XDimension2D dimBody = this.body == null ? new XDimension2D(0.0, 0.0) : this.body.calculateDimension(stringBounder);
        double width = Math.max(dimBody.getWidth(), dimHeader.getWidth());
        if (width < (minClassWidth = this.getStyle().value(PName.MinimumWidth).asDouble())) {
            width = minClassWidth;
        }
        if (width < (paramSameClassWidth = this.getSkinParam().getParamSameClassWidth())) {
            width = paramSameClassWidth;
        }
        double height = dimBody.getHeight() + dimHeader.getHeight();
        return new XDimension2D(Math.max(width, this.getKalWidth() * 1.3), height);
    }

    private double getKalWidth() {
        double widthUp = 0.0;
        double widthDown = 0.0;
        for (Kal kal : this.getEntity().getKals(Direction.UP)) {
            widthUp += kal.getDimension().getWidth();
        }
        for (Kal kal : this.getEntity().getKals(Direction.DOWN)) {
            widthDown += kal.getDimension().getWidth();
        }
        return Math.max(widthUp, widthDown);
    }

    @Override
    public XRectangle2D getInnerPosition(CharSequence member, StringBounder stringBounder) {
        XRectangle2D result = this.body.getInnerPosition(member, stringBounder);
        if (result == null) {
            return result;
        }
        XDimension2D dimHeader = this.header.calculateDimension(stringBounder);
        UTranslate translate = UTranslate.dy(dimHeader.getHeight());
        return translate.apply(result);
    }

    @Override
    public final void drawU(UGraphic ug) {
        ug.draw(new UComment("class " + this.getEntity().getName()));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        UGroup group = new UGroup(this.getEntity().getLocation());
        group.put(UGroupType.CLASS, "entity");
        group.put(UGroupType.ID, "entity_" + this.getEntity().getName());
        group.put(UGroupType.DATA_ENTITY, this.getEntity().getName());
        group.put(UGroupType.DATA_UID, this.getEntity().getUid());
        group.put(UGroupType.DATA_QUALIFIED_NAME, this.getEntity().getQuark().getQualifiedName());
        ug.startGroup(group);
        this.drawInternal(ug);
        ug.closeGroup();
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.classDiagram, SName.class_).withTOBECHANGED(this.getEntity().getStereotype()).with(this.getEntity().getStereostyles()).getMergedStyle(this.getEntity().getCurrentStyleBuilder());
    }

    private Style getStyleHeader() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.classDiagram, SName.class_, SName.header).withTOBECHANGED(this.getEntity().getStereotype()).with(this.getEntity().getStereostyles()).getMergedStyle(this.getEntity().getCurrentStyleBuilder());
    }

    private void drawInternal(UGraphic ug) {
        URectangle rect2;
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        XDimension2D dimHeader = this.header.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        LineLocation location = this.getEntity().getLocation();
        URectangle rect = URectangle.build(widthTotal, heightTotal).rounded(this.roundCorner).withCommentAndCodeLine(this.getEntity().getName(), location == null ? null : "" + location);
        double shadow = 0.0;
        HColor borderColor = this.lineConfig.getColors().getColor(ColorType.LINE);
        HColor headerBackcolor = this.getEntity().getColors().getColor(ColorType.HEADER);
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        shadow = this.getStyle().getShadowing();
        if (borderColor == null) {
            borderColor = this.getStyle().value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        if (headerBackcolor == null) {
            HColor hColor = headerBackcolor = backcolor == null ? this.getStyleHeader().value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet()) : backcolor;
        }
        if (backcolor == null) {
            backcolor = this.getStyle().value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        rect.setDeltaShadow(shadow);
        ug = ug.apply(borderColor);
        ug = ug.apply(backcolor.bg());
        UStroke stroke = this.getStyle().getStroke(this.lineConfig.getColors());
        UGraphic ugHeader = ug;
        if (this.roundCorner == 0.0 && headerBackcolor != null && !backcolor.equals(headerBackcolor)) {
            ug.apply(stroke).draw(rect);
            rect2 = URectangle.build(widthTotal, dimHeader.getHeight());
            rect2.setDeltaShadow(0.0);
            ugHeader = ugHeader.apply(headerBackcolor.bg());
            ugHeader.apply(stroke).draw(rect2);
        } else if (this.roundCorner != 0.0 && headerBackcolor != null && !backcolor.equals(headerBackcolor)) {
            ug.apply(stroke).draw(rect);
            rect2 = URectangle.build(widthTotal, dimHeader.getHeight()).rounded(this.roundCorner);
            URectangle rect3 = URectangle.build(widthTotal, this.roundCorner / 2.0);
            rect2.setDeltaShadow(0.0);
            rect3.setDeltaShadow(0.0);
            ugHeader = ugHeader.apply(headerBackcolor.bg()).apply(headerBackcolor);
            ugHeader.apply(stroke).draw(rect2);
            ugHeader.apply(stroke).apply(UTranslate.dy(dimHeader.getHeight() - rect3.getHeight())).draw(rect3);
            rect.setDeltaShadow(0.0);
            ug.apply(stroke).apply(HColors.none().bg()).draw(rect);
        } else {
            ug.apply(stroke).draw(rect);
        }
        this.header.drawU(ugHeader, dimTotal.getWidth(), dimHeader.getHeight());
        if (this.body != null) {
            UGraphic ug2 = UGraphicStencil.create(ug, this, stroke);
            UTranslate translate = UTranslate.dy(dimHeader.getHeight());
            this.body.drawU(ug2.apply(translate));
        }
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        XDimension2D dimHeader = this.header.calculateDimension(stringBounder);
        if (this.body instanceof WithPorts) {
            return ((WithPorts)((Object)this.body)).getPorts(stringBounder).translateY(dimHeader.getHeight());
        }
        return new Ports();
    }

    @Override
    public ShapeType getShapeType() {
        if (this.getEntity().getPortShortNames().size() > 0) {
            return ShapeType.RECTANGLE_HTML_FOR_PORTS;
        }
        return ShapeType.RECTANGLE;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return this.getEntity().getMargins();
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

