/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Set;
import org.apache.sis.image.ComputedImage;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Disposable;

abstract class SourceAlignedImage
extends ComputedImage {
    static final Set<String> POSITIONAL_PROPERTIES = JDK9.setOf("org.apache.sis.GridGeometry", "org.apache.sis.PositionalAccuracy", "org.apache.sis.PositionalConsistency");
    private final ColorModel colorModel;

    protected SourceAlignedImage(RenderedImage renderedImage) {
        super(SourceAlignedImage.getSampleModel(renderedImage), renderedImage);
        this.colorModel = renderedImage.getColorModel();
    }

    private static SampleModel getSampleModel(RenderedImage renderedImage) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = renderedImage.getTileWidth();
        int n2 = renderedImage.getTileHeight();
        if (sampleModel.getWidth() == n && sampleModel.getHeight() == n2) {
            return sampleModel;
        }
        return sampleModel.createCompatibleSampleModel(n, n2);
    }

    SourceAlignedImage(RenderedImage renderedImage, ColorModel colorModel, SampleModel sampleModel) {
        super(sampleModel, renderedImage);
        this.colorModel = colorModel;
        assert (renderedImage.getSampleModel().getWidth() == sampleModel.getWidth() && renderedImage.getSampleModel().getHeight() == sampleModel.getHeight());
    }

    protected SourceAlignedImage(RenderedImage renderedImage, ColorModel colorModel) {
        super(SourceAlignedImage.createSampleModel(colorModel, renderedImage.getSampleModel()), renderedImage);
        this.colorModel = colorModel;
    }

    private static SampleModel createSampleModel(ColorModel colorModel, SampleModel sampleModel) {
        SampleModel sampleModel2 = colorModel.createCompatibleSampleModel(sampleModel.getWidth(), sampleModel.getHeight());
        return sampleModel.equals(sampleModel2) ? sampleModel : sampleModel2;
    }

    @Override
    public final ColorModel getColorModel() {
        return this.colorModel;
    }

    static String[] filterPropertyNames(String[] stringArray, Set<String> set, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2 != null ? (String[])stringArray2.clone() : null;
        }
        int n = 0;
        for (String string : stringArray) {
            if (!set.contains(string)) continue;
            stringArray[n++] = string;
        }
        if (stringArray2 == null) {
            return ArraysExt.resize(stringArray, n);
        }
        stringArray = ArraysExt.resize(stringArray, n + stringArray2.length);
        System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
        return stringArray;
    }

    @Override
    public final int getMinX() {
        return this.getSource().getMinX();
    }

    @Override
    public final int getMinY() {
        return this.getSource().getMinY();
    }

    @Override
    public final int getWidth() {
        return this.getSource().getWidth();
    }

    @Override
    public final int getHeight() {
        return this.getSource().getHeight();
    }

    @Override
    public final int getMinTileX() {
        return this.getSource().getMinTileX();
    }

    @Override
    public final int getMinTileY() {
        return this.getSource().getMinTileY();
    }

    @Override
    public final int getNumXTiles() {
        return this.getSource().getNumXTiles();
    }

    @Override
    public final int getNumYTiles() {
        return this.getSource().getNumYTiles();
    }

    @Override
    public final int getTileWidth() {
        return this.getSource().getTileWidth();
    }

    @Override
    public final int getTileHeight() {
        return this.getSource().getTileHeight();
    }

    @Override
    public final int getTileGridXOffset() {
        return this.getSource().getTileGridXOffset();
    }

    @Override
    public final int getTileGridYOffset() {
        return this.getSource().getTileGridYOffset();
    }

    @Override
    protected Disposable prefetch(Rectangle rectangle) {
        RenderedImage renderedImage = this.getSource();
        if (renderedImage instanceof PlanarImage) {
            return ((PlanarImage)renderedImage).prefetch(rectangle);
        }
        return super.prefetch(rectangle);
    }
}

