/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.rules.ImmutableFilterWindowTransposeRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.immutables.value.Value;

@Value.Enclosing
public class FilterWindowTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected FilterWindowTransposeRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filterRel = (Filter)call.rel(0);
        Window windowRel = (Window)call.rel(1);
        ImmutableList<Window.Group> windowGroups = windowRel.groups;
        if (windowGroups.size() != 1) {
            return;
        }
        List<RexNode> conditions = RelOptUtil.conjunctions(filterRel.getCondition());
        ArrayList<RexNode> pushedConditions = new ArrayList<RexNode>();
        ArrayList<RexNode> remainingConditions = new ArrayList<RexNode>();
        Window.Group group = (Window.Group)windowGroups.get(0);
        ImmutableBitSet partitionKeys = group.keys;
        for (RexNode condition : conditions) {
            ImmutableBitSet rCols = RelOptUtil.InputFinder.bits(condition);
            if (partitionKeys.contains(rCols)) {
                pushedConditions.add(condition);
                continue;
            }
            remainingConditions.add(condition);
        }
        RelBuilder builder = call.builder();
        RelNode rel = builder.push(windowRel.getInput()).filter(pushedConditions).build();
        if (rel == windowRel.getInput(0)) {
            return;
        }
        rel = windowRel.copy(windowRel.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)rel));
        rel = builder.push(rel).filter(remainingConditions).build();
        call.transformTo(rel);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableFilterWindowTransposeRule.Config.of().withOperandSupplier(b0 -> b0.operand(Filter.class).oneInput(b1 -> b1.operand(Window.class).anyInputs()));

        @Override
        default public FilterWindowTransposeRule toRule() {
            return new FilterWindowTransposeRule(this);
        }
    }
}

