/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.api.model.ZooKeeperListChildrenResponse;
import org.apache.solr.client.solrj.InputStreamResponse;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class ZookeeperReadApi {

    public static class ReadNode
    extends SolrRequest<ReadNodeResponse> {
        private final String zkPath;

        public ReadNode(String zkPath) {
            super(SolrRequest.METHOD.valueOf("GET"), "/cluster/zookeeper/data{zkPath}".replace("{zkPath}", zkPath));
            this.zkPath = zkPath;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected ReadNodeResponse createResponse(SolrClient client) {
            return new ReadNodeResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ReadNodeResponse
    extends InputStreamResponse {
    }

    public static class ListNodes
    extends SolrRequest<ListNodesResponse> {
        private final String zkPath;
        private Boolean children;

        public ListNodes(String zkPath) {
            super(SolrRequest.METHOD.valueOf("GET"), "/cluster/zookeeper/children{zkPath}".replace("{zkPath}", zkPath));
            this.zkPath = zkPath;
        }

        public void setChildren(Boolean children) {
            this.children = children;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.children != null) {
                params.add("children", this.children.toString());
            }
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            queryParams.add("children");
            return queryParams;
        }

        @Override
        protected ListNodesResponse createResponse(SolrClient client) {
            return new ListNodesResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ListNodesResponse
    extends JacksonParsingResponse<ZooKeeperListChildrenResponse> {
        public ListNodesResponse() {
            super(ZooKeeperListChildrenResponse.class);
        }
    }
}

