/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util;

import java.util.List;
import org.apache.solr.analytics.util.OrdinalCalculator;

public class MedianCalculator {
    public static <T extends Number> double getMedian(List<T> list) {
        int size = list.size() - 1;
        if (size == -1) {
            return 0.0;
        }
        MedianCalculator.select(list, 0.5 * (double)size, 0, size);
        int firstIdx = (int)Math.floor(0.5 * (double)size);
        int secondIdx = firstIdx <= size && size % 2 == 1 ? firstIdx + 1 : firstIdx;
        double result = ((Number)list.get(firstIdx)).doubleValue() * 0.5 + ((Number)list.get(secondIdx)).doubleValue() * 0.5;
        return result;
    }

    private static <T extends Comparable<T>> void select(List<T> list, double place, int begin, int end) {
        Object split = end - begin < 10 ? (Comparable)list.get((int)(Math.random() * (double)(end - begin + 1)) + begin) : MedianCalculator.split(list, begin, end);
        OrdinalCalculator.Point result = MedianCalculator.partition(list, begin, end, split);
        if (place < (double)result.low) {
            MedianCalculator.select(list, place, begin, result.low);
        } else if (place > (double)result.high) {
            MedianCalculator.select(list, place, result.high, end);
        } else {
            if (result.low == (int)Math.floor(place) && result.low > begin) {
                MedianCalculator.select(list, result.low, begin, result.low);
            }
            if (result.high == (int)Math.ceil(place) && result.high < end) {
                MedianCalculator.select(list, result.high, result.high, end);
            }
        }
    }

    private static <T extends Comparable<T>> T split(List<T> list, int begin, int end) {
        int num = end - begin + 1;
        int recursiveSize = (int)Math.sqrt(num);
        int step = num / recursiveSize;
        for (int i = 1; i < recursiveSize; ++i) {
            int swapFrom = i * step + begin;
            int swapTo = i + begin;
            Comparable temp = (Comparable)list.get(swapFrom);
            list.set(swapFrom, (Comparable)list.get(swapTo));
            list.set(swapTo, temp);
        }
        MedianCalculator.select(list, --recursiveSize / 2 + begin, begin, recursiveSize + begin);
        return (T)((Comparable)list.get(recursiveSize / 2 + begin));
    }

    private static <T extends Comparable<T>> OrdinalCalculator.Point partition(List<T> list, int begin, int end, T indexElement) {
        Comparable temp;
        int right;
        int left = begin;
        for (right = end; left < right; ++left, --right) {
            while (((Comparable)list.get(left)).compareTo(indexElement) < 0) {
                ++left;
            }
            while (right != begin - 1 && ((Comparable)list.get(right)).compareTo(indexElement) >= 0) {
                --right;
            }
            if (right <= left) {
                --left;
                ++right;
                break;
            }
            temp = (Comparable)list.get(left);
            list.set(left, (Comparable)list.get(right));
            list.set(right, temp);
        }
        while (left != begin - 1 && ((Comparable)list.get(left)).compareTo(indexElement) >= 0) {
            --left;
        }
        while (right != end + 1 && ((Comparable)list.get(right)).compareTo(indexElement) <= 0) {
            ++right;
        }
        for (int rightMove = right + 1; rightMove < end + 1; ++rightMove) {
            if (!((Comparable)list.get(rightMove)).equals(indexElement)) continue;
            temp = (Comparable)list.get(rightMove);
            list.set(rightMove, (Comparable)list.get(right));
            list.set(right, temp);
            while (((Comparable)list.get(++right)).equals(indexElement)) {
            }
            if (rightMove > right) continue;
            rightMove = right;
        }
        return new OrdinalCalculator.Point(left, right);
    }
}

