/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.clustering.PathResourceLookup;
import org.carrot2.clustering.ClusteringAlgorithm;
import org.carrot2.clustering.ClusteringAlgorithmProvider;
import org.carrot2.clustering.kmeans.BisectingKMeansClusteringAlgorithm;
import org.carrot2.clustering.lingo.LingoClusteringAlgorithm;
import org.carrot2.clustering.stc.STCClusteringAlgorithm;
import org.carrot2.language.LanguageComponents;
import org.carrot2.language.LanguageComponentsLoader;
import org.carrot2.language.LoadedLanguages;
import org.carrot2.util.ChainedResourceLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EngineContext {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final LinkedHashMap<String, LanguageComponents> languages;
    private final Map<String, ClusteringAlgorithmProvider> algorithmProviders;
    private static final Map<String, String> aliasedNames = new HashMap<String, String>();

    EngineContext(String resourcesPath, SolrCore core) {
        LanguageComponentsLoader loader = LanguageComponents.loader();
        ArrayList<Path> resourceLocations = new ArrayList<Path>();
        Path configDir = core.getResourceLoader().getConfigPath();
        if (resourcesPath != null && !resourcesPath.trim().isEmpty()) {
            configDir = configDir.resolve(resourcesPath);
            resourceLocations.add(configDir);
        }
        if (!resourceLocations.isEmpty()) {
            log.info("Clustering algorithm resources first looked up relative to: {}", resourceLocations);
            loader.withResourceLookup(provider -> new ChainedResourceLookup(Arrays.asList(new PathResourceLookup(resourceLocations), provider.defaultResourceLookup())));
        } else {
            log.info("Resources read from defaults (JARs).");
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.algorithmProviders = ServiceLoader.load(ClusteringAlgorithmProvider.class, classLoader).stream().map(ServiceLoader.Provider::get).collect(Collectors.toMap(ClusteringAlgorithmProvider::name, e -> e));
        loader.limitToAlgorithms((ClusteringAlgorithm[])this.algorithmProviders.values().stream().map(Supplier::get).toArray(ClusteringAlgorithm[]::new));
        this.languages = new LinkedHashMap();
        try {
            LoadedLanguages loadedLanguages = loader.load();
            for (String lang : loadedLanguages.languages()) {
                this.languages.put(lang, loadedLanguages.language(lang));
            }
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
        for (String lang : this.languages.keySet()) {
            if (!log.isTraceEnabled()) continue;
            log.trace("Loaded language '{}' with components:\n  - {}", (Object)lang, (Object)this.languages.get(lang).components().stream().map(Class::getSimpleName).collect(Collectors.joining("\n  - ")));
        }
        this.algorithmProviders.entrySet().removeIf(e -> !this.isAlgorithmAvailable((ClusteringAlgorithmProvider)e.getValue(), this.languages.values()));
        this.algorithmProviders.forEach((name, prov) -> {
            String supportedLanguages = this.languages.values().stream().filter(lc -> ((ClusteringAlgorithm)prov.get()).supports(lc)).map(LanguageComponents::language).collect(Collectors.joining(", "));
            log.info("Clustering algorithm {} loaded with support for the following languages: {}", name, (Object)supportedLanguages);
        });
    }

    ClusteringAlgorithm getAlgorithm(String algorithmName) {
        ClusteringAlgorithmProvider provider;
        if (!this.algorithmProviders.containsKey(algorithmName) && aliasedNames.containsKey(algorithmName)) {
            algorithmName = aliasedNames.get(algorithmName);
        }
        return (provider = this.algorithmProviders.get(algorithmName)) == null ? null : (ClusteringAlgorithm)provider.get();
    }

    LanguageComponents getLanguage(String language) {
        return this.languages.get(language);
    }

    boolean isLanguageSupported(String language) {
        return this.languages.containsKey(language);
    }

    private boolean isAlgorithmAvailable(ClusteringAlgorithmProvider provider, Collection<LanguageComponents> languages) {
        ClusteringAlgorithm algorithm = (ClusteringAlgorithm)provider.get();
        Optional<LanguageComponents> first = languages.stream().filter(arg_0 -> ((ClusteringAlgorithm)algorithm).supports(arg_0)).findFirst();
        if (first.isEmpty()) {
            log.warn("Algorithm does not support any of the available languages: {}", (Object)provider.name());
            return false;
        }
        return true;
    }

    static {
        aliasedNames.put(LingoClusteringAlgorithm.class.getName(), "Lingo");
        aliasedNames.put(STCClusteringAlgorithm.class.getName(), "STC");
        aliasedNames.put(BisectingKMeansClusteringAlgorithm.class.getName(), "Bisecting K-Means");
    }
}

