use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestUtil;
use Apache::TestRequest;

plan tests => 1, need_apache(2);

my $rc;

$rc = GET_RC "/security/CAN-2004-0747/";

# This test used to check for SegFaults when expanding variables
# inside a .htaccess file. 
# Only, the code trying to parse the generated AuthName will 
# fail with a 500 when the string exceeds a certain length (at least on OS X)
#
# So, in case of a 500 return, we check for a proper body and assume
# that the failure was graceful and not a crash.
#
# The alternative would be to expand a env var under our control in .htacess
# for this test, so that the outcome is not depending on the env of the person
# starting the test.
#
if ($rc == 500) {
    my $body = GET_BODY "/security/CAN-2004-0747/";
    if (length $body > 0) {
        $rc = 200;
    }
}

ok t_cmp($rc, 200, "CAN-2004-0747 ap_resolve_env test case");

