// Copyright John Maddock 2019.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<T, 4>, 2560> hypergeometric_1F1 = {{
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.1192211540270692135684850769467754943864e+07) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.5143811314216628861217890131957547270332e+07) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.8490645992100905657010395716213517079320e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.2584998744350866041098736430457431758187e+08) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(8.6000347009421229528205145741103121287486e+08) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.9310911983866698694771550134279429856052e+10) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.6330059700153438121714438258323563534913e+10) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.2537006694081032175908514583194485875714e+11) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.6237309362366581930053548040412248168521e+08) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(9.9626220234068125064350589227213124310459e+07) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.3200784547211743132061867908668953518000e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(6.0959134328264263700796956004993971891222e+08) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.6540578259446250549219669834573986864094e+09) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.0170925241529790410295616043598253646110e+10) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.5155993297162409281822542019370194297033e+10) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.9360683328099093749507850506373936413405e+11) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-9.7525833709353354966279157903896435385931e+15) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-6.2825210881714224212672547825813138849727e+15) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-3.8757505732987639831380304268522524550201e+13) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.4497155514636404513968826200000866632580e+11) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-5.8263811346507854556425569414825426998446e+12) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.5535497967956674593905372806396195361000e+15) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.4531729513823375531857961435127834737997e+15) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-4.8449036469827200268157658927345360703885e+16) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.2023016806095826062560744356589208962321e+07) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(9.5117908330406493968101436984219340382937e+06) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.3805493458724361725255413925649780149519e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.8625136572679071818542020295525974734853e-06) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-4.0742388232269332201527679924750480985781e-06) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0401820915092759295927802900824189286969e-05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.2171854266988646271515043865783488146673e-06) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.2273907467953269510681662585494726655634e-05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(7.1662899752201558926692508855790084872754e+06) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.6930811346973633228760609012281444374845e+06) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.6392501669169102298863828043571358947474e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.1505542162847578119830769451665124064327e-06) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(8.9753772535784104155251163229589487376403e-08) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.8693544100889813009208758683031529490469e-06) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.4392694539110955728991171086048010844426e-06) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.9471039344612588380101299129118206752508e-05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.4926608456056184648659183467188639954264e+06) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.2019789969070818410907631377317029885175e+06) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.1481295077183033833177281867723829306898e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-3.9163769347312715966829685000237278929992e-07) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-6.7590218595561886672742019750656682985281e-08) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-7.1408528842372123431928924769184198810448e-07) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-7.6215693462067825051980362257113338664859e-07) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.4844480302368899715476035090290400119866e-06) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.2854301294129886596311808819952551214732e+06) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0365225308704905309719589243773442996394e+06) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.0060350390412309332950846748626577512966e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-3.1485939034768644279791008360361077831082e-07) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.7164957529742235623423273478714423059286e-07) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-5.1028323267342914664951259167278678269296e-07) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-6.4019735175162124788647358321468454636222e-07) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.2802251093504580453605415737875243656637e-06) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.7104821806071019992487684423413509304853e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.8348835076786326524031386558176679447254e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.1604346995176880631794867005437030555275e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.2965673305571878905870761760703623815521e-07) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.6553618880551293287494063503819233150616e-08) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.5375650529395339361787482673030204597162e-07) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.2822278109194918164561508739604945158065e-07) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.6982551900173876604516723369325915904586e-07) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-2.9452809596717724207398724786174054887877e+06) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.8229826489392204553842760246212686280971e+06) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-6.6182283169750171462160899047454582446240e+03) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(7.5774631385183861776353501646017592085097e+07) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.8395965501955442821096835251470499186607e+08) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.1839566292769797162382632596363353049519e+09) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.2330863844185163642645456375816154590615e+09) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.0536615279056920437855666155795885379621e+10) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-9.8009339159280899993413360224354080795338e+06) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-6.0976137910342046007766357816218341046596e+06) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-2.3631200634362800551107359700955046163037e+04) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.2802919681494471714269321326575233498436e+08) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.1774864911142072767355446652829725831396e+08) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.8601253792627464224997113136896321721099e+09) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.8359294057455343437796824579754397444974e+09) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.8658635148472312209044057499772721567026e+10) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-4.3586411509770246230978089700093157224575e+14) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-2.8463797860629375547743874293954240169425e+14) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-2.0388142864988200221044782994377870518100e+12) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.4650065177960903139374412511924419790877e+12) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.1130729434134535333239853084103386867630e+12) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.7612661492217779211128550146263200856774e+14) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.5300075526495566791989322023970263027431e+14) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.3470247577664677883729994598003872186392e+15) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(5.8761663401954067168242331555380871476337e+06) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.6956667658206467212268000934205150407066e+06) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.0636019253161351996374880428881411146154e+05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.4972534142401805240390436361482452667050e-06) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.6486270771287248606871059300797618862919e-07) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.9979752741288838270704861477818133715720e-05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.3559394286058792205767630160143104081568e-05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-6.9205594549173656047968690883283882523978e-05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.5670276750032367492901569475339235598535e+06) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.8619281596746572837843666095393896853455e+06) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.5971811919646978552133040909763862873020e+05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.1179236881163269901798148855992366474699e-06) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.1325659689403100124247836705401751524697e-06) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.4346438587391186580279540178402220316755e-06) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(8.0357619537927900700165581014970234297973e-06) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-2.1751736899273638814788811600567102120300e-05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(7.8683322155002958760714683811733118272610e+05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(6.3963344751067049529420370268669974774240e+05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(6.7700337948042445018502930783032846306475e+04) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-3.6486619693064874382715567275055210318976e-07) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-5.4618754752408859736964403081815745122683e-07) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-3.7675175309942393003773858400624966272681e-07) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-8.5861486564260291147387990809236845044720e-07) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.8933984226788012375211950342194461294390e-06) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.8141334813428726523826428010952338557750e+05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.5466941104017289430528568443414592527169e+05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.9622177421665981496850605486421485561066e+04) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.6844167520702006295112894756877728583425e-07) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-5.2616999634306233650879848737049011077054e-07) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-2.2047988418679136359790622154139539963088e-08) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-4.4871778092665597728276441970692591746787e-07) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.0350551023751670626261195950766216288741e-06) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.5949093634715815763741056099125114604553e+05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.1318836685397488159546723808366667559164e+05) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.5519655453877603309241386034567340985426e+04) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.8888942137718296963614069264261330394734e-07) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.2244802666220815040292278231396636346880e-07) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.7514699028579292819772569605966692262678e-07) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.4418902953517629429472541484977544186233e-07) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-4.0880981684161990994429032531090059058332e-07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.8257841648142657812278361742183534983370e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.7741492543064406033476407277815236276810e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.5200661215677202647984225752711181929690e+02) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.9859197642491409364009225967381996125027e+07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.4765887775697998039998522317336921972376e+07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.1342860506572890428473874666074974029002e+08) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.9712775341962157511168534886755798674357e+08) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.9198025556533382730125471707497709842340e+09) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(8.2577474968326384211072611297681087709461e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.2112505998525569920907573777858750336085e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.3578583942320311439258053291118624064467e+03) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.1147305229020443550140777818488475574320e+07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(7.1494745010363881869669301962633110935717e+07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0327663549283752189472280995551232327186e+09) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.3485261147770946885794366082718557500735e+09) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(8.5876921052008442863282343067513516644968e+09) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.1225262345599745142576922320540350054854e+13) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-7.4338333192720099904854199700724416165193e+12) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-6.2059670100072198010676558326633089602488e+10) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-3.4300488791329192881722031922437332443379e+11) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.0883487117007457374821520317072492090744e+12) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-3.6785263058016205408864282961218318263278e+13) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-5.1614511015935458537412092574801422172926e+13) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-5.1453952693184975047308446070429888933118e+14) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.8491834536259972259826744661138822584545e+06) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.3000386676701426180995625942673806814249e+06) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.2231403107027976345032355761826203133840e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.4597317525077368441765799810915442443097e-06) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(8.5428355375386202989809268088684130618426e-06) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.9394945508373700883618055251629863319852e-06) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.9125432957923372400921597692662831541930e-05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-4.6095352305500889587335426362671563886474e-05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.7623374256493574349147498166748871419759e+06) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.4282215068485625736170494425991627897860e+06) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.4453954992119946180843000390217735519000e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-7.5579892531634224096922242831754677612814e-07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.9757556025634247974200089142063130100626e-06) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-9.5021442051100740096738819209784584250056e-06) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-4.7231873297682698611522631770409960187024e-06) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.6496604283861381227984681767349373463187e-05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.1231027267994143608648241137581776997898e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.3840237927220525804622957824276523467521e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.9735738526697870156836271812925330252365e+04) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.7971487650479192980195539088239471320710e-07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-8.6765093221827747253751651069944461951464e-07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0365741757628074987939882748802858803780e-06) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.1576624209679051779914244730673682094818e-07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-9.1151130485496347059774665059468714192873e-07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.5913010668724186274002512048356159544175e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.9513182858003014050073017476301093475422e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.5175752945733690532481441750521215139161e+04) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.9232023097860857815888257844142992151394e-07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-6.0128495072749081342389700570650109440295e-07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.1411994246005726267274620716895158886661e-06) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.7372545104386771296084918238801961981300e-07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.5735439947052268864033121028130462970025e-06) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.4224631856046996734201381805942848739109e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.1794498073167900387168058405469951169085e+05) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.5594627553376091545606020142409833658322e+04) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(8.5516840553936931043215120545305250317851e-08) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.1934616263573510948663298123320005365759e-07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-7.1046696015397119333402522142678867819787e-08) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0684065264800127287282631441870488864627e-07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.9457857864940653547581910624535747872051e-07) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-3.4540349424480073021746526193014612585849e+04) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-2.2006020443517389775662111449111015448513e+04) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-1.0936658747138797653579943185572347465546e+02) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.6892547414202597865885191033844772289410e+06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.1989356483022323843488689028607309180599e+07) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.3270631459841032747232699509998683632148e+08) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.6885810649883651652669914074952656530609e+08) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(9.0219039128932840588717788313876934671813e+08) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-9.0784979929628294355660408290962012652207e+04) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-5.8136642347178169063154704990155012997476e+04) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-3.0839949957364856126304378377973952054670e+02) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(8.4163832747452254519067915136705839801925e+06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.8007823439453675655924015828328672738919e+07) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.0840551589375472270186460702584353719138e+08) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.6626924487518826433651753697441556717656e+08) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.4612769291933544630986878052339748115508e+09) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-6.2085681832370087016034142690334866690683e+10) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-4.1710086323774569275688956271749294370973e+10) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-4.0750354326038799995397485647608030482648e+08) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0015093884716726485254682031328574960157e+10) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.7207482071558087819169290984882810315240e+10) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.0706141063940707737063884356839553014674e+11) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(8.2144731722017466910817014589221743234673e+11) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(6.4868231765874721037126082163600017370867e+12) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.3701378239121034582435053028834765982701e+06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.1175063984903217400562871429303616311506e+06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.2082473090697816239532269158165109716490e+05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.2540725583975718857911812619164815293318e-06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.2785396086461099533881557435325498772558e-05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-3.4787651024430074088656607340425842744369e-05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.5097845490177937598565409225054693299964e-05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(9.7315444620970583401928100895835274736728e-05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(8.6402592633006592633774813114551132086654e+05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.0736685496681689170488362209243283074663e+05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.9948818768147791905660165783037631109610e+04) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-5.7814028403949715409327969521882888927361e-06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.4686900725093585939793838305387512656763e-06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.9748077572522375340806626468383065857275e-05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.3052428571455646515674262279497398691886e-05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(6.3080122135011920196211362669107871340529e-05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.1473579878252690901286557038063143594824e+05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.7796075540175692207149893118099633296274e+05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.3211419306985713616506895990361397022836e+04) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.2095377064572056231856241908590321151115e-06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-3.3206968404428861086242243292090534876013e-07) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.4921390164617062890205761863237428004922e-06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.6500690366530072443433304711396042479076e-06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-5.6109941296098748940194438636336606622138e-06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.8814549309938022242159662709633196168920e+05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.5611611617856188318486275265136203481165e+05) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.0656733503749668964157427581720297985621e+04) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.1770003875069458310028187887721744527993e-06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.1536699985556564056754964047266560252240e-07) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.8491328986642307696482321469031839724234e-06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.2590885373272489849556249529055310508183e-06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-4.4975430164309374276498198947671820961063e-06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(7.7582105653563499214913376406082260119700e+04) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(6.4929362476957444314834076687637688043158e+04) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(9.4928262645691294870953282065119055700661e+03) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.9903452591341362244069480960961390548813e-07) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.4849186247696705190375120120508407115574e-07) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-5.7388055434572238183664155395352786222708e-07) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-4.4145889801974215555826686417078203997946e-07) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.5994686355195098371245553642890648505255e-07) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(5.2025435054144614538830082983307738044008e+03) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.3649368616452678493914384283240119806594e+03) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.9698388581859841530795401442596171054821e+01) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.7481983262168274869094632511786502160468e+06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.4623402359944975543393905418269511532132e+06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.1446003461206327255349743491864504801307e+07) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.9236833255155534712179047822758102941204e+07) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.8320784490485879741327885599034369540554e+08) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.2497040766709958549262332341511181060905e+04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.1242045346444066614090687283549473317189e+03) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.0760994857281426553563860371177514846308e+01) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.4648674514466011320396289814829793343726e+06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.9450802278695113277063174861835170254334e+06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.6654754623247240432221119964449782809790e+07) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.8419027787458759865448586004376383862506e+07) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.7915105881826372297632031402759539759054e+08) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0018093845792270206742358792690952646579e+09) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(6.8303029887657973798033736907630434488348e+08) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.8443629291464727035807667233273023387660e+06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(6.2368741448962903754726163371432012078538e+08) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.5098561004595522540522886372547969239405e+09) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.4179536877606438649114886338472968023495e+10) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.1738895437033954521860580887251034143434e+10) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.0519844023319758816950252571008570187597e+11) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.5326442368545320781182312439915787478174e+05) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.3840339761049222722826379178007233651206e+05) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(6.5218623202728991187369137313489426917825e+04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.5197886779107446103568148643598613772014e-05) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.5842329192332721382828390048399726218797e-06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-5.2212476050266728486847988710471782948005e-05) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-6.9621068843445894158480190585736500017493e-05) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.8530508033236341502905851904680216790220e-04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.2023959229361936103698647616498894023474e+05) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.4760483977408706007308886507797755194187e+05) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.3942395848898829540132495801907820922325e+04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-8.1866331465748705326983239957197258025854e-06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-8.5004754691324636534027768179513037289246e-06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-4.3975262467333984245892392433505374326843e-06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.8210005203138893870940796867210592602622e-05) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.5560933575660611601219693021089001592538e-05) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.1113170367501200052905555370812035986576e+05) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(9.3007910591438146996561994710583053095072e+04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.3492370808570001290064798761521024164416e+04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.9228905424061505740236072200684158618232e-06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.4940859472993082104437648884640421083714e-06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.2733629318684920571133832825158190689377e-06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.9291805559102955711372825210086326151022e-06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-4.6608066958633895987536721079672811635584e-06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.7961215152310703308042828958952541272078e+04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.2082123400099247200640786486176378789468e+04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.2072613990511017595143930801468506263732e+04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.3633086687852375709377654954183531473453e-06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.6957179188205449396037559564611638070437e-06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.8802300939044385637712877546145309266313e-08) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.5169564319706378165691835531675338748114e-06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.7640378991046170651716494167223155554696e-06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.2094021824552144505737132983437244848312e+04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.5562039693574263236778750787733392858282e+04) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.7555987642494381528954082381610765303944e+03) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-8.7706613914087133908571117884514938091174e-07) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.2353249017280124129114289593746700182527e-07) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-8.1293031424641029556541376153250752858325e-07) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.0383303642422207215637097791761560066087e-06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.6172728691304152179980728889412336859825e-06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-9.4381184711342177628798863780454875578316e+02) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-6.2000128984212248765299925150193474495237e+02) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-4.2967505112066063254559996133966734160824e+00) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.6889226244118609524747760231363917555728e+05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0633418723193983807025002260936787202273e+06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.0258963892654661514207266123262930068545e+06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(9.8319243949360126325579066503671429320167e+06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.0436477847941563449374434656251716721249e+07) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-2.0956758434501312288951033756752805275582e+03) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.3836756100737046935832717344196825803729e+03) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-1.0234125674999783359828022381164945544050e+01) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(7.7008369658935307575864766160777636658131e+05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.4553836123296376161402643333649897891073e+06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.1350456156043184751193798865517750742786e+07) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.3946973248095424976723111609905804726928e+07) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.8521165447601268672373081257491599754902e+07) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-3.9505971051897983341666461891469277093900e+07) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-2.7347014745086898693682726054983080938551e+07) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-3.7099125816924110445097051532329391194825e+05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(7.5397039254984680449441125001186995264282e+07) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.6602283168373298179343503515247374838011e+08) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.0042402104792768111569876172123373096093e+09) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.5617972580970776749746038546027269515134e+09) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.3868410716568848619809637710963220913650e+10) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.0870869282829718124221377496517408006060e+05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.5713743284026633932101208114808891217930e+05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.4954315107921479303096670835997390064219e+04) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.9502490195968296852891676726917421449135e-05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.5490351363484765516095800687479734956431e-05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.5734673556302743084517155602698427812690e-05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.2792855178187340391259838941445776096921e-05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-5.7276551005441257650353910321782967037032e-05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.0270713739703805269109139069593912111285e+05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.6943017961253953242768056461008475160891e+05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.3993918253760472162806470730256373195459e+04) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-7.3087398614034500231884074742870004227776e-07) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.6755063987899785645191549259912741310867e-05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.9160045801176670490736297328778027539682e-05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.0353749071765553308846376961282066762742e-05) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.1901640925683169577674828114681696787824e-04) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(5.7139209117981181129785662473307721209532e+04) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.8298295615592481709702597272040249898678e+04) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.8032173216871256333861190985396999970420e+03) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(6.9587030578566936117880587276895055342705e-07) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.5964804785515864552255466468273406964965e-06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-4.3836499629694540316594983254911422765239e-06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.4212410719699099275820312336101850810987e-06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(8.6618076339662648383667565669733085818548e-06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(5.0681062854862539804908743185180270443377e+04) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.2887758150286418240625746943940850343992e+04) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.0209816115598746328810248747530703820279e+03) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-3.0690312875398495309151590628113604097263e-07) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.8854649548091651805596979146698633129236e-06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-4.6261336730942162752939969181821931371157e-06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-3.5109645793444171049257451366925504993704e-06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(9.3423378353562697421696721342726176898819e-06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.2717001908918047715311319756629581852883e+04) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.9375414843973387109619317644059275604587e+04) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.4754562569944950263289870428140389158922e+03) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.0912567529426287972641412969700701955790e-06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.2185733860022389327185183654727189290343e-06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.7711221751045675869269204503954521814573e-07) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-5.3854999618206586377030165314554726281423e-07) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.9056087926329057711789911343850242323716e-07) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.0289612144897827820252307394329507724970e+02) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.3543968491797837102686015707438034598570e+02) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.1173383320005108965397089861841017595450e+00) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.9427238391991146950735502540032165064097e+05) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.4388969815333665725429674661620748937550e+05) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.1799922624787108381989080611544376766625e+06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.6245288157609160119099607055801543607913e+06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(9.5709421268624890167617467138212657284850e+06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.1998899945553526952702789460428588061960e+02) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.8177521225267907281504284824838392005622e+02) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.4807455032726299158212947395290057822675e+00) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.5384524807240306791758303389082280038670e+05) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.5363500205911953840939493466632300815532e+05) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.9581606425890502612004494031009370340035e+06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.5707859466605519436248210783145389996882e+06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.3250364370585868014741134452869432475891e+07) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.5517194518211075269677056506039998399588e+06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.7942254288775475838371368946573852545346e+06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.8905365825319631905214511319512521313131e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.2368271301828774569416415492058209292642e+07) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.5089794059717107165439056404115255559592e+07) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.3593677518739302561669904813733235499447e+08) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.9445345108423672502801618374316017231478e+08) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.3569524294826379450943484707300416273927e+09) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.4453994275217722171080713443962676326316e+05) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.2169408654819942095230808173408107344344e+05) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.8596113781295238499314826506616392677099e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.5093083040920536747844078056528712070520e-06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-4.1105056598673989057303526533441528818597e-05) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.3516675981242819150310311556709748478242e-04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.3323788392716903047108755024569457664601e-04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-4.6201550015183325626416819252933628034113e-04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.6940149047516369798726365645905951674072e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.1888500233225733490094990410082695245212e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.3012395974537373611759221582219492464184e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.7942646980135531833049583769577317905473e-05) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-6.1346053839017634758670669201503298605284e-06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.6335163665013335987615413394003304693531e-05) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.7074546970892315171522677105939665476509e-05) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.5971658049970496756910227084950966281176e-04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.9180815578878593035842790054909519515386e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.4915309097644222048161167554056202130235e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.4893855616517874685661161957285230238122e+03) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-3.6908458158343974426333194947282923349794e-06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.6855379911301949511230106755575522842400e-06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-9.7357448158996762614259052134720128799656e-06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.1118252248820028038014248907164810494153e-05) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.1949299861727077121953017662205813720665e-05) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.6048115567434695684457782021083008246089e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.2264445445475015878139770726151800209024e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.0624034558889383768482120254320915279359e+03) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-4.2236708672020182713793001645907934645405e-06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(8.8696752320152712750926849524751567149227e-07) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-7.0456413516746398719527608207499702964352e-06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-9.1120475917281984968895030383537232327055e-06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.5451435549310167752589118281809901961866e-05) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.2192232963726297744105388827280272402380e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0499430900823378371391537065018390531725e+04) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.0898203967560754374909936975413275732956e+03) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.2454751775857913625344714507951123572529e-07) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.1900918529438278080177636035311394517107e-06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.6406404196907540309625810256264979890585e-06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.0858796317702164667770814613812080062107e-06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-4.3884298584822123488677580893959214862057e-06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-5.1081364340477291860429660576307684156741e+01) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-3.4669026836752543712652758892857706631945e+01) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-3.4254720664025912550234173910512751704743e-01) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(6.9146754872284930979559007501078782623179e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.1625395752760026886038524999557671465634e+05) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.2452445522840927745833735733123035121296e+05) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.3955214205523094293002215548757210966653e+05) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.4050248409988496809241875841594103410045e+06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-9.9214397543021700941625645866053221404028e+01) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-6.7676079480274970982545625860985699953599e+01) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-7.1355072785925551959009607070182712438472e-01) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(8.7575390444564951082559506213667949761208e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.4845072950704572310427626994495556492080e+05) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.1724480709968490722359649253746891428953e+05) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(9.6998708218956451643305823992539264560578e+05) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.2025381167707422542566582384401208846568e+06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-2.3444507865318637251105872893213624839996e+05) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.6753561532854951675603819076548799011607e+05) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-3.2240812951712781049695251723204858099880e+03) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.4513617142802679130234595251830708438922e+06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.6216184076595620495368130433101061536536e+06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.4668759831020881173114446758954121001144e+07) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.2332218419860925505558563959279324679379e+07) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.6819465556316992200294386666144877773217e+08) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.7025333445684181400327851750059833136277e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.7050084489659638226057770436223900835850e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(9.8176193021138210035135235790627708040776e+03) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.1248560483669614432293670996353303661171e-05) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(9.0770893435609425974261367064850234566009e-07) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0226456473036850148600639700379767365969e-04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.8499771620525783147532944924862525297484e-04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.7482035307216942800703709838783368841933e-04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.5946455479318986900670690449135710558070e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.9231618224663184285903217193011110243964e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.0070906898365902778341457046833148799864e+03) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.1158254652790902418008883721208745298382e-05) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.1477870298270334256694483523111558143130e-05) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-3.2461105781074267224963120127748051086392e-05) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(8.8132957007832812928167721337776636162281e-06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.6906762422396532362883633743928769450881e-04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.4798784430240668114174994603113386220759e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.2765093125217420239121486982080017787058e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.5689324058005538290742108862709768118472e+03) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-9.0688400371910091248756236818417172114480e-06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-4.9506496662820937659872135047485682924934e-06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.8203621033414133870563146880050015123328e-06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-8.6773502774873445697344138689972436054628e-06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-4.6235242773408398153350233553722907932234e-07) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.3296836764494504456717242016778764810429e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.1481238261925163600327329435952151987283e+04) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.3382176403216342457668393999786024060019e+03) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-7.4834880882775701309479298904707045085865e-06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-6.3500420229294089285758523557083081989788e-06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.5859328680328907328657870080452942789341e-06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-3.1120671631990806132563455847367855091367e-06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-9.0146877402357441367302613854502835082472e-06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.5064379116808306895034278510024450358212e+03) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.6579464598491371784026624001557262380770e+03) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.2512060187070950438248401395534234650683e+03) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.5594403796837563065647487957857053466787e-06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-9.2124353667116196860650753733167649626577e-07) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.9313189900402361519518999696109371554459e-06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.0567694308132340467264801370994967310635e-06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-6.4109226617179132112491596468149014957844e-06) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.4933077462531258185144432752456099437487e+01) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0311090708324914719344926744884760116519e+01) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.2284972760945433872772139868746187660117e-01) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.5516572798140309066663811211275381957329e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.0847641081379612168678385635151414369553e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.8739853133080035224248501219204079665726e+05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.1843920182623560023120449415702611288883e+05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(6.3663224465595416486505514301650052978441e+05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.7354068700544735363693238032856864495618e+01) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.8982176017952151823617735635902914720235e+01) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.4131995506885128559663030698691620053458e-01) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.1427678889276214418080310856792841421873e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.0668111559314741253548466693888615639347e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.3742810584239840764713450725952039729086e+05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.7730596308803763990379480890421904702372e+05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(8.1890669287104335651030204168692237469763e+05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.8515300279065194956183569241473506518767e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.0721208586488066353127796161918821596331e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.7944964666655492273567106660218012295356e+02) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.5512268341128899827738775632212705124056e+05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(9.7905786673790928199361826292635507478274e+05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.9662926159282456807335848539836769885382e+06) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.1391362266666005486693393386482450319814e+06) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.4705955307171017030472851541609334142458e+07) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.0769664959461170316918657988559527914595e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.6481931448832650841024581000261562665103e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.1417835430783413242835556715551682487615e+03) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(6.9076217850829202420381803965853342346495e-05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0207564966984389262331807868940691401415e-04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-2.3380347682193311021967286300479895480275e-04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.5866435278582334209020002136423621174619e-04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.0339620500640494206873681998204296021567e-03) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.1575189563378211839213065302063931909185e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.8624059098909204153636474362962114618217e+04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.7455915667772237579715863377140794917840e+03) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.4616467979152518867465284952884574516805e-06) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.2352002605814782700965662581738550960630e-05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.7749230478564031031701259956529839823355e-04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.8741274254872769135818148826870268938722e-04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.1839817148040747284512274677002242723261e-04) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(7.4509610753509535494493036963178061831847e+03) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(6.4938088965728871307064625687840845949520e+03) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.4618114523502018593493627655479391366054e+03) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-6.9550247585039467485347446867759563208513e-06) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.6682327898882839185304520307240859379790e-05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.5465399003439537266511624113530381702186e-05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.0408971321785705425685917115672404699627e-05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-6.3514419197351983587630723707817099017328e-05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.7399745156418318723366660926796961934376e+03) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.8798011640175707663606253044447939079644e+03) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.3385273124930565110258984058165183272661e+03) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.4689445005648946999817978659720863476312e-06) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.4303270256125539510967914300967206502858e-05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.4135935840503674265849715825341350389843e-05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.2251843728463680067557650554657702651061e-05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-5.4149012311386373216193432746515050253076e-05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.4518604357076131828341026001058668842574e+03) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.0314765227224771181363663017933554274528e+03) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.4578825695567425937503290951221525007940e+02) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(7.5336727763744980424135774244945552702918e-06) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.9926261805778776045431591184303776830190e-06) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.8021812702778489149095825100772718624419e-06) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.5930095101016845956522750379551263772057e-06) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.6875889901764864716676114266145045477079e-06) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-5.0388634634352131521950355395534688348310e+00) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-3.5421413511253985226903732969926093167549e+00) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-5.1276680226044682505294445936908597700510e-02) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(9.7217568400187351237247695394404433819036e+03) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.4850353367175975043236621193408759238709e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.8575941328768467680892869375820271271323e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(6.7252954514828116045327788453648721237821e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.7643312612554016233647728474237940659775e+05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-8.7402289644395342711921176774090328262339e+00) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-6.1746292747194419700365438785623854716734e+00) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-9.5370946742096394612092818089501820062868e-02) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.1675413591899863062479597406075245985473e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.7943927296343914522055792023270477154136e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(7.2084922293750637740624873854582901673961e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(8.2905457233784084032793256642895755335082e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.1999249159932313264767031600974012128517e+05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-4.3988060057871782475501275227993374840009e+03) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-3.2525278239270916817238361522788077360753e+03) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-9.1148218994350010258288870954799521452873e+01) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.3907983476376146673870352376095277965124e+05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.3063207492343805353364298889791973965564e+05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.1584033818970002261357929357364708215986e+06) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.3601130068996025402830029578966049094559e+06) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.1341150375246089680964169531842873018409e+06) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.3978036333222320024754284271798034624135e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.2166343698738456892956987598281218831032e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.6705189773454125323065638417464398620958e+03) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.9975014396951847719982392694734848042623e-05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.3446852360591669728569326010019921709415e-04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-4.6621057245587850399112425735457808722176e-04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-6.0586580111396716248742519880630333579022e-04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(9.1296351485252793837464836719121538191953e-04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0033222995314317443004693395894383567118e+04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.7572861690885999098489879718536434788804e+03) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.9868929609843225877797983937304352188520e+03) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-7.6314152425547285024714961639605913077959e-05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.6852679175816116820992596750114261989349e-06) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-8.5290711093790107379435120546779584329705e-05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.9584637801877648536335784610492966221130e-04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.6752877674567242487622881155636010185934e-04) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.7234161154444260032660856152984901007177e+03) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.2792969761784019399518771499188011868474e+03) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(8.2702464292441977616611731660148966040116e+02) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.4040375655377500896409285838381080651695e-05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.4958956303700440464658319253730128475701e-05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.9221848188506491647367984554322287986810e-05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.2266415155278531485835213040002839137089e-05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-5.5964170987564098411049628866837040001521e-05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.3915331349008898468069846484024392046876e+03) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.9896893801204537663070545821862581502121e+03) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.6195472284199074485541699557326165008867e+02) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.8090290655228434503119908975638024881446e-05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-6.7500778515610647603694597567341565479451e-06) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.4932752121837352155614652055946463440627e-05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.8717396875448434817050913649925831409916e-05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-2.3312390405744635422376822581289366539484e-05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.8202489480490441973198076763556943173522e+03) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.6146247451399022920341622829247723391318e+03) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.4249692306528295862750071507416062022718e+02) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.0180172009388554282135461281188400302971e-06) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.3620127503606967241900520832302345552617e-05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.6101545074627500729912590525698435317977e-05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.4381054744299232004878062110702989061408e-05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.8370932316013340883896061258352386732316e-05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.9549064293366299710763830130397612726937e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.4001647472787046457318725157879096705065e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.4845172475744668903467206265656256932922e-02) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.8112228181665665134833352693179955431168e+03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.5658162149452556575869795800774879225162e+03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.8987918150670172399149741988493820986208e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.1485612312468219262080843546337239504937e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.0935540967126352534030616974744370700696e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.2213427561431191251207189833747598410027e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.3186176995447425095931914938715117290980e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.3890528699231349697128712350931055670046e-02) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.4728791920640153482327195396701081984211e+03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.5664429139618084695595079612903942144129e+03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.2756853119831877444163870616613897665202e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.5788488698554173682552297722265191476931e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(6.1741261901343645408150962992841257672048e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(8.3708782713181105177166329812819011455787e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(6.3025913011284478876200652958112709896620e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.1568893208897426215527391686848980324607e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.7761665989655486649670440630084463623824e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.9117616015427514254434013765271129812491e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.4766042450241003195431259912931697306670e+05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.8563834070291208640765400470063089715633e+05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.6794941213622082788361482712075069020313e+05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.2805968795422161137460393090183481605345e+03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.5294658793515454822218326502322172015454e+03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.3749629720395514811543474135876286445081e+03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.3045513700051106503469522257529856879101e-04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.0515315341473661164463252479997984361488e-04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.7830201815412560623992753754206857715806e-04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(6.9027989526708540535740363825437601868825e-07) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-2.5289070786736134150900606309251979223162e-03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.6187625382849372004489252390051843730152e+03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.0770072589789824761379702412595181957256e+03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.0455852923585387136280534414806417487004e+03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.3001768306601289769782996164904754844849e-04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.6838140358877502457877148817191368845702e-04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.2710370911709787209286085455007975425621e-04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.6909568995853791104134647273637426183093e-04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.5355988959720574991634815495072808857594e-03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.8462555990341010425291643673088464123704e+03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.6434192509819275561543832465090333153267e+03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.6509767036785560206619554015821752520258e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.9370198829208311882430619989255916545034e-05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.7025328140192158766635894094212518383875e-05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-3.2325086292487257053478103171941954378280e-05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.4947272503301397341271967360487861051954e-06) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.5913271812553089587010033419448091499278e-04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.6937321159140354651309733889036710945592e+03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.5089143846206749076740680386028694651459e+03) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.3122600905322921297793950458675614369067e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.3599166970364549757063093753435541117035e-05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.4279944761722580443853243708375989291825e-05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-4.6055662664958796893196378381821837907820e-05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.4089707728371426293700275581322934536865e-05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.5654796009428905290026229850711683502368e-04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.5386947505257858738937530373998495787921e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.5472444207414290637852406002885606537854e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.6130690712793395431954605354306357884506e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.5417065088932391695678276916046461070413e-05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.1127694235756400116307765920029331756991e-05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.9451869066767542582177167473663899989069e-05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.7973386958623240927950675159382873175244e-05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.2322659265936035318296941626267650988912e-05) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-8.7028631831723571304112515074862117992551e-01) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-6.3566263396944787582179867246454987696845e-01) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-1.3952043060199073158909214633473586882151e-02) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.5330746509697265581209844687824576660898e+03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.1440402649661812688682304556004316203682e+03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.3598809014357466188474516398426111836231e+03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.0961340389256907417167839605758601871279e+03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.5255241846240189438839507470817963807030e+04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.3658707359070017872649204377932217327481e+00) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.0025252599350455429658452017635632633798e+00) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-2.3480407519356945986209118144463232296354e-02) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.7615160333987442907152556513462055876652e+03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.4745762554172262888427811096922036175099e+03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(7.4397314854902042121614905745491282147479e+03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(8.3115250216620630921845196394045292290215e+03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.8019508744882865114143302180208672034826e+04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.9287837927465533763074884554160508402358e+02) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.4799576602557185588485132808609750853192e+02) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-6.2435610386345525888460538556413881420864e+00) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0953526507094751731167491190737349370041e+04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.6244143211611830243356897569053566957775e+04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.7326796216929314475505032729543110420114e+04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(6.5007215193056537247257190881877353437240e+04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.5552532558854427104379085334255249991277e+05) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.7897277276645491661962680799371806983717e+03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.4848373189660983395071173887016899567970e+03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.0149758137027726366231509895559362774924e+02) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.2927268473053512464731862079316410148480e-04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-5.1544476946646908855862139169775495578092e-04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.5252471101654093491207649344303711194703e-03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.7503486338949750189057126574671360663527e-03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-2.9844223997443170910325063325929910284442e-03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.1038361541669377005837934052116502580892e+03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.8784335052132707370265012501864095067225e+03) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.4566279186902782922922880004421150675638e+02) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.5689104677281267647780103124603149946456e-05) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.4105730964616558861981057415315054997904e-04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.8291537708701048067809117796884141541130e-04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(8.4899813667067294304023177410299608456603e-04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.0638189836355636814936044171847358069419e-04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.0809821988792152753719936304201321805664e+02) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.1709969779445852644803030831144711989528e+02) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.5993990041027955942600363831978623198149e+02) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.6415582656010636545305832037712330597200e-05) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(9.8801173813905439326201415146504562235456e-05) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.7313294648764000162604869810987777174962e-04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.8233554289091852666672815425584512886776e-04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.0103948966461625388900095660586982079178e-04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(8.3922704655559290844134841218894070926199e+02) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.5571195448943336682851841804932438927254e+02) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.4258469354333262381557292640709800971412e+02) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.2603041519802234339863084324637494483419e-05) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(8.5202301234294643124818167814341726703637e-05) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.4360135494461056542482754583319797337473e-04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.6300962740143598751320221979599462762720e-04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.9530563192104668877477046731752547730867e-04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.9663297355484001059766184886705133671699e+02) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.4960162372074330215711818827921756072857e+02) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.5355780062754876417332944373754435707264e+02) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-5.4523329362361903351113703564946079247363e-05) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.8199447993097220275513901781461455491569e-05) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.0919934002356854466127005974515686433961e-05) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.2704425633613621021764364789158635823524e-05) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-9.5094293180284089984587216232054612778635e-05) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.4449694781782386295988059675708473028193e-01) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.3143587646406616418658066183101113841411e-01) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(9.1330486600986778249658322409145755573839e-03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(6.3127819190686633658527547957711306614712e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(8.4674319414905087124689218766360568595672e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.1943358016572503228605519759780799321956e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.4153517562888371688196500088844550388838e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.7236221437448645304432458379828908696634e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.6576910570507936664556838785034943186699e-01) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.9883270296427472393691005222115202709618e-01) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.4646085019422543331260918912242913382232e-02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(7.1126386275370810426988432653747198526865e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(9.5764894454617931680773727320260263177899e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.5101708297077884600060434481515272291708e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.7659699308114669429240274114679787740815e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.4482013845992010315236094222016352109627e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(5.3137561879341929650969496445586684858814e+01) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.1590533307073969971386743598854799871742e+01) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.1867063191634724715489693340334021838311e+00) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.3594817338942405427349917366344767322735e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.7329359780497195890905486226429061056346e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.4190618431933337319553397686088152943378e+04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.5834098923326625896140697801266955701042e+04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.3886398310797798857804719057344703334526e+04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.2242910160992118664404404833833719389730e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.1034808528686942715706900990373890244171e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.5449758266661654121066133155652485054540e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.1579112600943976823377303503154254615083e-04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.5167366974722743071902793915879779105956e-04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.1314628498121374964075195859390240511409e-04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.3949323454645720375532457733776579382489e-04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(8.0425347684204351520415250287034697939480e-03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.4773112421784858862559013575947075094466e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.5609628446969194230158569763197424266090e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.8229696776675441400505475365980267100253e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.7164193346267933940604036915346810522927e-04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.4178651378562008750523056957203839445534e-04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.0158830697077536535509878266799473840147e-03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-7.1889304534812463094992019614120305067372e-04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.9721769206625933109309211829031377707726e-03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.4292008510114593682813762324676968293934e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.0292546867146467695359805317929600071111e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.4434539495722864480493216120181866189523e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-9.4381722205134300687586700551585283371098e-05) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(7.0535282340843754282350534334567943824353e-05) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-7.0368118532619731267405593953752587075389e-05) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.7871273872440358848588577749260708472614e-04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-4.2780244194573808831626139799153799360295e-04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.1244599846824093758897177709839109090971e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.7546630061234552055660314043402860842827e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.3561489580375164707901362362013046154658e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.1948802557517200108995916233462070648801e-04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.2738498856311536843280599338756056415409e-05) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.0083728606531955134730853713636501546267e-06) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-8.5799425813235043534948093256877077971797e-05) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-4.7310456215208812009910712942809394058146e-04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.5684601500014996923672038669094123079119e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.3495328134802038754410005653569445049575e+02) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(8.9785024173115838478720247304494428713959e+01) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-6.3335962733147634906911600998301122505668e-05) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.0648095402071633718314685703399761387088e-04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.2721376366416795625211906908995441570780e-04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.3385053115734031899840948417902527885819e-04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.4194784484779246406447821376667930866765e-04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-2.6092358994251473385805044277711186750674e-01) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.9885918573776974216834536749229863425138e-01) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-6.8865894503206595177918371919818208642134e-03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.6556448777783364064723903051511402884816e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.4210100979625229438777919908188565929972e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(7.7787888464687022161091369497031612636705e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(8.4503959071021755640509034757045230305795e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.5077117732496844272787295535021062208885e+03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-3.7353114445978649532213275407767030218083e-01) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-2.8604625752342373730049118099165132817536e-01) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-1.0604725501815485601552387610245371517688e-02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.9380439305298408850644325994920042802190e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.7967842312324857141234019278046313768738e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.7158045548054105216069042024598334568007e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(9.4768338327639007358617463548435635154508e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.7010242138544534191400046305012909293213e+03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.7362019403001502333311102090511295598271e+01) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.3877101607434646618349865414009263691383e+01) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-9.2104585310957109240790381807615367456803e-01) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0809553186627575104751896477596300711830e+03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.4502566467818997451527568545480726478682e+03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.7215235827012003393273658504532154285394e+03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.0888525900704264274143476814373527390781e+03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.8635500826376317911180939916743185869039e+03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(5.3052259849460421402361043786912269178310e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.8397525480301841467700298762184211997306e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.7735700101757007781366248572607947737405e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.2748877667398759133960995618536939279792e-03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.4778380808915321191266870018294074677921e-03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-5.1597091188256003841192411181178917069963e-03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-5.7142989214539546568975433249774534577008e-03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.3889718358362082641429344693842179875686e-03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.2200084776238855552339142905257531843449e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.8573977826913614072729027186543215077450e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.4472015075685202161350698588756126873532e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.1858515638694364680642231982296598771295e-04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.1278007678366669494179138142616940107188e-03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-2.5093937144802890125142107700311549465276e-03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-3.2544804363008528416037037558430450893961e-03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.2493388288675183879347174056410039458562e-03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.1415114263850611392698549012989044439520e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.9699339885353566124457716394137711232121e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.9620576001237124319196882604633278368540e+01) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-3.6664539166638341623045106471034467312783e-04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.8005533268087657938216077455840169999478e-04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.3070327897041361032542169749699530884777e-04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.7469115939939638280683897429944239603494e-04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.3690028693815203266746998134747783214796e-03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.0098565675091379337162394626652102000158e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.8499898916801073592898443834498044736715e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.5323993910252992075645727835314860890144e+01) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-3.2604960061933994562863472738307929795945e-04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-3.0955892096147781754526325556453793315013e-04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.9715928174691226369194879659807700390165e-04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.8546113330759138786875780039886066098717e-04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-9.9556511899968678110476391628448022071020e-04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.3191583990499034557891060209922340445588e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.2195112252515631147195973865318221392586e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.2224408256264275578031144370624061880748e+01) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(9.6194981443579741858841208432097331610149e-05) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.0331973588976034365833603632771216921127e-04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.5902534336493049207986520212514184050555e-05) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.2770212141752867280704496741121102576981e-04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.1198528120807325425128997796720173926780e-04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.7674640720291072663124524435396538553307e-01) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.3789183468140919048869483535188300409351e-01) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(6.3569510590045387454356019895637377175488e-03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.1393752526744865381881486158996704056590e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.4113749873158289484488447014797347847508e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.8268947813571943689056780304549477801736e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.0320041037762643937452931372983466505039e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.9483437927637163933999892695892758502497e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.4207866384665885184537258286131473987033e-01) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.8975378361177839315636237497100073484900e-01) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(9.2304038160763483472731448130641794671527e-03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.2392209309587215901603026011873472153699e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.5390423257112126735805947491081880925326e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.1067847735933849652444163741594889176651e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.3346661140935543181979425536969396156974e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.4692232361322568523304114449332225838641e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.6981452329958977201616366327424988586847e+00) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.4742992531304994596434356183048555380512e+00) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.6580191321331102420745916794773265723235e-01) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.6267272954629109356662161600170467857491e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.6436170253739073442200565256265236524423e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0264548416943327059970083580909584480512e+03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.1111545751820780011219190073348942890603e+03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.9281665828242712632524705891677734757927e+03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.2684531093233891218717188520677972969306e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.0950231949331161059060374095433229867579e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(8.7802988859852263194547345079934507779867e+01) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.3406005325653607776316882695751285247345e-04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.2147812551250928804880918461491477149527e-03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0874137195835898759923338888505440300305e-04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.5820026604459803888206285375424355571153e-03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-3.4621378071920496472573277262972249322166e-02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.8562839786953158688535188083440762934463e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.7173714517521117370979412390151614930770e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.3485535219307075549078227152034242289528e+01) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.1649430063381446621202309405213720938007e-03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.4003048520036663950784257169444682192322e-04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.3460952521064749519401041789821253383702e-03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.3041167011459611961886696849332804457408e-03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.8641378738693472726535726206013553812283e-02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0260248683128618778832627283293022142104e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(9.5455192668808414733261660146760489009411e+01) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.3613772703072760362075454642219130390037e+01) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.6713531003488138658168474730342659163223e-04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-7.7783666560896725753260132886780482491506e-04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.4528946101077309592818470819064946139716e-04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.2335856274897342830109590151423137355101e-03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.7518836005247086648610080979385938322896e-03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.7077948882472577725479472227482163652753e+01) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(9.0365406160020387849298995048404756393412e+01) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.1555688629785013021775440700984968354861e+01) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-9.1755686963177614671550074819483337780210e-05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-6.3406113646524807492417103763681638356586e-04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.0440387867078507423234905470377049679751e-04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(8.6925522565260402029015163057196013749489e-04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.9655043434192361653566956456347344160301e-03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.7266277793677788460828760707217683103815e+01) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(6.2854014029431291282739071515892575021777e+01) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.0213628255938379015846304539565130025555e+01) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.5086131978834715365025360249476513879665e-04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.0812305171062300977923693153902403975182e-04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-5.7506622900183711647389281335581751323682e-04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-5.0645848064386827667098008936224497105390e-04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(9.1844567029073634234715904317533810725009e-04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.3910043325539898331458617913268031383129e-01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.1128617252033049771485480553111692792865e-01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-6.1546879476800589777674662727076258408924e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.9781281543131576029776568157395131095091e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.9364162702863287688326707809078624265856e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0511398072888940889695354186880407923588e+02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.1134972937277112124114674903275453857103e+02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.6663182583662599079465299845307910594275e+02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.8237071834237693259456976307190180207607e-01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.4658539627946460920957981600512718337295e-01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-8.9051758380608471352925151984630386579077e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.3283720300398249576720169910122093073009e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.3672631624305113616635836380299018442762e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.1344961851903025674958567825458997661943e+02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.2025101243045488162593530623612719906467e+02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.8066526704179802070162748377704781157618e+02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-3.0480835274536402863708270758220561947990e+00) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-2.5513561449954813903128173793403448416918e+00) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-2.8361260558283935474570250263752529919715e-01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.2626515293381432225581256256907149907569e+02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.5457685674202997445213843174774136985378e+02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.9601840913750028191659438106226387203984e+02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.1589571600711871493894109597990027311804e+02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.9641917149977246059052805221575940435024e+02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.5641273228202248633342967270385972099583e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.9443918771093842894231371902354930909868e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.2988633320589358976601309062068918684554e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-5.4147406768248516723145482933253512481759e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-4.6218829563568976622525526653368142445217e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.1369896721535945343354817614219012643515e-02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.4639536163977740900509274968787687856669e-02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.5897296384061869259270452747680444608887e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(8.0612758040128169941778974003087679967610e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.5502772470279548047032006611688291159706e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.6941735515333293492864098481247973170003e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-3.5999648108048925957979821751448201558489e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-4.6940091054099485158341445536473827536558e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0713726973658568152543796823409996780848e-02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.3784936930427877260364450833906981004451e-02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.2239637893945157319748402340964099936799e-02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.8692911519082648057581363121387599291960e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.5824762839317551505522320391056333792198e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.3717728235794308362175577166269163325630e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.3571626906094756127443273463843899879644e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.7885142672166540917387083990275853292105e-04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-2.6428388189217062816764886717041970811424e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.2329066588347702578583753775759511780746e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(6.5850517595799616246531372249572559761728e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.6458963885127532185462996700849885154165e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.3743062087521100811830039319487430627305e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.2765658275578000046471224154531034124666e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.4960885300592669443129259567509361914948e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.3223466351254837936279018532365082193772e-04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-2.7008864381068014173402364065528606737057e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.4648693834520990445102385223910068016714e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.8794337551191090829805793194718941299433e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.4045240033173282539976597454022094491974e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.2159432386125168476975016166518547812873e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.7382380103174104156146050705897612094221e+01) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(8.2572343428095315515872675889327862526832e-04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.2723703765682798954584568348053854803358e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-9.9612801940189750138705268301487023380240e-04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.3225575138689982517685689028829185851828e-03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.3733233615244611405599626480163713992657e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.2865234626112850059739540911844960936303e-01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0583402237393137795593120993610610277005e-01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(9.8665739306435157203422178684261127748397e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.2120958658949353611979622709296161274139e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.5421200379983696098337359217065783810194e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.9924136490879843082706126564988818879729e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.1784403782190797279916946388049523355930e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.7463353630797875899530664224572031582788e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.6141196267554476824084402182528580731273e-01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.3337602964672041569822349636349838406050e-01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.2541435232542035571549047658535819138403e-02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.3322759467644628700854019978750758737783e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.6845031998904090857968758324079246192942e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.2363469949567127170780253646924118157406e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.4357606990731496584857040719207468467758e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(6.1188247783308791413890796563270159425071e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.6404799809762880192388607995128231410485e+00) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.4091604374044427607475498502145852259016e+00) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.0981488641615584393101532796745520183659e-01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.5435584834134783565135586130642857934332e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.3272294455204188444957192673104748298813e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.8835504782153690525743951210857171397371e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(9.3500596873090873804185073688985593511307e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.3349966277606782705005306777820434117927e+02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.9728504784969690235232575237834281146685e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.7632883305100072381318886355613841708521e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.0802500013047602502645523867783120164412e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-3.3725242733616617030349340755348581104120e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.2504537842182218035077370456706279394247e-02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.5819983475299864372512962461604957556796e-02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-8.2980299472139576448590027213791584960110e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.5228154887272190935604473979212115351737e-01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.4537520666346915819394633291280286920975e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.2756401941695665252077099133933544463920e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.8375917629142574620656843224367401754987e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.3038844406146709604360321093909381201685e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-4.3028616390121077221285703866404170840568e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-2.1860701068343740383168504745401400224306e-02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.9753936617155004112262323148036137374320e-02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(6.0627348351507838389288293114613339601727e-02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.2880125390832967149167869797731009352208e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.1785744769040254727183544898491104296929e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.2800867734725970694704672724435384984725e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.0568836397954751307396915014426904188402e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.8354663001552803508441531182028152898782e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-5.9573361724759226904770079959306266595404e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-7.8110157922447913221183153552630139435188e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.4446944234552924072740670530593611233909e-02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.2020901019672226076324307242799259386529e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.0975758249434364034233815467193964868872e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.2380985494115487459137355363374220900972e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.4267784051154755646204497039858438870349e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.6311023379079647123816708463459470848254e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-4.2700887583059876427223607003829618991563e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-6.0352735022835642752172828294909458471941e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.4357000925179173333734992562412661072676e-02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.7098113225338329045465561627424405979717e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.6330118101878532081463844900875718070383e+01) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(9.9427058643839987500509070038960544686380e+00) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.5109222051104028892689566787760558450578e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(8.4179256338253486396167321183779923966831e-04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.6812728608143129844451136353363693250593e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.0170467511390862684177721149505524352380e-03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-6.2570202946669478854455480776990485324987e-03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.4194411052631213332332113012086506811984e-01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.2029742413394156746119362278131963155244e-01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-8.7055280464946441231699211819133546621685e-03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(9.9858187895188793890486553700548567428447e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.1069444725465234625402874135934172362524e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.5466569332209242259074890922126666829982e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.5997554020175088913572055802069858808277e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.0259873621925673983598679978106866587291e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.7038019740137475181750038070379875785453e-01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.4507579669489317402965432468989650583751e-01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-1.3306050584081440779655651049623567285836e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0379221116716774244612196139041644632712e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.1518780682770308290310595903084673242726e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.6150407591530635387771094273332096474750e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.6710374732258387858346717578251534664910e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.1209320620247685052781188128444897291841e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.0517904991557812067159638110147288771741e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-9.2963719244337064432896912936830884759277e-01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-1.9087594585285623295606432270013295956438e-01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.6843461206421735522729156834411318333063e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.8942223983680029987589570942070294272913e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.7632948851838681981490659110273633669390e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.8697892582236925828089596102923821573429e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.7339730657109864819067474054963061573875e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.6244872860646586813771785947669175942613e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.5590576384385210189204388787850681676305e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(9.9426584257108707609166913086022552103842e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.9538962376286761202968217686544818895049e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.6182481734966937929814092913364571248839e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.0018544236159589454366099011844014820949e-01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.2812492597908931732391696144056201129562e-01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-4.4795564735260834374748271886066393749317e-01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.4587374191181228261062598615822624895443e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.4013330466972990805839346134511272909308e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(9.0396057526841219691628838912379801157372e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.3373588495446740492779826387920451199453e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.6883758374781733287503708331038494446298e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-4.0707891657668883688075119225358346058553e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-5.8513914385006384477454137876880896200967e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-2.7660589258740630720944846993544462318868e-01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0639844312380878328107565825940195938680e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0252274310356230831462259051808211527430e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(6.8545357262428271773873518071428520153294e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.3464710014487374069320333556537015193784e-03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.4378782362747370883150379388354732572336e-03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.8901995947520316190122251594319953407987e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.7235312848033028802649333576457754708312e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-2.8024024703837715514841801080682279050559e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0333001026541949847919442213479328385918e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(9.9595880235193434839646161666222348908591e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(6.6821855518361891174650257600948004608727e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-4.2407894356958125839441150104792015831750e-03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.1163885770960678365418153122626522877948e-03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.9085998424602541646115804762211962799497e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.8152266398329740195033316339057881414243e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.8240924665484452676340385532446113963433e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(8.5180110365983439677641401218942818143189e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.2270623405322906211728402806728854918315e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.6532098884936305438368015756295931578994e+00) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.0770774486942638500174893960887977801470e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-8.2571997019589208118677865350872759951167e-03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0461119971835400716752842925820633424243e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.2168173443625508049513540358552598742827e-02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.3186455314179030070674061228610966957123e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.9425956546600264684935298199576865306021e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.7120648272382614967844618683967421904485e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.6513921728229195698567278552990119113772e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.5747231732832733501381669049395973531615e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.8960126963525910921576397306551027730953e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.1033565921740194923719695707372544591812e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(6.2406651166548054864921356448074612492764e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.2921599045778019868381015940696665404244e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.2197046867155793189177683981283555667995e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.9628878203933370468606760482789191058606e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.0301622184165087500076133823809745694081e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.6910687840740191335583397343510818622811e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.0242439744511171100624985221955114645911e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.2772237856598013229085757332719033410355e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(6.4198055901021721673148197063438292906435e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.5121442917576693374567854707243924473099e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(8.1479827038586459769061122102098792292053e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.4382179051646650477643804292396036755594e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.2407198323645945469538410029804795005181e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(6.4149889407259193455473252825515261021958e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.9291040782558736846570541428951157392503e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.8797053822459540444741930521241003296370e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(9.1031401879212378935396163899510085187230e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.0823043481943546701045327008405506313965e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.5322414620832067617477378722871802454268e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(6.3535683201273262810662020179396740167369e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.6902016148332822566712951375103016365901e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.1701244662109776659362902952559415697627e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(7.4481063197702003567769992482384934871737e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.6853140818511631072643657350415849127115e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.1016785402733260219623614579234340823935e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.7448246424933615728046205750359898661086e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.0687445605694938222623109999542145399450e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.9066739574000699725021546292007984406262e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.3948770811189170150492114682016478535207e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.0552026729991760999261625865967641004667e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.6858343503624435718023863345125982434081e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.5467036203852971331631180421454195320265e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.8804738844051401369926012472986661997024e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.8508257127215160271983834843598672519576e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.8941688847985837978063292397402971938421e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.7734388201657467140391256278165030961575e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.6402636982733707429056528908001626248003e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-4.1025342273648719571045937486279593473863e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-3.7650247933402350885141075021720735738897e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.0974924669262621115361450588123041859841e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.5562573255049322558948845486043956537958e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.9859777595584964488967970289022460356242e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.7977450267236636615455838914264235724470e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.6803541151863936297512511863266041189966e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.5778527785175860573320019041994487438271e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-3.9708722304608894481602342560411558477518e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-3.8761693572348650982195293325125804731836e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.9007130142916282421637521843957052442673e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.2211808898424360554371506496762854554357e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.7383354812688734848868397941857406571945e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.2080623272367074307694526664740844770567e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.1108749238544345643002613487996759392346e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.1943360915811915713478353904162103043233e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.6468406735596292026266570280009772452777e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.8914477372667437197101117086840995515203e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-2.2005639240349263047800744561109920691423e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.6624091026257339198877479224280681598375e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.0086229488579662431859428191206976542633e-02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-3.3333344696343440162672852689368824559101e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-3.0298534683031673822522281442443228981130e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.8379117741806275449591698639336354757721e-03) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.1249778847415795833979604533159252018497e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.1974859340138640086313424771475662989028e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.4505005121876805653324788349732997670015e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.4776094726597454572105969159654269054490e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.6759646769467819103151701298280719755786e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-3.6438815568701019909122811179024434145433e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-3.3333321705667022240702459879318776890432e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-2.0387019896564931563044392802102468111707e-02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.1511797779069223916063132646789403661180e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.2253766142979831347676757388044759073591e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.4842841624905903110377482884656573387202e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.5120245185622902223651650000732542977599e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.7149996197753116272709704380537240043171e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-7.8283705839613688637198604480285594732250e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-7.4225777367747887530664877445327406537647e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-3.3333302945742652964294277074659575418505e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.5042390688999114809483480849892291184833e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.6011915885933493111285130713740691141440e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.9395043844735213170468002322827431607409e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.9757525258925063289754489538616094422753e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.2409787599857421424527708468748034302728e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.5802785922272631224680182959225271677319e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.5443097555762686321733337050374390879997e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.1818453250330190413508696866009154425683e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-3.3333373735953524057942205667921976075992e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-4.1927091855761029814305517341410625161863e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-7.1914603405860076837703078720061153405921e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-7.5127581373907260633666614547286620631921e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-9.8636815594764951696647430979193862680383e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.4845920502965519806696540745627253176367e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.4508011420268775615706892926250297007455e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.1102840871566005494543033628455629553324e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.5259981158530243899106282741988010387859e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-3.3333345985408109119590194237182372825773e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-6.1505100936987353745178610604817252166731e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-6.4523531720396232616998163677867042382679e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-8.6609271794653789891042862445883913165268e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.2256306801321226581083371954236501563481e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.1977340105543956228180756480869570394547e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.9166142581794059243368720421323501532459e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-3.4105469377932407622403194708575908640961e-02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.0075653100623982186441352474260303947291e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-3.3333333333333333333333333333333333333333e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-3.5825251145544557868213884285193670120143e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-5.4058516387013725226609911956874943792093e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.2031446482841780172997182336077172000541e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.1757597849224219605527050804080075793929e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.8997975957575086437070121688629680213601e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.5133254586394005389243660256173637001218e-02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-8.0561502590036051333161074403553455637173e-02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-3.0887133488366370135223259877203991485487e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-3.3333333333333333333333333333333333333333e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-5.1232081995250575221783372091592533805815e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.0607489004226911317306904786829263265575e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.0366051170956948205827203778564737698809e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.7933038738641497931021016313718938873319e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0501078559367953904807982803798741960977e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.7326165356683949290081755722168313840436e-02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.5396251918056607959263704917872734876168e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.7552936735184250050036259338067748823945e-01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-3.3333315253384159686450289450946295499774e-01) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-2.2489891728117486545019052710922647636420e+00) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-2.0119261083874025886293674911554603983366e+00) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.7095173120530206014906309830983382494166e+00) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-4.4961205709911903420084770811196467407828e+22) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-9.8139335415815920893102603149686352344413e+23) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-2.4974650635580724105443147155634225467346e+28) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-7.0634639835291114949031651273912129194101e+28) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.1377636250902545306178131783261522525759e+32) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-9.0939489548469910180841932876590540539677e+00) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.0025231676737505168742699057207897390154e+01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-1.2983737559868825271364482076245979666797e+01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0079763548111505654545532796559980381631e+23) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.1312633204452287818638002239904077470887e+24) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.9191104538410003782556390768871056196621e+28) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.3781876321456610046732807183872613523536e+29) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.0819746959213206727460103729374282957176e+32) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-2.2006220420238541221682068948552584161792e+00) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-2.4166435519053353399598503202458598090231e+00) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-5.6694390592889990831784388916045066103509e+00) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.5542065494168385006051205006072304641157e+22) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.3847564693445282630527826133963566556219e+23) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-2.0575436454530530296022335890637457716204e+27) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-5.2419029068899861414452929747155133212023e+27) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-4.1479276789637603998112156883492493849674e+30) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.7972304080386913395979373339372860625326e-01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.8523352216758716422165950534914194888428e-01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.5109837873191192723627483698762357573517e-01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.2691222472598984050969012635098331502340e+01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.5676843982074435542264604438942862895171e+01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.3414416017401383980165521307593895119354e+02) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.0400316738651103624237205290407159520964e+02) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(6.2781432010090774823758517848040558712262e+03) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.9521714721863542100169108513039996405235e-01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.0080337253214178839421241954420811886726e-01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.6725553686258457798632895821435208408933e-01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.2299720199093609645894395004023372483456e+01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.5774941738342618410325420677851460369828e+01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.7746096420351453096574162144002724257726e+02) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.5775377066038354697786461018408936814289e+02) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.7414033165171429731008695210774931616307e+03) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.4364712241984424512823531308634367619581e-01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.4939769023280818086246862608655107467117e-01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.1680726832185214077801569495974107086795e-01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(8.7095785694704974010309266321587762343678e+00) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.1865221161755577018908460709997488103024e+01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.8282707796001217950920568628853937201029e+01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.7954665107674572093122785714985874539294e+01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.6645708783032962672724603436915056318231e+02) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.4837523233366278188943423687451365953616e-01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.5413599351643104421221935782469375652493e-01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.2156950316803559822107965358720626698078e-01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(8.0948792143024124634167500760282648646465e+00) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0880826490968361542256895296826121114871e+01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.1779241652280417636636849910848382130738e+01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.9801898276544770648807970824413760428036e+01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.1744961409455522184143025051851650380179e+02) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.8064751276959449123201439040547471921908e-01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.8645020526484015778203604150568033202323e-01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.5372664890761830442797520214508469016275e-01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.2802786292832461841841490509613997101587e+00) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.5630021758930385538261824929680187473903e+00) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.7654051294368945699325447372097909772828e+01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.0125224956606648054984213200998132692515e+01) },
      { SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(6.2132827184775996600012536925054809586749e+01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.1100711341008798438696597445240167357167e+01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.3761668098951213981661554788646979338513e+01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-1.5726147171984341208918995122012142578266e+01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.2282182446090279091830385976597161891419e+24) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-5.0229157240670291217247132063067520742470e+25) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.4196625146809037137933549532842224108423e+30) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-4.0580207386251016120764403640306580226539e+30) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-7.0416424434484682777041897605467190000001e+33) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.1416519297506042869850949304823611891978e+01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.0166690268186683247882221602926097832883e+01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-4.3049509742319333708015022269678543534291e+01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.9440512705904193423080002958189207911499e+24) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0799551507190361864462431677304555694087e+26) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.7711676936934879866793886500062088552594e+30) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.8476004939154744812841060730003814811679e+30) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.2779326895900409617405829038570368682304e+34) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.6957569951440812931976496514689014385810e+00) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.4528452717107365642166468482604453583700e+00) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.5547485030160167074203357629277882937079e+00) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-6.8254310097913294601706620851477073337436e+23) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.0859857322112169969305616208211763654098e+25) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.0534892839177608611096425283874445778350e+29) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.7157265873164990136984146469997077850126e+29) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-2.3331004565690955461235501074880125941238e+32) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.4105661694403365298503137503654257645670e-01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.4523846999513681529399719466112631109519e-01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.0004696623718118142884970475014088751714e-01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.8904008560505163487722919725456537973576e+02) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.7004553411898032360028644531002268103580e+02) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.3398137320116611035315055773611709645055e+03) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.1413338493202723580775700895432874035751e+04) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.2951086163054833901905650266686784218870e+05) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.5318051116165464337033511604956128759575e-01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.5759957226327118963162487463154851742975e-01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.1507551342237423917010694736724720188125e-01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.7692421374152061239002226137006583720521e+02) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.3034867123700917481686541095403469071406e+02) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.0042275965633662147678553871754938198067e+03) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.3745165853502804083999509658515923182639e+03) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.3226737126924263812420504992053099162557e+04) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.9420322396814144111718345829307202705073e-01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.9932674133873697087844843983438210852471e-01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.6442458070050084447357469902117133784894e-01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.7998957031375450193970163617742854633565e+01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(7.6185367424167371580952482589535475470746e+01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.1176751796601412113021419301378877179456e+02) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(6.4476971525790215174195310485119211346539e+02) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.0633441322502281000113126476123602551481e+03) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.9846125983273649365516017028394832072142e-01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.0364974737615503448615732548109682380273e-01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.6942537702490650972624868001217534037857e-01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.3030668559723872366124224742284515466491e+01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.7305518774463906003486100631978233241276e+01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.2742332866376191434149000219811151395316e+02) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.3514439293061468218105610815401342898471e+02) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.2218043228628702531769390400239752707333e+03) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.2872311964611121159290570572449549237638e-01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.3433232877014510160351626434545433217839e-01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.0437368512121799651488356863065450787062e-01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.2093780160741354491996836844951725351326e+01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.1520201276311784513409920922365099021645e+01) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.3890486971158788348669448702640486768052e+02) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.6676094681235534969288203302228759698222e+02) },
      { SC_(2.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.3403897708855876527223126002931087422072e+02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.6621774809499580908218474007843095172345e+01) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.3662129475305593258256034578386550622544e+01) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-7.7172197789321512703830304157705855713141e+01) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-5.6893906756552629632318879174096202723279e+25) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.3236667062501609327821966482422484617970e+27) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-4.1464958378739229398026870438008801307418e+31) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.1976534533184635279795820990953993433226e+32) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-2.2355901213278092226148318891624055045394e+35) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.6185915607867596065568286385792146619747e+01) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.0026951945107451398447376597079795650786e+01) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.8468594064887098827124164580183513511137e+01) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.2499203500560434988915746122494287503830e+26) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.8187353322599949349955079732260458352056e+27) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.0240532581741328857478379718761351151102e+31) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.2962952173050456396294695933029103896423e+32) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.0249698961643727040849814867880271546139e+35) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-9.8584745910171391717422371730044724408626e+00) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-8.7494567277629417572497400839735783992284e+00) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.1099486916178736052563616406124800286165e+01) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.5524161859935305551433927078084855040646e+25) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.5589716583589878348093342927227966875313e+26) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-2.7830733707435489235430847659292564830297e+30) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-7.2572834864221516599480886940964483807292e+30) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-6.7559870641261968723252121867579162404510e+33) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(5.1169522956757930274420888290598966804809e-02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.3495846241693472215258202544013691734904e-02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(8.7097906530728484968478700893642293518332e-02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.7637283407616335885314051273684999697269e+03) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.8667000097532401759427074197543684542670e+03) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(7.7815772837285296077386169850356598168222e+04) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0972820305305948432048328048731864224416e+05) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.5181545912986063169016300043589639853711e+06) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(5.8139574751605259128469414421581751176759e-02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(6.0708998236834185718228736439924810239092e-02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(9.7419189468628852428852121180801669522103e-02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0048227476977583580502779071538823434068e+03) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.0911662101561447926192274917630738436403e+03) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.5271357659795109839458695038020991449261e+04) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.8839350170053999891645931199277485243451e+04) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.9457347866858146006598014196361869120033e+05) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(8.3813671698750690082464098746844126076581e-02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.7190915232252836160349418647461456209027e-02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.3386888693183755776607677963629438263203e-01) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.1324538296237755773232217014240047750909e+02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.7839767526847872346665738904405160345877e+02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.6397451184768648626659663258457528584194e+03) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.7491310154463702829792995670299568309422e+03) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.7844686090916943584268209598534388773832e+04) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(8.6652479306120345755242736705757622628006e-02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(9.0111568926618927512689099757999577540119e-02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.3776980850383034372319725242455819968961e-01) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.8642892333060894796999973927139468651352e+02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.2590895448726619951623200033271735465423e+02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.9683850096570755860502152368497780400209e+03) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.8502516622906333089091601474020941393951e+03) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.9392325354113873992392387398324244605900e+04) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0770559985322440058367592193654692000971e-01) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.1173146000106478661417035770377178846474e-01) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.6603182225881005505117300883486041704958e-01) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(8.0545458246841094452074685716778589406872e+01) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.2781007553657257796766855985174168048902e+02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.0929633573861602691654335374724245257914e+02) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0082118080094300688979014680120757916405e+03) },
      { SC_(3.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.7215776350157775969684346910872903916362e+03) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(7.1221544462637586153568981065244532198437e+01) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0505988006649057315044807258241484718010e+02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-2.2930902134675592408482721608789306437993e+01) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-9.9686963556456299969939203469996096610270e+26) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.3922340863674822440518906287727025802794e+28) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-8.2895584605689676214385823338551553161727e+32) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.4188958607901379501331471793105971849538e+33) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-4.8505422572005947906761566978183848583163e+36) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-2.9078115437397769626332433651377072067015e+02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-2.8021807184627365674935722319652805861737e+02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.0217463110479991319715976474064902292940e+02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.1692572830618350045876289853376061634069e+27) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.0473361828277460983079811998964194175833e+28) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.5907894194692401881115361481403393150253e+33) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.5995919332092454400062980366211056202362e+33) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(8.6659116560908725175616385747401508462862e+36) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-2.0711632561468195569066207380468193511632e+01) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-3.0299498152937238585757028854900389033056e+01) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-9.6429158912750834699720975789952139285859e+00) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.4346049534155121426552441521093729556445e+26) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-4.1541489583027932989252702148913589701651e+27) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-5.0516640218523814310812899872064166827388e+31) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.3321813268116278443112682828651118257016e+32) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.3414180830245321560433092603131432922075e+35) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.8089987862805931802338203245384081179216e-02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.9212097031929997577460608894872476851002e-02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.7174171569896116136600549131447867696050e-02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(8.7583551318336436920051249071173527524105e+03) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.0956055253991000614375826212139968887329e+04) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.5203078527832520636405597690474063903962e+05) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.9877598958660838369959870263843425752948e+05) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.3147716307476998647217734207416145922909e+07) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.1573606665718434507320759728558046356784e-02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.2872984880455764678664883054935267463693e-02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.3369910546428184327273664531532625797423e-02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.7187675349181152322527602379196548147951e+03) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0735767358370423099689395885690204369998e+04) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.3871886188606372885281565225256691703884e+05) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.3945596446352506497552912500598903026228e+05) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.9428394755418044867731613097847870098611e+06) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.5631562954407412705103640200092192566486e-02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.7581945221317005891283872168390960119988e-02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(6.7018970030278353200325442771235379304155e-02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(8.2706865998754146426219147717832527129965e+02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.6083427205865240098251793883149522230066e+03) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.0767670678678722419495989882154424416779e+04) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.7894527058197869321758626583110159816021e+04) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.7063950103868662747094309935369943062836e+05) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.7290849614203685996660537545522601325744e-02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.9312432289678105653530224808089985362970e-02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(6.9696622376623000539804842014246677344076e-02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(7.0890891631986128117722975074905827708755e+02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.3580314900473298753022187623626827040826e+03) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.6623141475136323176351862938314942514733e+04) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.2200348151800940228744261931530471251196e+04) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.0669392314499057173191145862376966474287e+05) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(5.0162675271909647246747949405955633586781e-02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.2704046384592469794468901267483013979600e-02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(8.9844709722400588806116454359596507070325e-02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.6686335663599229302996905638436235248778e+02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.6295468826046902276696354699922974693663e+02) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.9506787084843947011138331776645633135363e+03) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.0729570832460923516169190466258963215973e+03) },
      { SC_(4.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.5476872053265616587485424228030473123773e+04) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-2.9786965069704257197707045691257870095915e+02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-2.5594473267610054264271781436169578940831e+02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.6273998297026203130621083002146453880640e+02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.3470965030834657822240806219864645877229e+28) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-3.3324882713548658321491684584402729378915e+29) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.2750284526955556199811767797629765123524e+34) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-3.7580378964503017602991111042178025158204e+34) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-8.0851661637804517997905074369239848622097e+37) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-3.0092800429865663480250108972143708971458e+02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-5.0263011040298823461113281902021456174550e+02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.4084753191129434034646715231415153786790e+02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.9045582724571701122344272511553662276284e+28) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.9687627403876859148139369718787529452087e+29) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.4271374653883613490143811872865691822115e+34) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.0891040386749356843412378907487144693700e+34) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.4337572292169606145988989387202716705934e+38) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(7.7534527304560870149165975907884172125617e+01) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.8871820261693350461524873572390654721770e+01) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-2.7076040435533373612354137794575603742745e+02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.9576498556539443201425311792772438711013e+27) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-5.2198103562029807556365150460526427929626e+28) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-7.0797567264579697256825484488665677408069e+32) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.8876441100194431297773657937034871574047e+33) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-2.0524675287686124101790001062716428504020e+36) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.2180129640505299024212728910020842177395e-03) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(6.7118795511070813360353713416022698545393e-03) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.5526529027522081723375829657990082187377e-02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.7861606995704192859795438094691957842781e+04) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(9.7778206323948035605938070153706963416294e+04) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.2677379775325357868830877205512758586684e+06) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.8388240557271047831767058767325912936127e+06) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(9.3166603083591040524100188311046296713663e+07) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(7.8114815127733199314288275784576914285324e-03) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.4131645922967718573780469892029106012391e-03) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.8950578724369917045780578344402752452013e-02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.9471824469266753471174983578768745261234e+04) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.7871618252071950161116786517731586910977e+04) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.3572201310366537001567321401512208619003e+06) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.9761450516628002472152878820872448725861e+06) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.3791268709051659267094781765997945969809e+07) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.4907189675205620323348357352186837352668e-02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.5947024183853867498272048257786117049806e-02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.3156116911197144007310566831431782325537e-02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.9105865303603909525288711223139553629266e+03) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.1279330238555372343316502695245968851820e+03) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0218703811040556805649319582580891546352e+05) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.4077520439340366990728992591248113503033e+05) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.6243230374287946009211069180462272907193e+06) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.5803217131971869309271599641839238227245e-02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.6894605204919946149379547524296978455123e-02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.4860919020782908967613002924041625215220e-02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.4538881986121902756559512410318134095973e+03) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.0893785501695599183197361452835739188924e+03) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.0520406868995324731550843639865417437117e+04) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.1030990014132543115827517766882217795720e+05) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.2228545469923509241170662131745426961904e+06) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.3093260939672613266662697924075771706546e-02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.4580616343746946267107183241749792644518e-02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.8210498228460225751542489583116581354021e-02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(8.2256882238473525348253813681408785220742e+02) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.5428971617091929476367864356582699723163e+03) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.7061732769438569897519154411210473351485e+04) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.2491042351001906465648971466134341104445e+04) },
      { SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.8864187493376784856836317963757461733289e+05) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-5.4132236974135791314006017425784708283678e+02) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-7.4009909335072221413026574929254601084743e+02) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.0569313714867408054770601229018771956580e+03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.4961519161539129024215006175175591300543e+29) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-3.8134287566067326776919110122064786371810e+30) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.6081675137803804589462672565551117631936e+35) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-4.7868736121632138718273158677773445818537e+35) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.1035855110141398305900559131923731238548e+39) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.4405419514594595387638857598859581689522e+03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.2335900531580892059703763119635507558171e+03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-1.8564444792139164363421923027419694875157e+03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.1974771726627566063771359492776328981016e+29) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(7.9061762977637333568185553863225280746621e+30) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.0374913443125772484345987415079836970647e+35) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(8.9603393976529484178536561204253133719801e+35) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.9429314163848860207625959880429049301819e+39) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.1926314972100495074333090773426228790611e+01) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(9.3494671029171492419322736315779795029749e+01) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-1.9746581601955792202571864956447199083108e+02) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.9651317508987821999827895812757522537539e+28) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-5.4086257970320402813617252501330468513977e+29) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-8.1629915919376370083593531644310725218566e+33) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.2000076691112650873950653592931577192784e+34) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-2.5789936525142426310108082555989525083994e+37) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.0723087311809685338336964292771988533575e-03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.2748668186383539273602726824256895014152e-03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(6.3332042980144931093421740375891833505416e-03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.4770621101388774236302111334624067372865e+05) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.0857196618204909315465202611412392396905e+05) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.6943423144660454926622635395619848900898e+07) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.5624939552154766247768906222278829722631e+07) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.6990446668258114771033417827105912222809e+08) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.7539294903064294855009228998818568507046e-03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.0146198387556582866311125494564443161620e-03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(8.1143907040009038395402561589244671558995e-03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(7.2967997568793595262089606147657065639028e+04) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.9231596751333722977932006453348006231574e+05) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.7912142816016820977350691981973753363175e+06) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0103427572018014538628750350336732457996e+07) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.0016421400656199139567934249977880804870e+08) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.1309400449575099853700722822324896592808e-03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(6.6544789683869301381625162877622657900664e-03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.6197661082422902425978252333048621214144e-02) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(9.5048975983703960693348207315423974029761e+03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.1485925079873814582227306474475473415392e+04) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.5060129576083467491927325333443348584692e+05) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(6.3507229504527244924976405503504548638611e+05) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(8.5717228110591731917370588969744289668087e+06) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.5882658234353068875398394687561202253608e-03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.1450765469978474492357152016863704896345e-03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.7227929076722798885102202914358068502524e-02) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(7.8996275394214982758660655146858006259410e+03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.7591103546899949158214556988369435809575e+04) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.5024703619720839920638438424088170720216e+05) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.9094230369762025111121705765094650264643e+05) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(6.3720516341727360361528206626080833402611e+06) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0502087941425127210155052219772551161994e-02) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.1328005955413728071689008717040896745329e-02) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.5642155002586489556908794260911387529277e-02) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.3937560725334964712643668171337656721541e+03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.8167765611929755671629263674311165145201e+03) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.7180777293617384516836867591859443403808e+04) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(9.0663848466758588279732986224557083235809e+04) },
      { SC_(6.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(8.9520658230763742943722618037034073893214e+05) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.9938611831227340936710546870224365733887e+02) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.6689582314847351956402590827369625564324e+02) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-6.3769910533739369531442916384582794600470e+01) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.4214279124535823335210976535855077873114e+30) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-3.7308887074493962786088495368237673474437e+31) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.7312990236540240526876525002497785483829e+36) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-5.2035521449495341558931048618540766064111e+36) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.2840392492884478822686222965055539248761e+40) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.3655224599603021609088412718445098825998e+03) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.3031066629835299441525578436557989380705e+03) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-5.6227650148940271241719082086336194802067e+03) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.0118885582795253601565493479128668145661e+30) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(7.6710190341196789080613588950040543910363e+31) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.2454401082556107501149055026428288027471e+36) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(9.6676636012706568770137774220759816611493e+36) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.2448652639838930138942283530572744413936e+40) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-3.0153763239707559839195671029091149434075e+02) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-3.0550250380431753573266645795631408921038e+02) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(8.1477894971851766910721271356486556197828e+02) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.5523753682320170592386598825650030807575e+29) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-4.8086492049406465689400654866401236834689e+30) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-8.0581308224293160438954645426304382352032e+34) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.1947670069418875909974593709957292221701e+35) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-2.7697444709266119571115936794212908497779e+38) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.6746646732660482576752360866275022395818e-04) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.4562846109285733947111137159834891666808e-04) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.5167962101996308483667247961205355384131e-03) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.3166583902265701024308778773252167022817e+05) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.5662256846452828781882061165120894008963e+06) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(7.9251876142334821170925748880312458277493e+07) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.2222866386852021286799576382768214610367e+08) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.1090329859879457856085111943359837777142e+09) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.4291193310520496500844352650111902648466e-04) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0496804865847534108908357776816271489764e-03) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.3985034972739645507367487088213999927115e-03) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.5344420535446952871943263873353154525456e+05) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(7.1189266121075796947560805765269806241416e+05) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.0765125662051256469740673955133905503841e+07) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.6690463391429310669795234200258038532205e+07) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.0605140783804612693387865684741503279403e+09) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.4757081988862593841582958662255191864838e-03) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.7275142509609550020336243317152233135285e-03) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.8072922254557259965607127146206042539331e-03) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.9225583108742298039269686937534179518295e+04) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(7.0495344136069365218804931947708209848156e+04) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.8231833494789600135834965801774488602473e+06) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.6238660880785452216728153618777903084859e+06) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.0913857742306563035377459318526436696997e+07) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.6988957597717060512161960712720375144935e-03) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.9704793185517743981123499036885224808425e-03) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(8.4053872980306588937138382436328412409560e-03) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.3983326931054349903005434744421356474948e+04) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.6989311576043535615734335730068582756688e+04) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.4000208331085696543933597641517537240532e+06) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.0040481805438204660318347099058154039709e+06) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.0071032439902142236785786119218879816077e+07) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.7146302615591302528752879733185328102215e-03) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.1550240173309115556195205241987326294413e-03) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.3512319117172168200978238599166888419401e-02) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(6.6431094075808804156658513697610238443492e+03) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.4255974249266755805731603211548277802744e+04) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.4579328332897881829457281866090257147108e+05) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.3890629890838767086972675410391113876532e+05) },
      { SC_(7.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.8853630841392682555388855650535669491074e+06) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.2057426451569048789892104974442719240248e+03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.6910126059932924946942571506175813290292e+03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-4.5643297851104264923181330235322661646390e+03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.1872202987328167773180028974279294230465e+31) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-3.2074126869992798064374332866536670090525e+32) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.6352123927376812972655078919087806252836e+37) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-4.9618136215105382424520702542021056621278e+37) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.3090786051017672315552604179694931402772e+41) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-3.9036522543352268984974287915675963907708e+03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.9218744386017295036679521276224163046500e+03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-3.2304916538178726282698795394436802068356e+03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.4948866236928689073223647677625854011322e+31) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.5418912033796327280496664548681978463802e+32) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.0429517485952985794309688022448440574632e+37) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(9.1519003817206690559048135731703569975268e+37) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.2731499057201728361975510372145537226034e+41) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.8081364686965047873004224454813680479888e+02) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-3.8584013942664074984517791113779200563570e+02) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.6497760760128431202747464105705971313263e+03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.9382804843533175056802619731359933050975e+30) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-3.7692024947231602888638911479078356090411e+31) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-6.9986734322978094624049911856701264776743e+35) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.9260198232363703467627818801600779086685e+36) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-2.6129397983893839749596202426592868760230e+39) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.0695491927003407964110110451134150454335e-04) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.3543913897229711339732321942750384948889e-04) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(9.7164282498635922919125611588214303468437e-04) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.7921622340303637037288385309422292065633e+06) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.5975166561776564550666695795766069569160e+06) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.4101531140550441578626348953524282656865e+08) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.3567553551820842397773142547855343328759e+08) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.5458245701079599317071086697004729122188e+10) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.1259256127599508277497191618307828425693e-04) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.5412192493575016292781236166817671474017e-04) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.3892442530875760852028387281165562426045e-03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(8.2728151777045236433655211369588047761693e+05) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.4651054316694540331826250794973469519696e+06) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.2857491642707044055402252379902980941650e+08) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.9879732060631284486373918351441046688899e+08) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.1331198837102456965581545005995554628235e+09) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.8019772472131779808062165575576209521326e-04) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0966177071567890234363372712092441858973e-03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.7093669497909895355605506438123837581021e-03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(8.5473274014829307709609926227431478618552e+04) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.1894275199157748910815484762596965306111e+05) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.8768624316461582979372431447549413743015e+06) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0091124390576512799452792251207151637887e+07) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.7999947274388917584505368921998368375344e+08) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0850112220400744669459151254924808775850e-03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.2124552626696814164804937057584898512700e-03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.0451593148157149305491698840153340507664e-03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(6.9343154705215471736222017889435385709773e+04) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.7498414049745811887724415091629461788898e+05) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.2229797210624476247541784791950823862801e+06) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.6236003772983515836550183696123715009288e+06) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.3093453309696299501422710285391738347411e+08) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.0876847318486408921952360954255808864564e-03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.3147178401768745576517438236166411808492e-03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.0509366924977854737866071087313862480062e-03) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.7709094880810400115913407433052849537879e+04) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.0341702254331694743089385878720874073808e+04) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.4648213093196238877682662961066743247710e+05) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.1905890015769394306958431319437035068114e+06) },
      { SC_(8.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.5678150807125617992038688196907493887789e+07) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-3.7324392505344974361579508482102360994685e+02) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.1005639085969027674388758071277675687805e+03) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-8.9227247920569871662111886391612750759584e+03) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-8.8924688700441367353765163462993596783101e+31) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.4716143480997864305428667453192636738454e+33) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.3823173859778890953145290193873394214183e+38) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-4.2339630366827687911425289451704527752955e+38) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.1930653929299318314291574333142840416873e+42) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.2751129057388580683184695454910868054452e+04) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.4425876407421481436738155189872791320456e+04) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.4714044503949057309236231781939965468383e+04) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.8537984136737686124420471221416447272824e+32) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.0020402833349073314811113384770557082447e+33) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.5541327153946244697553283071658494014224e+38) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.7546306627528909677182067141401419128784e+38) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.0580766435151315581367576482472626158323e+42) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(8.6695329490573927553478276512903780868397e+02) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.7221236491872283837542237296731599312490e+02) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-3.7052165360231836892022434197168045340099e+02) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.3242889510855384310829678218363889427271e+31) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.6564697965933969282231892548530190896972e+32) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-5.4548562253086746948965331023544437035373e+36) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.5164770337139824467311454911191661632821e+37) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-2.2087547515834925906123326588378162342598e+40) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.1478030046956501103312744883139419811411e-05) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.1284536687457731055026306090193989470751e-05) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.6315842168952703418415157603055496488191e-04) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.7177080050023705890928480522078823543668e+06) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.8865397999585975172359807485364159666907e+07) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.3687176494152743950201954102531270058651e+09) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.1875646107134609631532946647526475562115e+09) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.1136763010004721595289223495114025755934e+10) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.9979217979278739918400972233372842203679e-05) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.1534259200882739327033175451190704509972e-04) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.5285843205667918497403676779364416713540e-04) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.5629668827515804471848572570172744616158e+06) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(8.0715727943965147897713759052289559025636e+06) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.0237791513084260624020985501108847992826e+08) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.9050613179779534496547224035712224380570e+08) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.3040584441429912613914685536660233518578e+10) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.7991501985551572194778526574258355654590e-04) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.3183107902742921111624811577640643427524e-04) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.7353561633262961036928103393634685311179e-03) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.3953918918915421001813794884590668331979e+05) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.4907642837640427433458140136063897418101e+05) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.4455725566662795039898377296231542915998e+07) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.6546509890908993891065952307940816487787e+07) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.3974587303401976276168598103333714361287e+08) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.2744824167212220144678320678063083378636e-04) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.8518777645028123723189478146462680705016e-04) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.9184114820845134765939135212608217884129e-03) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.9231238071921394703707980446981397494054e+05) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.1336915973501119346387911925538816208679e+05) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.8387973170520357653867179012524990716534e+07) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.7334871842803171225471141979473960391259e+07) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.3299872758640404523900374558628357911745e+08) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.1107460283195995113533264672694185309502e-04) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0246917569357049426697613062857873445713e-03) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.6413453880198842887704977176513808346528e-03) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.5596168305427194788211426685575094572664e+04) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0984489839652272522134910610891944216311e+05) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.7697993190612354393533666525640479048873e+06) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.9689300383818039540835701197568399521457e+06) },
      { SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.9511287443143989764692155157690639883188e+07) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.1614736740458718279770549328398484560386e+04) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.0251197341325895115333581249355180009809e+04) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-1.9937214233197539075717655082101452360314e+03) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-6.0635850721539330977209004663010603386544e+32) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.7331286380010590037505785179268823420875e+34) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.0618032684104823168302560908749921179233e+39) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-3.2824184314904801113855500643122136898252e+39) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-9.8689018131109224820558759451914401610879e+42) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-8.2076062445749128138128345238876546117038e+02) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.0573732924465141063422829368444991516817e+04) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.9780185411432763795991438055654750807964e+04) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.2542909847900552512544640915298957196922e+33) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.4811181694912634209115602607797484557468e+34) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.9484276945730312954851678461422191985519e+39) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.9708981963640764686489096554018676111144e+39) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.6915342825842159100531602216886340621142e+43) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.8879573427407882494813555105529386133519e+02) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.5818540021978076335603194629641825828106e+03) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-5.2293338527751425120405282500320840817882e+03) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-8.2619073995239666509087798251671339767124e+31) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.7086043059041696392148134225172233669096e+33) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-3.8728924622759951729573284410287250658130e+37) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.0874681852331015791297289182757585705533e+38) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.6983506631641743645267323354863581316379e+41) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.7393487089042076353300102385431139858709e-05) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.0575611621898913299869400235156530503327e-05) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.3084700891969332725068823132391614629637e-04) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.7402380297366027030502705319197072047825e+07) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.0473570603518738783354189958266178321511e+07) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.1771564235651335806080374311093225482511e+09) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(8.4116318980163484332703909976657222825244e+09) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.0647058931087828890743789268233896148373e+11) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.0715989390591109821824773665737097832870e-05) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.6117014661534099298641549865361843282223e-05) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.1352672699110342663578327264615269715240e-04) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(7.5922022033390484108764690219660739552964e+06) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.5192574041515680851612693401735591353374e+07) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.8534296362159861635269160114939356730572e+09) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.9653752931590024705067516859037215767398e+09) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(9.6980234786303873402218035804139649421126e+10) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.4389056378054574991388738629437376522414e-04) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.6625668290215645926044226392393000344247e-04) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.9843731642281575194006082467979140537613e-04) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(6.4693519845050335416658344760445700382158e+05) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.8484330438756374061039555552468485289537e+06) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.2691607645757754555613656265082551827466e+07) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.2572109352440827499408833244518587605383e+08) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.8682703736264870206936866743990271284368e+09) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.6474440181310706391989022489659984038642e-04) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.9004469783949482019892845255377694854375e-04) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(8.9555849708192356130443203357021073482565e-04) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.1440053092799107658827506251424346938774e+05) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.4479577173089461755156282848386319981090e+06) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.1598494864748361539992059549826779480213e+07) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(9.3165727677799555806239665468602426518006e+07) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.0484243104840152332962908130692962466523e+09) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.9146929857286826371748369966913853927688e-04) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.4679877626939414460730254258486099493759e-04) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.8599689219523873429493971493991870775710e-03) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.1387152641929275752612051183317297630647e+05) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.8919807005867723585644785324790022377842e+05) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.6720138912788832580253053123844595062526e+06) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.2646417469103072577378477804886588663634e+07) },
      { SC_(1.0000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.1435741489481508121288721879469325881698e+08) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.3355977446854511894818726581288693001279e+04) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-2.0352796862500346860020807264819367212713e+04) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.4892382495516718407360501150863356407072e+04) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-3.8085331835799707035374489580878634086773e+33) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.1189710899892136595889796478192931516757e+35) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-7.4993698519739021052937231413689679136727e+39) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.3395138338592140086865952747011302491675e+40) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-7.4979619196471707620295604114142884463639e+43) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.9652210780306068974308160149806470924050e+04) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.2538534619493954257474661101874326185083e+04) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.0890907083066218733086557203943575070019e+04) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(7.8190993208945603440575999843463241769435e+33) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.2311338126733926508672329689199098135324e+35) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.3669547623504567278263493810518560400323e+40) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.2275269983229887434717387822915021900111e+40) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.2771596673859528832273784083189062912085e+44) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.6360933981307260608802479585049968667877e+03) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-8.6630706326977987599919185280014495776269e+02) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-6.5503581825133150617731475847750673594632e+03) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-4.7613427785842366396424397840868434836119e+32) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.0145954028884636732357654838977342956278e+34) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-2.5342405559558478431072765993235887638965e+38) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-7.1859260450929912301326430303242771364336e+38) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.2019231959884856951693936522052205971060e+42) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.6516134278148635436792382376557742837141e-06) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.6201810751869425876766150571424308375912e-06) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.5204001771678216294191207294569777596915e-05) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.0837930404757451183721108253065695384197e+07) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.8558459714126800047674468226644880581662e+08) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.8600745389751918431644675544832636103640e+10) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.0699858677763923880351898029661064611234e+10) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.2469670217751493281040671491034517338720e+12) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.0156217407951713704455495132217402452094e-06) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0815016705312372954387961836195335161101e-05) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.9735552944411030485018515152902107424906e-05) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.1627984897707658878583437446510208573097e+07) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(7.5417306956928195545220711008143720205343e+07) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.5056517418767145087710475098707114670044e+09) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0575162964976134888031775319760201847429e+10) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.8606460381835536424884458536596453904303e+11) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(5.3142269623827792855717438104732197632156e-05) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(6.2454730036982367176740908564612943543664e-05) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.6078809393116257410542615560966687785648e-04) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.6912699376140049526542807784983128380263e+06) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.0815814187999395886386480135269469641159e+06) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.6758225685806695341677784970664616131859e+08) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.1353827467148516775922433720581189337679e+08) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.0573081726798251882694964844754713072329e+10) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.1998402045045660133486789973239984349650e-05) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.2726401425347569516995505950441919917061e-05) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.1099925681161000068413672319022891642045e-04) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.3327801298426484717161738470155217823295e+06) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.9451536563001466936673541338788150473604e+06) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.9760523848976227462121624158732053092452e+08) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.0381896412190879138049436142195499908024e+08) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.4887275106733949043374497630593713546560e+09) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.6543524595664340375202192911208979280615e-04) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.9169052727354204210897395733366089292245e-04) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(9.3902829854490501449237694493412446507138e-04) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.7677873345565107775663281494372541445780e+05) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(7.3906428967396206105295954022563082735618e+05) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.6122340989569776195458411974849342856909e+07) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.8734130033265260484229092261081458804950e+07) },
      { SC_(1.1000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.3763152924614035512758363239758839358629e+08) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.7592430765085063846635207879955313285262e+04) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.9495371330629069607432506420105187084795e+03) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.5978676810038947176645068579803702533471e+04) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.2243257705163891899993908238520354655558e+34) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-6.7149717952595177387845239084649186644445e+35) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-4.9167162489305132126342209956050061742033e+40) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.5476398542687605850510201505798525676170e+41) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-5.2824224269048377240329750983872660799885e+44) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(5.3028455880991111797856048510805089989786e+04) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.5109104659650365585532355444639376355140e+04) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-5.8345799984908899073642579851687583207782e+04) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.5333898595844694532889495388251111419223e+34) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.3294174398052877990348980633123703866723e+36) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.9037612806059764895451889277351833170268e+40) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.7785899744246981317361178311643307292152e+41) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(8.9432696454953214645477968357865050874933e+44) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-3.8166675651254927177455388377771722648565e+03) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-4.7430239452093391127466848942617745390301e+03) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.4081536692956088505252740903427455946497e+03) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.5582586382880623987321415772340209091244e+33) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-5.6141714411201153621097860753827136750258e+34) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.5427148316917101320479233911212368362347e+39) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-4.4167548834909470357458577647296653317543e+39) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-7.9029646198216759794913080723040331321649e+42) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.1643788967611096599074507407076012532199e-06) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.4388205619482923088821221975520797891392e-06) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.4870292893107871971649744033951588365828e-05) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.4323845116318857294585347058080133568727e+08) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.4808383474202337490332344623861737071527e+08) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.3875177415600633185964113211196958638146e+10) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0702159311651037477148323827487121764976e+11) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.8250287682343581240478026134572738521958e+12) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.5109603223698615092453133287725438703888e-06) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.0764043662260994873935496503011054583703e-06) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.8652600897458975901199149802559961930839e-05) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.9520198373442127803437352814027399847948e+07) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.1761408876838321842307533223340052423432e+08) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.1856346910548538523824763642331877974815e+10) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.6072291698659426039411432225219398465491e+10) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.4633593517234224012838324380574036745472e+12) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.9091578110633258246659912316468152271020e-05) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.2836797931131701787440866764801450496935e-05) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.5985359109454746799307181213530826574619e-04) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.2952105279095944609247788496186126413163e+06) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.3539341742968018050726328095574536558661e+07) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.3292643858131484106568207135668648913415e+08) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.3075469962491738572672875528362080896652e+09) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.7277631756348930237858005457888976395675e+10) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.2731046693338260311846766759326563666027e-05) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.7131487637939917802547477686114050660218e-05) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.8516015740207978106622886664972503494667e-04) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.3564956981983164478192589073321930261706e+06) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0423802190246341704666905941210022958299e+07) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.1012229745644397309807873613411993545721e+08) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(9.5288822014677404075783546864439237417934e+08) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.6198520394985299490852034168798474322812e+10) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.8677742825582682254398524042460516759616e-05) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.0825265649441432614891950541459941051526e-05) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.6821563887422964780060735528478326121117e-04) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(6.5657591035098759197815894444131662382262e+05) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.8390906370185226763727647580587225244582e+06) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(7.6036752017347347608153631340488512073106e+07) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.1455267052449901197216782854822700861357e+08) },
      { SC_(1.2000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.4379370620566497511337777378855100720766e+09) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.2513599050734647713145257644814260580966e+04) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(6.2544431407881929193770779756261064350060e+04) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.0935326664364845157536982144439801198061e+04) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.2172982466108172394667723868596626101977e+35) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-3.7745034565500890205608652460245992843782e+36) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-3.0155902775624129225764707145473711276351e+41) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-9.5764902003115965738787816983637604715384e+41) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-3.4780409696914187606383243617252084628043e+45) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-4.1084313734868246077953897527133270222178e+04) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.2742791485015909040011414968409871580954e+04) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-2.0171675169469161961421668179314505582247e+05) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.4634142190714120334178325693941557793154e+35) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(7.4211960530381306975620108913249320788469e+36) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.4264425416072586925728956486388974379840e+41) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.7085559022892963253837894329490415786136e+42) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.8536483142654463608545561063942319762712e+45) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.5234399503825742759914810818575991485637e+02) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-2.5008257211500289235338597650449995666823e+03) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.0918705109784432762807432907970164030891e+04) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.2912223189746258330607891166919684302856e+34) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.9168009759642817052824204284681892158800e+35) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-8.8038212357520986322710627581312260323299e+39) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-2.5445090599001258038709089038245363052935e+40) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-4.8653784864026286524650753693630383124304e+43) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.6919443273813642606231463711532094744560e-07) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.4076907979865644077932321012066369968767e-07) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.6148831205007157969300256422728143602998e-06) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.9077274064853147723685051256045483969214e+08) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.5642328206866272908320029715664472367750e+09) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.1070512935302837700697193741726845873337e+11) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.5817636075603424390901273485351472736902e+11) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.7854588783626567184552772879312745311385e+13) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.5774056287325496078175075918674786515864e-07) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.2416142951603717864814312848970453129746e-07) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(9.8484295060553144387074748279731248852283e-06) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.5882411838032615725501906732660336500955e+08) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.0764238912044849451634653776349427961465e+08) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(7.0621492744858117748905853861176368783160e+10) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.1827007629564490434739856076702319955913e+11) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.3102857054595289962987727610434837648458e+12) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.6522806680157504787378558783573873398485e-06) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.1051115197594903634755627546587864524608e-06) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(6.9315618629844446485376205510404564465255e-05) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0627891534768020390156496790960527344991e+07) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.5075283606138220835500917983664773426555e+07) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.5045087294469057583193222780776510066757e+09) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.9910374766385191215137073462981207139705e+09) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.2632158296854425957098452062863893905549e+11) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(8.0980361992014848654936759045484066063747e-06) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(9.8420756610981493144549115201985900870578e-06) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(8.1747350046146228660965151704984485767213e-05) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(8.2398934123544638957361231394041603241646e+06) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.6792283725750585940194219144317522536234e+07) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.8205674562104643545780201569664087615195e+09) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.8864162327602864647170206238427967101636e+09) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(8.8128360617230998136239882264428879836874e+10) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.7967899999216943999379631425497761335152e-05) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.3447926672322867771867703562241098833573e-05) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.3037253077769061985471368145839766677934e-04) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.5235997759155266001456224876485543690591e+06) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.4676895635512015867571038643827841493711e+06) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.1463550676427331792267366355827641200488e+08) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.2831559013134190283583427822525725974565e+08) },
      { SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.7726164903084550210538688699256661043566e+09) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.1273183054931658588988168084514557670231e+04) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.4437018592488479706144391285503711725830e+04) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-7.0280873831547977102246769384659311447193e+04) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-6.2825398604742723420752000079724534451483e+35) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.0001125207602446021725971577527867420509e+37) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.7415159154354258081412757990003706195680e+42) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-5.5788971685392262155084605779057341336255e+42) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-2.1541540383483095001099156460926641484955e+46) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.9922609500499925572856287311339110440423e+05) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-1.8313435551074500484572637347207857475972e+05) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-2.4000713955490340226597314145306876877636e+05) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.2626313311249675947638505848790223481593e+36) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.9061339531286964824634163900570999906137e+37) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(3.1144858463534134148668348030018846564949e+42) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(9.8925898380287243556074324112198262341634e+42) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.6046365197547779387857048923403398232242e+46) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.1795190440348777815956963535691996453626e+03) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.2381810744637692416019167441690914618518e+03) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.5063287961763248577513356176311529931017e+04) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-6.1605176000446501368632244772496726033218e+34) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.4318075415117686934385813852233707862938e+36) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-4.7398591516399908114242738656046601680294e+40) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.3827668360215571948325336377905965224696e+41) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-2.8225542236304524135100862333194693057304e+44) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(5.6401781838937688147202584066928058668458e-08) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.3295127741589471759414983866450494976203e-08) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.3337457092133800422922237820235502276206e-06) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0355794996347246717450578296426802078594e+09) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.3291620587985106824505078343893433354540e+09) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.7042300990446523326854739568324093082450e+11) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.1556585878224788293095061989099894280040e+12) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(6.3474347457902232937375683512485801700245e+13) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.6013527533160027616998636983136391139994e-07) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.0554658462213796259459494518767022503447e-07) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.2122049553567862697591592453786979862202e-06) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.1218938527577293597207334196457870153660e+08) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.6473216794181153981057327995828839842466e+09) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.2034093385551399645549656496027322365628e+11) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.7423571827685624421423573114271759294410e+11) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.8531098850432580664761582356446139741160e+13) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.2402793423862229309301082432279801741372e-06) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.7826494857913932845529812956453997798066e-06) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.9349839607722592839845842973443537836356e-05) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.5683873347830375470331254015234712445190e+07) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(8.8587759060217145276931861347568866497052e+07) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(7.2996195376184129216148153659153689387791e+09) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.1801263911284826417491326841949687167993e+10) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.1307707495913200167746738529712615540864e+11) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.7944129840968912848687621801940452655013e-06) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.4610073909820587805340762417878820387270e-06) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.5297872155090430169653887659389490121932e-05) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.9765017712130302145903256875209624319280e+07) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.7166255685663956974900998983540523324491e+07) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.2679039601249423277078060630408755100850e+09) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(8.4736022813023240734286933786613958680594e+09) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.8618321511672213232068678315886648087832e+11) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.1154999023563122303823217207451941029455e-05) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.3564372821873567162412985792591971844062e-05) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.1173945201922625978320467768058783190715e-04) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.4652284855460343619885002307735784469774e+06) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.0618535581270598549274069583567769293516e+07) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.8928949845335141788552776605503444058453e+08) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(9.1468056348755553823411592107988682212960e+08) },
      { SC_(1.4000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.3989661115642276654421053548967013452639e+10) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.0189671192968487738328104194021442745549e+05) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-3.4553652257736379548621969001178401427926e+04) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-2.4725627775759766435378268427813107172303e+05) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-3.0743869962665380754608430250712123016549e+36) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.0045692003269488940547155676739744527586e+38) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-9.5216736332870901553892730005727218102450e+42) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-3.0765980914641994863542705909366434680796e+43) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.2619689485544898082628364036691383209822e+47) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.7977232985559360115788182126680389798553e+05) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-3.0355214750396291011961112598909871657080e+05) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.4476887727959560463335476319486670633185e+04) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(6.1373544607268562157266674263761731468209e+36) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.9490750152486778210931195345561079852781e+38) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.6926068386784156162424484068573170805703e+43) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(5.4229821512847401632816731786031281782712e+43) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.0998440740561618889851864877973734232506e+47) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(8.7744487067415206859734358743958925103437e+03) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.4656369100700904555669741028285160647304e+04) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-5.7901612978222565042287701323293183445308e+03) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.7930594051196708663563943145638935395388e+35) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-6.6759940699476830915787363353974695793917e+36) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-2.4204441480899276328183759554044088985786e+41) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-7.1263614529532929747026753776935349542224e+41) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.5513749695731437526113684593751771384247e+45) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.0406502821168609210344306758282400953648e-08) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.3921228389069040768274991727371504835821e-08) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.5214465726139056005610564872094899506590e-07) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.6730689526021913671478387321108106727343e+09) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.1652176232265388912731427321498348938895e+10) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.0646503272275357467415207443482109818369e+12) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.6073208487027262454478831071128307808162e+12) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.1762473288258289527227152341010687105581e+14) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.5638132808575974560701940750674360316232e-08) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(4.6957208291598052135583646638361096504376e-08) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(9.8339690592312539326635211861499631661255e-07) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0430753595968262159569681548144118705690e+09) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.3478053263417846532516980466170070019639e+09) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.6602947712077700831863182630147538558466e+11) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.1466985696061700822442036813241612043915e+12) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(6.2419454067428001031083457826030133084837e+13) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(7.2606008366514679391686284739818538123423e-07) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(9.2029594191471738678747055863930482293416e-07) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.2102545221666666884557340022510223677605e-05) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(6.0746295780540024661936756117233836579155e+07) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.1862286060883424301237029002029763805264e+08) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.0681950174968080822507128860229559354151e+10) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.3904992343535500336184289303308755699501e+10) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.3078680467603681473161459515948352903575e+12) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.3044334467103254602833307541967806312464e-07) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.1754691943739239501522673165205257926615e-06) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.4870765814286860993968033392111171255817e-05) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.6417931028888653956010445349109669247377e+07) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.6459193870489521627628878927799587180914e+08) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.4823173403606190238578151509717666240172e+10) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.4178369634947947569944738637205133935142e+10) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(9.0011658428191550973841729100059449268248e+11) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.3495737848639227495017719500856623135559e-06) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(5.3810564002211220329343273353159518133191e-06) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.3368749720730072403585944600830168426094e-05) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(7.7372238260946093023599470041336679036676e+06) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.4737095690116687930054364238114046176040e+07) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.5775520552179131177729236456016956474809e+09) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.4833949170780487704785504144155194199135e+09) },
      { SC_(1.5000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.1893791174537129952568244838405304391717e+10) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-2.5596993257047975950171692795605225775800e+05) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-2.6390813251926818064425113412490038100096e+05) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-3.2041587384869412867755871864312193312309e+05) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.4330718851787391160792752742898592459802e+37) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-4.8044460024025690977003172935892350893407e+38) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-4.9517264016349038443655547272300629375369e+43) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.6136239412197947754706019192030949650605e+44) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-7.0257499897569673760200856045019875877819e+47) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.2568657342083863816054328950209768312998e+05) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-9.4075301410023574472692827240800143909086e+03) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(6.7759133692717238800618420503725997516555e+05) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.8421584492032456950587949538812460967990e+37) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(9.2623534238517552784689416600765290194742e+38) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(8.7508002639264952892766647006883827311044e+43) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.8277375380358917494768838411190042444620e+44) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.1626329741222449527050179154677912383476e+48) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-9.5385465564112457715954364383859350183348e+03) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-2.5739923259620809346053272906575228135326e+02) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-6.2457157021015650715226766524467590321653e+04) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.2087535313629738803026902004600503821225e+36) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.9700059476878611516635116391748659438170e+37) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.1777266598772531189647063907232953700803e+42) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-3.4990310872598137186425628501258413709843e+42) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-8.1160705366565769877451090309828754459036e+45) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.6116844653461771656386258287624281252854e-09) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.2282175222484553495173240964573758222117e-09) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(8.2348321186370462107518216983124885000211e-08) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(6.7359487431845047255823585961421504459569e+09) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.0575373958022436401985018124875431766649e+10) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.1720569463154063526277083443769604999418e+12) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0925555816521440121751100364728689810369e+13) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.2191449258258906198061332442861932062191e+14) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(7.0727547953305764087827496193454289561588e-09) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(9.5924041664239199654334754016411112560452e-09) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.7815135804152054187897576204497666152422e-07) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.5793821235788861056073588852770187284998e+09) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.1197825683734237311348634056320781783308e+10) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.9559166931174725527497682108092499281536e+12) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.4121282937382140958646610967466541684477e+12) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.0358373455036994665998723600305129494844e+14) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.2524551063939947225637894486577309803800e-07) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.9168564926157280349456027761822890479716e-07) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(4.8441076880209751232561791523159348960395e-06) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.4086079194300535695089206588513461181644e+08) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.2820534060405492294925263118864819137847e+08) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.7102874651493238337719065170360622261920e+10) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(9.4880029904869225008654438795587937328544e+10) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.0207544594843186936082788464876921969440e+12) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.9752636038646865587756352794260430045709e-07) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.8381972914634016255298441009595901072938e-07) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(6.0949506256579957626258401747283792990096e-06) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.0691387938671699119948436443447853553066e+08) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(3.9500233653151581032315433899154372869476e+08) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.0659428324476359673288829022125509199904e+10) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(6.7220606267334184511226879098069670948793e+10) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.7497654433767986976879864895926410855731e+12) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.6544675771712500505460088006960008830606e-06) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.0838779526920233196203780793584233515245e-06) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.5067598306692689718050121170751115417649e-05) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.6984349573450765382103197510004043058431e+07) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(5.6574775048000964060962100787800928029848e+07) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.1265316562745503824374588268762542744690e+09) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(6.5851003235262121028646697942947458961378e+09) },
      { SC_(1.6000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.0973471680932398974525330639524930044786e+11) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.4815985335154663736841002793466826857553e+05) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-3.3308056695783194924167364733587209605681e+05) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-4.8985477239817686043584881237362692408043e+04) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-6.3883484214042708355992534365735387676891e+37) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.1967240132940128094770470663788091153633e+39) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-2.4592717506945782031242814606799410501453e+44) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-8.0815358206525686013343181206924930264183e+44) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-3.7322640214558472614153151767234252826366e+48) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(7.6447181250679968588760460842172888678178e+05) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.0396775539476298247617628101579590706148e+05) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.2310242949687608459404164451234727789111e+06) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.2589222722485766871347647817092552562399e+38) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.2087438535642090956817373416187878657481e+39) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.3212289567110206360731839036906194221101e+44) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.4081876483703102263545156574998617033300e+45) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(6.1431205809108473032421368353858221423522e+48) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-2.9219159777197381808632663373807621821641e+04) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-3.0303657199150940654073779117579667292516e+04) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-9.1287674148496252673768089148760072707670e+04) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-5.0126340194870483178122259601901031720974e+36) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-1.2655898463567114015977797463061297653042e+38) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-5.4818066311872606131057934021326600220436e+42) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.6432411441860128687735056661648576557412e+43) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-4.0575058131279506532729722534733220641839e+46) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.9073105353753561751527190647270817122344e-10) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.7427236159440872787175987644681258508944e-10) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.6107361823280631744793115627241827969346e-08) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.6603576118242722528752909056200439356855e+10) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(7.8380213969315097723784083497405640137136e+10) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.7954699205930897746491385031716504342594e+13) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.2188516292203988580468824775110645921372e+13) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.3234465732775347987391685128488974398692e+15) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.2023879370384453416458833280326445246260e-09) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.6850642678367044067314418208905388208787e-09) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(7.0919204460487056060226592453898629446561e-08) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(6.2446177810493303107805471327802257483837e+09) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.8199125150432291332844597112619658613279e+10) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.5938173218424204631831155815094328696346e+12) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(9.8839970121308039757220329611162246044194e+12) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(6.4467506120360756336862151917606276122795e+14) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.6432461952001214376001681116300429925435e-08) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.8013186603149774942168375420272213005895e-08) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.8742702516938880532862175406260444795518e-06) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.2072463634284744177547981321715839647171e+08) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.2514566001458643787940026956134750049963e+09) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.5396077686969825872596155802300479469335e+11) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.5917373367677306719379256035881448935097e+11) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.2031397981717678269180028008555212069453e+13) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.0825308928447216336629040693404333221275e-08) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.1979751504879918401848360933638857624792e-07) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.4216298634518939232145770331549958896708e-06) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.4187311055123889130092685674268038981966e+08) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(9.2988563012810701961619019446603244756044e+08) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0894169260123076655960176051915246099356e+11) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.8247739062405275283231870669477134911358e+11) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(8.1785444031196226524965743334173893010207e+12) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.1235146612970140263556298938507465054988e-07) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.8586934776899608589435592695040806662883e-07) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.1562029139497000417532356860894933201199e-05) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.6699564218412738268446492715692564741414e+07) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.2719888563898312828152157710002831094529e+08) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0566322221983283299929606505980172108230e+10) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.7085572947995242604077418371783723656910e+10) },
      { SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.9690543053029434392808865600172906663242e+11) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.6165736835767878644135140000215512897412e+05) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(7.8047540021403118838321580440476932839608e+04) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(6.4409487904894439679921099076173363236706e+05) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-2.7328811442486941796379786997467555264471e+38) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-9.6356735566630280576092575160717882639378e+39) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.1705387729025244843236819692095101716251e+45) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-3.8785560885081304507716763189529605832162e+45) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.8985592736831625036206467623516153121273e+49) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(6.5451186812249808295777537966610980158039e+05) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.1275493861586761599490371333688461904472e+06) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(8.8041228857273466097538984943355159313975e+05) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.3521693175376653414758039396493218366860e+38) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.8349499950781180328252501826799775439522e+40) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.0452884152765555223074019633516441407904e+45) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(6.7208498292115215747703140713579809331000e+45) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.1085667749551625876822282193832562978539e+49) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-1.6986992154462284235067629503647919753761e+04) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-3.7950068973930216145562111568103618532087e+04) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-2.8663594011808667156487644509554379322210e+04) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.9985736479913821053270296065008321005065e+37) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-5.1830543944068195478291749057144011955773e+38) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-2.4491728977428232530652463705461373569574e+43) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-7.4065755518698005593361565608791127896985e+43) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-1.9451898356640464449348684121960960465201e+47) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.3356293486260747594303278179515432877892e-11) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.0260755131086295390255895043658989044237e-11) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.3007025137339430958587753888629132761728e-09) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(4.0101120221491687588763200830097343776524e+10) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.9665120406535919024728360496931064544716e+11) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(5.0935760838097109209825568750116524250944e+13) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(9.2449072218191366770988501215218768153925e+13) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(7.2725507549076434104815148832410847237932e+15) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.6242336656822683649109780931579337077379e-10) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.3666456716493865981682400125009769213391e-10) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.5613429808617798986516073934103289102792e-08) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.4824748943312980184707869920025337530354e+10) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.9554601315101996458431647767359117480659e+10) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.5612328766542573507338381548263549086985e+13) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.7930959687532439125388519741608128825834e+13) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.9866619016715712475172634347420771366470e+15) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.8459861741344611011540764076606435858793e-08) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.5063718782219870679958451754683334084837e-08) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(6.9734716874518077213519164588193325241267e-07) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(7.1799636924449806204220228408338262437941e+08) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.9117974040382364829321484437104836164470e+09) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.0610300083981275373019922287840384855875e+11) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(6.9233510109196568481554048922192381424663e+11) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(3.5115656938102120858580708584851187823995e+13) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.6264858734362612993543821489049977127287e-08) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(3.5475786488366569842478823679076857893502e-08) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(9.2851760119798901032833079837812138899618e-07) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(5.3815719065179922414771246024549490776604e+08) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.1503629719541206202066043653409695820576e+09) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.8563794278630683212289205219633075883283e+11) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.8455049726365247322360254780547282237719e+11) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.3732314242684169030516656417988955826572e+13) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(2.1986259557192046014373031169775022086847e-07) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.8775863610518552406306060865402862485742e-07) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(5.2274336073651877893634414472092999041141e-06) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(7.8143488460716153909711266580538588441031e+07) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(2.8148269249140183301148569737735265192709e+08) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(2.6526912426618058897903888035083154073974e+10) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(4.3446109622115190795798399163072002925780e+10) },
      { SC_(1.8000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.6604091854095532769468808416615599463736e+12) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(9.0580094894326798142841506247390010416809e+05) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.7391798366026123273303873605740449603300e+05) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.4003554138416760727001816160276895219678e+06) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-1.1253294413502100705034708679071920259687e+39) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-4.0670856229901610729084063838208025505175e+40) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-5.3558807399988705610166830023042830557155e+45) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-1.7892411421404929021771102455781188129912e+46) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-9.2767811918441110165529514411272561611102e+49) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-6.7413151959956082396511123911474864719770e+05) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.3906984603500919603849374814838991259459e+05) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(-9.8779825942721100224307843327797566279234e+05) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(2.1905490334400416433857502468430773448775e+39) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(7.6993423616270048844239286431652865260366e+40) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(9.3072912892204035170310511259736748926911e+45) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(3.0836525128686976104683915509894343393249e+46) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.5111339384918198897613128731306879123182e+50) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(3.4781361051755061095791137531240978599788e+04) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(8.7762185723986828975067988152446718297550e+03) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.2773230491219439113132398842233883269383e+05) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(-7.6837614979701456820826284177819366949989e+37) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(-2.0460505668350094383116786458762579107424e+39) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(-1.0535003275538729654975010112235181594139e+44) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(-3.2136711364622411951321748113365045474286e+44) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(-8.9696294278155336549120133649090386867265e+47) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(-8.0948170419305541362861081243911929294809e-14) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(-9.7201935051955247648238380303175704529862e-14) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(1.2579140296725773702102980132409020487307e-10) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(9.5040214100652752015228890738878208658292e+10) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.8364587103358189897390545014428466301817e+11) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.4118072626254712031152218514978979889619e+14) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(2.5934140808569487893851536260639736723935e+14) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(2.2184606756298936837378783439157094149971e+16) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(1.4510627566218038404714887556239626117647e-11) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(2.2264719519894120069599639434334562769318e-11) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.7090459552686698639441747523185937224548e-09) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(3.4559933276786651429107749757792835601418e+10) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(1.6829033352098491501606283387809941008186e+11) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(4.2600355877825892374729475397514482028067e+13) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(7.7140455636037578772642694005351830674554e+13) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(5.9699768341509256350650123151762936654006e+15) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(4.7734638712486578839259400300013587210763e-09) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(6.6563988961722059350946467894913609359886e-09) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.4777179790422143225270684030884946424302e-07) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.5822158188052132187297897877745889490035e+09) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.6617487635509954619514271294875628915699e+09) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(1.0496023110749649655395742753837157034180e+12) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.8115613483139045214738019872952149693390e+12) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(1.0015122045028095621084817303361342984621e+14) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(7.1206715382465573476970268581778307372646e-09) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(9.8682080987525243418673873775512123462077e-09) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(3.4157255327842071567821610795562527419734e-07) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.1789448226007626835790402945784435614249e+09) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(4.8908537858870160654329414995371469496558e+09) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(7.3401453993505697447343177386876780111508e+11) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.2606199568756346082511449147103470673071e+12) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(6.7308975315302781016305361824663266984848e+13) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9841056823730468750000000000000000000000e+01), SC_(7.6295399432189323162542831232082150482646e-08) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9161842346191406250000000000000000000000e+01), SC_(1.0194297154567438456087626808728266472124e-07) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.2317276000976562500000000000000000000000e+01), SC_(2.3119032708921826042467399899541287797659e-06) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.5177894592285156250000000000000000000000e+01), SC_(1.6411993227997707183522199448336883950595e+08) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6800682067871093750000000000000000000000e+01), SC_(6.1374461568405594813525139923227866410862e+08) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.2463348388671875000000000000000000000000e+01), SC_(6.5384616052888809928433157372272489553006e+10) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3070068359375000000000000000000000000000e+01), SC_(1.0842828456086984753186911473077983080517e+11) },
      { SC_(1.9000000000000000000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7509414672851562500000000000000000000000e+01), SC_(4.5218251677481531875880698139531607502434e+12) }
   }};
//#undef SC_
