﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using Mono.Cecil;

namespace Mono.Linker.Steps
{
	public abstract class BaseSubStep : ISubStep
	{
		protected AnnotationStore Annotations { get => throw null; }

		protected LinkContext Context { get => throw null; }

		public abstract SubStepTargets Targets { get; }

		public virtual void Initialize (LinkContext context) => throw null;
		public virtual bool IsActiveFor (AssemblyDefinition assembly) => throw null;
		public virtual void ProcessAssembly (AssemblyDefinition assembly) => throw null;
		public virtual void ProcessType (TypeDefinition type) => throw null;
		public virtual void ProcessField (FieldDefinition field) => throw null;
		public virtual void ProcessMethod (MethodDefinition method) => throw null;
		public virtual void ProcessProperty (PropertyDefinition property) => throw null;
		public virtual void ProcessEvent (EventDefinition @event) => throw null;
	}
}