; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc %s -o - -mtriple=thumbv8m.base | \
; RUN:   FileCheck %s --check-prefix=CHECK-8B
; RUN: llc %s -o - -mtriple=thumbebv8m.base | \
; RUN:   FileCheck %s --check-prefix=CHECK-8B
; RUN: llc %s -o - -mtriple=thumbv8m.main -mattr=-fpregs,+dsp | \
; RUN:   FileCheck %s --check-prefix=CHECK-8M-SOFT
; RUN: llc %s -o - -mtriple=thumbebv8m.main -mattr=-fpregs,+dsp | \
; RUN:   FileCheck %s --check-prefix=CHECK-8M-SOFT
; RUN: llc %s -o - -mtriple=thumbv8m.main -mattr=+fp-armv8d16sp,+dsp | \
; RUN:   FileCheck %s --check-prefix=CHECK-8M-SOFTFP
; RUN: llc %s -o - -mtriple=thumbebv8m.main -mattr=+fp-armv8d16sp,+dsp | \
; RUN:   FileCheck %s --check-prefix=CHECK-8M-SOFTFP
; RUN: llc %s -o - -mtriple=thumbv8.1m.main -mattr=-fpregs,+dsp | \
; RUN:   FileCheck %s --check-prefix=CHECK-81M-SOFT
; RUN: llc %s -o - -mtriple=thumbebv8.1m.main -mattr=-fpregs,+dsp | \
; RUN:   FileCheck %s --check-prefix=CHECK-81M-SOFT
; RUN: llc %s -o - -mtriple=thumbv8.1m.main -mattr=+fp-armv8d16sp,+dsp | \
; RUN:   FileCheck %s --check-prefix=CHECK-81M-SOFTFP
; RUN: llc %s -o - -mtriple=thumbebv8.1m.main -mattr=+fp-armv8d16sp,+dsp | \
; RUN:   FileCheck %s --check-prefix=CHECK-81M-SOFTFP
; RUN: llc %s -o - -mtriple=thumbv8.1m.main -mattr=+mve | \
; RUN:   FileCheck %s --check-prefix=CHECK-81M-SOFTFP
; RUN: llc %s -o - -mtriple=thumbebv8.1m.main -mattr=mve | \
; RUN:   FileCheck %s --check-prefix=CHECK-81M-SOFTFP

define i32 @ns_entry(i32 (i32)* nocapture %fptr) #0 {
; CHECK-8B-LABEL: ns_entry:
; CHECK-8B:       @ %bb.0: @ %entry
; CHECK-8B-NEXT:    push {r7, lr}
; CHECK-8B-NEXT:    mov r1, r0
; CHECK-8B-NEXT:    movs r0, #10
; CHECK-8B-NEXT:    blx r1
; CHECK-8B-NEXT:    pop {r7}
; CHECK-8B-NEXT:    pop {r1}
; CHECK-8B-NEXT:    mov lr, r1
; CHECK-8B-NEXT:    mov r1, lr
; CHECK-8B-NEXT:    mov r2, lr
; CHECK-8B-NEXT:    mov r3, lr
; CHECK-8B-NEXT:    mov r12, lr
; CHECK-8B-NEXT:    msr apsr, lr
; CHECK-8B-NEXT:    bxns lr
;
; CHECK-8M-SOFT-LABEL: ns_entry:
; CHECK-8M-SOFT:       @ %bb.0: @ %entry
; CHECK-8M-SOFT-NEXT:    push {r7, lr}
; CHECK-8M-SOFT-NEXT:    mov r1, r0
; CHECK-8M-SOFT-NEXT:    movs r0, #10
; CHECK-8M-SOFT-NEXT:    blx r1
; CHECK-8M-SOFT-NEXT:    pop.w {r7, lr}
; CHECK-8M-SOFT-NEXT:    mov r1, lr
; CHECK-8M-SOFT-NEXT:    mov r2, lr
; CHECK-8M-SOFT-NEXT:    mov r3, lr
; CHECK-8M-SOFT-NEXT:    mov r12, lr
; CHECK-8M-SOFT-NEXT:    msr apsr_nzcvqg, lr
; CHECK-8M-SOFT-NEXT:    bxns lr
;
; CHECK-8M-SOFTFP-LABEL: ns_entry:
; CHECK-8M-SOFTFP:       @ %bb.0: @ %entry
; CHECK-8M-SOFTFP-NEXT:    push {r7, lr}
; CHECK-8M-SOFTFP-NEXT:    mov r1, r0
; CHECK-8M-SOFTFP-NEXT:    movs r0, #10
; CHECK-8M-SOFTFP-NEXT:    blx r1
; CHECK-8M-SOFTFP-NEXT:    pop.w {r7, lr}
; CHECK-8M-SOFTFP-NEXT:    mrs r12, control
; CHECK-8M-SOFTFP-NEXT:    tst.w r12, #8
; CHECK-8M-SOFTFP-NEXT:    beq .LBB0_2
; CHECK-8M-SOFTFP-NEXT:  @ %bb.1: @ %entry
; CHECK-8M-SOFTFP-NEXT:    vmrs r12, fpscr
; CHECK-8M-SOFTFP-NEXT:    vmov d0, lr, lr
; CHECK-8M-SOFTFP-NEXT:    vmov d1, lr, lr
; CHECK-8M-SOFTFP-NEXT:    vmov d2, lr, lr
; CHECK-8M-SOFTFP-NEXT:    vmov d3, lr, lr
; CHECK-8M-SOFTFP-NEXT:    vmov d4, lr, lr
; CHECK-8M-SOFTFP-NEXT:    vmov d5, lr, lr
; CHECK-8M-SOFTFP-NEXT:    vmov d6, lr, lr
; CHECK-8M-SOFTFP-NEXT:    vmov d7, lr, lr
; CHECK-8M-SOFTFP-NEXT:    bic r12, r12, #159
; CHECK-8M-SOFTFP-NEXT:    bic r12, r12, #4026531840
; CHECK-8M-SOFTFP-NEXT:    vmsr fpscr, r12
; CHECK-8M-SOFTFP-NEXT:  .LBB0_2: @ %entry
; CHECK-8M-SOFTFP-NEXT:    mov r1, lr
; CHECK-8M-SOFTFP-NEXT:    mov r2, lr
; CHECK-8M-SOFTFP-NEXT:    mov r3, lr
; CHECK-8M-SOFTFP-NEXT:    mov r12, lr
; CHECK-8M-SOFTFP-NEXT:    msr apsr_nzcvqg, lr
; CHECK-8M-SOFTFP-NEXT:    bxns lr
;
; CHECK-81M-SOFT-LABEL: ns_entry:
; CHECK-81M-SOFT:       @ %bb.0: @ %entry
; CHECK-81M-SOFT-NEXT:    vstr fpcxtns, [sp, #-4]!
; CHECK-81M-SOFT-NEXT:    push {r7, lr}
; CHECK-81M-SOFT-NEXT:    sub sp, #4
; CHECK-81M-SOFT-NEXT:    mov r1, r0
; CHECK-81M-SOFT-NEXT:    movs r0, #10
; CHECK-81M-SOFT-NEXT:    blx r1
; CHECK-81M-SOFT-NEXT:    add sp, #4
; CHECK-81M-SOFT-NEXT:    pop.w {r7, lr}
; CHECK-81M-SOFT-NEXT:    vscclrm {s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, vpr}
; CHECK-81M-SOFT-NEXT:    vldr fpcxtns, [sp], #4
; CHECK-81M-SOFT-NEXT:    clrm {r1, r2, r3, r12, apsr}
; CHECK-81M-SOFT-NEXT:    bxns lr
;
; CHECK-81M-SOFTFP-LABEL: ns_entry:
; CHECK-81M-SOFTFP:       @ %bb.0: @ %entry
; CHECK-81M-SOFTFP-NEXT:    vstr fpcxtns, [sp, #-4]!
; CHECK-81M-SOFTFP-NEXT:    push {r7, lr}
; CHECK-81M-SOFTFP-NEXT:    sub sp, #4
; CHECK-81M-SOFTFP-NEXT:    mov r1, r0
; CHECK-81M-SOFTFP-NEXT:    movs r0, #10
; CHECK-81M-SOFTFP-NEXT:    blx r1
; CHECK-81M-SOFTFP-NEXT:    add sp, #4
; CHECK-81M-SOFTFP-NEXT:    pop.w {r7, lr}
; CHECK-81M-SOFTFP-NEXT:    vscclrm {s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, vpr}
; CHECK-81M-SOFTFP-NEXT:    vldr fpcxtns, [sp], #4
; CHECK-81M-SOFTFP-NEXT:    clrm {r1, r2, r3, r12, apsr}
; CHECK-81M-SOFTFP-NEXT:    bxns lr
entry:
  %call = call i32 %fptr(i32 10) #1
  ret i32 %call
}

attributes #0 = { "cmse_nonsecure_entry" nounwind }
attributes #1 = { nounwind }


define i32 @ns_call(i32 (i32)* nocapture %fptr) #2 {
; CHECK-8B-LABEL: ns_call:
; CHECK-8B:       @ %bb.0: @ %entry
; CHECK-8B-NEXT:    push {r7, lr}
; CHECK-8B-NEXT:    mov r1, r0
; CHECK-8B-NEXT:    movs r0, #10
; CHECK-8B-NEXT:    push {r4, r5, r6, r7}
; CHECK-8B-NEXT:    mov r7, r11
; CHECK-8B-NEXT:    mov r6, r10
; CHECK-8B-NEXT:    mov r5, r9
; CHECK-8B-NEXT:    mov r4, r8
; CHECK-8B-NEXT:    push {r4, r5, r6, r7}
; CHECK-8B-NEXT:    mov r2, #1
; CHECK-8B-NEXT:    bics r1, r2
; CHECK-8B-NEXT:    mov r2, r1
; CHECK-8B-NEXT:    mov r3, r1
; CHECK-8B-NEXT:    mov r4, r1
; CHECK-8B-NEXT:    mov r5, r1
; CHECK-8B-NEXT:    mov r6, r1
; CHECK-8B-NEXT:    mov r7, r1
; CHECK-8B-NEXT:    mov r8, r1
; CHECK-8B-NEXT:    mov r9, r1
; CHECK-8B-NEXT:    mov r10, r1
; CHECK-8B-NEXT:    mov r11, r1
; CHECK-8B-NEXT:    mov r12, r1
; CHECK-8B-NEXT:    msr apsr, r1
; CHECK-8B-NEXT:    blxns r1
; CHECK-8B-NEXT:    pop {r4, r5, r6, r7}
; CHECK-8B-NEXT:    mov r8, r4
; CHECK-8B-NEXT:    mov r9, r5
; CHECK-8B-NEXT:    mov r10, r6
; CHECK-8B-NEXT:    mov r11, r7
; CHECK-8B-NEXT:    pop {r4, r5, r6, r7}
; CHECK-8B-NEXT:    pop {r7, pc}
;
; CHECK-8M-SOFT-LABEL: ns_call:
; CHECK-8M-SOFT:       @ %bb.0: @ %entry
; CHECK-8M-SOFT-NEXT:    push {r7, lr}
; CHECK-8M-SOFT-NEXT:    mov r1, r0
; CHECK-8M-SOFT-NEXT:    movs r0, #10
; CHECK-8M-SOFT-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFT-NEXT:    bic r1, r1, #1
; CHECK-8M-SOFT-NEXT:    msr apsr_nzcvqg, r1
; CHECK-8M-SOFT-NEXT:    mov r2, r1
; CHECK-8M-SOFT-NEXT:    mov r3, r1
; CHECK-8M-SOFT-NEXT:    mov r4, r1
; CHECK-8M-SOFT-NEXT:    mov r5, r1
; CHECK-8M-SOFT-NEXT:    mov r6, r1
; CHECK-8M-SOFT-NEXT:    mov r7, r1
; CHECK-8M-SOFT-NEXT:    mov r8, r1
; CHECK-8M-SOFT-NEXT:    mov r9, r1
; CHECK-8M-SOFT-NEXT:    mov r10, r1
; CHECK-8M-SOFT-NEXT:    mov r11, r1
; CHECK-8M-SOFT-NEXT:    mov r12, r1
; CHECK-8M-SOFT-NEXT:    blxns r1
; CHECK-8M-SOFT-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFT-NEXT:    pop {r7, pc}
;
; CHECK-8M-SOFTFP-LABEL: ns_call:
; CHECK-8M-SOFTFP:       @ %bb.0: @ %entry
; CHECK-8M-SOFTFP-NEXT:    push {r7, lr}
; CHECK-8M-SOFTFP-NEXT:    mov r1, r0
; CHECK-8M-SOFTFP-NEXT:    movs r0, #10
; CHECK-8M-SOFTFP-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFTFP-NEXT:    bic r1, r1, #1
; CHECK-8M-SOFTFP-NEXT:    sub sp, #136
; CHECK-8M-SOFTFP-NEXT:    vlstm sp
; CHECK-8M-SOFTFP-NEXT:    mov r2, r1
; CHECK-8M-SOFTFP-NEXT:    mov r3, r1
; CHECK-8M-SOFTFP-NEXT:    mov r4, r1
; CHECK-8M-SOFTFP-NEXT:    mov r5, r1
; CHECK-8M-SOFTFP-NEXT:    mov r6, r1
; CHECK-8M-SOFTFP-NEXT:    mov r7, r1
; CHECK-8M-SOFTFP-NEXT:    mov r8, r1
; CHECK-8M-SOFTFP-NEXT:    mov r9, r1
; CHECK-8M-SOFTFP-NEXT:    mov r10, r1
; CHECK-8M-SOFTFP-NEXT:    mov r11, r1
; CHECK-8M-SOFTFP-NEXT:    mov r12, r1
; CHECK-8M-SOFTFP-NEXT:    msr apsr_nzcvqg, r1
; CHECK-8M-SOFTFP-NEXT:    blxns r1
; CHECK-8M-SOFTFP-NEXT:    vlldm sp
; CHECK-8M-SOFTFP-NEXT:    add sp, #136
; CHECK-8M-SOFTFP-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFTFP-NEXT:    pop {r7, pc}
;
; CHECK-81M-SOFT-LABEL: ns_call:
; CHECK-81M-SOFT:       @ %bb.0: @ %entry
; CHECK-81M-SOFT-NEXT:    push {r7, lr}
; CHECK-81M-SOFT-NEXT:    mov r1, r0
; CHECK-81M-SOFT-NEXT:    movs r0, #10
; CHECK-81M-SOFT-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFT-NEXT:    bic r1, r1, #1
; CHECK-81M-SOFT-NEXT:    sub sp, #136
; CHECK-81M-SOFT-NEXT:    vlstm sp
; CHECK-81M-SOFT-NEXT:    clrm {r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, apsr}
; CHECK-81M-SOFT-NEXT:    blxns r1
; CHECK-81M-SOFT-NEXT:    vlldm sp
; CHECK-81M-SOFT-NEXT:    add sp, #136
; CHECK-81M-SOFT-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFT-NEXT:    pop {r7, pc}
;
; CHECK-81M-SOFTFP-LABEL: ns_call:
; CHECK-81M-SOFTFP:       @ %bb.0: @ %entry
; CHECK-81M-SOFTFP-NEXT:    push {r7, lr}
; CHECK-81M-SOFTFP-NEXT:    mov r1, r0
; CHECK-81M-SOFTFP-NEXT:    movs r0, #10
; CHECK-81M-SOFTFP-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFTFP-NEXT:    bic r1, r1, #1
; CHECK-81M-SOFTFP-NEXT:    sub sp, #136
; CHECK-81M-SOFTFP-NEXT:    vlstm sp
; CHECK-81M-SOFTFP-NEXT:    clrm {r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, apsr}
; CHECK-81M-SOFTFP-NEXT:    blxns r1
; CHECK-81M-SOFTFP-NEXT:    vlldm sp
; CHECK-81M-SOFTFP-NEXT:    add sp, #136
; CHECK-81M-SOFTFP-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFTFP-NEXT:    pop {r7, pc}
entry:
  %call = call i32 %fptr(i32 10) #3
  ret i32 %call
}

attributes #2 = { nounwind }
attributes #3 = { "cmse_nonsecure_call" nounwind }


define i32 @ns_tail_call(i32 (i32)* nocapture %fptr) #4 {
; CHECK-8B-LABEL: ns_tail_call:
; CHECK-8B:       @ %bb.0: @ %entry
; CHECK-8B-NEXT:    push {r7, lr}
; CHECK-8B-NEXT:    mov r1, r0
; CHECK-8B-NEXT:    movs r0, #10
; CHECK-8B-NEXT:    push {r4, r5, r6, r7}
; CHECK-8B-NEXT:    mov r7, r11
; CHECK-8B-NEXT:    mov r6, r10
; CHECK-8B-NEXT:    mov r5, r9
; CHECK-8B-NEXT:    mov r4, r8
; CHECK-8B-NEXT:    push {r4, r5, r6, r7}
; CHECK-8B-NEXT:    mov r2, #1
; CHECK-8B-NEXT:    bics r1, r2
; CHECK-8B-NEXT:    mov r2, r1
; CHECK-8B-NEXT:    mov r3, r1
; CHECK-8B-NEXT:    mov r4, r1
; CHECK-8B-NEXT:    mov r5, r1
; CHECK-8B-NEXT:    mov r6, r1
; CHECK-8B-NEXT:    mov r7, r1
; CHECK-8B-NEXT:    mov r8, r1
; CHECK-8B-NEXT:    mov r9, r1
; CHECK-8B-NEXT:    mov r10, r1
; CHECK-8B-NEXT:    mov r11, r1
; CHECK-8B-NEXT:    mov r12, r1
; CHECK-8B-NEXT:    msr apsr, r1
; CHECK-8B-NEXT:    blxns r1
; CHECK-8B-NEXT:    pop {r4, r5, r6, r7}
; CHECK-8B-NEXT:    mov r8, r4
; CHECK-8B-NEXT:    mov r9, r5
; CHECK-8B-NEXT:    mov r10, r6
; CHECK-8B-NEXT:    mov r11, r7
; CHECK-8B-NEXT:    pop {r4, r5, r6, r7}
; CHECK-8B-NEXT:    pop {r7, pc}
;
; CHECK-8M-SOFT-LABEL: ns_tail_call:
; CHECK-8M-SOFT:       @ %bb.0: @ %entry
; CHECK-8M-SOFT-NEXT:    push {r7, lr}
; CHECK-8M-SOFT-NEXT:    mov r1, r0
; CHECK-8M-SOFT-NEXT:    movs r0, #10
; CHECK-8M-SOFT-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFT-NEXT:    bic r1, r1, #1
; CHECK-8M-SOFT-NEXT:    msr apsr_nzcvqg, r1
; CHECK-8M-SOFT-NEXT:    mov r2, r1
; CHECK-8M-SOFT-NEXT:    mov r3, r1
; CHECK-8M-SOFT-NEXT:    mov r4, r1
; CHECK-8M-SOFT-NEXT:    mov r5, r1
; CHECK-8M-SOFT-NEXT:    mov r6, r1
; CHECK-8M-SOFT-NEXT:    mov r7, r1
; CHECK-8M-SOFT-NEXT:    mov r8, r1
; CHECK-8M-SOFT-NEXT:    mov r9, r1
; CHECK-8M-SOFT-NEXT:    mov r10, r1
; CHECK-8M-SOFT-NEXT:    mov r11, r1
; CHECK-8M-SOFT-NEXT:    mov r12, r1
; CHECK-8M-SOFT-NEXT:    blxns r1
; CHECK-8M-SOFT-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFT-NEXT:    pop {r7, pc}
;
; CHECK-8M-SOFTFP-LABEL: ns_tail_call:
; CHECK-8M-SOFTFP:       @ %bb.0: @ %entry
; CHECK-8M-SOFTFP-NEXT:    push {r7, lr}
; CHECK-8M-SOFTFP-NEXT:    mov r1, r0
; CHECK-8M-SOFTFP-NEXT:    movs r0, #10
; CHECK-8M-SOFTFP-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFTFP-NEXT:    bic r1, r1, #1
; CHECK-8M-SOFTFP-NEXT:    sub sp, #136
; CHECK-8M-SOFTFP-NEXT:    vlstm sp
; CHECK-8M-SOFTFP-NEXT:    mov r2, r1
; CHECK-8M-SOFTFP-NEXT:    mov r3, r1
; CHECK-8M-SOFTFP-NEXT:    mov r4, r1
; CHECK-8M-SOFTFP-NEXT:    mov r5, r1
; CHECK-8M-SOFTFP-NEXT:    mov r6, r1
; CHECK-8M-SOFTFP-NEXT:    mov r7, r1
; CHECK-8M-SOFTFP-NEXT:    mov r8, r1
; CHECK-8M-SOFTFP-NEXT:    mov r9, r1
; CHECK-8M-SOFTFP-NEXT:    mov r10, r1
; CHECK-8M-SOFTFP-NEXT:    mov r11, r1
; CHECK-8M-SOFTFP-NEXT:    mov r12, r1
; CHECK-8M-SOFTFP-NEXT:    msr apsr_nzcvqg, r1
; CHECK-8M-SOFTFP-NEXT:    blxns r1
; CHECK-8M-SOFTFP-NEXT:    vlldm sp
; CHECK-8M-SOFTFP-NEXT:    add sp, #136
; CHECK-8M-SOFTFP-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFTFP-NEXT:    pop {r7, pc}
;
; CHECK-81M-SOFT-LABEL: ns_tail_call:
; CHECK-81M-SOFT:       @ %bb.0: @ %entry
; CHECK-81M-SOFT-NEXT:    push {r7, lr}
; CHECK-81M-SOFT-NEXT:    mov r1, r0
; CHECK-81M-SOFT-NEXT:    movs r0, #10
; CHECK-81M-SOFT-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFT-NEXT:    bic r1, r1, #1
; CHECK-81M-SOFT-NEXT:    sub sp, #136
; CHECK-81M-SOFT-NEXT:    vlstm sp
; CHECK-81M-SOFT-NEXT:    clrm {r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, apsr}
; CHECK-81M-SOFT-NEXT:    blxns r1
; CHECK-81M-SOFT-NEXT:    vlldm sp
; CHECK-81M-SOFT-NEXT:    add sp, #136
; CHECK-81M-SOFT-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFT-NEXT:    pop {r7, pc}
;
; CHECK-81M-SOFTFP-LABEL: ns_tail_call:
; CHECK-81M-SOFTFP:       @ %bb.0: @ %entry
; CHECK-81M-SOFTFP-NEXT:    push {r7, lr}
; CHECK-81M-SOFTFP-NEXT:    mov r1, r0
; CHECK-81M-SOFTFP-NEXT:    movs r0, #10
; CHECK-81M-SOFTFP-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFTFP-NEXT:    bic r1, r1, #1
; CHECK-81M-SOFTFP-NEXT:    sub sp, #136
; CHECK-81M-SOFTFP-NEXT:    vlstm sp
; CHECK-81M-SOFTFP-NEXT:    clrm {r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, apsr}
; CHECK-81M-SOFTFP-NEXT:    blxns r1
; CHECK-81M-SOFTFP-NEXT:    vlldm sp
; CHECK-81M-SOFTFP-NEXT:    add sp, #136
; CHECK-81M-SOFTFP-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFTFP-NEXT:    pop {r7, pc}
entry:
  %call = tail call i32 %fptr(i32 10) #5
  ret i32 %call
}

attributes #4 = { nounwind }
attributes #5 = { "cmse_nonsecure_call" nounwind }


define void (i32, i32, i32, i32)* @ns_tail_call_many_args(void (i32, i32, i32, i32)* %f, i32 %a, i32 %b, i32 %c, i32 %d) #6 {
; CHECK-8B-LABEL: ns_tail_call_many_args:
; CHECK-8B:       @ %bb.0:
; CHECK-8B-NEXT:    push {r4, r5, r7, lr}
; CHECK-8B-NEXT:    mov r5, r3
; CHECK-8B-NEXT:    mov r4, r0
; CHECK-8B-NEXT:    ldr r3, [sp, #16]
; CHECK-8B-NEXT:    mov r0, r1
; CHECK-8B-NEXT:    mov r1, r2
; CHECK-8B-NEXT:    mov r2, r5
; CHECK-8B-NEXT:    push {r4, r5, r6, r7}
; CHECK-8B-NEXT:    mov r7, r11
; CHECK-8B-NEXT:    mov r6, r10
; CHECK-8B-NEXT:    mov r5, r9
; CHECK-8B-NEXT:    push {r5, r6, r7}
; CHECK-8B-NEXT:    mov r5, r8
; CHECK-8B-NEXT:    push {r5}
; CHECK-8B-NEXT:    mov r5, #1
; CHECK-8B-NEXT:    bics r4, r5
; CHECK-8B-NEXT:    mov r5, r4
; CHECK-8B-NEXT:    mov r6, r4
; CHECK-8B-NEXT:    mov r7, r4
; CHECK-8B-NEXT:    mov r8, r4
; CHECK-8B-NEXT:    mov r9, r4
; CHECK-8B-NEXT:    mov r10, r4
; CHECK-8B-NEXT:    mov r11, r4
; CHECK-8B-NEXT:    mov r12, r4
; CHECK-8B-NEXT:    msr apsr, r4
; CHECK-8B-NEXT:    blxns r4
; CHECK-8B-NEXT:    pop {r4, r5, r6, r7}
; CHECK-8B-NEXT:    mov r8, r4
; CHECK-8B-NEXT:    mov r9, r5
; CHECK-8B-NEXT:    mov r10, r6
; CHECK-8B-NEXT:    mov r11, r7
; CHECK-8B-NEXT:    pop {r4, r5, r6, r7}
; CHECK-8B-NEXT:    mov r0, r4
; CHECK-8B-NEXT:    pop {r4, r5, r7, pc}
;
; CHECK-8M-SOFT-LABEL: ns_tail_call_many_args:
; CHECK-8M-SOFT:       @ %bb.0:
; CHECK-8M-SOFT-NEXT:    push {r4, lr}
; CHECK-8M-SOFT-NEXT:    mov r4, r0
; CHECK-8M-SOFT-NEXT:    mov r12, r3
; CHECK-8M-SOFT-NEXT:    mov r0, r1
; CHECK-8M-SOFT-NEXT:    mov r1, r2
; CHECK-8M-SOFT-NEXT:    ldr r3, [sp, #8]
; CHECK-8M-SOFT-NEXT:    mov r2, r12
; CHECK-8M-SOFT-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFT-NEXT:    bic r4, r4, #1
; CHECK-8M-SOFT-NEXT:    msr apsr_nzcvqg, r4
; CHECK-8M-SOFT-NEXT:    mov r5, r4
; CHECK-8M-SOFT-NEXT:    mov r6, r4
; CHECK-8M-SOFT-NEXT:    mov r7, r4
; CHECK-8M-SOFT-NEXT:    mov r8, r4
; CHECK-8M-SOFT-NEXT:    mov r9, r4
; CHECK-8M-SOFT-NEXT:    mov r10, r4
; CHECK-8M-SOFT-NEXT:    mov r11, r4
; CHECK-8M-SOFT-NEXT:    mov r12, r4
; CHECK-8M-SOFT-NEXT:    blxns r4
; CHECK-8M-SOFT-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFT-NEXT:    mov r0, r4
; CHECK-8M-SOFT-NEXT:    pop {r4, pc}
;
; CHECK-8M-SOFTFP-LABEL: ns_tail_call_many_args:
; CHECK-8M-SOFTFP:       @ %bb.0:
; CHECK-8M-SOFTFP-NEXT:    push {r4, lr}
; CHECK-8M-SOFTFP-NEXT:    mov r4, r0
; CHECK-8M-SOFTFP-NEXT:    mov r12, r3
; CHECK-8M-SOFTFP-NEXT:    mov r0, r1
; CHECK-8M-SOFTFP-NEXT:    mov r1, r2
; CHECK-8M-SOFTFP-NEXT:    ldr r3, [sp, #8]
; CHECK-8M-SOFTFP-NEXT:    mov r2, r12
; CHECK-8M-SOFTFP-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFTFP-NEXT:    bic r4, r4, #1
; CHECK-8M-SOFTFP-NEXT:    sub sp, #136
; CHECK-8M-SOFTFP-NEXT:    vlstm sp
; CHECK-8M-SOFTFP-NEXT:    mov r5, r4
; CHECK-8M-SOFTFP-NEXT:    mov r6, r4
; CHECK-8M-SOFTFP-NEXT:    mov r7, r4
; CHECK-8M-SOFTFP-NEXT:    mov r8, r4
; CHECK-8M-SOFTFP-NEXT:    mov r9, r4
; CHECK-8M-SOFTFP-NEXT:    mov r10, r4
; CHECK-8M-SOFTFP-NEXT:    mov r11, r4
; CHECK-8M-SOFTFP-NEXT:    mov r12, r4
; CHECK-8M-SOFTFP-NEXT:    msr apsr_nzcvqg, r4
; CHECK-8M-SOFTFP-NEXT:    blxns r4
; CHECK-8M-SOFTFP-NEXT:    vlldm sp
; CHECK-8M-SOFTFP-NEXT:    add sp, #136
; CHECK-8M-SOFTFP-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFTFP-NEXT:    mov r0, r4
; CHECK-8M-SOFTFP-NEXT:    pop {r4, pc}
;
; CHECK-81M-SOFT-LABEL: ns_tail_call_many_args:
; CHECK-81M-SOFT:       @ %bb.0:
; CHECK-81M-SOFT-NEXT:    push {r4, lr}
; CHECK-81M-SOFT-NEXT:    mov r4, r0
; CHECK-81M-SOFT-NEXT:    mov r12, r3
; CHECK-81M-SOFT-NEXT:    mov r0, r1
; CHECK-81M-SOFT-NEXT:    mov r1, r2
; CHECK-81M-SOFT-NEXT:    ldr r3, [sp, #8]
; CHECK-81M-SOFT-NEXT:    mov r2, r12
; CHECK-81M-SOFT-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFT-NEXT:    bic r4, r4, #1
; CHECK-81M-SOFT-NEXT:    sub sp, #136
; CHECK-81M-SOFT-NEXT:    vlstm sp
; CHECK-81M-SOFT-NEXT:    clrm {r5, r6, r7, r8, r9, r10, r11, r12, apsr}
; CHECK-81M-SOFT-NEXT:    blxns r4
; CHECK-81M-SOFT-NEXT:    vlldm sp
; CHECK-81M-SOFT-NEXT:    add sp, #136
; CHECK-81M-SOFT-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFT-NEXT:    mov r0, r4
; CHECK-81M-SOFT-NEXT:    pop {r4, pc}
;
; CHECK-81M-SOFTFP-LABEL: ns_tail_call_many_args:
; CHECK-81M-SOFTFP:       @ %bb.0:
; CHECK-81M-SOFTFP-NEXT:    push {r4, lr}
; CHECK-81M-SOFTFP-NEXT:    mov r4, r0
; CHECK-81M-SOFTFP-NEXT:    mov r12, r3
; CHECK-81M-SOFTFP-NEXT:    mov r0, r1
; CHECK-81M-SOFTFP-NEXT:    mov r1, r2
; CHECK-81M-SOFTFP-NEXT:    ldr r3, [sp, #8]
; CHECK-81M-SOFTFP-NEXT:    mov r2, r12
; CHECK-81M-SOFTFP-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFTFP-NEXT:    bic r4, r4, #1
; CHECK-81M-SOFTFP-NEXT:    sub sp, #136
; CHECK-81M-SOFTFP-NEXT:    vlstm sp
; CHECK-81M-SOFTFP-NEXT:    clrm {r5, r6, r7, r8, r9, r10, r11, r12, apsr}
; CHECK-81M-SOFTFP-NEXT:    blxns r4
; CHECK-81M-SOFTFP-NEXT:    vlldm sp
; CHECK-81M-SOFTFP-NEXT:    add sp, #136
; CHECK-81M-SOFTFP-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFTFP-NEXT:    mov r0, r4
; CHECK-81M-SOFTFP-NEXT:    pop {r4, pc}
  tail call void %f(i32 %a, i32 %b, i32 %c, i32 %d) #7
  ret void (i32, i32, i32, i32)* %f
}

attributes #6 = { nounwind }
attributes #7 = { "cmse_nonsecure_call" nounwind }


define i32 @ns_call_void(i32 %reg0, i32 ()* nocapture %fptr) #8 {
; CHECK-8B-LABEL: ns_call_void:
; CHECK-8B:       @ %bb.0: @ %entry
; CHECK-8B-NEXT:    push {r7, lr}
; CHECK-8B-NEXT:    push {r4, r5, r6, r7}
; CHECK-8B-NEXT:    mov r7, r11
; CHECK-8B-NEXT:    mov r6, r10
; CHECK-8B-NEXT:    mov r5, r9
; CHECK-8B-NEXT:    mov r4, r8
; CHECK-8B-NEXT:    push {r4, r5, r6, r7}
; CHECK-8B-NEXT:    mov r0, #1
; CHECK-8B-NEXT:    bics r1, r0
; CHECK-8B-NEXT:    mov r0, r1
; CHECK-8B-NEXT:    mov r2, r1
; CHECK-8B-NEXT:    mov r3, r1
; CHECK-8B-NEXT:    mov r4, r1
; CHECK-8B-NEXT:    mov r5, r1
; CHECK-8B-NEXT:    mov r6, r1
; CHECK-8B-NEXT:    mov r7, r1
; CHECK-8B-NEXT:    mov r8, r1
; CHECK-8B-NEXT:    mov r9, r1
; CHECK-8B-NEXT:    mov r10, r1
; CHECK-8B-NEXT:    mov r11, r1
; CHECK-8B-NEXT:    mov r12, r1
; CHECK-8B-NEXT:    msr apsr, r1
; CHECK-8B-NEXT:    blxns r1
; CHECK-8B-NEXT:    pop {r4, r5, r6, r7}
; CHECK-8B-NEXT:    mov r8, r4
; CHECK-8B-NEXT:    mov r9, r5
; CHECK-8B-NEXT:    mov r10, r6
; CHECK-8B-NEXT:    mov r11, r7
; CHECK-8B-NEXT:    pop {r4, r5, r6, r7}
; CHECK-8B-NEXT:    pop {r7, pc}
;
; CHECK-8M-SOFT-LABEL: ns_call_void:
; CHECK-8M-SOFT:       @ %bb.0: @ %entry
; CHECK-8M-SOFT-NEXT:    push {r7, lr}
; CHECK-8M-SOFT-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFT-NEXT:    bic r1, r1, #1
; CHECK-8M-SOFT-NEXT:    msr apsr_nzcvqg, r1
; CHECK-8M-SOFT-NEXT:    mov r0, r1
; CHECK-8M-SOFT-NEXT:    mov r2, r1
; CHECK-8M-SOFT-NEXT:    mov r3, r1
; CHECK-8M-SOFT-NEXT:    mov r4, r1
; CHECK-8M-SOFT-NEXT:    mov r5, r1
; CHECK-8M-SOFT-NEXT:    mov r6, r1
; CHECK-8M-SOFT-NEXT:    mov r7, r1
; CHECK-8M-SOFT-NEXT:    mov r8, r1
; CHECK-8M-SOFT-NEXT:    mov r9, r1
; CHECK-8M-SOFT-NEXT:    mov r10, r1
; CHECK-8M-SOFT-NEXT:    mov r11, r1
; CHECK-8M-SOFT-NEXT:    mov r12, r1
; CHECK-8M-SOFT-NEXT:    blxns r1
; CHECK-8M-SOFT-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFT-NEXT:    pop {r7, pc}
;
; CHECK-8M-SOFTFP-LABEL: ns_call_void:
; CHECK-8M-SOFTFP:       @ %bb.0: @ %entry
; CHECK-8M-SOFTFP-NEXT:    push {r7, lr}
; CHECK-8M-SOFTFP-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFTFP-NEXT:    bic r1, r1, #1
; CHECK-8M-SOFTFP-NEXT:    sub sp, #136
; CHECK-8M-SOFTFP-NEXT:    vlstm sp
; CHECK-8M-SOFTFP-NEXT:    mov r0, r1
; CHECK-8M-SOFTFP-NEXT:    mov r2, r1
; CHECK-8M-SOFTFP-NEXT:    mov r3, r1
; CHECK-8M-SOFTFP-NEXT:    mov r4, r1
; CHECK-8M-SOFTFP-NEXT:    mov r5, r1
; CHECK-8M-SOFTFP-NEXT:    mov r6, r1
; CHECK-8M-SOFTFP-NEXT:    mov r7, r1
; CHECK-8M-SOFTFP-NEXT:    mov r8, r1
; CHECK-8M-SOFTFP-NEXT:    mov r9, r1
; CHECK-8M-SOFTFP-NEXT:    mov r10, r1
; CHECK-8M-SOFTFP-NEXT:    mov r11, r1
; CHECK-8M-SOFTFP-NEXT:    mov r12, r1
; CHECK-8M-SOFTFP-NEXT:    msr apsr_nzcvqg, r1
; CHECK-8M-SOFTFP-NEXT:    blxns r1
; CHECK-8M-SOFTFP-NEXT:    vlldm sp
; CHECK-8M-SOFTFP-NEXT:    add sp, #136
; CHECK-8M-SOFTFP-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-8M-SOFTFP-NEXT:    pop {r7, pc}
;
; CHECK-81M-SOFT-LABEL: ns_call_void:
; CHECK-81M-SOFT:       @ %bb.0: @ %entry
; CHECK-81M-SOFT-NEXT:    push {r7, lr}
; CHECK-81M-SOFT-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFT-NEXT:    bic r1, r1, #1
; CHECK-81M-SOFT-NEXT:    sub sp, #136
; CHECK-81M-SOFT-NEXT:    vlstm sp
; CHECK-81M-SOFT-NEXT:    clrm {r0, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, apsr}
; CHECK-81M-SOFT-NEXT:    blxns r1
; CHECK-81M-SOFT-NEXT:    vlldm sp
; CHECK-81M-SOFT-NEXT:    add sp, #136
; CHECK-81M-SOFT-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFT-NEXT:    pop {r7, pc}
;
; CHECK-81M-SOFTFP-LABEL: ns_call_void:
; CHECK-81M-SOFTFP:       @ %bb.0: @ %entry
; CHECK-81M-SOFTFP-NEXT:    push {r7, lr}
; CHECK-81M-SOFTFP-NEXT:    push.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFTFP-NEXT:    bic r1, r1, #1
; CHECK-81M-SOFTFP-NEXT:    sub sp, #136
; CHECK-81M-SOFTFP-NEXT:    vlstm sp
; CHECK-81M-SOFTFP-NEXT:    clrm {r0, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, apsr}
; CHECK-81M-SOFTFP-NEXT:    blxns r1
; CHECK-81M-SOFTFP-NEXT:    vlldm sp
; CHECK-81M-SOFTFP-NEXT:    add sp, #136
; CHECK-81M-SOFTFP-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, r10, r11}
; CHECK-81M-SOFTFP-NEXT:    pop {r7, pc}
entry:
  %call = call i32 %fptr() #9
  ret i32 %call
}

attributes #8 = { nounwind }
attributes #9 = { "cmse_nonsecure_call" nounwind }

