; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -bdce < %s | FileCheck %s
define i32 @ZEXT_0(i16 %a) {
; CHECK-LABEL: @ZEXT_0(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[EXT1:%.*]] = zext i16 [[A:%.*]] to i32
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[EXT1]], 65280
; CHECK-NEXT:    [[LSR:%.*]] = lshr i32 [[EXT1]], 8
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[LSR]], 255
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[AND]], [[AND2]]
; CHECK-NEXT:    ret i32 [[OR]]
;
entry:
  %ext = sext i16 %a to i32
  %and = and i32 %ext, 65280
  %lsr = lshr i32 %ext, 8
  %and2 = and i32 %lsr, 255
  %or = or i32 %and, %and2
  ret i32 %or
}

define i32 @ZEXT_1(i16 %a) {
; CHECK-LABEL: @ZEXT_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[EXT1:%.*]] = zext i16 [[A:%.*]] to i32
; CHECK-NEXT:    [[LSR:%.*]] = lshr i32 [[EXT1]], 8
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[LSR]], 255
; CHECK-NEXT:    [[AND:%.*]] = or i32 [[EXT1]], -65536
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[AND]], [[AND2]]
; CHECK-NEXT:    ret i32 [[OR]]
;
entry:
  %ext = sext i16 %a to i32
  %lsr = lshr i32 %ext, 8
  %and2 = and i32 %lsr, 255
  %and = or i32 %ext, 4294901760
  %or = or i32 %and, %and2
  ret i32 %or
}

define i16 @NOT_ZEXT_0(i16 %a) {
; CHECK-LABEL: @NOT_ZEXT_0(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[EXT:%.*]] = sext i16 [[A:%.*]] to i32
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[EXT]], 65280
; CHECK-NEXT:    [[LSR:%.*]] = lshr i32 [[EXT]], 9
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[LSR]], 255
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[AND]], [[AND2]]
; CHECK-NEXT:    [[RET:%.*]] = trunc i32 [[OR]] to i16
; CHECK-NEXT:    ret i16 [[RET]]
;
entry:
  %ext = sext i16 %a to i32
  %and = and i32 %ext, 65280
  %lsr = lshr i32 %ext, 9
  %and2 = and i32 %lsr, 255
  %or = or i32 %and, %and2
  %ret = trunc i32 %or to i16
  ret i16 %ret
}

define i32 @NOT_ZEXT_1(i16 %a) {
; CHECK-LABEL: @NOT_ZEXT_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[EXT:%.*]] = sext i16 [[A:%.*]] to i32
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[EXT]], 85280
; CHECK-NEXT:    [[LSR:%.*]] = lshr i32 [[EXT]], 8
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[LSR]], 255
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[AND]], [[AND2]]
; CHECK-NEXT:    ret i32 [[OR]]
;
entry:
  %ext = sext i16 %a to i32
  %and = and i32 %ext, 85280
  %lsr = lshr i32 %ext, 8
  %and2 = and i32 %lsr, 255
  %or = or i32 %and, %and2
  ret i32 %or
}

define i32 @NOT_ZEXT_2(i16 %a) {
; CHECK-LABEL: @NOT_ZEXT_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[EXT:%.*]] = sext i16 [[A:%.*]] to i32
; CHECK-NEXT:    [[LSR:%.*]] = lshr i32 [[EXT]], 8
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[LSR]], 255
; CHECK-NEXT:    [[AND:%.*]] = xor i32 [[EXT]], -65536
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[AND]], [[AND2]]
; CHECK-NEXT:    ret i32 [[OR]]
;
entry:
  %ext = sext i16 %a to i32
  %lsr = lshr i32 %ext, 8
  %and2 = and i32 %lsr, 255
  %and = xor i32 %ext, 4294901760
  %or = or i32 %and, %and2
  ret i32 %or
}

define i16 @clear_assumptions(i8 %x, i16 %y) {
; CHECK-LABEL: @clear_assumptions(
; CHECK-NEXT:    [[EXT1:%.*]] = zext i8 [[X:%.*]] to i16
; CHECK-NEXT:    [[ADD:%.*]] = add i16 [[EXT1]], [[Y:%.*]]
; CHECK-NEXT:    [[AND:%.*]] = and i16 [[ADD]], 255
; CHECK-NEXT:    ret i16 [[AND]]
;
  %ext = sext i8 %x to i16
  %add = add nsw i16 %ext, %y
  %and = and i16 %add, 255
  ret i16 %and
}
