; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -basic-aa -memcpyopt -S -verify-memoryssa | FileCheck %s
; These memmoves should get optimized to memcpys.

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128"
target triple = "x86_64-apple-darwin9.0"

@C = external constant [0 x i8]

declare void @llvm.memmove.p0i8.p0i8.i64(i8* nocapture, i8* nocapture, i64, i1) nounwind

define i8* @test1(i8* nocapture %src) nounwind {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MALLOCCALL:%.*]] = tail call i8* @malloc(i32 trunc (i64 mul nuw (i64 ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64), i64 13) to i32))
; CHECK-NEXT:    [[CALL3:%.*]] = bitcast i8* [[MALLOCCALL]] to [13 x i8]*
; CHECK-NEXT:    [[CALL3_SUB:%.*]] = getelementptr inbounds [13 x i8], [13 x i8]* [[CALL3]], i64 0, i64 0
; CHECK-NEXT:    tail call void @llvm.memcpy.p0i8.p0i8.i64(i8* [[CALL3_SUB]], i8* [[SRC:%.*]], i64 13, i1 false)
; CHECK-NEXT:    ret i8* [[CALL3_SUB]]
;
entry:

  %malloccall = tail call i8* @malloc(i32 trunc (i64 mul nuw (i64 ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64), i64 13) to i32))
  %call3 = bitcast i8* %malloccall to [13 x i8]*
  %call3.sub = getelementptr inbounds [13 x i8], [13 x i8]* %call3, i64 0, i64 0
  tail call void @llvm.memmove.p0i8.p0i8.i64(i8* %call3.sub, i8* %src, i64 13, i1 false)
  ret i8* %call3.sub
}
declare noalias i8* @malloc(i32)


define void @test2(i8* %P) nounwind {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr i8, i8* [[P:%.*]], i64 16
; CHECK-NEXT:    tail call void @llvm.memcpy.p0i8.p0i8.i64(i8* [[P]], i8* [[ADD_PTR]], i64 16, i1 false)
; CHECK-NEXT:    ret void
;
entry:
  %add.ptr = getelementptr i8, i8* %P, i64 16
  tail call void @llvm.memmove.p0i8.p0i8.i64(i8* %P, i8* %add.ptr, i64 16, i1 false)
  ret void
}

; This cannot be optimize because the src/dst really do overlap.
define void @test3(i8* %P) nounwind {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr i8, i8* [[P:%.*]], i64 16
; CHECK-NEXT:    tail call void @llvm.memmove.p0i8.p0i8.i64(i8* [[P]], i8* [[ADD_PTR]], i64 17, i1 false)
; CHECK-NEXT:    ret void
;
entry:
  %add.ptr = getelementptr i8, i8* %P, i64 16
  tail call void @llvm.memmove.p0i8.p0i8.i64(i8* %P, i8* %add.ptr, i64 17, i1 false)
  ret void
}

define void @test4(i8* %P) nounwind {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds [0 x i8], [0 x i8]* @C, i64 0, i64 0
; CHECK-NEXT:    tail call void @llvm.memcpy.p0i8.p0i8.i64(i8* [[P:%.*]], i8* [[ADD_PTR]], i64 17, i1 false)
; CHECK-NEXT:    ret void
;
  %add.ptr = getelementptr inbounds [0 x i8], [0 x i8]* @C, i64 0, i64 0
  tail call void @llvm.memmove.p0i8.p0i8.i64(i8* %P, i8* %add.ptr, i64 17, i1 false)
  ret void
}
