; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=licm < %s -S | FileCheck %s
; RUN: opt -aa-pipeline=basic-aa -passes='require<aa>,require<targetir>,require<scalar-evolution>,require<opt-remark-emit>,loop-mssa(licm)' < %s -S | FileCheck %s

define void @test1(i1 %cond, ptr %ptr) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[PTR:%.*]])
; CHECK-NEXT:    [[VAL:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[X:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[X_INC:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[X_INC]] = add i32 [[X]], [[VAL]]
; CHECK-NEXT:    br label [[LOOP]]
;

entry:
  br label %loop

loop:
  %x = phi i32 [ 0, %entry ], [ %x.inc, %loop ]
  call ptr @llvm.invariant.start.p0(i64 4, ptr %ptr)
  %val = load i32, ptr %ptr
  %x.inc = add i32 %x, %val
  br label %loop
}

;; despite the loop varying invariant.start, we should be
;; able to hoist the load
define void @test2(i1 %cond, ptr %ptr) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[VAL:%.*]] = load i32, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[X:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[X_INC:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[PIV:%.*]] = getelementptr i32, ptr [[PTR]], i32 [[X]]
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[PIV]])
; CHECK-NEXT:    [[X_INC]] = add i32 [[X]], [[VAL]]
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  br label %loop

loop:
  %x = phi i32 [ 0, %entry ], [ %x.inc, %loop ]
  %piv = getelementptr i32, ptr %ptr, i32 %x
  call ptr @llvm.invariant.start.p0(i64 4, ptr %piv)
  %val = load i32, ptr %ptr
  %x.inc = add i32 %x, %val
  br label %loop
}

define void @test3(i1 %cond, ptr %ptr) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[PTR:%.*]])
; CHECK-NEXT:    [[VAL:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    [[P2:%.*]] = getelementptr i32, ptr [[PTR]], i32 1
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[X:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[X_INC:%.*]], [[LOOP]] ]
; CHECK-NEXT:    store volatile i32 0, ptr [[P2]], align 4
; CHECK-NEXT:    [[X_INC]] = add i32 [[X]], [[VAL]]
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  br label %loop

loop:
  %x = phi i32 [ 0, %entry ], [ %x.inc, %loop ]
  call ptr @llvm.invariant.start.p0(i64 4, ptr %ptr)
  %val = load i32, ptr %ptr
  %p2 = getelementptr i32, ptr %ptr, i32 1
  store volatile i32 0, ptr %p2
  %x.inc = add i32 %x, %val
  br label %loop
}

; can't hoist due to init in loop, only well defined if loop exits
; on first iteration, but we don't bother checking for that currently
define void @test4(i1 %cond, ptr %ptr) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[X:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[X_INC:%.*]], [[LOOP]] ]
; CHECK-NEXT:    store i32 0, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[PTR]])
; CHECK-NEXT:    [[X_INC]] = add i32 [[X]], 0
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  br label %loop

loop:
  %x = phi i32 [ 0, %entry ], [ %x.inc, %loop ]
  store i32 0, ptr %ptr
  call ptr @llvm.invariant.start.p0(i64 4, ptr %ptr)
  %val = load i32, ptr %ptr
  %x.inc = add i32 %x, %val
  br label %loop
}

; don't try to reason about scopes
define void @test5(i1 %cond, ptr %ptr) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[X:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[X_INC:%.*]], [[LOOP]] ]
; CHECK-NEXT:    store i32 0, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    [[SCOPE:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[PTR]])
; CHECK-NEXT:    [[VAL:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    call void @llvm.invariant.end.p0(ptr [[SCOPE]], i64 4, ptr [[PTR]])
; CHECK-NEXT:    [[X_INC]] = add i32 [[X]], [[VAL]]
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  br label %loop

loop:
  %x = phi i32 [ 0, %entry ], [ %x.inc, %loop ]
  store i32 0, ptr %ptr
  %scope = call ptr @llvm.invariant.start.p0(i64 4, ptr %ptr)
  %val = load i32, ptr %ptr
  call void @llvm.invariant.end.p0(ptr %scope, i64 4, ptr %ptr)
  %x.inc = add i32 %x, %val
  br label %loop
}

declare ptr @llvm.invariant.start.p0(i64, ptr)
declare void @llvm.invariant.end.p0(ptr, i64, ptr)
