; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2   | FileCheck %s --check-prefix=SSE --check-prefix=SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.2 | FileCheck %s --check-prefix=SSE --check-prefix=SSE42
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx    | FileCheck %s --check-prefix=AVX --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2   | FileCheck %s --check-prefix=AVX --check-prefix=AVX2

; PR28925

define <4 x i32> @test1(<4 x i1> %cond, <4 x i32> %x) {
; SSE-LABEL: test1:
; SSE:       # %bb.0:
; SSE-NEXT:    pslld $31, %xmm0
; SSE-NEXT:    psrad $31, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %r = select <4 x i1> %cond, <4 x i32> zeroinitializer, <4 x i32> %x
  ret <4 x i32> %r
}

define <4 x i32> @test2(<4 x float> %a, <4 x float> %b, <4 x i32> %x) {
; SSE-LABEL: test2:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpneqps %xmm1, %xmm0
; SSE-NEXT:    andps %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test2:
; AVX:       # %bb.0:
; AVX-NEXT:    vcmpneqps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vandps %xmm2, %xmm0, %xmm0
; AVX-NEXT:    retq
  %cond = fcmp oeq <4 x float> %a, %b
  %r = select <4 x i1> %cond, <4 x i32> zeroinitializer, <4 x i32> %x
  ret <4 x i32> %r
}

define float @fsel(float %a, float %b, float %x) {
; SSE-LABEL: fsel:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpeqss %xmm1, %xmm0
; SSE-NEXT:    andnps %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: fsel:
; AVX:       # %bb.0:
; AVX-NEXT:    vcmpeqss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vandnps %xmm2, %xmm0, %xmm0
; AVX-NEXT:    retq
  %cond = fcmp oeq float %a, %b
  %sel = select i1 %cond, float 0.0, float %x
  ret float %sel
}
