; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
;       Except for the NACL version which isn't parsed by update_llc_test_checks.py

; RUN: llc -mtriple=mipsel-unknown-linux-gnu -force-mips-long-branch -O3 \
; RUN:   -mcpu=mips32r2 -mattr=+use-indirect-jump-hazard -relocation-model=pic \
; RUN:   -verify-machineinstrs < %s | FileCheck %s -check-prefix=O32-PIC

; RUN: llc -mtriple=mipsel-unknown-linux-gnu -mcpu=mips32r6 \
; RUN:   -force-mips-long-branch -O3 -mattr=+use-indirect-jump-hazard  \
; RUN:   -relocation-model=pic -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=O32-R6-PIC

; RUN: llc -mtriple=mips64el-unknown-linux-gnu -mcpu=mips64r2 -target-abi=n64 \
; RUN:   -force-mips-long-branch -O3 -relocation-model=pic \
; RUN:   -mattr=+use-indirect-jump-hazard -verify-machineinstrs \
; RUN:   < %s | FileCheck %s -check-prefix=MIPS64

; RUN: llc -mtriple=mips64el-unknown-linux-gnu -mcpu=mips64r6 -target-abi=n64 \
; RUN:   -force-mips-long-branch -O3 -mattr=+use-indirect-jump-hazard \
; RUN:   -relocation-model=pic -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=N64-R6

; Test that the long branches also get changed to their hazard variants.

@x = external global i32

define void @test1(i32 signext %s) {
; O32-PIC-LABEL: test1:
; O32-PIC:       # %bb.0: # %entry
; O32-PIC-NEXT:    lui $2, %hi(_gp_disp)
; O32-PIC-NEXT:    addiu $2, $2, %lo(_gp_disp)
; O32-PIC-NEXT:    bnez $4, $BB0_3
; O32-PIC-NEXT:    addu $2, $2, $25
; O32-PIC-NEXT:  # %bb.1: # %entry
; O32-PIC-NEXT:    addiu $sp, $sp, -8
; O32-PIC-NEXT:    sw $ra, 0($sp)
; O32-PIC-NEXT:    lui $1, %hi(($BB0_4)-($BB0_2))
; O32-PIC-NEXT:    bal $BB0_2
; O32-PIC-NEXT:    addiu $1, $1, %lo(($BB0_4)-($BB0_2))
; O32-PIC-NEXT:  $BB0_2: # %entry
; O32-PIC-NEXT:    addu $1, $ra, $1
; O32-PIC-NEXT:    lw $ra, 0($sp)
; O32-PIC-NEXT:    jr.hb $1
; O32-PIC-NEXT:    addiu $sp, $sp, 8
; O32-PIC-NEXT:  $BB0_3: # %then
; O32-PIC-NEXT:    lw $1, %got(x)($2)
; O32-PIC-NEXT:    addiu $2, $zero, 1
; O32-PIC-NEXT:    sw $2, 0($1)
; O32-PIC-NEXT:  $BB0_4: # %end
; O32-PIC-NEXT:    jr $ra
; O32-PIC-NEXT:    nop
;
; O32-R6-PIC-LABEL: test1:
; O32-R6-PIC:       # %bb.0: # %entry
; O32-R6-PIC-NEXT:    lui $2, %hi(_gp_disp)
; O32-R6-PIC-NEXT:    addiu $2, $2, %lo(_gp_disp)
; O32-R6-PIC-NEXT:    bnez $4, $BB0_3
; O32-R6-PIC-NEXT:    addu $2, $2, $25
; O32-R6-PIC-NEXT:  # %bb.1: # %entry
; O32-R6-PIC-NEXT:    addiu $sp, $sp, -8
; O32-R6-PIC-NEXT:    sw $ra, 0($sp)
; O32-R6-PIC-NEXT:    lui $1, %hi(($BB0_4)-($BB0_2))
; O32-R6-PIC-NEXT:    addiu $1, $1, %lo(($BB0_4)-($BB0_2))
; O32-R6-PIC-NEXT:    balc $BB0_2
; O32-R6-PIC-NEXT:  $BB0_2: # %entry
; O32-R6-PIC-NEXT:    addu $1, $ra, $1
; O32-R6-PIC-NEXT:    lw $ra, 0($sp)
; O32-R6-PIC-NEXT:    jr.hb $1
; O32-R6-PIC-NEXT:    addiu $sp, $sp, 8
; O32-R6-PIC-NEXT:  $BB0_3: # %then
; O32-R6-PIC-NEXT:    lw $1, %got(x)($2)
; O32-R6-PIC-NEXT:    addiu $2, $zero, 1
; O32-R6-PIC-NEXT:    sw $2, 0($1)
; O32-R6-PIC-NEXT:  $BB0_4: # %end
; O32-R6-PIC-NEXT:    jrc $ra
;
; MIPS64-LABEL: test1:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    lui $1, %hi(%neg(%gp_rel(test1)))
; MIPS64-NEXT:    bnez $4, .LBB0_3
; MIPS64-NEXT:    daddu $2, $1, $25
; MIPS64-NEXT:  # %bb.1: # %entry
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    sd $ra, 0($sp)
; MIPS64-NEXT:    daddiu $1, $zero, %hi(.LBB0_4-.LBB0_2)
; MIPS64-NEXT:    dsll $1, $1, 16
; MIPS64-NEXT:    bal .LBB0_2
; MIPS64-NEXT:    daddiu $1, $1, %lo(.LBB0_4-.LBB0_2)
; MIPS64-NEXT:  .LBB0_2: # %entry
; MIPS64-NEXT:    daddu $1, $ra, $1
; MIPS64-NEXT:    ld $ra, 0($sp)
; MIPS64-NEXT:    jr.hb $1
; MIPS64-NEXT:    daddiu $sp, $sp, 16
; MIPS64-NEXT:  .LBB0_3: # %then
; MIPS64-NEXT:    daddiu $1, $2, %lo(%neg(%gp_rel(test1)))
; MIPS64-NEXT:    addiu $2, $zero, 1
; MIPS64-NEXT:    ld $1, %got_disp(x)($1)
; MIPS64-NEXT:    sw $2, 0($1)
; MIPS64-NEXT:  .LBB0_4: # %end
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
;
; N64-R6-LABEL: test1:
; N64-R6:       # %bb.0: # %entry
; N64-R6-NEXT:    lui $1, %hi(%neg(%gp_rel(test1)))
; N64-R6-NEXT:    bnez $4, .LBB0_3
; N64-R6-NEXT:    daddu $2, $1, $25
; N64-R6-NEXT:  # %bb.1: # %entry
; N64-R6-NEXT:    daddiu $sp, $sp, -16
; N64-R6-NEXT:    sd $ra, 0($sp)
; N64-R6-NEXT:    daddiu $1, $zero, %hi(.LBB0_4-.LBB0_2)
; N64-R6-NEXT:    dsll $1, $1, 16
; N64-R6-NEXT:    daddiu $1, $1, %lo(.LBB0_4-.LBB0_2)
; N64-R6-NEXT:    balc .LBB0_2
; N64-R6-NEXT:  .LBB0_2: # %entry
; N64-R6-NEXT:    daddu $1, $ra, $1
; N64-R6-NEXT:    ld $ra, 0($sp)
; N64-R6-NEXT:    jr.hb $1
; N64-R6-NEXT:    daddiu $sp, $sp, 16
; N64-R6-NEXT:  .LBB0_3: # %then
; N64-R6-NEXT:    daddiu $1, $2, %lo(%neg(%gp_rel(test1)))
; N64-R6-NEXT:    addiu $2, $zero, 1
; N64-R6-NEXT:    ld $1, %got_disp(x)($1)
; N64-R6-NEXT:    sw $2, 0($1)
; N64-R6-NEXT:  .LBB0_4: # %end
; N64-R6-NEXT:    jrc $ra
entry:
  %cmp = icmp eq i32 %s, 0
  br i1 %cmp, label %end, label %then

then:
  store i32 1, i32* @x, align 4
  br label %end

end:
  ret void

}
