; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=AVX-32 --check-prefix=AVX1-32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=AVX-64 --check-prefix=AVX1-64
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=AVX-32 --check-prefix=AVX2-32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=AVX-64 --check-prefix=AVX2-64

define <4 x double> @test_buildvector_v4f64(double %a0, double %a1, double %a2, double %a3) {
; AVX-32-LABEL: test_buildvector_v4f64:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    vmovups {{[0-9]+}}(%esp), %ymm0
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_buildvector_v4f64:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX-64-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX-64-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-64-NEXT:    retq
  %ins0 = insertelement <4 x double> undef, double %a0, i32 0
  %ins1 = insertelement <4 x double> %ins0, double %a1, i32 1
  %ins2 = insertelement <4 x double> %ins1, double %a2, i32 2
  %ins3 = insertelement <4 x double> %ins2, double %a3, i32 3
  ret <4 x double> %ins3
}

define <8 x float> @test_buildvector_v8f32(float %a0, float %a1, float %a2, float %a3, float %a4, float %a5, float %a6, float %a7) {
; AVX-32-LABEL: test_buildvector_v8f32:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    vmovups {{[0-9]+}}(%esp), %ymm0
; AVX-32-NEXT:    retl
;
; AVX-64-LABEL: test_buildvector_v8f32:
; AVX-64:       # %bb.0:
; AVX-64-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[2,3]
; AVX-64-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0,1],xmm6[0],xmm4[3]
; AVX-64-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0,1,2],xmm7[0]
; AVX-64-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[2,3]
; AVX-64-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm2[0],xmm0[3]
; AVX-64-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm3[0]
; AVX-64-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX-64-NEXT:    retq
  %ins0 = insertelement <8 x float> undef, float %a0, i32 0
  %ins1 = insertelement <8 x float> %ins0, float %a1, i32 1
  %ins2 = insertelement <8 x float> %ins1, float %a2, i32 2
  %ins3 = insertelement <8 x float> %ins2, float %a3, i32 3
  %ins4 = insertelement <8 x float> %ins3, float %a4, i32 4
  %ins5 = insertelement <8 x float> %ins4, float %a5, i32 5
  %ins6 = insertelement <8 x float> %ins5, float %a6, i32 6
  %ins7 = insertelement <8 x float> %ins6, float %a7, i32 7
  ret <8 x float> %ins7
}

define <4 x i64> @test_buildvector_v4i64(i64 %a0, i64 %a1, i64 %a2, i64 %a3) {
; AVX-32-LABEL: test_buildvector_v4i64:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    vmovups {{[0-9]+}}(%esp), %ymm0
; AVX-32-NEXT:    retl
;
; AVX1-64-LABEL: test_buildvector_v4i64:
; AVX1-64:       # %bb.0:
; AVX1-64-NEXT:    vmovq %rcx, %xmm0
; AVX1-64-NEXT:    vmovq %rdx, %xmm1
; AVX1-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-64-NEXT:    vmovq %rsi, %xmm1
; AVX1-64-NEXT:    vmovq %rdi, %xmm2
; AVX1-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX1-64-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-64-NEXT:    retq
;
; AVX2-64-LABEL: test_buildvector_v4i64:
; AVX2-64:       # %bb.0:
; AVX2-64-NEXT:    vmovq %rcx, %xmm0
; AVX2-64-NEXT:    vmovq %rdx, %xmm1
; AVX2-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-64-NEXT:    vmovq %rsi, %xmm1
; AVX2-64-NEXT:    vmovq %rdi, %xmm2
; AVX2-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-64-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-64-NEXT:    retq
  %ins0 = insertelement <4 x i64> undef, i64 %a0, i32 0
  %ins1 = insertelement <4 x i64> %ins0, i64 %a1, i32 1
  %ins2 = insertelement <4 x i64> %ins1, i64 %a2, i32 2
  %ins3 = insertelement <4 x i64> %ins2, i64 %a3, i32 3
  ret <4 x i64> %ins3
}

define <8 x i32> @test_buildvector_v8i32(i32 %a0, i32 %a1, i32 %a2, i32 %a3, i32 %a4, i32 %a5, i32 %a6, i32 %a7) {
; AVX-32-LABEL: test_buildvector_v8i32:
; AVX-32:       # %bb.0:
; AVX-32-NEXT:    vmovups {{[0-9]+}}(%esp), %ymm0
; AVX-32-NEXT:    retl
;
; AVX1-64-LABEL: test_buildvector_v8i32:
; AVX1-64:       # %bb.0:
; AVX1-64-NEXT:    vmovd %edi, %xmm0
; AVX1-64-NEXT:    vpinsrd $1, %esi, %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrd $2, %edx, %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrd $3, %ecx, %xmm0, %xmm0
; AVX1-64-NEXT:    vmovd %r8d, %xmm1
; AVX1-64-NEXT:    vpinsrd $1, %r9d, %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrd $2, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrd $3, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-64-NEXT:    retq
;
; AVX2-64-LABEL: test_buildvector_v8i32:
; AVX2-64:       # %bb.0:
; AVX2-64-NEXT:    vmovd %edi, %xmm0
; AVX2-64-NEXT:    vpinsrd $1, %esi, %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrd $2, %edx, %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrd $3, %ecx, %xmm0, %xmm0
; AVX2-64-NEXT:    vmovd %r8d, %xmm1
; AVX2-64-NEXT:    vpinsrd $1, %r9d, %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrd $2, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrd $3, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-64-NEXT:    retq
  %ins0 = insertelement <8 x i32> undef, i32 %a0, i32 0
  %ins1 = insertelement <8 x i32> %ins0, i32 %a1, i32 1
  %ins2 = insertelement <8 x i32> %ins1, i32 %a2, i32 2
  %ins3 = insertelement <8 x i32> %ins2, i32 %a3, i32 3
  %ins4 = insertelement <8 x i32> %ins3, i32 %a4, i32 4
  %ins5 = insertelement <8 x i32> %ins4, i32 %a5, i32 5
  %ins6 = insertelement <8 x i32> %ins5, i32 %a6, i32 6
  %ins7 = insertelement <8 x i32> %ins6, i32 %a7, i32 7
  ret <8 x i32> %ins7
}

define <16 x i16> @test_buildvector_v16i16(i16 %a0, i16 %a1, i16 %a2, i16 %a3, i16 %a4, i16 %a5, i16 %a6, i16 %a7, i16 %a8, i16 %a9, i16 %a10, i16 %a11, i16 %a12, i16 %a13, i16 %a14, i16 %a15) {
; AVX1-32-LABEL: test_buildvector_v16i16:
; AVX1-32:       # %bb.0:
; AVX1-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX1-32-NEXT:    vpinsrw $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrw $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrw $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrw $4, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrw $5, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrw $6, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrw $7, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX1-32-NEXT:    vpinsrw $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrw $2, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrw $3, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrw $4, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrw $5, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrw $6, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrw $7, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-32-NEXT:    retl
;
; AVX1-64-LABEL: test_buildvector_v16i16:
; AVX1-64:       # %bb.0:
; AVX1-64-NEXT:    vmovd %edi, %xmm0
; AVX1-64-NEXT:    vpinsrw $1, %esi, %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrw $2, %edx, %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrw $3, %ecx, %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrw $4, %r8d, %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrw $5, %r9d, %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrw $6, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrw $7, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX1-64-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX1-64-NEXT:    vpinsrw $1, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrw $2, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrw $3, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrw $4, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrw $5, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrw $6, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrw $7, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-64-NEXT:    retq
;
; AVX2-32-LABEL: test_buildvector_v16i16:
; AVX2-32:       # %bb.0:
; AVX2-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX2-32-NEXT:    vpinsrw $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrw $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrw $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrw $4, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrw $5, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrw $6, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrw $7, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX2-32-NEXT:    vpinsrw $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrw $2, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrw $3, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrw $4, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrw $5, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrw $6, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrw $7, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-32-NEXT:    retl
;
; AVX2-64-LABEL: test_buildvector_v16i16:
; AVX2-64:       # %bb.0:
; AVX2-64-NEXT:    vmovd %edi, %xmm0
; AVX2-64-NEXT:    vpinsrw $1, %esi, %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrw $2, %edx, %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrw $3, %ecx, %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrw $4, %r8d, %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrw $5, %r9d, %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrw $6, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrw $7, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX2-64-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX2-64-NEXT:    vpinsrw $1, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrw $2, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrw $3, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrw $4, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrw $5, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrw $6, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrw $7, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-64-NEXT:    retq
  %ins0  = insertelement <16 x i16> undef,  i16 %a0,  i32 0
  %ins1  = insertelement <16 x i16> %ins0,  i16 %a1,  i32 1
  %ins2  = insertelement <16 x i16> %ins1,  i16 %a2,  i32 2
  %ins3  = insertelement <16 x i16> %ins2,  i16 %a3,  i32 3
  %ins4  = insertelement <16 x i16> %ins3,  i16 %a4,  i32 4
  %ins5  = insertelement <16 x i16> %ins4,  i16 %a5,  i32 5
  %ins6  = insertelement <16 x i16> %ins5,  i16 %a6,  i32 6
  %ins7  = insertelement <16 x i16> %ins6,  i16 %a7,  i32 7
  %ins8  = insertelement <16 x i16> %ins7,  i16 %a8,  i32 8
  %ins9  = insertelement <16 x i16> %ins8,  i16 %a9,  i32 9
  %ins10 = insertelement <16 x i16> %ins9,  i16 %a10, i32 10
  %ins11 = insertelement <16 x i16> %ins10, i16 %a11, i32 11
  %ins12 = insertelement <16 x i16> %ins11, i16 %a12, i32 12
  %ins13 = insertelement <16 x i16> %ins12, i16 %a13, i32 13
  %ins14 = insertelement <16 x i16> %ins13, i16 %a14, i32 14
  %ins15 = insertelement <16 x i16> %ins14, i16 %a15, i32 15
  ret <16 x i16> %ins15
}

define <32 x i8> @test_buildvector_v32i8(i8 %a0, i8 %a1, i8 %a2, i8 %a3, i8 %a4, i8 %a5, i8 %a6, i8 %a7, i8 %a8, i8 %a9, i8 %a10, i8 %a11, i8 %a12, i8 %a13, i8 %a14, i8 %a15, i8 %a16, i8 %a17, i8 %a18, i8 %a19, i8 %a20, i8 %a21, i8 %a22, i8 %a23, i8 %a24, i8 %a25, i8 %a26, i8 %a27, i8 %a28, i8 %a29, i8 %a30, i8 %a31) {
; AVX1-32-LABEL: test_buildvector_v32i8:
; AVX1-32:       # %bb.0:
; AVX1-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX1-32-NEXT:    vpinsrb $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrb $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrb $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrb $4, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrb $5, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrb $6, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrb $7, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrb $8, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrb $9, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrb $10, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrb $11, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrb $12, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrb $13, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrb $14, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vpinsrb $15, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX1-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX1-32-NEXT:    vpinsrb $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrb $2, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrb $3, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrb $4, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrb $5, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrb $6, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrb $7, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrb $8, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrb $9, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrb $10, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrb $11, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrb $12, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrb $13, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrb $14, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vpinsrb $15, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX1-32-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-32-NEXT:    retl
;
; AVX1-64-LABEL: test_buildvector_v32i8:
; AVX1-64:       # %bb.0:
; AVX1-64-NEXT:    vmovd %edi, %xmm0
; AVX1-64-NEXT:    vpinsrb $1, %esi, %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrb $2, %edx, %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrb $3, %ecx, %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrb $4, %r8d, %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrb $5, %r9d, %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrb $6, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrb $7, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrb $8, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrb $9, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrb $10, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrb $11, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrb $12, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrb $13, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrb $14, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX1-64-NEXT:    vpinsrb $15, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX1-64-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX1-64-NEXT:    vpinsrb $1, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrb $2, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrb $3, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrb $4, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrb $5, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrb $6, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrb $7, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrb $8, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrb $9, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrb $10, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrb $11, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrb $12, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrb $13, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrb $14, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vpinsrb $15, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX1-64-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-64-NEXT:    retq
;
; AVX2-32-LABEL: test_buildvector_v32i8:
; AVX2-32:       # %bb.0:
; AVX2-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX2-32-NEXT:    vpinsrb $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrb $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrb $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrb $4, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrb $5, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrb $6, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrb $7, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrb $8, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrb $9, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrb $10, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrb $11, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrb $12, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrb $13, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrb $14, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vpinsrb $15, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX2-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX2-32-NEXT:    vpinsrb $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrb $2, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrb $3, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrb $4, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrb $5, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrb $6, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrb $7, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrb $8, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrb $9, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrb $10, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrb $11, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrb $12, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrb $13, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrb $14, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vpinsrb $15, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX2-32-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-32-NEXT:    retl
;
; AVX2-64-LABEL: test_buildvector_v32i8:
; AVX2-64:       # %bb.0:
; AVX2-64-NEXT:    vmovd %edi, %xmm0
; AVX2-64-NEXT:    vpinsrb $1, %esi, %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrb $2, %edx, %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrb $3, %ecx, %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrb $4, %r8d, %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrb $5, %r9d, %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrb $6, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrb $7, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrb $8, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrb $9, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrb $10, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrb $11, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrb $12, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrb $13, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrb $14, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX2-64-NEXT:    vpinsrb $15, {{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX2-64-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX2-64-NEXT:    vpinsrb $1, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrb $2, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrb $3, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrb $4, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrb $5, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrb $6, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrb $7, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrb $8, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrb $9, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrb $10, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrb $11, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrb $12, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrb $13, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrb $14, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vpinsrb $15, {{[0-9]+}}(%rsp), %xmm1, %xmm1
; AVX2-64-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-64-NEXT:    retq
  %ins0  = insertelement <32 x i8> undef,  i8 %a0,  i32 0
  %ins1  = insertelement <32 x i8> %ins0,  i8 %a1,  i32 1
  %ins2  = insertelement <32 x i8> %ins1,  i8 %a2,  i32 2
  %ins3  = insertelement <32 x i8> %ins2,  i8 %a3,  i32 3
  %ins4  = insertelement <32 x i8> %ins3,  i8 %a4,  i32 4
  %ins5  = insertelement <32 x i8> %ins4,  i8 %a5,  i32 5
  %ins6  = insertelement <32 x i8> %ins5,  i8 %a6,  i32 6
  %ins7  = insertelement <32 x i8> %ins6,  i8 %a7,  i32 7
  %ins8  = insertelement <32 x i8> %ins7,  i8 %a8,  i32 8
  %ins9  = insertelement <32 x i8> %ins8,  i8 %a9,  i32 9
  %ins10 = insertelement <32 x i8> %ins9,  i8 %a10, i32 10
  %ins11 = insertelement <32 x i8> %ins10, i8 %a11, i32 11
  %ins12 = insertelement <32 x i8> %ins11, i8 %a12, i32 12
  %ins13 = insertelement <32 x i8> %ins12, i8 %a13, i32 13
  %ins14 = insertelement <32 x i8> %ins13, i8 %a14, i32 14
  %ins15 = insertelement <32 x i8> %ins14, i8 %a15, i32 15
  %ins16 = insertelement <32 x i8> %ins15, i8 %a16, i32 16
  %ins17 = insertelement <32 x i8> %ins16, i8 %a17, i32 17
  %ins18 = insertelement <32 x i8> %ins17, i8 %a18, i32 18
  %ins19 = insertelement <32 x i8> %ins18, i8 %a19, i32 19
  %ins20 = insertelement <32 x i8> %ins19, i8 %a20, i32 20
  %ins21 = insertelement <32 x i8> %ins20, i8 %a21, i32 21
  %ins22 = insertelement <32 x i8> %ins21, i8 %a22, i32 22
  %ins23 = insertelement <32 x i8> %ins22, i8 %a23, i32 23
  %ins24 = insertelement <32 x i8> %ins23, i8 %a24, i32 24
  %ins25 = insertelement <32 x i8> %ins24, i8 %a25, i32 25
  %ins26 = insertelement <32 x i8> %ins25, i8 %a26, i32 26
  %ins27 = insertelement <32 x i8> %ins26, i8 %a27, i32 27
  %ins28 = insertelement <32 x i8> %ins27, i8 %a28, i32 28
  %ins29 = insertelement <32 x i8> %ins28, i8 %a29, i32 29
  %ins30 = insertelement <32 x i8> %ins29, i8 %a30, i32 30
  %ins31 = insertelement <32 x i8> %ins30, i8 %a31, i32 31
  ret <32 x i8> %ins31
}

; PR30780

define <8 x i32> @test_buildvector_v8i32_splat_sext_i8(i8 %in) {
; AVX1-32-LABEL: test_buildvector_v8i32_splat_sext_i8:
; AVX1-32:       # %bb.0:
; AVX1-32-NEXT:    movsbl {{[0-9]+}}(%esp), %eax
; AVX1-32-NEXT:    vmovd %eax, %xmm0
; AVX1-32-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-32-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-32-NEXT:    retl
;
; AVX1-64-LABEL: test_buildvector_v8i32_splat_sext_i8:
; AVX1-64:       # %bb.0:
; AVX1-64-NEXT:    movsbl %dil, %eax
; AVX1-64-NEXT:    vmovd %eax, %xmm0
; AVX1-64-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-64-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-64-NEXT:    retq
;
; AVX2-32-LABEL: test_buildvector_v8i32_splat_sext_i8:
; AVX2-32:       # %bb.0:
; AVX2-32-NEXT:    movsbl {{[0-9]+}}(%esp), %eax
; AVX2-32-NEXT:    vmovd %eax, %xmm0
; AVX2-32-NEXT:    vpbroadcastd %xmm0, %ymm0
; AVX2-32-NEXT:    retl
;
; AVX2-64-LABEL: test_buildvector_v8i32_splat_sext_i8:
; AVX2-64:       # %bb.0:
; AVX2-64-NEXT:    movsbl %dil, %eax
; AVX2-64-NEXT:    vmovd %eax, %xmm0
; AVX2-64-NEXT:    vpbroadcastd %xmm0, %ymm0
; AVX2-64-NEXT:    retq
  %ext = sext i8 %in to i32
  %insert = insertelement <8 x i32> undef, i32 %ext, i32 0
  %splat = shufflevector <8 x i32> %insert, <8 x i32> undef, <8 x i32> zeroinitializer
  ret <8 x i32> %splat
}

define <8 x i32> @test_buildvector_v8i32_splat_zext_i8(i8 %in) {
; AVX1-32-LABEL: test_buildvector_v8i32_splat_zext_i8:
; AVX1-32:       # %bb.0:
; AVX1-32-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; AVX1-32-NEXT:    vmovd %eax, %xmm0
; AVX1-32-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-32-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-32-NEXT:    retl
;
; AVX1-64-LABEL: test_buildvector_v8i32_splat_zext_i8:
; AVX1-64:       # %bb.0:
; AVX1-64-NEXT:    movzbl %dil, %eax
; AVX1-64-NEXT:    vmovd %eax, %xmm0
; AVX1-64-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,0,0]
; AVX1-64-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-64-NEXT:    retq
;
; AVX2-32-LABEL: test_buildvector_v8i32_splat_zext_i8:
; AVX2-32:       # %bb.0:
; AVX2-32-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; AVX2-32-NEXT:    vmovd %eax, %xmm0
; AVX2-32-NEXT:    vpbroadcastd %xmm0, %ymm0
; AVX2-32-NEXT:    retl
;
; AVX2-64-LABEL: test_buildvector_v8i32_splat_zext_i8:
; AVX2-64:       # %bb.0:
; AVX2-64-NEXT:    movzbl %dil, %eax
; AVX2-64-NEXT:    vmovd %eax, %xmm0
; AVX2-64-NEXT:    vpbroadcastd %xmm0, %ymm0
; AVX2-64-NEXT:    retq
  %ext = zext i8 %in to i32
  %insert = insertelement <8 x i32> undef, i32 %ext, i32 0
  %splat = shufflevector <8 x i32> %insert, <8 x i32> undef, <8 x i32> zeroinitializer
  ret <8 x i32> %splat
}
