#!/usr/bin/env python3

import os
import re
import sys

def main(argv):
    ensure_types = []
    print('/* This file was generated by gen-plublic-types.py, do not edit it. */\n')

    # Run through the headers fed in to #include them and extract the ADW_TYPE_* macros
    for header in argv[1:]:
        print('#include "%s"' % os.path.basename(header))
        with open(header, 'r') as file:
            for line in file:
                match = re.search(r'#define {1,}(ADW_TYPE_[A-Z0-9_]{1,}) {1,}.*', line)
                if match:
                    ensure_types.append(match.group(1))

    ensure_types.sort()

    print('#include "adw-main-private.h"\n')
    print('void')
    print('adw_init_public_types (void)')
    print('{')

    for gtype in ensure_types:
        print('  g_type_ensure (%s);' % gtype)

    print('}')

main(sys.argv)
