/*
 * Decompiled with CFR 0.152.
 */
package org.xmlopen.zipspy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Utils {
    public static void streamClose(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void streamClose(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int readIntLittle(byte[] b) throws IOException {
        int n = 0xFF & b[3];
        n <<= 8;
        n |= 0xFF & b[2];
        n <<= 8;
        n |= 0xFF & b[1];
        n <<= 8;
        return n |= 0xFF & b[0];
    }

    public static int readIntLittle(InputStream is) throws IOException {
        byte[] b = new byte[4];
        is.read(b);
        return Utils.readIntLittle(b);
    }

    public static short readShortLittle(InputStream is) throws IOException {
        byte[] b = new byte[2];
        is.read(b);
        int n = 0xFF & b[1];
        n <<= 8;
        return (short)(n |= 0xFF & b[0]);
    }

    public static String makeElement(String name, Object o) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(name);
        sb.append(">");
        sb.append(o.toString());
        sb.append("</");
        sb.append(name);
        sb.append(">");
        return sb.toString();
    }

    public static String makeByteElement(String name, byte[] b) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(name);
        sb.append(">");
        for (int i = 0; i < b.length; ++i) {
            sb.append("<byte>");
            sb.append(Integer.toHexString(0xFF & b[i]).toUpperCase());
            sb.append("</byte>");
        }
        sb.append("</");
        sb.append(name);
        sb.append(">");
        return sb.toString();
    }
}

