/* @test %I% %E%
   @bug 4028605 4109069
   @summary Make sure ZipInputStream/InflaterInputStream.available() will
            return 0 after EOF has reached and 1 otherwise.
   */


import java.io.*;
import java.util.zip.*;

public class Available {
    static test(InputStream in) {
        byte[] buf = new byte[1024];
        int n;

        while ((n = in.read(buf)) != -1);
        if (in.available() != 0) {
            throw new Exception("available should return 0 after EOF");
        }
    }
    
    public static void main(String[] args) throws Exception {
        File f = new File(System.getProperty("test.src", "."), "input.jar");

        // test ZipInputStream
        ZipInputStream z = new ZipInputStream(new FileInputStream(f));
        z.getNextEntry();
        test(z);
        
        // test InflaterInputStream
        ZipFile zfile = new ZipFile(f);
        test(zfile.getInputStream(zfile.getEntry("Available.java")));
    }
}
