// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "net/quic/quic_alarm.h"

#include "base/logging.h"

namespace net {

QuicAlarm::QuicAlarm(Delegate* delegate)
    : delegate_(delegate),
      deadline_(QuicTime::Zero()) {
}

QuicAlarm::~QuicAlarm() {}

void QuicAlarm::Set(QuicTime deadline) {
  DCHECK(!IsSet());
  DCHECK(deadline.IsInitialized());
  deadline_ = deadline;
  SetImpl();
}

void QuicAlarm::Cancel() {
  deadline_ = QuicTime::Zero();
  CancelImpl();
}

bool QuicAlarm::IsSet() const {
  return deadline_.IsInitialized();
}

void QuicAlarm::Fire() {
  if (!deadline_.IsInitialized()) {
    return;
  }

  deadline_ = QuicTime::Zero();
  QuicTime deadline = delegate_->OnAlarm();
  // delegate_->OnAlarm() might call Set(), in which case  deadline_ will
  // already contain the new value, so don't overwrite it.
  if (!deadline_.IsInitialized() && deadline.IsInitialized()) {
    Set(deadline);
  }
}

}  // namespace net
