/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMessageChannel.h"

#include "JSMessagePort.h"
#include "MessageChannel.h"
#include "MessagePort.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMessageChannel);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSMessageChannelTableValues[4] =
{
    { "port1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageChannelPort1), (intptr_t)0 THUNK_GENERATOR(0) },
    { "port2", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageChannelPort2), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageChannelConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSMessageChannelTable = { 8, 7, JSMessageChannelTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSMessageChannelConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSMessageChannelConstructorTable = { 1, 0, JSMessageChannelConstructorTableValues, 0 };
const ClassInfo JSMessageChannelConstructor::s_info = { "MessageChannelConstructor", &DOMConstructorObject::s_info, &JSMessageChannelConstructorTable, 0 };

JSMessageChannelConstructor::JSMessageChannelConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSMessageChannelPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSMessageChannelConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessageChannelConstructor, JSDOMWrapper>(exec, &JSMessageChannelConstructorTable, this, propertyName, slot);
}

bool JSMessageChannelConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMessageChannelConstructor, JSDOMWrapper>(exec, &JSMessageChannelConstructorTable, this, propertyName, descriptor);
}

ConstructType JSMessageChannelConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSMessageChannel;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSMessageChannelPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSMessageChannelPrototypeTable = { 1, 0, JSMessageChannelPrototypeTableValues, 0 };
static const HashTable* getJSMessageChannelPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessageChannelPrototypeTable);
}

const ClassInfo JSMessageChannelPrototype::s_info = { "MessageChannelPrototype", &JSC::JSObjectWithGlobalObject::s_info, 0, getJSMessageChannelPrototypeTable };

JSObject* JSMessageChannelPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMessageChannel>(exec, globalObject);
}

static const HashTable* getJSMessageChannelTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessageChannelTable);
}

const ClassInfo JSMessageChannel::s_info = { "MessageChannel", &JSDOMWrapper::s_info, 0, getJSMessageChannelTable };

JSMessageChannel::JSMessageChannel(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MessageChannel> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSMessageChannel::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSMessageChannelPrototype(exec->globalData(), globalObject, JSMessageChannelPrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

bool JSMessageChannel::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessageChannel, Base>(exec, getJSMessageChannelTable(exec), this, propertyName, slot);
}

bool JSMessageChannel::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMessageChannel, Base>(exec, getJSMessageChannelTable(exec), this, propertyName, descriptor);
}

JSValue jsMessageChannelPort1(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMessageChannel* castedThis = static_cast<JSMessageChannel*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MessageChannel* imp = static_cast<MessageChannel*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->port1()));
    return result;
}


JSValue jsMessageChannelPort2(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMessageChannel* castedThis = static_cast<JSMessageChannel*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MessageChannel* imp = static_cast<MessageChannel*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->port2()));
    return result;
}


JSValue jsMessageChannelConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMessageChannel* domObject = static_cast<JSMessageChannel*>(asObject(slotBase));
    return JSMessageChannel::getConstructor(exec, domObject->globalObject());
}

JSValue JSMessageChannel::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMessageChannelConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, MessageChannel* impl)
{
    return wrap<JSMessageChannel>(exec, globalObject, impl);
}

MessageChannel* toMessageChannel(JSC::JSValue value)
{
    return value.inherits(&JSMessageChannel::s_info) ? static_cast<JSMessageChannel*>(asObject(value))->impl() : 0;
}

}
