## RabbitMQ 3.7.14

RabbitMQ `3.7.14` is a maintenance release. It focuses on bug fixes and minor usability improvements. This release [**requires Erlang/OTP 20.3**](https://www.rabbitmq.com/which-erlang.html) or later.

### Erlang/OTP Compatibility Notes

Per the new Erlang version support policy in effect starting with January 2019,
this release [**no longer supports Erlang/OTP 19.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains what package repositories and tools can be used to provision latest patch versions of Erlang `20.3.x` and `21.x`.

### Compatibility Notes

#### Minimum Required Erlang Version

This release requires Erlang/OTP 20.3 or later.

#### Upgrading to Erlang 21.x

When upgrading to this release **and upgrading Erlang to 21.x** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade and compatibility notes if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Enhancements

 * TCP and TLS listeners are started later to reduce the probability of clients connecting to and performing operations
   on a node that's not fully initialised.

   GitHub issue: [rabbitmq/rabbitmq-server#1869](https://github.com/rabbitmq/rabbitmq-server/issues/1869)

 * Reduced schema data store locking for binding operations.

   GitHub issue: [rabbitmq/rabbitmq-server#1900](https://github.com/rabbitmq/rabbitmq-server/pull/1900)


### CLI Tools

#### Enhancements

 * More informative and user-friendly help messages produced by `help` and `help [command]` commands.

   GitHub issue: [rabbitmq/rabbitmq-cli#332](https://github.com/rabbitmq/rabbitmq-cli/pull/332)


### Management Plugin

#### Bug Fixes

 * Groups of upstream URIs were not formatted correctly.

    Contributed by [Grigory Starinkin](https://github.com/velimir).

    GitHub issue: [rabbitmq/rabbitmq-management#683](https://github.com/rabbitmq/rabbitmq-management/pull/683)

#### Enhancements

 * `management.load_definitions` now can point at a directory of definition files, not just a single file.

   GitHub issue: [rabbitmq/rabbitmq-management#665](https://github.com/rabbitmq/rabbitmq-management/issues/665)


### Federation Plugin

#### Bug Fixes

 * Federation links could fail to start with an `{error, already_started}`.

   GitHub issues: [rabbitmq/rabbitmq-federation#84](https://github.com/rabbitmq/rabbitmq-federation/issues/84), [rabbitmq/rabbitmq-federation#87](https://github.com/rabbitmq/rabbitmq-federation/pull/87)


### RPM Package

#### Bug Fixes

 * RPM package post-install scripts now restart the node in case it was running before the upgrade.

   GitHub issue: [rabbitmq/rabbitmq-server-release#94](https://github.com/rabbitmq/rabbitmq-server-release/issues/94)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.7.14.tar.gz`.
