/* Identities */

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  9, X'3045310B300906035504061302434831193017060355040A13104C696E7578207374726F6E675377616E311B3019060355040313127374726F6E675377616E20526F6F74204341'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'5da7dd700651327ee7b66db3b5e5e060ea2e4def'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'ae096b87b44886d3b820978623dabd0eae22ebbc'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, OU=Research, CN=Research CA */
  9, X'3051310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e3111300f060355040b13085265736561726368311430120603550403130b5265736561726368204341'
);

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, OU=Research, CN=Research CA' */
  11, X'e775f0a0f2ad20cdcd6023ccc7c80f29f3dd5420');

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, OU=Research, CN=Research CA' */
  11, X'c71449851517718914a496532a1ee801b21c6aa5');

INSERT INTO identities (
  type, data
) VALUES ( /* carol@strongswan.org */
  3, X'6361726f6c407374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, OU=Research, CN=carol@strongswan.org' */
  11, X'5da9f9ef80718d3a883938e2de6e6624989fdf69'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* moon.strongswan.org */
  2, X'6d6f6f6e2e7374726f6e677377616e2e6f7267'
 );

/* Certificates */

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  1, 1, X'308203b8308202a0a003020102020100300d06092a864886f70d01010b05003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3034303931303130303131385a170d3139303930373130303131385a3045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f7420434130820122300d06092a864886f70d01010105000382010f003082010a0282010100bff25f62ea3d566e58b3c87a49caf3ac61cfa96377734d842db3f8fd6ea023f7b0132e66265012317386729c6d7c427a8d9f167be138e8ebae2b12b95933baef36a315c3ddf224cee4bb9bd578135d0467382629621ff96b8d45f6e002e5083662dce181805c140b3f2ce93f83aee3c861cff610a39f0189cb3a3c7cb9bf7e2a09544e2170efaa18fdd4ff20fa94be176d7fecff821f68d17152041d9b46f0cfcfc1e4cf43de5d3f3a587763afe9267f53b11699b3264fc55c5189f5682871166cb98307950569641fa30ffb50de134fed2f973cef1a392827862bc4ddaa97bbb01442e293c41070d07224d4be47ae2753eb2bed4bc1da91c68ec780c4620f0f0203010001a381b23081af30120603551d130101ff040830060101ff020101300b0603551d0f040403020106301d0603551d0e041604145da7dd700651327ee7b66db3b5e5e060ea2e4def306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d01010b0500038201010023929aa101b412d1f5a577532088f209b34798a72ed7bd6945d74beaa2b3a1768764ad7f8b0df8d97a1a3ed1102e92a5f107e3059dc2250be49d02261ca83a342e0e5de7d43c37744e3fcea3197720ca1184d4ef94e6beeb0d241746b0b92b7fb1004c08e88bf9eb4ce60f3e149466f3e9fc3f98bce449f448f9d465e52b59f0101e6203cfad0d89e23509fa043d4c12021e8f32be7db8b2edbada641d64aa1a04af64a2ee5b814a753dd76b30e3de04f3c6b61166e632f8364d51cf3730a9564a4d93b9227c28b09b0f5595d92a632f72fe509a129ca9ee54df2b0edc6c3d38564f10256efcd8be82b2ec64977e3a6f5ef098eaa7f00662a6cded16cb80637c'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, OU=Research, CN=Research CA */
  1, 1, X'308203c1308202a9a003020102020120300d06092a864886f70d01010b05003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3130303430363039353335305a170d3139303430343039353335305a3051310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e3111300f060355040b13085265736561726368311430120603550403130b526573656172636820434130820122300d06092a864886f70d01010105000382010f003082010a0282010100b639b23aa6e0075b58a73f4fb25a856a72f71b5d3db1e780137a95b9e961a1dfaf19c6b2f9831421591c277b7a046a43f02e2471dc12fdc351d7c9596032a559d4bdd95ca79f21063a717d33d73fd203071cd0690c94cec13120658e5546367bbc49e412819d7564a24de1b58e07af519da8d87edcb1266de809067813452471e0f289e7814efdbefc2d4cc1fab331af3c70fe59c8f2312602d2a5ba043b73d6ae31e142cfe3669527e74a85a11cde6a9bed2234acb40bedb922e13c36afa2de3b41888f01c01a87637bb622e7e5521f4d73d77f47abc6b113cc1ecdf45f51dafe6d14838f78fb0c2ac1f1016518f3c4c98c17fd521b82351374c3389decae390203010001a381af3081ac300f0603551d130101ff040530030101ff300b0603551d0f040403020106301d0603551d0e04160414e775f0a0f2ad20cdcd6023ccc7c80f29f3dd5420306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d01010b050003820101008d6da16d1b2dcc815c0a3215e2ca1b2e1289b70d059b3fae80a173051abf47e8c8b74260c60528478738bbc8b1322389fa58e0c3f2dd20604395e972ce6f385c16f7b8cce987c1caa8f1e3eeea4c1a8e68b31705b789dcb230432262ae9a8767396c3ac71c8710a370c00c3ce0469968e974ea942e82e5c17f44161040dab11907589a9a06d4279339791344b9b9bcc51e816b0ff4391cffb6dfadc42f63c5c8c7a099ce155d2cb3b5ecddddf63ea86f286801c6354b672ab7cc3feb306db15d5c8a3d4e3acde94c08fd5476c33adad2f5730022e2ca246b4d8642b3ffaf00611eddb66c930de2036ce4d4af8537638e0c156332eeeb7205601bd6f2c1668992'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, OU=Research, CN=carol@strongswan.org */
  1, 1, X'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');

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 1
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 2
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 3
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 4 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 5 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 6 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  3, 7 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  3, 8 
);

/* Private Keys */

INSERT INTO private_keys (
   type, data
) VALUES ( /* key of 'C=CH, O=Linux strongSwan, OU=Research, CN=carol@strongswan.org' */
  1, X'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'
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 7 
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 8 
);

/* Configurations */

INSERT INTO ike_configs (
  local, remote
) VALUES (
  'PH_IP_CAROL', 'PH_IP_MOON'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id
) VALUES (
  'home', 1, 7, 9 
);

INSERT INTO child_configs (
  name, updown
) VALUES (
  'home', '/usr/local/libexec/ipsec/_updown iptables'
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 1
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES ( /* 10.1.0.0/16 */
  7, X'0a010000', X'0a01ffff'
);

INSERT INTO traffic_selectors (
  type
) VALUES ( /* dynamic/32 */
  7
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  1, 1, 1
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  1, 2, 2
);

