.TH MF 1 "17 January 2018" "Web2C @VERSION@"
.\"=====================================================================
.if n .ds MF Metafont
.if t .ds MF Metafont
.if t .ds TX \fRT\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\v'+0.25m'E\v'-0.25m'X\fP
.el .ds OX TeX
.\" BX definition must follow TX so BX can use TX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.if n .ds BX BibTeX
.\" LX definition must follow TX so LX can use TX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds LX LaTeX
.if n .ds WB Web
.if t .ds WB W\s-2EB\s0
.\"=====================================================================
.SH NAME
mf, inimf, mf-nowin \- Metafont, a language for font and logo design
.SH SYNOPSIS
.B mf
.RI [ options ]
.RI [ commands ]
.\"=====================================================================
.SH DESCRIPTION
\*(MF reads the program in the specified files
and outputs font rasters (in
.I gf
format) and font metrics (in
.I tfm
format).  The \*(MF
language is described in
.IR "The \*(MF\^book" .
.PP
Like
\*(TX, \*(MF
is normally used with a large body of precompiled macros, and font generation
in particular requires the support of several macro files.  This
version of \*(MF looks at its command line to see what name it was
called under.  Both
.B inimf
and
.B virmf
are symlinks to the
.B mf
executable.  When called as
.BR inimf
(or when the
.B -ini
option is given) it can be used to precompile macros into a
.I .base
file.  When called as
.B virmf
it will use the
.I plain
base.  When called under any other name, \*(MF will use that name as
the name of the base to use.  For example, when called as
.B mf
the
.I mf
base is used, which is identical to the
.I plain
base.  Other bases than
.I plain
are rarely used.
.PP
The
.I commands
given on the command line to the \*(MF program are passed to it as the
first input line.  (But it is often easier to type extended arguments
as the first input line, since UNIX shells tend to gobble up or
misinterpret \*(MF's favorite symbols, like semicolons, unless you
quote them.)  As described in
.IR "The \*(MF\^book" ,
that first line should begin with a filename, a
.RI \e controlsequence ,
or a
.IR &basename .
.PP
The normal usage is to say
.IP
\fBmf\ \fP '\\\|mode=<printengine>\^;\^ [\^mag=magstep(\fI\^n\fP\^)\^;\^]' input\ \^\fI font \fP
.PP
to start processing
.IR font.mf .
The single quotes are the best way of keeping the Unix
shell from misinterpreting the semicolons and
from removing the \\ character, which is needed here to
keep \*(MF from thinking that you want to produce a font called
.IR mode .
(Or you can just say
.I mf
and give the other stuff on the next line, without quotes.)  Other
control sequences, such as
.I batchmode
(for silent operation) can also appear.
The name
.I font
will be the ``jobname'', and is used in forming
output file names.
If \*(MF doesn't get a file name in the first line,
the jobname is
.IR mfput .
The default extension,
.IR .mf ,
can be overridden by specifying an extension explicitly.
.PP
A log of error messages goes into the file \fIjobname\fP\fB\^.\^\fP\fIlog\fP.
The output files are \fIjobname\fP\fB\^.\^\fP\fItfm\fP and
\fIjobname\fP\fB\^.\^\fP\fI<\fP\^number\^\fI>gf\fP, where <number> depends on
the resolution and magnification of the font.  The
.I mode
in this
example is shown generically as <printengine>, a symbolic term for which
the name of an actual device or, most commonly, the name
.I localfont
(see below) must
be substituted.  If the mode is not specified or is not valid for your
site, \*(MF will default to
.I proof
mode which produces
large character images for use in font design and refinement.  Proof
mode can be recognized by the suffix
.I .2602gf
after the jobname.  Examples of proof mode output can be found
in
.I "Computer Modern Typefaces"
(Volume E of
.IR "Computers and Typesetting" ).
The system of
.I magsteps
is identical to the system used by
\*(TX,
with values generally in the range 0.5, 1.0, 2.0, 3.0, 4.0 and 5.0.
A listing of
.I gf
numbers for 118-dpi, 240-dpi and 300-dpi fonts
is shown below.
.TS
tab(:);
c c c c
l l l l.
MAGSTEP:118 dpi:240 dpi:300 dpi
mag=magstep(0):118:240:300
mag=magstep(0.5):129:263:329
mag=magstep(1):142:288:360
mag=magstep(2):170:346:432
mag=magstep(3):204:415:518
mag=magstep(4):245:498:622
mag=magstep(5):294:597:746
.TE
.PP
Magnification can also be specified not as a magstep but as an
arbitrary value, such as 1.315, to create special character sizes.
.PP
Before font production can begin, it is necessary to set up the
appropriate base files.  The minimum set of components for font
production for a given print-engine is the
.I plain.mf
macro file
and the local
.I mode_def
file.  The macros in
.I plain.mf
can be
studied in an appendix to the
.IR "\*(MF\^book" ;
they were developed by Donald E. Knuth, and this file should never be
altered except when it is officially upgraded.
Each
.I mode_def
specification helps adapt fonts to a particular print-engine.
There is a regular discussion of
.IR mode_def s
in
.IR TUGboat ,
the journal of the
\*(TX
Users Group.
The local ones in use on this computer should be in
.IR modes.mf .
.PP
The
.I e
response to \*(MF\|'s error-recovery mode invokes the
system default
editor at the erroneous line of the source file.
There is an environment variable, MFEDIT,
that overrides the default editor.
It should contain a string with "%s" indicating where the
filename goes and "%d" indicating where the decimal linenumber (if any) goes.
For example, an MFEDIT string for the
.B vi
editor can be set with the
.B csh
command
.RS
\fIsetenv MFEDIT "vi +%d %s"\fP
.RE
.PP
A convenient file in the library is
.IR null.mf ,
containing nothing.
When
.B mf
can't find the file it thinks you want to input, it keeps
asking you for another file name; responding `null' gets you out
of the loop if you don't want to input anything.
.\"=====================================================================
.SH "ONLINE GRAPHICS OUTPUT"
\*(MF can use most modern displays, so you can see its output
without printing.  Chapter 23 of
.I "The \*(MF\^book"
describes what you can do.  This implementation of \*(MF uses
environment variables to determine which display device you want to use.
First it looks for a variable MFTERM, and then for TERM.
If it can't find either, you get no online output.  Otherwise, the value
of the variable determines the device to use:
.BR hp2627 ,
.B sun
(for old SunView),
.BR tek ,
.B uniterm
(for an Atari ST Tek 4014 emulator),
.B xterm
(for either X10 or X11).
Some of these devices may not be supported in all \*(MF
executables; the choice is made at compilation time.
.PP
On some systems, there are two \*(MF binaries,
.B mf
and
.BR mf-nowin .
On those systems the
.B mf
binary supports graphics, while the
.B mf-nowin
binary does not.  The
.B mf-nowin
binary is used by scripts like
.B mktexpk
where graphics support is a nuisance rather than something helpful.
.\"=====================================================================
.SH OPTIONS
This version of \*(MF understands the following command line options.
.TP
.BI -base \ base
Use
.I base
as the name of the base to be used, instead of the name by which
\*(MF was called or a
.I %&
line.
.TP
.B -file-line-error
Print error messages in the form
.I file:line:error
which is similar to the way many compilers format them.
.TP
.B -no-file-line-error
Disable printing error messages in the
.I file:line:error
style.
.TP
.B -file-line-error-style
This is the old name of the
.B -file-line-error
option.
.TP
.B -halt-on-error
Exit with an error code when an error is encountered during processing.
.TP
.B -help
Print help message and exit.
.TP
.B -ini
Be
.BR inimf ,
for dumping bases; this is implicitly true if the program is called
as
.BR inimf .
.TP
.BI -interaction \ mode
Sets the interaction mode.  The mode can be one of
.IR batchmode ,
.IR nonstopmode ,
.IR scrollmode ,
and
.IR errorstopmode .
The meaning of these modes is the same as that of the corresponding
commands.
.TP
.BI -jobname \ name
Use
.I name
for the job name, instead of deriving it from the name of the input file.
.TP
.BI -kpathsea-debug \ bitmask
Sets path searching debugging flags according to the bitmask.  See the
.I Kpathsea
manual for details.
.TP
.BI -maketex \ fmt
Enable
.RI mktex fmt ,
where
.I fmt
must be
.IR mf .
.TP
.BI -no-maketex \ fmt
Disable
.RI mktex fmt ,
where
.I fmt
must be
.IR mf .
.TP
.BI -output-directory \ directory
Write output files in
.I directory
instead of the current directory.  Look up input files in
.I directory
first, the along the normal search path.
.TP
.B -parse-first-line
If the first line of the main input file begins with
.I %&
parse it to look for a dump name or a
.B -translate-file
option.
.TP
.B -no-parse-first-line
Disable parsing of the first line of the main input file.
.TP
.BI -progname \ name
Pretend to be program
.IR name .
This affects both the format used and the search paths.
.TP
.B -recorder
Enable the filename recorder.  This leaves a trace of the files opened
for input and output in a file with extension
.IR .fls .
.TP
.BI -translate-file \ tcxname
Use the
.I tcxname
translation table.
.TP
.B -version
Print version information and exit.
.\"=====================================================================
.SH ENVIRONMENT
See the Kpathsearch library documentation (the `Path specifications'
node) for the details of how the environment variables are use when
searching.  The
.B kpsewhich
utility can be used to query the values of the variables.
.PP
If the environment variable
.B TEXMFOUTPUT
is set, \*(MF attempts to put its output
files in it, if they cannot be put in the current directory.  Again, see
.BR tex (1).
.TP
.B MFINPUTS
Search path for
.I input
files.
.TP
.B MFEDIT
Command template for switching to editor.
.TP
.B MFTERM
Determines the online graphics display.  If MFTERM is not set,
and DISPLAY is set, the Metafont window support for X is used.
(DISPLAY must be set to a valid X server specification, as usual.)
If neither MFTERM nor DISPLAY is set, TERM is used to guess the window
support to use.
.\"=====================================================================
.SH "FONT UTILITIES"
A number of utility programs are available.
The following is a partial list of available utilities and their purpose.
Consult your local \*(MF guru for details.
.br
.TP \w'gftodvi'u+2n
.B gftopk
Takes a
.I gf
file and produces a more tightly packed
.I pk
font file.
.TP
.B gftodvi
Produces proof sheets for fonts.
.TP
.B gftype
Displays the contents of a
.I gf
file in mnemonics and/or images.
.TP
.B pktype
Mnemonically displays the contents of a
.I pk
file.
.TP
.B mft
Formats a source file as shown in
.IR "Computer Modern Typefaces" .
.\"=====================================================================
.SH "FILES"
.TP
.I "mf.pool"
Encoded text of \*(MF's messages.
.TP
.I *.base
Predigested \*(MF base files.
.TP
.I $TEXMFMAIN/metafont/base/plain.mf
The standard base.
.TP
.I $TEXMFMAIN/metafont/misc/modes.mf
The file of
.IR mode_def s
for your site's various printers
.\"=====================================================================
.SH NOTES
This manual page is not meant to be exhaustive.  The complete
documentation for this version of \*(MF can be found in the info manual
.IR "Web2C: A TeX implementation" .
.\"=====================================================================
.SH BUGS
On January 4, 1986 the ``final'' bug in \*(MF was discovered
and removed.  If an error still lurks in the code, Donald E. Knuth promises to
pay a finder's fee which doubles every year to the first person who finds
it.  Happy hunting.
.\"=====================================================================
.SH "SUGGESTED READING"
Donald E. Knuth,
.I "The \*(MF\^book"
(Volume C of
.IR "Computers and Typesetting" ),
Addison-Wesley, 1986, ISBN 0-201-13445-4.
.br
Donald E. Knuth,
.I "\*(MF:\^ The Program"
(Volume D of
.IR "Computers and Typesetting" ),
Addison-Wesley, 1986, ISBN 0-201-13438-1.
.br
Donald E. Knuth,
.I Computer Modern Typefaces
(Volume E of
.IR "Computers and Typesetting" ),
Addison-Wesley, 1986, ISBN 0-201-13446-2.
.br
.I TUGboat
(the journal of the \*(TX Users Group).
.\"=====================================================================
.SH COMMENTS
Warning: ``Type design can be hazardous to your other interests.
Once you get hooked, you will develop intense feelings about letterforms;
the medium will intrude on the messages that you read.
And you will perpetually be thinking of improvements to the fonts that
you see everywhere, especially those of your own design.''
.\"=====================================================================
.SH "SEE ALSO"
.BR gftopk (1),
.BR gftodvi (1),
.BR gftype (1),
.BR mft (1),
.BR mpost (1),
.BR pltotf (1),
.BR tftopl (1).
.\"=====================================================================
.SH AUTHORS
\*(MF was designed by Donald E. Knuth, who implemented it
using his \*(WB system for Pascal programs.  It was originally
ported to Unix by Paul Richards at the University of Illinois at
Urbana-Champaign.  This page was mostly written by Pierre MacKay.
