/*
 * Copyright 2003-2015 (C) Raster Software Vigo (Sergio Costas)
 * This file is part of FBZX
 *
 * FBZX is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * FBZX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __LLSCREEN_H_
#define __LLSCREEN_H_

using namespace std;

#include <inttypes.h>
#include <string>
#include <SDL2/SDL.h>
#include <SDL2/SDL_thread.h>
#include <iostream>
#include <fstream>

extern struct Charset charset;

#define MIN_WIDTH    4

class LLScreen {
	uint32_t width;
	uint32_t height;
	uint8_t ulaplus_palete[64]; // contains the current palete
	uint32_t colors[80];
	bool setres;

	uint8_t printchar(uint8_t character, int16_t x, int16_t y, uint8_t color, uint8_t back);

public:
	uint32_t *memory;
	bool joystick;
	bool rotate;
	SDL_Window *sdlwindow;
	SDL_Renderer *sdlrenderer;
	SDL_Texture *llscreen;
	uint32_t cheight;
	uint32_t lines_in_screen;
	bool fullscreen;

	LLScreen(int16_t resx, int16_t resy, uint8_t depth, bool fullscreen, bool dblbuffer, bool hwsurface, bool setres);
	~LLScreen();
	ifstream *myfopen(string, ios_base::openmode);
	void print_string(string message, int16_t x, float y, uint8_t ink, uint8_t paper);
	void set_paletes(bool);
	void paint_one_pixel(uint8_t value, uint32_t *address);
	void fullscreen_switch();
	void set_mouse();
	void set_palete_entry(uint8_t entry, uint8_t Value, bool bw);
	uint8_t get_palete_entry(uint8_t entry);
	void clear_screen();
	void paint_picture(string filename);
	void do_flip();
	void do_screenshot(void);
};

extern LLScreen *llscreen;

#endif
