/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.table.JTableHeader;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.Pair;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableHeaderLocation {
    @RunsInCurrentThread
    public Pair<Integer, Point> pointAt(JTableHeader tableHeader, TextMatcher matcher) {
        int index = this.indexOf(tableHeader, matcher);
        if (this.isValidIndex(tableHeader, index)) {
            return new Pair<Integer, Point>(index, JTableHeaderLocation.point(tableHeader, index));
        }
        throw new LocationUnavailableException(Strings.concat((Object[])new Object[]{"Unable to find column with name matching ", matcher.description(), " ", matcher.formattedValues()}));
    }

    @RunsInCurrentThread
    private boolean isValidIndex(JTableHeader tableHeader, int index) {
        int itemCount = this.columnCount(tableHeader);
        return index >= 0 && index < itemCount;
    }

    @RunsInCurrentThread
    public Point pointAt(JTableHeader tableHeader, int index) {
        return JTableHeaderLocation.point(tableHeader, this.validatedIndex(tableHeader, index));
    }

    @RunsInCurrentThread
    private static Point point(JTableHeader tableHeader, int index) {
        Rectangle r = tableHeader.getHeaderRect(index);
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    @RunsInCurrentThread
    private int validatedIndex(JTableHeader tableHeader, int index) {
        int itemCount = this.columnCount(tableHeader);
        if (index >= 0 && index < itemCount) {
            return index;
        }
        throw new IndexOutOfBoundsException(Strings.concat((Object[])new Object[]{"Item index (", String.valueOf(index), ") should be between [", String.valueOf(0), "] and [", String.valueOf(itemCount - 1), "] (inclusive)"}));
    }

    @RunsInCurrentThread
    public int indexOf(JTableHeader tableHeader, TextMatcher matcher) {
        int size = this.columnCount(tableHeader);
        for (int i = 0; i < size; ++i) {
            if (!matcher.isMatching(this.columnName(tableHeader, i))) continue;
            return i;
        }
        return -1;
    }

    @RunsInCurrentThread
    private int columnCount(JTableHeader header) {
        return header.getColumnModel().getColumnCount();
    }

    @RunsInCurrentThread
    private String columnName(JTableHeader tableHeader, int index) {
        return tableHeader.getTable().getModel().getColumnName(index);
    }
}

