/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.hierarchy.ExistingHierarchy;
import org.fest.swing.hierarchy.TransientWindowListener;
import org.fest.swing.hierarchy.WindowFilter;
import org.fest.swing.listener.WeakEventListener;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewHierarchy
extends ExistingHierarchy {
    private final WindowFilter filter;
    private final TransientWindowListener transientWindowListener;

    public static NewHierarchy ignoreExistingComponents() {
        return new NewHierarchy(true);
    }

    public static NewHierarchy includeExistingComponents() {
        return new NewHierarchy(false);
    }

    private NewHierarchy(boolean ignoreExisting) {
        this(Toolkit.getDefaultToolkit(), ignoreExisting);
    }

    private NewHierarchy(Toolkit toolkit, boolean ignoreExisting) {
        this.filter = new WindowFilter(this.parentFinder(), this.childrenFinder());
        this.transientWindowListener = new TransientWindowListener(this.filter);
        this.setUp(toolkit, ignoreExisting);
    }

    @VisibleForTesting
    NewHierarchy(Toolkit toolkit, WindowFilter filter, boolean ignoreExisting) {
        this.filter = filter;
        this.transientWindowListener = new TransientWindowListener(filter);
        this.setUp(toolkit, ignoreExisting);
    }

    @RunsInCurrentThread
    private void setUp(Toolkit toolkit, boolean ignoreExisting) {
        if (ignoreExisting) {
            this.ignoreExisting();
        }
        WeakEventListener.attachAsWeakEventListener(toolkit, this.transientWindowListener, 65L);
    }

    @RunsInCurrentThread
    public void ignoreExisting() {
        for (Container container : this.roots()) {
            this.filter.ignore(container);
        }
    }

    @RunsInCurrentThread
    public void recognize(Component c) {
        this.filter.recognize(c);
    }

    @Override
    @RunsInCurrentThread
    public Collection<Component> childrenOf(Component c) {
        if (this.filter.isIgnored(c)) {
            return Collections.emptyList();
        }
        Collection<Component> children = super.childrenOf(c);
        children.removeAll(this.filter.filtered());
        return children;
    }

    @Override
    @RunsInCurrentThread
    public boolean contains(Component c) {
        return super.contains(c) && !this.filter.isIgnored(c);
    }

    @Override
    @RunsInCurrentThread
    public void dispose(Window w) {
        if (!this.contains(w)) {
            return;
        }
        super.dispose(w);
        this.filter.ignore(w);
    }

    @Override
    public Collection<? extends Container> roots() {
        Collection<? extends Container> roots = super.roots();
        roots.removeAll(this.filter.filtered());
        return roots;
    }
}

