#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 30 July 2009 17:41:24 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header$
#
# $Id$
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from Pmv.VisionInterface.PmvNodes import pmvlib
from MolKit.VisionInterface.MolKitNodes import molkitlib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(pmvlib,"Pmv.VisionInterface.PmvNodes", "pmvlib")

masterNet.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Select MolFrag ##
    from MolKit.VisionInterface.MolKitNodes import NodeSelector
    Select_MolFrag_0 = NodeSelector(constrkw={}, name='Select MolFrag', library=molkitlib)
    masterNet.addNode(Select_MolFrag_0,118,214)
    Select_MolFrag_0.inputPortByName['nodeType'].widget.set(r"Atom", run=False)
    Select_MolFrag_0.inputPortByName['selectionString'].widget.set(r"", run=False)
    apply(Select_MolFrag_0.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore NodeSelector named Select MolFrag in network masterNet"
    print_exc()
    Select_MolFrag_0=None

try:
    ## saving node setattr ##
    from Vision.StandardNodes import SetAttr
    setattr_1 = SetAttr(constrkw={}, name='setattr', library=stdlib)
    masterNet.addNode(setattr_1,5,293)
    apply(setattr_1.configure, (), {'specialPortsVisible': True})
    setattr_1.inputPortByName['name'].rebindWidget()
    setattr_1.inputPortByName['name'].widget.set(r"myattribut", run=False)
    setattr_1.inputPortByName['name'].unbindWidget()
    apply(setattr_1.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore SetAttr named setattr in network masterNet"
    print_exc()
    setattr_1=None

try:
    ## saving node Choose Cmd ##
    from Pmv.VisionInterface.PmvNodes import PmvChooseCommand
    Choose_Cmd_2 = PmvChooseCommand(constrkw={}, name='Choose Cmd', library=pmvlib)
    masterNet.addNode(Choose_Cmd_2,411,132)
    Choose_Cmd_2.inputPortByName['cmdName'].widget.set(r"colorByProperty", run=False)
    apply(Choose_Cmd_2.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore PmvChooseCommand named Choose Cmd in network masterNet"
    print_exc()
    Choose_Cmd_2=None

try:
    ## saving node myattribut ##
    from Vision.StandardNodes import Eval
    myattribut_3 = Eval(constrkw={}, name='myattribut', library=stdlib)
    masterNet.addNode(myattribut_3,55,214)
    myattribut_3.inputPortByName['command'].widget.set(r"'myattribut'", run=False)
    myattribut_3.inputPortByName['importString'].widget.set(r"", run=False)
    apply(myattribut_3.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Eval named myattribut in network masterNet"
    print_exc()
    myattribut_3=None

try:
    ## saving node [MSMS-MOL,st... ##
    from Vision.StandardNodes import Eval
    _MSMS_MOL_st____4 = Eval(constrkw={}, name='[MSMS-MOL,st...', library=stdlib)
    masterNet.addNode(_MSMS_MOL_st____4,276,237)
    _MSMS_MOL_st____4.inputPortByName['command'].widget.set(r"['MSMS-MOL','sticks','balls']", run=False)
    _MSMS_MOL_st____4.inputPortByName['importString'].widget.set(r"", run=False)
    apply(_MSMS_MOL_st____4.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Eval named [MSMS-MOL,st... in network masterNet"
    print_exc()
    _MSMS_MOL_st____4=None

try:
    ## saving node Atom ##
    from Vision.StandardNodes import Eval
    Atom_5 = Eval(constrkw={}, name='Atom', library=stdlib)
    masterNet.addNode(Atom_5,388,256)
    Atom_5.inputPortByName['command'].widget.set(r"'Atom'", run=False)
    Atom_5.inputPortByName['importString'].widget.set(r"", run=False)
    apply(Atom_5.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Eval named Atom in network masterNet"
    print_exc()
    Atom_5=None

try:
    ## saving node Choose Cmd ##
    from Pmv.VisionInterface.PmvNodes import PmvChooseCommand
    Choose_Cmd_6 = PmvChooseCommand(constrkw={}, name='Choose Cmd', library=pmvlib)
    masterNet.addNode(Choose_Cmd_6,327,123)
    Choose_Cmd_6.inputPortByName['cmdName'].widget.set(r"displaySticksAndBalls", run=False)
    apply(Choose_Cmd_6.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore PmvChooseCommand named Choose Cmd in network masterNet"
    print_exc()
    Choose_Cmd_6=None

try:
    ## saving node Pmv Viewer ##
    from Pmv.VisionInterface.PmvNodes import PmvViewer
    Pmv_Viewer_7 = PmvViewer(viewer=masterNet.editor.vf.GUI.VIEWER, constrkw={'viewer': 'masterNet.editor.vf.GUI.VIEWER'}, name='Pmv Viewer', library=pmvlib)
    masterNet.addNode(Pmv_Viewer_7,444,44)
    apply(Pmv_Viewer_7.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
    ##
        ## Saving State for Viewer
    Pmv_Viewer_7.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 453, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 86, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 29.159999999999997, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 688, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -28.642843], 'd2cutH': 255, 'far': 39.885329710042001, 'd1off': 4, 'lookFrom': [0.0, 0.0, 28.642843], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 18.923664600225031, 'drawThumbnail': False, 'rooty': 213, 'd1scale': 0.012999999999999999}
    apply(Pmv_Viewer_7.vi.cameras[0].Set, (), state)

    state = {'end': 36.259390645492722, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 21.026294000250033, 'mode': 'GL_LINEAR'}
    apply(Pmv_Viewer_7.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [3.0304208391351057, 5.4414852896898038, -6.7953270774764665], 'rotation': [-0.40730232, -0.4399063, 0.800367, 0.0, 0.14765662, -0.8965416, -0.41762519, 0.0, 0.9012782, -0.051920209, 0.43011853, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-3.0304215, -5.4414854, 6.7953272], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 2, 'inheritXform': 0}
    apply(Pmv_Viewer_7.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Pmv_Viewer_7.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Pmv_Viewer_7.vi.rootObject:
        Pmv_Viewer_7.vi.rootObject.clipP = []
        Pmv_Viewer_7.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore PmvViewer named Pmv Viewer in network masterNet"
    print_exc()
    Pmv_Viewer_7=None

try:
    ## saving node Get parser.filename ##
    from Vision.StandardNodes import GetAttr
    Get_parser_filename_8 = GetAttr(constrkw={}, name='Get parser.filename', library=stdlib)
    masterNet.addNode(Get_parser_filename_8,5,21)
    apply(Get_parser_filename_8.inputPortByName['attr'].widget.configure, (), {'choices': ['AAradii', 'APBSParams', 'AtomRadiiPatterns', 'NodesFromName', '_ExtrudeSecondaryStructureCommand__hasSSGeom', '_MarkTree', '__cmp__', '__doc__', '__eq__', '__hash__', '__init__', '__module__', '__ne__', '__repr__', '__str__', '_atomRadius', '_copyNode', '_copy_atom_attr', '_fit_atom_into_tree', '_numberOfDeletedNodes', '_uniqIndex', 'addBond', 'adopt', 'allAtoms', 'assignUniqIndex', 'atmNum', 'attach_nonbonded_fragments', 'bonds', 'bondsflag', 'buildBondsBhtree', 'buildBondsByDistance', 'buildBondsByDistanceOnAtoms', 'buildBrokenBonds', 'chains', 'childByName', 'children', 'childrenName', 'childrenSetClass', 'closerThan', 'compare', 'compiled_patterns', 'configureProgressBar', 'copy', 'defaultRadii', 'deleteSubTree', 'dump', 'elementType', 'findLevels', 'findType', 'full_name', 'geomContainer', 'geomName', 'get', 'getAtoms', 'getCenter', 'getNbrAtoms', 'getNext', 'getParentOfType', 'getPrevious', 'getRoot', 'getTypeList', 'hasBonds', 'hasSS', 'isAbove', 'isBelow', 'levels', 'makeNameUniq', 'merge', 'mergeNPH', 'name', 'number', 'p', 'parent', 'parser', 'read', 'remove', 'removeAllHydrogens', 'removeBond', 'secondaryStructure', 'secondaryStructureFromFile', 'secondaryStructureFromStride', 'setClass', 'split', 'subTree', 'top', 'unitedRadii', 'updateProgressBar', 'write']})
    Get_parser_filename_8.inputPortByName['attr'].widget.set(r"parser.filename", run=False)
    apply(Get_parser_filename_8.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore GetAttr named Get parser.filename in network masterNet"
    print_exc()
    Get_parser_filename_8=None

try:
    ## saving node ReadTable ##
    from Vision.StandardNodes import ReadTable
    ReadTable_9 = ReadTable(constrkw={}, name='ReadTable', library=stdlib)
    masterNet.addNode(ReadTable_9,5,127)
    ReadTable_9.inputPortByName['filename'].rebindWidget()
    ReadTable_9.inputPortByName['filename'].widget.set(r"", run=False)
    ReadTable_9.inputPortByName['filename'].unbindWidget()
    apply(ReadTable_9.inputPortByName['numOfTopLinesToJump'].widget.configure, (), {'oneTurn': 10.0})
    ReadTable_9.inputPortByName['numOfTopLinesToJump'].widget.set(0, run=False)
    apply(ReadTable_9.inputPortByName['numOfBottomLinesToJump'].widget.configure, (), {'oneTurn': 10.0})
    ReadTable_9.inputPortByName['numOfBottomLinesToJump'].widget.set(0, run=False)
    ReadTable_9.inputPortByName['sep'].widget.set(r"", run=False)
    ReadTable_9.inputPortByName['datatype'].widget.set(r"str", run=False)
    apply(ReadTable_9.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore ReadTable named ReadTable in network masterNet"
    print_exc()
    ReadTable_9=None

try:
    ## saving node Generic ##
    from Vision.StandardNodes import Generic
    Generic_10 = Generic(constrkw={}, name='Generic', library=stdlib)
    masterNet.addNode(Generic_10,5,180)
    apply(Generic_10.addInputPort, (), {'singleConnection': True, 'name': 'in0', 'cast': 1, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Generic_10.addOutputPort, (), {'name': 'out0', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    code = """def doit(self, in0):
    from string import  atof
    data = []
    for line in in0:
        data.append(atof(line[9]) + atof(line[10]))
    self.outputData(out0=data)



"""
    Generic_10.configure(function=code)
    apply(Generic_10.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Generic named Generic in network masterNet"
    print_exc()
    Generic_10=None

try:
    ## saving node ind_docked ##
    import os
    from mglutil.util.relpath import rel2abs
    lRelFileName = 'ind_docked.pdbq'
    lNetworkDir = os.path.dirname(os.path.abspath(masterNet.filename))
    lAbsFileName = rel2abs(lRelFileName, lNetworkDir)
    mol = masterNet.editor.vf.loadMoleculeIfNeeded(lAbsFileName)
    assert mol
    from Pmv.VisionInterface.PmvNodes import PmvMolecule
    ind_docked_11 = PmvMolecule(molecule=masterNet.editor.vf.expandNodes("ind_docked")[0], constrkw={'molecule': 'masterNet.editor.vf.expandNodes("ind_docked")[0]'}, name='ind_docked', library=pmvlib)
    masterNet.addNode(ind_docked_11,159,12)
except:
    print "WARNING: failed to restore PmvMolecule named ind_docked in network masterNet"
    print_exc()
    ind_docked_11=None

try:
    ## saving node os.path.split(i... ##
    from Vision.StandardNodes import Eval
    os_path_split_i____12 = Eval(constrkw={}, name='os.path.split(i...', library=stdlib)
    masterNet.addNode(os_path_split_i____12,5,74)
    apply(os_path_split_i____12.inputPortByName['in1'].configure, (), {'datatype': 'list', 'required': True, 'originalDatatype': 'None'})
    os_path_split_i____12.inputPortByName['command'].widget.set(r"os.path.split(in1[0])[-1]", run=False)
    os_path_split_i____12.inputPortByName['importString'].widget.set(r"", run=False)
    apply(os_path_split_i____12.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore Eval named os.path.split(i... in network masterNet"
    print_exc()
    os_path_split_i____12=None

try:
    ## saving node Pmv ##
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_13 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    masterNet.addNode(Pmv_13,379,3)
    Pmv_13.inputPortByName['cmdName'].widget.set(r"computeMSMS", run=False)
    Pmv_13.inputPortByName['molecules'].widget.set(r"", run=False)
    apply(Pmv_13.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore PmvNode named Pmv in network masterNet"
    print_exc()
    Pmv_13=None

try:
    ## saving node computeMSMS ##
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    computeMSMS_14 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.computeMSMS, namedArgs={'hdensity': 6.0, 'hdset': 'None', 'surfName': 'MSMS-MOL', 'density': 3.0, 'perMol': True, 'display': True, 'pRadius': 1.5}, posArgsNames=['nodes'], constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.computeMSMS', 'namedArgs': {'hdensity': 6.0, 'hdset': 'None', 'surfName': 'MSMS-MOL', 'density': 3.0, 'perMol': True, 'display': True, 'pRadius': 1.5}, 'posArgsNames': ['nodes']}, name='computeMSMS', library=pmvlib)
    masterNet.addNode(computeMSMS_14,235,66)
    apply(computeMSMS_14.inputPortByName['nodes'].configure, (), {'datatype': 'Molecule', 'originalDatatype': 'None'})
    computeMSMS_14.inputPortByName['importString'].widget.set(r"", run=False)
    computeMSMS_14.inputPortByName['hdensity'].widget.set(6.0, run=False)
    computeMSMS_14.inputPortByName['hdset'].widget.set(r"None", run=False)
    computeMSMS_14.inputPortByName['surfName'].widget.set(r"MSMS-MOL", run=False)
    computeMSMS_14.inputPortByName['density'].widget.set(3.0, run=False)
    computeMSMS_14.inputPortByName['perMol'].widget.set(1, run=False)
    computeMSMS_14.inputPortByName['display'].widget.set(1, run=False)
    computeMSMS_14.inputPortByName['pRadius'].widget.set(1.5, run=False)
    apply(computeMSMS_14.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore PmvRunCommand named computeMSMS in network masterNet"
    print_exc()
    computeMSMS_14=None

try:
    ## saving node displaySticksAndBalls ##
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    displaySticksAndBalls_15 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.displaySticksAndBalls, namedArgs={'cquality': 0, 'sticksBallsLicorice': 'Licorice', 'bquality': 0, 'cradius': 0.20000000000000001, 'only': False, 'bRad': 0.29999999999999999, 'negate': False, 'bScale': 0.0}, posArgsNames=['nodes'], constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.displaySticksAndBalls', 'namedArgs': {'cquality': 0, 'sticksBallsLicorice': 'Licorice', 'bquality': 0, 'cradius': 0.20000000000000001, 'only': False, 'bRad': 0.29999999999999999, 'negate': False, 'bScale': 0.0}, 'posArgsNames': ['nodes']}, name='displaySticksAndBalls', library=pmvlib)
    masterNet.addNode(displaySticksAndBalls_15,225,186)
    apply(displaySticksAndBalls_15.inputPortByName['nodes'].configure, (), {'datatype': 'Molecule', 'originalDatatype': 'None'})
    displaySticksAndBalls_15.inputPortByName['importString'].widget.set(r"", run=False)
    displaySticksAndBalls_15.inputPortByName['cquality'].widget.set(0, run=False)
    displaySticksAndBalls_15.inputPortByName['sticksBallsLicorice'].widget.set(r"Licorice", run=False)
    displaySticksAndBalls_15.inputPortByName['bquality'].widget.set(0, run=False)
    displaySticksAndBalls_15.inputPortByName['cradius'].widget.set(0.2, run=False)
    displaySticksAndBalls_15.inputPortByName['only'].widget.set(0, run=False)
    displaySticksAndBalls_15.inputPortByName['bRad'].widget.set(0.3, run=False)
    displaySticksAndBalls_15.inputPortByName['negate'].widget.set(0, run=False)
    displaySticksAndBalls_15.inputPortByName['bScale'].widget.set(0.0, run=False)
    apply(displaySticksAndBalls_15.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore PmvRunCommand named displaySticksAndBalls in network masterNet"
    print_exc()
    displaySticksAndBalls_15=None

try:
    ## saving node colorByProperty ##
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    colorByProperty_16 = PmvRunCommand(functionOrString='Run_Command', command=masterNet.editor.vf.colorByProperty, namedArgs={'mini': None, 'maxi': None, 'colormap': 'rgb256', 'propertyLevel': None}, posArgsNames=['nodes', 'geomsToColor', 'property'], constrkw={'functionOrString': "'Run_Command'", 'command': 'masterNet.editor.vf.colorByProperty', 'namedArgs': {'mini': None, 'maxi': None, 'colormap': 'rgb256', 'propertyLevel': None}, 'posArgsNames': ['nodes', 'geomsToColor', 'property']}, name='colorByProperty', library=pmvlib)
    masterNet.addNode(colorByProperty_16,242,313)
    apply(colorByProperty_16.inputPortByName['nodes'].configure, (), {'datatype': 'AtomSet', 'originalDatatype': 'None'})
    apply(colorByProperty_16.configure, (), {'specialPortsVisible': True})
    colorByProperty_16.inputPortByName['importString'].widget.set(r"", run=False)
    colorByProperty_16.inputPortByName['colormap'].widget.set(r"rgb256", run=False)
    apply(colorByProperty_16.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore PmvRunCommand named colorByProperty in network masterNet"
    print_exc()
    colorByProperty_16=None

#masterNet.run()
masterNet.freeze()

## saving connections for network msmsGen ##
if Select_MolFrag_0 is not None and setattr_1 is not None:
    try:
        masterNet.connectNodes(
            Select_MolFrag_0, setattr_1, "nodes", "object", blocking=True
            , splitratio=[0.4569166195246922, 0.28444459100836833])
    except:
        print "WARNING: failed to restore connection between Select_MolFrag_0 and setattr_1 in network masterNet"
if ReadTable_9 is not None and Generic_10 is not None:
    try:
        masterNet.connectNodes(
            ReadTable_9, Generic_10, "data", "in0", blocking=True
            , splitratio=[0.36743319399208207, 0.58513246582377987])
    except:
        print "WARNING: failed to restore connection between ReadTable_9 and Generic_10 in network masterNet"
if Generic_10 is not None and setattr_1 is not None:
    try:
        masterNet.connectNodes(
            Generic_10, setattr_1, "out0", "value", blocking=True
            , splitratio=[0.73825227573051277, 0.67522988832258757])
    except:
        print "WARNING: failed to restore connection between Generic_10 and setattr_1 in network masterNet"
if ind_docked_11 is not None and Select_MolFrag_0 is not None:
    try:
        masterNet.connectNodes(
            ind_docked_11, Select_MolFrag_0, "Molecule", "nodes", blocking=True
            , splitratio=[0.24765179389950198, 0.4250691441550386])
    except:
        print "WARNING: failed to restore connection between ind_docked_11 and Select_MolFrag_0 in network masterNet"
if ind_docked_11 is not None and Get_parser_filename_8 is not None:
    try:
        masterNet.connectNodes(
            ind_docked_11, Get_parser_filename_8, "Molecule", "objects", blocking=True
            , splitratio=[0.49082370320165924, 0.52386236653331752])
    except:
        print "WARNING: failed to restore connection between ind_docked_11 and Get_parser_filename_8 in network masterNet"
if myattribut_3 is not None and setattr_1 is not None:
    try:
        masterNet.connectNodes(
            myattribut_3, setattr_1, "result", "name", blocking=True
            , splitratio=[0.52801532114344507, 0.61424410492277159])
    except:
        print "WARNING: failed to restore connection between myattribut_3 and setattr_1 in network masterNet"
if os_path_split_i____12 is not None and ReadTable_9 is not None:
    try:
        masterNet.connectNodes(
            os_path_split_i____12, ReadTable_9, "result", "filename", blocking=True
            , splitratio=[0.31264925838805374, 0.3948785393737691])
    except:
        print "WARNING: failed to restore connection between os_path_split_i____12 and ReadTable_9 in network masterNet"
if Get_parser_filename_8 is not None and os_path_split_i____12 is not None:
    try:
        masterNet.connectNodes(
            Get_parser_filename_8, os_path_split_i____12, "attrs", "in1", blocking=True
            , splitratio=[0.43308259611857608, 0.57752657015776498])
    except:
        print "WARNING: failed to restore connection between Get_parser_filename_8 and os_path_split_i____12 in network masterNet"
if Pmv_13 is not None and computeMSMS_14 is not None:
    try:
        masterNet.connectNodes(
            Pmv_13, computeMSMS_14, "cmd", "command", blocking=True
            , splitratio=[0.44977790394892669, 0.51163580520696206])
    except:
        print "WARNING: failed to restore connection between Pmv_13 and computeMSMS_14 in network masterNet"
if ind_docked_11 is not None and computeMSMS_14 is not None:
    try:
        masterNet.connectNodes(
            ind_docked_11, computeMSMS_14, "Molecule", "nodes", blocking=True
            , splitratio=[0.55523269228583483, 0.53300028126250742])
    except:
        print "WARNING: failed to restore connection between ind_docked_11 and computeMSMS_14 in network masterNet"
if Choose_Cmd_6 is not None and displaySticksAndBalls_15 is not None:
    try:
        masterNet.connectNodes(
            Choose_Cmd_6, displaySticksAndBalls_15, "cmd", "command", blocking=True
            , splitratio=[0.55242895520278035, 0.47761189381965996])
    except:
        print "WARNING: failed to restore connection between Choose_Cmd_6 and displaySticksAndBalls_15 in network masterNet"
if ind_docked_11 is not None and displaySticksAndBalls_15 is not None:
    try:
        masterNet.connectNodes(
            ind_docked_11, displaySticksAndBalls_15, "Molecule", "nodes", blocking=True
            , splitratio=[0.73718894008787683, 0.5199244372957057])
    except:
        print "WARNING: failed to restore connection between ind_docked_11 and displaySticksAndBalls_15 in network masterNet"
if Choose_Cmd_2 is not None and colorByProperty_16 is not None:
    try:
        masterNet.connectNodes(
            Choose_Cmd_2, colorByProperty_16, "cmd", "command", blocking=True
            , splitratio=[0.31159057025934717, 0.44642723297917941])
    except:
        print "WARNING: failed to restore connection between Choose_Cmd_2 and colorByProperty_16 in network masterNet"
if Select_MolFrag_0 is not None and colorByProperty_16 is not None:
    try:
        masterNet.connectNodes(
            Select_MolFrag_0, colorByProperty_16, "nodes", "nodes", blocking=True
            , splitratio=[0.54811754603940543, 0.57840779236644457])
    except:
        print "WARNING: failed to restore connection between Select_MolFrag_0 and colorByProperty_16 in network masterNet"
if _MSMS_MOL_st____4 is not None and colorByProperty_16 is not None:
    try:
        masterNet.connectNodes(
            _MSMS_MOL_st____4, colorByProperty_16, "result", "geomsToColor", blocking=True
            , splitratio=[0.43166211518004516, 0.6800134644669602])
    except:
        print "WARNING: failed to restore connection between _MSMS_MOL_st____4 and colorByProperty_16 in network masterNet"
if myattribut_3 is not None and colorByProperty_16 is not None:
    try:
        masterNet.connectNodes(
            myattribut_3, colorByProperty_16, "result", "property", blocking=True
            , splitratio=[0.64044127762724479, 0.70672505234699035])
    except:
        print "WARNING: failed to restore connection between myattribut_3 and colorByProperty_16 in network masterNet"
if Atom_5 is not None and colorByProperty_16 is not None:
    try:
        masterNet.connectNodes(
            Atom_5, colorByProperty_16, "result", "propertyLevel", blocking=True
            , splitratio=[0.28041513999000595, 0.69088860005355635])
    except:
        print "WARNING: failed to restore connection between Atom_5 and colorByProperty_16 in network masterNet"
if setattr_1 is not None and colorByProperty_16 is not None:
    try:
        masterNet.specialConnectNodes(
            setattr_1, colorByProperty_16, "trigger", "runNode", blocking=True
            , splitratio=[0.60817454364637635, 0.25857840818229999])
    except:
        print "WARNING: failed to restore connection between setattr_1 and colorByProperty_16 in network masterNet"
if Pmv_13 is not None and Choose_Cmd_6 is not None:
    try:
        masterNet.connectNodes(
            Pmv_13, Choose_Cmd_6, "PMV", "viewer", blocking=True
            , splitratio=[0.24112414877161342, 0.50860775952890847])
    except:
        print "WARNING: failed to restore connection between Pmv_13 and Choose_Cmd_6 in network masterNet"
if Pmv_13 is not None and Choose_Cmd_2 is not None:
    try:
        masterNet.connectNodes(
            Pmv_13, Choose_Cmd_2, "PMV", "viewer", blocking=True
            , splitratio=[0.37587524961048213, 0.47875505163190857])
    except:
        print "WARNING: failed to restore connection between Pmv_13 and Choose_Cmd_2 in network masterNet"
masterNet.runOnNewData.value = False


def loadSavedStates_Pmv_Viewer_7(self=Pmv_Viewer_7, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|misc
    ## Object root|AutoLigand_geoms
    ## Object root|CoarseAPBSbox
    ## Object root|FineAPBSbox
    ## Object root|ind_docked
    ## Object root|misc|addBondsGeom
    ## Object root|misc|edit_geoms
    ## Object root|misc|repair_geoms
    ## Object root|misc|measure_geoms
    ## Object root|misc|setTorsionGeom
    ## Object root|misc|selectInSphereGeoms
    ## Object root|AutoLigand_geoms|Cross
    ## Object root|AutoLigand_geoms|Box
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': 0, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'line', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': 0, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 1, 'pickableVertices': True, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': 0, 'shading': 'flat', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'none', 'name': 'Box', 'backPolyMode': 'line', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': True, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|AutoLigand_geoms|Box')
    if obj:
        apply(obj.Set, (), state)

    ## Material for Box
    if obj:
        from opengltk.OpenGL import GL
        state = {'shininess': [13.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'binding': [10.0, 12.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for Box

    ## Clipping Planes for Box
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for Box

    ## Object root|AutoLigand_geoms|Spheres
    ## Object root|AutoLigand_geoms|Halo
    ## Object root|ind_docked|selection
    ## Object root|ind_docked|lines
    ## Object root|ind_docked|AtomLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'AtomLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (0.29999999999999999, 0.29999999999999999, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|ind_docked|AtomLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for AtomLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for AtomLabels

    ## Clipping Planes for AtomLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for AtomLabels

    ## Object root|ind_docked|ResidueLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'ResidueLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (0.59999999999999998, 0.59999999999999998, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|ind_docked|ResidueLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for ResidueLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for ResidueLabels

    ## Clipping Planes for ResidueLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for ResidueLabels

    ## Object root|ind_docked|ChainLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'ChainLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (0.89999999999999991, 0.89999999999999991, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|ind_docked|ChainLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for ChainLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for ChainLabels

    ## Clipping Planes for ChainLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for ChainLabels

    ## Object root|ind_docked|ProteinLabels
    state = {'inheritStippleLines': True, 'stippleLines': False, 'labels': ['Aa'], 'disableStencil': False, 'replace': True, 'scissorAspectRatio': 1.0, 'immediateRendering': True, 'inheritLighting': True, 'pivot': [0.0, 0.0, 0.0], 'billboard': True, 'invertNormals': False, 'font': 'arial1.glf', 'translation': [0.0, 0.0, 0.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'inheritFrontPolyMode': True, 'vertexArrayFlag': False, 'name': 'ProteinLabels', 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'fontSpacing': 0.20000000000000001, 'pickable': 0, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'includeCameraRotationInBillboard': False, 'fontScales': (1.2, 1.2, 0.10000000000000001), 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': True, 'shading': 'smooth', 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'transparent': False, 'sharpColorBoundaries': True, 'fontRotateAngles': (0, 0, 0), 'culling': 'none', 'outline': False, 'backPolyMode': 'line', 'visible': 0, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': False, 'fontTranslation': (0, 0, 3.0), 'fontStyle': 'solid3d', 'inheritLineWidth': False, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|ind_docked|ProteinLabels')
    if obj:
        apply(obj.Set, (), state)

    ## Material for ProteinLabels
    if obj:
        pass  ## needed in case there no modif
    ## End Materials for ProteinLabels

    ## Clipping Planes for ProteinLabels
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for ProteinLabels

    ## Object root|ind_docked|sticks
    ## Object root|ind_docked|balls
    ## Object root|ind_docked|cpk
    ## Object root|ind_docked|CAsticks
    ## Object root|ind_docked|CAballs
    ## Object root|ind_docked|MSMS-MOL
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': 1, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': True, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 1, 'sharpColorBoundaries': False, 'culling': 'none', 'name': 'MSMS-MOL', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': True, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|ind_docked|MSMS-MOL')
    if obj:
        apply(obj.Set, (), state)

    ## Material for MSMS-MOL
    if obj:
        from opengltk.OpenGL import GL
        state = {'shininess': [13.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'binding': [10, 11, 10, 10, 10, 10], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for MSMS-MOL

    ## Clipping Planes for MSMS-MOL
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for MSMS-MOL

    ## Object root|misc|addBondsGeom|addBondsSpheres
    ## Object root|misc|edit_geoms|editAtomTypeSphere
    ## Object root|misc|edit_geoms|editAtomChargeSphere
    ## Object root|misc|repair_geoms|closeContactGeoms
    ## Object root|misc|measure_geoms|measureDistGeomCtrl
    ## Object root|misc|measure_geoms|measureDistGeom
    ## Object root|misc|measure_geoms|measureAngleGeom
    ## Object root|misc|measure_geoms|measureTorsionGeom
    ## Object root|misc|setTorsionGeom|settorsionLine
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': 1, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'front', 'name': 'settorsionLine', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': False, 'scissor': 0, 'protected': True, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|misc|setTorsionGeom|settorsionLine')
    if obj:
        apply(obj.Set, (), state)

    ## Material for settorsionLine
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [13.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[0.0, 1.0, 1.0, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for settorsionLine

    ## Clipping Planes for settorsionLine
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for settorsionLine

    ## Object root|misc|setTorsionGeom|settorsionLabel
    ## Object root|misc|setTorsionGeom|settorsionSpheres
    ## Object root|misc|selectInSphereGeoms|SelSphReg_selSph
    ## Object root|misc|selectInSphereGeoms|SelSphReg_cenCross
    ## Object root|ind_docked|lines|bonded
    ## Object root|ind_docked|lines|nobnds
    ## Object root|ind_docked|lines|bondorder
    ## Object root|misc|repair_geoms|closeContactGeoms|closeContLines
    ## Object root|misc|repair_geoms|closeContactGeoms|closeContLabels
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLine
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distLabel
    ## Object root|misc|measure_geoms|measureDistGeomCtrl|distSpheres
    ## Object root|misc|measure_geoms|measureDistGeom|distLine
    ## Object root|misc|measure_geoms|measureDistGeom|distLabel
    ## Object root|misc|measure_geoms|measureDistGeom|distSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLine
    ## Object root|misc|measure_geoms|measureAngleGeom|angleLabel
    ## Object root|misc|measure_geoms|measureAngleGeom|angleSpheres
    ## Object root|misc|measure_geoms|measureAngleGeom|angles
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLine
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionLabel
    ## Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres
    ## End Object root|misc|measure_geoms|measureTorsionGeom|torsionSpheres

    ##
        ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 453, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 29.159999999999997, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 688, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -28.642843], 'd2cutH': 255, 'far': 39.885329710042001, 'd1off': 4, 'lookFrom': [0.0, 0.0, 28.642843], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 18.923664600225031, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 36.259390645492722, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': 1, 'start': 21.026294000250033, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'disableStencil': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [3.0304208391351057, 5.4414852896898038, -6.7953270774764665], 'rotation': [-0.40730232, -0.4399063, 0.800367, 0.0, 0.14765662, -0.8965416, -0.41762519, 0.0, 0.9012782, -0.051920209, 0.43011853, 0.0, 0.0, 0.0, 0.0, 1.0], 'instanceMatricesFromFortran': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'vertexArrayFlag': False, 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [-3.0304215, -5.4414854, 6.7953272], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 2, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Pmv_Viewer_7.restoreStates_cb = Pmv_Viewer_7.restoreStatesFirstRun = loadSavedStates_Pmv_Viewer_7
Pmv_Viewer_7.menu.add_separator()
Pmv_Viewer_7.menu.add_command(label='Restore states', command=Pmv_Viewer_7.restoreStates_cb)

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 0) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        # create communication socket
        import socket
        HOST = ''                 # Symbolic name meaning the local host
        PORT = 50010              # Arbitrary non-privileged port
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.bind((HOST, PORT))
        s.listen(5)
        s.setblocking(0)
        masterNet.socket = s
        masterNet.socketConnections = []
        masterNet.HOST = HOST
        masterNet.PORT = PORT

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

