
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The method setNamedItemNS adds a node using its namespaceURI and localName. If a node with 
 *  that namespace URI and that local name is already present in this map, it is replaced 
 *  by the new one.
 *  
 *  Retreive the first element whose localName is address and namespaceURI http://www.nist.gov", 
 *  and put its attributes into a named node map.  Create a new attribute node and add it to this map.  
 *  Verify if the attr node was successfully added by checking the nodeName of the retreived atttribute.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-getNamedItemNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-getNamedItemNS</a>
*/
public final class namednodemapsetnameditemns01 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public namednodemapsetnameditemns01(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "staffNS", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NamedNodeMap attributes;
      Node element;
      Attr attribute;
      Attr newAttribute;
      Attr newAttr1;
      NodeList elementList;
      String attrName;
      doc = (Document) load("staffNS", true);
      elementList = doc.getElementsByTagNameNS("http://www.nist.gov", "address");
      element = elementList.item(0);
      attributes = element.getAttributes();
      newAttr1 = doc.createAttributeNS("http://www.w3.org/DOM/L1", "streets");
      newAttribute = ((Element) /*Node */element).setAttributeNodeNS(newAttr1);
      attribute = (Attr) attributes.getNamedItemNS("http://www.w3.org/DOM/L1", "streets");
      attrName = attribute.getNodeName();
      assertEquals("namednodemapsetnameditemns01", "streets", attrName);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/namednodemapsetnameditemns01";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(namednodemapsetnameditemns01.class, args);
   }
}

