// generated by go run gen.go; DO NOT EDIT

package publicsuffix

const version = "publicsuffix.org's public_suffix_list.dat, git revision 24caf4f (2016-01-30)"

const (
	nodesBitsChildren   = 9
	nodesBitsICANN      = 1
	nodesBitsTextOffset = 15
	nodesBitsTextLength = 6

	childrenBitsWildcard = 1
	childrenBitsNodeType = 2
	childrenBitsHi       = 14
	childrenBitsLo       = 14
)

const (
	nodeTypeNormal     = 0
	nodeTypeException  = 1
	nodeTypeParentOnly = 2
)

// numTLD is the number of top level domains.
const numTLD = 1543

// Text is the combined text of all labels.
const text = "bieszczadygeyachimataipeigersundurbanamexeterbievatmallorcadaque" +
	"sanjotateshinanomachintaijinfinitinfoggiabifukagawalmartateyamab" +
	"ihorologyusuharabikedagestangebilbaogakievenesannanikkoebenhavni" +
	"kolaeverbankashiwazakiyokawarabillustrationikonantanangerbiomuta" +
	"shinainuyamanouchikuhokuryugasakitashiobarabirdartcenterprisesak" +
	"ikonaircraftraeumtgeradealstahaugesundurhamburgliwicebirkenesodd" +
	"tangenovaravennaharimalvikasukabedzin-the-bandaioirasebastopolog" +
	"yeongnamegawakembuchikumagayagawakkanaibetsubamericanfamilydsclo" +
	"udappspotenzachpomorskienebakkeshibechambagriculturennebudapest-" +
	"a-la-masioninohelplfinancialinzainvestmentsannohelsinkitahiroshi" +
	"marshallstatebankasumigaurawa-mazowszextraspace-to-rentalstomako" +
	"maibarabirthplacebjarkoyusuisservicesanokasuyakutiabjerkreimmobi" +
	"lieninomiyakonojoshkar-olayangroupaleostrowiecartoonartdecoffeed" +
	"backaszubyuudmurtiabjugnirasakis-a-candidateblockbusternidvrdnsa" +
	"ntabarbarabloombergbauernrtatsunostrowwlkpmglobalashovhachinoheg" +
	"uris-a-catererbluedatingloboehringerikebmoattachmentsantacruzsan" +
	"tafedexhibitionishiazais-a-celticsfanishigotpantheonishiharabmsa" +
	"nukis-a-chefarsundwglogowegroweibolzanore-og-uvdalipetskatowiceb" +
	"mweirbnpparibaselburgloppenzaogashimadachicagobododgemologically" +
	"ngenglandyndns-homednsaotomeldalivornobomloansapodhalewismillerb" +
	"ondyndns-ip6bonnishiizunazukis-a-conservativefsncfailomzansimagi" +
	"casadelamonedavvesiidazaifudaigodoesntexistanbullensakerbookingm" +
	"inakamichigangwonishikatakazakis-a-cpadoval-daostavalleyuzawaboo" +
	"tsapporoboschaefflerdalorenskogmodenakatombetsumidatlanticaseihi" +
	"chisobetsuitairabostikatsushikabeeldengeluidyndns-mailotenkawabo" +
	"stonakijinsekikogentingmxboxenishikatsuragivestbytomaritimekeepi" +
	"ngretakamoriokamchatkameokameyamashinatsukigatakanabeatsaratoval" +
	"leaostavernishikawazukanazawabotanicalgardenishimerabotanicgarde" +
	"nishinomiyashironobotanyuzhno-sakhalinskatsuyamasfjordenishinoom" +
	"otegotsukisosakitagatakamatsukawaboutiquebecngrimstadyndns-offic" +
	"e-on-the-webcambridgestonewspaperbozentsujiiebradescorporationis" +
	"hinoshimatta-varjjatattoolsztynsettlersardegnamsskoganeis-a-cubi" +
	"cle-slavellinowtvalled-aostavropolicebrandywinevalleybrasiljan-m" +
	"ayenishiokoppegardyndns-picsardiniabresciabrindisibenikebristolg" +
	"alsacebritishcolumbialowiezagannakadomari-elasticbeanstalkaufeni" +
	"shitosashimizunaminamiashigarabroadcastlebtimnetzgorabroadwaybro" +
	"ke-itaxihuanishiwakis-a-democratgorybrokerrypropertiesarlottebro" +
	"nnoysundyndns-remotegildeskalmykiabrothermesaverdefensejnybrumun" +
	"ddalottokigawabrunelblagdenesnaaseralingenkainanaejrietisalatina" +
	"benogatachikawakayamagadancebetsukubabia-goracleaningatlantagajo" +
	"bojis-a-designerbrusselsarpsborgripebruxellesarufutsunomiyawakas" +
	"aikaitakoelnissandoybryanskjakdnepropetrovskiervaapsteiermarkaut" +
	"okeinobryneustarhubalestrandabergamoarekembroideryonabaruconnect" +
	"arnobrzegjesdalimanowarudasnesoddenmarkets3-eu-central-1buskerud" +
	"inewhampshirecipesaro-urbino-pesarourbinopesaromaniwakuratelekom" +
	"munikationissayokoshibahikariwanumataketomisatokuyamatteledataba" +
	"seballooningriwataraidyndns-serverbaniabuzenissedalouvrepbodyndn" +
	"s-blogdnsasayamabuzzgorzeleccollegersundyndns-weberlincolnisshin" +
	"guernseybwfashioniyodogawabzhitomirkutskjervoyagecloudfunctionsb" +
	"schokoladencntjxn--0trq7p7nncolognewmexicoldwarmiamiastapleschol" +
	"arshipschooluroycolonialwilliamsburgujolstercoloradoplateaudioco" +
	"lumbusheycommunitysneschulezajskfhskhabarovskhakassiacomobaracom" +
	"paremarkerryhotelschwarzgwangjuifminamibosogndalutskharkivguccip" +
	"rianiigataitogitsuldaluxembourgulencompute-1computerhistoryofsci" +
	"ence-fictioncomsecuritysvardoharuhrcondoshichinohedmarkhangelsky" +
	"pescaravantaaconferenceconstructionconsuladollschweizgradconsult" +
	"anthropologyconsultingvolluxurycontactkmaxxn--11b4c3dcontemporar" +
	"yarteducationalchikugojomedicaltanissettaiwanairguardcontractors" +
	"kenconventureshinodesashibetsuikimobetsuliguriacookingchannelver" +
	"uminamidaitomangotembaixadacoolkuszippodlasiellakasamatsudoosand" +
	"iegokaseljordcoopocznorthwesternmutualuzerncopenhagencyclopedica" +
	"tholicasertaishinomakikuchikuseikarugapartmentsaseboknowsitallov" +
	"egaskimitsubatamicabbottjeldsundyndns-wikindlegnicamerakershus-e" +
	"ast-1corsicagliaridagawarszawashingtondclkharkovalledaostakkofue" +
	"lvivano-frankivskhersoncorvettemasekhmelnitskiyamashikecosenzama" +
	"mibuildersciencecentersciencehistorycostumedio-campidano-medioca" +
	"mpidanomediocouncilcouponscientistor-elvdalcoursescjohnsoncq-acr" +
	"anbrookuwanalyticscrapper-sitecreditcardcreditunioncremonashorok" +
	"anaiecrewiiheyaizuwakamatsubushikusakadogawacricketrzyncrimeacro" +
	"tonewportlligatewaycrowncrscrappingunmarriottmpalmspringsakercru" +
	"isesettsurfastlycuisinellajollamericanexpressexyzjcbnlculturalce" +
	"ntertainmentoyokawacuneocupcakecxn--1ck2e1balsanagochihayaakasak" +
	"awaharaumakeupowiathletajimabariakepnordkappgjovikaruizawastrono" +
	"mydstvedestrandgcahcesuolocalhistoryazannefrankfurtargets-itargi" +
	"234cymruovatoyonakagyokutoshimacyouthdfcbankhmelnytskyivallee-ao" +
	"steroyfilminamifuranofinalfinancefineartsfranziskanerimamateramo" +
	"chizukirafinlandfinnoyfirebaseappamperedchefauskedsmokorsetagaya" +
	"sells-for-lessevastopolefirenzefirestonextdirectoryfirmdalegolfe" +
	"djejuegoshikiminokamoenairlinebraskaunbieidsvollfishingonohejis-" +
	"a-geekhvalleeaosteigenfitjarqhachiojiyahikobeautydalfitnessettle" +
	"mentoyonofjalerflickragerotikalugansklabudhabikinokawabarthachir" +
	"ogatakanezawaflightshangrilangevagrarboretumbriaflirumansionshar" +
	"is-a-greenfloguchikuzenfloraflorencefloridafloristanohatakaharus" +
	"siafloromskogxn--1ctwolominamatamayukis-a-gurulsandvikcoromantov" +
	"alle-daostavangerflowersharpanamaflsmidthruhereggiocalabriaflynn" +
	"hubalsfjordiskstationaval-d-aosta-valleyonagoyaugustowadaegubs3-" +
	"eu-west-1fndfolldalfoodnetworkangerfor-better-thandafor-ourfor-s" +
	"omedizinhistorischeshawaiijimarylandfor-theaterforexrothadanotog" +
	"awaforgotdnshellaspeziaforli-cesena-forlicesenaforlikes-piedmont" +
	"blancomeereshimokawaforsaleikangerforsandasuolodingenfortmissoul" +
	"an-udell-ogliastrakhanawawilliamhillfortworthadselfipirangaforum" +
	"inamiiselectoyookarasjohkaminoyamatsuris-a-hard-workerfosneshimo" +
	"kitayamafotoyosatotalfoxn--1lqs03nfreiburgzlgfreightcmwinbaltimo" +
	"re-og-romsdalimitedunetflixilimoliserniaukraanghke164freseniusde" +
	"corativeartshimonitayanagivingfribourgfriuli-v-giuliafriuli-ve-g" +
	"iuliafriuli-vegiuliafriuli-venezia-giuliafriuli-veneziagiuliafri" +
	"uli-vgiuliafriuliv-giuliafriulive-giuliafriulivegiuliafriulivene" +
	"zia-giuliafriuliveneziagiuliafriulivgiuliafrlfroganshimonosekika" +
	"wafrognfrolandfrom-akrehamnfrom-alfrom-arfrom-azpanasonicdn77-ss" +
	"lattumetlifeinsurancefrom-canonoichikawamisatodayfrom-collection" +
	"from-ctoyotaris-a-hunterfrom-dcheltenham-radio-operaunitelemarka" +
	"zimierz-dolnyfrom-dellogliastraderfrom-flandershimosuwalkis-a-kn" +
	"ightoyotomiyazakis-a-landscaperugiafrom-gaulardalfrom-higashiaga" +
	"tsumagoirmitakeharafrom-iafrom-idfrom-ilfrom-incheonfrom-kshimot" +
	"sukefrom-kyknetoyotsukaidovre-eikerfrom-lanbibaidarfrom-manxn--1" +
	"lqs71dfrom-mdfrom-meetoyourafrom-microsoftbankmpspbambleborkarum" +
	"aifarmsteadivtasvuodnakaiwamizawaurskog-holandroverhalla-speziae" +
	"tnagahamaroygardendoftheinternetcimdbalatinordre-landds3-ap-sout" +
	"heast-1kappleangaviikadenaamesjevuemielnoboribetsucks3-ap-northe" +
	"ast-1from-mnfrom-modalenfrom-mshimotsumafrom-mtnfrom-nchelyabins" +
	"kodjeffersonrwhalingrongausdalucaniafrom-ndfrom-nexusgardenfrom-" +
	"nhktoystre-slidrettozawafrom-njcparaglidingfrom-nminamiizukamito" +
	"ndabayashiogamagoriziafrom-nvanylvenicefrom-nyfrom-ohkurafrom-ok" +
	"etogurafrom-orfrom-paderbornfrom-pratohmaoris-a-lawyerfrom-ris-a" +
	"-liberalfrom-schoenbrunnfrom-sdnipropetrovskmshinichinanfrom-tnf" +
	"rom-txn--1qqw23afrom-utazuerichardlikescandyndns-at-homedepotaru" +
	"is-a-libertarianfrom-vadsochildrensgardenfrom-vtozsdefrom-wafrom" +
	"-wielunnerfrom-wvaolbia-tempio-olbiatempioolbialystokkemerovodka" +
	"goshimaintenancefrom-wyfrosinonefrostalowa-wolawafroyahabadajozo" +
	"rahkkeravjudygarlandfstcgrouparisor-fronfujiiderafujikawaguchiko" +
	"nefujiminohtawaramotoineppugliafujinomiyadafujiokayamarburgfujis" +
	"atoshonairportland-4-salernogiessengerdalaskanittedallasalleasee" +
	"klogesquarezzoologyfujisawafujishiroishidakabiratoridelmenhorsta" +
	"lbanshinjournalismailillehammerfest-mon-blogueurovisionfujitsuru" +
	"gashimarinefujixeroxn--2m4a15efujiyoshidafukayabeardubaiduckdnsd" +
	"ojoburgfukuchiyamadafukudominichernigovernmentjmaxxxfinityfukuis" +
	"-a-linux-useranishiaritabashikaoizumizakitaurayasudafukumitsubis" +
	"higakirkeneshinjukumanofukuokazakirovogradoyfukuroishikarikaturi" +
	"ndalfukusakiryuohaebaruminamimakis-a-llamarylhursteinkjerusalemb" +
	"etsukuis-a-musicianfukuyamagatakahashimamakisarazure-mobileirfjo" +
	"rdfunabashiriuchinadafunagatakahatakaishimoichinosekigaharafunah" +
	"ashikamiamakusatsumasendaisennangoodyearthagakhanamigawafundacio" +
	"fuoiskujukuriyamarcheaparliamentranbyfuosskoczowindmillfurniture" +
	"ggioemiliaromagnakasatsunairtelecityeatshinkamigotoyohashimotomo" +
	"bellunordreisa-geekokonoefurubiraquarelleasingleshinshinotsurgeo" +
	"nshalloffamelhustkamisunagawafurudonostiafurukawairtraffichernih" +
	"ivanovosibirskydivingrossetouchijiwadeltajimicrolightingroundhan" +
	"dlingroznyfusodegaurafussaikishiwadafutabayamaguchinomigawafutbo" +
	"ldlygoingnowhere-for-moregontrailroadfuttsurugiminamiminowafvgfy" +
	"is-a-nascarfanfylkesbiblackfridayfyresdalhannovareserveftparoche" +
	"rkasyzrankoshigayaltaikis-a-painteractivegarsheis-a-patsfanhanyu" +
	"zenhapmirhappoulvikomaganehareidsbergenharstadharvestcelebration" +
	"hasamarahasaminami-alpssells-for-unzenhashbanghasudahasvikomakiy" +
	"osatokamachippubetsubetsugaruhatogayahoooshikamaishimofusartshin" +
	"tokushimahatoyamazakitahatakaokamikitayamatotakadahatsukaichihar" +
	"ahattfjelldalhayashimamotobuildinghazuminobusells-itrani-andria-" +
	"barletta-trani-andriahbofagehembygdsforbundhemneshintomikasahara" +
	"hemsedalherokussldheroyhgtvarggatraniandriabarlettatraniandriahi" +
	"gashichichibungotakadatsunanjoetsuwanouchikujogaszkoladbrokesenn" +
	"umamurogawalterhigashihiroshimanehigashiizumozakitakamiizumisano" +
	"fiatranoyhigashikagawahigashikagurasoedahigashikawakitaaikitakat" +
	"akarazukamikoaniikappulawyhigashikurumeguroroskoleitungsenhigash" +
	"imatsushimarugame-hostinghigashimatsuyamakitaakitadaitoigawahiga" +
	"shimurayamalatvuopmidoris-a-personaltrainerhigashinarusellsyourh" +
	"omegoodshinyoshitomiokaniepcehigashinehigashiomihachimanchesterh" +
	"igashiosakasayamamotorcycleshiojirishirifujiedahigashishirakawam" +
	"atakasagooglecodespotransportrapaniimimatakatoris-a-photographer" +
	"okuapparshioyameloyalistockholmestrandhigashisumiyoshikawaminami" +
	"aikitakyushuaiahigashitsunowruzhgorodoyhigashiurausukitamidsundh" +
	"igashiyamatokoriyamanakakogawahigashiyodogawahigashiyoshinogaris" +
	"-a-playerhiraizumisatohnoshoohirakatashinagawahiranais-a-republi" +
	"cancerresearchaeologicaliforniahirarahiratsukagawahirayaitakasak" +
	"itamotosumitakaginankokubunjis-a-rockstarachowicehisayamanashiib" +
	"aghdadultravelchannelhistorichouseshirahamatonbetsurgeryhitachio" +
	"miyaginowaniihamatamakawajimaritimodellinghitachiotagopartis-a-s" +
	"ocialistmeindianapolis-a-bloggerhitoyoshimifunehitradinghjartdal" +
	"hjelmelandholeckobierzyceholidayhomeipartnershirakoenighomelinux" +
	"n--30rr7yhomesensembokukitanakagusukumoduminamiogunicomcastresis" +
	"tancehomeunixn--32vp30hagebostadhondahonefosshiranukanmakiwakuni" +
	"gamihamadahoneywellhongorgehonjyoitakashimarumorimachidahorninda" +
	"lhorseminehortendofinternetravelersinsurancehoteleshiraois-a-sox" +
	"fanhotmailhoyangerhoylandetroitskomatsushimashikiyosemitehumanit" +
	"ieshiraokannamiharuhurdalhurumajis-a-studentalhyllestadhyogoris-" +
	"a-teacherkassymantechnologyhyugawarahyundaiwafunejgorajlchiryuky" +
	"uragifuefukihaborokunohealthcareersaskatchewanggouvicenzajlljmpa" +
	"rtshizukuishimogosenjnjelenia-gorajoyokaichibahcavuotnagaraholta" +
	"lenjpmorganichitachinakagawatchandclockazojpnchitosetogakushimot" +
	"oganewjerseyjprshizuokanoyakagejuniperjurkristiansandcatshoujis-" +
	"bykristiansundkrodsheradkrokstadelvaldaostarostwodzislawinnersho" +
	"wakryminamitanekumatorinokumejimasudakumenanyokkaichirurgiens-de" +
	"ntisteshowtimemerckomonokunisakis-certifiedekakegawakunitachiara" +
	"ilwaykunitomigusukumamotoyamassa-carrara-massacarraramassabunkyo" +
	"nanaoshimageandsoundandvisionkunneppupartykunstsammlungkunstundd" +
	"esignkuokgroupasadenamsosnowiechloekurepairbusantiquest-a-la-mai" +
	"sondre-landebusinessebykleclerchocolatelevisionkurgankurobelaudi" +
	"blebesbyglandkurogimilitarykuroisoftwarendalenugkuromatsunais-fo" +
	"undationkurotakikawasakis-gonekurskomorotsukamishihoronobeokamin" +
	"okawanishiaizubangekushirogawakustanais-into-animeiwamaseratis-a" +
	"n-actorkusupersportrentino-stirolkutchanelkutnokuzbassnillfjordk" +
	"uzumakis-into-carshisognekvafjordkvalsundkvamlidlugolekagaminord" +
	"-aurdalvdalipayufuchukotkafjordkvanangenkvinesdalkvinnheradkvite" +
	"seidskogkvitsoykwpspjelkavikomvuxn--3bst00minamisanrikubetsupply" +
	"kyotobetsupplieshriramsterdambulanceokyowariasahikawamishimatsum" +
	"otofukemissilelmisugitokonamegatakayamatsunomitourismolanciamito" +
	"yoakemiuramiyazurewebsiteshikagamiishibukawamiyotamanomjondalenm" +
	"lbarclaycards3-us-west-2monmouthaibarakitagawamonstermonticellol" +
	"montrealestatefarmequipmentrentino-sud-tirolmonza-brianzaporizhz" +
	"hekinannestadmonza-e-della-brianzaporizhzhiamonzabrianzapposlomb" +
	"ardiamondsigdalmonzaebrianzaramonzaedellabrianzamoparachutingmor" +
	"doviajessheiminamiuonumatsumaebashimodatemoriyamatsusakahoginoza" +
	"waonsenmoriyoshiokamitsuemormoneymoroyamatsushigemortgagemoscowi" +
	"ostrolekaneyamaxunjargamoseushistorymosjoenmoskenesimbirskongsvi" +
	"ngermossimple-urlmosvikoninjamisonmoviemovistargardmtpccwitdkons" +
	"kowolancashireisenmtranakayamatsuuramuenstermugithubusercontentr" +
	"entino-sudtirolmuikamogawamukochikushinonsenergymulhouservebbsir" +
	"dalmultichoicemunakatanemuncieszynmuosattemupassagenslingmurmans" +
	"konsulatrobeermurotorcraftrentino-sued-tirolmusashimurayamatsuza" +
	"kis-lostre-toteneis-an-actresshishikuis-an-accountantshiratakaha" +
	"gis-a-techietis-a-therapistoiamusashinoharamuseetrentino-suedtir" +
	"olmuseumverenigingmutsuzawamutuellevangermyokohamamatsudamypetsl" +
	"upskonyveloftrentino-altoadigemyphotoshibahccavuotnagareyamaizur" +
	"ubtsovskiptveterinairebungoonomichinomiyakemytis-a-bookkeepermin" +
	"amiyamashirokawanabelgorodeophiladelphiaareadmyblogsitephilately" +
	"philipsyphoenixn--3ds443gphotographysiopiagetmyipassenger-associ" +
	"ationpictetrentinoa-adigepicturesnzpiemontepilotsokanrapinkoperv" +
	"ikommunalforbundpioneerpippupiszpittsburghofermobilypiwatepizzap" +
	"koryolasiteplanetariuminanoplantationplantsokndalplatformincommb" +
	"ankongsbergplaystationplazaplchofunatorientexpressassaris-a-fina" +
	"ncialadvisor-aurdaluccapebretonamiasakuchinotsuchiurakawassamuka" +
	"wataricohdavvenjargamvikazunoplombardyndns-at-workinggroupavianc" +
	"apetownplumbingotvbarclaysakuraibigawaustinnaturalsciencesnature" +
	"lles3-external-1plusterpmnpodzonepohlpokerpokrovskosaigawapoliti" +
	"endapolkowicepoltavalle-aostathellexuslivinghistorypomorzeszowit" +
	"hgoogleapisa-hockeynutrentinoaadigepordenonepornporsangerporsang" +
	"ugeporsgrunnanpoznanpraxis-a-bruinsfansolarssonprdpreservationpr" +
	"esidioprgmrprimelbourneprincipeprivneprochowiceproductionsologne" +
	"proferraraprogressivenneslaskerrylogisticsolundbeckosakaerodrome" +
	"gallupinbarcelonagasakijobservercellierneues3-us-west-1projectre" +
	"ntinoalto-adigepromombetsupportrentinoaltoadigepropertyprotectio" +
	"nprudentialpruszkowithyoutubeneventochiokinoshimalselvendrellprz" +
	"eworskogptzpvtrentinos-tirolpwchonanbugattipschmidtre-gauldaluce" +
	"rnepzqldqponqslgbtrentinostirolqvchoseiroumuenchenstudiostudyndn" +
	"s-freemasonryokamikawanehonbetsurutaharastuff-4-salestuttgartren" +
	"tinosued-tirolsurnadalsurreysusakis-uberleetrentino-a-adigesuson" +
	"osuzakanumazurysuzukanzakiwiensuzukis-very-badaddjamalborkdalsva" +
	"lbardudinkakamigaharasveiosvelvikosherbrookegawasvizzeraswedensw" +
	"idnicapitalonewhollandswiebodzindianmarketingswiftcoverisignswin" +
	"oujscienceandhistoryswisshikis-very-evillagesxn--3e0b707etunesoo" +
	"turystykarasjoksnesopotrentinosud-tiroltuscanytushuissier-justic" +
	"etuvalle-d-aostatoilvestnesor-varangervestre-slidreamhostersorfo" +
	"ldvestre-totennishiawakuravestvagoyvevelstadvibo-valentiaviboval" +
	"entiavideovillaskoyabearalvahkihokumakogeniwaizumiotsukumiyamazo" +
	"nawsabaerobaticketsorreisahayakawakamiichikaiseis-slickomforbana" +
	"narepublicargodaddynathomebuiltarumizusawaustevollavangenaturalh" +
	"istorymuseumcenterhcloudcontrolledigitalaziobiragroks-thisamitsu" +
	"keisenbahnativeamericanantiques3-ap-southeast-2vinnicarbonia-igl" +
	"esias-carboniaiglesiascarboniavinnytsiavipsinaappfizervirginiavi" +
	"rtualvirtuelvisakatakinouevistaprintuitrentottoris-very-goodhand" +
	"sonviterboltrevisohughesolutionsomavivoldavladikavkazanvladimirv" +
	"ladivostokaizukarasuyamazoevlogvolkenkunderseaportroandinosaurep" +
	"ortrentinosuedtirolvolkswagentsortlandvologdanskoshunantokashiki" +
	"zunokunimilanovolvolgogradvolyngdalvoronezhytomyrvossevangenvote" +
	"votingvotoursoruminnesotaketakatsukis-into-cartoonshisuifuettert" +
	"dasnetzwindowshitaramavrnworse-thangglidingwowiwatsukiyonowrites" +
	"thisblogspotrogstadwroclawloclawekostromahachijorpelandwtchoshib" +
	"uyachiyodawtferrarittogoldpointelligencewuozuwwworldwzmiuwajimax" +
	"n--4gbriminingxn--4gq48lf9jeonnamerikawauexn--4it168dxn--4it797k" +
	"otohiradomainsureitrentino-s-tirollagrigentomologyeonggiehtavuoa" +
	"tnagaivuotnagaokakyotambabydgoszczecinemailxn--4pvxsouthcarolina" +
	"zawaxn--54b7fta0cchromediaxn--55qw42gxn--55qx5dxn--5js045dxn--5r" +
	"tp49chryslerxn--5rtq34kotouraxn--5su34j936bgsgxn--5tzm5gxn--6btw" +
	"5axn--6frz82gxn--6orx2rxn--6qq986b3xlxn--7t0a264chtrainingrpaler" +
	"momasvuotnakatsugawaxn--80adxhksouthwestfalenxn--80ao21axn--80aq" +
	"ecdr1axn--80asehdbarefootballangenoamishirasatobishimalopolskanl" +
	"andivttasvuotnakamagayachtsakyotanabellevuelosangelesjaguarchite" +
	"cturealtychyattorneyagawalbrzycharternopilawalesundiyonagunivers" +
	"ityoriikasaokamiokamiminersalangenavigationavuotnakhodkanagawaus" +
	"traliaisondriodejaneirochesterxn--80aswgxn--80audnedalnxn--8ltr6" +
	"2kouhokutamakis-an-engineeringxn--8pvr4uxn--8y0a063axn--90a3acad" +
	"emydroboatsaritsynologyeongbukounosunndalxn--90aishobaraomoriguc" +
	"hiharagusaarlandxn--90azhair-surveillancexn--9dbhblg6diethnology" +
	"xn--9dbq2axn--9et52uxn--9krt00axn--andy-iraxn--aroport-byanagawa" +
	"xn--asky-iraxn--aurskog-hland-jnbargainstitutelefonicafederation" +
	"ayoroceanographicsalondonetskashibatakasugaibmdnpalacemergencybe" +
	"rlevagangaviikanonjiinetatamotorsaltdalindasiaustrheimatunduhren" +
	"nesoyekaterinburgjemnes3-external-2xn--avery-yuasakegawaxn--b-5g" +
	"axn--b4w605ferdxn--bck1b9a5dre4chungbukchristiansburgruexn--bddd" +
	"j-mrabdxn--bearalvhki-y4axn--berlevg-jxaxn--bhcavuotna-s4axn--bh" +
	"ccavuotna-k7axn--bidr-5nachikatsuuraxn--bievt-0qa2xn--bjarky-fya" +
	"naizuxn--bjddar-ptamboversaillesor-odalxn--blt-elaborxn--bmlo-gr" +
	"aingerxn--bod-2naroyxn--brnny-wuaccident-investigationjukudoyama" +
	"ceratabuseat-band-campaniamallamadridvagsoyericssonlineat-urlxn-" +
	"-brnnysund-m8accident-preventionxn--brum-voagatromsakakinokiaxn-" +
	"-btsfjord-9zaxn--c1avgxn--c2br7gxn--c3s14minternationalfirearmsi" +
	"enarashinoxn--cck2b3barreauctionflatangerxn--cg4bkis-very-nicexn" +
	"--ciqpnxn--clchc0ea0b2g2a9gcdn77-securecreationxn--comunicaes-v6" +
	"a2oxn--correios-e-telecomunicaes-ghc29axn--czr694barrel-of-knowl" +
	"edgeometre-experts-comptablesalvadordalibabaikaliszczytnordlandr" +
	"angedalindesnesalzburgladeloittenrightathomeftpaccessamegawautho" +
	"rdalandroidiscountyumenaturbruksgymnaturhistorisches3-fips-us-go" +
	"v-west-1xn--czrs0tromsojavald-aostarnbergxn--czru2dxn--czrw28bar" +
	"rell-of-knowledgeorgeorgiautomotivecodyn-o-saurlandes3-sa-east-1" +
	"xn--d1acj3bashkiriautoscanadaejeonbukariyakumoldebinagisoccertif" +
	"icationatuurwetenschappenaumburgjerdrumckinseyokosukareliancebin" +
	"osegawakunedre-eikereviewskrakowebhopagefrontappagespeedmobilize" +
	"robihirosakikamijimaeroportalabamagasakishimabarackmaze-burggfar" +
	"merseinewyorkshireggio-emilia-romagnakanotoddenasushiobarabruzzo" +
	"ologicalvinklein-addrammenuernbergdyniabogadocscbg12000xn--d1alf" +
	"aromeoxn--d1atrusteexn--d5qv7z876chungnamdalseidfjordyroyrviking" +
	"uideventsaudaxn--davvenjrga-y4axn--djrs72d6uyxn--djty4kouyamashi" +
	"kokuchuoxn--dnna-grajewolterskluwerxn--drbak-wuaxn--dyry-iraxn--" +
	"eckvdtc9dxn--efvn9sowaxn--efvy88hakatanotteroyxn--ehqz56nxn--elq" +
	"q16hakodatevaksdalxn--estv75gxn--eveni-0qa01gaxn--f6qx53axn--fct" +
	"429kouzushimasoyxn--fhbeiarnxn--finny-yuaxn--fiq228c5hspreadbett" +
	"ingxn--fiq64basilicataniaveroykenvironmentalconservationaustdali" +
	"llesandefjordiscoveryggeelvinckarlsoyokotebizenakaniikawatanagur" +
	"amusementarantomsk-uralsk12xn--fiqs8spydebergxn--fiqz9srlxn--fjo" +
	"rd-lraxn--fjq720axn--fl-ziaxn--flor-jraxn--flw351exn--fpcrj9c3dx" +
	"n--frde-grandrapidsrtrentinosudtirolxn--frna-woaraisaijosoyrovig" +
	"orlicexn--frya-hraxn--fzc2c9e2churchaseljeepilepsydneyxn--fzys8d" +
	"69uvgmailxn--g2xx48chuvashiaxn--gckr3f0ferreroticampobassociates" +
	"evenassisicilyxn--gecrj9circlegallocuscountryestateofdelawaredum" +
	"brellahppiacenzakopanerairforcechirealtorlandxn--ggaviika-8ya47h" +
	"akonexn--gildeskl-g0axn--givuotna-8yandexn--3oq18vl8pn36axn--gjv" +
	"ik-wuaxn--gk3at1exn--gls-elacaixaxn--gmq050is-very-sweetrentino-" +
	"aadigexn--gmqw5axn--h-2fairwindsrvdonskoseis-an-artistjohnxn--h1" +
	"aeghakubankolobrzegyptianpachigasakidsmynasperschlesischesurance" +
	"xn--h2brj9circuscultureggio-calabriaxn--hbmer-xqaxn--hcesuolo-7y" +
	"a35basketballfinanz-2xn--hery-iraxn--hgebostad-g3axn--hmmrfeasta" +
	"-s4acoachampionshiphopenair-traffic-controlleyxn--hnefoss-q1axn-" +
	"-hobl-iraxn--holtlen-hxaxn--hpmir-xqaxn--hxt814exn--hyanger-q1ax" +
	"n--hylandet-54axn--i1b6b1a6a2exn--imr513nxn--indery-fyaotsurguts" +
	"iracusaitokyotangovtrverranzanxn--io0a7is-with-thebandoomdnsalia" +
	"scolipicenord-odalxn--j1aefetsundxn--j1amhakuis-a-nurseoullensva" +
	"nguardxn--j6w193gxn--jlq61u9w7batochigiftsamnangerxn--jlster-bya" +
	"roslavlaanderenxn--jrpeland-54axn--jvr189misakis-into-gamessinas" +
	"hikitchenxn--k7yn95exn--karmy-yuaxn--kbrq7oxn--kcrx77d1x4axn--kf" +
	"jord-iuaxn--klbu-woaxn--klt787dxn--kltp7dxn--kltx9axn--klty5xn--" +
	"3pxu8kosugexn--koluokta-7ya57hakusandnessjoenxn--kprw13dxn--kpry" +
	"57dxn--kpu716fguovdageaidnulminamiechizenxn--kput3isleofmandalxn" +
	"--krager-gyasakaiminatoyakokamisatohobby-sitexasdaburyatiaarphar" +
	"maciensmolenskooris-an-anarchistoricalsocietyxn--kranghke-b0axn-" +
	"-krdsherad-m8axn--krehamn-dxaxn--krjohka-hwab49jetztrentino-alto" +
	"-adigexn--ksnes-uuaxn--kvfjord-nxaxn--kvitsy-fyasugissmarterthan" +
	"youxn--kvnangen-k0axn--l-1faitheguardianquanconagawakuyabukicks-" +
	"assedicitadeliverybnikahokutogliattiresauheradxn--l1accenturekla" +
	"mborghiniizaxn--laheadju-7yasuokaratexn--langevg-jxaxn--lcvr32dx" +
	"n--ldingen-q1axn--leagaviika-52batsfjordrivelandrobaknoluoktaina" +
	"ikawachinaganoharamcoalaheadjudaicaaarborteaches-yogasawaracingr" +
	"oks-theatreemersongdalenviknakanojohanamakinoharavocatanzarowedd" +
	"ingjerstadotsuruokamakurazakisofukushimarnardalillyokozehimejibe" +
	"stadishakotankarmoyomitanobninskarpaczeladz-1xn--lesund-huaxn--l" +
	"gbbat1ad8jevnakerxn--lgrd-poaciticasinorfolkebiblefrakkestadyndn" +
	"s-workshoppdalowiczest-le-patrondheimperiaxn--lhppi-xqaxn--linds" +
	"-pramericanartrysilkoshimizumakiyosumykolaivaroyxn--lns-qlanxess" +
	"toragexn--loabt-0qaxn--lrdal-sraxn--lrenskog-54axn--lt-liacivila" +
	"viationxn--lten-granexn--lury-iraxn--mely-iraxn--merker-kuaxn--m" +
	"gb2ddestordalxn--mgb9awbfidelityxn--mgba3a3ejtulansomnaritakuras" +
	"hikis-saveducatorahimeshimakanegasakinkobayashikshacknetnedalxn-" +
	"-mgba3a4f16axn--mgba3a4franamizuholdingsmileirvikozagawaxn--mgba" +
	"7c0bbn0axn--mgbaakc7dvfidonnakamuratakahamannortonsbergushikamif" +
	"uranotairesewildlifestylexn--mgbaam7a8haldenxn--mgbab2bdxn--mgba" +
	"i9a5eva00bauhausposts-and-telecommunicationsnasadoes-itveronagas" +
	"ukemrxn--mgbai9azgqp6jewelryxn--mgbayh7gpaduaxn--mgbb9fbpobanaza" +
	"waxn--mgbbh1a71exn--mgbc0a9azcgxn--mgbca7dzdownloadxn--mgberp4a5" +
	"d4a87gxn--mgberp4a5d4arxn--mgbi4ecexposedxn--mgbpl2fhvalerxn--mg" +
	"bqly7c0a67fbcivilisationxn--mgbqly7cvafredrikstadtvstorenburgxn-" +
	"-mgbt3dhdxn--mgbtf8flekkefjordxn--mgbtx2bbcarrierxn--mgbx4cd0abb" +
	"vieeexn--mix082fieldxn--mix891figuerestaurantoyonezawaxn--mjndal" +
	"en-64axn--mk0axindustriesteamfamberkeleyxn--mk1bu44civilizationx" +
	"n--mkru45iwchernovtsykkylvenetoeiheijis-a-doctorayxn--mlatvuopmi" +
	"-s4axn--mli-tlapyatigorskozakis-an-entertainerxn--mlselv-iuaxn--" +
	"moreke-juaxn--mori-qsakuhokkaidontexisteingeekpnxn--mosjen-eyato" +
	"minamiawajikixn--mot-tlaquilancasterxn--mre-og-romsdal-qqbbtatar" +
	"stanfshostrodawaravoues3-us-gov-west-1xn--msy-ula0halsaintlouis-" +
	"a-anarchistoirehabmerxn--mtta-vrjjat-k7afamilycompanycivilwarman" +
	"agementjomemorialukowhoswhokksundxn--muost-0qaxn--mxtq1misasagur" +
	"is-leetrdxn--ngbc5azdxn--ngbe9e0axn--ngbrxn--42c2d9axn--nit225kp" +
	"pspiegelxn--nmesjevuemie-tcbajddarchaeologyxn--nnx388axn--nodess" +
	"akuragawaxn--nqv7fs00emaxn--nry-yla5gxn--ntso0iqx3axn--ntsq17gxn" +
	"--nttery-byaeservegame-serverdalxn--nvuotna-hwaxn--nyqy26axn--o1" +
	"achattanooganorilskleppharmacysnoasaitamatsukuris-not-certifiedo" +
	"gawarabikomaezakirunoshiroomuraxn--o3cw4hammarfeastafricamagiche" +
	"rnivtsiciliaxn--od0algxn--od0aq3bbvacationswatch-and-clockerxn--" +
	"ogbpf8flesbergxn--oppegrd-ixaxn--ostery-fyatsukaratsuginamikatag" +
	"amihoboleslawieclaimsavannahgaxn--osyro-wuaxn--p1acfdxn--p1aixn-" +
	"-pbt977clickddielddanuorrikuzentakatajirissagaeroclubmedecincinn" +
	"ationwidealerimo-i-ranadexchangeiseiyoichiropracticbcn-north-1xn" +
	"--pgbs0dhlxn--porsgu-sta26filateliaxn--pssu33lxn--pssy2uxn--q9jy" +
	"b4clinicateringebudejjuedischesapeakebayernurembergrondarxn--qck" +
	"a1pmcdonaldstorfjordxn--qqqt11misawaxn--qxamurskinderoyxn--rady-" +
	"iraxn--rdal-poaxn--rde-ularvikrasnodarxn--rdy-0nabarixn--rennesy" +
	"-v1axn--rhkkervju-01aflakstadaokagakibichuoxn--rholt-mragowoodsi" +
	"dexn--rhqv96gxn--rht27zxn--rht3dxn--rht61exn--risa-5narusawaxn--" +
	"risr-iraxn--rland-uuaxn--rlingen-mxaxn--rmskog-byatsushiroxn--rn" +
	"y31hamurakamigoriginshinshiroxn--rovu88bentleyukuhashimojiitateb" +
	"ayashijonawatextileksvikashiharaxasmatartanddesignieznorddalavag" +
	"iske12xn--rros-granvindafjordxn--rskog-uuaxn--rst-0narutokorozaw" +
	"axn--rsta-francaiseharaxn--ryken-vuaxn--ryrvik-byawaraxn--s-1far" +
	"eastcoastaldefencexn--s9brj9cliniquenoharaxn--sandnessjen-ogbizh" +
	"evskrasnoyarskommunexn--sandy-yuaxn--seral-lraxn--ses554gxn--sgn" +
	"e-gratangenxn--skierv-utazaskvolloabathsbclintonoshoesaves-the-w" +
	"halessandria-trani-barletta-andriatranibarlettaandriaxn--skjervy" +
	"-v1axn--skjk-soaxn--sknit-yqaxn--sknland-fxaxn--slat-5narviikana" +
	"nporovnoxn--slt-elabourxn--smla-hraxn--smna-gratis-a-bulls-fanxn" +
	"--snase-nraxn--sndre-land-0cbremangerxn--snes-poaxn--snsa-roaxn-" +
	"-sr-aurdal-l8axn--sr-fron-q1axn--sr-odal-q1axn--sr-varanger-ggbe" +
	"ppubolognagatorockartuzyurihonjournalistjordalshalsenhsamsclubin" +
	"dalinkashiwaraxn--srfold-byawatahamaxn--srreisa-q1axn--srum-graz" +
	"xn--stfold-9xaxn--stjrdal-s1axn--stjrdalshalsen-sqberndunloppaci" +
	"ficartierxn--stre-toten-zcbstpetersburgxn--t60b56axn--tckweather" +
	"channelxn--tiq49xqyjewishartgalleryxn--tjme-hraxn--tn0agrinetban" +
	"kzxn--tnsberg-q1axn--tor131oxn--trany-yuaxn--trgstad-r1axn--trna" +
	"-woaxn--troms-zuaxn--tysvr-vraxn--uc0atversicherungxn--uc0ay4axn" +
	"--uist22hangoutsystemscloudcontrolapparmaxn--uisz3gxn--unjrga-rt" +
	"aobaokinawashirosatobamagazinemurorangeologyxn--unup4yxn--uuwu58" +
	"axn--vads-jraxn--vard-jraxn--vegrshei-c0axn--vermgensberater-ctb" +
	"eskidynaliascoli-picenord-frontierxn--vermgensberatung-pwbestbuy" +
	"shousesamsunglassassinationalheritagematsubarakawagoepostfoldnav" +
	"yatkakudamatsuepsonyoursidegreevje-og-hornnesanfranciscotlanduns" +
	"agamiharaxn--vestvgy-ixa6oxn--vg-yiabcgxn--vgan-qoaxn--vgsy-qoa0" +
	"jfkomitamamuraxn--vgu402clothinguitarsavonaplesaxoxn--vhquvestfo" +
	"ldxn--vler-qoaxn--vre-eiker-k8axn--vrggt-xqadxn--vry-yla5gxn--vu" +
	"q861betainaboxfordeatnuorogersvpalanaklodzkodairaxn--w4r85el8fhu" +
	"5dnraxn--w4rs40lxn--wcvs22dxn--wgbh1cloudfrontdoorxn--wgbl6axn--" +
	"xhq521bhartiffanynysafetysfjordupontarioceanographiquexn--xkc2al" +
	"3hye2axn--xkc2dl3a5ee0hannanmokuizumodernxn--y9a3aquariumisconfu" +
	"sedxn--yer-znarvikredstonexn--yfro4i67oxn--ygarden-p1axn--ygbi2a" +
	"mmxn--45brj9choyodobashichikashukujitawaraxn--ystre-slidre-ujbie" +
	"lawallonieruchomoscienceandindustrynikiiyamanobeauxartsandcrafts" +
	"angoddaxn--zbx025dxn--zf0ao64axn--zf0avxn--45q11christmasakikuga" +
	"watchesatxjaworznoxn--zfr164biellaakesvuemieleccexperiaxz"

// nodes is the list of nodes. Each node is represented as a uint32, which
// encodes the node's children, wildcard bit and node type (as an index into
// the children array), ICANN bit and text.
//
// In the //-comment after each node's data, the nodes indexes of the children
// are formatted as (n0x1234-n0x1256), with * denoting the wildcard bit. The
// nodeType is printed as + for normal, ! for exception, and o for parent-only
// nodes that have children but don't match a domain label in their own right.
// An I denotes an ICANN domain.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 9 bits] children index
//	[ 1 bits] ICANN bit
//	[15 bits] text index
//	[ 6 bits] text length
var nodes = [...]uint32{
	0x00352883, // n0x0000 c0x0000 (---------------)  + I aaa
	0x0034ae44, // n0x0001 c0x0000 (---------------)  + I aarp
	0x00250d46, // n0x0002 c0x0000 (---------------)  + I abarth
	0x0023e483, // n0x0003 c0x0000 (---------------)  + I abb
	0x0023e486, // n0x0004 c0x0000 (---------------)  + I abbott
	0x00365f46, // n0x0005 c0x0000 (---------------)  + I abbvie
	0x0039a8c3, // n0x0006 c0x0000 (---------------)  + I abc
	0x0031f604, // n0x0007 c0x0000 (---------------)  + I able
	0x00329987, // n0x0008 c0x0000 (---------------)  + I abogado
	0x00250988, // n0x0009 c0x0000 (---------------)  + I abudhabi
	0x01a00342, // n0x000a c0x0006 (n0x0607-n0x060d)  + I ac
	0x0030cf07, // n0x000b c0x0000 (---------------)  + I academy
	0x0034fd09, // n0x000c c0x0000 (---------------)  + I accenture
	0x002cfaca, // n0x000d c0x0000 (---------------)  + I accountant
	0x002cfacb, // n0x000e c0x0000 (---------------)  + I accountants
	0x00233d03, // n0x000f c0x0000 (---------------)  + I aco
	0x0028c8c6, // n0x0010 c0x0000 (---------------)  + I active
	0x00239e85, // n0x0011 c0x0000 (---------------)  + I actor
	0x01e001c2, // n0x0012 c0x0007 (n0x060d-n0x060e)  + I ad
	0x00212904, // n0x0013 c0x0000 (---------------)  + I adac
	0x0025ab43, // n0x0014 c0x0000 (---------------)  + I ads
	0x002a3105, // n0x0015 c0x0000 (---------------)  + I adult
	0x022030c2, // n0x0016 c0x0008 (n0x060e-n0x0616)  + I ae
	0x00255e03, // n0x0017 c0x0000 (---------------)  + I aeg
	0x026e2dc4, // n0x0018 c0x0009 (n0x0616-n0x066d)  + I aero
	0x0026af85, // n0x0019 c0x0000 (---------------)  + I aetna
	0x02a05242, // n0x001a c0x000a (n0x066d-n0x0672)  + I af
	0x0036d9ce, // n0x001b c0x0000 (---------------)  + I afamilycompany
	0x00251303, // n0x001c c0x0000 (---------------)  + I afl
	0x00374cc6, // n0x001d c0x0000 (---------------)  + I africa
	0x00374ccb, // n0x001e c0x0000 (---------------)  + I africamagic
	0x02e01b82, // n0x001f c0x000b (n0x0672-n0x0677)  + I ag
	0x00283a87, // n0x0020 c0x0000 (---------------)  + I agakhan
	0x0023cc46, // n0x0021 c0x0000 (---------------)  + I agency
	0x03200502, // n0x0022 c0x000c (n0x0677-n0x067b)  + I ai
	0x00215703, // n0x0023 c0x0000 (---------------)  + I aig
	0x00215704, // n0x0024 c0x0000 (---------------)  + I aigo
	0x002b7a06, // n0x0025 c0x0000 (---------------)  + I airbus
	0x003385c8, // n0x0026 c0x0000 (---------------)  + I airforce
	0x00285646, // n0x0027 c0x0000 (---------------)  + I airtel
	0x00229704, // n0x0028 c0x0000 (---------------)  + I akdn
	0x03600d02, // n0x0029 c0x000d (n0x067b-n0x0682)  + I al
	0x00329f49, // n0x002a c0x0000 (---------------)  + I alfaromeo
	0x0031f947, // n0x002b c0x0000 (---------------)  + I alibaba
	0x002be246, // n0x002c c0x0000 (---------------)  + I alipay
	0x0033e289, // n0x002d c0x0000 (---------------)  + I allfinanz
	0x0020a148, // n0x002e c0x0000 (---------------)  + I allstate
	0x00212f04, // n0x002f c0x0000 (---------------)  + I ally
	0x00222006, // n0x0030 c0x0000 (---------------)  + I alsace
	0x0020adc6, // n0x0031 c0x0000 (---------------)  + I alstom
	0x03a00942, // n0x0032 c0x000e (n0x0682-n0x0683)  + I am
	0x0024678f, // n0x0033 c0x0000 (---------------)  + I americanexpress
	0x00207b4e, // n0x0034 c0x0000 (---------------)  + I americanfamily
	0x00200944, // n0x0035 c0x0000 (---------------)  + I amex
	0x003676c5, // n0x0036 c0x0000 (---------------)  + I amfam
	0x0023e385, // n0x0037 c0x0000 (---------------)  + I amica
	0x002c0509, // n0x0038 c0x0000 (---------------)  + I amsterdam
	0x00243249, // n0x0039 c0x0000 (---------------)  + I analytics
	0x00321107, // n0x003a c0x0000 (---------------)  + I android
	0x0034e986, // n0x003b c0x0000 (---------------)  + I anquan
	0x0024bac3, // n0x003c c0x0000 (---------------)  + I anz
	0x03e02882, // n0x003d c0x000f (n0x0683-n0x0689)  + I ao
	0x00275443, // n0x003e c0x0000 (---------------)  + I aol
	0x0023d94a, // n0x003f c0x0000 (---------------)  + I apartments
	0x00208083, // n0x0040 c0x0000 (---------------)  + I app
	0x0026c205, // n0x0041 c0x0000 (---------------)  + I apple
	0x00200f02, // n0x0042 c0x0000 (---------------)  + I aq
	0x00286809, // n0x0043 c0x0000 (---------------)  + I aquarelle
	0x04201d42, // n0x0044 c0x0010 (n0x0689-n0x0692)  + I ar
	0x00202344, // n0x0045 c0x0000 (---------------)  + I arab
	0x003523c6, // n0x0046 c0x0000 (---------------)  + I aramco
	0x00308e45, // n0x0047 c0x0000 (---------------)  + I archi
	0x00346644, // n0x0048 c0x0000 (---------------)  + I army
	0x04a54644, // n0x0049 c0x0012 (n0x0693-n0x0699)  + I arpa
	0x00239044, // n0x004a c0x0000 (---------------)  + I arte
	0x04e03302, // n0x004b c0x0013 (n0x0699-n0x069a)  + I as
	0x0034ab84, // n0x004c c0x0000 (---------------)  + I asda
	0x00312a84, // n0x004d c0x0000 (---------------)  + I asia
	0x00336d8a, // n0x004e c0x0000 (---------------)  + I associates
	0x05200482, // n0x004f c0x0014 (n0x069a-n0x06a1)  + I at
	0x00248447, // n0x0050 c0x0000 (---------------)  + I athleta
	0x00309308, // n0x0051 c0x0000 (---------------)  + I attorney
	0x05a05782, // n0x0052 c0x0016 (n0x06a2-n0x06b4)  + I au
	0x0031c647, // n0x0053 c0x0000 (---------------)  + I auction
	0x00232e44, // n0x0054 c0x0000 (---------------)  + I audi
	0x002b8f07, // n0x0055 c0x0000 (---------------)  + I audible
	0x00232e45, // n0x0056 c0x0000 (---------------)  + I audio
	0x00360347, // n0x0057 c0x0000 (---------------)  + I auspost
	0x00320ec6, // n0x0058 c0x0000 (---------------)  + I author
	0x00229f44, // n0x0059 c0x0000 (---------------)  + I auto
	0x00324485, // n0x005a c0x0000 (---------------)  + I autos
	0x002dbe87, // n0x005b c0x0000 (---------------)  + I avianca
	0x06a01c02, // n0x005c c0x001a (n0x06c2-n0x06c3)  + I aw
	0x002f2043, // n0x005d c0x0000 (---------------)  + I aws
	0x00224142, // n0x005e c0x0000 (---------------)  + I ax
	0x003827c3, // n0x005f c0x0000 (---------------)  + I axa
	0x06e03442, // n0x0060 c0x001b (n0x06c3-n0x06cf)  + I az
	0x00281bc5, // n0x0061 c0x0000 (---------------)  + I azure
	0x07200882, // n0x0062 c0x001c (n0x06cf-n0x06da)  + I ba
	0x003025c4, // n0x0063 c0x0000 (---------------)  + I baby
	0x0027cd45, // n0x0064 c0x0000 (---------------)  + I baidu
	0x00200887, // n0x0065 c0x0000 (---------------)  + I banamex
	0x002f2f0e, // n0x0066 c0x0000 (---------------)  + I bananarepublic
	0x00206a84, // n0x0067 c0x0000 (---------------)  + I band
	0x00203204, // n0x0068 c0x0000 (---------------)  + I bank
	0x002049c3, // n0x0069 c0x0000 (---------------)  + I bar
	0x002e3209, // n0x006a c0x0000 (---------------)  + I barcelona
	0x002c304b, // n0x006b c0x0000 (---------------)  + I barclaycard
	0x002dc488, // n0x006c c0x0000 (---------------)  + I barclays
	0x00307448, // n0x006d c0x0000 (---------------)  + I barefoot
	0x00310808, // n0x006e c0x0000 (---------------)  + I bargains
	0x0022df88, // n0x006f c0x0000 (---------------)  + I baseball
	0x0033e0ca, // n0x0070 c0x0000 (---------------)  + I basketball
	0x00360247, // n0x0071 c0x0000 (---------------)  + I bauhaus
	0x0037b946, // n0x0072 c0x0000 (---------------)  + I bayern
	0x0763e4c2, // n0x0073 c0x001d (n0x06da-n0x06e4)  + I bb
	0x00365a03, // n0x0074 c0x0000 (---------------)  + I bbc
	0x0036be43, // n0x0075 c0x0000 (---------------)  + I bbt
	0x00375804, // n0x0076 c0x0000 (---------------)  + I bbva
	0x0039a903, // n0x0077 c0x0000 (---------------)  + I bcg
	0x00379cc3, // n0x0078 c0x0000 (---------------)  + I bcn
	0x01714f02, // n0x0079 c0x0005 (---------------)* o I bd
	0x07a02e02, // n0x007a c0x001e (n0x06e4-n0x06e6)  + I be
	0x0021acc5, // n0x007b c0x0000 (---------------)  + I beats
	0x0024fac6, // n0x007c c0x0000 (---------------)  + I beauty
	0x002ce284, // n0x007d c0x0000 (---------------)  + I beer
	0x003819c7, // n0x007e c0x0000 (---------------)  + I bentley
	0x0022fc06, // n0x007f c0x0000 (---------------)  + I berlin
	0x00354f84, // n0x0080 c0x0000 (---------------)  + I best
	0x00397e47, // n0x0081 c0x0000 (---------------)  + I bestbuy
	0x002079c3, // n0x0082 c0x0000 (---------------)  + I bet
	0x07f5b5c2, // n0x0083 c0x001f (n0x06e6-n0x06e7)  + I bf
	0x08304a82, // n0x0084 c0x0020 (n0x06e7-n0x070c)  + I bg
	0x0870ebc2, // n0x0085 c0x0021 (n0x070c-n0x0711)  + I bh
	0x0039f186, // n0x0086 c0x0000 (---------------)  + I bharti
	0x08a00002, // n0x0087 c0x0022 (n0x0711-n0x0716)  + I bi
	0x00356b45, // n0x0088 c0x0000 (---------------)  + I bible
	0x00316443, // n0x0089 c0x0000 (---------------)  + I bid
	0x00202404, // n0x008a c0x0000 (---------------)  + I bike
	0x002dc2c4, // n0x008b c0x0000 (---------------)  + I bing
	0x002dc2c5, // n0x008c c0x0000 (---------------)  + I bingo
	0x00203e43, // n0x008d c0x0000 (---------------)  + I bio
	0x08f31a83, // n0x008e c0x0023 (n0x0716-n0x071e)  + I biz
	0x0920b442, // n0x008f c0x0024 (n0x071e-n0x0722)  + I bj
	0x0028b585, // n0x0090 c0x0000 (---------------)  + I black
	0x0028b58b, // n0x0091 c0x0000 (---------------)  + I blackfriday
	0x00259006, // n0x0092 c0x0000 (---------------)  + I blanco
	0x0020db0b, // n0x0093 c0x0000 (---------------)  + I blockbuster
	0x0022f084, // n0x0094 c0x0000 (---------------)  + I blog
	0x0020e289, // n0x0095 c0x0000 (---------------)  + I bloomberg
	0x0020f384, // n0x0096 c0x0000 (---------------)  + I blue
	0x0960f9c2, // n0x0097 c0x0025 (n0x0722-n0x0727)  + I bm
	0x00210f03, // n0x0098 c0x0000 (---------------)  + I bms
	0x00211fc3, // n0x0099 c0x0000 (---------------)  + I bmw
	0x01612142, // n0x009a c0x0005 (---------------)* o I bn
	0x00246cc3, // n0x009b c0x0000 (---------------)  + I bnl
	0x0021214a, // n0x009c c0x0000 (---------------)  + I bnpparibas
	0x09a0f682, // n0x009d c0x0026 (n0x0727-n0x0730)  + I bo
	0x0030d185, // n0x009e c0x0000 (---------------)  + I boats
	0x0020f68a, // n0x009f c0x0000 (---------------)  + I boehringer
	0x00292584, // n0x00a0 c0x0000 (---------------)  + I bofa
	0x00213983, // n0x00a1 c0x0000 (---------------)  + I bom
	0x00213fc4, // n0x00a2 c0x0000 (---------------)  + I bond
	0x00215e03, // n0x00a3 c0x0000 (---------------)  + I boo
	0x00215e04, // n0x00a4 c0x0000 (---------------)  + I book
	0x00215e07, // n0x00a5 c0x0000 (---------------)  + I booking
	0x00216f45, // n0x00a6 c0x0000 (---------------)  + I boots
	0x00217205, // n0x00a7 c0x0000 (---------------)  + I bosch
	0x00218406, // n0x00a8 c0x0000 (---------------)  + I bostik
	0x00218f86, // n0x00a9 c0x0000 (---------------)  + I boston
	0x0021b743, // n0x00aa c0x0000 (---------------)  + I bot
	0x0021d848, // n0x00ab c0x0000 (---------------)  + I boutique
	0x00219643, // n0x00ac c0x0000 (---------------)  + I box
	0x09e1e3c2, // n0x00ad c0x0027 (n0x0730-n0x0776)  + I br
	0x0021eb48, // n0x00ae c0x0000 (---------------)  + I bradesco
	0x0021e3cb, // n0x00af c0x0000 (---------------)  + I bridgestone
	0x00223d48, // n0x00b0 c0x0000 (---------------)  + I broadway
	0x00224906, // n0x00b1 c0x0000 (---------------)  + I broker
	0x00225887, // n0x00b2 c0x0000 (---------------)  + I brother
	0x00228408, // n0x00b3 c0x0000 (---------------)  + I brussels
	0x0a630fc2, // n0x00b4 c0x0029 (n0x0777-n0x077c)  + I bs
	0x0aa23a42, // n0x00b5 c0x002a (n0x077c-n0x0781)  + I bt
	0x00208dc8, // n0x00b6 c0x0000 (---------------)  + I budapest
	0x002e6907, // n0x00b7 c0x0000 (---------------)  + I bugatti
	0x00241085, // n0x00b8 c0x0000 (---------------)  + I build
	0x00241088, // n0x00b9 c0x0000 (---------------)  + I builders
	0x002b8308, // n0x00ba c0x0000 (---------------)  + I business
	0x002fefc3, // n0x00bb c0x0000 (---------------)  + I buy
	0x0022f404, // n0x00bc c0x0000 (---------------)  + I buzz
	0x00365fc2, // n0x00bd c0x0000 (---------------)  + I bv
	0x0ae30202, // n0x00be c0x002b (n0x0781-n0x0783)  + I bw
	0x0b20d202, // n0x00bf c0x002c (n0x0783-n0x0787)  + I by
	0x0ba30682, // n0x00c0 c0x002e (n0x0788-n0x078e)  + I bz
	0x00230683, // n0x00c1 c0x0000 (---------------)  + I bzh
	0x0be00e42, // n0x00c2 c0x002f (n0x078e-n0x079f)  + I ca
	0x0023e443, // n0x00c3 c0x0000 (---------------)  + I cab
	0x00310d04, // n0x00c4 c0x0000 (---------------)  + I cafe
	0x00212ec3, // n0x00c5 c0x0000 (---------------)  + I cal
	0x00212ec4, // n0x00c6 c0x0000 (---------------)  + I call
	0x0032914b, // n0x00c7 c0x0000 (---------------)  + I calvinklein
	0x0023ec46, // n0x00c8 c0x0000 (---------------)  + I camera
	0x00241bc4, // n0x00c9 c0x0000 (---------------)  + I camp
	0x002a100e, // n0x00ca c0x0000 (---------------)  + I cancerresearch
	0x00263685, // n0x00cb c0x0000 (---------------)  + I canon
	0x002dbfc8, // n0x00cc c0x0000 (---------------)  + I capetown
	0x002ec107, // n0x00cd c0x0000 (---------------)  + I capital
	0x002ec10a, // n0x00ce c0x0000 (---------------)  + I capitalone
	0x0020cb43, // n0x00cf c0x0000 (---------------)  + I car
	0x002370c7, // n0x00d0 c0x0000 (---------------)  + I caravan
	0x002c3205, // n0x00d1 c0x0000 (---------------)  + I cards
	0x002ae704, // n0x00d2 c0x0000 (---------------)  + I care
	0x002ae706, // n0x00d3 c0x0000 (---------------)  + I career
	0x002ae707, // n0x00d4 c0x0000 (---------------)  + I careers
	0x002bd384, // n0x00d5 c0x0000 (---------------)  + I cars
	0x00390087, // n0x00d6 c0x0000 (---------------)  + I cartier
	0x00215004, // n0x00d7 c0x0000 (---------------)  + I casa
	0x00217e44, // n0x00d8 c0x0000 (---------------)  + I case
	0x00217e46, // n0x00d9 c0x0000 (---------------)  + I caseih
	0x002cb1c4, // n0x00da c0x0000 (---------------)  + I cash
	0x00356846, // n0x00db c0x0000 (---------------)  + I casino
	0x0020f1c3, // n0x00dc c0x0000 (---------------)  + I cat
	0x0037b1c8, // n0x00dd c0x0000 (---------------)  + I catering
	0x0023cf88, // n0x00de c0x0000 (---------------)  + I catholic
	0x0024a9c3, // n0x00df c0x0000 (---------------)  + I cba
	0x00246c83, // n0x00e0 c0x0000 (---------------)  + I cbn
	0x0038b6c4, // n0x00e1 c0x0000 (---------------)  + I cbre
	0x00390643, // n0x00e2 c0x0000 (---------------)  + I cbs
	0x0c22f6c2, // n0x00e3 c0x0030 (n0x079f-n0x07a3)  + I cc
	0x0c662e02, // n0x00e4 c0x0031 (n0x07a3-n0x07a4)  + I cd
	0x00205cc3, // n0x00e5 c0x0000 (---------------)  + I ceb
	0x00204c86, // n0x00e6 c0x0000 (---------------)  + I center
	0x002c0883, // n0x00e7 c0x0000 (---------------)  + I ceo
	0x002e6f84, // n0x00e8 c0x0000 (---------------)  + I cern
	0x0ca14c02, // n0x00e9 c0x0032 (n0x07a4-n0x07a5)  + I cf
	0x00214c03, // n0x00ea c0x0000 (---------------)  + I cfa
	0x00377c83, // n0x00eb c0x0000 (---------------)  + I cfd
	0x0021be82, // n0x00ec c0x0000 (---------------)  + I cg
	0x0ce00382, // n0x00ed c0x0033 (n0x07a5-n0x07a6)  + I ch
	0x002bc906, // n0x00ee c0x0000 (---------------)  + I chanel
	0x0023ad87, // n0x00ef c0x0000 (---------------)  + I channel
	0x00335885, // n0x00f0 c0x0000 (---------------)  + I chase
	0x0021a404, // n0x00f1 c0x0000 (---------------)  + I chat
	0x00284485, // n0x00f2 c0x0000 (---------------)  + I cheap
	0x00201487, // n0x00f3 c0x0000 (---------------)  + I chintai
	0x002b7785, // n0x00f4 c0x0000 (---------------)  + I chloe
	0x003a4c09, // n0x00f5 c0x0000 (---------------)  + I christmas
	0x00303446, // n0x00f6 c0x0000 (---------------)  + I chrome
	0x00304108, // n0x00f7 c0x0000 (---------------)  + I chrysler
	0x00335786, // n0x00f8 c0x0000 (---------------)  + I church
	0x0d209602, // n0x00f9 c0x0034 (n0x07a6-n0x07b5)  + I ci
	0x00234f48, // n0x00fa c0x0000 (---------------)  + I cipriani
	0x00337606, // n0x00fb c0x0000 (---------------)  + I circle
	0x00399cc5, // n0x00fc c0x0000 (---------------)  + I cisco
	0x0034f187, // n0x00fd c0x0000 (---------------)  + I citadel
	0x00356744, // n0x00fe c0x0000 (---------------)  + I citi
	0x00356745, // n0x00ff c0x0000 (---------------)  + I citic
	0x00285804, // n0x0100 c0x0000 (---------------)  + I city
	0x00285808, // n0x0101 c0x0000 (---------------)  + I cityeats
	0x0d60d082, // n0x0102 c0x0035 (n0x07b5-n0x07b6)* o I ck
	0x0da07f42, // n0x0103 c0x0036 (n0x07b6-n0x07bb)  + I cl
	0x003773c6, // n0x0104 c0x0000 (---------------)  + I claims
	0x00227b48, // n0x0105 c0x0000 (---------------)  + I cleaning
	0x003781c5, // n0x0106 c0x0000 (---------------)  + I click
	0x0037b086, // n0x0107 c0x0000 (---------------)  + I clinic
	0x00385708, // n0x0108 c0x0000 (---------------)  + I clinique
	0x0039b608, // n0x0109 c0x0000 (---------------)  + I clothing
	0x00207f45, // n0x010a c0x0000 (---------------)  + I cloud
	0x00378c44, // n0x010b c0x0000 (---------------)  + I club
	0x00378c47, // n0x010c c0x0000 (---------------)  + I clubmed
	0x0de5cd02, // n0x010d c0x0037 (n0x07bb-n0x07bf)  + I cm
	0x0e21dac2, // n0x010e c0x0038 (n0x07bf-n0x07ec)  + I cn
	0x0fa0ce42, // n0x010f c0x003e (n0x07f1-n0x07fe)  + I co
	0x0033f105, // n0x0110 c0x0000 (---------------)  + I coach
	0x0029c345, // n0x0111 c0x0000 (---------------)  + I codes
	0x0020ce46, // n0x0112 c0x0000 (---------------)  + I coffee
	0x0022f707, // n0x0113 c0x0000 (---------------)  + I college
	0x00231707, // n0x0114 c0x0000 (---------------)  + I cologne
	0x10233243, // n0x0115 c0x0040 (n0x07ff-n0x08d1)  + I com
	0x002a7d07, // n0x0116 c0x0000 (---------------)  + I comcast
	0x002d8ec8, // n0x0117 c0x0000 (---------------)  + I commbank
	0x00233249, // n0x0118 c0x0000 (---------------)  + I community
	0x0036db87, // n0x0119 c0x0000 (---------------)  + I company
	0x00233f47, // n0x011a c0x0000 (---------------)  + I compare
	0x00235b08, // n0x011b c0x0000 (---------------)  + I computer
	0x00236306, // n0x011c c0x0000 (---------------)  + I comsec
	0x002368c6, // n0x011d c0x0000 (---------------)  + I condos
	0x002375cc, // n0x011e c0x0000 (---------------)  + I construction
	0x0023830a, // n0x011f c0x0000 (---------------)  + I consulting
	0x002387c7, // n0x0120 c0x0000 (---------------)  + I contact
	0x00239d4b, // n0x0121 c0x0000 (---------------)  + I contractors
	0x0023abc7, // n0x0122 c0x0000 (---------------)  + I cooking
	0x0023abce, // n0x0123 c0x0000 (---------------)  + I cookingchannel
	0x0023b6c4, // n0x0124 c0x0000 (---------------)  + I cool
	0x0023c344, // n0x0125 c0x0000 (---------------)  + I coop
	0x0023f147, // n0x0126 c0x0000 (---------------)  + I corsica
	0x00337987, // n0x0127 c0x0000 (---------------)  + I country
	0x002424c6, // n0x0128 c0x0000 (---------------)  + I coupon
	0x002424c7, // n0x0129 c0x0000 (---------------)  + I coupons
	0x00242ac7, // n0x012a c0x0000 (---------------)  + I courses
	0x11a051c2, // n0x012b c0x0046 (n0x08f0-n0x08f7)  + I cr
	0x00243786, // n0x012c c0x0000 (---------------)  + I credit
	0x0024378a, // n0x012d c0x0000 (---------------)  + I creditcard
	0x00243a0b, // n0x012e c0x0000 (---------------)  + I creditunion
	0x00244b07, // n0x012f c0x0000 (---------------)  + I cricket
	0x002454c5, // n0x0130 c0x0000 (---------------)  + I crown
	0x00245603, // n0x0131 c0x0000 (---------------)  + I crs
	0x00245f46, // n0x0132 c0x0000 (---------------)  + I cruise
	0x00245f47, // n0x0133 c0x0000 (---------------)  + I cruises
	0x00243403, // n0x0134 c0x0000 (---------------)  + I csc
	0x11e08b42, // n0x0135 c0x0047 (n0x08f7-n0x08fd)  + I cu
	0x0024640a, // n0x0136 c0x0000 (---------------)  + I cuisinella
	0x12350e42, // n0x0137 c0x0048 (n0x08fd-n0x08fe)  + I cv
	0x126cadc2, // n0x0138 c0x0049 (n0x08fe-n0x0902)  + I cw
	0x12a477c2, // n0x0139 c0x004a (n0x0902-n0x0904)  + I cx
	0x12e3cd42, // n0x013a c0x004b (n0x0904-n0x0911)  o I cy
	0x0024a0c5, // n0x013b c0x0000 (---------------)  + I cymru
	0x0024a7c4, // n0x013c c0x0000 (---------------)  + I cyou
	0x13600142, // n0x013d c0x004d (n0x0912-n0x0914)  + I cz
	0x0034ac05, // n0x013e c0x0000 (---------------)  + I dabur
	0x002a30c3, // n0x013f c0x0000 (---------------)  + I dad
	0x002275c5, // n0x0140 c0x0000 (---------------)  + I dance
	0x0020da04, // n0x0141 c0x0000 (---------------)  + I date
	0x0020f486, // n0x0142 c0x0000 (---------------)  + I dating
	0x00294506, // n0x0143 c0x0000 (---------------)  + I datsun
	0x00263b83, // n0x0144 c0x0000 (---------------)  + I day
	0x0023f984, // n0x0145 c0x0000 (---------------)  + I dclk
	0x0026bd03, // n0x0146 c0x0000 (---------------)  + I dds
	0x13a05582, // n0x0147 c0x004e (n0x0914-n0x091c)  + I de
	0x00205584, // n0x0148 c0x0000 (---------------)  + I deal
	0x003791c6, // n0x0149 c0x0000 (---------------)  + I dealer
	0x00205585, // n0x014a c0x0000 (---------------)  + I deals
	0x00399646, // n0x014b c0x0000 (---------------)  + I degree
	0x0034f288, // n0x014c c0x0000 (---------------)  + I delivery
	0x0025a104, // n0x014d c0x0000 (---------------)  + I dell
	0x00320608, // n0x014e c0x0000 (---------------)  + I deloitte
	0x00288905, // n0x014f c0x0000 (---------------)  + I delta
	0x00224608, // n0x0150 c0x0000 (---------------)  + I democrat
	0x002aca06, // n0x0151 c0x0000 (---------------)  + I dental
	0x002b3f87, // n0x0152 c0x0000 (---------------)  + I dentist
	0x00228204, // n0x0153 c0x0000 (---------------)  + I desi
	0x00228206, // n0x0154 c0x0000 (---------------)  + I design
	0x0032b083, // n0x0155 c0x0000 (---------------)  + I dev
	0x0037a1c3, // n0x0156 c0x0000 (---------------)  + I dhl
	0x002c6088, // n0x0157 c0x0000 (---------------)  + I diamonds
	0x0030ed44, // n0x0158 c0x0000 (---------------)  + I diet
	0x002f4847, // n0x0159 c0x0000 (---------------)  + I digital
	0x0024da86, // n0x015a c0x0000 (---------------)  + I direct
	0x0024da89, // n0x015b c0x0000 (---------------)  + I directory
	0x00321288, // n0x015c c0x0000 (---------------)  + I discount
	0x00331308, // n0x015d c0x0000 (---------------)  + I discover
	0x003550c4, // n0x015e c0x0000 (---------------)  + I dish
	0x00309c83, // n0x015f c0x0000 (---------------)  + I diy
	0x0024e002, // n0x0160 c0x0000 (---------------)  + I dj
	0x13e489c2, // n0x0161 c0x004f (n0x091c-n0x091d)  + I dk
	0x1420d302, // n0x0162 c0x0050 (n0x091d-n0x0922)  + I dm
	0x00311b83, // n0x0163 c0x0000 (---------------)  + I dnp
	0x14612c02, // n0x0164 c0x0051 (n0x0922-n0x092c)  + I do
	0x00329ac4, // n0x0165 c0x0000 (---------------)  + I docs
	0x00212c05, // n0x0166 c0x0000 (---------------)  + I dodge
	0x00230503, // n0x0167 c0x0000 (---------------)  + I dog
	0x002366c4, // n0x0168 c0x0000 (---------------)  + I doha
	0x003011c7, // n0x0169 c0x0000 (---------------)  + I domains
	0x0023be46, // n0x016a c0x0000 (---------------)  + I doosan
	0x00354243, // n0x016b c0x0000 (---------------)  + I dot
	0x00362ac8, // n0x016c c0x0000 (---------------)  + I download
	0x003519c5, // n0x016d c0x0000 (---------------)  + I drive
	0x00249084, // n0x016e c0x0000 (---------------)  + I dstv
	0x00364c03, // n0x016f c0x0000 (---------------)  + I dtv
	0x0027ccc5, // n0x0170 c0x0000 (---------------)  + I dubai
	0x0027ce04, // n0x0171 c0x0000 (---------------)  + I duck
	0x0038fd86, // n0x0172 c0x0000 (---------------)  + I dunlop
	0x00399f04, // n0x0173 c0x0000 (---------------)  + I duns
	0x0039f786, // n0x0174 c0x0000 (---------------)  + I dupont
	0x002007c6, // n0x0175 c0x0000 (---------------)  + I durban
	0x00319904, // n0x0176 c0x0000 (---------------)  + I dvag
	0x00211443, // n0x0177 c0x0000 (---------------)  + I dwg
	0x14a06842, // n0x0178 c0x0052 (n0x092c-n0x0934)  + I dz
	0x00283945, // n0x0179 c0x0000 (---------------)  + I earth
	0x0021ad03, // n0x017a c0x0000 (---------------)  + I eat
	0x14e088c2, // n0x017b c0x0053 (n0x0934-n0x0940)  + I ec
	0x002b4a45, // n0x017c c0x0000 (---------------)  + I edeka
	0x00239103, // n0x017d c0x0000 (---------------)  + I edu
	0x00239109, // n0x017e c0x0000 (---------------)  + I education
	0x1520cf42, // n0x017f c0x0054 (n0x0940-n0x094a)  + I ee
	0x15a07202, // n0x0180 c0x0056 (n0x094b-n0x0954)  + I eg
	0x00302985, // n0x0181 c0x0000 (---------------)  + I email
	0x002b4346, // n0x0182 c0x0000 (---------------)  + I emerck
	0x003532c7, // n0x0183 c0x0000 (---------------)  + I emerson
	0x002cca86, // n0x0184 c0x0000 (---------------)  + I energy
	0x0030c4c8, // n0x0185 c0x0000 (---------------)  + I engineer
	0x0030c4cb, // n0x0186 c0x0000 (---------------)  + I engineering
	0x00204ccb, // n0x0187 c0x0000 (---------------)  + I enterprises
	0x00398d05, // n0x0188 c0x0000 (---------------)  + I epost
	0x00399385, // n0x0189 c0x0000 (---------------)  + I epson
	0x002c4489, // n0x018a c0x0000 (---------------)  + I equipment
	0x01600682, // n0x018b c0x0005 (---------------)* o I er
	0x00319ac8, // n0x018c c0x0000 (---------------)  + I ericsson
	0x0020dd44, // n0x018d c0x0000 (---------------)  + I erni
	0x16200082, // n0x018e c0x0058 (n0x0955-n0x095a)  + I es
	0x0027a103, // n0x018f c0x0000 (---------------)  + I esq
	0x002c4206, // n0x0190 c0x0000 (---------------)  + I estate
	0x0033ce08, // n0x0191 c0x0000 (---------------)  + I esurance
	0x16a00a42, // n0x0192 c0x005a (n0x095b-n0x0963)  + I et
	0x00226d48, // n0x0193 c0x0000 (---------------)  + I etisalat
	0x00205382, // n0x0194 c0x0000 (---------------)  + I eu
	0x0027bb4a, // n0x0195 c0x0000 (---------------)  + I eurovision
	0x0022a283, // n0x0196 c0x0000 (---------------)  + I eus
	0x0032b0c6, // n0x0197 c0x0000 (---------------)  + I events
	0x00203108, // n0x0198 c0x0000 (---------------)  + I everbank
	0x00379608, // n0x0199 c0x0000 (---------------)  + I exchange
	0x0031f2c6, // n0x019a c0x0000 (---------------)  + I expert
	0x00363887, // n0x019b c0x0000 (---------------)  + I exposed
	0x00246987, // n0x019c c0x0000 (---------------)  + I express
	0x0020a94a, // n0x019d c0x0000 (---------------)  + I extraspace
	0x00292604, // n0x019e c0x0000 (---------------)  + I fage
	0x00214c44, // n0x019f c0x0000 (---------------)  + I fail
	0x0033b5c9, // n0x01a0 c0x0000 (---------------)  + I fairwinds
	0x0034e685, // n0x01a1 c0x0000 (---------------)  + I faith
	0x00207d46, // n0x01a2 c0x0000 (---------------)  + I family
	0x00210883, // n0x01a3 c0x0000 (---------------)  + I fan
	0x002e08c4, // n0x01a4 c0x0000 (---------------)  + I fans
	0x0026a084, // n0x01a5 c0x0000 (---------------)  + I farm
	0x00327f47, // n0x01a6 c0x0000 (---------------)  + I farmers
	0x00230287, // n0x01a7 c0x0000 (---------------)  + I fashion
	0x00246284, // n0x01a8 c0x0000 (---------------)  + I fast
	0x00210085, // n0x01a9 c0x0000 (---------------)  + I fedex
	0x0020cf08, // n0x01aa c0x0000 (---------------)  + I feedback
	0x002ff307, // n0x01ab c0x0000 (---------------)  + I ferrari
	0x003369c7, // n0x01ac c0x0000 (---------------)  + I ferrero
	0x16e01702, // n0x01ad c0x005b (n0x0963-n0x0966)  + I fi
	0x00296004, // n0x01ae c0x0000 (---------------)  + I fiat
	0x0035b608, // n0x01af c0x0000 (---------------)  + I fidelity
	0x0035e584, // n0x01b0 c0x0000 (---------------)  + I fido
	0x0024b184, // n0x01b1 c0x0000 (---------------)  + I film
	0x0024b545, // n0x01b2 c0x0000 (---------------)  + I final
	0x0024b687, // n0x01b3 c0x0000 (---------------)  + I finance
	0x002094c9, // n0x01b4 c0x0000 (---------------)  + I financial
	0x0024c584, // n0x01b5 c0x0000 (---------------)  + I fire
	0x0024d7c9, // n0x01b6 c0x0000 (---------------)  + I firestone
	0x0024dcc8, // n0x01b7 c0x0000 (---------------)  + I firmdale
	0x0024ec04, // n0x01b8 c0x0000 (---------------)  + I fish
	0x0024ec07, // n0x01b9 c0x0000 (---------------)  + I fishing
	0x0024f583, // n0x01ba c0x0000 (---------------)  + I fit
	0x0024fd07, // n0x01bb c0x0000 (---------------)  + I fitness
	0x0161cc42, // n0x01bc c0x0005 (---------------)* o I fj
	0x0179b042, // n0x01bd c0x0005 (---------------)* o I fk
	0x002503c6, // n0x01be c0x0000 (---------------)  + I flickr
	0x00251347, // n0x01bf c0x0000 (---------------)  + I flights
	0x00251c04, // n0x01c0 c0x0000 (---------------)  + I flir
	0x00252ac7, // n0x01c1 c0x0000 (---------------)  + I florist
	0x00254447, // n0x01c2 c0x0000 (---------------)  + I flowers
	0x00254848, // n0x01c3 c0x0000 (---------------)  + I flsmidth
	0x00254ec3, // n0x01c4 c0x0000 (---------------)  + I fly
	0x00234802, // n0x01c5 c0x0000 (---------------)  + I fm
	0x002018c2, // n0x01c6 c0x0000 (---------------)  + I fo
	0x002564c3, // n0x01c7 c0x0000 (---------------)  + I foo
	0x002564cb, // n0x01c8 c0x0000 (---------------)  + I foodnetwork
	0x00307548, // n0x01c9 c0x0000 (---------------)  + I football
	0x0039d384, // n0x01ca c0x0000 (---------------)  + I ford
	0x00257bc5, // n0x01cb c0x0000 (---------------)  + I forex
	0x00259507, // n0x01cc c0x0000 (---------------)  + I forsale
	0x0025aec5, // n0x01cd c0x0000 (---------------)  + I forum
	0x002b9f8a, // n0x01ce c0x0000 (---------------)  + I foundation
	0x0025c543, // n0x01cf c0x0000 (---------------)  + I fox
	0x17240202, // n0x01d0 c0x005c (n0x0966-n0x097e)  + I fr
	0x002e8084, // n0x01d1 c0x0000 (---------------)  + I free
	0x0025dd49, // n0x01d2 c0x0000 (---------------)  + I fresenius
	0x00261a83, // n0x01d3 c0x0000 (---------------)  + I frl
	0x00261b47, // n0x01d4 c0x0000 (---------------)  + I frogans
	0x0039ea49, // n0x01d5 c0x0000 (---------------)  + I frontdoor
	0x00397688, // n0x01d6 c0x0000 (---------------)  + I frontier
	0x00205283, // n0x01d7 c0x0000 (---------------)  + I ftr
	0x0027bdc7, // n0x01d8 c0x0000 (---------------)  + I fujitsu
	0x0027c2c9, // n0x01d9 c0x0000 (---------------)  + I fujixerox
	0x00283e04, // n0x01da c0x0000 (---------------)  + I fund
	0x00284dc9, // n0x01db c0x0000 (---------------)  + I furniture
	0x00289ec6, // n0x01dc c0x0000 (---------------)  + I futbol
	0x0028af83, // n0x01dd c0x0000 (---------------)  + I fyi
	0x00201bc2, // n0x01de c0x0000 (---------------)  + I ga
	0x00221fc3, // n0x01df c0x0000 (---------------)  + I gal
	0x00391707, // n0x01e0 c0x0000 (---------------)  + I gallery
	0x00337785, // n0x01e1 c0x0000 (---------------)  + I gallo
	0x002e3006, // n0x01e2 c0x0000 (---------------)  + I gallup
	0x00298344, // n0x01e3 c0x0000 (---------------)  + I game
	0x00345d85, // n0x01e4 c0x0000 (---------------)  + I games
	0x0023d903, // n0x01e5 c0x0000 (---------------)  + I gap
	0x0021b986, // n0x01e6 c0x0000 (---------------)  + I garden
	0x0020e482, // n0x01e7 c0x0000 (---------------)  + I gb
	0x00385ec4, // n0x01e8 c0x0000 (---------------)  + I gbiz
	0x002265c2, // n0x01e9 c0x0000 (---------------)  + I gd
	0x0022f143, // n0x01ea c0x0000 (---------------)  + I gdn
	0x17600282, // n0x01eb c0x005d (n0x097e-n0x0985)  + I ge
	0x002b6283, // n0x01ec c0x0000 (---------------)  + I gea
	0x00219404, // n0x01ed c0x0000 (---------------)  + I gent
	0x00219407, // n0x01ee c0x0000 (---------------)  + I genting
	0x003233c6, // n0x01ef c0x0000 (---------------)  + I george
	0x0025cb02, // n0x01f0 c0x0000 (---------------)  + I gf
	0x17a01942, // n0x01f1 c0x005e (n0x0985-n0x0988)  + I gg
	0x00331544, // n0x01f2 c0x0000 (---------------)  + I ggee
	0x17e51402, // n0x01f3 c0x005f (n0x0988-n0x098d)  + I gh
	0x18201982, // n0x01f4 c0x0060 (n0x098d-n0x0993)  + I gi
	0x00344944, // n0x01f5 c0x0000 (---------------)  + I gift
	0x00344945, // n0x01f6 c0x0000 (---------------)  + I gifts
	0x00219a45, // n0x01f7 c0x0000 (---------------)  + I gives
	0x0025e606, // n0x01f8 c0x0000 (---------------)  + I giving
	0x18605b82, // n0x01f9 c0x0061 (n0x0993-n0x0998)  + I gl
	0x00320545, // n0x01fa c0x0000 (---------------)  + I glade
	0x00398305, // n0x01fb c0x0000 (---------------)  + I glass
	0x00286b43, // n0x01fc c0x0000 (---------------)  + I gle
	0x0020eac6, // n0x01fd c0x0000 (---------------)  + I global
	0x0020f5c5, // n0x01fe c0x0000 (---------------)  + I globo
	0x00215f82, // n0x01ff c0x0000 (---------------)  + I gm
	0x00336105, // n0x0200 c0x0000 (---------------)  + I gmail
	0x00217783, // n0x0201 c0x0000 (---------------)  + I gmo
	0x00219583, // n0x0202 c0x0000 (---------------)  + I gmx
	0x18a07102, // n0x0203 c0x0062 (n0x0998-n0x099e)  + I gn
	0x002f3307, // n0x0204 c0x0000 (---------------)  + I godaddy
	0x002ff584, // n0x0205 c0x0000 (---------------)  + I gold
	0x002ff589, // n0x0206 c0x0000 (---------------)  + I goldpoint
	0x0024dec4, // n0x0207 c0x0000 (---------------)  + I golf
	0x00283803, // n0x0208 c0x0000 (---------------)  + I goo
	0x002f7e09, // n0x0209 c0x0000 (---------------)  + I goodhands
	0x00283808, // n0x020a c0x0000 (---------------)  + I goodyear
	0x0029c1c4, // n0x020b c0x0000 (---------------)  + I goog
	0x0029c1c6, // n0x020c c0x0000 (---------------)  + I google
	0x002a4d03, // n0x020d c0x0000 (---------------)  + I gop
	0x00210a43, // n0x020e c0x0000 (---------------)  + I got
	0x002dc384, // n0x020f c0x0000 (---------------)  + I gotv
	0x0027d903, // n0x0210 c0x0000 (---------------)  + I gov
	0x18ed5602, // n0x0211 c0x0063 (n0x099e-n0x09a4)  + I gp
	0x003004c2, // n0x0212 c0x0000 (---------------)  + I gq
	0x19208a82, // n0x0213 c0x0064 (n0x09a4-n0x09aa)  + I gr
	0x00317f88, // n0x0214 c0x0000 (---------------)  + I grainger
	0x00311288, // n0x0215 c0x0000 (---------------)  + I graphics
	0x0038ab06, // n0x0216 c0x0000 (---------------)  + I gratis
	0x00252145, // n0x0217 c0x0000 (---------------)  + I green
	0x002287c5, // n0x0218 c0x0000 (---------------)  + I gripe
	0x0020c745, // n0x0219 c0x0000 (---------------)  + I group
	0x00245dc2, // n0x021a c0x0000 (---------------)  + I gs
	0x1963f882, // n0x021b c0x0065 (n0x09aa-n0x09b1)  + I gt
	0x0160efc2, // n0x021c c0x0005 (---------------)* o I gu
	0x0034e808, // n0x021d c0x0000 (---------------)  + I guardian
	0x00234e85, // n0x021e c0x0000 (---------------)  + I gucci
	0x002dffc4, // n0x021f c0x0000 (---------------)  + I guge
	0x0032afc5, // n0x0220 c0x0000 (---------------)  + I guide
	0x0039b7c7, // n0x0221 c0x0000 (---------------)  + I guitars
	0x00253a84, // n0x0222 c0x0000 (---------------)  + I guru
	0x00216342, // n0x0223 c0x0000 (---------------)  + I gw
	0x19a021c2, // n0x0224 c0x0066 (n0x09b1-n0x09b7)  + I gy
	0x0030e604, // n0x0225 c0x0000 (---------------)  + I hair
	0x00205a07, // n0x0226 c0x0000 (---------------)  + I hamburg
	0x00394207, // n0x0227 c0x0000 (---------------)  + I hangout
	0x00360304, // n0x0228 c0x0000 (---------------)  + I haus
	0x00292543, // n0x0229 c0x0000 (---------------)  + I hbo
	0x0024a904, // n0x022a c0x0000 (---------------)  + I hdfc
	0x0024a908, // n0x022b c0x0000 (---------------)  + I hdfcbank
	0x002ae586, // n0x022c c0x0000 (---------------)  + I health
	0x002ae58a, // n0x022d c0x0000 (---------------)  + I healthcare
	0x00209384, // n0x022e c0x0000 (---------------)  + I help
	0x00209bc8, // n0x022f c0x0000 (---------------)  + I helsinki
	0x00254ac4, // n0x0230 c0x0000 (---------------)  + I here
	0x00225986, // n0x0231 c0x0000 (---------------)  + I hermes
	0x002935c4, // n0x0232 c0x0000 (---------------)  + I hgtv
	0x0033f406, // n0x0233 c0x0000 (---------------)  + I hiphop
	0x002f4dc9, // n0x0234 c0x0000 (---------------)  + I hisamitsu
	0x002a3e07, // n0x0235 c0x0000 (---------------)  + I hitachi
	0x00287fc3, // n0x0236 c0x0000 (---------------)  + I hiv
	0x19e0c482, // n0x0237 c0x0067 (n0x09b7-n0x09cf)  + I hk
	0x0026f043, // n0x0238 c0x0000 (---------------)  + I hkt
	0x0020fbc2, // n0x0239 c0x0000 (---------------)  + I hm
	0x1a21c682, // n0x023a c0x0068 (n0x09cf-n0x09d5)  + I hn
	0x002df346, // n0x023b c0x0000 (---------------)  + I hockey
	0x0035d808, // n0x023c c0x0000 (---------------)  + I holdings
	0x002a6647, // n0x023d c0x0000 (---------------)  + I holiday
	0x00273d09, // n0x023e c0x0000 (---------------)  + I homedepot
	0x00299fc9, // n0x023f c0x0000 (---------------)  + I homegoods
	0x002a7245, // n0x0240 c0x0000 (---------------)  + I homes
	0x002a7249, // n0x0241 c0x0000 (---------------)  + I homesense
	0x002a8805, // n0x0242 c0x0000 (---------------)  + I honda
	0x002a9289, // n0x0243 c0x0000 (---------------)  + I honeywell
	0x002aa045, // n0x0244 c0x0000 (---------------)  + I horse
	0x00298484, // n0x0245 c0x0000 (---------------)  + I host
	0x00298487, // n0x0246 c0x0000 (---------------)  + I hosting
	0x00234303, // n0x0247 c0x0000 (---------------)  + I hot
	0x002aab07, // n0x0248 c0x0000 (---------------)  + I hoteles
	0x002ab0c7, // n0x0249 c0x0000 (---------------)  + I hotmail
	0x002a3745, // n0x024a c0x0000 (---------------)  + I house
	0x002a2ac3, // n0x024b c0x0000 (---------------)  + I how
	0x1a60f742, // n0x024c c0x0069 (n0x09d5-n0x09da)  + I hr
	0x00387984, // n0x024d c0x0000 (---------------)  + I hsbc
	0x1aa51442, // n0x024e c0x006a (n0x09da-n0x09eb)  + I ht
	0x0025cc83, // n0x024f c0x0000 (---------------)  + I htc
	0x1ae24202, // n0x0250 c0x006b (n0x09eb-n0x0a0b)  + I hu
	0x002f8486, // n0x0251 c0x0000 (---------------)  + I hughes
	0x00309285, // n0x0252 c0x0000 (---------------)  + I hyatt
	0x002ad907, // n0x0253 c0x0000 (---------------)  + I hyundai
	0x00311ac3, // n0x0254 c0x0000 (---------------)  + I ibm
	0x00379c44, // n0x0255 c0x0000 (---------------)  + I icbc
	0x00205c83, // n0x0256 c0x0000 (---------------)  + I ice
	0x00208b03, // n0x0257 c0x0000 (---------------)  + I icu
	0x1b20d9c2, // n0x0258 c0x006c (n0x0a0b-n0x0a16)  + I id
	0x1ba00042, // n0x0259 c0x006e (n0x0a17-n0x0a19)  + I ie
	0x00366044, // n0x025a c0x0000 (---------------)  + I ieee
	0x002347c3, // n0x025b c0x0000 (---------------)  + I ifm
	0x003124c5, // n0x025c c0x0000 (---------------)  + I iinet
	0x00312305, // n0x025d c0x0000 (---------------)  + I ikano
	0x1be027c2, // n0x025e c0x006f (n0x0a19-n0x0a21)  + I il
	0x1c600402, // n0x025f c0x0071 (n0x0a22-n0x0a29)  + I im
	0x0024bd46, // n0x0260 c0x0000 (---------------)  + I imamat
	0x0026b844, // n0x0261 c0x0000 (---------------)  + I imdb
	0x0020be84, // n0x0262 c0x0000 (---------------)  + I immo
	0x0020be8a, // n0x0263 c0x0000 (---------------)  + I immobilien
	0x1ce012c2, // n0x0264 c0x0073 (n0x0a2b-n0x0a38)  + I in
	0x003673ca, // n0x0265 c0x0000 (---------------)  + I industries
	0x00201688, // n0x0266 c0x0000 (---------------)  + I infiniti
	0x1d201844, // n0x0267 c0x0074 (n0x0a38-n0x0a42)  + I info
	0x0020f543, // n0x0268 c0x0000 (---------------)  + I ing
	0x00209cc3, // n0x0269 c0x0000 (---------------)  + I ink
	0x00310949, // n0x026a c0x0000 (---------------)  + I institute
	0x00263309, // n0x026b c0x0000 (---------------)  + I insurance
	0x003012c6, // n0x026c c0x0000 (---------------)  + I insure
	0x1d601503, // n0x026d c0x0075 (n0x0a42-n0x0a43)  + I int
	0x002ff705, // n0x026e c0x0000 (---------------)  + I intel
	0x0031ba8d, // n0x026f c0x0000 (---------------)  + I international
	0x002f7846, // n0x0270 c0x0000 (---------------)  + I intuit
	0x0020980b, // n0x0271 c0x0000 (---------------)  + I investments
	0x1da03a02, // n0x0272 c0x0076 (n0x0a43-n0x0a49)  + I io
	0x0025acc8, // n0x0273 c0x0000 (---------------)  + I ipiranga
	0x1de1d942, // n0x0274 c0x0077 (n0x0a49-n0x0a4f)  + I iq
	0x1e204b02, // n0x0275 c0x0078 (n0x0a4f-n0x0a58)  + I ir
	0x0029b805, // n0x0276 c0x0000 (---------------)  + I irish
	0x1e604e82, // n0x0277 c0x0079 (n0x0a58-n0x0a60)  + I is
	0x0025b147, // n0x0278 c0x0000 (---------------)  + I iselect
	0x0027b3c7, // n0x0279 c0x0000 (---------------)  + I ismaili
	0x00215a03, // n0x027a c0x0000 (---------------)  + I ist
	0x00215a08, // n0x027b c0x0000 (---------------)  + I istanbul
	0x1ea017c2, // n0x027c c0x007a (n0x0a60-n0x0bd1)  + I it
	0x0027ea04, // n0x027d c0x0000 (---------------)  + I itau
	0x00360d43, // n0x027e c0x0000 (---------------)  + I itv
	0x00323805, // n0x027f c0x0000 (---------------)  + I iveco
	0x00368243, // n0x0280 c0x0000 (---------------)  + I iwc
	0x00308d46, // n0x0281 c0x0000 (---------------)  + I jaguar
	0x003225c4, // n0x0282 c0x0000 (---------------)  + I java
	0x00246c43, // n0x0283 c0x0000 (---------------)  + I jcb
	0x0026f783, // n0x0284 c0x0000 (---------------)  + I jcp
	0x1ee0bd02, // n0x0285 c0x007b (n0x0bd1-n0x0bd4)  + I je
	0x00335a04, // n0x0286 c0x0000 (---------------)  + I jeep
	0x0034cbc5, // n0x0287 c0x0000 (---------------)  + I jetzt
	0x00361547, // n0x0288 c0x0000 (---------------)  + I jewelry
	0x00278b43, // n0x0289 c0x0000 (---------------)  + I jio
	0x002add83, // n0x028a c0x0000 (---------------)  + I jlc
	0x002aee43, // n0x028b c0x0000 (---------------)  + I jll
	0x0167db82, // n0x028c c0x0005 (---------------)* o I jm
	0x002aef03, // n0x028d c0x0000 (---------------)  + I jmp
	0x002af503, // n0x028e c0x0000 (---------------)  + I jnj
	0x1f2010c2, // n0x028f c0x007c (n0x0bd4-n0x0bdc)  + I jo
	0x002e35c4, // n0x0290 c0x0000 (---------------)  + I jobs
	0x0027d046, // n0x0291 c0x0000 (---------------)  + I joburg
	0x002010c3, // n0x0292 c0x0000 (---------------)  + I jot
	0x002af883, // n0x0293 c0x0000 (---------------)  + I joy
	0x1f6b00c2, // n0x0294 c0x007d (n0x0bdc-n0x0c4b)  + I jp
	0x002b00c8, // n0x0295 c0x0000 (---------------)  + I jpmorgan
	0x002b1304, // n0x0296 c0x0000 (---------------)  + I jprs
	0x0024e0c6, // n0x0297 c0x0000 (---------------)  + I juegos
	0x002b17c7, // n0x0298 c0x0000 (---------------)  + I juniper
	0x00222e46, // n0x0299 c0x0000 (---------------)  + I kaufen
	0x003782c4, // n0x029a c0x0000 (---------------)  + I kddi
	0x2d202482, // n0x029b c0x00b4 (n0x12df-n0x12e0)* o I ke
	0x002341cb, // n0x029c c0x0000 (---------------)  + I kerryhotels
	0x002e270e, // n0x029d c0x0000 (---------------)  + I kerrylogistics
	0x002249cf, // n0x029e c0x0000 (---------------)  + I kerryproperties
	0x002337c3, // n0x029f c0x0000 (---------------)  + I kfh
	0x2dab7202, // n0x02a0 c0x00b6 (n0x12e1-n0x12e7)  + I kg
	0x0161c802, // n0x02a1 c0x0005 (---------------)* o I kh
	0x2de02982, // n0x02a2 c0x00b7 (n0x12e7-n0x12ee)  + I ki
	0x002257c3, // n0x02a3 c0x0000 (---------------)  + I kia
	0x0023a7c3, // n0x02a4 c0x0000 (---------------)  + I kim
	0x0037cbc6, // n0x02a5 c0x0000 (---------------)  + I kinder
	0x0023ea06, // n0x02a6 c0x0000 (---------------)  + I kindle
	0x00346087, // n0x02a7 c0x0000 (---------------)  + I kitchen
	0x002ea604, // n0x02a8 c0x0000 (---------------)  + I kiwi
	0x2e238982, // n0x02a9 c0x00b8 (n0x12ee-n0x12ff)  + I km
	0x2e63dd02, // n0x02aa c0x00b9 (n0x12ff-n0x1303)  + I kn
	0x002291c5, // n0x02ab c0x0000 (---------------)  + I koeln
	0x002ab807, // n0x02ac c0x0000 (---------------)  + I komatsu
	0x002eb806, // n0x02ad c0x0000 (---------------)  + I kosher
	0x2ea0ea02, // n0x02ae c0x00ba (n0x1303-n0x1309)  + I kp
	0x0020ea04, // n0x02af c0x0000 (---------------)  + I kpmg
	0x0036ab43, // n0x02b0 c0x0000 (---------------)  + I kpn
	0x2ee0bdc2, // n0x02b1 c0x00bb (n0x1309-n0x1327)  + I kr
	0x0034c043, // n0x02b2 c0x0000 (---------------)  + I krd
	0x003a1444, // n0x02b3 c0x0000 (---------------)  + I kred
	0x002b7149, // n0x02b4 c0x0000 (---------------)  + I kuokgroup
	0x016bf3c2, // n0x02b5 c0x0005 (---------------)* o I kw
	0x2f236f82, // n0x02b6 c0x00bc (n0x1327-n0x132c)  + I ky
	0x00268246, // n0x02b7 c0x0000 (---------------)  + I kyknet
	0x002c0005, // n0x02b8 c0x0000 (---------------)  + I kyoto
	0x2f792002, // n0x02b9 c0x00bd (n0x132c-n0x1332)  + I kz
	0x2fa03082, // n0x02ba c0x00be (n0x1332-n0x133b)  + I la
	0x0033a687, // n0x02bb c0x0000 (---------------)  + I lacaixa
	0x00294d09, // n0x02bc c0x0000 (---------------)  + I ladbrokes
	0x0034ff8b, // n0x02bd c0x0000 (---------------)  + I lamborghini
	0x00246745, // n0x02be c0x0000 (---------------)  + I lamer
	0x0036b6c9, // n0x02bf c0x0000 (---------------)  + I lancaster
	0x002c1d86, // n0x02c0 c0x0000 (---------------)  + I lancia
	0x00259047, // n0x02c1 c0x0000 (---------------)  + I lancome
	0x00213144, // n0x02c2 c0x0000 (---------------)  + I land
	0x0026aa89, // n0x02c3 c0x0000 (---------------)  + I landrover
	0x00358e47, // n0x02c4 c0x0000 (---------------)  + I lanxess
	0x00279d47, // n0x02c5 c0x0000 (---------------)  + I lasalle
	0x00226e83, // n0x02c6 c0x0000 (---------------)  + I lat
	0x0026b986, // n0x02c7 c0x0000 (---------------)  + I latino
	0x002ce147, // n0x02c8 c0x0000 (---------------)  + I latrobe
	0x00271c03, // n0x02c9 c0x0000 (---------------)  + I law
	0x00271c06, // n0x02ca c0x0000 (---------------)  + I lawyer
	0x2fe02802, // n0x02cb c0x00bf (n0x133b-n0x1340)  + I lb
	0x30239382, // n0x02cc c0x00c0 (n0x1340-n0x1346)  + I lc
	0x0023e683, // n0x02cd c0x0000 (---------------)  + I lds
	0x00279e85, // n0x02ce c0x0000 (---------------)  + I lease
	0x002b8607, // n0x02cf c0x0000 (---------------)  + I leclerc
	0x00356c06, // n0x02d0 c0x0000 (---------------)  + I lefrak
	0x00337705, // n0x02d1 c0x0000 (---------------)  + I legal
	0x0024de44, // n0x02d2 c0x0000 (---------------)  + I lego
	0x002de845, // n0x02d3 c0x0000 (---------------)  + I lexus
	0x002e7384, // n0x02d4 c0x0000 (---------------)  + I lgbt
	0x30605bc2, // n0x02d5 c0x00c1 (n0x1346-n0x1347)  + I li
	0x0030b0c7, // n0x02d6 c0x0000 (---------------)  + I liaison
	0x002bdb44, // n0x02d7 c0x0000 (---------------)  + I lidl
	0x00263204, // n0x02d8 c0x0000 (---------------)  + I life
	0x0026320d, // n0x02d9 c0x0000 (---------------)  + I lifeinsurance
	0x0035f409, // n0x02da c0x0000 (---------------)  + I lifestyle
	0x00288c08, // n0x02db c0x0000 (---------------)  + I lighting
	0x00258c84, // n0x02dc c0x0000 (---------------)  + I like
	0x00354b85, // n0x02dd c0x0000 (---------------)  + I lilly
	0x0025d307, // n0x02de c0x0000 (---------------)  + I limited
	0x0025d704, // n0x02df c0x0000 (---------------)  + I limo
	0x0022fcc7, // n0x02e0 c0x0000 (---------------)  + I lincoln
	0x00320185, // n0x02e1 c0x0000 (---------------)  + I linde
	0x0038e084, // n0x02e2 c0x0000 (---------------)  + I link
	0x002d50c5, // n0x02e3 c0x0000 (---------------)  + I lipsy
	0x00260744, // n0x02e4 c0x0000 (---------------)  + I live
	0x002de986, // n0x02e5 c0x0000 (---------------)  + I living
	0x0025d605, // n0x02e6 c0x0000 (---------------)  + I lixil
	0x30a0e9c2, // n0x02e7 c0x00c2 (n0x1347-n0x1356)  + I lk
	0x00213a44, // n0x02e8 c0x0000 (---------------)  + I loan
	0x00213a45, // n0x02e9 c0x0000 (---------------)  + I loans
	0x00375d86, // n0x02ea c0x0000 (---------------)  + I locker
	0x00337845, // n0x02eb c0x0000 (---------------)  + I locus
	0x002d2244, // n0x02ec c0x0000 (---------------)  + I loft
	0x002c3f43, // n0x02ed c0x0000 (---------------)  + I lol
	0x003114c6, // n0x02ee c0x0000 (---------------)  + I london
	0x00224e05, // n0x02ef c0x0000 (---------------)  + I lotte
	0x002260c5, // n0x02f0 c0x0000 (---------------)  + I lotto
	0x0023df44, // n0x02f1 c0x0000 (---------------)  + I love
	0x00209403, // n0x02f2 c0x0000 (---------------)  + I lpl
	0x0020940c, // n0x02f3 c0x0000 (---------------)  + I lplfinancial
	0x30e8a802, // n0x02f4 c0x00c3 (n0x1356-n0x135b)  + I lr
	0x31205642, // n0x02f5 c0x00c4 (n0x135b-n0x135d)  + I ls
	0x31608bc2, // n0x02f6 c0x00c5 (n0x135d-n0x135f)  + I lt
	0x00312883, // n0x02f7 c0x0000 (---------------)  + I ltd
	0x00312884, // n0x02f8 c0x0000 (---------------)  + I ltda
	0x31a03842, // n0x02f9 c0x00c6 (n0x135f-n0x1360)  + I lu
	0x002e2ac8, // n0x02fa c0x0000 (---------------)  + I lundbeck
	0x002e30c5, // n0x02fb c0x0000 (---------------)  + I lupin
	0x00235544, // n0x02fc c0x0000 (---------------)  + I luxe
	0x00238646, // n0x02fd c0x0000 (---------------)  + I luxury
	0x31e06582, // n0x02fe c0x00c7 (n0x1360-n0x1369)  + I lv
	0x32207e42, // n0x02ff c0x00c8 (n0x1369-n0x1372)  + I ly
	0x32600442, // n0x0300 c0x00c9 (n0x1372-n0x1378)  + I ma
	0x00373685, // n0x0301 c0x0000 (---------------)  + I macys
	0x003197c6, // n0x0302 c0x0000 (---------------)  + I madrid
	0x00269fc4, // n0x0303 c0x0000 (---------------)  + I maif
	0x002b7f46, // n0x0304 c0x0000 (---------------)  + I maison
	0x00248206, // n0x0305 c0x0000 (---------------)  + I makeup
	0x00204283, // n0x0306 c0x0000 (---------------)  + I man
	0x0036df4a, // n0x0307 c0x0000 (---------------)  + I management
	0x0023b305, // n0x0308 c0x0000 (---------------)  + I mango
	0x0022b8c6, // n0x0309 c0x0000 (---------------)  + I market
	0x002ec909, // n0x030a c0x0000 (---------------)  + I marketing
	0x0022b8c7, // n0x030b c0x0000 (---------------)  + I markets
	0x00245948, // n0x030c c0x0000 (---------------)  + I marriott
	0x0020a009, // n0x030d c0x0000 (---------------)  + I marshalls
	0x002bbd48, // n0x030e c0x0000 (---------------)  + I maserati
	0x0022dcc6, // n0x030f c0x0000 (---------------)  + I mattel
	0x002089c3, // n0x0310 c0x0000 (---------------)  + I mba
	0x32a1a3c2, // n0x0311 c0x00ca (n0x1378-n0x137a)  + I mc
	0x0037c0c3, // n0x0312 c0x0000 (---------------)  + I mcd
	0x0037c0c9, // n0x0313 c0x0000 (---------------)  + I mcdonalds
	0x00325988, // n0x0314 c0x0000 (---------------)  + I mckinsey
	0x32e4dd82, // n0x0315 c0x00cb (n0x137a-n0x137b)  + I md
	0x33200982, // n0x0316 c0x00cc (n0x137b-n0x1388)  + I me
	0x00213443, // n0x0317 c0x0000 (---------------)  + I med
	0x00303545, // n0x0318 c0x0000 (---------------)  + I media
	0x00269484, // n0x0319 c0x0000 (---------------)  + I meet
	0x002e1389, // n0x031a c0x0000 (---------------)  + I melbourne
	0x002b4304, // n0x031b c0x0000 (---------------)  + I meme
	0x0036e248, // n0x031c c0x0000 (---------------)  + I memorial
	0x00209983, // n0x031d c0x0000 (---------------)  + I men
	0x003295c4, // n0x031e c0x0000 (---------------)  + I menu
	0x0021a583, // n0x031f c0x0000 (---------------)  + I meo
	0x00263147, // n0x0320 c0x0000 (---------------)  + I metlife
	0x3360ea82, // n0x0321 c0x00cd (n0x1388-n0x1391)  + I mg
	0x0025a7c2, // n0x0322 c0x0000 (---------------)  + I mh
	0x00231bc5, // n0x0323 c0x0000 (---------------)  + I miami
	0x00269849, // n0x0324 c0x0000 (---------------)  + I microsoft
	0x00207dc3, // n0x0325 c0x0000 (---------------)  + I mil
	0x0027d684, // n0x0326 c0x0000 (---------------)  + I mini
	0x0031ba44, // n0x0327 c0x0000 (---------------)  + I mint
	0x0023e183, // n0x0328 c0x0000 (---------------)  + I mit
	0x0027ee0a, // n0x0329 c0x0000 (---------------)  + I mitsubishi
	0x33b67282, // n0x032a c0x00ce (n0x1391-n0x1399)  + I mk
	0x33e13a02, // n0x032b c0x00cf (n0x1399-n0x13a0)  + I ml
	0x002c2fc3, // n0x032c c0x0000 (---------------)  + I mlb
	0x00369c83, // n0x032d c0x0000 (---------------)  + I mls
	0x0160bec2, // n0x032e c0x0005 (---------------)* o I mm
	0x00374a83, // n0x032f c0x0000 (---------------)  + I mma
	0x34223b02, // n0x0330 c0x00d0 (n0x13a0-n0x13a4)  + I mn
	0x00223b04, // n0x0331 c0x0000 (---------------)  + I mnet
	0x34608442, // n0x0332 c0x00d1 (n0x13a4-n0x13a9)  + I mo
	0x34a0bf04, // n0x0333 c0x00d2 (n0x13a9-n0x13aa)  + I mobi
	0x002d7b86, // n0x0334 c0x0000 (---------------)  + I mobily
	0x0026d444, // n0x0335 c0x0000 (---------------)  + I moda
	0x0024e4c3, // n0x0336 c0x0000 (---------------)  + I moe
	0x00282a43, // n0x0337 c0x0000 (---------------)  + I moi
	0x002e4483, // n0x0338 c0x0000 (---------------)  + I mom
	0x00243d86, // n0x0339 c0x0000 (---------------)  + I monash
	0x002c8705, // n0x033a c0x0000 (---------------)  + I money
	0x002c3b87, // n0x033b c0x0000 (---------------)  + I monster
	0x00258f09, // n0x033c c0x0000 (---------------)  + I montblanc
	0x002c6c05, // n0x033d c0x0000 (---------------)  + I mopar
	0x002c8646, // n0x033e c0x0000 (---------------)  + I mormon
	0x002c8c48, // n0x033f c0x0000 (---------------)  + I mortgage
	0x002c8e46, // n0x0340 c0x0000 (---------------)  + I moscow
	0x00278444, // n0x0341 c0x0000 (---------------)  + I moto
	0x0029b44b, // n0x0342 c0x0000 (---------------)  + I motorcycles
	0x002ca883, // n0x0343 c0x0000 (---------------)  + I mov
	0x002ca885, // n0x0344 c0x0000 (---------------)  + I movie
	0x002ca9c8, // n0x0345 c0x0000 (---------------)  + I movistar
	0x0022c182, // n0x0346 c0x0000 (---------------)  + I mp
	0x0033a982, // n0x0347 c0x0000 (---------------)  + I mq
	0x34e4a142, // n0x0348 c0x00d3 (n0x13aa-n0x13ac)  + I mr
	0x35210f42, // n0x0349 c0x00d4 (n0x13ac-n0x13b1)  + I ms
	0x0025d203, // n0x034a c0x0000 (---------------)  + I msd
	0x35605402, // n0x034b c0x00d5 (n0x13b1-n0x13b5)  + I mt
	0x0026db43, // n0x034c c0x0000 (---------------)  + I mtn
	0x002cacc4, // n0x034d c0x0000 (---------------)  + I mtpc
	0x002cb483, // n0x034e c0x0000 (---------------)  + I mtr
	0x35e03f02, // n0x034f c0x00d7 (n0x13b6-n0x13bd)  + I mu
	0x002cd0cb, // n0x0350 c0x0000 (---------------)  + I multichoice
	0x362d1086, // n0x0351 c0x00d8 (n0x13bd-n0x15e1)  + I museum
	0x0023c806, // n0x0352 c0x0000 (---------------)  + I mutual
	0x002d16c8, // n0x0353 c0x0000 (---------------)  + I mutuelle
	0x366bf742, // n0x0354 c0x00d9 (n0x15e1-n0x15ef)  + I mv
	0x36a12002, // n0x0355 c0x00da (n0x15ef-n0x15fa)  + I mw
	0x36e195c2, // n0x0356 c0x00db (n0x15fa-n0x1600)  + I mx
	0x37225742, // n0x0357 c0x00dc (n0x1600-n0x1608)  + I my
	0x37614d82, // n0x0358 c0x00dd (n0x1608-n0x1609)* o I mz
	0x00214d8b, // n0x0359 c0x0000 (---------------)  + I mzansimagic
	0x37a00902, // n0x035a c0x00de (n0x1609-n0x161a)  + I na
	0x0021ac43, // n0x035b c0x0000 (---------------)  + I nab
	0x00379545, // n0x035c c0x0000 (---------------)  + I nadex
	0x00255a46, // n0x035d c0x0000 (---------------)  + I nagoya
	0x37e00904, // n0x035e c0x00df (n0x161a-n0x161c)  + I name
	0x0033ca07, // n0x035f c0x0000 (---------------)  + I naspers
	0x00378fca, // n0x0360 c0x0000 (---------------)  + I nationwide
	0x002dcac6, // n0x0361 c0x0000 (---------------)  + I natura
	0x00398f44, // n0x0362 c0x0000 (---------------)  + I navy
	0x0025ce03, // n0x0363 c0x0000 (---------------)  + I nba
	0x38a095c2, // n0x0364 c0x00e2 (n0x161e-n0x161f)  + I nc
	0x00202ac2, // n0x0365 c0x0000 (---------------)  + I ne
	0x0022af03, // n0x0366 c0x0000 (---------------)  + I nec
	0x38e23b43, // n0x0367 c0x00e3 (n0x161f-n0x1654)  + I net
	0x00391e87, // n0x0368 c0x0000 (---------------)  + I netbank
	0x0025d507, // n0x0369 c0x0000 (---------------)  + I netflix
	0x002565c7, // n0x036a c0x0000 (---------------)  + I network
	0x0022a247, // n0x036b c0x0000 (---------------)  + I neustar
	0x0021e603, // n0x036c c0x0000 (---------------)  + I new
	0x002ec30a, // n0x036d c0x0000 (---------------)  + I newholland
	0x0021e604, // n0x036e c0x0000 (---------------)  + I news
	0x0024d984, // n0x036f c0x0000 (---------------)  + I next
	0x0024d98a, // n0x0370 c0x0000 (---------------)  + I nextdirect
	0x0026ec05, // n0x0371 c0x0000 (---------------)  + I nexus
	0x3a2016c2, // n0x0372 c0x00e8 (n0x165c-n0x1666)  + I nf
	0x00252243, // n0x0373 c0x0000 (---------------)  + I nfl
	0x3a6026c2, // n0x0374 c0x00e9 (n0x1666-n0x1670)  + I ng
	0x0023b383, // n0x0375 c0x0000 (---------------)  + I ngo
	0x0026f003, // n0x0376 c0x0000 (---------------)  + I nhk
	0x3ae01782, // n0x0377 c0x00eb (n0x1671-n0x167f)  o I ni
	0x002a7c84, // n0x0378 c0x0000 (---------------)  + I nico
	0x00221d04, // n0x0379 c0x0000 (---------------)  + I nike
	0x00203a85, // n0x037a c0x0000 (---------------)  + I nikon
	0x002ca605, // n0x037b c0x0000 (---------------)  + I ninja
	0x002292c6, // n0x037c c0x0000 (---------------)  + I nissan
	0x0022d246, // n0x037d c0x0000 (---------------)  + I nissay
	0x3b246d02, // n0x037e c0x00ec (n0x167f-n0x1682)  + I nl
	0x3b601382, // n0x037f c0x00ed (n0x1682-n0x1958)  + I no
	0x0031ae05, // n0x0380 c0x0000 (---------------)  + I nokia
	0x0023c512, // n0x0381 c0x0000 (---------------)  + I northwesternmutual
	0x0035eb06, // n0x0382 c0x0000 (---------------)  + I norton
	0x00220303, // n0x0383 c0x0000 (---------------)  + I now
	0x0029e646, // n0x0384 c0x0000 (---------------)  + I nowruz
	0x00220305, // n0x0385 c0x0000 (---------------)  + I nowtv
	0x01612182, // n0x0386 c0x0005 (---------------)* o I np
	0x43a0e602, // n0x0387 c0x010e (n0x1980-n0x1987)  + I nr
	0x002d6d03, // n0x0388 c0x0000 (---------------)  + I nra
	0x0026e2c3, // n0x0389 c0x0000 (---------------)  + I nrw
	0x00372083, // n0x038a c0x0000 (---------------)  + I ntt
	0x43e04182, // n0x038b c0x010f (n0x1987-n0x198a)  + I nu
	0x0036dcc3, // n0x038c c0x0000 (---------------)  + I nyc
	0x44208282, // n0x038d c0x0110 (n0x198a-n0x199a)  + I nz
	0x0020bf43, // n0x038e c0x0000 (---------------)  + I obi
	0x002e3608, // n0x038f c0x0000 (---------------)  + I observer
	0x0020ce83, // n0x0390 c0x0000 (---------------)  + I off
	0x0021dec6, // n0x0391 c0x0000 (---------------)  + I office
	0x00395107, // n0x0392 c0x0000 (---------------)  + I okinawa
	0x0020c5c6, // n0x0393 c0x0000 (---------------)  + I olayan
	0x0020c5cb, // n0x0394 c0x0000 (---------------)  + I olayangroup
	0x00398e87, // n0x0395 c0x0000 (---------------)  + I oldnavy
	0x00387784, // n0x0396 c0x0000 (---------------)  + I ollo
	0x44a013c2, // n0x0397 c0x0112 (n0x199b-n0x19a4)  + I om
	0x002e2f45, // n0x0398 c0x0000 (---------------)  + I omega
	0x00215243, // n0x0399 c0x0000 (---------------)  + I one
	0x00207083, // n0x039a c0x0000 (---------------)  + I ong
	0x00319c43, // n0x039b c0x0000 (---------------)  + I onl
	0x00319c46, // n0x039c c0x0000 (---------------)  + I online
	0x0039944a, // n0x039d c0x0000 (---------------)  + I onyourside
	0x0028f983, // n0x039e c0x0000 (---------------)  + I ooo
	0x0023cb04, // n0x039f c0x0000 (---------------)  + I open
	0x00227a86, // n0x03a0 c0x0000 (---------------)  + I oracle
	0x00395846, // n0x03a1 c0x0000 (---------------)  + I orange
	0x44e28743, // n0x03a2 c0x0113 (n0x19a4-n0x19e1)  + I org
	0x002b0187, // n0x03a3 c0x0000 (---------------)  + I organic
	0x002d994d, // n0x03a4 c0x0000 (---------------)  + I orientexpress
	0x00381387, // n0x03a5 c0x0000 (---------------)  + I origins
	0x0029b185, // n0x03a6 c0x0000 (---------------)  + I osaka
	0x00268446, // n0x03a7 c0x0000 (---------------)  + I otsuka
	0x00224e43, // n0x03a8 c0x0000 (---------------)  + I ott
	0x0020ed03, // n0x03a9 c0x0000 (---------------)  + I ovh
	0x4660aac2, // n0x03aa c0x0119 (n0x1a1e-n0x1a29)  + I pa
	0x00326904, // n0x03ab c0x0000 (---------------)  + I page
	0x0024c80c, // n0x03ac c0x0000 (---------------)  + I pamperedchef
	0x00262c09, // n0x03ad c0x0000 (---------------)  + I panasonic
	0x00338487, // n0x03ae c0x0000 (---------------)  + I panerai
	0x00277705, // n0x03af c0x0000 (---------------)  + I paris
	0x0029d144, // n0x03b0 c0x0000 (---------------)  + I pars
	0x002a6948, // n0x03b1 c0x0000 (---------------)  + I partners
	0x002aef85, // n0x03b2 c0x0000 (---------------)  + I parts
	0x002b6945, // n0x03b3 c0x0000 (---------------)  + I party
	0x002cdb09, // n0x03b4 c0x0000 (---------------)  + I passagens
	0x002be303, // n0x03b5 c0x0000 (---------------)  + I pay
	0x002be304, // n0x03b6 c0x0000 (---------------)  + I payu
	0x002cad44, // n0x03b7 c0x0000 (---------------)  + I pccw
	0x46a00582, // n0x03b8 c0x011a (n0x1a29-n0x1a31)  + I pe
	0x00211cc3, // n0x03b9 c0x0000 (---------------)  + I pet
	0x46ef6c02, // n0x03ba c0x011b (n0x1a31-n0x1a34)  + I pf
	0x002f6c06, // n0x03bb c0x0000 (---------------)  + I pfizer
	0x01648ac2, // n0x03bc c0x0005 (---------------)* o I pg
	0x4729cd02, // n0x03bd c0x011c (n0x1a34-n0x1a3c)  + I ph
	0x00373588, // n0x03be c0x0000 (---------------)  + I pharmacy
	0x002d5007, // n0x03bf c0x0000 (---------------)  + I philips
	0x0029cd05, // n0x03c0 c0x0000 (---------------)  + I photo
	0x002d564b, // n0x03c1 c0x0000 (---------------)  + I photography
	0x002d2806, // n0x03c2 c0x0000 (---------------)  + I photos
	0x002d5846, // n0x03c3 c0x0000 (---------------)  + I physio
	0x002d59c6, // n0x03c4 c0x0000 (---------------)  + I piaget
	0x00221604, // n0x03c5 c0x0000 (---------------)  + I pics
	0x002d6146, // n0x03c6 c0x0000 (---------------)  + I pictet
	0x002d6648, // n0x03c7 c0x0000 (---------------)  + I pictures
	0x00241c83, // n0x03c8 c0x0000 (---------------)  + I pid
	0x00219f83, // n0x03c9 c0x0000 (---------------)  + I pin
	0x00219f84, // n0x03ca c0x0000 (---------------)  + I ping
	0x002d6dc4, // n0x03cb c0x0000 (---------------)  + I pink
	0x002d7407, // n0x03cc c0x0000 (---------------)  + I pioneer
	0x002d7e85, // n0x03cd c0x0000 (---------------)  + I pizza
	0x476d7fc2, // n0x03ce c0x011d (n0x1a3c-n0x1a4a)  + I pk
	0x47a09442, // n0x03cf c0x011e (n0x1a4a-n0x1aef)  + I pl
	0x0020b305, // n0x03d0 c0x0000 (---------------)  + I place
	0x002a00c4, // n0x03d1 c0x0000 (---------------)  + I play
	0x002d92cb, // n0x03d2 c0x0000 (---------------)  + I playstation
	0x002dc1c8, // n0x03d3 c0x0000 (---------------)  + I plumbing
	0x002dd404, // n0x03d4 c0x0000 (---------------)  + I plus
	0x0020ea42, // n0x03d5 c0x0000 (---------------)  + I pm
	0x482488c2, // n0x03d6 c0x0120 (n0x1b1e-n0x1b23)  + I pn
	0x002b0ac3, // n0x03d7 c0x0000 (---------------)  + I pnc
	0x002dd844, // n0x03d8 c0x0000 (---------------)  + I pohl
	0x002dd945, // n0x03d9 c0x0000 (---------------)  + I poker
	0x002dde87, // n0x03da c0x0000 (---------------)  + I politie
	0x002dfb04, // n0x03db c0x0000 (---------------)  + I porn
	0x00360404, // n0x03dc c0x0000 (---------------)  + I post
	0x48604e02, // n0x03dd c0x0121 (n0x1b23-n0x1b30)  + I pr
	0x00358049, // n0x03de c0x0000 (---------------)  + I pramerica
	0x002e0505, // n0x03df c0x0000 (---------------)  + I praxi
	0x00246a05, // n0x03e0 c0x0000 (---------------)  + I press
	0x002e12c5, // n0x03e1 c0x0000 (---------------)  + I prime
	0x48a24b03, // n0x03e2 c0x0122 (n0x1b30-n0x1b37)  + I pro
	0x002e1bc4, // n0x03e3 c0x0000 (---------------)  + I prod
	0x002e1bcb, // n0x03e4 c0x0000 (---------------)  + I productions
	0x002e2004, // n0x03e5 c0x0000 (---------------)  + I prof
	0x002e228b, // n0x03e6 c0x0000 (---------------)  + I progressive
	0x002e43c5, // n0x03e7 c0x0000 (---------------)  + I promo
	0x00224b0a, // n0x03e8 c0x0000 (---------------)  + I properties
	0x002e4bc8, // n0x03e9 c0x0000 (---------------)  + I property
	0x002e4dca, // n0x03ea c0x0000 (---------------)  + I protection
	0x002e5043, // n0x03eb c0x0000 (---------------)  + I pru
	0x002e504a, // n0x03ec c0x0000 (---------------)  + I prudential
	0x48e08102, // n0x03ed c0x0123 (n0x1b37-n0x1b3e)  + I ps
	0x492d3242, // n0x03ee c0x0124 (n0x1b3e-n0x1b47)  + I pt
	0x0028f343, // n0x03ef c0x0000 (---------------)  + I pub
	0x496e6702, // n0x03f0 c0x0125 (n0x1b47-n0x1b4d)  + I pw
	0x002e6703, // n0x03f1 c0x0000 (---------------)  + I pwc
	0x49b32942, // n0x03f2 c0x0126 (n0x1b4d-n0x1b54)  + I py
	0x49f16bc2, // n0x03f3 c0x0127 (n0x1b54-n0x1b5d)  + I qa
	0x002e7204, // n0x03f4 c0x0000 (---------------)  + I qpon
	0x0021d986, // n0x03f5 c0x0000 (---------------)  + I quebec
	0x002b7c85, // n0x03f6 c0x0000 (---------------)  + I quest
	0x002e77c3, // n0x03f7 c0x0000 (---------------)  + I qvc
	0x00352e46, // n0x03f8 c0x0000 (---------------)  + I racing
	0x0022e484, // n0x03f9 c0x0000 (---------------)  + I raid
	0x4a208c82, // n0x03fa c0x0128 (n0x1b5d-n0x1b61)  + I re
	0x002d4a44, // n0x03fb c0x0000 (---------------)  + I read
	0x002c410a, // n0x03fc c0x0000 (---------------)  + I realestate
	0x00338887, // n0x03fd c0x0000 (---------------)  + I realtor
	0x003090c6, // n0x03fe c0x0000 (---------------)  + I realty
	0x0022c2c7, // n0x03ff c0x0000 (---------------)  + I recipes
	0x002437c3, // n0x0400 c0x0000 (---------------)  + I red
	0x003a1488, // n0x0401 c0x0000 (---------------)  + I redstone
	0x00337ecb, // n0x0402 c0x0000 (---------------)  + I redumbrella
	0x0036d345, // n0x0403 c0x0000 (---------------)  + I rehab
	0x002cb305, // n0x0404 c0x0000 (---------------)  + I reise
	0x002cb306, // n0x0405 c0x0000 (---------------)  + I reisen
	0x003013c4, // n0x0406 c0x0000 (---------------)  + I reit
	0x00325d48, // n0x0407 c0x0000 (---------------)  + I reliance
	0x00208c83, // n0x0408 c0x0000 (---------------)  + I ren
	0x0020acc4, // n0x0409 c0x0000 (---------------)  + I rent
	0x0020acc7, // n0x040a c0x0000 (---------------)  + I rentals
	0x002b7946, // n0x040b c0x0000 (---------------)  + I repair
	0x002f9f46, // n0x040c c0x0000 (---------------)  + I report
	0x002a0e4a, // n0x040d c0x0000 (---------------)  + I republican
	0x0024d844, // n0x040e c0x0000 (---------------)  + I rest
	0x003668ca, // n0x040f c0x0000 (---------------)  + I restaurant
	0x003264c6, // n0x0410 c0x0000 (---------------)  + I review
	0x003264c7, // n0x0411 c0x0000 (---------------)  + I reviews
	0x00257c47, // n0x0412 c0x0000 (---------------)  + I rexroth
	0x002736c4, // n0x0413 c0x0000 (---------------)  + I rich
	0x002736c9, // n0x0414 c0x0000 (---------------)  + I richardli
	0x002db105, // n0x0415 c0x0000 (---------------)  + I ricoh
	0x0032084b, // n0x0416 c0x0000 (---------------)  + I rightathome
	0x00251603, // n0x0417 c0x0000 (---------------)  + I ril
	0x0021a283, // n0x0418 c0x0000 (---------------)  + I rio
	0x00228803, // n0x0419 c0x0000 (---------------)  + I rip
	0x00267204, // n0x041a c0x0000 (---------------)  + I rmit
	0x4a6020c2, // n0x041b c0x0129 (n0x1b61-n0x1b6d)  + I ro
	0x0028bec6, // n0x041c c0x0000 (---------------)  + I rocher
	0x002a2845, // n0x041d c0x0000 (---------------)  + I rocks
	0x002d45c5, // n0x041e c0x0000 (---------------)  + I rodeo
	0x0039d606, // n0x041f c0x0000 (---------------)  + I rogers
	0x00374604, // n0x0420 c0x0000 (---------------)  + I room
	0x4aa006c2, // n0x0421 c0x012a (n0x1b6d-n0x1b74)  + I rs
	0x0039d704, // n0x0422 c0x0000 (---------------)  + I rsvp
	0x4ae0fe82, // n0x0423 c0x012b (n0x1b74-n0x1bf7)  + I ru
	0x002367c4, // n0x0424 c0x0000 (---------------)  + I ruhr
	0x002263c3, // n0x0425 c0x0000 (---------------)  + I run
	0x4b26e302, // n0x0426 c0x012c (n0x1bf7-n0x1c00)  + I rw
	0x003252c3, // n0x0427 c0x0000 (---------------)  + I rwe
	0x002adec6, // n0x0428 c0x0000 (---------------)  + I ryukyu
	0x4b601002, // n0x0429 c0x012d (n0x1c00-n0x1c08)  + I sa
	0x0030e208, // n0x042a c0x0000 (---------------)  + I saarland
	0x0039f4c4, // n0x042b c0x0000 (---------------)  + I safe
	0x0039f4c6, // n0x042c c0x0000 (---------------)  + I safety
	0x002dc646, // n0x042d c0x0000 (---------------)  + I sakura
	0x002595c4, // n0x042e c0x0000 (---------------)  + I sale
	0x00311445, // n0x042f c0x0000 (---------------)  + I salon
	0x0038dd88, // n0x0430 c0x0000 (---------------)  + I samsclub
	0x00398187, // n0x0431 c0x0000 (---------------)  + I samsung
	0x00253bc7, // n0x0432 c0x0000 (---------------)  + I sandvik
	0x00253bcf, // n0x0433 c0x0000 (---------------)  + I sandvikcoromant
	0x00295f06, // n0x0434 c0x0000 (---------------)  + I sanofi
	0x00213b43, // n0x0435 c0x0000 (---------------)  + I sap
	0x00213b44, // n0x0436 c0x0000 (---------------)  + I sapo
	0x00224d44, // n0x0437 c0x0000 (---------------)  + I sarl
	0x00223143, // n0x0438 c0x0000 (---------------)  + I sas
	0x00225ac4, // n0x0439 c0x0000 (---------------)  + I save
	0x0039bb84, // n0x043a c0x0000 (---------------)  + I saxo
	0x4ba286c2, // n0x043b c0x012e (n0x1c08-n0x1c0d)  + I sb
	0x0028b4c3, // n0x043c c0x0000 (---------------)  + I sbi
	0x00230f83, // n0x043d c0x0000 (---------------)  + I sbs
	0x4be07f02, // n0x043e c0x012f (n0x1c0d-n0x1c12)  + I sc
	0x00237083, // n0x043f c0x0000 (---------------)  + I sca
	0x00329b83, // n0x0440 c0x0000 (---------------)  + I scb
	0x0021728a, // n0x0441 c0x0000 (---------------)  + I schaeffler
	0x002e6b07, // n0x0442 c0x0000 (---------------)  + I schmidt
	0x00231ecc, // n0x0443 c0x0000 (---------------)  + I scholarships
	0x00232186, // n0x0444 c0x0000 (---------------)  + I school
	0x00233546, // n0x0445 c0x0000 (---------------)  + I schule
	0x00234447, // n0x0446 c0x0000 (---------------)  + I schwarz
	0x00235f47, // n0x0447 c0x0000 (---------------)  + I science
	0x00242c49, // n0x0448 c0x0000 (---------------)  + I scjohnson
	0x0021ec84, // n0x0449 c0x0000 (---------------)  + I scor
	0x00399d44, // n0x044a c0x0000 (---------------)  + I scot
	0x4c22b2c2, // n0x044b c0x0130 (n0x1c12-n0x1c1a)  + I sd
	0x4c604ec2, // n0x044c c0x0131 (n0x1c1a-n0x1c43)  + I se
	0x00319204, // n0x044d c0x0000 (---------------)  + I seat
	0x0031d846, // n0x044e c0x0000 (---------------)  + I secure
	0x002363c8, // n0x044f c0x0000 (---------------)  + I security
	0x00279f44, // n0x0450 c0x0000 (---------------)  + I seek
	0x0025b186, // n0x0451 c0x0000 (---------------)  + I select
	0x002cca45, // n0x0452 c0x0000 (---------------)  + I sener
	0x0020b748, // n0x0453 c0x0000 (---------------)  + I services
	0x00204ec3, // n0x0454 c0x0000 (---------------)  + I ses
	0x00336fc5, // n0x0455 c0x0000 (---------------)  + I seven
	0x0035f283, // n0x0456 c0x0000 (---------------)  + I sew
	0x00246b03, // n0x0457 c0x0000 (---------------)  + I sex
	0x00246b04, // n0x0458 c0x0000 (---------------)  + I sexy
	0x0024ba03, // n0x0459 c0x0000 (---------------)  + I sfr
	0x4ca6ed02, // n0x045a c0x0132 (n0x1c43-n0x1c4a)  + I sg
	0x4ce01242, // n0x045b c0x0133 (n0x1c4a-n0x1c51)  + I sh
	0x002514c9, // n0x045c c0x0000 (---------------)  + I shangrila
	0x002545c5, // n0x045d c0x0000 (---------------)  + I sharp
	0x002574c4, // n0x045e c0x0000 (---------------)  + I shaw
	0x002582c5, // n0x045f c0x0000 (---------------)  + I shell
	0x00210404, // n0x0460 c0x0000 (---------------)  + I shia
	0x0035cb07, // n0x0461 c0x0000 (---------------)  + I shiksha
	0x00387c45, // n0x0462 c0x0000 (---------------)  + I shoes
	0x002b1e06, // n0x0463 c0x0000 (---------------)  + I shouji
	0x002b2f44, // n0x0464 c0x0000 (---------------)  + I show
	0x002b4188, // n0x0465 c0x0000 (---------------)  + I showtime
	0x002c03c7, // n0x0466 c0x0000 (---------------)  + I shriram
	0x4d2091c2, // n0x0467 c0x0134 (n0x1c51-n0x1c52)  + I si
	0x00358404, // n0x0468 c0x0000 (---------------)  + I silk
	0x002f6a84, // n0x0469 c0x0000 (---------------)  + I sina
	0x00286a87, // n0x046a c0x0000 (---------------)  + I singles
	0x00243684, // n0x046b c0x0000 (---------------)  + I site
	0x0025b502, // n0x046c c0x0000 (---------------)  + I sj
	0x4d608502, // n0x046d c0x0135 (n0x1c52-n0x1c53)  + I sk
	0x00208503, // n0x046e c0x0000 (---------------)  + I ski
	0x0037cb84, // n0x046f c0x0000 (---------------)  + I skin
	0x00236f43, // n0x0470 c0x0000 (---------------)  + I sky
	0x00236f45, // n0x0471 c0x0000 (---------------)  + I skype
	0x4da20102, // n0x0472 c0x0136 (n0x1c53-n0x1c58)  + I sl
	0x002cdd05, // n0x0473 c0x0000 (---------------)  + I sling
	0x00213e02, // n0x0474 c0x0000 (---------------)  + I sm
	0x0034dd45, // n0x0475 c0x0000 (---------------)  + I smart
	0x0035d9c5, // n0x0476 c0x0000 (---------------)  + I smile
	0x4de14b82, // n0x0477 c0x0137 (n0x1c58-n0x1c60)  + I sn
	0x00214b84, // n0x0478 c0x0000 (---------------)  + I sncf
	0x4e205f02, // n0x0479 c0x0138 (n0x1c60-n0x1c63)  + I so
	0x00324dc6, // n0x047a c0x0000 (---------------)  + I soccer
	0x002a4fc6, // n0x047b c0x0000 (---------------)  + I social
	0x00269988, // n0x047c c0x0000 (---------------)  + I softbank
	0x002b9808, // n0x047d c0x0000 (---------------)  + I software
	0x002f8404, // n0x047e c0x0000 (---------------)  + I sohu
	0x002e0985, // n0x047f c0x0000 (---------------)  + I solar
	0x002f85c9, // n0x0480 c0x0000 (---------------)  + I solutions
	0x003533c4, // n0x0481 c0x0000 (---------------)  + I song
	0x00399404, // n0x0482 c0x0000 (---------------)  + I sony
	0x002bf303, // n0x0483 c0x0000 (---------------)  + I soy
	0x0020aa85, // n0x0484 c0x0000 (---------------)  + I space
	0x00370047, // n0x0485 c0x0000 (---------------)  + I spiegel
	0x00208144, // n0x0486 c0x0000 (---------------)  + I spot
	0x0032fd8d, // n0x0487 c0x0000 (---------------)  + I spreadbetting
	0x00332d82, // n0x0488 c0x0000 (---------------)  + I sr
	0x00332d83, // n0x0489 c0x0000 (---------------)  + I srl
	0x00334483, // n0x048a c0x0000 (---------------)  + I srt
	0x4e602602, // n0x048b c0x0139 (n0x1c63-n0x1c6f)  + I st
	0x0037e645, // n0x048c c0x0000 (---------------)  + I stada
	0x00231d47, // n0x048d c0x0000 (---------------)  + I staples
	0x0022a304, // n0x048e c0x0000 (---------------)  + I star
	0x0022a307, // n0x048f c0x0000 (---------------)  + I starhub
	0x0020a209, // n0x0490 c0x0000 (---------------)  + I statebank
	0x002c4249, // n0x0491 c0x0000 (---------------)  + I statefarm
	0x002ef347, // n0x0492 c0x0000 (---------------)  + I statoil
	0x00277543, // n0x0493 c0x0000 (---------------)  + I stc
	0x00277548, // n0x0494 c0x0000 (---------------)  + I stcgroup
	0x0029d589, // n0x0495 c0x0000 (---------------)  + I stockholm
	0x00358fc7, // n0x0496 c0x0000 (---------------)  + I storage
	0x00364cc5, // n0x0497 c0x0000 (---------------)  + I store
	0x002e7c86, // n0x0498 c0x0000 (---------------)  + I studio
	0x002e7e05, // n0x0499 c0x0000 (---------------)  + I study
	0x0035f505, // n0x049a c0x0000 (---------------)  + I style
	0x4ea00702, // n0x049b c0x013a (n0x1c6f-n0x1c8f)  + I su
	0x0026cc05, // n0x049c c0x0000 (---------------)  + I sucks
	0x002bc24a, // n0x049d c0x0000 (---------------)  + I supersport
	0x002c0208, // n0x049e c0x0000 (---------------)  + I supplies
	0x002bfe86, // n0x049f c0x0000 (---------------)  + I supply
	0x002e4607, // n0x04a0 c0x0000 (---------------)  + I support
	0x002461c4, // n0x04a1 c0x0000 (---------------)  + I surf
	0x002a3c47, // n0x04a2 c0x0000 (---------------)  + I surgery
	0x002ea786, // n0x04a3 c0x0000 (---------------)  + I suzuki
	0x4ee365c2, // n0x04a4 c0x013b (n0x1c8f-n0x1c94)  + I sv
	0x00375a86, // n0x04a5 c0x0000 (---------------)  + I swatch
	0x002ecb4a, // n0x04a6 c0x0000 (---------------)  + I swiftcover
	0x002ed505, // n0x04a7 c0x0000 (---------------)  + I swiss
	0x4f2edb02, // n0x04a8 c0x013c (n0x1c94-n0x1c95)  + I sx
	0x4f68c0c2, // n0x04a9 c0x013d (n0x1c95-n0x1c9b)  + I sy
	0x00335c06, // n0x04aa c0x0000 (---------------)  + I sydney
	0x002ad308, // n0x04ab c0x0000 (---------------)  + I symantec
	0x003943c7, // n0x04ac c0x0000 (---------------)  + I systems
	0x4fa000c2, // n0x04ad c0x013e (n0x1c9b-n0x1c9e)  + I sz
	0x0020e043, // n0x04ae c0x0000 (---------------)  + I tab
	0x002004c6, // n0x04af c0x0000 (---------------)  + I taipei
	0x00222d84, // n0x04b0 c0x0000 (---------------)  + I talk
	0x00394fc6, // n0x04b1 c0x0000 (---------------)  + I taobao
	0x00249c86, // n0x04b2 c0x0000 (---------------)  + I target
	0x003125ca, // n0x04b3 c0x0000 (---------------)  + I tatamotors
	0x0036bec5, // n0x04b4 c0x0000 (---------------)  + I tatar
	0x0021f4c6, // n0x04b5 c0x0000 (---------------)  + I tattoo
	0x00224103, // n0x04b6 c0x0000 (---------------)  + I tax
	0x00224104, // n0x04b7 c0x0000 (---------------)  + I taxi
	0x00204c42, // n0x04b8 c0x0000 (---------------)  + I tc
	0x0026b7c3, // n0x04b9 c0x0000 (---------------)  + I tci
	0x4fe0cd82, // n0x04ba c0x013f (n0x1c9e-n0x1c9f)  + I td
	0x002cae83, // n0x04bb c0x0000 (---------------)  + I tdk
	0x00367644, // n0x04bc c0x0000 (---------------)  + I team
	0x002ad444, // n0x04bd c0x0000 (---------------)  + I tech
	0x002ad44a, // n0x04be c0x0000 (---------------)  + I technology
	0x0022ce43, // n0x04bf c0x0000 (---------------)  + I tel
	0x00285708, // n0x04c0 c0x0000 (---------------)  + I telecity
	0x00310b0a, // n0x04c1 c0x0000 (---------------)  + I telefonica
	0x00240747, // n0x04c2 c0x0000 (---------------)  + I temasek
	0x002f02c6, // n0x04c3 c0x0000 (---------------)  + I tennis
	0x0032e244, // n0x04c4 c0x0000 (---------------)  + I teva
	0x0025d582, // n0x04c5 c0x0000 (---------------)  + I tf
	0x00205442, // n0x04c6 c0x0000 (---------------)  + I tg
	0x50206982, // n0x04c7 c0x0140 (n0x1c9f-n0x1ca6)  + I th
	0x0024a8c3, // n0x04c8 c0x0000 (---------------)  + I thd
	0x00257a07, // n0x04c9 c0x0000 (---------------)  + I theater
	0x00353107, // n0x04ca c0x0000 (---------------)  + I theatre
	0x0034e74b, // n0x04cb c0x0000 (---------------)  + I theguardian
	0x0034adc4, // n0x04cc c0x0000 (---------------)  + I tiaa
	0x002f2307, // n0x04cd c0x0000 (---------------)  + I tickets
	0x002ddf86, // n0x04ce c0x0000 (---------------)  + I tienda
	0x0039f287, // n0x04cf c0x0000 (---------------)  + I tiffany
	0x002e6a44, // n0x04d0 c0x0000 (---------------)  + I tips
	0x0034f885, // n0x04d1 c0x0000 (---------------)  + I tires
	0x002bc705, // n0x04d2 c0x0000 (---------------)  + I tirol
	0x50631342, // n0x04d3 c0x0141 (n0x1ca6-n0x1cb5)  + I tj
	0x0027db46, // n0x04d4 c0x0000 (---------------)  + I tjmaxx
	0x00231343, // n0x04d5 c0x0000 (---------------)  + I tjx
	0x0021a4c2, // n0x04d6 c0x0000 (---------------)  + I tk
	0x00238946, // n0x04d7 c0x0000 (---------------)  + I tkmaxx
	0x50a17cc2, // n0x04d8 c0x0142 (n0x1cb5-n0x1cb6)  + I tl
	0x50e00c82, // n0x04d9 c0x0143 (n0x1cb6-n0x1cbe)  + I tm
	0x00200c85, // n0x04da c0x0000 (---------------)  + I tmall
	0x5124fd82, // n0x04db c0x0144 (n0x1cbe-n0x1cd2)  + I tn
	0x51606e42, // n0x04dc c0x0145 (n0x1cd2-n0x1cd8)  + I to
	0x00263b05, // n0x04dd c0x0000 (---------------)  + I today
	0x00342205, // n0x04de c0x0000 (---------------)  + I tokyo
	0x0021f585, // n0x04df c0x0000 (---------------)  + I tools
	0x00206e43, // n0x04e0 c0x0000 (---------------)  + I top
	0x00368b45, // n0x04e1 c0x0000 (---------------)  + I toray
	0x002d28c7, // n0x04e2 c0x0000 (---------------)  + I toshiba
	0x0025c405, // n0x04e3 c0x0000 (---------------)  + I total
	0x002fc205, // n0x04e4 c0x0000 (---------------)  + I tours
	0x002dc0c4, // n0x04e5 c0x0000 (---------------)  + I town
	0x00264186, // n0x04e6 c0x0000 (---------------)  + I toyota
	0x0026f0c4, // n0x04e7 c0x0000 (---------------)  + I toys
	0x51a03902, // n0x04e8 c0x0146 (n0x1cd8-n0x1ced)  + I tr
	0x00265705, // n0x04e9 c0x0000 (---------------)  + I trade
	0x002a5c47, // n0x04ea c0x0000 (---------------)  + I trading
	0x00305c88, // n0x04eb c0x0000 (---------------)  + I training
	0x002a3206, // n0x04ec c0x0000 (---------------)  + I travel
	0x002a320d, // n0x04ed c0x0000 (---------------)  + I travelchannel
	0x002aa689, // n0x04ee c0x0000 (---------------)  + I travelers
	0x002aa692, // n0x04ef c0x0000 (---------------)  + I travelersinsurance
	0x0032a345, // n0x04f0 c0x0000 (---------------)  + I trust
	0x003424c3, // n0x04f1 c0x0000 (---------------)  + I trv
	0x5260fac2, // n0x04f2 c0x0149 (n0x1cef-n0x1d00)  + I tt
	0x002e5644, // n0x04f3 c0x0000 (---------------)  + I tube
	0x002f78c3, // n0x04f4 c0x0000 (---------------)  + I tui
	0x002ede45, // n0x04f5 c0x0000 (---------------)  + I tunes
	0x002eeb85, // n0x04f6 c0x0000 (---------------)  + I tushu
	0x52a203c2, // n0x04f7 c0x014a (n0x1d00-n0x1d04)  + I tv
	0x00364c43, // n0x04f8 c0x0000 (---------------)  + I tvs
	0x52e534c2, // n0x04f9 c0x014b (n0x1d04-n0x1d12)  + I tw
	0x53223bc2, // n0x04fa c0x014c (n0x1d12-n0x1d1e)  + I tz
	0x53624242, // n0x04fb c0x014d (n0x1d1e-n0x1d6d)  + I ua
	0x0033c185, // n0x04fc c0x0000 (---------------)  + I ubank
	0x00255ec3, // n0x04fd c0x0000 (---------------)  + I ubs
	0x0022ae08, // n0x04fe c0x0000 (---------------)  + I uconnect
	0x53a04682, // n0x04ff c0x014e (n0x1d6d-n0x1d76)  + I ug
	0x53e01b02, // n0x0500 c0x014f (n0x1d76-n0x1d81)  + I uk
	0x002a7c46, // n0x0501 c0x0000 (---------------)  + I unicom
	0x00309e4a, // n0x0502 c0x0000 (---------------)  + I university
	0x0020e783, // n0x0503 c0x0000 (---------------)  + I uno
	0x00249583, // n0x0504 c0x0000 (---------------)  + I uol
	0x002d2003, // n0x0505 c0x0000 (---------------)  + I ups
	0x54a02242, // n0x0506 c0x0152 (n0x1d83-n0x1dc2)  + I us
	0x62e041c2, // n0x0507 c0x018b (n0x1e65-n0x1e6b)  + I uy
	0x6360fec2, // n0x0508 c0x018d (n0x1e6c-n0x1e70)  + I uz
	0x00200c02, // n0x0509 c0x0000 (---------------)  + I va
	0x00375889, // n0x050a c0x0000 (---------------)  + I vacations
	0x002be804, // n0x050b c0x0000 (---------------)  + I vana
	0x00343f88, // n0x050c c0x0000 (---------------)  + I vanguard
	0x63ae7802, // n0x050d c0x018e (n0x1e70-n0x1e76)  + I vc
	0x63e02a42, // n0x050e c0x018f (n0x1e76-n0x1e87)  + I ve
	0x0023dfc5, // n0x050f c0x0000 (---------------)  + I vegas
	0x0023a188, // n0x0510 c0x0000 (---------------)  + I ventures
	0x002ecd08, // n0x0511 c0x0000 (---------------)  + I verisign
	0x003939cc, // n0x0512 c0x0000 (---------------)  + I versicherung
	0x00240683, // n0x0513 c0x0000 (---------------)  + I vet
	0x00234e42, // n0x0514 c0x0000 (---------------)  + I vg
	0x642065c2, // n0x0515 c0x0190 (n0x1e87-n0x1e8c)  + I vi
	0x002c7086, // n0x0516 c0x0000 (---------------)  + I viajes
	0x002f1145, // n0x0517 c0x0000 (---------------)  + I video
	0x0030a8c3, // n0x0518 c0x0000 (---------------)  + I vig
	0x0032ae86, // n0x0519 c0x0000 (---------------)  + I viking
	0x002f1286, // n0x051a c0x0000 (---------------)  + I villas
	0x0025e683, // n0x051b c0x0000 (---------------)  + I vin
	0x002f69c3, // n0x051c c0x0000 (---------------)  + I vip
	0x002f6d86, // n0x051d c0x0000 (---------------)  + I virgin
	0x002f7304, // n0x051e c0x0000 (---------------)  + I visa
	0x0027bc46, // n0x051f c0x0000 (---------------)  + I vision
	0x002caa45, // n0x0520 c0x0000 (---------------)  + I vista
	0x002f768a, // n0x0521 c0x0000 (---------------)  + I vistaprint
	0x00240044, // n0x0522 c0x0000 (---------------)  + I viva
	0x002f88c4, // n0x0523 c0x0000 (---------------)  + I vivo
	0x0034514a, // n0x0524 c0x0000 (---------------)  + I vlaanderen
	0x64602f42, // n0x0525 c0x0191 (n0x1e8c-n0x1e99)  + I vn
	0x00275ec5, // n0x0526 c0x0000 (---------------)  + I vodka
	0x002fa4ca, // n0x0527 c0x0000 (---------------)  + I volkswagen
	0x002fb385, // n0x0528 c0x0000 (---------------)  + I volvo
	0x002fbf04, // n0x0529 c0x0000 (---------------)  + I vote
	0x002fc006, // n0x052a c0x0000 (---------------)  + I voting
	0x002fc184, // n0x052b c0x0000 (---------------)  + I voto
	0x00230ac6, // n0x052c c0x0000 (---------------)  + I voyage
	0x64a6a402, // n0x052d c0x0192 (n0x1e99-n0x1e9d)  + I vu
	0x00308a06, // n0x052e c0x0000 (---------------)  + I vuelos
	0x00309ac5, // n0x052f c0x0000 (---------------)  + I wales
	0x00201c47, // n0x0530 c0x0000 (---------------)  + I walmart
	0x00295246, // n0x0531 c0x0000 (---------------)  + I walter
	0x00234644, // n0x0532 c0x0000 (---------------)  + I wang
	0x002aeac7, // n0x0533 c0x0000 (---------------)  + I wanggou
	0x0036de86, // n0x0534 c0x0000 (---------------)  + I warman
	0x002b0685, // n0x0535 c0x0000 (---------------)  + I watch
	0x003a5007, // n0x0536 c0x0000 (---------------)  + I watches
	0x00390e47, // n0x0537 c0x0000 (---------------)  + I weather
	0x00390e4e, // n0x0538 c0x0000 (---------------)  + I weatherchannel
	0x0021e246, // n0x0539 c0x0000 (---------------)  + I webcam
	0x0022fb85, // n0x053a c0x0000 (---------------)  + I weber
	0x002c2487, // n0x053b c0x0000 (---------------)  + I website
	0x002ebe43, // n0x053c c0x0000 (---------------)  + I wed
	0x00353f07, // n0x053d c0x0000 (---------------)  + I wedding
	0x00211745, // n0x053e c0x0000 (---------------)  + I weibo
	0x00212044, // n0x053f c0x0000 (---------------)  + I weir
	0x00230242, // n0x0540 c0x0000 (---------------)  + I wf
	0x0036e507, // n0x0541 c0x0000 (---------------)  + I whoswho
	0x002ea684, // n0x0542 c0x0000 (---------------)  + I wien
	0x0023e984, // n0x0543 c0x0000 (---------------)  + I wiki
	0x0025a64b, // n0x0544 c0x0000 (---------------)  + I williamhill
	0x00220ac3, // n0x0545 c0x0000 (---------------)  + I win
	0x002fd1c7, // n0x0546 c0x0000 (---------------)  + I windows
	0x00220ac4, // n0x0547 c0x0000 (---------------)  + I wine
	0x002b2dc7, // n0x0548 c0x0000 (---------------)  + I winners
	0x002318c3, // n0x0549 c0x0000 (---------------)  + I wme
	0x0032c58d, // n0x054a c0x0000 (---------------)  + I wolterskluwer
	0x0037ee88, // n0x054b c0x0000 (---------------)  + I woodside
	0x00256684, // n0x054c c0x0000 (---------------)  + I work
	0x00357085, // n0x054d c0x0000 (---------------)  + I works
	0x002ffbc5, // n0x054e c0x0000 (---------------)  + I world
	0x002fdac3, // n0x054f c0x0000 (---------------)  + I wow
	0x64e0a882, // n0x0550 c0x0193 (n0x1e9d-n0x1ea4)  + I ws
	0x002fedc3, // n0x0551 c0x0000 (---------------)  + I wtc
	0x002ff283, // n0x0552 c0x0000 (---------------)  + I wtf
	0x00219604, // n0x0553 c0x0000 (---------------)  + I xbox
	0x0027c3c5, // n0x0554 c0x0000 (---------------)  + I xerox
	0x0027dcc7, // n0x0555 c0x0000 (---------------)  + I xfinity
	0x00224186, // n0x0556 c0x0000 (---------------)  + I xihuan
	0x00367383, // n0x0557 c0x0000 (---------------)  + I xin
	0x00238a8b, // n0x0558 c0x0000 (---------------)  + I xn--11b4c3d
	0x0024780b, // n0x0559 c0x0000 (---------------)  + I xn--1ck2e1b
	0x0027314b, // n0x055a c0x0000 (---------------)  + I xn--1qqw23a
	0x002a6fca, // n0x055b c0x0000 (---------------)  + I xn--30rr7y
	0x002bf80b, // n0x055c c0x0000 (---------------)  + I xn--3bst00m
	0x002d538b, // n0x055d c0x0000 (---------------)  + I xn--3ds443g
	0x002edb4c, // n0x055e c0x0000 (---------------)  + I xn--3e0b707e
	0x00339a11, // n0x055f c0x0000 (---------------)  + I xn--3oq18vl8pn36a
	0x00347f0a, // n0x0560 c0x0000 (---------------)  + I xn--3pxu8k
	0x0036fa4b, // n0x0561 c0x0000 (---------------)  + I xn--42c2d9a
	0x003a208b, // n0x0562 c0x0000 (---------------)  + I xn--45brj9c
	0x003a49ca, // n0x0563 c0x0000 (---------------)  + I xn--45q11c
	0x002fffca, // n0x0564 c0x0000 (---------------)  + I xn--4gbrim
	0x0030038d, // n0x0565 c0x0000 (---------------)  + I xn--4gq48lf9j
	0x0030310e, // n0x0566 c0x0000 (---------------)  + I xn--54b7fta0cc
	0x0030368b, // n0x0567 c0x0000 (---------------)  + I xn--55qw42g
	0x0030394a, // n0x0568 c0x0000 (---------------)  + I xn--55qx5d
	0x00304751, // n0x0569 c0x0000 (---------------)  + I xn--5su34j936bgsg
	0x00304b8a, // n0x056a c0x0000 (---------------)  + I xn--5tzm5g
	0x0030508b, // n0x056b c0x0000 (---------------)  + I xn--6frz82g
	0x003055ce, // n0x056c c0x0000 (---------------)  + I xn--6qq986b3xl
	0x0030650c, // n0x056d c0x0000 (---------------)  + I xn--80adxhks
	0x00306b4b, // n0x056e c0x0000 (---------------)  + I xn--80ao21a
	0x00306e0e, // n0x056f c0x0000 (---------------)  + I xn--80aqecdr1a
	0x0030718c, // n0x0570 c0x0000 (---------------)  + I xn--80asehdb
	0x0030b78a, // n0x0571 c0x0000 (---------------)  + I xn--80aswg
	0x0030ca0c, // n0x0572 c0x0000 (---------------)  + I xn--8y0a063a
	0x6530cd0a, // n0x0573 c0x0194 (n0x1ea4-n0x1eaa)  + I xn--90a3ac
	0x0030da49, // n0x0574 c0x0000 (---------------)  + I xn--90ais
	0x0030f00a, // n0x0575 c0x0000 (---------------)  + I xn--9dbq2a
	0x0030f28a, // n0x0576 c0x0000 (---------------)  + I xn--9et52u
	0x0030f50b, // n0x0577 c0x0000 (---------------)  + I xn--9krt00a
	0x0031404e, // n0x0578 c0x0000 (---------------)  + I xn--b4w605ferd
	0x003143d1, // n0x0579 c0x0000 (---------------)  + I xn--bck1b9a5dre4c
	0x0031b349, // n0x057a c0x0000 (---------------)  + I xn--c1avg
	0x0031b58a, // n0x057b c0x0000 (---------------)  + I xn--c2br7g
	0x0031c28b, // n0x057c c0x0000 (---------------)  + I xn--cck2b3b
	0x0031ca4a, // n0x057d c0x0000 (---------------)  + I xn--cg4bki
	0x0031d1d6, // n0x057e c0x0000 (---------------)  + I xn--clchc0ea0b2g2a9gcd
	0x0031e9cb, // n0x057f c0x0000 (---------------)  + I xn--czr694b
	0x0032220a, // n0x0580 c0x0000 (---------------)  + I xn--czrs0t
	0x00322a4a, // n0x0581 c0x0000 (---------------)  + I xn--czru2d
	0x0032400b, // n0x0582 c0x0000 (---------------)  + I xn--d1acj3b
	0x00329dc9, // n0x0583 c0x0000 (---------------)  + I xn--d1alf
	0x0032cf0d, // n0x0584 c0x0000 (---------------)  + I xn--eckvdtc9d
	0x0032d58b, // n0x0585 c0x0000 (---------------)  + I xn--efvy88h
	0x0032e48b, // n0x0586 c0x0000 (---------------)  + I xn--estv75g
	0x0032ee4b, // n0x0587 c0x0000 (---------------)  + I xn--fct429k
	0x0032f409, // n0x0588 c0x0000 (---------------)  + I xn--fhbei
	0x0032fa4e, // n0x0589 c0x0000 (---------------)  + I xn--fiq228c5hs
	0x003300ca, // n0x058a c0x0000 (---------------)  + I xn--fiq64b
	0x003326ca, // n0x058b c0x0000 (---------------)  + I xn--fiqs8s
	0x00332b4a, // n0x058c c0x0000 (---------------)  + I xn--fiqz9s
	0x0033318b, // n0x058d c0x0000 (---------------)  + I xn--fjq720a
	0x003339cb, // n0x058e c0x0000 (---------------)  + I xn--flw351e
	0x00333c8d, // n0x058f c0x0000 (---------------)  + I xn--fpcrj9c3d
	0x0033548d, // n0x0590 c0x0000 (---------------)  + I xn--fzc2c9e2c
	0x00335d90, // n0x0591 c0x0000 (---------------)  + I xn--fzys8d69uvgm
	0x0033624b, // n0x0592 c0x0000 (---------------)  + I xn--g2xx48c
	0x0033670c, // n0x0593 c0x0000 (---------------)  + I xn--gckr3f0f
	0x0033738b, // n0x0594 c0x0000 (---------------)  + I xn--gecrj9c
	0x0033a18b, // n0x0595 c0x0000 (---------------)  + I xn--gk3at1e
	0x0033d00b, // n0x0596 c0x0000 (---------------)  + I xn--h2brj9c
	0x0034094b, // n0x0597 c0x0000 (---------------)  + I xn--hxt814e
	0x003413cf, // n0x0598 c0x0000 (---------------)  + I xn--i1b6b1a6a2e
	0x0034178b, // n0x0599 c0x0000 (---------------)  + I xn--imr513n
	0x0034278a, // n0x059a c0x0000 (---------------)  + I xn--io0a7i
	0x00343489, // n0x059b c0x0000 (---------------)  + I xn--j1aef
	0x00343849, // n0x059c c0x0000 (---------------)  + I xn--j1amh
	0x0034418b, // n0x059d c0x0000 (---------------)  + I xn--j6w193g
	0x0034444e, // n0x059e c0x0000 (---------------)  + I xn--jlq61u9w7b
	0x003457cb, // n0x059f c0x0000 (---------------)  + I xn--jvr189m
	0x00346acf, // n0x05a0 c0x0000 (---------------)  + I xn--kcrx77d1x4a
	0x00348b4b, // n0x05a1 c0x0000 (---------------)  + I xn--kprw13d
	0x00348e0b, // n0x05a2 c0x0000 (---------------)  + I xn--kpry57d
	0x003490cb, // n0x05a3 c0x0000 (---------------)  + I xn--kpu716f
	0x00349a4a, // n0x05a4 c0x0000 (---------------)  + I xn--kput3i
	0x0034fb89, // n0x05a5 c0x0000 (---------------)  + I xn--l1acc
	0x00355ecf, // n0x05a6 c0x0000 (---------------)  + I xn--lgbbat1ad8j
	0x0035aecc, // n0x05a7 c0x0000 (---------------)  + I xn--mgb2ddes
	0x0035b34c, // n0x05a8 c0x0000 (---------------)  + I xn--mgb9awbf
	0x0035b80e, // n0x05a9 c0x0000 (---------------)  + I xn--mgba3a3ejt
	0x0035cf4f, // n0x05aa c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x0035d30e, // n0x05ab c0x0000 (---------------)  + I xn--mgba3a4fra
	0x0035de10, // n0x05ac c0x0000 (---------------)  + I xn--mgba7c0bbn0a
	0x0035e20f, // n0x05ad c0x0000 (---------------)  + I xn--mgbaakc7dvf
	0x0035f64e, // n0x05ae c0x0000 (---------------)  + I xn--mgbaam7a8h
	0x0035fb0c, // n0x05af c0x0000 (---------------)  + I xn--mgbab2bd
	0x0035fe12, // n0x05b0 c0x0000 (---------------)  + I xn--mgbai9a5eva00b
	0x00361151, // n0x05b1 c0x0000 (---------------)  + I xn--mgbai9azgqp6j
	0x0036170e, // n0x05b2 c0x0000 (---------------)  + I xn--mgbayh7gpa
	0x00361b4e, // n0x05b3 c0x0000 (---------------)  + I xn--mgbb9fbpob
	0x0036208e, // n0x05b4 c0x0000 (---------------)  + I xn--mgbbh1a71e
	0x0036240f, // n0x05b5 c0x0000 (---------------)  + I xn--mgbc0a9azcg
	0x003627ce, // n0x05b6 c0x0000 (---------------)  + I xn--mgbca7dzdo
	0x00362cd3, // n0x05b7 c0x0000 (---------------)  + I xn--mgberp4a5d4a87g
	0x00363191, // n0x05b8 c0x0000 (---------------)  + I xn--mgberp4a5d4ar
	0x003635ce, // n0x05b9 c0x0000 (---------------)  + I xn--mgbi4ecexp
	0x00363a4c, // n0x05ba c0x0000 (---------------)  + I xn--mgbpl2fh
	0x00363e93, // n0x05bb c0x0000 (---------------)  + I xn--mgbqly7c0a67fbc
	0x00364610, // n0x05bc c0x0000 (---------------)  + I xn--mgbqly7cvafr
	0x00364f4c, // n0x05bd c0x0000 (---------------)  + I xn--mgbt3dhd
	0x0036524c, // n0x05be c0x0000 (---------------)  + I xn--mgbtf8fl
	0x0036578b, // n0x05bf c0x0000 (---------------)  + I xn--mgbtx2b
	0x00365c4e, // n0x05c0 c0x0000 (---------------)  + I xn--mgbx4cd0ab
	0x0036614b, // n0x05c1 c0x0000 (---------------)  + I xn--mix082f
	0x0036650b, // n0x05c2 c0x0000 (---------------)  + I xn--mix891f
	0x00367a0c, // n0x05c3 c0x0000 (---------------)  + I xn--mk1bu44c
	0x0036eb8a, // n0x05c4 c0x0000 (---------------)  + I xn--mxtq1m
	0x0036f24c, // n0x05c5 c0x0000 (---------------)  + I xn--ngbc5azd
	0x0036f54c, // n0x05c6 c0x0000 (---------------)  + I xn--ngbe9e0a
	0x0036f849, // n0x05c7 c0x0000 (---------------)  + I xn--ngbrx
	0x00370acb, // n0x05c8 c0x0000 (---------------)  + I xn--nnx388a
	0x00370d88, // n0x05c9 c0x0000 (---------------)  + I xn--node
	0x00371249, // n0x05ca c0x0000 (---------------)  + I xn--nqv7f
	0x0037124f, // n0x05cb c0x0000 (---------------)  + I xn--nqv7fs00ema
	0x00372bcb, // n0x05cc c0x0000 (---------------)  + I xn--nyqy26a
	0x003747ca, // n0x05cd c0x0000 (---------------)  + I xn--o3cw4h
	0x00375f0c, // n0x05ce c0x0000 (---------------)  + I xn--ogbpf8fl
	0x00377ac9, // n0x05cf c0x0000 (---------------)  + I xn--p1acf
	0x00377d48, // n0x05d0 c0x0000 (---------------)  + I xn--p1ai
	0x00377f4b, // n0x05d1 c0x0000 (---------------)  + I xn--pbt977c
	0x00379f8b, // n0x05d2 c0x0000 (---------------)  + I xn--pgbs0dh
	0x0037ab8a, // n0x05d3 c0x0000 (---------------)  + I xn--pssy2u
	0x0037ae0b, // n0x05d4 c0x0000 (---------------)  + I xn--q9jyb4c
	0x0037be4c, // n0x05d5 c0x0000 (---------------)  + I xn--qcka1pmc
	0x0037c908, // n0x05d6 c0x0000 (---------------)  + I xn--qxam
	0x0037f08b, // n0x05d7 c0x0000 (---------------)  + I xn--rhqv96g
	0x0038174b, // n0x05d8 c0x0000 (---------------)  + I xn--rovu88b
	0x0038548b, // n0x05d9 c0x0000 (---------------)  + I xn--s9brj9c
	0x00386b8b, // n0x05da c0x0000 (---------------)  + I xn--ses554g
	0x003909cb, // n0x05db c0x0000 (---------------)  + I xn--t60b56a
	0x00390c89, // n0x05dc c0x0000 (---------------)  + I xn--tckwe
	0x003911cd, // n0x05dd c0x0000 (---------------)  + I xn--tiq49xqyj
	0x00395b0a, // n0x05de c0x0000 (---------------)  + I xn--unup4y
	0x00396a57, // n0x05df c0x0000 (---------------)  + I xn--vermgensberater-ctb
	0x00397898, // n0x05e0 c0x0000 (---------------)  + I xn--vermgensberatung-pwb
	0x0039bc89, // n0x05e1 c0x0000 (---------------)  + I xn--vhquv
	0x0039ce8b, // n0x05e2 c0x0000 (---------------)  + I xn--vuq861b
	0x0039dc54, // n0x05e3 c0x0000 (---------------)  + I xn--w4r85el8fhu5dnra
	0x0039e14b, // n0x05e4 c0x0000 (---------------)  + I xn--w4rs40l
	0x0039e6ca, // n0x05e5 c0x0000 (---------------)  + I xn--wgbh1c
	0x0039ec8a, // n0x05e6 c0x0000 (---------------)  + I xn--wgbl6a
	0x0039ef0b, // n0x05e7 c0x0000 (---------------)  + I xn--xhq521b
	0x0039fd90, // n0x05e8 c0x0000 (---------------)  + I xn--xkc2al3hye2a
	0x003a0191, // n0x05e9 c0x0000 (---------------)  + I xn--xkc2dl3a5ee0h
	0x003a0a4a, // n0x05ea c0x0000 (---------------)  + I xn--y9a3aq
	0x003a168d, // n0x05eb c0x0000 (---------------)  + I xn--yfro4i67o
	0x003a1d8d, // n0x05ec c0x0000 (---------------)  + I xn--ygbi2ammx
	0x003a548b, // n0x05ed c0x0000 (---------------)  + I xn--zfr164b
	0x003a5c46, // n0x05ee c0x0000 (---------------)  + I xperia
	0x0027dc43, // n0x05ef c0x0000 (---------------)  + I xxx
	0x00246b83, // n0x05f0 c0x0000 (---------------)  + I xyz
	0x00308546, // n0x05f1 c0x0000 (---------------)  + I yachts
	0x0028f8c5, // n0x05f2 c0x0000 (---------------)  + I yahoo
	0x002c92c7, // n0x05f3 c0x0000 (---------------)  + I yamaxun
	0x003398c6, // n0x05f4 c0x0000 (---------------)  + I yandex
	0x01607002, // n0x05f5 c0x0005 (---------------)* o I ye
	0x003a23c9, // n0x05f6 c0x0000 (---------------)  + I yodobashi
	0x00352c44, // n0x05f7 c0x0000 (---------------)  + I yoga
	0x002d1a88, // n0x05f8 c0x0000 (---------------)  + I yokohama
	0x0024a803, // n0x05f9 c0x0000 (---------------)  + I you
	0x002e5587, // n0x05fa c0x0000 (---------------)  + I youtube
	0x00219c02, // n0x05fb c0x0000 (---------------)  + I yt
	0x002ad943, // n0x05fc c0x0000 (---------------)  + I yun
	0x65600182, // n0x05fd c0x0195 (n0x1eaa-n0x1ebb)  o I za
	0x002c5d86, // n0x05fe c0x0000 (---------------)  + I zappos
	0x002c6684, // n0x05ff c0x0000 (---------------)  + I zara
	0x00326f84, // n0x0600 c0x0000 (---------------)  + I zero
	0x0023b883, // n0x0601 c0x0000 (---------------)  + I zip
	0x0023b885, // n0x0602 c0x0000 (---------------)  + I zippo
	0x016ffd42, // n0x0603 c0x0005 (---------------)* o I zm
	0x002dd744, // n0x0604 c0x0000 (---------------)  + I zone
	0x00273607, // n0x0605 c0x0000 (---------------)  + I zuerich
	0x016fd182, // n0x0606 c0x0005 (---------------)* o I zw
	0x00233243, // n0x0607 c0x0000 (---------------)  + I com
	0x00239103, // n0x0608 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x0609 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x060a c0x0000 (---------------)  + I mil
	0x00223b43, // n0x060b c0x0000 (---------------)  + I net
	0x00228743, // n0x060c c0x0000 (---------------)  + I org
	0x00201383, // n0x060d c0x0000 (---------------)  + I nom
	0x00200342, // n0x060e c0x0000 (---------------)  + I ac
	0x000fe108, // n0x060f c0x0000 (---------------)  +   blogspot
	0x0020ce42, // n0x0610 c0x0000 (---------------)  + I co
	0x0027d903, // n0x0611 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x0612 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x0613 c0x0000 (---------------)  + I net
	0x00228743, // n0x0614 c0x0000 (---------------)  + I org
	0x00217283, // n0x0615 c0x0000 (---------------)  + I sch
	0x00318816, // n0x0616 c0x0000 (---------------)  + I accident-investigation
	0x0031a353, // n0x0617 c0x0000 (---------------)  + I accident-prevention
	0x002f2189, // n0x0618 c0x0000 (---------------)  + I aerobatic
	0x00378b48, // n0x0619 c0x0000 (---------------)  + I aeroclub
	0x002e2dc9, // n0x061a c0x0000 (---------------)  + I aerodrome
	0x002fa646, // n0x061b c0x0000 (---------------)  + I agents
	0x0030e650, // n0x061c c0x0000 (---------------)  + I air-surveillance
	0x0033f613, // n0x061d c0x0000 (---------------)  + I air-traffic-control
	0x00205108, // n0x061e c0x0000 (---------------)  + I aircraft
	0x0024e5c7, // n0x061f c0x0000 (---------------)  + I airline
	0x002791c7, // n0x0620 c0x0000 (---------------)  + I airport
	0x00287c0a, // n0x0621 c0x0000 (---------------)  + I airtraffic
	0x002c06c9, // n0x0622 c0x0000 (---------------)  + I ambulance
	0x00332009, // n0x0623 c0x0000 (---------------)  + I amusement
	0x002d5e8b, // n0x0624 c0x0000 (---------------)  + I association
	0x00320ec6, // n0x0625 c0x0000 (---------------)  + I author
	0x0022e08a, // n0x0626 c0x0000 (---------------)  + I ballooning
	0x00224906, // n0x0627 c0x0000 (---------------)  + I broker
	0x00352843, // n0x0628 c0x0000 (---------------)  + I caa
	0x002f3245, // n0x0629 c0x0000 (---------------)  + I cargo
	0x0037b1c8, // n0x062a c0x0000 (---------------)  + I catering
	0x00324e8d, // n0x062b c0x0000 (---------------)  + I certification
	0x0033f1cc, // n0x062c c0x0000 (---------------)  + I championship
	0x00309787, // n0x062d c0x0000 (---------------)  + I charter
	0x00359e8d, // n0x062e c0x0000 (---------------)  + I civilaviation
	0x00378c44, // n0x062f c0x0000 (---------------)  + I club
	0x0023734a, // n0x0630 c0x0000 (---------------)  + I conference
	0x00237e4a, // n0x0631 c0x0000 (---------------)  + I consultant
	0x0023830a, // n0x0632 c0x0000 (---------------)  + I consulting
	0x002f4607, // n0x0633 c0x0000 (---------------)  + I control
	0x00242307, // n0x0634 c0x0000 (---------------)  + I council
	0x00244144, // n0x0635 c0x0000 (---------------)  + I crew
	0x00228206, // n0x0636 c0x0000 (---------------)  + I design
	0x00249384, // n0x0637 c0x0000 (---------------)  + I dgca
	0x0035c248, // n0x0638 c0x0000 (---------------)  + I educator
	0x00311d49, // n0x0639 c0x0000 (---------------)  + I emergency
	0x0030c4c6, // n0x063a c0x0000 (---------------)  + I engine
	0x0030c4c8, // n0x063b c0x0000 (---------------)  + I engineer
	0x00246fcd, // n0x063c c0x0000 (---------------)  + I entertainment
	0x002c4489, // n0x063d c0x0000 (---------------)  + I equipment
	0x00379608, // n0x063e c0x0000 (---------------)  + I exchange
	0x00246987, // n0x063f c0x0000 (---------------)  + I express
	0x00310d8a, // n0x0640 c0x0000 (---------------)  + I federation
	0x00251346, // n0x0641 c0x0000 (---------------)  + I flight
	0x0025cb47, // n0x0642 c0x0000 (---------------)  + I freight
	0x0023ff44, // n0x0643 c0x0000 (---------------)  + I fuel
	0x0026f907, // n0x0644 c0x0000 (---------------)  + I gliding
	0x0027d90a, // n0x0645 c0x0000 (---------------)  + I government
	0x00288dce, // n0x0646 c0x0000 (---------------)  + I groundhandling
	0x0020c745, // n0x0647 c0x0000 (---------------)  + I group
	0x002fd80b, // n0x0648 c0x0000 (---------------)  + I hanggliding
	0x002f3589, // n0x0649 c0x0000 (---------------)  + I homebuilt
	0x00263309, // n0x064a c0x0000 (---------------)  + I insurance
	0x0027b207, // n0x064b c0x0000 (---------------)  + I journal
	0x0038d78a, // n0x064c c0x0000 (---------------)  + I journalist
	0x002869c7, // n0x064d c0x0000 (---------------)  + I leasing
	0x002e2849, // n0x064e c0x0000 (---------------)  + I logistics
	0x00395588, // n0x064f c0x0000 (---------------)  + I magazine
	0x0027614b, // n0x0650 c0x0000 (---------------)  + I maintenance
	0x00303545, // n0x0651 c0x0000 (---------------)  + I media
	0x00288aca, // n0x0652 c0x0000 (---------------)  + I microlight
	0x002a4849, // n0x0653 c0x0000 (---------------)  + I modelling
	0x0030a84a, // n0x0654 c0x0000 (---------------)  + I navigation
	0x002c6c8b, // n0x0655 c0x0000 (---------------)  + I parachuting
	0x0026f80b, // n0x0656 c0x0000 (---------------)  + I paragliding
	0x002d5c15, // n0x0657 c0x0000 (---------------)  + I passenger-association
	0x002d6ac5, // n0x0658 c0x0000 (---------------)  + I pilot
	0x00246a05, // n0x0659 c0x0000 (---------------)  + I press
	0x002e1bca, // n0x065a c0x0000 (---------------)  + I production
	0x0031d94a, // n0x065b c0x0000 (---------------)  + I recreation
	0x0022ed87, // n0x065c c0x0000 (---------------)  + I repbody
	0x00221903, // n0x065d c0x0000 (---------------)  + I res
	0x002a1188, // n0x065e c0x0000 (---------------)  + I research
	0x002ce40a, // n0x065f c0x0000 (---------------)  + I rotorcraft
	0x0039f4c6, // n0x0660 c0x0000 (---------------)  + I safety
	0x00242649, // n0x0661 c0x0000 (---------------)  + I scientist
	0x0020b748, // n0x0662 c0x0000 (---------------)  + I services
	0x002b2f44, // n0x0663 c0x0000 (---------------)  + I show
	0x00288309, // n0x0664 c0x0000 (---------------)  + I skydiving
	0x002b9808, // n0x0665 c0x0000 (---------------)  + I software
	0x002ac947, // n0x0666 c0x0000 (---------------)  + I student
	0x00265706, // n0x0667 c0x0000 (---------------)  + I trader
	0x002a5c47, // n0x0668 c0x0000 (---------------)  + I trading
	0x00299907, // n0x0669 c0x0000 (---------------)  + I trainer
	0x00243b85, // n0x066a c0x0000 (---------------)  + I union
	0x002dbb8c, // n0x066b c0x0000 (---------------)  + I workinggroup
	0x00357085, // n0x066c c0x0000 (---------------)  + I works
	0x00233243, // n0x066d c0x0000 (---------------)  + I com
	0x00239103, // n0x066e c0x0000 (---------------)  + I edu
	0x0027d903, // n0x066f c0x0000 (---------------)  + I gov
	0x00223b43, // n0x0670 c0x0000 (---------------)  + I net
	0x00228743, // n0x0671 c0x0000 (---------------)  + I org
	0x0020ce42, // n0x0672 c0x0000 (---------------)  + I co
	0x00233243, // n0x0673 c0x0000 (---------------)  + I com
	0x00223b43, // n0x0674 c0x0000 (---------------)  + I net
	0x00201383, // n0x0675 c0x0000 (---------------)  + I nom
	0x00228743, // n0x0676 c0x0000 (---------------)  + I org
	0x00233243, // n0x0677 c0x0000 (---------------)  + I com
	0x00223b43, // n0x0678 c0x0000 (---------------)  + I net
	0x0020ce83, // n0x0679 c0x0000 (---------------)  + I off
	0x00228743, // n0x067a c0x0000 (---------------)  + I org
	0x000fe108, // n0x067b c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x067c c0x0000 (---------------)  + I com
	0x00239103, // n0x067d c0x0000 (---------------)  + I edu
	0x0027d903, // n0x067e c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x067f c0x0000 (---------------)  + I mil
	0x00223b43, // n0x0680 c0x0000 (---------------)  + I net
	0x00228743, // n0x0681 c0x0000 (---------------)  + I org
	0x000fe108, // n0x0682 c0x0000 (---------------)  +   blogspot
	0x0020ce42, // n0x0683 c0x0000 (---------------)  + I co
	0x002024c2, // n0x0684 c0x0000 (---------------)  + I ed
	0x00238542, // n0x0685 c0x0000 (---------------)  + I gv
	0x002017c2, // n0x0686 c0x0000 (---------------)  + I it
	0x00201902, // n0x0687 c0x0000 (---------------)  + I og
	0x0022ee02, // n0x0688 c0x0000 (---------------)  + I pb
	0x04633243, // n0x0689 c0x0011 (n0x0692-n0x0693)  + I com
	0x00239103, // n0x068a c0x0000 (---------------)  + I edu
	0x00212b03, // n0x068b c0x0000 (---------------)  + I gob
	0x0027d903, // n0x068c c0x0000 (---------------)  + I gov
	0x00201503, // n0x068d c0x0000 (---------------)  + I int
	0x00207dc3, // n0x068e c0x0000 (---------------)  + I mil
	0x00223b43, // n0x068f c0x0000 (---------------)  + I net
	0x00228743, // n0x0690 c0x0000 (---------------)  + I org
	0x00208c03, // n0x0691 c0x0000 (---------------)  + I tur
	0x000fe108, // n0x0692 c0x0000 (---------------)  +   blogspot
	0x0025dc44, // n0x0693 c0x0000 (---------------)  + I e164
	0x00329387, // n0x0694 c0x0000 (---------------)  + I in-addr
	0x00214243, // n0x0695 c0x0000 (---------------)  + I ip6
	0x0029b804, // n0x0696 c0x0000 (---------------)  + I iris
	0x0020f003, // n0x0697 c0x0000 (---------------)  + I uri
	0x0027b283, // n0x0698 c0x0000 (---------------)  + I urn
	0x0027d903, // n0x0699 c0x0000 (---------------)  + I gov
	0x00200342, // n0x069a c0x0000 (---------------)  + I ac
	0x00131a83, // n0x069b c0x0000 (---------------)  +   biz
	0x0560ce42, // n0x069c c0x0015 (n0x06a1-n0x06a2)  + I co
	0x00238542, // n0x069d c0x0000 (---------------)  + I gv
	0x00001844, // n0x069e c0x0000 (---------------)  +   info
	0x00200dc2, // n0x069f c0x0000 (---------------)  + I or
	0x000e17c4, // n0x06a0 c0x0000 (---------------)  +   priv
	0x000fe108, // n0x06a1 c0x0000 (---------------)  +   blogspot
	0x002388c3, // n0x06a2 c0x0000 (---------------)  + I act
	0x0022b643, // n0x06a3 c0x0000 (---------------)  + I asn
	0x05e33243, // n0x06a4 c0x0017 (n0x06b4-n0x06b5)  + I com
	0x00237344, // n0x06a5 c0x0000 (---------------)  + I conf
	0x06239103, // n0x06a6 c0x0018 (n0x06b5-n0x06bd)  + I edu
	0x0667d903, // n0x06a7 c0x0019 (n0x06bd-n0x06c2)  + I gov
	0x0020d9c2, // n0x06a8 c0x0000 (---------------)  + I id
	0x00201844, // n0x06a9 c0x0000 (---------------)  + I info
	0x00223b43, // n0x06aa c0x0000 (---------------)  + I net
	0x002ebf43, // n0x06ab c0x0000 (---------------)  + I nsw
	0x00201542, // n0x06ac c0x0000 (---------------)  + I nt
	0x00228743, // n0x06ad c0x0000 (---------------)  + I org
	0x0021e882, // n0x06ae c0x0000 (---------------)  + I oz
	0x002e7143, // n0x06af c0x0000 (---------------)  + I qld
	0x00201002, // n0x06b0 c0x0000 (---------------)  + I sa
	0x00203f83, // n0x06b1 c0x0000 (---------------)  + I tas
	0x0020b803, // n0x06b2 c0x0000 (---------------)  + I vic
	0x00201c42, // n0x06b3 c0x0000 (---------------)  + I wa
	0x000fe108, // n0x06b4 c0x0000 (---------------)  +   blogspot
	0x002388c3, // n0x06b5 c0x0000 (---------------)  + I act
	0x002ebf43, // n0x06b6 c0x0000 (---------------)  + I nsw
	0x00201542, // n0x06b7 c0x0000 (---------------)  + I nt
	0x002e7143, // n0x06b8 c0x0000 (---------------)  + I qld
	0x00201002, // n0x06b9 c0x0000 (---------------)  + I sa
	0x00203f83, // n0x06ba c0x0000 (---------------)  + I tas
	0x0020b803, // n0x06bb c0x0000 (---------------)  + I vic
	0x00201c42, // n0x06bc c0x0000 (---------------)  + I wa
	0x002e7143, // n0x06bd c0x0000 (---------------)  + I qld
	0x00201002, // n0x06be c0x0000 (---------------)  + I sa
	0x00203f83, // n0x06bf c0x0000 (---------------)  + I tas
	0x0020b803, // n0x06c0 c0x0000 (---------------)  + I vic
	0x00201c42, // n0x06c1 c0x0000 (---------------)  + I wa
	0x00233243, // n0x06c2 c0x0000 (---------------)  + I com
	0x00331a83, // n0x06c3 c0x0000 (---------------)  + I biz
	0x00233243, // n0x06c4 c0x0000 (---------------)  + I com
	0x00239103, // n0x06c5 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x06c6 c0x0000 (---------------)  + I gov
	0x00201844, // n0x06c7 c0x0000 (---------------)  + I info
	0x00201503, // n0x06c8 c0x0000 (---------------)  + I int
	0x00207dc3, // n0x06c9 c0x0000 (---------------)  + I mil
	0x00200904, // n0x06ca c0x0000 (---------------)  + I name
	0x00223b43, // n0x06cb c0x0000 (---------------)  + I net
	0x00228743, // n0x06cc c0x0000 (---------------)  + I org
	0x002080c2, // n0x06cd c0x0000 (---------------)  + I pp
	0x00224b03, // n0x06ce c0x0000 (---------------)  + I pro
	0x000fe108, // n0x06cf c0x0000 (---------------)  +   blogspot
	0x0020ce42, // n0x06d0 c0x0000 (---------------)  + I co
	0x00233243, // n0x06d1 c0x0000 (---------------)  + I com
	0x00239103, // n0x06d2 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x06d3 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x06d4 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x06d5 c0x0000 (---------------)  + I net
	0x00228743, // n0x06d6 c0x0000 (---------------)  + I org
	0x002006c2, // n0x06d7 c0x0000 (---------------)  + I rs
	0x0024e904, // n0x06d8 c0x0000 (---------------)  + I unbi
	0x00399f44, // n0x06d9 c0x0000 (---------------)  + I unsa
	0x00331a83, // n0x06da c0x0000 (---------------)  + I biz
	0x0020ce42, // n0x06db c0x0000 (---------------)  + I co
	0x00233243, // n0x06dc c0x0000 (---------------)  + I com
	0x00239103, // n0x06dd c0x0000 (---------------)  + I edu
	0x0027d903, // n0x06de c0x0000 (---------------)  + I gov
	0x00201844, // n0x06df c0x0000 (---------------)  + I info
	0x00223b43, // n0x06e0 c0x0000 (---------------)  + I net
	0x00228743, // n0x06e1 c0x0000 (---------------)  + I org
	0x00364cc5, // n0x06e2 c0x0000 (---------------)  + I store
	0x002203c2, // n0x06e3 c0x0000 (---------------)  + I tv
	0x00200342, // n0x06e4 c0x0000 (---------------)  + I ac
	0x000fe108, // n0x06e5 c0x0000 (---------------)  +   blogspot
	0x0027d903, // n0x06e6 c0x0000 (---------------)  + I gov
	0x002314c1, // n0x06e7 c0x0000 (---------------)  + I 0
	0x0022bdc1, // n0x06e8 c0x0000 (---------------)  + I 1
	0x002479c1, // n0x06e9 c0x0000 (---------------)  + I 2
	0x0022ba81, // n0x06ea c0x0000 (---------------)  + I 3
	0x00238c41, // n0x06eb c0x0000 (---------------)  + I 4
	0x0027c701, // n0x06ec c0x0000 (---------------)  + I 5
	0x002142c1, // n0x06ed c0x0000 (---------------)  + I 6
	0x002315c1, // n0x06ee c0x0000 (---------------)  + I 7
	0x00300581, // n0x06ef c0x0000 (---------------)  + I 8
	0x00300641, // n0x06f0 c0x0000 (---------------)  + I 9
	0x002001c1, // n0x06f1 c0x0000 (---------------)  + I a
	0x00200001, // n0x06f2 c0x0000 (---------------)  + I b
	0x000fe108, // n0x06f3 c0x0000 (---------------)  +   blogspot
	0x00200141, // n0x06f4 c0x0000 (---------------)  + I c
	0x00200201, // n0x06f5 c0x0000 (---------------)  + I d
	0x00200081, // n0x06f6 c0x0000 (---------------)  + I e
	0x00201701, // n0x06f7 c0x0000 (---------------)  + I f
	0x00200281, // n0x06f8 c0x0000 (---------------)  + I g
	0x002003c1, // n0x06f9 c0x0000 (---------------)  + I h
	0x00200041, // n0x06fa c0x0000 (---------------)  + I i
	0x002010c1, // n0x06fb c0x0000 (---------------)  + I j
	0x00201b41, // n0x06fc c0x0000 (---------------)  + I k
	0x00200d41, // n0x06fd c0x0000 (---------------)  + I l
	0x00200441, // n0x06fe c0x0000 (---------------)  + I m
	0x00200781, // n0x06ff c0x0000 (---------------)  + I n
	0x00200dc1, // n0x0700 c0x0000 (---------------)  + I o
	0x00200581, // n0x0701 c0x0000 (---------------)  + I p
	0x00200f41, // n0x0702 c0x0000 (---------------)  + I q
	0x002006c1, // n0x0703 c0x0000 (---------------)  + I r
	0x002000c1, // n0x0704 c0x0000 (---------------)  + I s
	0x002004c1, // n0x0705 c0x0000 (---------------)  + I t
	0x00200741, // n0x0706 c0x0000 (---------------)  + I u
	0x00200c01, // n0x0707 c0x0000 (---------------)  + I v
	0x00201c41, // n0x0708 c0x0000 (---------------)  + I w
	0x00200a01, // n0x0709 c0x0000 (---------------)  + I x
	0x00200241, // n0x070a c0x0000 (---------------)  + I y
	0x00200101, // n0x070b c0x0000 (---------------)  + I z
	0x00233243, // n0x070c c0x0000 (---------------)  + I com
	0x00239103, // n0x070d c0x0000 (---------------)  + I edu
	0x0027d903, // n0x070e c0x0000 (---------------)  + I gov
	0x00223b43, // n0x070f c0x0000 (---------------)  + I net
	0x00228743, // n0x0710 c0x0000 (---------------)  + I org
	0x0020ce42, // n0x0711 c0x0000 (---------------)  + I co
	0x00233243, // n0x0712 c0x0000 (---------------)  + I com
	0x00239103, // n0x0713 c0x0000 (---------------)  + I edu
	0x00200dc2, // n0x0714 c0x0000 (---------------)  + I or
	0x00228743, // n0x0715 c0x0000 (---------------)  + I org
	0x00007ec7, // n0x0716 c0x0000 (---------------)  +   dscloud
	0x00013206, // n0x0717 c0x0000 (---------------)  +   dyndns
	0x000568ca, // n0x0718 c0x0000 (---------------)  +   for-better
	0x0008a448, // n0x0719 c0x0000 (---------------)  +   for-more
	0x00056ec8, // n0x071a c0x0000 (---------------)  +   for-some
	0x00057907, // n0x071b c0x0000 (---------------)  +   for-the
	0x0005abc6, // n0x071c c0x0000 (---------------)  +   selfip
	0x001267c6, // n0x071d c0x0000 (---------------)  +   webhop
	0x002d5e84, // n0x071e c0x0000 (---------------)  + I asso
	0x0031c507, // n0x071f c0x0000 (---------------)  + I barreau
	0x000fe108, // n0x0720 c0x0000 (---------------)  +   blogspot
	0x002aebc4, // n0x0721 c0x0000 (---------------)  + I gouv
	0x00233243, // n0x0722 c0x0000 (---------------)  + I com
	0x00239103, // n0x0723 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x0724 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x0725 c0x0000 (---------------)  + I net
	0x00228743, // n0x0726 c0x0000 (---------------)  + I org
	0x00233243, // n0x0727 c0x0000 (---------------)  + I com
	0x00239103, // n0x0728 c0x0000 (---------------)  + I edu
	0x00212b03, // n0x0729 c0x0000 (---------------)  + I gob
	0x0027d903, // n0x072a c0x0000 (---------------)  + I gov
	0x00201503, // n0x072b c0x0000 (---------------)  + I int
	0x00207dc3, // n0x072c c0x0000 (---------------)  + I mil
	0x00223b43, // n0x072d c0x0000 (---------------)  + I net
	0x00228743, // n0x072e c0x0000 (---------------)  + I org
	0x002203c2, // n0x072f c0x0000 (---------------)  + I tv
	0x002c52c3, // n0x0730 c0x0000 (---------------)  + I adm
	0x002da143, // n0x0731 c0x0000 (---------------)  + I adv
	0x00208a43, // n0x0732 c0x0000 (---------------)  + I agr
	0x00200942, // n0x0733 c0x0000 (---------------)  + I am
	0x0024f683, // n0x0734 c0x0000 (---------------)  + I arq
	0x00201d43, // n0x0735 c0x0000 (---------------)  + I art
	0x00211e03, // n0x0736 c0x0000 (---------------)  + I ato
	0x00200001, // n0x0737 c0x0000 (---------------)  + I b
	0x00203e43, // n0x0738 c0x0000 (---------------)  + I bio
	0x0022f084, // n0x0739 c0x0000 (---------------)  + I blog
	0x00311b03, // n0x073a c0x0000 (---------------)  + I bmd
	0x0026b803, // n0x073b c0x0000 (---------------)  + I cim
	0x0021dac3, // n0x073c c0x0000 (---------------)  + I cng
	0x002312c3, // n0x073d c0x0000 (---------------)  + I cnt
	0x0a233243, // n0x073e c0x0028 (n0x0776-n0x0777)  + I com
	0x0023c344, // n0x073f c0x0000 (---------------)  + I coop
	0x0021da83, // n0x0740 c0x0000 (---------------)  + I ecn
	0x0020ce03, // n0x0741 c0x0000 (---------------)  + I eco
	0x00239103, // n0x0742 c0x0000 (---------------)  + I edu
	0x00238e43, // n0x0743 c0x0000 (---------------)  + I emp
	0x00213083, // n0x0744 c0x0000 (---------------)  + I eng
	0x0029c403, // n0x0745 c0x0000 (---------------)  + I esp
	0x0026b783, // n0x0746 c0x0000 (---------------)  + I etc
	0x00226d43, // n0x0747 c0x0000 (---------------)  + I eti
	0x002112c3, // n0x0748 c0x0000 (---------------)  + I far
	0x00252284, // n0x0749 c0x0000 (---------------)  + I flog
	0x00234802, // n0x074a c0x0000 (---------------)  + I fm
	0x00256243, // n0x074b c0x0000 (---------------)  + I fnd
	0x0025c203, // n0x074c c0x0000 (---------------)  + I fot
	0x00277503, // n0x074d c0x0000 (---------------)  + I fst
	0x00329c43, // n0x074e c0x0000 (---------------)  + I g12
	0x00327ec3, // n0x074f c0x0000 (---------------)  + I ggf
	0x0027d903, // n0x0750 c0x0000 (---------------)  + I gov
	0x002c9cc3, // n0x0751 c0x0000 (---------------)  + I imb
	0x00221b03, // n0x0752 c0x0000 (---------------)  + I ind
	0x00201683, // n0x0753 c0x0000 (---------------)  + I inf
	0x0021cc83, // n0x0754 c0x0000 (---------------)  + I jor
	0x002eee83, // n0x0755 c0x0000 (---------------)  + I jus
	0x0022f7c3, // n0x0756 c0x0000 (---------------)  + I leg
	0x002c1303, // n0x0757 c0x0000 (---------------)  + I lel
	0x00200443, // n0x0758 c0x0000 (---------------)  + I mat
	0x00213443, // n0x0759 c0x0000 (---------------)  + I med
	0x00207dc3, // n0x075a c0x0000 (---------------)  + I mil
	0x0022c182, // n0x075b c0x0000 (---------------)  + I mp
	0x002812c3, // n0x075c c0x0000 (---------------)  + I mus
	0x00223b43, // n0x075d c0x0000 (---------------)  + I net
	0x01601383, // n0x075e c0x0005 (---------------)* o I nom
	0x00257ec3, // n0x075f c0x0000 (---------------)  + I not
	0x0022bc43, // n0x0760 c0x0000 (---------------)  + I ntr
	0x00212bc3, // n0x0761 c0x0000 (---------------)  + I odo
	0x00228743, // n0x0762 c0x0000 (---------------)  + I org
	0x00248a83, // n0x0763 c0x0000 (---------------)  + I ppg
	0x00224b03, // n0x0764 c0x0000 (---------------)  + I pro
	0x00232143, // n0x0765 c0x0000 (---------------)  + I psc
	0x002f6a43, // n0x0766 c0x0000 (---------------)  + I psi
	0x002e7303, // n0x0767 c0x0000 (---------------)  + I qsl
	0x00264a45, // n0x0768 c0x0000 (---------------)  + I radio
	0x0022c2c3, // n0x0769 c0x0000 (---------------)  + I rec
	0x002e7343, // n0x076a c0x0000 (---------------)  + I slg
	0x0033b7c3, // n0x076b c0x0000 (---------------)  + I srv
	0x00224104, // n0x076c c0x0000 (---------------)  + I taxi
	0x00337c43, // n0x076d c0x0000 (---------------)  + I teo
	0x00245b03, // n0x076e c0x0000 (---------------)  + I tmp
	0x0036f183, // n0x076f c0x0000 (---------------)  + I trd
	0x00208c03, // n0x0770 c0x0000 (---------------)  + I tur
	0x002203c2, // n0x0771 c0x0000 (---------------)  + I tv
	0x00240683, // n0x0772 c0x0000 (---------------)  + I vet
	0x002f96c4, // n0x0773 c0x0000 (---------------)  + I vlog
	0x0023e984, // n0x0774 c0x0000 (---------------)  + I wiki
	0x0025ca83, // n0x0775 c0x0000 (---------------)  + I zlg
	0x000fe108, // n0x0776 c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x0777 c0x0000 (---------------)  + I com
	0x00239103, // n0x0778 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x0779 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x077a c0x0000 (---------------)  + I net
	0x00228743, // n0x077b c0x0000 (---------------)  + I org
	0x00233243, // n0x077c c0x0000 (---------------)  + I com
	0x00239103, // n0x077d c0x0000 (---------------)  + I edu
	0x0027d903, // n0x077e c0x0000 (---------------)  + I gov
	0x00223b43, // n0x077f c0x0000 (---------------)  + I net
	0x00228743, // n0x0780 c0x0000 (---------------)  + I org
	0x0020ce42, // n0x0781 c0x0000 (---------------)  + I co
	0x00228743, // n0x0782 c0x0000 (---------------)  + I org
	0x0b633243, // n0x0783 c0x002d (n0x0787-n0x0788)  + I com
	0x0027d903, // n0x0784 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x0785 c0x0000 (---------------)  + I mil
	0x0020ce82, // n0x0786 c0x0000 (---------------)  + I of
	0x000fe108, // n0x0787 c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x0788 c0x0000 (---------------)  + I com
	0x00239103, // n0x0789 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x078a c0x0000 (---------------)  + I gov
	0x00223b43, // n0x078b c0x0000 (---------------)  + I net
	0x00228743, // n0x078c c0x0000 (---------------)  + I org
	0x00000182, // n0x078d c0x0000 (---------------)  +   za
	0x00201a02, // n0x078e c0x0000 (---------------)  + I ab
	0x0021e2c2, // n0x078f c0x0000 (---------------)  + I bc
	0x000fe108, // n0x0790 c0x0000 (---------------)  +   blogspot
	0x0000ce42, // n0x0791 c0x0000 (---------------)  +   co
	0x0023ad42, // n0x0792 c0x0000 (---------------)  + I gc
	0x00205a82, // n0x0793 c0x0000 (---------------)  + I mb
	0x00215b02, // n0x0794 c0x0000 (---------------)  + I nb
	0x002016c2, // n0x0795 c0x0000 (---------------)  + I nf
	0x00246d02, // n0x0796 c0x0000 (---------------)  + I nl
	0x0020df42, // n0x0797 c0x0000 (---------------)  + I ns
	0x00201542, // n0x0798 c0x0000 (---------------)  + I nt
	0x00204182, // n0x0799 c0x0000 (---------------)  + I nu
	0x00203a42, // n0x079a c0x0000 (---------------)  + I on
	0x00200582, // n0x079b c0x0000 (---------------)  + I pe
	0x0037bf42, // n0x079c c0x0000 (---------------)  + I qc
	0x00208502, // n0x079d c0x0000 (---------------)  + I sk
	0x00225782, // n0x079e c0x0000 (---------------)  + I yk
	0x00120b09, // n0x079f c0x0000 (---------------)  +   ftpaccess
	0x0017248b, // n0x07a0 c0x0000 (---------------)  +   game-server
	0x000d2788, // n0x07a1 c0x0000 (---------------)  +   myphotos
	0x00045689, // n0x07a2 c0x0000 (---------------)  +   scrapping
	0x0027d903, // n0x07a3 c0x0000 (---------------)  + I gov
	0x000fe108, // n0x07a4 c0x0000 (---------------)  +   blogspot
	0x000fe108, // n0x07a5 c0x0000 (---------------)  +   blogspot
	0x00200342, // n0x07a6 c0x0000 (---------------)  + I ac
	0x002d5e84, // n0x07a7 c0x0000 (---------------)  + I asso
	0x0020ce42, // n0x07a8 c0x0000 (---------------)  + I co
	0x00233243, // n0x07a9 c0x0000 (---------------)  + I com
	0x002024c2, // n0x07aa c0x0000 (---------------)  + I ed
	0x00239103, // n0x07ab c0x0000 (---------------)  + I edu
	0x00210a42, // n0x07ac c0x0000 (---------------)  + I go
	0x002aebc4, // n0x07ad c0x0000 (---------------)  + I gouv
	0x00201503, // n0x07ae c0x0000 (---------------)  + I int
	0x0024dd82, // n0x07af c0x0000 (---------------)  + I md
	0x00223b43, // n0x07b0 c0x0000 (---------------)  + I net
	0x00200dc2, // n0x07b1 c0x0000 (---------------)  + I or
	0x00228743, // n0x07b2 c0x0000 (---------------)  + I org
	0x00246a06, // n0x07b3 c0x0000 (---------------)  + I presse
	0x0030facf, // n0x07b4 c0x0000 (---------------)  + I xn--aroport-bya
	0x006ffb43, // n0x07b5 c0x0001 (---------------)  ! I www
	0x000fe108, // n0x07b6 c0x0000 (---------------)  +   blogspot
	0x0020ce42, // n0x07b7 c0x0000 (---------------)  + I co
	0x00212b03, // n0x07b8 c0x0000 (---------------)  + I gob
	0x0027d903, // n0x07b9 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x07ba c0x0000 (---------------)  + I mil
	0x0020ce42, // n0x07bb c0x0000 (---------------)  + I co
	0x00233243, // n0x07bc c0x0000 (---------------)  + I com
	0x0027d903, // n0x07bd c0x0000 (---------------)  + I gov
	0x00223b43, // n0x07be c0x0000 (---------------)  + I net
	0x00200342, // n0x07bf c0x0000 (---------------)  + I ac
	0x00205702, // n0x07c0 c0x0000 (---------------)  + I ah
	0x0e6f1ec9, // n0x07c1 c0x0039 (n0x07ec-n0x07ed)  o I amazonaws
	0x0020b442, // n0x07c2 c0x0000 (---------------)  + I bj
	0x0ee33243, // n0x07c3 c0x003b (n0x07ee-n0x07ef)  + I com
	0x00242e82, // n0x07c4 c0x0000 (---------------)  + I cq
	0x00239103, // n0x07c5 c0x0000 (---------------)  + I edu
	0x0021cc42, // n0x07c6 c0x0000 (---------------)  + I fj
	0x002265c2, // n0x07c7 c0x0000 (---------------)  + I gd
	0x0027d903, // n0x07c8 c0x0000 (---------------)  + I gov
	0x00245dc2, // n0x07c9 c0x0000 (---------------)  + I gs
	0x00253302, // n0x07ca c0x0000 (---------------)  + I gx
	0x0025ca42, // n0x07cb c0x0000 (---------------)  + I gz
	0x00202302, // n0x07cc c0x0000 (---------------)  + I ha
	0x0028ea42, // n0x07cd c0x0000 (---------------)  + I hb
	0x002069c2, // n0x07ce c0x0000 (---------------)  + I he
	0x002003c2, // n0x07cf c0x0000 (---------------)  + I hi
	0x0020c482, // n0x07d0 c0x0000 (---------------)  + I hk
	0x002484c2, // n0x07d1 c0x0000 (---------------)  + I hl
	0x0021c682, // n0x07d2 c0x0000 (---------------)  + I hn
	0x002add82, // n0x07d3 c0x0000 (---------------)  + I jl
	0x00233742, // n0x07d4 c0x0000 (---------------)  + I js
	0x00231382, // n0x07d5 c0x0000 (---------------)  + I jx
	0x00229282, // n0x07d6 c0x0000 (---------------)  + I ln
	0x00207dc3, // n0x07d7 c0x0000 (---------------)  + I mil
	0x00208442, // n0x07d8 c0x0000 (---------------)  + I mo
	0x00223b43, // n0x07d9 c0x0000 (---------------)  + I net
	0x0022b882, // n0x07da c0x0000 (---------------)  + I nm
	0x00268e82, // n0x07db c0x0000 (---------------)  + I nx
	0x00228743, // n0x07dc c0x0000 (---------------)  + I org
	0x0024f702, // n0x07dd c0x0000 (---------------)  + I qh
	0x00207f02, // n0x07de c0x0000 (---------------)  + I sc
	0x0022b2c2, // n0x07df c0x0000 (---------------)  + I sd
	0x00201242, // n0x07e0 c0x0000 (---------------)  + I sh
	0x00214b82, // n0x07e1 c0x0000 (---------------)  + I sn
	0x002edb02, // n0x07e2 c0x0000 (---------------)  + I sx
	0x00231342, // n0x07e3 c0x0000 (---------------)  + I tj
	0x002534c2, // n0x07e4 c0x0000 (---------------)  + I tw
	0x003a5242, // n0x07e5 c0x0000 (---------------)  + I xj
	0x0030394a, // n0x07e6 c0x0000 (---------------)  + I xn--55qx5d
	0x0034278a, // n0x07e7 c0x0000 (---------------)  + I xn--io0a7i
	0x0037530a, // n0x07e8 c0x0000 (---------------)  + I xn--od0alg
	0x003a5dc2, // n0x07e9 c0x0000 (---------------)  + I xz
	0x00212fc2, // n0x07ea c0x0000 (---------------)  + I yn
	0x00246c02, // n0x07eb c0x0000 (---------------)  + I zj
	0x0e8358c7, // n0x07ec c0x003a (n0x07ed-n0x07ee)  +   compute
	0x00179d0a, // n0x07ed c0x0000 (---------------)  +   cn-north-1
	0x0f2f1ec9, // n0x07ee c0x003c (n0x07ef-n0x07f0)  o I amazonaws
	0x0f779d0a, // n0x07ef c0x003d (n0x07f0-n0x07f1)  o I cn-north-1
	0x0002ba42, // n0x07f0 c0x0000 (---------------)  +   s3
	0x0024b944, // n0x07f1 c0x0000 (---------------)  + I arts
	0x0fe33243, // n0x07f2 c0x003f (n0x07fe-n0x07ff)  + I com
	0x00239103, // n0x07f3 c0x0000 (---------------)  + I edu
	0x0024dcc4, // n0x07f4 c0x0000 (---------------)  + I firm
	0x0027d903, // n0x07f5 c0x0000 (---------------)  + I gov
	0x00201844, // n0x07f6 c0x0000 (---------------)  + I info
	0x00201503, // n0x07f7 c0x0000 (---------------)  + I int
	0x00207dc3, // n0x07f8 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x07f9 c0x0000 (---------------)  + I net
	0x00201383, // n0x07fa c0x0000 (---------------)  + I nom
	0x00228743, // n0x07fb c0x0000 (---------------)  + I org
	0x0022c2c3, // n0x07fc c0x0000 (---------------)  + I rec
	0x0021e243, // n0x07fd c0x0000 (---------------)  + I web
	0x000fe108, // n0x07fe c0x0000 (---------------)  +   blogspot
	0x0006c185, // n0x07ff c0x0000 (---------------)  +   1kapp
	0x0010c982, // n0x0800 c0x0000 (---------------)  +   4u
	0x00174cc6, // n0x0801 c0x0000 (---------------)  +   africa
	0x106f1ec9, // n0x0802 c0x0041 (n0x08d1-n0x08e3)  o I amazonaws
	0x00008087, // n0x0803 c0x0000 (---------------)  +   appspot
	0x00001d42, // n0x0804 c0x0000 (---------------)  +   ar
	0x0019d10a, // n0x0805 c0x0000 (---------------)  +   betainabox
	0x0002f087, // n0x0806 c0x0000 (---------------)  +   blogdns
	0x000fe108, // n0x0807 c0x0000 (---------------)  +   blogspot
	0x0001e3c2, // n0x0808 c0x0000 (---------------)  +   br
	0x00138747, // n0x0809 c0x0000 (---------------)  +   cechire
	0x0019458f, // n0x080a c0x0000 (---------------)  +   cloudcontrolapp
	0x000f44cf, // n0x080b c0x0000 (---------------)  +   cloudcontrolled
	0x0001dac2, // n0x080c c0x0000 (---------------)  +   cn
	0x0000ce42, // n0x080d c0x0000 (---------------)  +   co
	0x0009c348, // n0x080e c0x0000 (---------------)  +   codespot
	0x00005582, // n0x080f c0x0000 (---------------)  +   de
	0x00142e48, // n0x0810 c0x0000 (---------------)  +   dnsalias
	0x0007cf07, // n0x0811 c0x0000 (---------------)  +   dnsdojo
	0x0001580b, // n0x0812 c0x0000 (---------------)  +   doesntexist
	0x0016a789, // n0x0813 c0x0000 (---------------)  +   dontexist
	0x00142d47, // n0x0814 c0x0000 (---------------)  +   doomdns
	0x000efc0c, // n0x0815 c0x0000 (---------------)  +   dreamhosters
	0x0013c907, // n0x0816 c0x0000 (---------------)  +   dsmynas
	0x0012394a, // n0x0817 c0x0000 (---------------)  +   dyn-o-saur
	0x00197108, // n0x0818 c0x0000 (---------------)  +   dynalias
	0x00073a8e, // n0x0819 c0x0000 (---------------)  +   dyndns-at-home
	0x000db90e, // n0x081a c0x0000 (---------------)  +   dyndns-at-work
	0x0002eecb, // n0x081b c0x0000 (---------------)  +   dyndns-blog
	0x000e7ecb, // n0x081c c0x0000 (---------------)  +   dyndns-free
	0x0001320b, // n0x081d c0x0000 (---------------)  +   dyndns-home
	0x00014089, // n0x081e c0x0000 (---------------)  +   dyndns-ip
	0x00018acb, // n0x081f c0x0000 (---------------)  +   dyndns-mail
	0x0001dd0d, // n0x0820 c0x0000 (---------------)  +   dyndns-office
	0x0002144b, // n0x0821 c0x0000 (---------------)  +   dyndns-pics
	0x000251cd, // n0x0822 c0x0000 (---------------)  +   dyndns-remote
	0x0002e54d, // n0x0823 c0x0000 (---------------)  +   dyndns-server
	0x0002f9ca, // n0x0824 c0x0000 (---------------)  +   dyndns-web
	0x0003e7cb, // n0x0825 c0x0000 (---------------)  +   dyndns-wiki
	0x00156ecb, // n0x0826 c0x0000 (---------------)  +   dyndns-work
	0x00022a90, // n0x0827 c0x0000 (---------------)  +   elasticbeanstalk
	0x000b7d0f, // n0x0828 c0x0000 (---------------)  +   est-a-la-maison
	0x00008f0f, // n0x0829 c0x0000 (---------------)  +   est-a-la-masion
	0x001574cd, // n0x082a c0x0000 (---------------)  +   est-le-patron
	0x0007b810, // n0x082b c0x0000 (---------------)  +   est-mon-blogueur
	0x00005382, // n0x082c c0x0000 (---------------)  +   eu
	0x00007d48, // n0x082d c0x0000 (---------------)  +   familyds
	0x0004c58b, // n0x082e c0x0000 (---------------)  +   firebaseapp
	0x00054ec8, // n0x082f c0x0000 (---------------)  +   flynnhub
	0x00062387, // n0x0830 c0x0000 (---------------)  +   from-ak
	0x000626c7, // n0x0831 c0x0000 (---------------)  +   from-al
	0x00062887, // n0x0832 c0x0000 (---------------)  +   from-ar
	0x00063547, // n0x0833 c0x0000 (---------------)  +   from-ca
	0x00064007, // n0x0834 c0x0000 (---------------)  +   from-ct
	0x00064607, // n0x0835 c0x0000 (---------------)  +   from-dc
	0x00065347, // n0x0836 c0x0000 (---------------)  +   from-de
	0x00065887, // n0x0837 c0x0000 (---------------)  +   from-fl
	0x000668c7, // n0x0838 c0x0000 (---------------)  +   from-ga
	0x00066c47, // n0x0839 c0x0000 (---------------)  +   from-hi
	0x000674c7, // n0x083a c0x0000 (---------------)  +   from-ia
	0x00067687, // n0x083b c0x0000 (---------------)  +   from-id
	0x00067847, // n0x083c c0x0000 (---------------)  +   from-il
	0x00067a07, // n0x083d c0x0000 (---------------)  +   from-in
	0x00067d07, // n0x083e c0x0000 (---------------)  +   from-ks
	0x00068107, // n0x083f c0x0000 (---------------)  +   from-ky
	0x00068cc7, // n0x0840 c0x0000 (---------------)  +   from-ma
	0x00069187, // n0x0841 c0x0000 (---------------)  +   from-md
	0x00069707, // n0x0842 c0x0000 (---------------)  +   from-mi
	0x0006d147, // n0x0843 c0x0000 (---------------)  +   from-mn
	0x0006d307, // n0x0844 c0x0000 (---------------)  +   from-mo
	0x0006d607, // n0x0845 c0x0000 (---------------)  +   from-ms
	0x0006da07, // n0x0846 c0x0000 (---------------)  +   from-mt
	0x0006dc07, // n0x0847 c0x0000 (---------------)  +   from-nc
	0x0006e907, // n0x0848 c0x0000 (---------------)  +   from-nd
	0x0006eac7, // n0x0849 c0x0000 (---------------)  +   from-ne
	0x0006eec7, // n0x084a c0x0000 (---------------)  +   from-nh
	0x0006f607, // n0x084b c0x0000 (---------------)  +   from-nj
	0x0006fac7, // n0x084c c0x0000 (---------------)  +   from-nm
	0x00070587, // n0x084d c0x0000 (---------------)  +   from-nv
	0x00070b87, // n0x084e c0x0000 (---------------)  +   from-oh
	0x00070e47, // n0x084f c0x0000 (---------------)  +   from-ok
	0x000711c7, // n0x0850 c0x0000 (---------------)  +   from-or
	0x00071387, // n0x0851 c0x0000 (---------------)  +   from-pa
	0x00071707, // n0x0852 c0x0000 (---------------)  +   from-pr
	0x00071d87, // n0x0853 c0x0000 (---------------)  +   from-ri
	0x00072207, // n0x0854 c0x0000 (---------------)  +   from-sc
	0x00072607, // n0x0855 c0x0000 (---------------)  +   from-sd
	0x00072e07, // n0x0856 c0x0000 (---------------)  +   from-tn
	0x00072fc7, // n0x0857 c0x0000 (---------------)  +   from-tx
	0x00073407, // n0x0858 c0x0000 (---------------)  +   from-ut
	0x00074407, // n0x0859 c0x0000 (---------------)  +   from-va
	0x00074a47, // n0x085a c0x0000 (---------------)  +   from-vt
	0x00074d47, // n0x085b c0x0000 (---------------)  +   from-wa
	0x00074f07, // n0x085c c0x0000 (---------------)  +   from-wi
	0x00075287, // n0x085d c0x0000 (---------------)  +   from-wv
	0x00076407, // n0x085e c0x0000 (---------------)  +   from-wy
	0x0000e482, // n0x085f c0x0000 (---------------)  +   gb
	0x000d5a87, // n0x0860 c0x0000 (---------------)  +   getmyip
	0x000cbb91, // n0x0861 c0x0000 (---------------)  +   githubusercontent
	0x000df04a, // n0x0862 c0x0000 (---------------)  +   googleapis
	0x0009c1ca, // n0x0863 c0x0000 (---------------)  +   googlecode
	0x00058186, // n0x0864 c0x0000 (---------------)  +   gotdns
	0x00010a4b, // n0x0865 c0x0000 (---------------)  +   gotpantheon
	0x00008a82, // n0x0866 c0x0000 (---------------)  +   gr
	0x0009cf49, // n0x0867 c0x0000 (---------------)  +   herokuapp
	0x00093209, // n0x0868 c0x0000 (---------------)  +   herokussl
	0x0000c482, // n0x0869 c0x0000 (---------------)  +   hk
	0x0014a8ca, // n0x086a c0x0000 (---------------)  +   hobby-site
	0x000a6dc9, // n0x086b c0x0000 (---------------)  +   homelinux
	0x000a8148, // n0x086c c0x0000 (---------------)  +   homeunix
	0x00024202, // n0x086d c0x0000 (---------------)  +   hu
	0x00119609, // n0x086e c0x0000 (---------------)  +   iamallama
	0x0016cf4e, // n0x086f c0x0000 (---------------)  +   is-a-anarchist
	0x000a550c, // n0x0870 c0x0000 (---------------)  +   is-a-blogger
	0x000d3b8f, // n0x0871 c0x0000 (---------------)  +   is-a-bookkeeper
	0x0018ac0e, // n0x0872 c0x0000 (---------------)  +   is-a-bulls-fan
	0x0000f08c, // n0x0873 c0x0000 (---------------)  +   is-a-caterer
	0x000110c9, // n0x0874 c0x0000 (---------------)  +   is-a-chef
	0x00014711, // n0x0875 c0x0000 (---------------)  +   is-a-conservative
	0x00016788, // n0x0876 c0x0000 (---------------)  +   is-a-cpa
	0x0001fdd2, // n0x0877 c0x0000 (---------------)  +   is-a-cubicle-slave
	0x000244cd, // n0x0878 c0x0000 (---------------)  +   is-a-democrat
	0x000280cd, // n0x0879 c0x0000 (---------------)  +   is-a-designer
	0x0016894b, // n0x087a c0x0000 (---------------)  +   is-a-doctor
	0x000d9dd5, // n0x087b c0x0000 (---------------)  +   is-a-financialadvisor
	0x0004ef49, // n0x087c c0x0000 (---------------)  +   is-a-geek
	0x0005200a, // n0x087d c0x0000 (---------------)  +   is-a-green
	0x00053949, // n0x087e c0x0000 (---------------)  +   is-a-guru
	0x0005b990, // n0x087f c0x0000 (---------------)  +   is-a-hard-worker
	0x0006434b, // n0x0880 c0x0000 (---------------)  +   is-a-hunter
	0x0006640f, // n0x0881 c0x0000 (---------------)  +   is-a-landscaper
	0x00071acb, // n0x0882 c0x0000 (---------------)  +   is-a-lawyer
	0x00071f0c, // n0x0883 c0x0000 (---------------)  +   is-a-liberal
	0x00074010, // n0x0884 c0x0000 (---------------)  +   is-a-libertarian
	0x0008080a, // n0x0885 c0x0000 (---------------)  +   is-a-llama
	0x0008118d, // n0x0886 c0x0000 (---------------)  +   is-a-musician
	0x0008b00e, // n0x0887 c0x0000 (---------------)  +   is-a-nascarfan
	0x00143b4a, // n0x0888 c0x0000 (---------------)  +   is-a-nurse
	0x0008c5cc, // n0x0889 c0x0000 (---------------)  +   is-a-painter
	0x000995d4, // n0x088a c0x0000 (---------------)  +   is-a-personaltrainer
	0x0009cbd1, // n0x088b c0x0000 (---------------)  +   is-a-photographer
	0x0009ff8b, // n0x088c c0x0000 (---------------)  +   is-a-player
	0x000a0d0f, // n0x088d c0x0000 (---------------)  +   is-a-republican
	0x000a270d, // n0x088e c0x0000 (---------------)  +   is-a-rockstar
	0x000a4e8e, // n0x088f c0x0000 (---------------)  +   is-a-socialist
	0x000ac80c, // n0x0890 c0x0000 (---------------)  +   is-a-student
	0x000acf4c, // n0x0891 c0x0000 (---------------)  +   is-a-teacher
	0x000d004b, // n0x0892 c0x0000 (---------------)  +   is-a-techie
	0x000d034e, // n0x0893 c0x0000 (---------------)  +   is-a-therapist
	0x000cf950, // n0x0894 c0x0000 (---------------)  +   is-an-accountant
	0x000bbf0b, // n0x0895 c0x0000 (---------------)  +   is-an-actor
	0x000cf44d, // n0x0896 c0x0000 (---------------)  +   is-an-actress
	0x0014b44f, // n0x0897 c0x0000 (---------------)  +   is-an-anarchist
	0x0013ba8c, // n0x0898 c0x0000 (---------------)  +   is-an-artist
	0x0010c34e, // n0x0899 c0x0000 (---------------)  +   is-an-engineer
	0x00169751, // n0x089a c0x0000 (---------------)  +   is-an-entertainer
	0x000b47cc, // n0x089b c0x0000 (---------------)  +   is-certified
	0x000ba5c7, // n0x089c c0x0000 (---------------)  +   is-gone
	0x000bb94d, // n0x089d c0x0000 (---------------)  +   is-into-anime
	0x000bd18c, // n0x089e c0x0000 (---------------)  +   is-into-cars
	0x000fc8d0, // n0x089f c0x0000 (---------------)  +   is-into-cartoons
	0x00145b8d, // n0x08a0 c0x0000 (---------------)  +   is-into-games
	0x0016f007, // n0x08a1 c0x0000 (---------------)  +   is-leet
	0x00173bd0, // n0x08a2 c0x0000 (---------------)  +   is-not-certified
	0x000f2bc8, // n0x08a3 c0x0000 (---------------)  +   is-slick
	0x000e984b, // n0x08a4 c0x0000 (---------------)  +   is-uberleet
	0x001429cf, // n0x08a5 c0x0000 (---------------)  +   is-with-theband
	0x000862c8, // n0x08a6 c0x0000 (---------------)  +   isa-geek
	0x000df24d, // n0x08a7 c0x0000 (---------------)  +   isa-hockeynut
	0x0014dcd0, // n0x08a8 c0x0000 (---------------)  +   issmarterthanyou
	0x000b0a83, // n0x08a9 c0x0000 (---------------)  +   jpn
	0x0000bdc2, // n0x08aa c0x0000 (---------------)  +   kr
	0x00058c89, // n0x08ab c0x0000 (---------------)  +   likes-pie
	0x0007388a, // n0x08ac c0x0000 (---------------)  +   likescandy
	0x00000983, // n0x08ad c0x0000 (---------------)  +   mex
	0x0010d047, // n0x08ae c0x0000 (---------------)  +   mydrobo
	0x00119d48, // n0x08af c0x0000 (---------------)  +   neat-url
	0x0016c0c7, // n0x08b0 c0x0000 (---------------)  +   nfshost
	0x00001382, // n0x08b1 c0x0000 (---------------)  +   no
	0x00064bca, // n0x08b2 c0x0000 (---------------)  +   operaunite
	0x0019430f, // n0x08b3 c0x0000 (---------------)  +   outsystemscloud
	0x0012690c, // n0x08b4 c0x0000 (---------------)  +   pagefrontapp
	0x00126bd2, // n0x08b5 c0x0000 (---------------)  +   pagespeedmobilizer
	0x116e1185, // n0x08b6 c0x0045 (n0x08ef-n0x08f0)  o I prgmr
	0x00116bc3, // n0x08b7 c0x0000 (---------------)  +   qa2
	0x0017bf42, // n0x08b8 c0x0000 (---------------)  +   qc
	0x00127bc8, // n0x08b9 c0x0000 (---------------)  +   rackmaze
	0x000f4447, // n0x08ba c0x0000 (---------------)  +   rhcloud
	0x000020c2, // n0x08bb c0x0000 (---------------)  +   ro
	0x0000fe82, // n0x08bc c0x0000 (---------------)  +   ru
	0x00001002, // n0x08bd c0x0000 (---------------)  +   sa
	0x00187d50, // n0x08be c0x0000 (---------------)  +   saves-the-whales
	0x00004ec2, // n0x08bf c0x0000 (---------------)  +   se
	0x0005abc6, // n0x08c0 c0x0000 (---------------)  +   selfip
	0x0004d00e, // n0x08c1 c0x0000 (---------------)  +   sells-for-less
	0x0008e5cb, // n0x08c2 c0x0000 (---------------)  +   sells-for-u
	0x000ccd88, // n0x08c3 c0x0000 (---------------)  +   servebbs
	0x000ca1ca, // n0x08c4 c0x0000 (---------------)  +   simple-url
	0x000f6a87, // n0x08c5 c0x0000 (---------------)  +   sinaapp
	0x0000aa8d, // n0x08c6 c0x0000 (---------------)  +   space-to-rent
	0x00152a4c, // n0x08c7 c0x0000 (---------------)  +   teaches-yoga
	0x00001b02, // n0x08c8 c0x0000 (---------------)  +   uk
	0x00002242, // n0x08c9 c0x0000 (---------------)  +   us
	0x000041c2, // n0x08ca c0x0000 (---------------)  +   uy
	0x000f69ca, // n0x08cb c0x0000 (---------------)  +   vipsinaapp
	0x000def4a, // n0x08cc c0x0000 (---------------)  +   withgoogle
	0x000e548b, // n0x08cd c0x0000 (---------------)  +   withyoutube
	0x000fde8e, // n0x08ce c0x0000 (---------------)  +   writesthisblog
	0x000d80c8, // n0x08cf c0x0000 (---------------)  +   yolasite
	0x00000182, // n0x08d0 c0x0000 (---------------)  +   za
	0x108358c7, // n0x08d1 c0x0042 (n0x08e3-n0x08ec)  +   compute
	0x10c358c9, // n0x08d2 c0x0043 (n0x08ec-n0x08ee)  +   compute-1
	0x000123c3, // n0x08d3 c0x0000 (---------------)  +   elb
	0x1122bb0c, // n0x08d4 c0x0044 (n0x08ee-n0x08ef)  o I eu-central-1
	0x0002ba42, // n0x08d5 c0x0000 (---------------)  +   s3
	0x0006cd11, // n0x08d6 c0x0000 (---------------)  +   s3-ap-northeast-1
	0x0006bd91, // n0x08d7 c0x0000 (---------------)  +   s3-ap-southeast-1
	0x000f5791, // n0x08d8 c0x0000 (---------------)  +   s3-ap-southeast-2
	0x0002ba4f, // n0x08d9 c0x0000 (---------------)  +   s3-eu-central-1
	0x00055f4c, // n0x08da c0x0000 (---------------)  +   s3-eu-west-1
	0x000dd0cd, // n0x08db c0x0000 (---------------)  +   s3-external-1
	0x0011358d, // n0x08dc c0x0000 (---------------)  +   s3-external-2
	0x00121cd5, // n0x08dd c0x0000 (---------------)  +   s3-fips-us-gov-west-1
	0x00123d0c, // n0x08de c0x0000 (---------------)  +   s3-sa-east-1
	0x0016c590, // n0x08df c0x0000 (---------------)  +   s3-us-gov-west-1
	0x000e3acc, // n0x08e0 c0x0000 (---------------)  +   s3-us-west-1
	0x000c330c, // n0x08e1 c0x0000 (---------------)  +   s3-us-west-2
	0x0003ef09, // n0x08e2 c0x0000 (---------------)  +   us-east-1
	0x0006cdce, // n0x08e3 c0x0000 (---------------)  +   ap-northeast-1
	0x0006be4e, // n0x08e4 c0x0000 (---------------)  +   ap-southeast-1
	0x000f584e, // n0x08e5 c0x0000 (---------------)  +   ap-southeast-2
	0x0002bb0c, // n0x08e6 c0x0000 (---------------)  +   eu-central-1
	0x00056009, // n0x08e7 c0x0000 (---------------)  +   eu-west-1
	0x00123dc9, // n0x08e8 c0x0000 (---------------)  +   sa-east-1
	0x00121ecd, // n0x08e9 c0x0000 (---------------)  +   us-gov-west-1
	0x000e3b89, // n0x08ea c0x0000 (---------------)  +   us-west-1
	0x000c33c9, // n0x08eb c0x0000 (---------------)  +   us-west-2
	0x00155a83, // n0x08ec c0x0000 (---------------)  +   z-1
	0x0013e483, // n0x08ed c0x0000 (---------------)  +   z-2
	0x0002ba42, // n0x08ee c0x0000 (---------------)  +   s3
	0x000196c3, // n0x08ef c0x0000 (---------------)  +   xen
	0x00200342, // n0x08f0 c0x0000 (---------------)  + I ac
	0x0020ce42, // n0x08f1 c0x0000 (---------------)  + I co
	0x002024c2, // n0x08f2 c0x0000 (---------------)  + I ed
	0x00201702, // n0x08f3 c0x0000 (---------------)  + I fi
	0x00210a42, // n0x08f4 c0x0000 (---------------)  + I go
	0x00200dc2, // n0x08f5 c0x0000 (---------------)  + I or
	0x00201002, // n0x08f6 c0x0000 (---------------)  + I sa
	0x00233243, // n0x08f7 c0x0000 (---------------)  + I com
	0x00239103, // n0x08f8 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x08f9 c0x0000 (---------------)  + I gov
	0x00201683, // n0x08fa c0x0000 (---------------)  + I inf
	0x00223b43, // n0x08fb c0x0000 (---------------)  + I net
	0x00228743, // n0x08fc c0x0000 (---------------)  + I org
	0x000fe108, // n0x08fd c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x08fe c0x0000 (---------------)  + I com
	0x00239103, // n0x08ff c0x0000 (---------------)  + I edu
	0x00223b43, // n0x0900 c0x0000 (---------------)  + I net
	0x00228743, // n0x0901 c0x0000 (---------------)  + I org
	0x0003cfc3, // n0x0902 c0x0000 (---------------)  +   ath
	0x0027d903, // n0x0903 c0x0000 (---------------)  + I gov
	0x00200342, // n0x0904 c0x0000 (---------------)  + I ac
	0x00331a83, // n0x0905 c0x0000 (---------------)  + I biz
	0x13233243, // n0x0906 c0x004c (n0x0911-n0x0912)  + I com
	0x00279fc7, // n0x0907 c0x0000 (---------------)  + I ekloges
	0x0027d903, // n0x0908 c0x0000 (---------------)  + I gov
	0x00312883, // n0x0909 c0x0000 (---------------)  + I ltd
	0x00200904, // n0x090a c0x0000 (---------------)  + I name
	0x00223b43, // n0x090b c0x0000 (---------------)  + I net
	0x00228743, // n0x090c c0x0000 (---------------)  + I org
	0x0028458a, // n0x090d c0x0000 (---------------)  + I parliament
	0x00246a05, // n0x090e c0x0000 (---------------)  + I press
	0x00224b03, // n0x090f c0x0000 (---------------)  + I pro
	0x00200c82, // n0x0910 c0x0000 (---------------)  + I tm
	0x000fe108, // n0x0911 c0x0000 (---------------)  +   blogspot
	0x000fe108, // n0x0912 c0x0000 (---------------)  +   blogspot
	0x0000ce42, // n0x0913 c0x0000 (---------------)  +   co
	0x000fe108, // n0x0914 c0x0000 (---------------)  +   blogspot
	0x00033243, // n0x0915 c0x0000 (---------------)  +   com
	0x000fce0f, // n0x0916 c0x0000 (---------------)  +   fuettertdasnetz
	0x0016a90a, // n0x0917 c0x0000 (---------------)  +   isteingeek
	0x000a5147, // n0x0918 c0x0000 (---------------)  +   istmein
	0x000239ca, // n0x0919 c0x0000 (---------------)  +   lebtimnetz
	0x00097c0a, // n0x091a c0x0000 (---------------)  +   leitungsen
	0x000052cd, // n0x091b c0x0000 (---------------)  +   traeumtgerade
	0x000fe108, // n0x091c c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x091d c0x0000 (---------------)  + I com
	0x00239103, // n0x091e c0x0000 (---------------)  + I edu
	0x0027d903, // n0x091f c0x0000 (---------------)  + I gov
	0x00223b43, // n0x0920 c0x0000 (---------------)  + I net
	0x00228743, // n0x0921 c0x0000 (---------------)  + I org
	0x00201d43, // n0x0922 c0x0000 (---------------)  + I art
	0x00233243, // n0x0923 c0x0000 (---------------)  + I com
	0x00239103, // n0x0924 c0x0000 (---------------)  + I edu
	0x00212b03, // n0x0925 c0x0000 (---------------)  + I gob
	0x0027d903, // n0x0926 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x0927 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x0928 c0x0000 (---------------)  + I net
	0x00228743, // n0x0929 c0x0000 (---------------)  + I org
	0x002933c3, // n0x092a c0x0000 (---------------)  + I sld
	0x0021e243, // n0x092b c0x0000 (---------------)  + I web
	0x00201d43, // n0x092c c0x0000 (---------------)  + I art
	0x002d5e84, // n0x092d c0x0000 (---------------)  + I asso
	0x00233243, // n0x092e c0x0000 (---------------)  + I com
	0x00239103, // n0x092f c0x0000 (---------------)  + I edu
	0x0027d903, // n0x0930 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x0931 c0x0000 (---------------)  + I net
	0x00228743, // n0x0932 c0x0000 (---------------)  + I org
	0x00206ec3, // n0x0933 c0x0000 (---------------)  + I pol
	0x00233243, // n0x0934 c0x0000 (---------------)  + I com
	0x00239103, // n0x0935 c0x0000 (---------------)  + I edu
	0x00201703, // n0x0936 c0x0000 (---------------)  + I fin
	0x00212b03, // n0x0937 c0x0000 (---------------)  + I gob
	0x0027d903, // n0x0938 c0x0000 (---------------)  + I gov
	0x00201844, // n0x0939 c0x0000 (---------------)  + I info
	0x00332603, // n0x093a c0x0000 (---------------)  + I k12
	0x00213443, // n0x093b c0x0000 (---------------)  + I med
	0x00207dc3, // n0x093c c0x0000 (---------------)  + I mil
	0x00223b43, // n0x093d c0x0000 (---------------)  + I net
	0x00228743, // n0x093e c0x0000 (---------------)  + I org
	0x00224b03, // n0x093f c0x0000 (---------------)  + I pro
	0x00200503, // n0x0940 c0x0000 (---------------)  + I aip
	0x15633243, // n0x0941 c0x0055 (n0x094a-n0x094b)  + I com
	0x00239103, // n0x0942 c0x0000 (---------------)  + I edu
	0x002b49c3, // n0x0943 c0x0000 (---------------)  + I fie
	0x0027d903, // n0x0944 c0x0000 (---------------)  + I gov
	0x00272043, // n0x0945 c0x0000 (---------------)  + I lib
	0x00213443, // n0x0946 c0x0000 (---------------)  + I med
	0x00228743, // n0x0947 c0x0000 (---------------)  + I org
	0x00204e03, // n0x0948 c0x0000 (---------------)  + I pri
	0x0030a104, // n0x0949 c0x0000 (---------------)  + I riik
	0x000fe108, // n0x094a c0x0000 (---------------)  +   blogspot
	0x15e33243, // n0x094b c0x0057 (n0x0954-n0x0955)  + I com
	0x00239103, // n0x094c c0x0000 (---------------)  + I edu
	0x002a8203, // n0x094d c0x0000 (---------------)  + I eun
	0x0027d903, // n0x094e c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x094f c0x0000 (---------------)  + I mil
	0x00200904, // n0x0950 c0x0000 (---------------)  + I name
	0x00223b43, // n0x0951 c0x0000 (---------------)  + I net
	0x00228743, // n0x0952 c0x0000 (---------------)  + I org
	0x00221983, // n0x0953 c0x0000 (---------------)  + I sci
	0x000fe108, // n0x0954 c0x0000 (---------------)  +   blogspot
	0x16633243, // n0x0955 c0x0059 (n0x095a-n0x095b)  + I com
	0x00239103, // n0x0956 c0x0000 (---------------)  + I edu
	0x00212b03, // n0x0957 c0x0000 (---------------)  + I gob
	0x00201383, // n0x0958 c0x0000 (---------------)  + I nom
	0x00228743, // n0x0959 c0x0000 (---------------)  + I org
	0x000fe108, // n0x095a c0x0000 (---------------)  +   blogspot
	0x00331a83, // n0x095b c0x0000 (---------------)  + I biz
	0x00233243, // n0x095c c0x0000 (---------------)  + I com
	0x00239103, // n0x095d c0x0000 (---------------)  + I edu
	0x0027d903, // n0x095e c0x0000 (---------------)  + I gov
	0x00201844, // n0x095f c0x0000 (---------------)  + I info
	0x00200904, // n0x0960 c0x0000 (---------------)  + I name
	0x00223b43, // n0x0961 c0x0000 (---------------)  + I net
	0x00228743, // n0x0962 c0x0000 (---------------)  + I org
	0x00321085, // n0x0963 c0x0000 (---------------)  + I aland
	0x000fe108, // n0x0964 c0x0000 (---------------)  +   blogspot
	0x0003a783, // n0x0965 c0x0000 (---------------)  +   iki
	0x003274c8, // n0x0966 c0x0000 (---------------)  + I aeroport
	0x0034f007, // n0x0967 c0x0000 (---------------)  + I assedic
	0x002d5e84, // n0x0968 c0x0000 (---------------)  + I asso
	0x00353c06, // n0x0969 c0x0000 (---------------)  + I avocat
	0x0036c446, // n0x096a c0x0000 (---------------)  + I avoues
	0x000fe108, // n0x096b c0x0000 (---------------)  +   blogspot
	0x00234f03, // n0x096c c0x0000 (---------------)  + I cci
	0x00208909, // n0x096d c0x0000 (---------------)  + I chambagri
	0x002b3c95, // n0x096e c0x0000 (---------------)  + I chirurgiens-dentistes
	0x00233243, // n0x096f c0x0000 (---------------)  + I com
	0x0031f2d2, // n0x0970 c0x0000 (---------------)  + I experts-comptables
	0x0031f08f, // n0x0971 c0x0000 (---------------)  + I geometre-expert
	0x002aebc4, // n0x0972 c0x0000 (---------------)  + I gouv
	0x0021a045, // n0x0973 c0x0000 (---------------)  + I greta
	0x002eec50, // n0x0974 c0x0000 (---------------)  + I huissier-justice
	0x00378d47, // n0x0975 c0x0000 (---------------)  + I medecin
	0x00201383, // n0x0976 c0x0000 (---------------)  + I nom
	0x0035f0c8, // n0x0977 c0x0000 (---------------)  + I notaires
	0x0034af0a, // n0x0978 c0x0000 (---------------)  + I pharmacien
	0x00245144, // n0x0979 c0x0000 (---------------)  + I port
	0x002e0bc3, // n0x097a c0x0000 (---------------)  + I prd
	0x00246a06, // n0x097b c0x0000 (---------------)  + I presse
	0x00200c82, // n0x097c c0x0000 (---------------)  + I tm
	0x002d32cb, // n0x097d c0x0000 (---------------)  + I veterinaire
	0x00233243, // n0x097e c0x0000 (---------------)  + I com
	0x00239103, // n0x097f c0x0000 (---------------)  + I edu
	0x0027d903, // n0x0980 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x0981 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x0982 c0x0000 (---------------)  + I net
	0x00228743, // n0x0983 c0x0000 (---------------)  + I org
	0x002e62c3, // n0x0984 c0x0000 (---------------)  + I pvt
	0x0020ce42, // n0x0985 c0x0000 (---------------)  + I co
	0x00223b43, // n0x0986 c0x0000 (---------------)  + I net
	0x00228743, // n0x0987 c0x0000 (---------------)  + I org
	0x00233243, // n0x0988 c0x0000 (---------------)  + I com
	0x00239103, // n0x0989 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x098a c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x098b c0x0000 (---------------)  + I mil
	0x00228743, // n0x098c c0x0000 (---------------)  + I org
	0x00233243, // n0x098d c0x0000 (---------------)  + I com
	0x00239103, // n0x098e c0x0000 (---------------)  + I edu
	0x0027d903, // n0x098f c0x0000 (---------------)  + I gov
	0x00312883, // n0x0990 c0x0000 (---------------)  + I ltd
	0x002177c3, // n0x0991 c0x0000 (---------------)  + I mod
	0x00228743, // n0x0992 c0x0000 (---------------)  + I org
	0x0020ce42, // n0x0993 c0x0000 (---------------)  + I co
	0x00233243, // n0x0994 c0x0000 (---------------)  + I com
	0x00239103, // n0x0995 c0x0000 (---------------)  + I edu
	0x00223b43, // n0x0996 c0x0000 (---------------)  + I net
	0x00228743, // n0x0997 c0x0000 (---------------)  + I org
	0x00200342, // n0x0998 c0x0000 (---------------)  + I ac
	0x00233243, // n0x0999 c0x0000 (---------------)  + I com
	0x00239103, // n0x099a c0x0000 (---------------)  + I edu
	0x0027d903, // n0x099b c0x0000 (---------------)  + I gov
	0x00223b43, // n0x099c c0x0000 (---------------)  + I net
	0x00228743, // n0x099d c0x0000 (---------------)  + I org
	0x002d5e84, // n0x099e c0x0000 (---------------)  + I asso
	0x00233243, // n0x099f c0x0000 (---------------)  + I com
	0x00239103, // n0x09a0 c0x0000 (---------------)  + I edu
	0x0020bf04, // n0x09a1 c0x0000 (---------------)  + I mobi
	0x00223b43, // n0x09a2 c0x0000 (---------------)  + I net
	0x00228743, // n0x09a3 c0x0000 (---------------)  + I org
	0x000fe108, // n0x09a4 c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x09a5 c0x0000 (---------------)  + I com
	0x00239103, // n0x09a6 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x09a7 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x09a8 c0x0000 (---------------)  + I net
	0x00228743, // n0x09a9 c0x0000 (---------------)  + I org
	0x00233243, // n0x09aa c0x0000 (---------------)  + I com
	0x00239103, // n0x09ab c0x0000 (---------------)  + I edu
	0x00212b03, // n0x09ac c0x0000 (---------------)  + I gob
	0x00221b03, // n0x09ad c0x0000 (---------------)  + I ind
	0x00207dc3, // n0x09ae c0x0000 (---------------)  + I mil
	0x00223b43, // n0x09af c0x0000 (---------------)  + I net
	0x00228743, // n0x09b0 c0x0000 (---------------)  + I org
	0x0020ce42, // n0x09b1 c0x0000 (---------------)  + I co
	0x00233243, // n0x09b2 c0x0000 (---------------)  + I com
	0x00239103, // n0x09b3 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x09b4 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x09b5 c0x0000 (---------------)  + I net
	0x00228743, // n0x09b6 c0x0000 (---------------)  + I org
	0x000fe108, // n0x09b7 c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x09b8 c0x0000 (---------------)  + I com
	0x00239103, // n0x09b9 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x09ba c0x0000 (---------------)  + I gov
	0x0020de03, // n0x09bb c0x0000 (---------------)  + I idv
	0x0002fd03, // n0x09bc c0x0000 (---------------)  +   inc
	0x00112883, // n0x09bd c0x0000 (---------------)  +   ltd
	0x00223b43, // n0x09be c0x0000 (---------------)  + I net
	0x00228743, // n0x09bf c0x0000 (---------------)  + I org
	0x0030394a, // n0x09c0 c0x0000 (---------------)  + I xn--55qx5d
	0x0031cf89, // n0x09c1 c0x0000 (---------------)  + I xn--ciqpn
	0x0033a84b, // n0x09c2 c0x0000 (---------------)  + I xn--gmq050i
	0x0033b18a, // n0x09c3 c0x0000 (---------------)  + I xn--gmqw5a
	0x0034278a, // n0x09c4 c0x0000 (---------------)  + I xn--io0a7i
	0x00350d0b, // n0x09c5 c0x0000 (---------------)  + I xn--lcvr32d
	0x0036718a, // n0x09c6 c0x0000 (---------------)  + I xn--mk0axi
	0x0036eb8a, // n0x09c7 c0x0000 (---------------)  + I xn--mxtq1m
	0x0037530a, // n0x09c8 c0x0000 (---------------)  + I xn--od0alg
	0x0037558b, // n0x09c9 c0x0000 (---------------)  + I xn--od0aq3b
	0x00391bc9, // n0x09ca c0x0000 (---------------)  + I xn--tn0ag
	0x0039378a, // n0x09cb c0x0000 (---------------)  + I xn--uc0atv
	0x00393ccb, // n0x09cc c0x0000 (---------------)  + I xn--uc0ay4a
	0x0039e40b, // n0x09cd c0x0000 (---------------)  + I xn--wcvs22d
	0x003a478a, // n0x09ce c0x0000 (---------------)  + I xn--zf0avx
	0x00233243, // n0x09cf c0x0000 (---------------)  + I com
	0x00239103, // n0x09d0 c0x0000 (---------------)  + I edu
	0x00212b03, // n0x09d1 c0x0000 (---------------)  + I gob
	0x00207dc3, // n0x09d2 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x09d3 c0x0000 (---------------)  + I net
	0x00228743, // n0x09d4 c0x0000 (---------------)  + I org
	0x000fe108, // n0x09d5 c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x09d6 c0x0000 (---------------)  + I com
	0x00262384, // n0x09d7 c0x0000 (---------------)  + I from
	0x00214502, // n0x09d8 c0x0000 (---------------)  + I iz
	0x00200904, // n0x09d9 c0x0000 (---------------)  + I name
	0x002a3105, // n0x09da c0x0000 (---------------)  + I adult
	0x00201d43, // n0x09db c0x0000 (---------------)  + I art
	0x002d5e84, // n0x09dc c0x0000 (---------------)  + I asso
	0x00233243, // n0x09dd c0x0000 (---------------)  + I com
	0x0023c344, // n0x09de c0x0000 (---------------)  + I coop
	0x00239103, // n0x09df c0x0000 (---------------)  + I edu
	0x0024dcc4, // n0x09e0 c0x0000 (---------------)  + I firm
	0x002aebc4, // n0x09e1 c0x0000 (---------------)  + I gouv
	0x00201844, // n0x09e2 c0x0000 (---------------)  + I info
	0x00213443, // n0x09e3 c0x0000 (---------------)  + I med
	0x00223b43, // n0x09e4 c0x0000 (---------------)  + I net
	0x00228743, // n0x09e5 c0x0000 (---------------)  + I org
	0x00299705, // n0x09e6 c0x0000 (---------------)  + I perso
	0x00206ec3, // n0x09e7 c0x0000 (---------------)  + I pol
	0x00224b03, // n0x09e8 c0x0000 (---------------)  + I pro
	0x00286903, // n0x09e9 c0x0000 (---------------)  + I rel
	0x00357184, // n0x09ea c0x0000 (---------------)  + I shop
	0x00329cc4, // n0x09eb c0x0000 (---------------)  + I 2000
	0x00251805, // n0x09ec c0x0000 (---------------)  + I agrar
	0x000fe108, // n0x09ed c0x0000 (---------------)  +   blogspot
	0x002f8204, // n0x09ee c0x0000 (---------------)  + I bolt
	0x00356846, // n0x09ef c0x0000 (---------------)  + I casino
	0x00285804, // n0x09f0 c0x0000 (---------------)  + I city
	0x0020ce42, // n0x09f1 c0x0000 (---------------)  + I co
	0x00336ac7, // n0x09f2 c0x0000 (---------------)  + I erotica
	0x002505c7, // n0x09f3 c0x0000 (---------------)  + I erotika
	0x0024b184, // n0x09f4 c0x0000 (---------------)  + I film
	0x0025aec5, // n0x09f5 c0x0000 (---------------)  + I forum
	0x00345d85, // n0x09f6 c0x0000 (---------------)  + I games
	0x00234305, // n0x09f7 c0x0000 (---------------)  + I hotel
	0x00201844, // n0x09f8 c0x0000 (---------------)  + I info
	0x00227c88, // n0x09f9 c0x0000 (---------------)  + I ingatlan
	0x00294b06, // n0x09fa c0x0000 (---------------)  + I jogasz
	0x002d20c8, // n0x09fb c0x0000 (---------------)  + I konyvelo
	0x0023bb85, // n0x09fc c0x0000 (---------------)  + I lakas
	0x00303545, // n0x09fd c0x0000 (---------------)  + I media
	0x0021e604, // n0x09fe c0x0000 (---------------)  + I news
	0x00228743, // n0x09ff c0x0000 (---------------)  + I org
	0x002e17c4, // n0x0a00 c0x0000 (---------------)  + I priv
	0x0034fec6, // n0x0a01 c0x0000 (---------------)  + I reklam
	0x00246b03, // n0x0a02 c0x0000 (---------------)  + I sex
	0x00357184, // n0x0a03 c0x0000 (---------------)  + I shop
	0x0029c605, // n0x0a04 c0x0000 (---------------)  + I sport
	0x0023a984, // n0x0a05 c0x0000 (---------------)  + I suli
	0x0020a8c4, // n0x0a06 c0x0000 (---------------)  + I szex
	0x00200c82, // n0x0a07 c0x0000 (---------------)  + I tm
	0x00274bc6, // n0x0a08 c0x0000 (---------------)  + I tozsde
	0x00387586, // n0x0a09 c0x0000 (---------------)  + I utazas
	0x002f1145, // n0x0a0a c0x0000 (---------------)  + I video
	0x00200342, // n0x0a0b c0x0000 (---------------)  + I ac
	0x00331a83, // n0x0a0c c0x0000 (---------------)  + I biz
	0x1b60ce42, // n0x0a0d c0x006d (n0x0a16-n0x0a17)  + I co
	0x0023a484, // n0x0a0e c0x0000 (---------------)  + I desa
	0x00210a42, // n0x0a0f c0x0000 (---------------)  + I go
	0x00207dc3, // n0x0a10 c0x0000 (---------------)  + I mil
	0x00225742, // n0x0a11 c0x0000 (---------------)  + I my
	0x00223b43, // n0x0a12 c0x0000 (---------------)  + I net
	0x00200dc2, // n0x0a13 c0x0000 (---------------)  + I or
	0x00217283, // n0x0a14 c0x0000 (---------------)  + I sch
	0x0021e243, // n0x0a15 c0x0000 (---------------)  + I web
	0x000fe108, // n0x0a16 c0x0000 (---------------)  +   blogspot
	0x000fe108, // n0x0a17 c0x0000 (---------------)  +   blogspot
	0x0027d903, // n0x0a18 c0x0000 (---------------)  + I gov
	0x00200342, // n0x0a19 c0x0000 (---------------)  + I ac
	0x1c20ce42, // n0x0a1a c0x0070 (n0x0a21-n0x0a22)  + I co
	0x0027d903, // n0x0a1b c0x0000 (---------------)  + I gov
	0x002677c3, // n0x0a1c c0x0000 (---------------)  + I idf
	0x00332603, // n0x0a1d c0x0000 (---------------)  + I k12
	0x0022d004, // n0x0a1e c0x0000 (---------------)  + I muni
	0x00223b43, // n0x0a1f c0x0000 (---------------)  + I net
	0x00228743, // n0x0a20 c0x0000 (---------------)  + I org
	0x000fe108, // n0x0a21 c0x0000 (---------------)  +   blogspot
	0x00200342, // n0x0a22 c0x0000 (---------------)  + I ac
	0x1ca0ce42, // n0x0a23 c0x0072 (n0x0a29-n0x0a2b)  + I co
	0x00233243, // n0x0a24 c0x0000 (---------------)  + I com
	0x00223b43, // n0x0a25 c0x0000 (---------------)  + I net
	0x00228743, // n0x0a26 c0x0000 (---------------)  + I org
	0x0020fac2, // n0x0a27 c0x0000 (---------------)  + I tt
	0x002203c2, // n0x0a28 c0x0000 (---------------)  + I tv
	0x00312883, // n0x0a29 c0x0000 (---------------)  + I ltd
	0x002d96c3, // n0x0a2a c0x0000 (---------------)  + I plc
	0x00200342, // n0x0a2b c0x0000 (---------------)  + I ac
	0x000fe108, // n0x0a2c c0x0000 (---------------)  +   blogspot
	0x0020ce42, // n0x0a2d c0x0000 (---------------)  + I co
	0x00239103, // n0x0a2e c0x0000 (---------------)  + I edu
	0x0024dcc4, // n0x0a2f c0x0000 (---------------)  + I firm
	0x002060c3, // n0x0a30 c0x0000 (---------------)  + I gen
	0x0027d903, // n0x0a31 c0x0000 (---------------)  + I gov
	0x00221b03, // n0x0a32 c0x0000 (---------------)  + I ind
	0x00207dc3, // n0x0a33 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x0a34 c0x0000 (---------------)  + I net
	0x0021b843, // n0x0a35 c0x0000 (---------------)  + I nic
	0x00228743, // n0x0a36 c0x0000 (---------------)  + I org
	0x00221903, // n0x0a37 c0x0000 (---------------)  + I res
	0x0011ec53, // n0x0a38 c0x0000 (---------------)  +   barrel-of-knowledge
	0x00122f54, // n0x0a39 c0x0000 (---------------)  +   barrell-of-knowledge
	0x00013206, // n0x0a3a c0x0000 (---------------)  +   dyndns
	0x00056d07, // n0x0a3b c0x0000 (---------------)  +   for-our
	0x00152f89, // n0x0a3c c0x0000 (---------------)  +   groks-the
	0x000f4c0a, // n0x0a3d c0x0000 (---------------)  +   groks-this
	0x0008a30d, // n0x0a3e c0x0000 (---------------)  +   here-for-more
	0x0003dd0a, // n0x0a3f c0x0000 (---------------)  +   knowsitall
	0x0005abc6, // n0x0a40 c0x0000 (---------------)  +   selfip
	0x001267c6, // n0x0a41 c0x0000 (---------------)  +   webhop
	0x00205382, // n0x0a42 c0x0000 (---------------)  + I eu
	0x00233243, // n0x0a43 c0x0000 (---------------)  + I com
	0x000cbb86, // n0x0a44 c0x0000 (---------------)  +   github
	0x00152f45, // n0x0a45 c0x0000 (---------------)  +   ngrok
	0x0000ddc3, // n0x0a46 c0x0000 (---------------)  +   nid
	0x00010b08, // n0x0a47 c0x0000 (---------------)  +   pantheon
	0x000b1c48, // n0x0a48 c0x0000 (---------------)  +   sandcats
	0x00233243, // n0x0a49 c0x0000 (---------------)  + I com
	0x00239103, // n0x0a4a c0x0000 (---------------)  + I edu
	0x0027d903, // n0x0a4b c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x0a4c c0x0000 (---------------)  + I mil
	0x00223b43, // n0x0a4d c0x0000 (---------------)  + I net
	0x00228743, // n0x0a4e c0x0000 (---------------)  + I org
	0x00200342, // n0x0a4f c0x0000 (---------------)  + I ac
	0x0020ce42, // n0x0a50 c0x0000 (---------------)  + I co
	0x0027d903, // n0x0a51 c0x0000 (---------------)  + I gov
	0x0020d9c2, // n0x0a52 c0x0000 (---------------)  + I id
	0x00223b43, // n0x0a53 c0x0000 (---------------)  + I net
	0x00228743, // n0x0a54 c0x0000 (---------------)  + I org
	0x00217283, // n0x0a55 c0x0000 (---------------)  + I sch
	0x0035cf4f, // n0x0a56 c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x0035d30e, // n0x0a57 c0x0000 (---------------)  + I xn--mgba3a4fra
	0x000fe108, // n0x0a58 c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x0a59 c0x0000 (---------------)  + I com
	0x00047607, // n0x0a5a c0x0000 (---------------)  +   cupcake
	0x00239103, // n0x0a5b c0x0000 (---------------)  + I edu
	0x0027d903, // n0x0a5c c0x0000 (---------------)  + I gov
	0x00201503, // n0x0a5d c0x0000 (---------------)  + I int
	0x00223b43, // n0x0a5e c0x0000 (---------------)  + I net
	0x00228743, // n0x0a5f c0x0000 (---------------)  + I org
	0x00221883, // n0x0a60 c0x0000 (---------------)  + I abr
	0x00328e47, // n0x0a61 c0x0000 (---------------)  + I abruzzo
	0x00201b82, // n0x0a62 c0x0000 (---------------)  + I ag
	0x003018c9, // n0x0a63 c0x0000 (---------------)  + I agrigento
	0x00200d02, // n0x0a64 c0x0000 (---------------)  + I al
	0x0038804b, // n0x0a65 c0x0000 (---------------)  + I alessandria
	0x002e414a, // n0x0a66 c0x0000 (---------------)  + I alto-adige
	0x002d2549, // n0x0a67 c0x0000 (---------------)  + I altoadige
	0x002008c2, // n0x0a68 c0x0000 (---------------)  + I an
	0x0034ea86, // n0x0a69 c0x0000 (---------------)  + I ancona
	0x00291e55, // n0x0a6a c0x0000 (---------------)  + I andria-barletta-trani
	0x00388195, // n0x0a6b c0x0000 (---------------)  + I andria-trani-barletta
	0x00293953, // n0x0a6c c0x0000 (---------------)  + I andriabarlettatrani
	0x00388713, // n0x0a6d c0x0000 (---------------)  + I andriatranibarletta
	0x00202882, // n0x0a6e c0x0000 (---------------)  + I ao
	0x00216b45, // n0x0a6f c0x0000 (---------------)  + I aosta
	0x0025570c, // n0x0a70 c0x0000 (---------------)  + I aosta-valley
	0x00216b4b, // n0x0a71 c0x0000 (---------------)  + I aostavalley
	0x0024af85, // n0x0a72 c0x0000 (---------------)  + I aoste
	0x00208082, // n0x0a73 c0x0000 (---------------)  + I ap
	0x00200f02, // n0x0a74 c0x0000 (---------------)  + I aq
	0x0036b5c6, // n0x0a75 c0x0000 (---------------)  + I aquila
	0x00201d42, // n0x0a76 c0x0000 (---------------)  + I ar
	0x0027a206, // n0x0a77 c0x0000 (---------------)  + I arezzo
	0x0039728d, // n0x0a78 c0x0000 (---------------)  + I ascoli-piceno
	0x00342fcc, // n0x0a79 c0x0000 (---------------)  + I ascolipiceno
	0x00222b04, // n0x0a7a c0x0000 (---------------)  + I asti
	0x00200482, // n0x0a7b c0x0000 (---------------)  + I at
	0x00202f02, // n0x0a7c c0x0000 (---------------)  + I av
	0x00220188, // n0x0a7d c0x0000 (---------------)  + I avellino
	0x00200882, // n0x0a7e c0x0000 (---------------)  + I ba
	0x00247a86, // n0x0a7f c0x0000 (---------------)  + I balsan
	0x00248704, // n0x0a80 c0x0000 (---------------)  + I bari
	0x00292015, // n0x0a81 c0x0000 (---------------)  + I barletta-trani-andria
	0x00293ad3, // n0x0a82 c0x0000 (---------------)  + I barlettatraniandria
	0x00206d83, // n0x0a83 c0x0000 (---------------)  + I bas
	0x0033030a, // n0x0a84 c0x0000 (---------------)  + I basilicata
	0x00286007, // n0x0a85 c0x0000 (---------------)  + I belluno
	0x002e56c9, // n0x0a86 c0x0000 (---------------)  + I benevento
	0x0022a747, // n0x0a87 c0x0000 (---------------)  + I bergamo
	0x00304a82, // n0x0a88 c0x0000 (---------------)  + I bg
	0x00200002, // n0x0a89 c0x0000 (---------------)  + I bi
	0x003a5706, // n0x0a8a c0x0000 (---------------)  + I biella
	0x0020db02, // n0x0a8b c0x0000 (---------------)  + I bl
	0x000fe108, // n0x0a8c c0x0000 (---------------)  +   blogspot
	0x00212142, // n0x0a8d c0x0000 (---------------)  + I bn
	0x0020f682, // n0x0a8e c0x0000 (---------------)  + I bo
	0x0038d0c7, // n0x0a8f c0x0000 (---------------)  + I bologna
	0x00211807, // n0x0a90 c0x0000 (---------------)  + I bolzano
	0x0021e845, // n0x0a91 c0x0000 (---------------)  + I bozen
	0x0021e3c2, // n0x0a92 c0x0000 (---------------)  + I br
	0x002218c7, // n0x0a93 c0x0000 (---------------)  + I brescia
	0x00221a88, // n0x0a94 c0x0000 (---------------)  + I brindisi
	0x00230fc2, // n0x0a95 c0x0000 (---------------)  + I bs
	0x00223a42, // n0x0a96 c0x0000 (---------------)  + I bt
	0x00230682, // n0x0a97 c0x0000 (---------------)  + I bz
	0x00200e42, // n0x0a98 c0x0000 (---------------)  + I ca
	0x0023f288, // n0x0a99 c0x0000 (---------------)  + I cagliari
	0x00212ec3, // n0x0a9a c0x0000 (---------------)  + I cal
	0x00254cc8, // n0x0a9b c0x0000 (---------------)  + I calabria
	0x0023970d, // n0x0a9c c0x0000 (---------------)  + I caltanissetta
	0x0021e303, // n0x0a9d c0x0000 (---------------)  + I cam
	0x00319488, // n0x0a9e c0x0000 (---------------)  + I campania
	0x00241bcf, // n0x0a9f c0x0000 (---------------)  + I campidano-medio
	0x00241f8e, // n0x0aa0 c0x0000 (---------------)  + I campidanomedio
	0x00336c0a, // n0x0aa1 c0x0000 (---------------)  + I campobasso
	0x002f5d11, // n0x0aa2 c0x0000 (---------------)  + I carbonia-iglesias
	0x002f6190, // n0x0aa3 c0x0000 (---------------)  + I carboniaiglesias
	0x002b584d, // n0x0aa4 c0x0000 (---------------)  + I carrara-massa
	0x002b5b8c, // n0x0aa5 c0x0000 (---------------)  + I carraramassa
	0x0023d147, // n0x0aa6 c0x0000 (---------------)  + I caserta
	0x00330487, // n0x0aa7 c0x0000 (---------------)  + I catania
	0x00353cc9, // n0x0aa8 c0x0000 (---------------)  + I catanzaro
	0x00222c02, // n0x0aa9 c0x0000 (---------------)  + I cb
	0x00204c82, // n0x0aaa c0x0000 (---------------)  + I ce
	0x0025874c, // n0x0aab c0x0000 (---------------)  + I cesena-forli
	0x00258a4b, // n0x0aac c0x0000 (---------------)  + I cesenaforli
	0x00200382, // n0x0aad c0x0000 (---------------)  + I ch
	0x002d0206, // n0x0aae c0x0000 (---------------)  + I chieti
	0x00209602, // n0x0aaf c0x0000 (---------------)  + I ci
	0x00207f42, // n0x0ab0 c0x0000 (---------------)  + I cl
	0x0021dac2, // n0x0ab1 c0x0000 (---------------)  + I cn
	0x0020ce42, // n0x0ab2 c0x0000 (---------------)  + I co
	0x00233d44, // n0x0ab3 c0x0000 (---------------)  + I como
	0x00240dc7, // n0x0ab4 c0x0000 (---------------)  + I cosenza
	0x002051c2, // n0x0ab5 c0x0000 (---------------)  + I cr
	0x00243cc7, // n0x0ab6 c0x0000 (---------------)  + I cremona
	0x00244f47, // n0x0ab7 c0x0000 (---------------)  + I crotone
	0x00210802, // n0x0ab8 c0x0000 (---------------)  + I cs
	0x0022af82, // n0x0ab9 c0x0000 (---------------)  + I ct
	0x002474c5, // n0x0aba c0x0000 (---------------)  + I cuneo
	0x00200142, // n0x0abb c0x0000 (---------------)  + I cz
	0x0025a10e, // n0x0abc c0x0000 (---------------)  + I dell-ogliastra
	0x0026548d, // n0x0abd c0x0000 (---------------)  + I dellogliastra
	0x00239103, // n0x0abe c0x0000 (---------------)  + I edu
	0x003285ce, // n0x0abf c0x0000 (---------------)  + I emilia-romagna
	0x0028510d, // n0x0ac0 c0x0000 (---------------)  + I emiliaromagna
	0x00361083, // n0x0ac1 c0x0000 (---------------)  + I emr
	0x00202a82, // n0x0ac2 c0x0000 (---------------)  + I en
	0x00206304, // n0x0ac3 c0x0000 (---------------)  + I enna
	0x0024a982, // n0x0ac4 c0x0000 (---------------)  + I fc
	0x0020cf02, // n0x0ac5 c0x0000 (---------------)  + I fe
	0x002d7ac5, // n0x0ac6 c0x0000 (---------------)  + I fermo
	0x002e20c7, // n0x0ac7 c0x0000 (---------------)  + I ferrara
	0x00349342, // n0x0ac8 c0x0000 (---------------)  + I fg
	0x00201702, // n0x0ac9 c0x0000 (---------------)  + I fi
	0x0024d607, // n0x0aca c0x0000 (---------------)  + I firenze
	0x00252708, // n0x0acb c0x0000 (---------------)  + I florence
	0x00234802, // n0x0acc c0x0000 (---------------)  + I fm
	0x002018c6, // n0x0acd c0x0000 (---------------)  + I foggia
	0x002585cc, // n0x0ace c0x0000 (---------------)  + I forli-cesena
	0x0025890b, // n0x0acf c0x0000 (---------------)  + I forlicesena
	0x00240202, // n0x0ad0 c0x0000 (---------------)  + I fr
	0x0025e98f, // n0x0ad1 c0x0000 (---------------)  + I friuli-v-giulia
	0x0025ed50, // n0x0ad2 c0x0000 (---------------)  + I friuli-ve-giulia
	0x0025f14f, // n0x0ad3 c0x0000 (---------------)  + I friuli-vegiulia
	0x0025f515, // n0x0ad4 c0x0000 (---------------)  + I friuli-venezia-giulia
	0x0025fa54, // n0x0ad5 c0x0000 (---------------)  + I friuli-veneziagiulia
	0x0025ff4e, // n0x0ad6 c0x0000 (---------------)  + I friuli-vgiulia
	0x002602ce, // n0x0ad7 c0x0000 (---------------)  + I friuliv-giulia
	0x0026064f, // n0x0ad8 c0x0000 (---------------)  + I friulive-giulia
	0x00260a0e, // n0x0ad9 c0x0000 (---------------)  + I friulivegiulia
	0x00260d94, // n0x0ada c0x0000 (---------------)  + I friulivenezia-giulia
	0x00261293, // n0x0adb c0x0000 (---------------)  + I friuliveneziagiulia
	0x0026174d, // n0x0adc c0x0000 (---------------)  + I friulivgiulia
	0x002765c9, // n0x0add c0x0000 (---------------)  + I frosinone
	0x0028aec3, // n0x0ade c0x0000 (---------------)  + I fvg
	0x00200282, // n0x0adf c0x0000 (---------------)  + I ge
	0x003077c5, // n0x0ae0 c0x0000 (---------------)  + I genoa
	0x002060c6, // n0x0ae1 c0x0000 (---------------)  + I genova
	0x00210a42, // n0x0ae2 c0x0000 (---------------)  + I go
	0x002703c7, // n0x0ae3 c0x0000 (---------------)  + I gorizia
	0x0027d903, // n0x0ae4 c0x0000 (---------------)  + I gov
	0x00208a82, // n0x0ae5 c0x0000 (---------------)  + I gr
	0x00288508, // n0x0ae6 c0x0000 (---------------)  + I grosseto
	0x002f5f51, // n0x0ae7 c0x0000 (---------------)  + I iglesias-carbonia
	0x002f6390, // n0x0ae8 c0x0000 (---------------)  + I iglesiascarbonia
	0x00200402, // n0x0ae9 c0x0000 (---------------)  + I im
	0x003578c7, // n0x0aea c0x0000 (---------------)  + I imperia
	0x00204e82, // n0x0aeb c0x0000 (---------------)  + I is
	0x0025d847, // n0x0aec c0x0000 (---------------)  + I isernia
	0x0020bdc2, // n0x0aed c0x0000 (---------------)  + I kr
	0x0026ad89, // n0x0aee c0x0000 (---------------)  + I la-spezia
	0x0036b587, // n0x0aef c0x0000 (---------------)  + I laquila
	0x002583c8, // n0x0af0 c0x0000 (---------------)  + I laspezia
	0x00226e86, // n0x0af1 c0x0000 (---------------)  + I latina
	0x002d95c3, // n0x0af2 c0x0000 (---------------)  + I laz
	0x002f49c5, // n0x0af3 c0x0000 (---------------)  + I lazio
	0x00239382, // n0x0af4 c0x0000 (---------------)  + I lc
	0x0020c8c2, // n0x0af5 c0x0000 (---------------)  + I le
	0x003a5b05, // n0x0af6 c0x0000 (---------------)  + I lecce
	0x0022f645, // n0x0af7 c0x0000 (---------------)  + I lecco
	0x00205bc2, // n0x0af8 c0x0000 (---------------)  + I li
	0x0023aa03, // n0x0af9 c0x0000 (---------------)  + I lig
	0x0023aa07, // n0x0afa c0x0000 (---------------)  + I liguria
	0x002137c7, // n0x0afb c0x0000 (---------------)  + I livorno
	0x00200d82, // n0x0afc c0x0000 (---------------)  + I lo
	0x00259b44, // n0x0afd c0x0000 (---------------)  + I lodi
	0x00214d03, // n0x0afe c0x0000 (---------------)  + I lom
	0x002c5f09, // n0x0aff c0x0000 (---------------)  + I lombardia
	0x002db788, // n0x0b00 c0x0000 (---------------)  + I lombardy
	0x00208bc2, // n0x0b01 c0x0000 (---------------)  + I lt
	0x00203842, // n0x0b02 c0x0000 (---------------)  + I lu
	0x0026e747, // n0x0b03 c0x0000 (---------------)  + I lucania
	0x002da485, // n0x0b04 c0x0000 (---------------)  + I lucca
	0x00318f88, // n0x0b05 c0x0000 (---------------)  + I macerata
	0x00253e87, // n0x0b06 c0x0000 (---------------)  + I mantova
	0x00201d03, // n0x0b07 c0x0000 (---------------)  + I mar
	0x002843c6, // n0x0b08 c0x0000 (---------------)  + I marche
	0x002b56cd, // n0x0b09 c0x0000 (---------------)  + I massa-carrara
	0x002b5a4c, // n0x0b0a c0x0000 (---------------)  + I massacarrara
	0x0024be06, // n0x0b0b c0x0000 (---------------)  + I matera
	0x00205a82, // n0x0b0c c0x0000 (---------------)  + I mb
	0x0021a3c2, // n0x0b0d c0x0000 (---------------)  + I mc
	0x00200982, // n0x0b0e c0x0000 (---------------)  + I me
	0x00241a4f, // n0x0b0f c0x0000 (---------------)  + I medio-campidano
	0x00241e4e, // n0x0b10 c0x0000 (---------------)  + I mediocampidano
	0x00345e07, // n0x0b11 c0x0000 (---------------)  + I messina
	0x00207dc2, // n0x0b12 c0x0000 (---------------)  + I mi
	0x002fb205, // n0x0b13 c0x0000 (---------------)  + I milan
	0x002fb206, // n0x0b14 c0x0000 (---------------)  + I milano
	0x00223b02, // n0x0b15 c0x0000 (---------------)  + I mn
	0x00208442, // n0x0b16 c0x0000 (---------------)  + I mo
	0x002177c6, // n0x0b17 c0x0000 (---------------)  + I modena
	0x00212d43, // n0x0b18 c0x0000 (---------------)  + I mol
	0x0025d786, // n0x0b19 c0x0000 (---------------)  + I molise
	0x002c4b05, // n0x0b1a c0x0000 (---------------)  + I monza
	0x002c4b0d, // n0x0b1b c0x0000 (---------------)  + I monza-brianza
	0x002c5355, // n0x0b1c c0x0000 (---------------)  + I monza-e-della-brianza
	0x002c5b0c, // n0x0b1d c0x0000 (---------------)  + I monzabrianza
	0x002c63cd, // n0x0b1e c0x0000 (---------------)  + I monzaebrianza
	0x002c6792, // n0x0b1f c0x0000 (---------------)  + I monzaedellabrianza
	0x00210f42, // n0x0b20 c0x0000 (---------------)  + I ms
	0x00205402, // n0x0b21 c0x0000 (---------------)  + I mt
	0x00200902, // n0x0b22 c0x0000 (---------------)  + I na
	0x0039ba46, // n0x0b23 c0x0000 (---------------)  + I naples
	0x002a53c6, // n0x0b24 c0x0000 (---------------)  + I napoli
	0x00201382, // n0x0b25 c0x0000 (---------------)  + I no
	0x00206146, // n0x0b26 c0x0000 (---------------)  + I novara
	0x00204182, // n0x0b27 c0x0000 (---------------)  + I nu
	0x0039d545, // n0x0b28 c0x0000 (---------------)  + I nuoro
	0x00201902, // n0x0b29 c0x0000 (---------------)  + I og
	0x0025a249, // n0x0b2a c0x0000 (---------------)  + I ogliastra
	0x0027548c, // n0x0b2b c0x0000 (---------------)  + I olbia-tempio
	0x002757cb, // n0x0b2c c0x0000 (---------------)  + I olbiatempio
	0x00200dc2, // n0x0b2d c0x0000 (---------------)  + I or
	0x00252b48, // n0x0b2e c0x0000 (---------------)  + I oristano
	0x00201102, // n0x0b2f c0x0000 (---------------)  + I ot
	0x0020aac2, // n0x0b30 c0x0000 (---------------)  + I pa
	0x00216906, // n0x0b31 c0x0000 (---------------)  + I padova
	0x00361a05, // n0x0b32 c0x0000 (---------------)  + I padua
	0x00305ec7, // n0x0b33 c0x0000 (---------------)  + I palermo
	0x00394905, // n0x0b34 c0x0000 (---------------)  + I parma
	0x002dbe45, // n0x0b35 c0x0000 (---------------)  + I pavia
	0x00247682, // n0x0b36 c0x0000 (---------------)  + I pc
	0x00357282, // n0x0b37 c0x0000 (---------------)  + I pd
	0x00200582, // n0x0b38 c0x0000 (---------------)  + I pe
	0x00266707, // n0x0b39 c0x0000 (---------------)  + I perugia
	0x0022c3cd, // n0x0b3a c0x0000 (---------------)  + I pesaro-urbino
	0x0022c74c, // n0x0b3b c0x0000 (---------------)  + I pesarourbino
	0x00237007, // n0x0b3c c0x0000 (---------------)  + I pescara
	0x00248ac2, // n0x0b3d c0x0000 (---------------)  + I pg
	0x00219f82, // n0x0b3e c0x0000 (---------------)  + I pi
	0x00338208, // n0x0b3f c0x0000 (---------------)  + I piacenza
	0x00258e08, // n0x0b40 c0x0000 (---------------)  + I piedmont
	0x002d68c8, // n0x0b41 c0x0000 (---------------)  + I piemonte
	0x002df204, // n0x0b42 c0x0000 (---------------)  + I pisa
	0x002d05c7, // n0x0b43 c0x0000 (---------------)  + I pistoia
	0x002dd5c3, // n0x0b44 c0x0000 (---------------)  + I pmn
	0x002488c2, // n0x0b45 c0x0000 (---------------)  + I pn
	0x00206ec2, // n0x0b46 c0x0000 (---------------)  + I po
	0x002df8c9, // n0x0b47 c0x0000 (---------------)  + I pordenone
	0x00208187, // n0x0b48 c0x0000 (---------------)  + I potenza
	0x00204e02, // n0x0b49 c0x0000 (---------------)  + I pr
	0x00271845, // n0x0b4a c0x0000 (---------------)  + I prato
	0x002d3242, // n0x0b4b c0x0000 (---------------)  + I pt
	0x00235982, // n0x0b4c c0x0000 (---------------)  + I pu
	0x00278643, // n0x0b4d c0x0000 (---------------)  + I pug
	0x00278646, // n0x0b4e c0x0000 (---------------)  + I puglia
	0x002e62c2, // n0x0b4f c0x0000 (---------------)  + I pv
	0x002e70c2, // n0x0b50 c0x0000 (---------------)  + I pz
	0x00202382, // n0x0b51 c0x0000 (---------------)  + I ra
	0x0030e106, // n0x0b52 c0x0000 (---------------)  + I ragusa
	0x00206247, // n0x0b53 c0x0000 (---------------)  + I ravenna
	0x00200e02, // n0x0b54 c0x0000 (---------------)  + I rc
	0x00208c82, // n0x0b55 c0x0000 (---------------)  + I re
	0x0033d54f, // n0x0b56 c0x0000 (---------------)  + I reggio-calabria
	0x0032840d, // n0x0b57 c0x0000 (---------------)  + I reggio-emilia
	0x00254b4e, // n0x0b58 c0x0000 (---------------)  + I reggiocalabria
	0x00284f8c, // n0x0b59 c0x0000 (---------------)  + I reggioemilia
	0x00205b42, // n0x0b5a c0x0000 (---------------)  + I rg
	0x00204e42, // n0x0b5b c0x0000 (---------------)  + I ri
	0x00226cc5, // n0x0b5c c0x0000 (---------------)  + I rieti
	0x00300186, // n0x0b5d c0x0000 (---------------)  + I rimini
	0x00225a02, // n0x0b5e c0x0000 (---------------)  + I rm
	0x0020dd82, // n0x0b5f c0x0000 (---------------)  + I rn
	0x002020c2, // n0x0b60 c0x0000 (---------------)  + I ro
	0x0022cb44, // n0x0b61 c0x0000 (---------------)  + I roma
	0x002e2f04, // n0x0b62 c0x0000 (---------------)  + I rome
	0x00334ec6, // n0x0b63 c0x0000 (---------------)  + I rovigo
	0x00201002, // n0x0b64 c0x0000 (---------------)  + I sa
	0x00279547, // n0x0b65 c0x0000 (---------------)  + I salerno
	0x0021adc3, // n0x0b66 c0x0000 (---------------)  + I sar
	0x0021f988, // n0x0b67 c0x0000 (---------------)  + I sardegna
	0x002216c8, // n0x0b68 c0x0000 (---------------)  + I sardinia
	0x002d9c47, // n0x0b69 c0x0000 (---------------)  + I sassari
	0x0039b946, // n0x0b6a c0x0000 (---------------)  + I savona
	0x002091c2, // n0x0b6b c0x0000 (---------------)  + I si
	0x0023f203, // n0x0b6c c0x0000 (---------------)  + I sic
	0x00375147, // n0x0b6d c0x0000 (---------------)  + I sicilia
	0x00337206, // n0x0b6e c0x0000 (---------------)  + I sicily
	0x0031bf85, // n0x0b6f c0x0000 (---------------)  + I siena
	0x00341fc8, // n0x0b70 c0x0000 (---------------)  + I siracusa
	0x00205f02, // n0x0b71 c0x0000 (---------------)  + I so
	0x0030b1c7, // n0x0b72 c0x0000 (---------------)  + I sondrio
	0x00208142, // n0x0b73 c0x0000 (---------------)  + I sp
	0x00332d82, // n0x0b74 c0x0000 (---------------)  + I sr
	0x0020b702, // n0x0b75 c0x0000 (---------------)  + I ss
	0x002d0e49, // n0x0b76 c0x0000 (---------------)  + I suedtirol
	0x002365c2, // n0x0b77 c0x0000 (---------------)  + I sv
	0x002004c2, // n0x0b78 c0x0000 (---------------)  + I ta
	0x00237283, // n0x0b79 c0x0000 (---------------)  + I taa
	0x00332207, // n0x0b7a c0x0000 (---------------)  + I taranto
	0x00200a82, // n0x0b7b c0x0000 (---------------)  + I te
	0x0027560c, // n0x0b7c c0x0000 (---------------)  + I tempio-olbia
	0x0027590b, // n0x0b7d c0x0000 (---------------)  + I tempioolbia
	0x0024be86, // n0x0b7e c0x0000 (---------------)  + I teramo
	0x0020dd05, // n0x0b7f c0x0000 (---------------)  + I terni
	0x0024fd82, // n0x0b80 c0x0000 (---------------)  + I tn
	0x00206e42, // n0x0b81 c0x0000 (---------------)  + I to
	0x002b34c6, // n0x0b82 c0x0000 (---------------)  + I torino
	0x002230c3, // n0x0b83 c0x0000 (---------------)  + I tos
	0x00324507, // n0x0b84 c0x0000 (---------------)  + I toscana
	0x00210ac2, // n0x0b85 c0x0000 (---------------)  + I tp
	0x00203902, // n0x0b86 c0x0000 (---------------)  + I tr
	0x00291cd5, // n0x0b87 c0x0000 (---------------)  + I trani-andria-barletta
	0x00388355, // n0x0b88 c0x0000 (---------------)  + I trani-barletta-andria
	0x00293813, // n0x0b89 c0x0000 (---------------)  + I traniandriabarletta
	0x00388893, // n0x0b8a c0x0000 (---------------)  + I tranibarlettaandria
	0x0029c707, // n0x0b8b c0x0000 (---------------)  + I trapani
	0x002bc488, // n0x0b8c c0x0000 (---------------)  + I trentino
	0x002e9ad0, // n0x0b8d c0x0000 (---------------)  + I trentino-a-adige
	0x0033adcf, // n0x0b8e c0x0000 (---------------)  + I trentino-aadige
	0x0034ccd3, // n0x0b8f c0x0000 (---------------)  + I trentino-alto-adige
	0x002d2312, // n0x0b90 c0x0000 (---------------)  + I trentino-altoadige
	0x00301490, // n0x0b91 c0x0000 (---------------)  + I trentino-s-tirol
	0x002bc48f, // n0x0b92 c0x0000 (---------------)  + I trentino-stirol
	0x002c4692, // n0x0b93 c0x0000 (---------------)  + I trentino-sud-tirol
	0x002cbf91, // n0x0b94 c0x0000 (---------------)  + I trentino-sudtirol
	0x002ce653, // n0x0b95 c0x0000 (---------------)  + I trentino-sued-tirol
	0x002d0c12, // n0x0b96 c0x0000 (---------------)  + I trentino-suedtirol
	0x002d628f, // n0x0b97 c0x0000 (---------------)  + I trentinoa-adige
	0x002df54e, // n0x0b98 c0x0000 (---------------)  + I trentinoaadige
	0x002e3f52, // n0x0b99 c0x0000 (---------------)  + I trentinoalto-adige
	0x002e4791, // n0x0b9a c0x0000 (---------------)  + I trentinoaltoadige
	0x002e634f, // n0x0b9b c0x0000 (---------------)  + I trentinos-tirol
	0x002e744e, // n0x0b9c c0x0000 (---------------)  + I trentinostirol
	0x002ee591, // n0x0b9d c0x0000 (---------------)  + I trentinosud-tirol
	0x00334510, // n0x0b9e c0x0000 (---------------)  + I trentinosudtirol
	0x002e8f12, // n0x0b9f c0x0000 (---------------)  + I trentinosued-tirol
	0x002fa091, // n0x0ba0 c0x0000 (---------------)  + I trentinosuedtirol
	0x002f7986, // n0x0ba1 c0x0000 (---------------)  + I trento
	0x002f82c7, // n0x0ba2 c0x0000 (---------------)  + I treviso
	0x00367507, // n0x0ba3 c0x0000 (---------------)  + I trieste
	0x00207a42, // n0x0ba4 c0x0000 (---------------)  + I ts
	0x0027ff05, // n0x0ba5 c0x0000 (---------------)  + I turin
	0x002ee9c7, // n0x0ba6 c0x0000 (---------------)  + I tuscany
	0x002203c2, // n0x0ba7 c0x0000 (---------------)  + I tv
	0x00208002, // n0x0ba8 c0x0000 (---------------)  + I ud
	0x0022bf85, // n0x0ba9 c0x0000 (---------------)  + I udine
	0x00222403, // n0x0baa c0x0000 (---------------)  + I umb
	0x00251a86, // n0x0bab c0x0000 (---------------)  + I umbria
	0x0022c58d, // n0x0bac c0x0000 (---------------)  + I urbino-pesaro
	0x0022c8cc, // n0x0bad c0x0000 (---------------)  + I urbinopesaro
	0x00200c02, // n0x0bae c0x0000 (---------------)  + I va
	0x0025558b, // n0x0baf c0x0000 (---------------)  + I val-d-aosta
	0x00216a0a, // n0x0bb0 c0x0000 (---------------)  + I val-daosta
	0x0032264a, // n0x0bb1 c0x0000 (---------------)  + I vald-aosta
	0x002b2889, // n0x0bb2 c0x0000 (---------------)  + I valdaosta
	0x002de48b, // n0x0bb3 c0x0000 (---------------)  + I valle-aosta
	0x002ef0cd, // n0x0bb4 c0x0000 (---------------)  + I valle-d-aosta
	0x00253fcc, // n0x0bb5 c0x0000 (---------------)  + I valle-daosta
	0x0021af4a, // n0x0bb6 c0x0000 (---------------)  + I valleaosta
	0x0022040c, // n0x0bb7 c0x0000 (---------------)  + I valled-aosta
	0x0023fbcb, // n0x0bb8 c0x0000 (---------------)  + I valledaosta
	0x0024adcc, // n0x0bb9 c0x0000 (---------------)  + I vallee-aoste
	0x0024f1cb, // n0x0bba c0x0000 (---------------)  + I valleeaoste
	0x00275403, // n0x0bbb c0x0000 (---------------)  + I vao
	0x0028bb86, // n0x0bbc c0x0000 (---------------)  + I varese
	0x002dc442, // n0x0bbd c0x0000 (---------------)  + I vb
	0x002e7802, // n0x0bbe c0x0000 (---------------)  + I vc
	0x00211b83, // n0x0bbf c0x0000 (---------------)  + I vda
	0x00202a42, // n0x0bc0 c0x0000 (---------------)  + I ve
	0x00202a43, // n0x0bc1 c0x0000 (---------------)  + I ven
	0x00368646, // n0x0bc2 c0x0000 (---------------)  + I veneto
	0x0025f6c7, // n0x0bc3 c0x0000 (---------------)  + I venezia
	0x00270846, // n0x0bc4 c0x0000 (---------------)  + I venice
	0x0022e7c8, // n0x0bc5 c0x0000 (---------------)  + I verbania
	0x002e3748, // n0x0bc6 c0x0000 (---------------)  + I vercelli
	0x00360dc6, // n0x0bc7 c0x0000 (---------------)  + I verona
	0x002065c2, // n0x0bc8 c0x0000 (---------------)  + I vi
	0x002f0b0d, // n0x0bc9 c0x0000 (---------------)  + I vibo-valentia
	0x002f0e4c, // n0x0bca c0x0000 (---------------)  + I vibovalentia
	0x002aec87, // n0x0bcb c0x0000 (---------------)  + I vicenza
	0x002f80c7, // n0x0bcc c0x0000 (---------------)  + I viterbo
	0x0020de82, // n0x0bcd c0x0000 (---------------)  + I vr
	0x00229a42, // n0x0bce c0x0000 (---------------)  + I vs
	0x0026a302, // n0x0bcf c0x0000 (---------------)  + I vt
	0x00215382, // n0x0bd0 c0x0000 (---------------)  + I vv
	0x0020ce42, // n0x0bd1 c0x0000 (---------------)  + I co
	0x00223b43, // n0x0bd2 c0x0000 (---------------)  + I net
	0x00228743, // n0x0bd3 c0x0000 (---------------)  + I org
	0x00233243, // n0x0bd4 c0x0000 (---------------)  + I com
	0x00239103, // n0x0bd5 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x0bd6 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x0bd7 c0x0000 (---------------)  + I mil
	0x00200904, // n0x0bd8 c0x0000 (---------------)  + I name
	0x00223b43, // n0x0bd9 c0x0000 (---------------)  + I net
	0x00228743, // n0x0bda c0x0000 (---------------)  + I org
	0x00217283, // n0x0bdb c0x0000 (---------------)  + I sch
	0x00200342, // n0x0bdc c0x0000 (---------------)  + I ac
	0x002001c2, // n0x0bdd c0x0000 (---------------)  + I ad
	0x1fa90e05, // n0x0bde c0x007e (n0x0c4b-n0x0c7f)  + I aichi
	0x1fe04785, // n0x0bdf c0x007f (n0x0c7f-n0x0c9b)  + I akita
	0x2030ddc6, // n0x0be0 c0x0080 (n0x0c9b-n0x0cb1)  + I aomori
	0x000fe108, // n0x0be1 c0x0000 (---------------)  +   blogspot
	0x206afa45, // n0x0be2 c0x0081 (n0x0cb1-n0x0ceb)  + I chiba
	0x0020ce42, // n0x0be3 c0x0000 (---------------)  + I co
	0x002024c2, // n0x0be4 c0x0000 (---------------)  + I ed
	0x20b54dc5, // n0x0be5 c0x0082 (n0x0ceb-n0x0d01)  + I ehime
	0x20e7de85, // n0x0be6 c0x0083 (n0x0d01-n0x0d10)  + I fukui
	0x2127f5c7, // n0x0be7 c0x0084 (n0x0d10-n0x0d4f)  + I fukuoka
	0x217547c9, // n0x0be8 c0x0085 (n0x0d4f-n0x0d82)  + I fukushima
	0x21aae0c4, // n0x0be9 c0x0086 (n0x0d82-n0x0da8)  + I gifu
	0x00210a42, // n0x0bea c0x0000 (---------------)  + I go
	0x00208a82, // n0x0beb c0x0000 (---------------)  + I gr
	0x21e45885, // n0x0bec c0x0087 (n0x0da8-n0x0dcc)  + I gunma
	0x22209e49, // n0x0bed c0x0088 (n0x0dcc-n0x0de5)  + I hiroshima
	0x2276a608, // n0x0bee c0x0089 (n0x0de5-n0x0e73)  + I hokkaido
	0x22aacdc5, // n0x0bef c0x008a (n0x0e73-n0x0ea1)  + I hyogo
	0x22ec3847, // n0x0bf0 c0x008b (n0x0ea1-n0x0ed4)  + I ibaraki
	0x2321b2c8, // n0x0bf1 c0x008c (n0x0ed4-n0x0ee7)  + I ishikawa
	0x236d7d45, // n0x0bf2 c0x008d (n0x0ee7-n0x0f09)  + I iwate
	0x23a01b46, // n0x0bf3 c0x008e (n0x0f09-n0x0f18)  + I kagawa
	0x23e75f89, // n0x0bf4 c0x008f (n0x0f18-n0x0f2c)  + I kagoshima
	0x2430ad88, // n0x0bf5 c0x0090 (n0x0f2c-n0x0f4a)  + I kanagawa
	0x246ba408, // n0x0bf6 c0x0091 (n0x0f4a-n0x0f4b)* o I kawasaki
	0x24a9e08a, // n0x0bf7 c0x0092 (n0x0f4b-n0x0f4c)* o I kitakyushu
	0x24e4fa44, // n0x0bf8 c0x0093 (n0x0f4c-n0x0f4d)* o I kobe
	0x252cc705, // n0x0bf9 c0x0094 (n0x0f4d-n0x0f6c)  + I kochi
	0x256b5448, // n0x0bfa c0x0095 (n0x0f6c-n0x0f86)  + I kumamoto
	0x25ac0005, // n0x0bfb c0x0096 (n0x0f86-n0x0fa5)  + I kyoto
	0x0021b942, // n0x0bfc c0x0000 (---------------)  + I lg
	0x25e65083, // n0x0bfd c0x0097 (n0x0fa5-n0x0fc3)  + I mie
	0x262a4006, // n0x0bfe c0x0098 (n0x0fc3-n0x0fe4)  + I miyagi
	0x26666248, // n0x0bff c0x0099 (n0x0fe4-n0x0fff)  + I miyazaki
	0x26b52206, // n0x0c00 c0x009a (n0x0fff-n0x104a)  + I nagano
	0x26ee33c8, // n0x0c01 c0x009b (n0x104a-n0x1060)  + I nagasaki
	0x27255a46, // n0x0c02 c0x009c (n0x1060-n0x1061)* o I nagoya
	0x2771c044, // n0x0c03 c0x009d (n0x1061-n0x1087)  + I nara
	0x00202ac2, // n0x0c04 c0x0000 (---------------)  + I ne
	0x27a350c7, // n0x0c05 c0x009e (n0x1087-n0x10a9)  + I niigata
	0x27ea9804, // n0x0c06 c0x009f (n0x10a9-n0x10bc)  + I oita
	0x28278bc7, // n0x0c07 c0x00a0 (n0x10bc-n0x10d6)  + I okayama
	0x28795107, // n0x0c08 c0x00a1 (n0x10d6-n0x1100)  + I okinawa
	0x00200dc2, // n0x0c09 c0x0000 (---------------)  + I or
	0x28a9b185, // n0x0c0a c0x00a2 (n0x1100-n0x1132)  + I osaka
	0x28f78a84, // n0x0c0b c0x00a3 (n0x1132-n0x114c)  + I saga
	0x29373887, // n0x0c0c c0x00a4 (n0x114c-n0x1191)  + I saitama
	0x29617047, // n0x0c0d c0x00a5 (n0x1191-n0x1192)* o I sapporo
	0x29a83506, // n0x0c0e c0x00a6 (n0x1192-n0x1193)* o I sendai
	0x29e235c5, // n0x0c0f c0x00a7 (n0x1193-n0x11aa)  + I shiga
	0x2a295687, // n0x0c10 c0x00a8 (n0x11aa-n0x11c1)  + I shimane
	0x2a6b13c8, // n0x0c11 c0x00a9 (n0x11c1-n0x11e5)  + I shizuoka
	0x2ab44807, // n0x0c12 c0x00aa (n0x11e5-n0x1204)  + I tochigi
	0x2ae90009, // n0x0c13 c0x00ab (n0x1204-n0x1215)  + I tokushima
	0x2b342205, // n0x0c14 c0x00ac (n0x1215-n0x124e)  + I tokyo
	0x2b6f7a87, // n0x0c15 c0x00ad (n0x124e-n0x125b)  + I tottori
	0x2ba902c6, // n0x0c16 c0x00ae (n0x125b-n0x1273)  + I toyama
	0x2be27348, // n0x0c17 c0x00af (n0x1273-n0x1290)  + I wakayama
	0x002313cd, // n0x0c18 c0x0000 (---------------)  + I xn--0trq7p7nn
	0x00253349, // n0x0c19 c0x0000 (---------------)  + I xn--1ctwo
	0x0025c5cb, // n0x0c1a c0x0000 (---------------)  + I xn--1lqs03n
	0x00268ecb, // n0x0c1b c0x0000 (---------------)  + I xn--1lqs71d
	0x0027c4cb, // n0x0c1c c0x0000 (---------------)  + I xn--2m4a15e
	0x002a830b, // n0x0c1d c0x0000 (---------------)  + I xn--32vp30h
	0x00300a8b, // n0x0c1e c0x0000 (---------------)  + I xn--4it168d
	0x00300d4b, // n0x0c1f c0x0000 (---------------)  + I xn--4it797k
	0x00302ac9, // n0x0c20 c0x0000 (---------------)  + I xn--4pvxs
	0x00303bcb, // n0x0c21 c0x0000 (---------------)  + I xn--5js045d
	0x00303e8b, // n0x0c22 c0x0000 (---------------)  + I xn--5rtp49c
	0x0030430b, // n0x0c23 c0x0000 (---------------)  + I xn--5rtq34k
	0x00304e0a, // n0x0c24 c0x0000 (---------------)  + I xn--6btw5a
	0x0030534a, // n0x0c25 c0x0000 (---------------)  + I xn--6orx2r
	0x0030594c, // n0x0c26 c0x0000 (---------------)  + I xn--7t0a264c
	0x0030bdcb, // n0x0c27 c0x0000 (---------------)  + I xn--8ltr62k
	0x0030c78a, // n0x0c28 c0x0000 (---------------)  + I xn--8pvr4u
	0x0031b80a, // n0x0c29 c0x0000 (---------------)  + I xn--c3s14m
	0x0032a50e, // n0x0c2a c0x0000 (---------------)  + I xn--d5qv7z876c
	0x0032b7ce, // n0x0c2b c0x0000 (---------------)  + I xn--djrs72d6uy
	0x0032bb4a, // n0x0c2c c0x0000 (---------------)  + I xn--djty4k
	0x0032d24a, // n0x0c2d c0x0000 (---------------)  + I xn--efvn9s
	0x0032db8b, // n0x0c2e c0x0000 (---------------)  + I xn--ehqz56n
	0x0032de4b, // n0x0c2f c0x0000 (---------------)  + I xn--elqq16h
	0x0032eb8b, // n0x0c30 c0x0000 (---------------)  + I xn--f6qx53a
	0x0034624b, // n0x0c31 c0x0000 (---------------)  + I xn--k7yn95e
	0x0034684a, // n0x0c32 c0x0000 (---------------)  + I xn--kbrq7o
	0x0034750b, // n0x0c33 c0x0000 (---------------)  + I xn--klt787d
	0x003477ca, // n0x0c34 c0x0000 (---------------)  + I xn--kltp7d
	0x00347a4a, // n0x0c35 c0x0000 (---------------)  + I xn--kltx9a
	0x00347cca, // n0x0c36 c0x0000 (---------------)  + I xn--klty5x
	0x00367fcb, // n0x0c37 c0x0000 (---------------)  + I xn--mkru45i
	0x0036fd0b, // n0x0c38 c0x0000 (---------------)  + I xn--nit225k
	0x0037194e, // n0x0c39 c0x0000 (---------------)  + I xn--ntso0iqx3a
	0x00371ccb, // n0x0c3a c0x0000 (---------------)  + I xn--ntsq17g
	0x0037a8cb, // n0x0c3b c0x0000 (---------------)  + I xn--pssu33l
	0x0037c50b, // n0x0c3c c0x0000 (---------------)  + I xn--qqqt11m
	0x0037f34a, // n0x0c3d c0x0000 (---------------)  + I xn--rht27z
	0x0037f5c9, // n0x0c3e c0x0000 (---------------)  + I xn--rht3d
	0x0037f80a, // n0x0c3f c0x0000 (---------------)  + I xn--rht61e
	0x00380e8a, // n0x0c40 c0x0000 (---------------)  + I xn--rny31h
	0x0039244b, // n0x0c41 c0x0000 (---------------)  + I xn--tor131o
	0x00393f8b, // n0x0c42 c0x0000 (---------------)  + I xn--uist22h
	0x00394a4a, // n0x0c43 c0x0000 (---------------)  + I xn--uisz3g
	0x00395d8b, // n0x0c44 c0x0000 (---------------)  + I xn--uuwu58a
	0x0039b38b, // n0x0c45 c0x0000 (---------------)  + I xn--vgu402c
	0x003a41cb, // n0x0c46 c0x0000 (---------------)  + I xn--zbx025d
	0x2c2815c8, // n0x0c47 c0x00b0 (n0x1290-n0x12b2)  + I yamagata
	0x2c689a89, // n0x0c48 c0x00b1 (n0x12b2-n0x12c2)  + I yamaguchi
	0x2caa2d49, // n0x0c49 c0x00b2 (n0x12c2-n0x12de)  + I yamanashi
	0x2ced1a88, // n0x0c4a c0x00b3 (n0x12de-n0x12df)* o I yokohama
	0x00334c45, // n0x0c4b c0x0000 (---------------)  + I aisai
	0x00201f03, // n0x0c4c c0x0000 (---------------)  + I ama
	0x00201044, // n0x0c4d c0x0000 (---------------)  + I anjo
	0x00360f85, // n0x0c4e c0x0000 (---------------)  + I asuke
	0x002ade06, // n0x0c4f c0x0000 (---------------)  + I chiryu
	0x002b0305, // n0x0c50 c0x0000 (---------------)  + I chita
	0x00289284, // n0x0c51 c0x0000 (---------------)  + I fuso
	0x002702c8, // n0x0c52 c0x0000 (---------------)  + I gamagori
	0x00256bc5, // n0x0c53 c0x0000 (---------------)  + I handa
	0x00291884, // n0x0c54 c0x0000 (---------------)  + I hazu
	0x002c5007, // n0x0c55 c0x0000 (---------------)  + I hekinan
	0x0029e9ca, // n0x0c56 c0x0000 (---------------)  + I higashiura
	0x002d37ca, // n0x0c57 c0x0000 (---------------)  + I ichinomiya
	0x00302f47, // n0x0c58 c0x0000 (---------------)  + I inazawa
	0x00204147, // n0x0c59 c0x0000 (---------------)  + I inuyama
	0x002ed587, // n0x0c5a c0x0000 (---------------)  + I isshiki
	0x0022cc87, // n0x0c5b c0x0000 (---------------)  + I iwakura
	0x0029a545, // n0x0c5c c0x0000 (---------------)  + I kanie
	0x00324906, // n0x0c5d c0x0000 (---------------)  + I kariya
	0x00311947, // n0x0c5e c0x0000 (---------------)  + I kasugai
	0x0024c144, // n0x0c5f c0x0000 (---------------)  + I kira
	0x00358786, // n0x0c60 c0x0000 (---------------)  + I kiyosu
	0x0028ee46, // n0x0c61 c0x0000 (---------------)  + I komaki
	0x00203b05, // n0x0c62 c0x0000 (---------------)  + I konan
	0x00355204, // n0x0c63 c0x0000 (---------------)  + I kota
	0x002a9086, // n0x0c64 c0x0000 (---------------)  + I mihama
	0x0029dbc7, // n0x0c65 c0x0000 (---------------)  + I miyoshi
	0x002210c6, // n0x0c66 c0x0000 (---------------)  + I nishio
	0x0022fe47, // n0x0c67 c0x0000 (---------------)  + I nisshin
	0x0027d083, // n0x0c68 c0x0000 (---------------)  + I obu
	0x00252306, // n0x0c69 c0x0000 (---------------)  + I oguchi
	0x00236705, // n0x0c6a c0x0000 (---------------)  + I oharu
	0x0027f6c7, // n0x0c6b c0x0000 (---------------)  + I okazaki
	0x002c09ca, // n0x0c6c c0x0000 (---------------)  + I owariasahi
	0x00288604, // n0x0c6d c0x0000 (---------------)  + I seto
	0x002197c8, // n0x0c6e c0x0000 (---------------)  + I shikatsu
	0x00381509, // n0x0c6f c0x0000 (---------------)  + I shinshiro
	0x002fd347, // n0x0c70 c0x0000 (---------------)  + I shitara
	0x002e8886, // n0x0c71 c0x0000 (---------------)  + I tahara
	0x0035e8c8, // n0x0c72 c0x0000 (---------------)  + I takahama
	0x00307b49, // n0x0c73 c0x0000 (---------------)  + I tobishima
	0x00368744, // n0x0c74 c0x0000 (---------------)  + I toei
	0x002ff504, // n0x0c75 c0x0000 (---------------)  + I togo
	0x002f91c5, // n0x0c76 c0x0000 (---------------)  + I tokai
	0x002c1548, // n0x0c77 c0x0000 (---------------)  + I tokoname
	0x002c1f87, // n0x0c78 c0x0000 (---------------)  + I toyoake
	0x00285c49, // n0x0c79 c0x0000 (---------------)  + I toyohashi
	0x002472c8, // n0x0c7a c0x0000 (---------------)  + I toyokawa
	0x00366b06, // n0x0c7b c0x0000 (---------------)  + I toyone
	0x00264186, // n0x0c7c c0x0000 (---------------)  + I toyota
	0x002980c8, // n0x0c7d c0x0000 (---------------)  + I tsushima
	0x0036af06, // n0x0c7e c0x0000 (---------------)  + I yatomi
	0x00204785, // n0x0c7f c0x0000 (---------------)  + I akita
	0x002835c6, // n0x0c80 c0x0000 (---------------)  + I daisen
	0x00278ec8, // n0x0c81 c0x0000 (---------------)  + I fujisato
	0x00239506, // n0x0c82 c0x0000 (---------------)  + I gojome
	0x00250e8b, // n0x0c83 c0x0000 (---------------)  + I hachirogata
	0x0028d246, // n0x0c84 c0x0000 (---------------)  + I happou
	0x00299acd, // n0x0c85 c0x0000 (---------------)  + I higashinaruse
	0x0038d6c5, // n0x0c86 c0x0000 (---------------)  + I honjo
	0x002a96c6, // n0x0c87 c0x0000 (---------------)  + I honjyo
	0x0021b385, // n0x0c88 c0x0000 (---------------)  + I ikawa
	0x002971c9, // n0x0c89 c0x0000 (---------------)  + I kamikoani
	0x0030a307, // n0x0c8a c0x0000 (---------------)  + I kamioka
	0x00376ec8, // n0x0c8b c0x0000 (---------------)  + I katagami
	0x002db5c6, // n0x0c8c c0x0000 (---------------)  + I kazuno
	0x00298a49, // n0x0c8d c0x0000 (---------------)  + I kitaakita
	0x002e2c86, // n0x0c8e c0x0000 (---------------)  + I kosaka
	0x002c0945, // n0x0c8f c0x0000 (---------------)  + I kyowa
	0x0022da46, // n0x0c90 c0x0000 (---------------)  + I misato
	0x002b3246, // n0x0c91 c0x0000 (---------------)  + I mitane
	0x002c81c9, // n0x0c92 c0x0000 (---------------)  + I moriyoshi
	0x0034f4c6, // n0x0c93 c0x0000 (---------------)  + I nikaho
	0x003744c7, // n0x0c94 c0x0000 (---------------)  + I noshiro
	0x002c7905, // n0x0c95 c0x0000 (---------------)  + I odate
	0x002028c3, // n0x0c96 c0x0000 (---------------)  + I oga
	0x002270c5, // n0x0c97 c0x0000 (---------------)  + I ogata
	0x002a7407, // n0x0c98 c0x0000 (---------------)  + I semboku
	0x00331906, // n0x0c99 c0x0000 (---------------)  + I yokote
	0x0038d5c9, // n0x0c9a c0x0000 (---------------)  + I yurihonjo
	0x0030ddc6, // n0x0c9b c0x0000 (---------------)  + I aomori
	0x0024ed86, // n0x0c9c c0x0000 (---------------)  + I gonohe
	0x0020ed89, // n0x0c9d c0x0000 (---------------)  + I hachinohe
	0x00282fc9, // n0x0c9e c0x0000 (---------------)  + I hashikami
	0x002a0b87, // n0x0c9f c0x0000 (---------------)  + I hiranai
	0x00327108, // n0x0ca0 c0x0000 (---------------)  + I hirosaki
	0x0025e449, // n0x0ca1 c0x0000 (---------------)  + I itayanagi
	0x0027fb88, // n0x0ca2 c0x0000 (---------------)  + I kuroishi
	0x0037c786, // n0x0ca3 c0x0000 (---------------)  + I misawa
	0x002d1485, // n0x0ca4 c0x0000 (---------------)  + I mutsu
	0x002227ca, // n0x0ca5 c0x0000 (---------------)  + I nakadomari
	0x0024ee06, // n0x0ca6 c0x0000 (---------------)  + I noheji
	0x00206c06, // n0x0ca7 c0x0000 (---------------)  + I oirase
	0x002a41c5, // n0x0ca8 c0x0000 (---------------)  + I owani
	0x002ae408, // n0x0ca9 c0x0000 (---------------)  + I rokunohe
	0x00209a87, // n0x0caa c0x0000 (---------------)  + I sannohe
	0x00236a0a, // n0x0cab c0x0000 (---------------)  + I shichinohe
	0x0024ec86, // n0x0cac c0x0000 (---------------)  + I shingo
	0x0023fe05, // n0x0cad c0x0000 (---------------)  + I takko
	0x00255cc6, // n0x0cae c0x0000 (---------------)  + I towada
	0x0028f587, // n0x0caf c0x0000 (---------------)  + I tsugaru
	0x002e8747, // n0x0cb0 c0x0000 (---------------)  + I tsuruta
	0x00374145, // n0x0cb1 c0x0000 (---------------)  + I abiko
	0x002c0b05, // n0x0cb2 c0x0000 (---------------)  + I asahi
	0x002e6786, // n0x0cb3 c0x0000 (---------------)  + I chonan
	0x002e7846, // n0x0cb4 c0x0000 (---------------)  + I chosei
	0x002fee46, // n0x0cb5 c0x0000 (---------------)  + I choshi
	0x0032c104, // n0x0cb6 c0x0000 (---------------)  + I chuo
	0x00282089, // n0x0cb7 c0x0000 (---------------)  + I funabashi
	0x0028a946, // n0x0cb8 c0x0000 (---------------)  + I futtsu
	0x00283b8a, // n0x0cb9 c0x0000 (---------------)  + I hanamigawa
	0x00290e48, // n0x0cba c0x0000 (---------------)  + I ichihara
	0x00263808, // n0x0cbb c0x0000 (---------------)  + I ichikawa
	0x002d37ca, // n0x0cbc c0x0000 (---------------)  + I ichinomiya
	0x00209705, // n0x0cbd c0x0000 (---------------)  + I inzai
	0x0029db05, // n0x0cbe c0x0000 (---------------)  + I isumi
	0x003083c8, // n0x0cbf c0x0000 (---------------)  + I kamagaya
	0x002cc488, // n0x0cc0 c0x0000 (---------------)  + I kamogawa
	0x002032c7, // n0x0cc1 c0x0000 (---------------)  + I kashiwa
	0x0029ca86, // n0x0cc2 c0x0000 (---------------)  + I katori
	0x00316708, // n0x0cc3 c0x0000 (---------------)  + I katsuura
	0x0023e107, // n0x0cc4 c0x0000 (---------------)  + I kimitsu
	0x00281a88, // n0x0cc5 c0x0000 (---------------)  + I kisarazu
	0x00369606, // n0x0cc6 c0x0000 (---------------)  + I kozaki
	0x00284148, // n0x0cc7 c0x0000 (---------------)  + I kujukuri
	0x002b5f46, // n0x0cc8 c0x0000 (---------------)  + I kyonan
	0x0023bd07, // n0x0cc9 c0x0000 (---------------)  + I matsudo
	0x00299486, // n0x0cca c0x0000 (---------------)  + I midori
	0x002a9086, // n0x0ccb c0x0000 (---------------)  + I mihama
	0x0023484a, // n0x0ccc c0x0000 (---------------)  + I minamiboso
	0x00233dc6, // n0x0ccd c0x0000 (---------------)  + I mobara
	0x002d1489, // n0x0cce c0x0000 (---------------)  + I mutsuzawa
	0x002afd46, // n0x0ccf c0x0000 (---------------)  + I nagara
	0x002d2c8a, // n0x0cd0 c0x0000 (---------------)  + I nagareyama
	0x0031c049, // n0x0cd1 c0x0000 (---------------)  + I narashino
	0x0035bd46, // n0x0cd2 c0x0000 (---------------)  + I narita
	0x0037d844, // n0x0cd3 c0x0000 (---------------)  + I noda
	0x0030788d, // n0x0cd4 c0x0000 (---------------)  + I oamishirasato
	0x00289d07, // n0x0cd5 c0x0000 (---------------)  + I omigawa
	0x00318d06, // n0x0cd6 c0x0000 (---------------)  + I onjuku
	0x002ba2c5, // n0x0cd7 c0x0000 (---------------)  + I otaki
	0x002e2d05, // n0x0cd8 c0x0000 (---------------)  + I sakae
	0x002dc646, // n0x0cd9 c0x0000 (---------------)  + I sakura
	0x0028fc49, // n0x0cda c0x0000 (---------------)  + I shimofusa
	0x002a6b07, // n0x0cdb c0x0000 (---------------)  + I shirako
	0x0027a7c6, // n0x0cdc c0x0000 (---------------)  + I shiroi
	0x002fcc86, // n0x0cdd c0x0000 (---------------)  + I shisui
	0x00289309, // n0x0cde c0x0000 (---------------)  + I sodegaura
	0x0021d284, // n0x0cdf c0x0000 (---------------)  + I sosa
	0x00229144, // n0x0ce0 c0x0000 (---------------)  + I tako
	0x00201dc8, // n0x0ce1 c0x0000 (---------------)  + I tateyama
	0x002b0fc6, // n0x0ce2 c0x0000 (---------------)  + I togane
	0x002a0508, // n0x0ce3 c0x0000 (---------------)  + I tohnosho
	0x0022d9c8, // n0x0ce4 c0x0000 (---------------)  + I tomisato
	0x0027eac7, // n0x0ce5 c0x0000 (---------------)  + I urayasu
	0x00200309, // n0x0ce6 c0x0000 (---------------)  + I yachimata
	0x002ff047, // n0x0ce7 c0x0000 (---------------)  + I yachiyo
	0x002af90a, // n0x0ce8 c0x0000 (---------------)  + I yokaichiba
	0x0022d38f, // n0x0ce9 c0x0000 (---------------)  + I yokoshibahikari
	0x0026840a, // n0x0cea c0x0000 (---------------)  + I yotsukaido
	0x00226ac5, // n0x0ceb c0x0000 (---------------)  + I ainan
	0x00279105, // n0x0cec c0x0000 (---------------)  + I honai
	0x00216505, // n0x0ced c0x0000 (---------------)  + I ikata
	0x00248647, // n0x0cee c0x0000 (---------------)  + I imabari
	0x00203543, // n0x0cef c0x0000 (---------------)  + I iyo
	0x00327308, // n0x0cf0 c0x0000 (---------------)  + I kamijima
	0x002f1746, // n0x0cf1 c0x0000 (---------------)  + I kihoku
	0x002f1849, // n0x0cf2 c0x0000 (---------------)  + I kumakogen
	0x003a4d86, // n0x0cf3 c0x0000 (---------------)  + I masaki
	0x002c1947, // n0x0cf4 c0x0000 (---------------)  + I matsuno
	0x00298809, // n0x0cf5 c0x0000 (---------------)  + I matsuyama
	0x00376dc8, // n0x0cf6 c0x0000 (---------------)  + I namikata
	0x002a4287, // n0x0cf7 c0x0000 (---------------)  + I niihama
	0x002ffa83, // n0x0cf8 c0x0000 (---------------)  + I ozu
	0x00334cc5, // n0x0cf9 c0x0000 (---------------)  + I saijo
	0x00379845, // n0x0cfa c0x0000 (---------------)  + I seiyo
	0x0032bf4b, // n0x0cfb c0x0000 (---------------)  + I shikokuchuo
	0x002c00c4, // n0x0cfc c0x0000 (---------------)  + I tobe
	0x0020cc04, // n0x0cfd c0x0000 (---------------)  + I toon
	0x00277e86, // n0x0cfe c0x0000 (---------------)  + I uchiko
	0x002ffe07, // n0x0cff c0x0000 (---------------)  + I uwajima
	0x0038e68a, // n0x0d00 c0x0000 (---------------)  + I yawatahama
	0x00349887, // n0x0d01 c0x0000 (---------------)  + I echizen
	0x003687c7, // n0x0d02 c0x0000 (---------------)  + I eiheiji
	0x0027de85, // n0x0d03 c0x0000 (---------------)  + I fukui
	0x00202445, // n0x0d04 c0x0000 (---------------)  + I ikeda
	0x0021c9c9, // n0x0d05 c0x0000 (---------------)  + I katsuyama
	0x002a9086, // n0x0d06 c0x0000 (---------------)  + I mihama
	0x0034970d, // n0x0d07 c0x0000 (---------------)  + I minamiechizen
	0x003954c5, // n0x0d08 c0x0000 (---------------)  + I obama
	0x002a0703, // n0x0d09 c0x0000 (---------------)  + I ohi
	0x0020c303, // n0x0d0a c0x0000 (---------------)  + I ono
	0x002f20c5, // n0x0d0b c0x0000 (---------------)  + I sabae
	0x0034a305, // n0x0d0c c0x0000 (---------------)  + I sakai
	0x0035e8c8, // n0x0d0d c0x0000 (---------------)  + I takahama
	0x0027bec7, // n0x0d0e c0x0000 (---------------)  + I tsuruga
	0x00228ec6, // n0x0d0f c0x0000 (---------------)  + I wakasa
	0x0029f086, // n0x0d10 c0x0000 (---------------)  + I ashiya
	0x0022e9c5, // n0x0d11 c0x0000 (---------------)  + I buzen
	0x002393c7, // n0x0d12 c0x0000 (---------------)  + I chikugo
	0x002043c7, // n0x0d13 c0x0000 (---------------)  + I chikuho
	0x002949c7, // n0x0d14 c0x0000 (---------------)  + I chikujo
	0x002cc78a, // n0x0d15 c0x0000 (---------------)  + I chikushino
	0x002523c8, // n0x0d16 c0x0000 (---------------)  + I chikuzen
	0x0032c104, // n0x0d17 c0x0000 (---------------)  + I chuo
	0x00215507, // n0x0d18 c0x0000 (---------------)  + I dazaifu
	0x0027d1c7, // n0x0d19 c0x0000 (---------------)  + I fukuchi
	0x0032d806, // n0x0d1a c0x0000 (---------------)  + I hakata
	0x00266d87, // n0x0d1b c0x0000 (---------------)  + I higashi
	0x002d4208, // n0x0d1c c0x0000 (---------------)  + I hirokawa
	0x002a2c48, // n0x0d1d c0x0000 (---------------)  + I hisayama
	0x0026fd86, // n0x0d1e c0x0000 (---------------)  + I iizuka
	0x0021a8c8, // n0x0d1f c0x0000 (---------------)  + I inatsuki
	0x002c7d84, // n0x0d20 c0x0000 (---------------)  + I kaho
	0x00311946, // n0x0d21 c0x0000 (---------------)  + I kasuga
	0x0020ba06, // n0x0d22 c0x0000 (---------------)  + I kasuya
	0x00203606, // n0x0d23 c0x0000 (---------------)  + I kawara
	0x002f5006, // n0x0d24 c0x0000 (---------------)  + I keisen
	0x0021fc44, // n0x0d25 c0x0000 (---------------)  + I koga
	0x0022cd46, // n0x0d26 c0x0000 (---------------)  + I kurate
	0x002b9346, // n0x0d27 c0x0000 (---------------)  + I kurogi
	0x00297846, // n0x0d28 c0x0000 (---------------)  + I kurume
	0x00223406, // n0x0d29 c0x0000 (---------------)  + I minami
	0x0020c1c6, // n0x0d2a c0x0000 (---------------)  + I miyako
	0x002d4046, // n0x0d2b c0x0000 (---------------)  + I miyama
	0x00228dc8, // n0x0d2c c0x0000 (---------------)  + I miyawaka
	0x00358608, // n0x0d2d c0x0000 (---------------)  + I mizumaki
	0x002cd388, // n0x0d2e c0x0000 (---------------)  + I munakata
	0x002b0508, // n0x0d2f c0x0000 (---------------)  + I nakagawa
	0x00308346, // n0x0d30 c0x0000 (---------------)  + I nakama
	0x00210385, // n0x0d31 c0x0000 (---------------)  + I nishi
	0x00227086, // n0x0d32 c0x0000 (---------------)  + I nogata
	0x002ace45, // n0x0d33 c0x0000 (---------------)  + I ogori
	0x0037e787, // n0x0d34 c0x0000 (---------------)  + I okagaki
	0x002035c5, // n0x0d35 c0x0000 (---------------)  + I okawa
	0x00215e83, // n0x0d36 c0x0000 (---------------)  + I oki
	0x00203ec5, // n0x0d37 c0x0000 (---------------)  + I omuta
	0x0026e544, // n0x0d38 c0x0000 (---------------)  + I onga
	0x0020c305, // n0x0d39 c0x0000 (---------------)  + I onojo
	0x002135c3, // n0x0d3a c0x0000 (---------------)  + I oto
	0x002ddcc7, // n0x0d3b c0x0000 (---------------)  + I saigawa
	0x0036ee48, // n0x0d3c c0x0000 (---------------)  + I sasaguri
	0x0022ff06, // n0x0d3d c0x0000 (---------------)  + I shingu
	0x0029a1cd, // n0x0d3e c0x0000 (---------------)  + I shinyoshitomi
	0x002790c6, // n0x0d3f c0x0000 (---------------)  + I shonai
	0x002968c5, // n0x0d40 c0x0000 (---------------)  + I soeda
	0x002c8583, // n0x0d41 c0x0000 (---------------)  + I sue
	0x002b4e09, // n0x0d42 c0x0000 (---------------)  + I tachiarai
	0x002c3a06, // n0x0d43 c0x0000 (---------------)  + I tagawa
	0x00296ec6, // n0x0d44 c0x0000 (---------------)  + I takata
	0x0034a844, // n0x0d45 c0x0000 (---------------)  + I toho
	0x00268387, // n0x0d46 c0x0000 (---------------)  + I toyotsu
	0x0023a6c6, // n0x0d47 c0x0000 (---------------)  + I tsuiki
	0x002ae245, // n0x0d48 c0x0000 (---------------)  + I ukiha
	0x0020a4c3, // n0x0d49 c0x0000 (---------------)  + I umi
	0x0020b604, // n0x0d4a c0x0000 (---------------)  + I usui
	0x0027d386, // n0x0d4b c0x0000 (---------------)  + I yamada
	0x0029d304, // n0x0d4c c0x0000 (---------------)  + I yame
	0x0030fe08, // n0x0d4d c0x0000 (---------------)  + I yanagawa
	0x00381b49, // n0x0d4e c0x0000 (---------------)  + I yukuhashi
	0x002bb289, // n0x0d4f c0x0000 (---------------)  + I aizubange
	0x002a030a, // n0x0d50 c0x0000 (---------------)  + I aizumisato
	0x0024438d, // n0x0d51 c0x0000 (---------------)  + I aizuwakamatsu
	0x00247f07, // n0x0d52 c0x0000 (---------------)  + I asakawa
	0x00206a86, // n0x0d53 c0x0000 (---------------)  + I bandai
	0x0020da04, // n0x0d54 c0x0000 (---------------)  + I date
	0x003547c9, // n0x0d55 c0x0000 (---------------)  + I fukushima
	0x00287748, // n0x0d56 c0x0000 (---------------)  + I furudono
	0x00289906, // n0x0d57 c0x0000 (---------------)  + I futaba
	0x0025a4c6, // n0x0d58 c0x0000 (---------------)  + I hanawa
	0x00266d87, // n0x0d59 c0x0000 (---------------)  + I higashi
	0x002cfd86, // n0x0d5a c0x0000 (---------------)  + I hirata
	0x0021c306, // n0x0d5b c0x0000 (---------------)  + I hirono
	0x00381e46, // n0x0d5c c0x0000 (---------------)  + I iitate
	0x0039518a, // n0x0d5d c0x0000 (---------------)  + I inawashiro
	0x0021b2c8, // n0x0d5e c0x0000 (---------------)  + I ishikawa
	0x002243c5, // n0x0d5f c0x0000 (---------------)  + I iwaki
	0x0027e809, // n0x0d60 c0x0000 (---------------)  + I izumizaki
	0x002c270a, // n0x0d61 c0x0000 (---------------)  + I kagamiishi
	0x002c91c8, // n0x0d62 c0x0000 (---------------)  + I kaneyama
	0x0029bec8, // n0x0d63 c0x0000 (---------------)  + I kawamata
	0x00296e48, // n0x0d64 c0x0000 (---------------)  + I kitakata
	0x002047cc, // n0x0d65 c0x0000 (---------------)  + I kitashiobara
	0x0034b345, // n0x0d66 c0x0000 (---------------)  + I koori
	0x0029f308, // n0x0d67 c0x0000 (---------------)  + I koriyama
	0x002fb106, // n0x0d68 c0x0000 (---------------)  + I kunimi
	0x002ac346, // n0x0d69 c0x0000 (---------------)  + I miharu
	0x002c0d47, // n0x0d6a c0x0000 (---------------)  + I mishima
	0x00349785, // n0x0d6b c0x0000 (---------------)  + I namie
	0x00283745, // n0x0d6c c0x0000 (---------------)  + I nango
	0x002bb149, // n0x0d6d c0x0000 (---------------)  + I nishiaizu
	0x00210907, // n0x0d6e c0x0000 (---------------)  + I nishigo
	0x002f1805, // n0x0d6f c0x0000 (---------------)  + I okuma
	0x0021cf87, // n0x0d70 c0x0000 (---------------)  + I omotego
	0x0020c303, // n0x0d71 c0x0000 (---------------)  + I ono
	0x002c2bc5, // n0x0d72 c0x0000 (---------------)  + I otama
	0x00320d08, // n0x0d73 c0x0000 (---------------)  + I samegawa
	0x002af287, // n0x0d74 c0x0000 (---------------)  + I shimogo
	0x0029bd89, // n0x0d75 c0x0000 (---------------)  + I shirakawa
	0x002b2f45, // n0x0d76 c0x0000 (---------------)  + I showa
	0x002f87c4, // n0x0d77 c0x0000 (---------------)  + I soma
	0x002a1a88, // n0x0d78 c0x0000 (---------------)  + I sukagawa
	0x0023d287, // n0x0d79 c0x0000 (---------------)  + I taishin
	0x002a4448, // n0x0d7a c0x0000 (---------------)  + I tamakawa
	0x00331e48, // n0x0d7b c0x0000 (---------------)  + I tanagura
	0x002cf345, // n0x0d7c c0x0000 (---------------)  + I tenei
	0x0034ed86, // n0x0d7d c0x0000 (---------------)  + I yabuki
	0x00290986, // n0x0d7e c0x0000 (---------------)  + I yamato
	0x0025b789, // n0x0d7f c0x0000 (---------------)  + I yamatsuri
	0x00316f87, // n0x0d80 c0x0000 (---------------)  + I yanaizu
	0x002ad706, // n0x0d81 c0x0000 (---------------)  + I yugawa
	0x0033c5c7, // n0x0d82 c0x0000 (---------------)  + I anpachi
	0x00217883, // n0x0d83 c0x0000 (---------------)  + I ena
	0x002ae0c4, // n0x0d84 c0x0000 (---------------)  + I gifu
	0x002a23c5, // n0x0d85 c0x0000 (---------------)  + I ginan
	0x00215784, // n0x0d86 c0x0000 (---------------)  + I godo
	0x002328c4, // n0x0d87 c0x0000 (---------------)  + I gujo
	0x00281847, // n0x0d88 c0x0000 (---------------)  + I hashima
	0x00217f87, // n0x0d89 c0x0000 (---------------)  + I hichiso
	0x0027a984, // n0x0d8a c0x0000 (---------------)  + I hida
	0x0029bbd0, // n0x0d8b c0x0000 (---------------)  + I higashishirakawa
	0x002dc7c7, // n0x0d8c c0x0000 (---------------)  + I ibigawa
	0x00202445, // n0x0d8d c0x0000 (---------------)  + I ikeda
	0x002eb24c, // n0x0d8e c0x0000 (---------------)  + I kakamigahara
	0x00279ac4, // n0x0d8f c0x0000 (---------------)  + I kani
	0x00292e08, // n0x0d90 c0x0000 (---------------)  + I kasahara
	0x0023bc09, // n0x0d91 c0x0000 (---------------)  + I kasamatsu
	0x00300906, // n0x0d92 c0x0000 (---------------)  + I kawaue
	0x0021d388, // n0x0d93 c0x0000 (---------------)  + I kitagata
	0x0024e344, // n0x0d94 c0x0000 (---------------)  + I mino
	0x0024e348, // n0x0d95 c0x0000 (---------------)  + I minokamo
	0x00267246, // n0x0d96 c0x0000 (---------------)  + I mitake
	0x00223288, // n0x0d97 c0x0000 (---------------)  + I mizunami
	0x002a20c6, // n0x0d98 c0x0000 (---------------)  + I motosu
	0x0030624b, // n0x0d99 c0x0000 (---------------)  + I nakatsugawa
	0x002028c5, // n0x0d9a c0x0000 (---------------)  + I ogaki
	0x002c7d08, // n0x0d9b c0x0000 (---------------)  + I sakahogi
	0x00219284, // n0x0d9c c0x0000 (---------------)  + I seki
	0x00282c4a, // n0x0d9d c0x0000 (---------------)  + I sekigahara
	0x0029bd89, // n0x0d9e c0x0000 (---------------)  + I shirakawa
	0x002889c6, // n0x0d9f c0x0000 (---------------)  + I tajimi
	0x002c17c8, // n0x0da0 c0x0000 (---------------)  + I takayama
	0x00273f05, // n0x0da1 c0x0000 (---------------)  + I tarui
	0x00226184, // n0x0da2 c0x0000 (---------------)  + I toki
	0x00292d06, // n0x0da3 c0x0000 (---------------)  + I tomika
	0x00294888, // n0x0da4 c0x0000 (---------------)  + I wanouchi
	0x002815c8, // n0x0da5 c0x0000 (---------------)  + I yamagata
	0x00341d46, // n0x0da6 c0x0000 (---------------)  + I yaotsu
	0x00311044, // n0x0da7 c0x0000 (---------------)  + I yoro
	0x00222746, // n0x0da8 c0x0000 (---------------)  + I annaka
	0x002ff0c7, // n0x0da9 c0x0000 (---------------)  + I chiyoda
	0x00278ac7, // n0x0daa c0x0000 (---------------)  + I fujioka
	0x00266d8f, // n0x0dab c0x0000 (---------------)  + I higashiagatsuma
	0x00204e87, // n0x0dac c0x0000 (---------------)  + I isesaki
	0x0035be07, // n0x0dad c0x0000 (---------------)  + I itakura
	0x002ac205, // n0x0dae c0x0000 (---------------)  + I kanna
	0x002d6c85, // n0x0daf c0x0000 (---------------)  + I kanra
	0x002a0849, // n0x0db0 c0x0000 (---------------)  + I katashina
	0x00250c86, // n0x0db1 c0x0000 (---------------)  + I kawaba
	0x00280285, // n0x0db2 c0x0000 (---------------)  + I kiryu
	0x002832c7, // n0x0db3 c0x0000 (---------------)  + I kusatsu
	0x002c76c8, // n0x0db4 c0x0000 (---------------)  + I maebashi
	0x002bbc05, // n0x0db5 c0x0000 (---------------)  + I meiwa
	0x00299486, // n0x0db6 c0x0000 (---------------)  + I midori
	0x00215fc8, // n0x0db7 c0x0000 (---------------)  + I minakami
	0x0035220a, // n0x0db8 c0x0000 (---------------)  + I naganohara
	0x003536c8, // n0x0db9 c0x0000 (---------------)  + I nakanojo
	0x003a0647, // n0x0dba c0x0000 (---------------)  + I nanmoku
	0x0022d7c6, // n0x0dbb c0x0000 (---------------)  + I numata
	0x0027e7c6, // n0x0dbc c0x0000 (---------------)  + I oizumi
	0x0021edc3, // n0x0dbd c0x0000 (---------------)  + I ora
	0x00201103, // n0x0dbe c0x0000 (---------------)  + I ota
	0x002c28c9, // n0x0dbf c0x0000 (---------------)  + I shibukawa
	0x0025e2c9, // n0x0dc0 c0x0000 (---------------)  + I shimonita
	0x0028ff06, // n0x0dc1 c0x0000 (---------------)  + I shinto
	0x002b2f45, // n0x0dc2 c0x0000 (---------------)  + I showa
	0x002a1e48, // n0x0dc3 c0x0000 (---------------)  + I takasaki
	0x002c17c8, // n0x0dc4 c0x0000 (---------------)  + I takayama
	0x0039b188, // n0x0dc5 c0x0000 (---------------)  + I tamamura
	0x00381ecb, // n0x0dc6 c0x0000 (---------------)  + I tatebayashi
	0x0029a407, // n0x0dc7 c0x0000 (---------------)  + I tomioka
	0x002fdc49, // n0x0dc8 c0x0000 (---------------)  + I tsukiyono
	0x00267008, // n0x0dc9 c0x0000 (---------------)  + I tsumagoi
	0x00385884, // n0x0dca c0x0000 (---------------)  + I ueno
	0x002c82c8, // n0x0dcb c0x0000 (---------------)  + I yoshioka
	0x0028e249, // n0x0dcc c0x0000 (---------------)  + I asaminami
	0x002ada05, // n0x0dcd c0x0000 (---------------)  + I daiwa
	0x00248547, // n0x0dce c0x0000 (---------------)  + I etajima
	0x002be405, // n0x0dcf c0x0000 (---------------)  + I fuchu
	0x002814c8, // n0x0dd0 c0x0000 (---------------)  + I fukuyama
	0x00290c8b, // n0x0dd1 c0x0000 (---------------)  + I hatsukaichi
	0x002953d0, // n0x0dd2 c0x0000 (---------------)  + I higashihiroshima
	0x002a94c5, // n0x0dd3 c0x0000 (---------------)  + I hongo
	0x002191cc, // n0x0dd4 c0x0000 (---------------)  + I jinsekikogen
	0x00229085, // n0x0dd5 c0x0000 (---------------)  + I kaita
	0x0027df03, // n0x0dd6 c0x0000 (---------------)  + I kui
	0x0027f446, // n0x0dd7 c0x0000 (---------------)  + I kumano
	0x002b78c4, // n0x0dd8 c0x0000 (---------------)  + I kure
	0x0039a0c6, // n0x0dd9 c0x0000 (---------------)  + I mihara
	0x0029dbc7, // n0x0dda c0x0000 (---------------)  + I miyoshi
	0x00216044, // n0x0ddb c0x0000 (---------------)  + I naka
	0x002d36c8, // n0x0ddc c0x0000 (---------------)  + I onomichi
	0x003271cd, // n0x0ddd c0x0000 (---------------)  + I osakikamijima
	0x002fc585, // n0x0dde c0x0000 (---------------)  + I otake
	0x00244884, // n0x0ddf c0x0000 (---------------)  + I saka
	0x00226804, // n0x0de0 c0x0000 (---------------)  + I sera
	0x0027e289, // n0x0de1 c0x0000 (---------------)  + I seranishi
	0x00272b48, // n0x0de2 c0x0000 (---------------)  + I shinichi
	0x0030dc47, // n0x0de3 c0x0000 (---------------)  + I shobara
	0x002672c8, // n0x0de4 c0x0000 (---------------)  + I takehara
	0x00282148, // n0x0de5 c0x0000 (---------------)  + I abashiri
	0x0027aac5, // n0x0de6 c0x0000 (---------------)  + I abira
	0x00207947, // n0x0de7 c0x0000 (---------------)  + I aibetsu
	0x0027aa47, // n0x0de8 c0x0000 (---------------)  + I akabira
	0x002086c7, // n0x0de9 c0x0000 (---------------)  + I akkeshi
	0x002c0b09, // n0x0dea c0x0000 (---------------)  + I asahikawa
	0x0023a549, // n0x0deb c0x0000 (---------------)  + I ashibetsu
	0x00243e46, // n0x0dec c0x0000 (---------------)  + I ashoro
	0x002b5d86, // n0x0ded c0x0000 (---------------)  + I assabu
	0x00266fc6, // n0x0dee c0x0000 (---------------)  + I atsuma
	0x00268ac5, // n0x0def c0x0000 (---------------)  + I bibai
	0x0024e984, // n0x0df0 c0x0000 (---------------)  + I biei
	0x00201a46, // n0x0df1 c0x0000 (---------------)  + I bifuka
	0x00201fc6, // n0x0df2 c0x0000 (---------------)  + I bihoro
	0x0027ab08, // n0x0df3 c0x0000 (---------------)  + I biratori
	0x0028f24b, // n0x0df4 c0x0000 (---------------)  + I chippubetsu
	0x002b0b47, // n0x0df5 c0x0000 (---------------)  + I chitose
	0x0020da04, // n0x0df6 c0x0000 (---------------)  + I date
	0x002276c6, // n0x0df7 c0x0000 (---------------)  + I ebetsu
	0x00280f47, // n0x0df8 c0x0000 (---------------)  + I embetsu
	0x002f1a05, // n0x0df9 c0x0000 (---------------)  + I eniwa
	0x003792c5, // n0x0dfa c0x0000 (---------------)  + I erimo
	0x00200fc4, // n0x0dfb c0x0000 (---------------)  + I esan
	0x0023a4c6, // n0x0dfc c0x0000 (---------------)  + I esashi
	0x00201ac8, // n0x0dfd c0x0000 (---------------)  + I fukagawa
	0x003547c9, // n0x0dfe c0x0000 (---------------)  + I fukushima
	0x0024b3c6, // n0x0dff c0x0000 (---------------)  + I furano
	0x00286648, // n0x0e00 c0x0000 (---------------)  + I furubira
	0x002ae306, // n0x0e01 c0x0000 (---------------)  + I haboro
	0x0032e0c8, // n0x0e02 c0x0000 (---------------)  + I hakodate
	0x002a39cc, // n0x0e03 c0x0000 (---------------)  + I hamatonbetsu
	0x0027a986, // n0x0e04 c0x0000 (---------------)  + I hidaka
	0x0029658d, // n0x0e05 c0x0000 (---------------)  + I higashikagura
	0x00296a0b, // n0x0e06 c0x0000 (---------------)  + I higashikawa
	0x00374585, // n0x0e07 c0x0000 (---------------)  + I hiroo
	0x00204507, // n0x0e08 c0x0000 (---------------)  + I hokuryu
	0x0034f5c6, // n0x0e09 c0x0000 (---------------)  + I hokuto
	0x002e8608, // n0x0e0a c0x0000 (---------------)  + I honbetsu
	0x00243ec9, // n0x0e0b c0x0000 (---------------)  + I horokanai
	0x002bac88, // n0x0e0c c0x0000 (---------------)  + I horonobe
	0x00202445, // n0x0e0d c0x0000 (---------------)  + I ikeda
	0x0035c607, // n0x0e0e c0x0000 (---------------)  + I imakane
	0x0027fc88, // n0x0e0f c0x0000 (---------------)  + I ishikari
	0x0026a609, // n0x0e10 c0x0000 (---------------)  + I iwamizawa
	0x00239a46, // n0x0e11 c0x0000 (---------------)  + I iwanai
	0x0035eeca, // n0x0e12 c0x0000 (---------------)  + I kamifurano
	0x002e8388, // n0x0e13 c0x0000 (---------------)  + I kamikawa
	0x002baacb, // n0x0e14 c0x0000 (---------------)  + I kamishihoro
	0x0028744c, // n0x0e15 c0x0000 (---------------)  + I kamisunagawa
	0x0024e448, // n0x0e16 c0x0000 (---------------)  + I kamoenai
	0x0027cac6, // n0x0e17 c0x0000 (---------------)  + I kayabe
	0x00207348, // n0x0e18 c0x0000 (---------------)  + I kembuchi
	0x00204fc7, // n0x0e19 c0x0000 (---------------)  + I kikonai
	0x0023a7c9, // n0x0e1a c0x0000 (---------------)  + I kimobetsu
	0x00209d4d, // n0x0e1b c0x0000 (---------------)  + I kitahiroshima
	0x0029ed06, // n0x0e1c c0x0000 (---------------)  + I kitami
	0x0028ef48, // n0x0e1d c0x0000 (---------------)  + I kiyosato
	0x003584c9, // n0x0e1e c0x0000 (---------------)  + I koshimizu
	0x002b6748, // n0x0e1f c0x0000 (---------------)  + I kunneppu
	0x00284248, // n0x0e20 c0x0000 (---------------)  + I kuriyama
	0x002b9c0c, // n0x0e21 c0x0000 (---------------)  + I kuromatsunai
	0x002bb4c7, // n0x0e22 c0x0000 (---------------)  + I kushiro
	0x002bc847, // n0x0e23 c0x0000 (---------------)  + I kutchan
	0x002c0945, // n0x0e24 c0x0000 (---------------)  + I kyowa
	0x00240c07, // n0x0e25 c0x0000 (---------------)  + I mashike
	0x002c7588, // n0x0e26 c0x0000 (---------------)  + I matsumae
	0x00292d86, // n0x0e27 c0x0000 (---------------)  + I mikasa
	0x0024b24c, // n0x0e28 c0x0000 (---------------)  + I minamifurano
	0x002e4488, // n0x0e29 c0x0000 (---------------)  + I mombetsu
	0x002c95c8, // n0x0e2a c0x0000 (---------------)  + I moseushi
	0x002daf06, // n0x0e2b c0x0000 (---------------)  + I mukawa
	0x00395787, // n0x0e2c c0x0000 (---------------)  + I muroran
	0x00244044, // n0x0e2d c0x0000 (---------------)  + I naie
	0x002b0508, // n0x0e2e c0x0000 (---------------)  + I nakagawa
	0x002853cc, // n0x0e2f c0x0000 (---------------)  + I nakasatsunai
	0x002178cc, // n0x0e30 c0x0000 (---------------)  + I nakatombetsu
	0x00226b45, // n0x0e31 c0x0000 (---------------)  + I nanae
	0x00389f87, // n0x0e32 c0x0000 (---------------)  + I nanporo
	0x00310fc6, // n0x0e33 c0x0000 (---------------)  + I nayoro
	0x00395706, // n0x0e34 c0x0000 (---------------)  + I nemuro
	0x00297388, // n0x0e35 c0x0000 (---------------)  + I niikappu
	0x003a38c4, // n0x0e36 c0x0000 (---------------)  + I niki
	0x002210cb, // n0x0e37 c0x0000 (---------------)  + I nishiokoppe
	0x0026c9cb, // n0x0e38 c0x0000 (---------------)  + I noboribetsu
	0x0022d7c6, // n0x0e39 c0x0000 (---------------)  + I numata
	0x00327047, // n0x0e3a c0x0000 (---------------)  + I obihiro
	0x002f4ac5, // n0x0e3b c0x0000 (---------------)  + I obira
	0x00270f85, // n0x0e3c c0x0000 (---------------)  + I oketo
	0x00221206, // n0x0e3d c0x0000 (---------------)  + I okoppe
	0x00273ec5, // n0x0e3e c0x0000 (---------------)  + I otaru
	0x002c0085, // n0x0e3f c0x0000 (---------------)  + I otobe
	0x002c1007, // n0x0e40 c0x0000 (---------------)  + I otofuke
	0x00278489, // n0x0e41 c0x0000 (---------------)  + I otoineppu
	0x002e7a04, // n0x0e42 c0x0000 (---------------)  + I oumu
	0x00276f45, // n0x0e43 c0x0000 (---------------)  + I ozora
	0x002d75c5, // n0x0e44 c0x0000 (---------------)  + I pippu
	0x0028c188, // n0x0e45 c0x0000 (---------------)  + I rankoshi
	0x002d3505, // n0x0e46 c0x0000 (---------------)  + I rebun
	0x002bfcc9, // n0x0e47 c0x0000 (---------------)  + I rikubetsu
	0x0029b847, // n0x0e48 c0x0000 (---------------)  + I rishiri
	0x0029b84b, // n0x0e49 c0x0000 (---------------)  + I rishirifuji
	0x0022cac6, // n0x0e4a c0x0000 (---------------)  + I saroma
	0x00228b09, // n0x0e4b c0x0000 (---------------)  + I sarufutsu
	0x00355148, // n0x0e4c c0x0000 (---------------)  + I shakotan
	0x00251f05, // n0x0e4d c0x0000 (---------------)  + I shari
	0x002087c8, // n0x0e4e c0x0000 (---------------)  + I shibecha
	0x0023a588, // n0x0e4f c0x0000 (---------------)  + I shibetsu
	0x00218687, // n0x0e50 c0x0000 (---------------)  + I shikabe
	0x0027e687, // n0x0e51 c0x0000 (---------------)  + I shikaoi
	0x002818c9, // n0x0e52 c0x0000 (---------------)  + I shimamaki
	0x002231c7, // n0x0e53 c0x0000 (---------------)  + I shimizu
	0x002592c9, // n0x0e54 c0x0000 (---------------)  + I shimokawa
	0x00286c0c, // n0x0e55 c0x0000 (---------------)  + I shinshinotsu
	0x0028ff08, // n0x0e56 c0x0000 (---------------)  + I shintoku
	0x002a8b09, // n0x0e57 c0x0000 (---------------)  + I shiranuka
	0x002aac87, // n0x0e58 c0x0000 (---------------)  + I shiraoi
	0x00282209, // n0x0e59 c0x0000 (---------------)  + I shiriuchi
	0x002180c7, // n0x0e5a c0x0000 (---------------)  + I sobetsu
	0x00287548, // n0x0e5b c0x0000 (---------------)  + I sunagawa
	0x0028c4c5, // n0x0e5c c0x0000 (---------------)  + I taiki
	0x003118c6, // n0x0e5d c0x0000 (---------------)  + I takasu
	0x002ba308, // n0x0e5e c0x0000 (---------------)  + I takikawa
	0x002f7488, // n0x0e5f c0x0000 (---------------)  + I takinoue
	0x002c25c9, // n0x0e60 c0x0000 (---------------)  + I teshikaga
	0x002c00c7, // n0x0e61 c0x0000 (---------------)  + I tobetsu
	0x00271905, // n0x0e62 c0x0000 (---------------)  + I tohma
	0x0020ae89, // n0x0e63 c0x0000 (---------------)  + I tomakomai
	0x00219c46, // n0x0e64 c0x0000 (---------------)  + I tomari
	0x002902c4, // n0x0e65 c0x0000 (---------------)  + I toya
	0x0034a546, // n0x0e66 c0x0000 (---------------)  + I toyako
	0x002660c8, // n0x0e67 c0x0000 (---------------)  + I toyotomi
	0x00269547, // n0x0e68 c0x0000 (---------------)  + I toyoura
	0x0028f448, // n0x0e69 c0x0000 (---------------)  + I tsubetsu
	0x0021a989, // n0x0e6a c0x0000 (---------------)  + I tsukigata
	0x002dac87, // n0x0e6b c0x0000 (---------------)  + I urakawa
	0x0029eb86, // n0x0e6c c0x0000 (---------------)  + I urausu
	0x002045c4, // n0x0e6d c0x0000 (---------------)  + I uryu
	0x00203f49, // n0x0e6e c0x0000 (---------------)  + I utashinai
	0x002077c8, // n0x0e6f c0x0000 (---------------)  + I wakkanai
	0x002dadc7, // n0x0e70 c0x0000 (---------------)  + I wassamu
	0x00324a06, // n0x0e71 c0x0000 (---------------)  + I yakumo
	0x00379906, // n0x0e72 c0x0000 (---------------)  + I yoichi
	0x00206b84, // n0x0e73 c0x0000 (---------------)  + I aioi
	0x002a98c6, // n0x0e74 c0x0000 (---------------)  + I akashi
	0x0020af43, // n0x0e75 c0x0000 (---------------)  + I ako
	0x003277c9, // n0x0e76 c0x0000 (---------------)  + I amagasaki
	0x00202886, // n0x0e77 c0x0000 (---------------)  + I aogaki
	0x0029c105, // n0x0e78 c0x0000 (---------------)  + I asago
	0x0029f086, // n0x0e79 c0x0000 (---------------)  + I ashiya
	0x002a4585, // n0x0e7a c0x0000 (---------------)  + I awaji
	0x00280108, // n0x0e7b c0x0000 (---------------)  + I fukusaki
	0x0024e187, // n0x0e7c c0x0000 (---------------)  + I goshiki
	0x00206406, // n0x0e7d c0x0000 (---------------)  + I harima
	0x00354e06, // n0x0e7e c0x0000 (---------------)  + I himeji
	0x00263808, // n0x0e7f c0x0000 (---------------)  + I ichikawa
	0x002a09c7, // n0x0e80 c0x0000 (---------------)  + I inagawa
	0x0029ed45, // n0x0e81 c0x0000 (---------------)  + I itami
	0x0029f588, // n0x0e82 c0x0000 (---------------)  + I kakogawa
	0x00381248, // n0x0e83 c0x0000 (---------------)  + I kamigori
	0x002e8388, // n0x0e84 c0x0000 (---------------)  + I kamikawa
	0x00228f45, // n0x0e85 c0x0000 (---------------)  + I kasai
	0x00311946, // n0x0e86 c0x0000 (---------------)  + I kasuga
	0x002bb049, // n0x0e87 c0x0000 (---------------)  + I kawanishi
	0x00290804, // n0x0e88 c0x0000 (---------------)  + I miki
	0x0036b00b, // n0x0e89 c0x0000 (---------------)  + I minamiawaji
	0x0021c00b, // n0x0e8a c0x0000 (---------------)  + I nishinomiya
	0x002242c9, // n0x0e8b c0x0000 (---------------)  + I nishiwaki
	0x0020c303, // n0x0e8c c0x0000 (---------------)  + I ono
	0x00259945, // n0x0e8d c0x0000 (---------------)  + I sanda
	0x00202b46, // n0x0e8e c0x0000 (---------------)  + I sannan
	0x0022f208, // n0x0e8f c0x0000 (---------------)  + I sasayama
	0x0022d304, // n0x0e90 c0x0000 (---------------)  + I sayo
	0x0022ff06, // n0x0e91 c0x0000 (---------------)  + I shingu
	0x002cc8c9, // n0x0e92 c0x0000 (---------------)  + I shinonsen
	0x002bd445, // n0x0e93 c0x0000 (---------------)  + I shiso
	0x002c0f46, // n0x0e94 c0x0000 (---------------)  + I sumoto
	0x0023d286, // n0x0e95 c0x0000 (---------------)  + I taishi
	0x002165c4, // n0x0e96 c0x0000 (---------------)  + I taka
	0x00296fca, // n0x0e97 c0x0000 (---------------)  + I takarazuka
	0x0029c048, // n0x0e98 c0x0000 (---------------)  + I takasago
	0x002f7486, // n0x0e99 c0x0000 (---------------)  + I takino
	0x00302505, // n0x0e9a c0x0000 (---------------)  + I tamba
	0x0020e687, // n0x0e9b c0x0000 (---------------)  + I tatsuno
	0x0025b2c7, // n0x0e9c c0x0000 (---------------)  + I toyooka
	0x0034ed84, // n0x0e9d c0x0000 (---------------)  + I yabu
	0x0021c247, // n0x0e9e c0x0000 (---------------)  + I yashiro
	0x00203584, // n0x0e9f c0x0000 (---------------)  + I yoka
	0x00203586, // n0x0ea0 c0x0000 (---------------)  + I yokawa
	0x00207d83, // n0x0ea1 c0x0000 (---------------)  + I ami
	0x002c0b05, // n0x0ea2 c0x0000 (---------------)  + I asahi
	0x00342c85, // n0x0ea3 c0x0000 (---------------)  + I bando
	0x0023d608, // n0x0ea4 c0x0000 (---------------)  + I chikusei
	0x002156c5, // n0x0ea5 c0x0000 (---------------)  + I daigo
	0x0027a6c9, // n0x0ea6 c0x0000 (---------------)  + I fujishiro
	0x002a3e07, // n0x0ea7 c0x0000 (---------------)  + I hitachi
	0x002b034b, // n0x0ea8 c0x0000 (---------------)  + I hitachinaka
	0x002a3e0c, // n0x0ea9 c0x0000 (---------------)  + I hitachiomiya
	0x002a4a8a, // n0x0eaa c0x0000 (---------------)  + I hitachiota
	0x002c3847, // n0x0eab c0x0000 (---------------)  + I ibaraki
	0x002012c3, // n0x0eac c0x0000 (---------------)  + I ina
	0x00345f08, // n0x0ead c0x0000 (---------------)  + I inashiki
	0x00229105, // n0x0eae c0x0000 (---------------)  + I itako
	0x002bbc85, // n0x0eaf c0x0000 (---------------)  + I iwama
	0x00334d84, // n0x0eb0 c0x0000 (---------------)  + I joso
	0x00287446, // n0x0eb1 c0x0000 (---------------)  + I kamisu
	0x0023bc06, // n0x0eb2 c0x0000 (---------------)  + I kasama
	0x002a9907, // n0x0eb3 c0x0000 (---------------)  + I kashima
	0x0020a40b, // n0x0eb4 c0x0000 (---------------)  + I kasumigaura
	0x0021fc44, // n0x0eb5 c0x0000 (---------------)  + I koga
	0x00377044, // n0x0eb6 c0x0000 (---------------)  + I miho
	0x0026ff04, // n0x0eb7 c0x0000 (---------------)  + I mito
	0x002c7a46, // n0x0eb8 c0x0000 (---------------)  + I moriya
	0x00216044, // n0x0eb9 c0x0000 (---------------)  + I naka
	0x002c1648, // n0x0eba c0x0000 (---------------)  + I namegata
	0x00334b85, // n0x0ebb c0x0000 (---------------)  + I oarai
	0x00230545, // n0x0ebc c0x0000 (---------------)  + I ogawa
	0x0039b0c7, // n0x0ebd c0x0000 (---------------)  + I omitama
	0x00204609, // n0x0ebe c0x0000 (---------------)  + I ryugasaki
	0x0034a305, // n0x0ebf c0x0000 (---------------)  + I sakai
	0x00370fca, // n0x0ec0 c0x0000 (---------------)  + I sakuragawa
	0x002c7809, // n0x0ec1 c0x0000 (---------------)  + I shimodate
	0x0026d78a, // n0x0ec2 c0x0000 (---------------)  + I shimotsuma
	0x003952c9, // n0x0ec3 c0x0000 (---------------)  + I shirosato
	0x0032d484, // n0x0ec4 c0x0000 (---------------)  + I sowa
	0x002fcd45, // n0x0ec5 c0x0000 (---------------)  + I suifu
	0x002cfe88, // n0x0ec6 c0x0000 (---------------)  + I takahagi
	0x0037394b, // n0x0ec7 c0x0000 (---------------)  + I tamatsukuri
	0x002f91c5, // n0x0ec8 c0x0000 (---------------)  + I tokai
	0x00285f06, // n0x0ec9 c0x0000 (---------------)  + I tomobe
	0x0021e584, // n0x0eca c0x0000 (---------------)  + I tone
	0x0027ac06, // n0x0ecb c0x0000 (---------------)  + I toride
	0x002dab09, // n0x0ecc c0x0000 (---------------)  + I tsuchiura
	0x00227787, // n0x0ecd c0x0000 (---------------)  + I tsukuba
	0x0030df88, // n0x0ece c0x0000 (---------------)  + I uchihara
	0x00244706, // n0x0ecf c0x0000 (---------------)  + I ushiku
	0x002ff047, // n0x0ed0 c0x0000 (---------------)  + I yachiyo
	0x002815c8, // n0x0ed1 c0x0000 (---------------)  + I yamagata
	0x00384c06, // n0x0ed2 c0x0000 (---------------)  + I yawara
	0x00253884, // n0x0ed3 c0x0000 (---------------)  + I yuki
	0x0035d647, // n0x0ed4 c0x0000 (---------------)  + I anamizu
	0x00343a45, // n0x0ed5 c0x0000 (---------------)  + I hakui
	0x00348747, // n0x0ed6 c0x0000 (---------------)  + I hakusan
	0x00201b44, // n0x0ed7 c0x0000 (---------------)  + I kaga
	0x0034f546, // n0x0ed8 c0x0000 (---------------)  + I kahoku
	0x0021b548, // n0x0ed9 c0x0000 (---------------)  + I kanazawa
	0x00296bc8, // n0x0eda c0x0000 (---------------)  + I kawakita
	0x002ab807, // n0x0edb c0x0000 (---------------)  + I komatsu
	0x003288c8, // n0x0edc c0x0000 (---------------)  + I nakanoto
	0x002b6005, // n0x0edd c0x0000 (---------------)  + I nanao
	0x0020c144, // n0x0ede c0x0000 (---------------)  + I nomi
	0x00263708, // n0x0edf c0x0000 (---------------)  + I nonoichi
	0x00257ec4, // n0x0ee0 c0x0000 (---------------)  + I noto
	0x00216485, // n0x0ee1 c0x0000 (---------------)  + I shika
	0x002ea3c4, // n0x0ee2 c0x0000 (---------------)  + I suzu
	0x0023e207, // n0x0ee3 c0x0000 (---------------)  + I tsubata
	0x0028aa07, // n0x0ee4 c0x0000 (---------------)  + I tsurugi
	0x00282348, // n0x0ee5 c0x0000 (---------------)  + I uchinada
	0x002a45c6, // n0x0ee6 c0x0000 (---------------)  + I wajima
	0x00215645, // n0x0ee7 c0x0000 (---------------)  + I fudai
	0x0027a4c8, // n0x0ee8 c0x0000 (---------------)  + I fujisawa
	0x003538c8, // n0x0ee9 c0x0000 (---------------)  + I hanamaki
	0x002a0249, // n0x0eea c0x0000 (---------------)  + I hiraizumi
	0x0021c306, // n0x0eeb c0x0000 (---------------)  + I hirono
	0x00236a88, // n0x0eec c0x0000 (---------------)  + I ichinohe
	0x00282aca, // n0x0eed c0x0000 (---------------)  + I ichinoseki
	0x002f1a88, // n0x0eee c0x0000 (---------------)  + I iwaizumi
	0x002d7d45, // n0x0eef c0x0000 (---------------)  + I iwate
	0x00227f86, // n0x0ef0 c0x0000 (---------------)  + I joboji
	0x0028fb08, // n0x0ef1 c0x0000 (---------------)  + I kamaishi
	0x0035c6ca, // n0x0ef2 c0x0000 (---------------)  + I kanegasaki
	0x00269ec7, // n0x0ef3 c0x0000 (---------------)  + I karumai
	0x00287b45, // n0x0ef4 c0x0000 (---------------)  + I kawai
	0x00295bc8, // n0x0ef5 c0x0000 (---------------)  + I kitakami
	0x003a2804, // n0x0ef6 c0x0000 (---------------)  + I kuji
	0x002ae486, // n0x0ef7 c0x0000 (---------------)  + I kunohe
	0x002bcfc8, // n0x0ef8 c0x0000 (---------------)  + I kuzumaki
	0x0020c1c6, // n0x0ef9 c0x0000 (---------------)  + I miyako
	0x002f3888, // n0x0efa c0x0000 (---------------)  + I mizusawa
	0x0021a207, // n0x0efb c0x0000 (---------------)  + I morioka
	0x00209286, // n0x0efc c0x0000 (---------------)  + I ninohe
	0x0037d844, // n0x0efd c0x0000 (---------------)  + I noda
	0x002d97c7, // n0x0efe c0x0000 (---------------)  + I ofunato
	0x002fac04, // n0x0eff c0x0000 (---------------)  + I oshu
	0x002daac7, // n0x0f00 c0x0000 (---------------)  + I otsuchi
	0x0037860d, // n0x0f01 c0x0000 (---------------)  + I rikuzentakata
	0x00203345, // n0x0f02 c0x0000 (---------------)  + I shiwa
	0x002af08b, // n0x0f03 c0x0000 (---------------)  + I shizukuishi
	0x002a21c6, // n0x0f04 c0x0000 (---------------)  + I sumita
	0x00252c48, // n0x0f05 c0x0000 (---------------)  + I tanohata
	0x00387b44, // n0x0f06 c0x0000 (---------------)  + I tono
	0x00276d06, // n0x0f07 c0x0000 (---------------)  + I yahaba
	0x0027d386, // n0x0f08 c0x0000 (---------------)  + I yamada
	0x00207687, // n0x0f09 c0x0000 (---------------)  + I ayagawa
	0x0029624d, // n0x0f0a c0x0000 (---------------)  + I higashikagawa
	0x00312347, // n0x0f0b c0x0000 (---------------)  + I kanonji
	0x00300fc8, // n0x0f0c c0x0000 (---------------)  + I kotohira
	0x0035ea45, // n0x0f0d c0x0000 (---------------)  + I manno
	0x00298248, // n0x0f0e c0x0000 (---------------)  + I marugame
	0x002c1f06, // n0x0f0f c0x0000 (---------------)  + I mitoyo
	0x002b6088, // n0x0f10 c0x0000 (---------------)  + I naoshima
	0x00210f86, // n0x0f11 c0x0000 (---------------)  + I sanuki
	0x003541c7, // n0x0f12 c0x0000 (---------------)  + I tadotsu
	0x0021d509, // n0x0f13 c0x0000 (---------------)  + I takamatsu
	0x00387b47, // n0x0f14 c0x0000 (---------------)  + I tonosho
	0x00289bc8, // n0x0f15 c0x0000 (---------------)  + I uchinomi
	0x00273545, // n0x0f16 c0x0000 (---------------)  + I utazu
	0x0021e8c8, // n0x0f17 c0x0000 (---------------)  + I zentsuji
	0x00326185, // n0x0f18 c0x0000 (---------------)  + I akune
	0x00240f45, // n0x0f19 c0x0000 (---------------)  + I amami
	0x002e5945, // n0x0f1a c0x0000 (---------------)  + I hioki
	0x00226dc3, // n0x0f1b c0x0000 (---------------)  + I isa
	0x00283644, // n0x0f1c c0x0000 (---------------)  + I isen
	0x0027e805, // n0x0f1d c0x0000 (---------------)  + I izumi
	0x00275f89, // n0x0f1e c0x0000 (---------------)  + I kagoshima
	0x002b1546, // n0x0f1f c0x0000 (---------------)  + I kanoya
	0x002d4308, // n0x0f20 c0x0000 (---------------)  + I kawanabe
	0x0035c8c5, // n0x0f21 c0x0000 (---------------)  + I kinko
	0x0032bd87, // n0x0f22 c0x0000 (---------------)  + I kouyama
	0x003544ca, // n0x0f23 c0x0000 (---------------)  + I makurazaki
	0x002c0e89, // n0x0f24 c0x0000 (---------------)  + I matsumoto
	0x002b314a, // n0x0f25 c0x0000 (---------------)  + I minamitane
	0x002cd408, // n0x0f26 c0x0000 (---------------)  + I nakatane
	0x0021cdcc, // n0x0f27 c0x0000 (---------------)  + I nishinoomote
	0x0028334d, // n0x0f28 c0x0000 (---------------)  + I satsumasendai
	0x002edf43, // n0x0f29 c0x0000 (---------------)  + I soo
	0x002f3788, // n0x0f2a c0x0000 (---------------)  + I tarumizu
	0x0020b5c5, // n0x0f2b c0x0000 (---------------)  + I yusui
	0x00351fc6, // n0x0f2c c0x0000 (---------------)  + I aikawa
	0x00376c46, // n0x0f2d c0x0000 (---------------)  + I atsugi
	0x0024cf45, // n0x0f2e c0x0000 (---------------)  + I ayase
	0x0033c6c9, // n0x0f2f c0x0000 (---------------)  + I chigasaki
	0x00324c05, // n0x0f30 c0x0000 (---------------)  + I ebina
	0x0027a4c8, // n0x0f31 c0x0000 (---------------)  + I fujisawa
	0x00257dc6, // n0x0f32 c0x0000 (---------------)  + I hadano
	0x00338fc6, // n0x0f33 c0x0000 (---------------)  + I hakone
	0x002a1949, // n0x0f34 c0x0000 (---------------)  + I hiratsuka
	0x00384407, // n0x0f35 c0x0000 (---------------)  + I isehara
	0x002f2a86, // n0x0f36 c0x0000 (---------------)  + I kaisei
	0x00354448, // n0x0f37 c0x0000 (---------------)  + I kamakura
	0x00203508, // n0x0f38 c0x0000 (---------------)  + I kiyokawa
	0x002d1c87, // n0x0f39 c0x0000 (---------------)  + I matsuda
	0x0022340e, // n0x0f3a c0x0000 (---------------)  + I minamiashigara
	0x002c2145, // n0x0f3b c0x0000 (---------------)  + I miura
	0x0026a505, // n0x0f3c c0x0000 (---------------)  + I nakai
	0x0020c0c8, // n0x0f3d c0x0000 (---------------)  + I ninomiya
	0x0036c2c7, // n0x0f3e c0x0000 (---------------)  + I odawara
	0x00206c02, // n0x0f3f c0x0000 (---------------)  + I oi
	0x002b9784, // n0x0f40 c0x0000 (---------------)  + I oiso
	0x00399fca, // n0x0f41 c0x0000 (---------------)  + I sagamihara
	0x002dae88, // n0x0f42 c0x0000 (---------------)  + I samukawa
	0x00281046, // n0x0f43 c0x0000 (---------------)  + I tsukui
	0x00298948, // n0x0f44 c0x0000 (---------------)  + I yamakita
	0x00290986, // n0x0f45 c0x0000 (---------------)  + I yamato
	0x00325b48, // n0x0f46 c0x0000 (---------------)  + I yokosuka
	0x002ad708, // n0x0f47 c0x0000 (---------------)  + I yugawara
	0x00240f04, // n0x0f48 c0x0000 (---------------)  + I zama
	0x0032f185, // n0x0f49 c0x0000 (---------------)  + I zushi
	0x00685804, // n0x0f4a c0x0001 (---------------)  ! I city
	0x00685804, // n0x0f4b c0x0001 (---------------)  ! I city
	0x00685804, // n0x0f4c c0x0001 (---------------)  ! I city
	0x00202943, // n0x0f4d c0x0000 (---------------)  + I aki
	0x00379786, // n0x0f4e c0x0000 (---------------)  + I geisei
	0x0027a986, // n0x0f4f c0x0000 (---------------)  + I hidaka
	0x0029e3cc, // n0x0f50 c0x0000 (---------------)  + I higashitsuno
	0x002092c3, // n0x0f51 c0x0000 (---------------)  + I ino
	0x002bdd86, // n0x0f52 c0x0000 (---------------)  + I kagami
	0x002160c4, // n0x0f53 c0x0000 (---------------)  + I kami
	0x002c3988, // n0x0f54 c0x0000 (---------------)  + I kitagawa
	0x002cc705, // n0x0f55 c0x0000 (---------------)  + I kochi
	0x0039a0c6, // n0x0f56 c0x0000 (---------------)  + I mihara
	0x002b5548, // n0x0f57 c0x0000 (---------------)  + I motoyama
	0x002ce386, // n0x0f58 c0x0000 (---------------)  + I muroto
	0x00206386, // n0x0f59 c0x0000 (---------------)  + I nahari
	0x0035e6c8, // n0x0f5a c0x0000 (---------------)  + I nakamura
	0x002a2447, // n0x0f5b c0x0000 (---------------)  + I nankoku
	0x00222f89, // n0x0f5c c0x0000 (---------------)  + I nishitosa
	0x0023040a, // n0x0f5d c0x0000 (---------------)  + I niyodogawa
	0x00247c84, // n0x0f5e c0x0000 (---------------)  + I ochi
	0x002035c5, // n0x0f5f c0x0000 (---------------)  + I okawa
	0x0025c245, // n0x0f60 c0x0000 (---------------)  + I otoyo
	0x0021d106, // n0x0f61 c0x0000 (---------------)  + I otsuki
	0x00247f46, // n0x0f62 c0x0000 (---------------)  + I sakawa
	0x002a7846, // n0x0f63 c0x0000 (---------------)  + I sukumo
	0x002e9706, // n0x0f64 c0x0000 (---------------)  + I susaki
	0x002230c4, // n0x0f65 c0x0000 (---------------)  + I tosa
	0x002230cb, // n0x0f66 c0x0000 (---------------)  + I tosashimizu
	0x002472c4, // n0x0f67 c0x0000 (---------------)  + I toyo
	0x0020e705, // n0x0f68 c0x0000 (---------------)  + I tsuno
	0x002ac705, // n0x0f69 c0x0000 (---------------)  + I umaji
	0x0027eb86, // n0x0f6a c0x0000 (---------------)  + I yasuda
	0x00202208, // n0x0f6b c0x0000 (---------------)  + I yusuhara
	0x00283207, // n0x0f6c c0x0000 (---------------)  + I amakusa
	0x0030dd44, // n0x0f6d c0x0000 (---------------)  + I arao
	0x00262cc3, // n0x0f6e c0x0000 (---------------)  + I aso
	0x003a2305, // n0x0f6f c0x0000 (---------------)  + I choyo
	0x0024a4c7, // n0x0f70 c0x0000 (---------------)  + I gyokuto
	0x002a5809, // n0x0f71 c0x0000 (---------------)  + I hitoyoshi
	0x0028310b, // n0x0f72 c0x0000 (---------------)  + I kamiamakusa
	0x002a9907, // n0x0f73 c0x0000 (---------------)  + I kashima
	0x0023d507, // n0x0f74 c0x0000 (---------------)  + I kikuchi
	0x002ddc44, // n0x0f75 c0x0000 (---------------)  + I kosa
	0x002b5448, // n0x0f76 c0x0000 (---------------)  + I kumamoto
	0x002aba87, // n0x0f77 c0x0000 (---------------)  + I mashiki
	0x002a5a46, // n0x0f78 c0x0000 (---------------)  + I mifune
	0x00253608, // n0x0f79 c0x0000 (---------------)  + I minamata
	0x002a7a4b, // n0x0f7a c0x0000 (---------------)  + I minamioguni
	0x00360ec6, // n0x0f7b c0x0000 (---------------)  + I nagasu
	0x00210cc9, // n0x0f7c c0x0000 (---------------)  + I nishihara
	0x002a7bc5, // n0x0f7d c0x0000 (---------------)  + I oguni
	0x002ffa83, // n0x0f7e c0x0000 (---------------)  + I ozu
	0x002c0f46, // n0x0f7f c0x0000 (---------------)  + I sumoto
	0x0021a108, // n0x0f80 c0x0000 (---------------)  + I takamori
	0x00211043, // n0x0f81 c0x0000 (---------------)  + I uki
	0x00229f83, // n0x0f82 c0x0000 (---------------)  + I uto
	0x00227446, // n0x0f83 c0x0000 (---------------)  + I yamaga
	0x00290986, // n0x0f84 c0x0000 (---------------)  + I yamato
	0x00380c0a, // n0x0f85 c0x0000 (---------------)  + I yatsushiro
	0x0027cb05, // n0x0f86 c0x0000 (---------------)  + I ayabe
	0x0027d1cb, // n0x0f87 c0x0000 (---------------)  + I fukuchiyama
	0x0029efcb, // n0x0f88 c0x0000 (---------------)  + I higashiyama
	0x0022ab43, // n0x0f89 c0x0000 (---------------)  + I ide
	0x00220b03, // n0x0f8a c0x0000 (---------------)  + I ine
	0x002af884, // n0x0f8b c0x0000 (---------------)  + I joyo
	0x0021a507, // n0x0f8c c0x0000 (---------------)  + I kameoka
	0x0021a184, // n0x0f8d c0x0000 (---------------)  + I kamo
	0x002047c4, // n0x0f8e c0x0000 (---------------)  + I kita
	0x002faf84, // n0x0f8f c0x0000 (---------------)  + I kizu
	0x002f1d88, // n0x0f90 c0x0000 (---------------)  + I kumiyama
	0x00302448, // n0x0f91 c0x0000 (---------------)  + I kyotamba
	0x00308709, // n0x0f92 c0x0000 (---------------)  + I kyotanabe
	0x00342288, // n0x0f93 c0x0000 (---------------)  + I kyotango
	0x002d2e87, // n0x0f94 c0x0000 (---------------)  + I maizuru
	0x00223406, // n0x0f95 c0x0000 (---------------)  + I minami
	0x002d3f4f, // n0x0f96 c0x0000 (---------------)  + I minamiyamashiro
	0x002c2286, // n0x0f97 c0x0000 (---------------)  + I miyazu
	0x002cc684, // n0x0f98 c0x0000 (---------------)  + I muko
	0x0030228a, // n0x0f99 c0x0000 (---------------)  + I nagaokakyo
	0x0024a3c7, // n0x0f9a c0x0000 (---------------)  + I nakagyo
	0x00203b86, // n0x0f9b c0x0000 (---------------)  + I nantan
	0x00290309, // n0x0f9c c0x0000 (---------------)  + I oyamazaki
	0x00308685, // n0x0f9d c0x0000 (---------------)  + I sakyo
	0x0023d745, // n0x0f9e c0x0000 (---------------)  + I seika
	0x003087c6, // n0x0f9f c0x0000 (---------------)  + I tanabe
	0x0021ea03, // n0x0fa0 c0x0000 (---------------)  + I uji
	0x003a2849, // n0x0fa1 c0x0000 (---------------)  + I ujitawara
	0x0021b446, // n0x0fa2 c0x0000 (---------------)  + I wazuka
	0x0021a749, // n0x0fa3 c0x0000 (---------------)  + I yamashina
	0x0038e686, // n0x0fa4 c0x0000 (---------------)  + I yawata
	0x002c0b05, // n0x0fa5 c0x0000 (---------------)  + I asahi
	0x00226f45, // n0x0fa6 c0x0000 (---------------)  + I inabe
	0x00204e83, // n0x0fa7 c0x0000 (---------------)  + I ise
	0x0021a648, // n0x0fa8 c0x0000 (---------------)  + I kameyama
	0x00398b87, // n0x0fa9 c0x0000 (---------------)  + I kawagoe
	0x002f1744, // n0x0faa c0x0000 (---------------)  + I kiho
	0x0021d208, // n0x0fab c0x0000 (---------------)  + I kisosaki
	0x002a8e04, // n0x0fac c0x0000 (---------------)  + I kiwa
	0x002b4486, // n0x0fad c0x0000 (---------------)  + I komono
	0x0027f446, // n0x0fae c0x0000 (---------------)  + I kumano
	0x00243186, // n0x0faf c0x0000 (---------------)  + I kuwana
	0x002c7bc9, // n0x0fb0 c0x0000 (---------------)  + I matsusaka
	0x002bbc05, // n0x0fb1 c0x0000 (---------------)  + I meiwa
	0x002a9086, // n0x0fb2 c0x0000 (---------------)  + I mihama
	0x0025afc9, // n0x0fb3 c0x0000 (---------------)  + I minamiise
	0x002c13c6, // n0x0fb4 c0x0000 (---------------)  + I misugi
	0x002d4046, // n0x0fb5 c0x0000 (---------------)  + I miyama
	0x0037dbc6, // n0x0fb6 c0x0000 (---------------)  + I nabari
	0x00209f45, // n0x0fb7 c0x0000 (---------------)  + I shima
	0x002ea3c6, // n0x0fb8 c0x0000 (---------------)  + I suzuka
	0x003541c4, // n0x0fb9 c0x0000 (---------------)  + I tado
	0x0028c4c5, // n0x0fba c0x0000 (---------------)  + I taiki
	0x002ba304, // n0x0fbb c0x0000 (---------------)  + I taki
	0x0030c206, // n0x0fbc c0x0000 (---------------)  + I tamaki
	0x00395484, // n0x0fbd c0x0000 (---------------)  + I toba
	0x00207a43, // n0x0fbe c0x0000 (---------------)  + I tsu
	0x00287805, // n0x0fbf c0x0000 (---------------)  + I udono
	0x0023a288, // n0x0fc0 c0x0000 (---------------)  + I ureshino
	0x0022e387, // n0x0fc1 c0x0000 (---------------)  + I watarai
	0x002b3b09, // n0x0fc2 c0x0000 (---------------)  + I yokkaichi
	0x00287a48, // n0x0fc3 c0x0000 (---------------)  + I furukawa
	0x00297e91, // n0x0fc4 c0x0000 (---------------)  + I higashimatsushima
	0x0023d30a, // n0x0fc5 c0x0000 (---------------)  + I ishinomaki
	0x0022d707, // n0x0fc6 c0x0000 (---------------)  + I iwanuma
	0x003990c6, // n0x0fc7 c0x0000 (---------------)  + I kakuda
	0x002160c4, // n0x0fc8 c0x0000 (---------------)  + I kami
	0x002ba408, // n0x0fc9 c0x0000 (---------------)  + I kawasaki
	0x00294e89, // n0x0fca c0x0000 (---------------)  + I kesennuma
	0x002a9a48, // n0x0fcb c0x0000 (---------------)  + I marumori
	0x0029804a, // n0x0fcc c0x0000 (---------------)  + I matsushima
	0x002bfa8d, // n0x0fcd c0x0000 (---------------)  + I minamisanriku
	0x0022da46, // n0x0fce c0x0000 (---------------)  + I misato
	0x0035e7c6, // n0x0fcf c0x0000 (---------------)  + I murata
	0x002d9886, // n0x0fd0 c0x0000 (---------------)  + I natori
	0x00373fc7, // n0x0fd1 c0x0000 (---------------)  + I ogawara
	0x002a0705, // n0x0fd2 c0x0000 (---------------)  + I ohira
	0x0034eb47, // n0x0fd3 c0x0000 (---------------)  + I onagawa
	0x0021d2c5, // n0x0fd4 c0x0000 (---------------)  + I osaki
	0x0029b984, // n0x0fd5 c0x0000 (---------------)  + I rifu
	0x002aa106, // n0x0fd6 c0x0000 (---------------)  + I semine
	0x00311787, // n0x0fd7 c0x0000 (---------------)  + I shibata
	0x003a254d, // n0x0fd8 c0x0000 (---------------)  + I shichikashuku
	0x0028fa47, // n0x0fd9 c0x0000 (---------------)  + I shikama
	0x002701c8, // n0x0fda c0x0000 (---------------)  + I shiogama
	0x0027a7c9, // n0x0fdb c0x0000 (---------------)  + I shiroishi
	0x00227e86, // n0x0fdc c0x0000 (---------------)  + I tagajo
	0x002399c5, // n0x0fdd c0x0000 (---------------)  + I taiwa
	0x00213604, // n0x0fde c0x0000 (---------------)  + I tome
	0x002661c6, // n0x0fdf c0x0000 (---------------)  + I tomiya
	0x0034ec86, // n0x0fe0 c0x0000 (---------------)  + I wakuya
	0x002db006, // n0x0fe1 c0x0000 (---------------)  + I watari
	0x0029b348, // n0x0fe2 c0x0000 (---------------)  + I yamamoto
	0x002126c3, // n0x0fe3 c0x0000 (---------------)  + I zao
	0x00207683, // n0x0fe4 c0x0000 (---------------)  + I aya
	0x00325f05, // n0x0fe5 c0x0000 (---------------)  + I ebino
	0x0023c086, // n0x0fe6 c0x0000 (---------------)  + I gokase
	0x002ad6c5, // n0x0fe7 c0x0000 (---------------)  + I hyuga
	0x00244908, // n0x0fe8 c0x0000 (---------------)  + I kadogawa
	0x0029dd8a, // n0x0fe9 c0x0000 (---------------)  + I kawaminami
	0x002e3544, // n0x0fea c0x0000 (---------------)  + I kijo
	0x002c3988, // n0x0feb c0x0000 (---------------)  + I kitagawa
	0x00296e48, // n0x0fec c0x0000 (---------------)  + I kitakata
	0x0027e9c7, // n0x0fed c0x0000 (---------------)  + I kitaura
	0x0035c989, // n0x0fee c0x0000 (---------------)  + I kobayashi
	0x002b5148, // n0x0fef c0x0000 (---------------)  + I kunitomi
	0x00290087, // n0x0ff0 c0x0000 (---------------)  + I kushima
	0x0029c906, // n0x0ff1 c0x0000 (---------------)  + I mimata
	0x0020c1ca, // n0x0ff2 c0x0000 (---------------)  + I miyakonojo
	0x00266248, // n0x0ff3 c0x0000 (---------------)  + I miyazaki
	0x002ba909, // n0x0ff4 c0x0000 (---------------)  + I morotsuka
	0x00272c08, // n0x0ff5 c0x0000 (---------------)  + I nichinan
	0x0021bac9, // n0x0ff6 c0x0000 (---------------)  + I nishimera
	0x002bad87, // n0x0ff7 c0x0000 (---------------)  + I nobeoka
	0x00342145, // n0x0ff8 c0x0000 (---------------)  + I saito
	0x002a2ec6, // n0x0ff9 c0x0000 (---------------)  + I shiiba
	0x00292c08, // n0x0ffa c0x0000 (---------------)  + I shintomi
	0x00252dc8, // n0x0ffb c0x0000 (---------------)  + I takaharu
	0x0021ab48, // n0x0ffc c0x0000 (---------------)  + I takanabe
	0x002165c8, // n0x0ffd c0x0000 (---------------)  + I takazaki
	0x0020e705, // n0x0ffe c0x0000 (---------------)  + I tsuno
	0x00200344, // n0x0fff c0x0000 (---------------)  + I achi
	0x00398888, // n0x1000 c0x0000 (---------------)  + I agematsu
	0x00203c84, // n0x1001 c0x0000 (---------------)  + I anan
	0x003950c4, // n0x1002 c0x0000 (---------------)  + I aoki
	0x002c0b05, // n0x1003 c0x0000 (---------------)  + I asahi
	0x002918c7, // n0x1004 c0x0000 (---------------)  + I azumino
	0x002043c9, // n0x1005 c0x0000 (---------------)  + I chikuhoku
	0x00207487, // n0x1006 c0x0000 (---------------)  + I chikuma
	0x0020ee05, // n0x1007 c0x0000 (---------------)  + I chino
	0x00278086, // n0x1008 c0x0000 (---------------)  + I fujimi
	0x0033c0c6, // n0x1009 c0x0000 (---------------)  + I hakuba
	0x00202304, // n0x100a c0x0000 (---------------)  + I hara
	0x002a1c86, // n0x100b c0x0000 (---------------)  + I hiraya
	0x00215484, // n0x100c c0x0000 (---------------)  + I iida
	0x00257606, // n0x100d c0x0000 (---------------)  + I iijima
	0x003a3986, // n0x100e c0x0000 (---------------)  + I iiyama
	0x002144c6, // n0x100f c0x0000 (---------------)  + I iizuna
	0x00202445, // n0x1010 c0x0000 (---------------)  + I ikeda
	0x002447c7, // n0x1011 c0x0000 (---------------)  + I ikusaka
	0x002012c3, // n0x1012 c0x0000 (---------------)  + I ina
	0x00248c49, // n0x1013 c0x0000 (---------------)  + I karuizawa
	0x002f2788, // n0x1014 c0x0000 (---------------)  + I kawakami
	0x0021d204, // n0x1015 c0x0000 (---------------)  + I kiso
	0x003546cd, // n0x1016 c0x0000 (---------------)  + I kisofukushima
	0x00296cc8, // n0x1017 c0x0000 (---------------)  + I kitaaiki
	0x0028d488, // n0x1018 c0x0000 (---------------)  + I komagane
	0x002ba886, // n0x1019 c0x0000 (---------------)  + I komoro
	0x0021d609, // n0x101a c0x0000 (---------------)  + I matsukawa
	0x002c0e89, // n0x101b c0x0000 (---------------)  + I matsumoto
	0x002da805, // n0x101c c0x0000 (---------------)  + I miasa
	0x0029de8a, // n0x101d c0x0000 (---------------)  + I minamiaiki
	0x002805ca, // n0x101e c0x0000 (---------------)  + I minamimaki
	0x0028abcc, // n0x101f c0x0000 (---------------)  + I minamiminowa
	0x0028ad46, // n0x1020 c0x0000 (---------------)  + I minowa
	0x00278946, // n0x1021 c0x0000 (---------------)  + I miyada
	0x002c2b06, // n0x1022 c0x0000 (---------------)  + I miyota
	0x0024bf89, // n0x1023 c0x0000 (---------------)  + I mochizuki
	0x00352206, // n0x1024 c0x0000 (---------------)  + I nagano
	0x002875c6, // n0x1025 c0x0000 (---------------)  + I nagawa
	0x00324cc6, // n0x1026 c0x0000 (---------------)  + I nagiso
	0x002b0508, // n0x1027 c0x0000 (---------------)  + I nakagawa
	0x003288c6, // n0x1028 c0x0000 (---------------)  + I nakano
	0x002c7f0b, // n0x1029 c0x0000 (---------------)  + I nozawaonsen
	0x00291a45, // n0x102a c0x0000 (---------------)  + I obuse
	0x00230545, // n0x102b c0x0000 (---------------)  + I ogawa
	0x00278bc5, // n0x102c c0x0000 (---------------)  + I okaya
	0x002013c6, // n0x102d c0x0000 (---------------)  + I omachi
	0x0020c183, // n0x102e c0x0000 (---------------)  + I omi
	0x00243106, // n0x102f c0x0000 (---------------)  + I ookuwa
	0x0028f9c7, // n0x1030 c0x0000 (---------------)  + I ooshika
	0x002ba2c5, // n0x1031 c0x0000 (---------------)  + I otaki
	0x00264245, // n0x1032 c0x0000 (---------------)  + I otari
	0x002e2d05, // n0x1033 c0x0000 (---------------)  + I sakae
	0x0031ac86, // n0x1034 c0x0000 (---------------)  + I sakaki
	0x002da8c4, // n0x1035 c0x0000 (---------------)  + I saku
	0x0036a506, // n0x1036 c0x0000 (---------------)  + I sakuho
	0x00265b89, // n0x1037 c0x0000 (---------------)  + I shimosuwa
	0x0020124c, // n0x1038 c0x0000 (---------------)  + I shinanomachi
	0x0029b6c8, // n0x1039 c0x0000 (---------------)  + I shiojiri
	0x00265cc4, // n0x103a c0x0000 (---------------)  + I suwa
	0x002ea046, // n0x103b c0x0000 (---------------)  + I suzaka
	0x002a22c6, // n0x103c c0x0000 (---------------)  + I takagi
	0x0021a108, // n0x103d c0x0000 (---------------)  + I takamori
	0x002c17c8, // n0x103e c0x0000 (---------------)  + I takayama
	0x00201149, // n0x103f c0x0000 (---------------)  + I tateshina
	0x0020e687, // n0x1040 c0x0000 (---------------)  + I tatsuno
	0x002b0d09, // n0x1041 c0x0000 (---------------)  + I togakushi
	0x00271046, // n0x1042 c0x0000 (---------------)  + I togura
	0x0022d9c4, // n0x1043 c0x0000 (---------------)  + I tomi
	0x0020f404, // n0x1044 c0x0000 (---------------)  + I ueda
	0x00255d44, // n0x1045 c0x0000 (---------------)  + I wada
	0x002815c8, // n0x1046 c0x0000 (---------------)  + I yamagata
	0x0020420a, // n0x1047 c0x0000 (---------------)  + I yamanouchi
	0x0034a286, // n0x1048 c0x0000 (---------------)  + I yasaka
	0x00350687, // n0x1049 c0x0000 (---------------)  + I yasuoka
	0x00288747, // n0x104a c0x0000 (---------------)  + I chijiwa
	0x00228c05, // n0x104b c0x0000 (---------------)  + I futsu
	0x00285bc4, // n0x104c c0x0000 (---------------)  + I goto
	0x0028e206, // n0x104d c0x0000 (---------------)  + I hasami
	0x003010c6, // n0x104e c0x0000 (---------------)  + I hirado
	0x0023a783, // n0x104f c0x0000 (---------------)  + I iki
	0x002f25c7, // n0x1050 c0x0000 (---------------)  + I isahaya
	0x00331d48, // n0x1051 c0x0000 (---------------)  + I kawatana
	0x002da94a, // n0x1052 c0x0000 (---------------)  + I kuchinotsu
	0x002cb708, // n0x1053 c0x0000 (---------------)  + I matsuura
	0x002e33c8, // n0x1054 c0x0000 (---------------)  + I nagasaki
	0x003954c5, // n0x1055 c0x0000 (---------------)  + I obama
	0x00374685, // n0x1056 c0x0000 (---------------)  + I omura
	0x002b0c45, // n0x1057 c0x0000 (---------------)  + I oseto
	0x00228fc6, // n0x1058 c0x0000 (---------------)  + I saikai
	0x0023db86, // n0x1059 c0x0000 (---------------)  + I sasebo
	0x00217ec5, // n0x105a c0x0000 (---------------)  + I seihi
	0x00327a09, // n0x105b c0x0000 (---------------)  + I shimabara
	0x002859cc, // n0x105c c0x0000 (---------------)  + I shinkamigoto
	0x002352c7, // n0x105d c0x0000 (---------------)  + I togitsu
	0x002980c8, // n0x105e c0x0000 (---------------)  + I tsushima
	0x0028e845, // n0x105f c0x0000 (---------------)  + I unzen
	0x00685804, // n0x1060 c0x0001 (---------------)  ! I city
	0x002293c4, // n0x1061 c0x0000 (---------------)  + I ando
	0x002af3c4, // n0x1062 c0x0000 (---------------)  + I gose
	0x0020ef46, // n0x1063 c0x0000 (---------------)  + I heguri
	0x0029fb4e, // n0x1064 c0x0000 (---------------)  + I higashiyoshino
	0x0023d7c7, // n0x1065 c0x0000 (---------------)  + I ikaruga
	0x0028d445, // n0x1066 c0x0000 (---------------)  + I ikoma
	0x0029078c, // n0x1067 c0x0000 (---------------)  + I kamikitayama
	0x002a8cc7, // n0x1068 c0x0000 (---------------)  + I kanmaki
	0x00311707, // n0x1069 c0x0000 (---------------)  + I kashiba
	0x003825c9, // n0x106a c0x0000 (---------------)  + I kashihara
	0x00219889, // n0x106b c0x0000 (---------------)  + I katsuragi
	0x00287b45, // n0x106c c0x0000 (---------------)  + I kawai
	0x002f2788, // n0x106d c0x0000 (---------------)  + I kawakami
	0x002bb049, // n0x106e c0x0000 (---------------)  + I kawanishi
	0x002d8005, // n0x106f c0x0000 (---------------)  + I koryo
	0x002ba208, // n0x1070 c0x0000 (---------------)  + I kurotaki
	0x002c84c6, // n0x1071 c0x0000 (---------------)  + I mitsue
	0x002d3946, // n0x1072 c0x0000 (---------------)  + I miyake
	0x0031c044, // n0x1073 c0x0000 (---------------)  + I nara
	0x00325fc8, // n0x1074 c0x0000 (---------------)  + I nosegawa
	0x00228043, // n0x1075 c0x0000 (---------------)  + I oji
	0x00207fc4, // n0x1076 c0x0000 (---------------)  + I ouda
	0x003a2385, // n0x1077 c0x0000 (---------------)  + I oyodo
	0x002dc647, // n0x1078 c0x0000 (---------------)  + I sakurai
	0x003a3fc5, // n0x1079 c0x0000 (---------------)  + I sango
	0x00282989, // n0x107a c0x0000 (---------------)  + I shimoichi
	0x0025becd, // n0x107b c0x0000 (---------------)  + I shimokitayama
	0x0027b106, // n0x107c c0x0000 (---------------)  + I shinjo
	0x00262d04, // n0x107d c0x0000 (---------------)  + I soni
	0x0029ca08, // n0x107e c0x0000 (---------------)  + I takatori
	0x002782ca, // n0x107f c0x0000 (---------------)  + I tawaramoto
	0x00218dc7, // n0x1080 c0x0000 (---------------)  + I tenkawa
	0x00320785, // n0x1081 c0x0000 (---------------)  + I tenri
	0x00208003, // n0x1082 c0x0000 (---------------)  + I uda
	0x0029f18e, // n0x1083 c0x0000 (---------------)  + I yamatokoriyama
	0x0029098c, // n0x1084 c0x0000 (---------------)  + I yamatotakada
	0x002f9507, // n0x1085 c0x0000 (---------------)  + I yamazoe
	0x0029fd07, // n0x1086 c0x0000 (---------------)  + I yoshino
	0x00201b83, // n0x1087 c0x0000 (---------------)  + I aga
	0x00352245, // n0x1088 c0x0000 (---------------)  + I agano
	0x002af3c5, // n0x1089 c0x0000 (---------------)  + I gosen
	0x00298d08, // n0x108a c0x0000 (---------------)  + I itoigawa
	0x00295a09, // n0x108b c0x0000 (---------------)  + I izumozaki
	0x00294706, // n0x108c c0x0000 (---------------)  + I joetsu
	0x0021a184, // n0x108d c0x0000 (---------------)  + I kamo
	0x0022d646, // n0x108e c0x0000 (---------------)  + I kariwa
	0x002032cb, // n0x108f c0x0000 (---------------)  + I kashiwazaki
	0x002c730c, // n0x1090 c0x0000 (---------------)  + I minamiuonuma
	0x002f4ec7, // n0x1091 c0x0000 (---------------)  + I mitsuke
	0x002cc3c5, // n0x1092 c0x0000 (---------------)  + I muika
	0x00381148, // n0x1093 c0x0000 (---------------)  + I murakami
	0x002d1a45, // n0x1094 c0x0000 (---------------)  + I myoko
	0x00302287, // n0x1095 c0x0000 (---------------)  + I nagaoka
	0x002350c7, // n0x1096 c0x0000 (---------------)  + I niigata
	0x0024f885, // n0x1097 c0x0000 (---------------)  + I ojiya
	0x0020c183, // n0x1098 c0x0000 (---------------)  + I omi
	0x00360b84, // n0x1099 c0x0000 (---------------)  + I sado
	0x00201005, // n0x109a c0x0000 (---------------)  + I sanjo
	0x002e7905, // n0x109b c0x0000 (---------------)  + I seiro
	0x002e7906, // n0x109c c0x0000 (---------------)  + I seirou
	0x00261e88, // n0x109d c0x0000 (---------------)  + I sekikawa
	0x00311787, // n0x109e c0x0000 (---------------)  + I shibata
	0x00376f46, // n0x109f c0x0000 (---------------)  + I tagami
	0x00351ec6, // n0x10a0 c0x0000 (---------------)  + I tainai
	0x002e5886, // n0x10a1 c0x0000 (---------------)  + I tochio
	0x0028f0c9, // n0x10a2 c0x0000 (---------------)  + I tokamachi
	0x00207a47, // n0x10a3 c0x0000 (---------------)  + I tsubame
	0x00294586, // n0x10a4 c0x0000 (---------------)  + I tsunan
	0x002c7486, // n0x10a5 c0x0000 (---------------)  + I uonuma
	0x0024f946, // n0x10a6 c0x0000 (---------------)  + I yahiko
	0x002a97c5, // n0x10a7 c0x0000 (---------------)  + I yoita
	0x00216dc6, // n0x10a8 c0x0000 (---------------)  + I yuzawa
	0x0038cf85, // n0x10a9 c0x0000 (---------------)  + I beppu
	0x002d3588, // n0x10aa c0x0000 (---------------)  + I bungoono
	0x002942cb, // n0x10ab c0x0000 (---------------)  + I bungotakada
	0x0028e006, // n0x10ac c0x0000 (---------------)  + I hasama
	0x00288784, // n0x10ad c0x0000 (---------------)  + I hiji
	0x0035c489, // n0x10ae c0x0000 (---------------)  + I himeshima
	0x002a3e04, // n0x10af c0x0000 (---------------)  + I hita
	0x002c8448, // n0x10b0 c0x0000 (---------------)  + I kamitsue
	0x00286487, // n0x10b1 c0x0000 (---------------)  + I kokonoe
	0x00284144, // n0x10b2 c0x0000 (---------------)  + I kuju
	0x002b4608, // n0x10b3 c0x0000 (---------------)  + I kunisaki
	0x002bc1c4, // n0x10b4 c0x0000 (---------------)  + I kusu
	0x002a9804, // n0x10b5 c0x0000 (---------------)  + I oita
	0x00289605, // n0x10b6 c0x0000 (---------------)  + I saiki
	0x002fc5c6, // n0x10b7 c0x0000 (---------------)  + I taketa
	0x002f1cc7, // n0x10b8 c0x0000 (---------------)  + I tsukumi
	0x00244843, // n0x10b9 c0x0000 (---------------)  + I usa
	0x0029ec45, // n0x10ba c0x0000 (---------------)  + I usuki
	0x002be384, // n0x10bb c0x0000 (---------------)  + I yufu
	0x0026a546, // n0x10bc c0x0000 (---------------)  + I akaiwa
	0x002da888, // n0x10bd c0x0000 (---------------)  + I asakuchi
	0x00331a85, // n0x10be c0x0000 (---------------)  + I bizen
	0x00291349, // n0x10bf c0x0000 (---------------)  + I hayashima
	0x0020b085, // n0x10c0 c0x0000 (---------------)  + I ibara
	0x002bdd88, // n0x10c1 c0x0000 (---------------)  + I kagamino
	0x0030a1c7, // n0x10c2 c0x0000 (---------------)  + I kasaoka
	0x0037e8c8, // n0x10c3 c0x0000 (---------------)  + I kibichuo
	0x002b3947, // n0x10c4 c0x0000 (---------------)  + I kumenan
	0x0035bec9, // n0x10c5 c0x0000 (---------------)  + I kurashiki
	0x0022cbc6, // n0x10c6 c0x0000 (---------------)  + I maniwa
	0x00345a46, // n0x10c7 c0x0000 (---------------)  + I misaki
	0x0025e584, // n0x10c8 c0x0000 (---------------)  + I nagi
	0x0029c845, // n0x10c9 c0x0000 (---------------)  + I niimi
	0x002f038c, // n0x10ca c0x0000 (---------------)  + I nishiawakura
	0x00278bc7, // n0x10cb c0x0000 (---------------)  + I okayama
	0x00278fc7, // n0x10cc c0x0000 (---------------)  + I satosho
	0x00288608, // n0x10cd c0x0000 (---------------)  + I setouchi
	0x0027b106, // n0x10ce c0x0000 (---------------)  + I shinjo
	0x002a0644, // n0x10cf c0x0000 (---------------)  + I shoo
	0x00322544, // n0x10d0 c0x0000 (---------------)  + I soja
	0x00281749, // n0x10d1 c0x0000 (---------------)  + I takahashi
	0x002c2c06, // n0x10d2 c0x0000 (---------------)  + I tamano
	0x0021ca47, // n0x10d3 c0x0000 (---------------)  + I tsuyama
	0x002072c4, // n0x10d4 c0x0000 (---------------)  + I wake
	0x002b1646, // n0x10d5 c0x0000 (---------------)  + I yakage
	0x00309dc5, // n0x10d6 c0x0000 (---------------)  + I aguni
	0x002a4107, // n0x10d7 c0x0000 (---------------)  + I ginowan
	0x002c7e86, // n0x10d8 c0x0000 (---------------)  + I ginoza
	0x0035ed89, // n0x10d9 c0x0000 (---------------)  + I gushikami
	0x00280407, // n0x10da c0x0000 (---------------)  + I haebaru
	0x00266d87, // n0x10db c0x0000 (---------------)  + I higashi
	0x002a17c6, // n0x10dc c0x0000 (---------------)  + I hirara
	0x00244285, // n0x10dd c0x0000 (---------------)  + I iheya
	0x0027ef88, // n0x10de c0x0000 (---------------)  + I ishigaki
	0x0021b2c8, // n0x10df c0x0000 (---------------)  + I ishikawa
	0x0023b246, // n0x10e0 c0x0000 (---------------)  + I itoman
	0x00331ac5, // n0x10e1 c0x0000 (---------------)  + I izena
	0x0026c506, // n0x10e2 c0x0000 (---------------)  + I kadena
	0x00215ec3, // n0x10e3 c0x0000 (---------------)  + I kin
	0x00298b89, // n0x10e4 c0x0000 (---------------)  + I kitadaito
	0x002a75ce, // n0x10e5 c0x0000 (---------------)  + I kitanakagusuku
	0x002b3648, // n0x10e6 c0x0000 (---------------)  + I kumejima
	0x002a8f08, // n0x10e7 c0x0000 (---------------)  + I kunigami
	0x0023b04b, // n0x10e8 c0x0000 (---------------)  + I minamidaito
	0x00291586, // n0x10e9 c0x0000 (---------------)  + I motobu
	0x00247bc4, // n0x10ea c0x0000 (---------------)  + I nago
	0x00206384, // n0x10eb c0x0000 (---------------)  + I naha
	0x002a76ca, // n0x10ec c0x0000 (---------------)  + I nakagusuku
	0x002190c7, // n0x10ed c0x0000 (---------------)  + I nakijin
	0x00294645, // n0x10ee c0x0000 (---------------)  + I nanjo
	0x00210cc9, // n0x10ef c0x0000 (---------------)  + I nishihara
	0x002b9405, // n0x10f0 c0x0000 (---------------)  + I ogimi
	0x00395107, // n0x10f1 c0x0000 (---------------)  + I okinawa
	0x00300704, // n0x10f2 c0x0000 (---------------)  + I onna
	0x00381cc7, // n0x10f3 c0x0000 (---------------)  + I shimoji
	0x0022d8c8, // n0x10f4 c0x0000 (---------------)  + I taketomi
	0x002fd406, // n0x10f5 c0x0000 (---------------)  + I tarama
	0x002fadc9, // n0x10f6 c0x0000 (---------------)  + I tokashiki
	0x002b524a, // n0x10f7 c0x0000 (---------------)  + I tomigusuku
	0x00219046, // n0x10f8 c0x0000 (---------------)  + I tonaki
	0x00296806, // n0x10f9 c0x0000 (---------------)  + I urasoe
	0x002ac685, // n0x10fa c0x0000 (---------------)  + I uruma
	0x00372285, // n0x10fb c0x0000 (---------------)  + I yaese
	0x00355487, // n0x10fc c0x0000 (---------------)  + I yomitan
	0x0022ac48, // n0x10fd c0x0000 (---------------)  + I yonabaru
	0x00309d08, // n0x10fe c0x0000 (---------------)  + I yonaguni
	0x00240f06, // n0x10ff c0x0000 (---------------)  + I zamami
	0x00226fc5, // n0x1100 c0x0000 (---------------)  + I abeno
	0x00247cce, // n0x1101 c0x0000 (---------------)  + I chihayaakasaka
	0x0032c104, // n0x1102 c0x0000 (---------------)  + I chuo
	0x0023b1c5, // n0x1103 c0x0000 (---------------)  + I daito
	0x00277a09, // n0x1104 c0x0000 (---------------)  + I fujiidera
	0x00250a88, // n0x1105 c0x0000 (---------------)  + I habikino
	0x003a0586, // n0x1106 c0x0000 (---------------)  + I hannan
	0x0029afcc, // n0x1107 c0x0000 (---------------)  + I higashiosaka
	0x0029d990, // n0x1108 c0x0000 (---------------)  + I higashisumiyoshi
	0x0029f78f, // n0x1109 c0x0000 (---------------)  + I higashiyodogawa
	0x002a0748, // n0x110a c0x0000 (---------------)  + I hirakata
	0x002c3847, // n0x110b c0x0000 (---------------)  + I ibaraki
	0x00202445, // n0x110c c0x0000 (---------------)  + I ikeda
	0x0027e805, // n0x110d c0x0000 (---------------)  + I izumi
	0x002f1b49, // n0x110e c0x0000 (---------------)  + I izumiotsu
	0x00295dc9, // n0x110f c0x0000 (---------------)  + I izumisano
	0x00222846, // n0x1110 c0x0000 (---------------)  + I kadoma
	0x002f9247, // n0x1111 c0x0000 (---------------)  + I kaizuka
	0x00389f05, // n0x1112 c0x0000 (---------------)  + I kanan
	0x0038e149, // n0x1113 c0x0000 (---------------)  + I kashiwara
	0x0032d886, // n0x1114 c0x0000 (---------------)  + I katano
	0x0035204d, // n0x1115 c0x0000 (---------------)  + I kawachinagano
	0x002896c9, // n0x1116 c0x0000 (---------------)  + I kishiwada
	0x002047c4, // n0x1117 c0x0000 (---------------)  + I kita
	0x002b33c8, // n0x1118 c0x0000 (---------------)  + I kumatori
	0x00398949, // n0x1119 c0x0000 (---------------)  + I matsubara
	0x0034a446, // n0x111a c0x0000 (---------------)  + I minato
	0x00278185, // n0x111b c0x0000 (---------------)  + I minoh
	0x00345a46, // n0x111c c0x0000 (---------------)  + I misaki
	0x0030de49, // n0x111d c0x0000 (---------------)  + I moriguchi
	0x00309448, // n0x111e c0x0000 (---------------)  + I neyagawa
	0x00210385, // n0x111f c0x0000 (---------------)  + I nishi
	0x00261e04, // n0x1120 c0x0000 (---------------)  + I nose
	0x0029b18b, // n0x1121 c0x0000 (---------------)  + I osakasayama
	0x0034a305, // n0x1122 c0x0000 (---------------)  + I sakai
	0x0022f286, // n0x1123 c0x0000 (---------------)  + I sayama
	0x00283686, // n0x1124 c0x0000 (---------------)  + I sennan
	0x002460c6, // n0x1125 c0x0000 (---------------)  + I settsu
	0x003820cb, // n0x1126 c0x0000 (---------------)  + I shijonawate
	0x00291449, // n0x1127 c0x0000 (---------------)  + I shimamoto
	0x00218205, // n0x1128 c0x0000 (---------------)  + I suita
	0x0037e687, // n0x1129 c0x0000 (---------------)  + I tadaoka
	0x0023d286, // n0x112a c0x0000 (---------------)  + I taishi
	0x003788c6, // n0x112b c0x0000 (---------------)  + I tajiri
	0x00282848, // n0x112c c0x0000 (---------------)  + I takaishi
	0x002fc6c9, // n0x112d c0x0000 (---------------)  + I takatsuki
	0x0026ff8c, // n0x112e c0x0000 (---------------)  + I tondabayashi
	0x0024a2c8, // n0x112f c0x0000 (---------------)  + I toyonaka
	0x002500c6, // n0x1130 c0x0000 (---------------)  + I toyono
	0x00341d43, // n0x1131 c0x0000 (---------------)  + I yao
	0x00248746, // n0x1132 c0x0000 (---------------)  + I ariake
	0x0027e4c5, // n0x1133 c0x0000 (---------------)  + I arita
	0x0027d508, // n0x1134 c0x0000 (---------------)  + I fukudomi
	0x002269c6, // n0x1135 c0x0000 (---------------)  + I genkai
	0x002a4348, // n0x1136 c0x0000 (---------------)  + I hamatama
	0x00349905, // n0x1137 c0x0000 (---------------)  + I hizen
	0x0027c105, // n0x1138 c0x0000 (---------------)  + I imari
	0x0030a448, // n0x1139 c0x0000 (---------------)  + I kamimine
	0x002ea4c7, // n0x113a c0x0000 (---------------)  + I kanzaki
	0x00376b87, // n0x113b c0x0000 (---------------)  + I karatsu
	0x002a9907, // n0x113c c0x0000 (---------------)  + I kashima
	0x0021d388, // n0x113d c0x0000 (---------------)  + I kitagata
	0x002904c8, // n0x113e c0x0000 (---------------)  + I kitahata
	0x00240b06, // n0x113f c0x0000 (---------------)  + I kiyama
	0x0030c047, // n0x1140 c0x0000 (---------------)  + I kouhoku
	0x002adf87, // n0x1141 c0x0000 (---------------)  + I kyuragi
	0x0027e38a, // n0x1142 c0x0000 (---------------)  + I nishiarita
	0x00212e03, // n0x1143 c0x0000 (---------------)  + I ogi
	0x002013c6, // n0x1144 c0x0000 (---------------)  + I omachi
	0x00204345, // n0x1145 c0x0000 (---------------)  + I ouchi
	0x00378a84, // n0x1146 c0x0000 (---------------)  + I saga
	0x0027a7c9, // n0x1147 c0x0000 (---------------)  + I shiroishi
	0x0035be44, // n0x1148 c0x0000 (---------------)  + I taku
	0x0022e404, // n0x1149 c0x0000 (---------------)  + I tara
	0x002a2144, // n0x114a c0x0000 (---------------)  + I tosu
	0x0029fd0b, // n0x114b c0x0000 (---------------)  + I yoshinogari
	0x00398ac7, // n0x114c c0x0000 (---------------)  + I arakawa
	0x00247f05, // n0x114d c0x0000 (---------------)  + I asaka
	0x00294148, // n0x114e c0x0000 (---------------)  + I chichibu
	0x00278086, // n0x114f c0x0000 (---------------)  + I fujimi
	0x00278088, // n0x1150 c0x0000 (---------------)  + I fujimino
	0x0027ca46, // n0x1151 c0x0000 (---------------)  + I fukaya
	0x0028ba45, // n0x1152 c0x0000 (---------------)  + I hanno
	0x0028cec5, // n0x1153 c0x0000 (---------------)  + I hanyu
	0x0028eb86, // n0x1154 c0x0000 (---------------)  + I hasuda
	0x0028f748, // n0x1155 c0x0000 (---------------)  + I hatogaya
	0x00290248, // n0x1156 c0x0000 (---------------)  + I hatoyama
	0x0027a986, // n0x1157 c0x0000 (---------------)  + I hidaka
	0x00293f8f, // n0x1158 c0x0000 (---------------)  + I higashichichibu
	0x00298650, // n0x1159 c0x0000 (---------------)  + I higashimatsuyama
	0x0038d6c5, // n0x115a c0x0000 (---------------)  + I honjo
	0x002012c3, // n0x115b c0x0000 (---------------)  + I ina
	0x00251c85, // n0x115c c0x0000 (---------------)  + I iruma
	0x002fdb88, // n0x115d c0x0000 (---------------)  + I iwatsuki
	0x00295cc9, // n0x115e c0x0000 (---------------)  + I kamiizumi
	0x002e8388, // n0x115f c0x0000 (---------------)  + I kamikawa
	0x0034a6c8, // n0x1160 c0x0000 (---------------)  + I kamisato
	0x00206648, // n0x1161 c0x0000 (---------------)  + I kasukabe
	0x00398b87, // n0x1162 c0x0000 (---------------)  + I kawagoe
	0x00277d49, // n0x1163 c0x0000 (---------------)  + I kawaguchi
	0x002a4548, // n0x1164 c0x0000 (---------------)  + I kawajima
	0x002b0984, // n0x1165 c0x0000 (---------------)  + I kazo
	0x002a1fc8, // n0x1166 c0x0000 (---------------)  + I kitamoto
	0x0028c249, // n0x1167 c0x0000 (---------------)  + I koshigaya
	0x0030d747, // n0x1168 c0x0000 (---------------)  + I kounosu
	0x002a7544, // n0x1169 c0x0000 (---------------)  + I kuki
	0x00207548, // n0x116a c0x0000 (---------------)  + I kumagaya
	0x0024458a, // n0x116b c0x0000 (---------------)  + I matsubushi
	0x002d8546, // n0x116c c0x0000 (---------------)  + I minano
	0x0022da46, // n0x116d c0x0000 (---------------)  + I misato
	0x0021c1c9, // n0x116e c0x0000 (---------------)  + I miyashiro
	0x0029dbc7, // n0x116f c0x0000 (---------------)  + I miyoshi
	0x002c8848, // n0x1170 c0x0000 (---------------)  + I moroyama
	0x0038d208, // n0x1171 c0x0000 (---------------)  + I nagatoro
	0x00207148, // n0x1172 c0x0000 (---------------)  + I namegawa
	0x003501c5, // n0x1173 c0x0000 (---------------)  + I niiza
	0x00373245, // n0x1174 c0x0000 (---------------)  + I ogano
	0x00230545, // n0x1175 c0x0000 (---------------)  + I ogawa
	0x002af385, // n0x1176 c0x0000 (---------------)  + I ogose
	0x002eba47, // n0x1177 c0x0000 (---------------)  + I okegawa
	0x0020c185, // n0x1178 c0x0000 (---------------)  + I omiya
	0x002ba2c5, // n0x1179 c0x0000 (---------------)  + I otaki
	0x00342606, // n0x117a c0x0000 (---------------)  + I ranzan
	0x002e82c7, // n0x117b c0x0000 (---------------)  + I ryokami
	0x00373887, // n0x117c c0x0000 (---------------)  + I saitama
	0x00244886, // n0x117d c0x0000 (---------------)  + I sakado
	0x002cd945, // n0x117e c0x0000 (---------------)  + I satte
	0x0022f286, // n0x117f c0x0000 (---------------)  + I sayama
	0x0024e205, // n0x1180 c0x0000 (---------------)  + I shiki
	0x002ac088, // n0x1181 c0x0000 (---------------)  + I shiraoka
	0x002d6c04, // n0x1182 c0x0000 (---------------)  + I soka
	0x002c1446, // n0x1183 c0x0000 (---------------)  + I sugito
	0x00263b04, // n0x1184 c0x0000 (---------------)  + I toda
	0x00226188, // n0x1185 c0x0000 (---------------)  + I tokigawa
	0x00383dca, // n0x1186 c0x0000 (---------------)  + I tokorozawa
	0x0027becc, // n0x1187 c0x0000 (---------------)  + I tsurugashima
	0x0020a605, // n0x1188 c0x0000 (---------------)  + I urawa
	0x00203686, // n0x1189 c0x0000 (---------------)  + I warabi
	0x00270146, // n0x118a c0x0000 (---------------)  + I yashio
	0x00354c86, // n0x118b c0x0000 (---------------)  + I yokoze
	0x00250144, // n0x118c c0x0000 (---------------)  + I yono
	0x0030a085, // n0x118d c0x0000 (---------------)  + I yorii
	0x0027c887, // n0x118e c0x0000 (---------------)  + I yoshida
	0x0029dc49, // n0x118f c0x0000 (---------------)  + I yoshikawa
	0x002a5907, // n0x1190 c0x0000 (---------------)  + I yoshimi
	0x00685804, // n0x1191 c0x0001 (---------------)  ! I city
	0x00685804, // n0x1192 c0x0001 (---------------)  ! I city
	0x0030dbc5, // n0x1193 c0x0000 (---------------)  + I aisho
	0x0022a804, // n0x1194 c0x0000 (---------------)  + I gamo
	0x0029a98a, // n0x1195 c0x0000 (---------------)  + I higashiomi
	0x00277f06, // n0x1196 c0x0000 (---------------)  + I hikone
	0x0034a644, // n0x1197 c0x0000 (---------------)  + I koka
	0x00203b05, // n0x1198 c0x0000 (---------------)  + I konan
	0x0033b985, // n0x1199 c0x0000 (---------------)  + I kosei
	0x00300fc4, // n0x119a c0x0000 (---------------)  + I koto
	0x002832c7, // n0x119b c0x0000 (---------------)  + I kusatsu
	0x0020b007, // n0x119c c0x0000 (---------------)  + I maibara
	0x002c7a48, // n0x119d c0x0000 (---------------)  + I moriyama
	0x0026b048, // n0x119e c0x0000 (---------------)  + I nagahama
	0x00210389, // n0x119f c0x0000 (---------------)  + I nishiazai
	0x00257ec8, // n0x11a0 c0x0000 (---------------)  + I notogawa
	0x0029ab4b, // n0x11a1 c0x0000 (---------------)  + I omihachiman
	0x0021d104, // n0x11a2 c0x0000 (---------------)  + I otsu
	0x002ff445, // n0x11a3 c0x0000 (---------------)  + I ritto
	0x00280305, // n0x11a4 c0x0000 (---------------)  + I ryuoh
	0x002a9889, // n0x11a5 c0x0000 (---------------)  + I takashima
	0x002fc6c9, // n0x11a6 c0x0000 (---------------)  + I takatsuki
	0x0035c388, // n0x11a7 c0x0000 (---------------)  + I torahime
	0x0025c288, // n0x11a8 c0x0000 (---------------)  + I toyosato
	0x0027eb84, // n0x11a9 c0x0000 (---------------)  + I yasu
	0x002a2305, // n0x11aa c0x0000 (---------------)  + I akagi
	0x00201f03, // n0x11ab c0x0000 (---------------)  + I ama
	0x0021d0c5, // n0x11ac c0x0000 (---------------)  + I gotsu
	0x002a9106, // n0x11ad c0x0000 (---------------)  + I hamada
	0x0029584c, // n0x11ae c0x0000 (---------------)  + I higashiizumo
	0x0021b346, // n0x11af c0x0000 (---------------)  + I hikawa
	0x0024e246, // n0x11b0 c0x0000 (---------------)  + I hikimi
	0x00295a05, // n0x11b1 c0x0000 (---------------)  + I izumo
	0x0031ad08, // n0x11b2 c0x0000 (---------------)  + I kakinoki
	0x002b37c6, // n0x11b3 c0x0000 (---------------)  + I masuda
	0x00399246, // n0x11b4 c0x0000 (---------------)  + I matsue
	0x0022da46, // n0x11b5 c0x0000 (---------------)  + I misato
	0x0021ef4c, // n0x11b6 c0x0000 (---------------)  + I nishinoshima
	0x002db1c4, // n0x11b7 c0x0000 (---------------)  + I ohda
	0x002e59ca, // n0x11b8 c0x0000 (---------------)  + I okinoshima
	0x003a0748, // n0x11b9 c0x0000 (---------------)  + I okuizumo
	0x00295687, // n0x11ba c0x0000 (---------------)  + I shimane
	0x00253786, // n0x11bb c0x0000 (---------------)  + I tamayu
	0x002947c7, // n0x11bc c0x0000 (---------------)  + I tsuwano
	0x002e0245, // n0x11bd c0x0000 (---------------)  + I unnan
	0x00324a06, // n0x11be c0x0000 (---------------)  + I yakumo
	0x0034db86, // n0x11bf c0x0000 (---------------)  + I yasugi
	0x00376a47, // n0x11c0 c0x0000 (---------------)  + I yatsuka
	0x0022e444, // n0x11c1 c0x0000 (---------------)  + I arai
	0x0023e305, // n0x11c2 c0x0000 (---------------)  + I atami
	0x00277a04, // n0x11c3 c0x0000 (---------------)  + I fuji
	0x0029ba07, // n0x11c4 c0x0000 (---------------)  + I fujieda
	0x00277c48, // n0x11c5 c0x0000 (---------------)  + I fujikawa
	0x002787ca, // n0x11c6 c0x0000 (---------------)  + I fujinomiya
	0x0027fb07, // n0x11c7 c0x0000 (---------------)  + I fukuroi
	0x0023b3c7, // n0x11c8 c0x0000 (---------------)  + I gotemba
	0x002c37c7, // n0x11c9 c0x0000 (---------------)  + I haibara
	0x002d1b89, // n0x11ca c0x0000 (---------------)  + I hamamatsu
	0x0029584a, // n0x11cb c0x0000 (---------------)  + I higashiizu
	0x00223083, // n0x11cc c0x0000 (---------------)  + I ito
	0x0022e345, // n0x11cd c0x0000 (---------------)  + I iwata
	0x00214503, // n0x11ce c0x0000 (---------------)  + I izu
	0x002fafc9, // n0x11cf c0x0000 (---------------)  + I izunokuni
	0x002b4b08, // n0x11d0 c0x0000 (---------------)  + I kakegawa
	0x002ac207, // n0x11d1 c0x0000 (---------------)  + I kannami
	0x002e8489, // n0x11d2 c0x0000 (---------------)  + I kawanehon
	0x0021b3c6, // n0x11d3 c0x0000 (---------------)  + I kawazu
	0x003a4e88, // n0x11d4 c0x0000 (---------------)  + I kikugawa
	0x002ddc45, // n0x11d5 c0x0000 (---------------)  + I kosai
	0x003539ca, // n0x11d6 c0x0000 (---------------)  + I makinohara
	0x002cee49, // n0x11d7 c0x0000 (---------------)  + I matsuzaki
	0x0026fc49, // n0x11d8 c0x0000 (---------------)  + I minamiizu
	0x002c0d47, // n0x11d9 c0x0000 (---------------)  + I mishima
	0x002a9b49, // n0x11da c0x0000 (---------------)  + I morimachi
	0x002143c8, // n0x11db c0x0000 (---------------)  + I nishiizu
	0x002ea1c6, // n0x11dc c0x0000 (---------------)  + I numazu
	0x00374248, // n0x11dd c0x0000 (---------------)  + I omaezaki
	0x00212807, // n0x11de c0x0000 (---------------)  + I shimada
	0x002231c7, // n0x11df c0x0000 (---------------)  + I shimizu
	0x002c7807, // n0x11e0 c0x0000 (---------------)  + I shimoda
	0x002b13c8, // n0x11e1 c0x0000 (---------------)  + I shizuoka
	0x002e9ec6, // n0x11e2 c0x0000 (---------------)  + I susono
	0x00244345, // n0x11e3 c0x0000 (---------------)  + I yaizu
	0x0027c887, // n0x11e4 c0x0000 (---------------)  + I yoshida
	0x00296308, // n0x11e5 c0x0000 (---------------)  + I ashikaga
	0x00344784, // n0x11e6 c0x0000 (---------------)  + I bato
	0x00283a44, // n0x11e7 c0x0000 (---------------)  + I haga
	0x002f2987, // n0x11e8 c0x0000 (---------------)  + I ichikai
	0x002ada87, // n0x11e9 c0x0000 (---------------)  + I iwafune
	0x002baeca, // n0x11ea c0x0000 (---------------)  + I kaminokawa
	0x002ea146, // n0x11eb c0x0000 (---------------)  + I kanuma
	0x002f938a, // n0x11ec c0x0000 (---------------)  + I karasuyama
	0x002b96c7, // n0x11ed c0x0000 (---------------)  + I kuroiso
	0x0032bec7, // n0x11ee c0x0000 (---------------)  + I mashiko
	0x00241004, // n0x11ef c0x0000 (---------------)  + I mibu
	0x00259384, // n0x11f0 c0x0000 (---------------)  + I moka
	0x00225406, // n0x11f1 c0x0000 (---------------)  + I motegi
	0x00328b84, // n0x11f2 c0x0000 (---------------)  + I nasu
	0x00328b8c, // n0x11f3 c0x0000 (---------------)  + I nasushiobara
	0x00202c85, // n0x11f4 c0x0000 (---------------)  + I nikko
	0x00216409, // n0x11f5 c0x0000 (---------------)  + I nishikata
	0x00279684, // n0x11f6 c0x0000 (---------------)  + I nogi
	0x002a0705, // n0x11f7 c0x0000 (---------------)  + I ohira
	0x00278248, // n0x11f8 c0x0000 (---------------)  + I ohtawara
	0x0025b745, // n0x11f9 c0x0000 (---------------)  + I oyama
	0x002dc646, // n0x11fa c0x0000 (---------------)  + I sakura
	0x0020b904, // n0x11fb c0x0000 (---------------)  + I sano
	0x00267e8a, // n0x11fc c0x0000 (---------------)  + I shimotsuke
	0x0029d206, // n0x11fd c0x0000 (---------------)  + I shioya
	0x002510ca, // n0x11fe c0x0000 (---------------)  + I takanezawa
	0x00344807, // n0x11ff c0x0000 (---------------)  + I tochigi
	0x0028f585, // n0x1200 c0x0000 (---------------)  + I tsuga
	0x0021ea05, // n0x1201 c0x0000 (---------------)  + I ujiie
	0x00228c4a, // n0x1202 c0x0000 (---------------)  + I utsunomiya
	0x002a1d85, // n0x1203 c0x0000 (---------------)  + I yaita
	0x002a0306, // n0x1204 c0x0000 (---------------)  + I aizumi
	0x00203c84, // n0x1205 c0x0000 (---------------)  + I anan
	0x002afa06, // n0x1206 c0x0000 (---------------)  + I ichiba
	0x00355545, // n0x1207 c0x0000 (---------------)  + I itano
	0x00226a86, // n0x1208 c0x0000 (---------------)  + I kainan
	0x002ab80c, // n0x1209 c0x0000 (---------------)  + I komatsushima
	0x002c89ca, // n0x120a c0x0000 (---------------)  + I matsushige
	0x002806c4, // n0x120b c0x0000 (---------------)  + I mima
	0x00223406, // n0x120c c0x0000 (---------------)  + I minami
	0x0029dbc7, // n0x120d c0x0000 (---------------)  + I miyoshi
	0x002cbb04, // n0x120e c0x0000 (---------------)  + I mugi
	0x002b0508, // n0x120f c0x0000 (---------------)  + I nakagawa
	0x00383cc6, // n0x1210 c0x0000 (---------------)  + I naruto
	0x00247b49, // n0x1211 c0x0000 (---------------)  + I sanagochi
	0x002cf749, // n0x1212 c0x0000 (---------------)  + I shishikui
	0x00290009, // n0x1213 c0x0000 (---------------)  + I tokushima
	0x0036b1c6, // n0x1214 c0x0000 (---------------)  + I wajiki
	0x00212906, // n0x1215 c0x0000 (---------------)  + I adachi
	0x00374387, // n0x1216 c0x0000 (---------------)  + I akiruno
	0x00327948, // n0x1217 c0x0000 (---------------)  + I akishima
	0x00212709, // n0x1218 c0x0000 (---------------)  + I aogashima
	0x00398ac7, // n0x1219 c0x0000 (---------------)  + I arakawa
	0x002b5e86, // n0x121a c0x0000 (---------------)  + I bunkyo
	0x002ff0c7, // n0x121b c0x0000 (---------------)  + I chiyoda
	0x002d9745, // n0x121c c0x0000 (---------------)  + I chofu
	0x0032c104, // n0x121d c0x0000 (---------------)  + I chuo
	0x00373f47, // n0x121e c0x0000 (---------------)  + I edogawa
	0x002be405, // n0x121f c0x0000 (---------------)  + I fuchu
	0x00289545, // n0x1220 c0x0000 (---------------)  + I fussa
	0x002fea47, // n0x1221 c0x0000 (---------------)  + I hachijo
	0x0024f748, // n0x1222 c0x0000 (---------------)  + I hachioji
	0x003810c6, // n0x1223 c0x0000 (---------------)  + I hamura
	0x0029768d, // n0x1224 c0x0000 (---------------)  + I higashikurume
	0x00298f0f, // n0x1225 c0x0000 (---------------)  + I higashimurayama
	0x0029efcd, // n0x1226 c0x0000 (---------------)  + I higashiyamato
	0x0020ee44, // n0x1227 c0x0000 (---------------)  + I hino
	0x0023a386, // n0x1228 c0x0000 (---------------)  + I hinode
	0x002d08c8, // n0x1229 c0x0000 (---------------)  + I hinohara
	0x00324c85, // n0x122a c0x0000 (---------------)  + I inagi
	0x0027e548, // n0x122b c0x0000 (---------------)  + I itabashi
	0x0021854a, // n0x122c c0x0000 (---------------)  + I katsushika
	0x002047c4, // n0x122d c0x0000 (---------------)  + I kita
	0x002abbc6, // n0x122e c0x0000 (---------------)  + I kiyose
	0x0039da87, // n0x122f c0x0000 (---------------)  + I kodaira
	0x0021fc47, // n0x1230 c0x0000 (---------------)  + I koganei
	0x002a2509, // n0x1231 c0x0000 (---------------)  + I kokubunji
	0x00374205, // n0x1232 c0x0000 (---------------)  + I komae
	0x00300fc4, // n0x1233 c0x0000 (---------------)  + I koto
	0x0032f0ca, // n0x1234 c0x0000 (---------------)  + I kouzushima
	0x002b4d09, // n0x1235 c0x0000 (---------------)  + I kunitachi
	0x002a9c47, // n0x1236 c0x0000 (---------------)  + I machida
	0x00297946, // n0x1237 c0x0000 (---------------)  + I meguro
	0x0034a446, // n0x1238 c0x0000 (---------------)  + I minato
	0x002a2246, // n0x1239 c0x0000 (---------------)  + I mitaka
	0x0035d706, // n0x123a c0x0000 (---------------)  + I mizuho
	0x002ceb0f, // n0x123b c0x0000 (---------------)  + I musashimurayama
	0x002d0789, // n0x123c c0x0000 (---------------)  + I musashino
	0x003288c6, // n0x123d c0x0000 (---------------)  + I nakano
	0x0024bc86, // n0x123e c0x0000 (---------------)  + I nerima
	0x00352c89, // n0x123f c0x0000 (---------------)  + I ogasawara
	0x0030c147, // n0x1240 c0x0000 (---------------)  + I okutama
	0x00213403, // n0x1241 c0x0000 (---------------)  + I ome
	0x00209f06, // n0x1242 c0x0000 (---------------)  + I oshima
	0x00201103, // n0x1243 c0x0000 (---------------)  + I ota
	0x0024ce08, // n0x1244 c0x0000 (---------------)  + I setagaya
	0x002fef07, // n0x1245 c0x0000 (---------------)  + I shibuya
	0x002a0949, // n0x1246 c0x0000 (---------------)  + I shinagawa
	0x0027f2c8, // n0x1247 c0x0000 (---------------)  + I shinjuku
	0x00376cc8, // n0x1248 c0x0000 (---------------)  + I suginami
	0x00217b46, // n0x1249 c0x0000 (---------------)  + I sumida
	0x00227189, // n0x124a c0x0000 (---------------)  + I tachikawa
	0x00235205, // n0x124b c0x0000 (---------------)  + I taito
	0x00253784, // n0x124c c0x0000 (---------------)  + I tama
	0x0024a607, // n0x124d c0x0000 (---------------)  + I toshima
	0x0024c005, // n0x124e c0x0000 (---------------)  + I chizu
	0x0020ee44, // n0x124f c0x0000 (---------------)  + I hino
	0x00247fc8, // n0x1250 c0x0000 (---------------)  + I kawahara
	0x00219384, // n0x1251 c0x0000 (---------------)  + I koge
	0x00304587, // n0x1252 c0x0000 (---------------)  + I kotoura
	0x0036edc6, // n0x1253 c0x0000 (---------------)  + I misasa
	0x002e6845, // n0x1254 c0x0000 (---------------)  + I nanbu
	0x00272c08, // n0x1255 c0x0000 (---------------)  + I nichinan
	0x0034a30b, // n0x1256 c0x0000 (---------------)  + I sakaiminato
	0x002f7a87, // n0x1257 c0x0000 (---------------)  + I tottori
	0x00228ec6, // n0x1258 c0x0000 (---------------)  + I wakasa
	0x002c2304, // n0x1259 c0x0000 (---------------)  + I yazu
	0x002559c6, // n0x125a c0x0000 (---------------)  + I yonago
	0x002c0b05, // n0x125b c0x0000 (---------------)  + I asahi
	0x002be405, // n0x125c c0x0000 (---------------)  + I fuchu
	0x0027ed09, // n0x125d c0x0000 (---------------)  + I fukumitsu
	0x00282ec9, // n0x125e c0x0000 (---------------)  + I funahashi
	0x00223204, // n0x125f c0x0000 (---------------)  + I himi
	0x00223245, // n0x1260 c0x0000 (---------------)  + I imizu
	0x00223445, // n0x1261 c0x0000 (---------------)  + I inami
	0x00353846, // n0x1262 c0x0000 (---------------)  + I johana
	0x002f2888, // n0x1263 c0x0000 (---------------)  + I kamiichi
	0x002b8d46, // n0x1264 c0x0000 (---------------)  + I kurobe
	0x00331b8b, // n0x1265 c0x0000 (---------------)  + I nakaniikawa
	0x0030078a, // n0x1266 c0x0000 (---------------)  + I namerikawa
	0x002fad05, // n0x1267 c0x0000 (---------------)  + I nanto
	0x0028cf46, // n0x1268 c0x0000 (---------------)  + I nyuzen
	0x002f1445, // n0x1269 c0x0000 (---------------)  + I oyabe
	0x002182c5, // n0x126a c0x0000 (---------------)  + I taira
	0x00290647, // n0x126b c0x0000 (---------------)  + I takaoka
	0x00201dc8, // n0x126c c0x0000 (---------------)  + I tateyama
	0x00257f44, // n0x126d c0x0000 (---------------)  + I toga
	0x002da706, // n0x126e c0x0000 (---------------)  + I tonami
	0x002902c6, // n0x126f c0x0000 (---------------)  + I toyama
	0x00214587, // n0x1270 c0x0000 (---------------)  + I unazuki
	0x002ffa44, // n0x1271 c0x0000 (---------------)  + I uozu
	0x0027d386, // n0x1272 c0x0000 (---------------)  + I yamada
	0x0023f3c5, // n0x1273 c0x0000 (---------------)  + I arida
	0x0023f3c9, // n0x1274 c0x0000 (---------------)  + I aridagawa
	0x00212b04, // n0x1275 c0x0000 (---------------)  + I gobo
	0x00285d49, // n0x1276 c0x0000 (---------------)  + I hashimoto
	0x0027a986, // n0x1277 c0x0000 (---------------)  + I hidaka
	0x002bb588, // n0x1278 c0x0000 (---------------)  + I hirogawa
	0x00223445, // n0x1279 c0x0000 (---------------)  + I inami
	0x00288845, // n0x127a c0x0000 (---------------)  + I iwade
	0x00226a86, // n0x127b c0x0000 (---------------)  + I kainan
	0x0026fe89, // n0x127c c0x0000 (---------------)  + I kamitonda
	0x00219889, // n0x127d c0x0000 (---------------)  + I katsuragi
	0x0024e2c6, // n0x127e c0x0000 (---------------)  + I kimino
	0x00250b88, // n0x127f c0x0000 (---------------)  + I kinokawa
	0x0025c008, // n0x1280 c0x0000 (---------------)  + I kitayama
	0x002f1404, // n0x1281 c0x0000 (---------------)  + I koya
	0x0035dc04, // n0x1282 c0x0000 (---------------)  + I koza
	0x0035dc08, // n0x1283 c0x0000 (---------------)  + I kozagawa
	0x00318e08, // n0x1284 c0x0000 (---------------)  + I kudoyama
	0x002b0e09, // n0x1285 c0x0000 (---------------)  + I kushimoto
	0x002a9086, // n0x1286 c0x0000 (---------------)  + I mihama
	0x0022da46, // n0x1287 c0x0000 (---------------)  + I misato
	0x003165cd, // n0x1288 c0x0000 (---------------)  + I nachikatsuura
	0x0022ff06, // n0x1289 c0x0000 (---------------)  + I shingu
	0x002a3889, // n0x128a c0x0000 (---------------)  + I shirahama
	0x00201585, // n0x128b c0x0000 (---------------)  + I taiji
	0x003087c6, // n0x128c c0x0000 (---------------)  + I tanabe
	0x00227348, // n0x128d c0x0000 (---------------)  + I wakayama
	0x00313b45, // n0x128e c0x0000 (---------------)  + I yuasa
	0x002adfc4, // n0x128f c0x0000 (---------------)  + I yura
	0x002c0b05, // n0x1290 c0x0000 (---------------)  + I asahi
	0x00282548, // n0x1291 c0x0000 (---------------)  + I funagata
	0x0029a749, // n0x1292 c0x0000 (---------------)  + I higashine
	0x00277ac4, // n0x1293 c0x0000 (---------------)  + I iide
	0x0034f546, // n0x1294 c0x0000 (---------------)  + I kahoku
	0x0025b60a, // n0x1295 c0x0000 (---------------)  + I kaminoyama
	0x002c91c8, // n0x1296 c0x0000 (---------------)  + I kaneyama
	0x002bb049, // n0x1297 c0x0000 (---------------)  + I kawanishi
	0x0029504a, // n0x1298 c0x0000 (---------------)  + I mamurogawa
	0x002e8406, // n0x1299 c0x0000 (---------------)  + I mikawa
	0x002990c8, // n0x129a c0x0000 (---------------)  + I murayama
	0x00302045, // n0x129b c0x0000 (---------------)  + I nagai
	0x002cb588, // n0x129c c0x0000 (---------------)  + I nakayama
	0x002b3a45, // n0x129d c0x0000 (---------------)  + I nanyo
	0x0021b289, // n0x129e c0x0000 (---------------)  + I nishikawa
	0x00361e49, // n0x129f c0x0000 (---------------)  + I obanazawa
	0x00202d82, // n0x12a0 c0x0000 (---------------)  + I oe
	0x002a7bc5, // n0x12a1 c0x0000 (---------------)  + I oguni
	0x00270cc6, // n0x12a2 c0x0000 (---------------)  + I ohkura
	0x0027a8c7, // n0x12a3 c0x0000 (---------------)  + I oishida
	0x00378a85, // n0x12a4 c0x0000 (---------------)  + I sagae
	0x002f7386, // n0x12a5 c0x0000 (---------------)  + I sakata
	0x00313c08, // n0x12a6 c0x0000 (---------------)  + I sakegawa
	0x0027b106, // n0x12a7 c0x0000 (---------------)  + I shinjo
	0x002cfd49, // n0x12a8 c0x0000 (---------------)  + I shirataka
	0x002790c6, // n0x12a9 c0x0000 (---------------)  + I shonai
	0x002826c8, // n0x12aa c0x0000 (---------------)  + I takahata
	0x002aa345, // n0x12ab c0x0000 (---------------)  + I tendo
	0x0026f486, // n0x12ac c0x0000 (---------------)  + I tozawa
	0x003542c8, // n0x12ad c0x0000 (---------------)  + I tsuruoka
	0x002815c8, // n0x12ae c0x0000 (---------------)  + I yamagata
	0x003a3a08, // n0x12af c0x0000 (---------------)  + I yamanobe
	0x00366b88, // n0x12b0 c0x0000 (---------------)  + I yonezawa
	0x00216dc4, // n0x12b1 c0x0000 (---------------)  + I yuza
	0x0022e983, // n0x12b2 c0x0000 (---------------)  + I abu
	0x002cff84, // n0x12b3 c0x0000 (---------------)  + I hagi
	0x0022d5c6, // n0x12b4 c0x0000 (---------------)  + I hikari
	0x002d9784, // n0x12b5 c0x0000 (---------------)  + I hofu
	0x002a8e47, // n0x12b6 c0x0000 (---------------)  + I iwakuni
	0x00399149, // n0x12b7 c0x0000 (---------------)  + I kudamatsu
	0x002c1b05, // n0x12b8 c0x0000 (---------------)  + I mitou
	0x0038d206, // n0x12b9 c0x0000 (---------------)  + I nagato
	0x00209f06, // n0x12ba c0x0000 (---------------)  + I oshima
	0x00261ccb, // n0x12bb c0x0000 (---------------)  + I shimonoseki
	0x002fac46, // n0x12bc c0x0000 (---------------)  + I shunan
	0x00319106, // n0x12bd c0x0000 (---------------)  + I tabuse
	0x0022db48, // n0x12be c0x0000 (---------------)  + I tokuyama
	0x00264186, // n0x12bf c0x0000 (---------------)  + I toyota
	0x0028f383, // n0x12c0 c0x0000 (---------------)  + I ube
	0x0020d243, // n0x12c1 c0x0000 (---------------)  + I yuu
	0x0032c104, // n0x12c2 c0x0000 (---------------)  + I chuo
	0x00236985, // n0x12c3 c0x0000 (---------------)  + I doshi
	0x002ae147, // n0x12c4 c0x0000 (---------------)  + I fuefuki
	0x00277c48, // n0x12c5 c0x0000 (---------------)  + I fujikawa
	0x00277c4f, // n0x12c6 c0x0000 (---------------)  + I fujikawaguchiko
	0x0027c78b, // n0x12c7 c0x0000 (---------------)  + I fujiyoshida
	0x002f2688, // n0x12c8 c0x0000 (---------------)  + I hayakawa
	0x0034f5c6, // n0x12c9 c0x0000 (---------------)  + I hokuto
	0x0026380e, // n0x12ca c0x0000 (---------------)  + I ichikawamisato
	0x00226a83, // n0x12cb c0x0000 (---------------)  + I kai
	0x0023fec4, // n0x12cc c0x0000 (---------------)  + I kofu
	0x002fabc5, // n0x12cd c0x0000 (---------------)  + I koshu
	0x00348146, // n0x12ce c0x0000 (---------------)  + I kosuge
	0x0028e30b, // n0x12cf c0x0000 (---------------)  + I minami-alps
	0x00291986, // n0x12d0 c0x0000 (---------------)  + I minobu
	0x00216049, // n0x12d1 c0x0000 (---------------)  + I nakamichi
	0x002e6845, // n0x12d2 c0x0000 (---------------)  + I nanbu
	0x0037fd08, // n0x12d3 c0x0000 (---------------)  + I narusawa
	0x0020d5c8, // n0x12d4 c0x0000 (---------------)  + I nirasaki
	0x0021974c, // n0x12d5 c0x0000 (---------------)  + I nishikatsura
	0x0029fd46, // n0x12d6 c0x0000 (---------------)  + I oshino
	0x0021d106, // n0x12d7 c0x0000 (---------------)  + I otsuki
	0x002b2f45, // n0x12d8 c0x0000 (---------------)  + I showa
	0x00289988, // n0x12d9 c0x0000 (---------------)  + I tabayama
	0x0027bec5, // n0x12da c0x0000 (---------------)  + I tsuru
	0x00385888, // n0x12db c0x0000 (---------------)  + I uenohara
	0x0029f40a, // n0x12dc c0x0000 (---------------)  + I yamanakako
	0x002a2d49, // n0x12dd c0x0000 (---------------)  + I yamanashi
	0x00685804, // n0x12de c0x0001 (---------------)  ! I city
	0x2d60ce42, // n0x12df c0x00b5 (n0x12e0-n0x12e1)  o I co
	0x000fe108, // n0x12e0 c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x12e1 c0x0000 (---------------)  + I com
	0x00239103, // n0x12e2 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x12e3 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x12e4 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x12e5 c0x0000 (---------------)  + I net
	0x00228743, // n0x12e6 c0x0000 (---------------)  + I org
	0x00331a83, // n0x12e7 c0x0000 (---------------)  + I biz
	0x00233243, // n0x12e8 c0x0000 (---------------)  + I com
	0x00239103, // n0x12e9 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x12ea c0x0000 (---------------)  + I gov
	0x00201844, // n0x12eb c0x0000 (---------------)  + I info
	0x00223b43, // n0x12ec c0x0000 (---------------)  + I net
	0x00228743, // n0x12ed c0x0000 (---------------)  + I org
	0x00233c03, // n0x12ee c0x0000 (---------------)  + I ass
	0x002d5e84, // n0x12ef c0x0000 (---------------)  + I asso
	0x00233243, // n0x12f0 c0x0000 (---------------)  + I com
	0x0023c344, // n0x12f1 c0x0000 (---------------)  + I coop
	0x00239103, // n0x12f2 c0x0000 (---------------)  + I edu
	0x002aebc4, // n0x12f3 c0x0000 (---------------)  + I gouv
	0x0027d903, // n0x12f4 c0x0000 (---------------)  + I gov
	0x00378d47, // n0x12f5 c0x0000 (---------------)  + I medecin
	0x00207dc3, // n0x12f6 c0x0000 (---------------)  + I mil
	0x00201383, // n0x12f7 c0x0000 (---------------)  + I nom
	0x0035f0c8, // n0x12f8 c0x0000 (---------------)  + I notaires
	0x00228743, // n0x12f9 c0x0000 (---------------)  + I org
	0x0034af0b, // n0x12fa c0x0000 (---------------)  + I pharmaciens
	0x002e0bc3, // n0x12fb c0x0000 (---------------)  + I prd
	0x00246a06, // n0x12fc c0x0000 (---------------)  + I presse
	0x00200c82, // n0x12fd c0x0000 (---------------)  + I tm
	0x002d32cb, // n0x12fe c0x0000 (---------------)  + I veterinaire
	0x00239103, // n0x12ff c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1300 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x1301 c0x0000 (---------------)  + I net
	0x00228743, // n0x1302 c0x0000 (---------------)  + I org
	0x00233243, // n0x1303 c0x0000 (---------------)  + I com
	0x00239103, // n0x1304 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1305 c0x0000 (---------------)  + I gov
	0x00228743, // n0x1306 c0x0000 (---------------)  + I org
	0x0022ed83, // n0x1307 c0x0000 (---------------)  + I rep
	0x00203903, // n0x1308 c0x0000 (---------------)  + I tra
	0x00200342, // n0x1309 c0x0000 (---------------)  + I ac
	0x000fe108, // n0x130a c0x0000 (---------------)  +   blogspot
	0x002b7ac5, // n0x130b c0x0000 (---------------)  + I busan
	0x003147c8, // n0x130c c0x0000 (---------------)  + I chungbuk
	0x0032a848, // n0x130d c0x0000 (---------------)  + I chungnam
	0x0020ce42, // n0x130e c0x0000 (---------------)  + I co
	0x00255dc5, // n0x130f c0x0000 (---------------)  + I daegu
	0x003246c7, // n0x1310 c0x0000 (---------------)  + I daejeon
	0x00200082, // n0x1311 c0x0000 (---------------)  + I es
	0x00216287, // n0x1312 c0x0000 (---------------)  + I gangwon
	0x00210a42, // n0x1313 c0x0000 (---------------)  + I go
	0x00234607, // n0x1314 c0x0000 (---------------)  + I gwangju
	0x0030d549, // n0x1315 c0x0000 (---------------)  + I gyeongbuk
	0x00301c08, // n0x1316 c0x0000 (---------------)  + I gyeonggi
	0x00206fc9, // n0x1317 c0x0000 (---------------)  + I gyeongnam
	0x00233842, // n0x1318 c0x0000 (---------------)  + I hs
	0x00267b47, // n0x1319 c0x0000 (---------------)  + I incheon
	0x0024e044, // n0x131a c0x0000 (---------------)  + I jeju
	0x00324787, // n0x131b c0x0000 (---------------)  + I jeonbuk
	0x00300687, // n0x131c c0x0000 (---------------)  + I jeonnam
	0x002b7202, // n0x131d c0x0000 (---------------)  + I kg
	0x00207dc3, // n0x131e c0x0000 (---------------)  + I mil
	0x00210f42, // n0x131f c0x0000 (---------------)  + I ms
	0x00202ac2, // n0x1320 c0x0000 (---------------)  + I ne
	0x00200dc2, // n0x1321 c0x0000 (---------------)  + I or
	0x00200582, // n0x1322 c0x0000 (---------------)  + I pe
	0x00208c82, // n0x1323 c0x0000 (---------------)  + I re
	0x00207f02, // n0x1324 c0x0000 (---------------)  + I sc
	0x00343d45, // n0x1325 c0x0000 (---------------)  + I seoul
	0x00253b45, // n0x1326 c0x0000 (---------------)  + I ulsan
	0x00233243, // n0x1327 c0x0000 (---------------)  + I com
	0x00239103, // n0x1328 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1329 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x132a c0x0000 (---------------)  + I net
	0x00228743, // n0x132b c0x0000 (---------------)  + I org
	0x00233243, // n0x132c c0x0000 (---------------)  + I com
	0x00239103, // n0x132d c0x0000 (---------------)  + I edu
	0x0027d903, // n0x132e c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x132f c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1330 c0x0000 (---------------)  + I net
	0x00228743, // n0x1331 c0x0000 (---------------)  + I org
	0x00000141, // n0x1332 c0x0000 (---------------)  +   c
	0x00233243, // n0x1333 c0x0000 (---------------)  + I com
	0x00239103, // n0x1334 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1335 c0x0000 (---------------)  + I gov
	0x00201844, // n0x1336 c0x0000 (---------------)  + I info
	0x00201503, // n0x1337 c0x0000 (---------------)  + I int
	0x00223b43, // n0x1338 c0x0000 (---------------)  + I net
	0x00228743, // n0x1339 c0x0000 (---------------)  + I org
	0x0021e783, // n0x133a c0x0000 (---------------)  + I per
	0x00233243, // n0x133b c0x0000 (---------------)  + I com
	0x00239103, // n0x133c c0x0000 (---------------)  + I edu
	0x0027d903, // n0x133d c0x0000 (---------------)  + I gov
	0x00223b43, // n0x133e c0x0000 (---------------)  + I net
	0x00228743, // n0x133f c0x0000 (---------------)  + I org
	0x0020ce42, // n0x1340 c0x0000 (---------------)  + I co
	0x00233243, // n0x1341 c0x0000 (---------------)  + I com
	0x00239103, // n0x1342 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1343 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x1344 c0x0000 (---------------)  + I net
	0x00228743, // n0x1345 c0x0000 (---------------)  + I org
	0x000fe108, // n0x1346 c0x0000 (---------------)  +   blogspot
	0x00200342, // n0x1347 c0x0000 (---------------)  + I ac
	0x002bccc4, // n0x1348 c0x0000 (---------------)  + I assn
	0x00233243, // n0x1349 c0x0000 (---------------)  + I com
	0x00239103, // n0x134a c0x0000 (---------------)  + I edu
	0x0027d903, // n0x134b c0x0000 (---------------)  + I gov
	0x00305e43, // n0x134c c0x0000 (---------------)  + I grp
	0x00234305, // n0x134d c0x0000 (---------------)  + I hotel
	0x00201503, // n0x134e c0x0000 (---------------)  + I int
	0x00312883, // n0x134f c0x0000 (---------------)  + I ltd
	0x00223b43, // n0x1350 c0x0000 (---------------)  + I net
	0x0023b383, // n0x1351 c0x0000 (---------------)  + I ngo
	0x00228743, // n0x1352 c0x0000 (---------------)  + I org
	0x00217283, // n0x1353 c0x0000 (---------------)  + I sch
	0x00274603, // n0x1354 c0x0000 (---------------)  + I soc
	0x0021e243, // n0x1355 c0x0000 (---------------)  + I web
	0x00233243, // n0x1356 c0x0000 (---------------)  + I com
	0x00239103, // n0x1357 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1358 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x1359 c0x0000 (---------------)  + I net
	0x00228743, // n0x135a c0x0000 (---------------)  + I org
	0x0020ce42, // n0x135b c0x0000 (---------------)  + I co
	0x00228743, // n0x135c c0x0000 (---------------)  + I org
	0x000fe108, // n0x135d c0x0000 (---------------)  +   blogspot
	0x0027d903, // n0x135e c0x0000 (---------------)  + I gov
	0x000fe108, // n0x135f c0x0000 (---------------)  +   blogspot
	0x0022b643, // n0x1360 c0x0000 (---------------)  + I asn
	0x00233243, // n0x1361 c0x0000 (---------------)  + I com
	0x00237344, // n0x1362 c0x0000 (---------------)  + I conf
	0x00239103, // n0x1363 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1364 c0x0000 (---------------)  + I gov
	0x0020d9c2, // n0x1365 c0x0000 (---------------)  + I id
	0x00207dc3, // n0x1366 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1367 c0x0000 (---------------)  + I net
	0x00228743, // n0x1368 c0x0000 (---------------)  + I org
	0x00233243, // n0x1369 c0x0000 (---------------)  + I com
	0x00239103, // n0x136a c0x0000 (---------------)  + I edu
	0x0027d903, // n0x136b c0x0000 (---------------)  + I gov
	0x0020d9c2, // n0x136c c0x0000 (---------------)  + I id
	0x00213443, // n0x136d c0x0000 (---------------)  + I med
	0x00223b43, // n0x136e c0x0000 (---------------)  + I net
	0x00228743, // n0x136f c0x0000 (---------------)  + I org
	0x002d96c3, // n0x1370 c0x0000 (---------------)  + I plc
	0x00217283, // n0x1371 c0x0000 (---------------)  + I sch
	0x00200342, // n0x1372 c0x0000 (---------------)  + I ac
	0x0020ce42, // n0x1373 c0x0000 (---------------)  + I co
	0x0027d903, // n0x1374 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x1375 c0x0000 (---------------)  + I net
	0x00228743, // n0x1376 c0x0000 (---------------)  + I org
	0x00246a05, // n0x1377 c0x0000 (---------------)  + I press
	0x002d5e84, // n0x1378 c0x0000 (---------------)  + I asso
	0x00200c82, // n0x1379 c0x0000 (---------------)  + I tm
	0x000fe108, // n0x137a c0x0000 (---------------)  +   blogspot
	0x00200342, // n0x137b c0x0000 (---------------)  + I ac
	0x0020ce42, // n0x137c c0x0000 (---------------)  + I co
	0x0005528b, // n0x137d c0x0000 (---------------)  +   diskstation
	0x00007ec7, // n0x137e c0x0000 (---------------)  +   dscloud
	0x00239103, // n0x137f c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1380 c0x0000 (---------------)  + I gov
	0x00049fc4, // n0x1381 c0x0000 (---------------)  +   i234
	0x00235383, // n0x1382 c0x0000 (---------------)  + I its
	0x00049004, // n0x1383 c0x0000 (---------------)  +   myds
	0x00223b43, // n0x1384 c0x0000 (---------------)  + I net
	0x00228743, // n0x1385 c0x0000 (---------------)  + I org
	0x002e17c4, // n0x1386 c0x0000 (---------------)  + I priv
	0x0010d3c8, // n0x1387 c0x0000 (---------------)  +   synology
	0x0020ce42, // n0x1388 c0x0000 (---------------)  + I co
	0x00233243, // n0x1389 c0x0000 (---------------)  + I com
	0x00239103, // n0x138a c0x0000 (---------------)  + I edu
	0x0027d903, // n0x138b c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x138c c0x0000 (---------------)  + I mil
	0x00201383, // n0x138d c0x0000 (---------------)  + I nom
	0x00228743, // n0x138e c0x0000 (---------------)  + I org
	0x002e0bc3, // n0x138f c0x0000 (---------------)  + I prd
	0x00200c82, // n0x1390 c0x0000 (---------------)  + I tm
	0x000fe108, // n0x1391 c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x1392 c0x0000 (---------------)  + I com
	0x00239103, // n0x1393 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1394 c0x0000 (---------------)  + I gov
	0x00201683, // n0x1395 c0x0000 (---------------)  + I inf
	0x00200904, // n0x1396 c0x0000 (---------------)  + I name
	0x00223b43, // n0x1397 c0x0000 (---------------)  + I net
	0x00228743, // n0x1398 c0x0000 (---------------)  + I org
	0x00233243, // n0x1399 c0x0000 (---------------)  + I com
	0x00239103, // n0x139a c0x0000 (---------------)  + I edu
	0x002aebc4, // n0x139b c0x0000 (---------------)  + I gouv
	0x0027d903, // n0x139c c0x0000 (---------------)  + I gov
	0x00223b43, // n0x139d c0x0000 (---------------)  + I net
	0x00228743, // n0x139e c0x0000 (---------------)  + I org
	0x00246a06, // n0x139f c0x0000 (---------------)  + I presse
	0x00239103, // n0x13a0 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x13a1 c0x0000 (---------------)  + I gov
	0x0016dcc3, // n0x13a2 c0x0000 (---------------)  +   nyc
	0x00228743, // n0x13a3 c0x0000 (---------------)  + I org
	0x00233243, // n0x13a4 c0x0000 (---------------)  + I com
	0x00239103, // n0x13a5 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x13a6 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x13a7 c0x0000 (---------------)  + I net
	0x00228743, // n0x13a8 c0x0000 (---------------)  + I org
	0x00007ec7, // n0x13a9 c0x0000 (---------------)  +   dscloud
	0x000fe108, // n0x13aa c0x0000 (---------------)  +   blogspot
	0x0027d903, // n0x13ab c0x0000 (---------------)  + I gov
	0x00233243, // n0x13ac c0x0000 (---------------)  + I com
	0x00239103, // n0x13ad c0x0000 (---------------)  + I edu
	0x0027d903, // n0x13ae c0x0000 (---------------)  + I gov
	0x00223b43, // n0x13af c0x0000 (---------------)  + I net
	0x00228743, // n0x13b0 c0x0000 (---------------)  + I org
	0x35a33243, // n0x13b1 c0x00d6 (n0x13b5-n0x13b6)  + I com
	0x00239103, // n0x13b2 c0x0000 (---------------)  + I edu
	0x00223b43, // n0x13b3 c0x0000 (---------------)  + I net
	0x00228743, // n0x13b4 c0x0000 (---------------)  + I org
	0x000fe108, // n0x13b5 c0x0000 (---------------)  +   blogspot
	0x00200342, // n0x13b6 c0x0000 (---------------)  + I ac
	0x0020ce42, // n0x13b7 c0x0000 (---------------)  + I co
	0x00233243, // n0x13b8 c0x0000 (---------------)  + I com
	0x0027d903, // n0x13b9 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x13ba c0x0000 (---------------)  + I net
	0x00200dc2, // n0x13bb c0x0000 (---------------)  + I or
	0x00228743, // n0x13bc c0x0000 (---------------)  + I org
	0x0030cf07, // n0x13bd c0x0000 (---------------)  + I academy
	0x00208a4b, // n0x13be c0x0000 (---------------)  + I agriculture
	0x00205103, // n0x13bf c0x0000 (---------------)  + I air
	0x00239b48, // n0x13c0 c0x0000 (---------------)  + I airguard
	0x003276c7, // n0x13c1 c0x0000 (---------------)  + I alabama
	0x002799c6, // n0x13c2 c0x0000 (---------------)  + I alaska
	0x00367785, // n0x13c3 c0x0000 (---------------)  + I amber
	0x002c06c9, // n0x13c4 c0x0000 (---------------)  + I ambulance
	0x00207b48, // n0x13c5 c0x0000 (---------------)  + I american
	0x002f53c9, // n0x13c6 c0x0000 (---------------)  + I americana
	0x002f53d0, // n0x13c7 c0x0000 (---------------)  + I americanantiques
	0x003580cb, // n0x13c8 c0x0000 (---------------)  + I americanart
	0x002c0509, // n0x13c9 c0x0000 (---------------)  + I amsterdam
	0x00206ac3, // n0x13ca c0x0000 (---------------)  + I and
	0x00249989, // n0x13cb c0x0000 (---------------)  + I annefrank
	0x00238006, // n0x13cc c0x0000 (---------------)  + I anthro
	0x0023800c, // n0x13cd c0x0000 (---------------)  + I anthropology
	0x002b7b88, // n0x13ce c0x0000 (---------------)  + I antiques
	0x003a0c48, // n0x13cf c0x0000 (---------------)  + I aquarium
	0x002518c9, // n0x13d0 c0x0000 (---------------)  + I arboretum
	0x002a128e, // n0x13d1 c0x0000 (---------------)  + I archaeological
	0x0037080b, // n0x13d2 c0x0000 (---------------)  + I archaeology
	0x00308e4c, // n0x13d3 c0x0000 (---------------)  + I architecture
	0x00201d43, // n0x13d4 c0x0000 (---------------)  + I art
	0x0038298c, // n0x13d5 c0x0000 (---------------)  + I artanddesign
	0x00204bc9, // n0x13d6 c0x0000 (---------------)  + I artcenter
	0x0020cd07, // n0x13d7 c0x0000 (---------------)  + I artdeco
	0x0023904c, // n0x13d8 c0x0000 (---------------)  + I arteducation
	0x0039164a, // n0x13d9 c0x0000 (---------------)  + I artgallery
	0x0024b944, // n0x13da c0x0000 (---------------)  + I arts
	0x003a3ccd, // n0x13db c0x0000 (---------------)  + I artsandcrafts
	0x00382848, // n0x13dc c0x0000 (---------------)  + I asmatart
	0x0039838d, // n0x13dd c0x0000 (---------------)  + I assassination
	0x00337106, // n0x13de c0x0000 (---------------)  + I assisi
	0x002d5e8b, // n0x13df c0x0000 (---------------)  + I association
	0x00248e49, // n0x13e0 c0x0000 (---------------)  + I astronomy
	0x00227d47, // n0x13e1 c0x0000 (---------------)  + I atlanta
	0x002dc946, // n0x13e2 c0x0000 (---------------)  + I austin
	0x0030af49, // n0x13e3 c0x0000 (---------------)  + I australia
	0x0032364a, // n0x13e4 c0x0000 (---------------)  + I automotive
	0x00359fc8, // n0x13e5 c0x0000 (---------------)  + I aviation
	0x002e0584, // n0x13e6 c0x0000 (---------------)  + I axis
	0x00276e07, // n0x13e7 c0x0000 (---------------)  + I badajoz
	0x002a2fc7, // n0x13e8 c0x0000 (---------------)  + I baghdad
	0x002f5184, // n0x13e9 c0x0000 (---------------)  + I bahn
	0x0022a484, // n0x13ea c0x0000 (---------------)  + I bale
	0x0025ce49, // n0x13eb c0x0000 (---------------)  + I baltimore
	0x002e3209, // n0x13ec c0x0000 (---------------)  + I barcelona
	0x0022df88, // n0x13ed c0x0000 (---------------)  + I baseball
	0x00212305, // n0x13ee c0x0000 (---------------)  + I basel
	0x003878c5, // n0x13ef c0x0000 (---------------)  + I baths
	0x0020e4c6, // n0x13f0 c0x0000 (---------------)  + I bauern
	0x003a3b89, // n0x13f1 c0x0000 (---------------)  + I beauxarts
	0x002187cd, // n0x13f2 c0x0000 (---------------)  + I beeldengeluid
	0x003088c8, // n0x13f3 c0x0000 (---------------)  + I bellevue
	0x0020e3c7, // n0x13f4 c0x0000 (---------------)  + I bergbau
	0x00367808, // n0x13f5 c0x0000 (---------------)  + I berkeley
	0x0022fc06, // n0x13f6 c0x0000 (---------------)  + I berlin
	0x0038fc84, // n0x13f7 c0x0000 (---------------)  + I bern
	0x00356b45, // n0x13f8 c0x0000 (---------------)  + I bible
	0x00202786, // n0x13f9 c0x0000 (---------------)  + I bilbao
	0x00203784, // n0x13fa c0x0000 (---------------)  + I bill
	0x00204ac7, // n0x13fb c0x0000 (---------------)  + I birdart
	0x0020b1ca, // n0x13fc c0x0000 (---------------)  + I birthplace
	0x00214304, // n0x13fd c0x0000 (---------------)  + I bonn
	0x00218f86, // n0x13fe c0x0000 (---------------)  + I boston
	0x0021b749, // n0x13ff c0x0000 (---------------)  + I botanical
	0x0021b74f, // n0x1400 c0x0000 (---------------)  + I botanicalgarden
	0x0021bd0d, // n0x1401 c0x0000 (---------------)  + I botanicgarden
	0x0021c486, // n0x1402 c0x0000 (---------------)  + I botany
	0x00220950, // n0x1403 c0x0000 (---------------)  + I brandywinevalley
	0x00220d46, // n0x1404 c0x0000 (---------------)  + I brasil
	0x00221e07, // n0x1405 c0x0000 (---------------)  + I bristol
	0x00222187, // n0x1406 c0x0000 (---------------)  + I british
	0x0022218f, // n0x1407 c0x0000 (---------------)  + I britishcolumbia
	0x00223789, // n0x1408 c0x0000 (---------------)  + I broadcast
	0x00226386, // n0x1409 c0x0000 (---------------)  + I brunel
	0x00228407, // n0x140a c0x0000 (---------------)  + I brussel
	0x00228408, // n0x140b c0x0000 (---------------)  + I brussels
	0x00228909, // n0x140c c0x0000 (---------------)  + I bruxelles
	0x00291688, // n0x140d c0x0000 (---------------)  + I building
	0x002d7947, // n0x140e c0x0000 (---------------)  + I burghof
	0x0020dc43, // n0x140f c0x0000 (---------------)  + I bus
	0x002330c6, // n0x1410 c0x0000 (---------------)  + I bushey
	0x00200e48, // n0x1411 c0x0000 (---------------)  + I cadaques
	0x002a154a, // n0x1412 c0x0000 (---------------)  + I california
	0x0021e309, // n0x1413 c0x0000 (---------------)  + I cambridge
	0x00207c83, // n0x1414 c0x0000 (---------------)  + I can
	0x003245c6, // n0x1415 c0x0000 (---------------)  + I canada
	0x002da54a, // n0x1416 c0x0000 (---------------)  + I capebreton
	0x00365a87, // n0x1417 c0x0000 (---------------)  + I carrier
	0x0020cb4a, // n0x1418 c0x0000 (---------------)  + I cartoonart
	0x0021500e, // n0x1419 c0x0000 (---------------)  + I casadelamoneda
	0x002238c6, // n0x141a c0x0000 (---------------)  + I castle
	0x002a7dc7, // n0x141b c0x0000 (---------------)  + I castres
	0x002106c6, // n0x141c c0x0000 (---------------)  + I celtic
	0x00204c86, // n0x141d c0x0000 (---------------)  + I center
	0x0037304b, // n0x141e c0x0000 (---------------)  + I chattanooga
	0x0026478a, // n0x141f c0x0000 (---------------)  + I cheltenham
	0x0037b6cd, // n0x1420 c0x0000 (---------------)  + I chesapeakebay
	0x002129c7, // n0x1421 c0x0000 (---------------)  + I chicago
	0x00274688, // n0x1422 c0x0000 (---------------)  + I children
	0x00274689, // n0x1423 c0x0000 (---------------)  + I childrens
	0x0027468f, // n0x1424 c0x0000 (---------------)  + I childrensgarden
	0x003799cc, // n0x1425 c0x0000 (---------------)  + I chiropractic
	0x002b8789, // n0x1426 c0x0000 (---------------)  + I chocolate
	0x003149ce, // n0x1427 c0x0000 (---------------)  + I christiansburg
	0x00378e4a, // n0x1428 c0x0000 (---------------)  + I cincinnati
	0x003028c6, // n0x1429 c0x0000 (---------------)  + I cinema
	0x0033d286, // n0x142a c0x0000 (---------------)  + I circus
	0x0036430c, // n0x142b c0x0000 (---------------)  + I civilisation
	0x00367ccc, // n0x142c c0x0000 (---------------)  + I civilization
	0x0036dd48, // n0x142d c0x0000 (---------------)  + I civilwar
	0x00387a47, // n0x142e c0x0000 (---------------)  + I clinton
	0x002b0885, // n0x142f c0x0000 (---------------)  + I clock
	0x003524c4, // n0x1430 c0x0000 (---------------)  + I coal
	0x0038510e, // n0x1431 c0x0000 (---------------)  + I coastaldefence
	0x003238c4, // n0x1432 c0x0000 (---------------)  + I cody
	0x00231a07, // n0x1433 c0x0000 (---------------)  + I coldwar
	0x00263d8a, // n0x1434 c0x0000 (---------------)  + I collection
	0x00232414, // n0x1435 c0x0000 (---------------)  + I colonialwilliamsburg
	0x00232b0f, // n0x1436 c0x0000 (---------------)  + I coloradoplateau
	0x00222348, // n0x1437 c0x0000 (---------------)  + I columbia
	0x00232f88, // n0x1438 c0x0000 (---------------)  + I columbus
	0x0036078d, // n0x1439 c0x0000 (---------------)  + I communication
	0x0036078e, // n0x143a c0x0000 (---------------)  + I communications
	0x00233249, // n0x143b c0x0000 (---------------)  + I community
	0x00235b08, // n0x143c c0x0000 (---------------)  + I computer
	0x00235b0f, // n0x143d c0x0000 (---------------)  + I computerhistory
	0x00238d4c, // n0x143e c0x0000 (---------------)  + I contemporary
	0x00238d4f, // n0x143f c0x0000 (---------------)  + I contemporaryart
	0x0023a0c7, // n0x1440 c0x0000 (---------------)  + I convent
	0x0023caca, // n0x1441 c0x0000 (---------------)  + I copenhagen
	0x0021eccb, // n0x1442 c0x0000 (---------------)  + I corporation
	0x002405c8, // n0x1443 c0x0000 (---------------)  + I corvette
	0x00241907, // n0x1444 c0x0000 (---------------)  + I costume
	0x0033798d, // n0x1445 c0x0000 (---------------)  + I countryestate
	0x00321346, // n0x1446 c0x0000 (---------------)  + I county
	0x003a3e86, // n0x1447 c0x0000 (---------------)  + I crafts
	0x00242f89, // n0x1448 c0x0000 (---------------)  + I cranbrook
	0x0031d9c8, // n0x1449 c0x0000 (---------------)  + I creation
	0x00246d88, // n0x144a c0x0000 (---------------)  + I cultural
	0x00246d8e, // n0x144b c0x0000 (---------------)  + I culturalcenter
	0x00208b47, // n0x144c c0x0000 (---------------)  + I culture
	0x00311f05, // n0x144d c0x0000 (---------------)  + I cyber
	0x0024a0c5, // n0x144e c0x0000 (---------------)  + I cymru
	0x00211bc4, // n0x144f c0x0000 (---------------)  + I dali
	0x00279c86, // n0x1450 c0x0000 (---------------)  + I dallas
	0x0022de88, // n0x1451 c0x0000 (---------------)  + I database
	0x00329483, // n0x1452 c0x0000 (---------------)  + I ddr
	0x0025df8e, // n0x1453 c0x0000 (---------------)  + I decorativearts
	0x00337d48, // n0x1454 c0x0000 (---------------)  + I delaware
	0x0027ad0b, // n0x1455 c0x0000 (---------------)  + I delmenhorst
	0x0022b807, // n0x1456 c0x0000 (---------------)  + I denmark
	0x00273e05, // n0x1457 c0x0000 (---------------)  + I depot
	0x00228206, // n0x1458 c0x0000 (---------------)  + I design
	0x002ab607, // n0x1459 c0x0000 (---------------)  + I detroit
	0x002f9d88, // n0x145a c0x0000 (---------------)  + I dinosaur
	0x00331309, // n0x145b c0x0000 (---------------)  + I discovery
	0x00237a85, // n0x145c c0x0000 (---------------)  + I dolls
	0x00287848, // n0x145d c0x0000 (---------------)  + I donostia
	0x00205946, // n0x145e c0x0000 (---------------)  + I durham
	0x00374bca, // n0x145f c0x0000 (---------------)  + I eastafrica
	0x00385009, // n0x1460 c0x0000 (---------------)  + I eastcoast
	0x00239109, // n0x1461 c0x0000 (---------------)  + I education
	0x0023910b, // n0x1462 c0x0000 (---------------)  + I educational
	0x0033c448, // n0x1463 c0x0000 (---------------)  + I egyptian
	0x002f5049, // n0x1464 c0x0000 (---------------)  + I eisenbahn
	0x002123c6, // n0x1465 c0x0000 (---------------)  + I elburg
	0x002e5cca, // n0x1466 c0x0000 (---------------)  + I elvendrell
	0x0022aa0a, // n0x1467 c0x0000 (---------------)  + I embroidery
	0x0023cccc, // n0x1468 c0x0000 (---------------)  + I encyclopedic
	0x00213087, // n0x1469 c0x0000 (---------------)  + I england
	0x00301a0a, // n0x146a c0x0000 (---------------)  + I entomology
	0x003307cb, // n0x146b c0x0000 (---------------)  + I environment
	0x003307d9, // n0x146c c0x0000 (---------------)  + I environmentalconservation
	0x00335a88, // n0x146d c0x0000 (---------------)  + I epilepsy
	0x00246a85, // n0x146e c0x0000 (---------------)  + I essex
	0x002c4206, // n0x146f c0x0000 (---------------)  + I estate
	0x0030edc9, // n0x1470 c0x0000 (---------------)  + I ethnology
	0x002009c6, // n0x1471 c0x0000 (---------------)  + I exeter
	0x0021014a, // n0x1472 c0x0000 (---------------)  + I exhibition
	0x00207d46, // n0x1473 c0x0000 (---------------)  + I family
	0x0026a084, // n0x1474 c0x0000 (---------------)  + I farm
	0x002c438d, // n0x1475 c0x0000 (---------------)  + I farmequipment
	0x00327f47, // n0x1476 c0x0000 (---------------)  + I farmers
	0x0026a089, // n0x1477 c0x0000 (---------------)  + I farmstead
	0x003663c5, // n0x1478 c0x0000 (---------------)  + I field
	0x00366788, // n0x1479 c0x0000 (---------------)  + I figueres
	0x0037a689, // n0x147a c0x0000 (---------------)  + I filatelia
	0x0024b184, // n0x147b c0x0000 (---------------)  + I film
	0x0024b847, // n0x147c c0x0000 (---------------)  + I fineart
	0x0024b848, // n0x147d c0x0000 (---------------)  + I finearts
	0x0024c247, // n0x147e c0x0000 (---------------)  + I finland
	0x002659c8, // n0x147f c0x0000 (---------------)  + I flanders
	0x00252907, // n0x1480 c0x0000 (---------------)  + I florida
	0x00338685, // n0x1481 c0x0000 (---------------)  + I force
	0x00259d4c, // n0x1482 c0x0000 (---------------)  + I fortmissoula
	0x0025a909, // n0x1483 c0x0000 (---------------)  + I fortworth
	0x002b9f8a, // n0x1484 c0x0000 (---------------)  + I foundation
	0x00384289, // n0x1485 c0x0000 (---------------)  + I francaise
	0x00249a89, // n0x1486 c0x0000 (---------------)  + I frankfurt
	0x0024ba4c, // n0x1487 c0x0000 (---------------)  + I franziskaner
	0x002e808b, // n0x1488 c0x0000 (---------------)  + I freemasonry
	0x0025c888, // n0x1489 c0x0000 (---------------)  + I freiburg
	0x0025e788, // n0x148a c0x0000 (---------------)  + I fribourg
	0x00261b44, // n0x148b c0x0000 (---------------)  + I frog
	0x00283e08, // n0x148c c0x0000 (---------------)  + I fundacio
	0x00284dc9, // n0x148d c0x0000 (---------------)  + I furniture
	0x00391707, // n0x148e c0x0000 (---------------)  + I gallery
	0x0021b986, // n0x148f c0x0000 (---------------)  + I garden
	0x00245307, // n0x1490 c0x0000 (---------------)  + I gateway
	0x00331589, // n0x1491 c0x0000 (---------------)  + I geelvinck
	0x00212ccb, // n0x1492 c0x0000 (---------------)  + I gemological
	0x00395947, // n0x1493 c0x0000 (---------------)  + I geology
	0x003234c7, // n0x1494 c0x0000 (---------------)  + I georgia
	0x00279707, // n0x1495 c0x0000 (---------------)  + I giessen
	0x00398304, // n0x1496 c0x0000 (---------------)  + I glas
	0x00398305, // n0x1497 c0x0000 (---------------)  + I glass
	0x002a9585, // n0x1498 c0x0000 (---------------)  + I gorge
	0x0033420b, // n0x1499 c0x0000 (---------------)  + I grandrapids
	0x0038ef04, // n0x149a c0x0000 (---------------)  + I graz
	0x00230008, // n0x149b c0x0000 (---------------)  + I guernsey
	0x0028708a, // n0x149c c0x0000 (---------------)  + I halloffame
	0x00205a07, // n0x149d c0x0000 (---------------)  + I hamburg
	0x002f7f07, // n0x149e c0x0000 (---------------)  + I handson
	0x0028db92, // n0x149f c0x0000 (---------------)  + I harvestcelebration
	0x00257506, // n0x14a0 c0x0000 (---------------)  + I hawaii
	0x002ae586, // n0x14a1 c0x0000 (---------------)  + I health
	0x00312c8e, // n0x14a2 c0x0000 (---------------)  + I heimatunduhren
	0x00258306, // n0x14a3 c0x0000 (---------------)  + I hellas
	0x00209bc8, // n0x14a4 c0x0000 (---------------)  + I helsinki
	0x0029270f, // n0x14a5 c0x0000 (---------------)  + I hembygdsforbund
	0x00398748, // n0x14a6 c0x0000 (---------------)  + I heritage
	0x0036d1c8, // n0x14a7 c0x0000 (---------------)  + I histoire
	0x0034b70a, // n0x14a8 c0x0000 (---------------)  + I historical
	0x0034b711, // n0x14a9 c0x0000 (---------------)  + I historicalsociety
	0x002a354e, // n0x14aa c0x0000 (---------------)  + I historichouses
	0x0025720a, // n0x14ab c0x0000 (---------------)  + I historisch
	0x0025720c, // n0x14ac c0x0000 (---------------)  + I historisches
	0x00235d07, // n0x14ad c0x0000 (---------------)  + I history
	0x00235d10, // n0x14ae c0x0000 (---------------)  + I historyofscience
	0x00202048, // n0x14af c0x0000 (---------------)  + I horology
	0x002a3745, // n0x14b0 c0x0000 (---------------)  + I house
	0x002abe4a, // n0x14b1 c0x0000 (---------------)  + I humanities
	0x002037cc, // n0x14b2 c0x0000 (---------------)  + I illustration
	0x002b61cd, // n0x14b3 c0x0000 (---------------)  + I imageandsound
	0x002a5286, // n0x14b4 c0x0000 (---------------)  + I indian
	0x002a5287, // n0x14b5 c0x0000 (---------------)  + I indiana
	0x002a528c, // n0x14b6 c0x0000 (---------------)  + I indianapolis
	0x002ec78c, // n0x14b7 c0x0000 (---------------)  + I indianmarket
	0x002ff70c, // n0x14b8 c0x0000 (---------------)  + I intelligence
	0x0028c78b, // n0x14b9 c0x0000 (---------------)  + I interactive
	0x00286784, // n0x14ba c0x0000 (---------------)  + I iraq
	0x0021c344, // n0x14bb c0x0000 (---------------)  + I iron
	0x00349c89, // n0x14bc c0x0000 (---------------)  + I isleofman
	0x002ca6c7, // n0x14bd c0x0000 (---------------)  + I jamison
	0x0026e0c9, // n0x14be c0x0000 (---------------)  + I jefferson
	0x00280d89, // n0x14bf c0x0000 (---------------)  + I jerusalem
	0x00361547, // n0x14c0 c0x0000 (---------------)  + I jewelry
	0x003914c6, // n0x14c1 c0x0000 (---------------)  + I jewish
	0x003914c9, // n0x14c2 c0x0000 (---------------)  + I jewishart
	0x0039b003, // n0x14c3 c0x0000 (---------------)  + I jfk
	0x0027b20a, // n0x14c4 c0x0000 (---------------)  + I journalism
	0x00352707, // n0x14c5 c0x0000 (---------------)  + I judaica
	0x0027724b, // n0x14c6 c0x0000 (---------------)  + I judygarland
	0x0037b54a, // n0x14c7 c0x0000 (---------------)  + I juedisches
	0x00234744, // n0x14c8 c0x0000 (---------------)  + I juif
	0x003507c6, // n0x14c9 c0x0000 (---------------)  + I karate
	0x0027fd89, // n0x14ca c0x0000 (---------------)  + I karikatur
	0x0033c884, // n0x14cb c0x0000 (---------------)  + I kids
	0x00202d4a, // n0x14cc c0x0000 (---------------)  + I koebenhavn
	0x002291c5, // n0x14cd c0x0000 (---------------)  + I koeln
	0x002b6a85, // n0x14ce c0x0000 (---------------)  + I kunst
	0x002b6a8d, // n0x14cf c0x0000 (---------------)  + I kunstsammlung
	0x002b6dce, // n0x14d0 c0x0000 (---------------)  + I kunstunddesign
	0x00317c05, // n0x14d1 c0x0000 (---------------)  + I labor
	0x0038a446, // n0x14d2 c0x0000 (---------------)  + I labour
	0x00246607, // n0x14d3 c0x0000 (---------------)  + I lajolla
	0x002cb10a, // n0x14d4 c0x0000 (---------------)  + I lancashire
	0x00323bc6, // n0x14d5 c0x0000 (---------------)  + I landes
	0x0035bbc4, // n0x14d6 c0x0000 (---------------)  + I lans
	0x002e0a07, // n0x14d7 c0x0000 (---------------)  + I larsson
	0x00213d0b, // n0x14d8 c0x0000 (---------------)  + I lewismiller
	0x0022fcc7, // n0x14d9 c0x0000 (---------------)  + I lincoln
	0x002096c4, // n0x14da c0x0000 (---------------)  + I linz
	0x002de986, // n0x14db c0x0000 (---------------)  + I living
	0x002de98d, // n0x14dc c0x0000 (---------------)  + I livinghistory
	0x0024960c, // n0x14dd c0x0000 (---------------)  + I localhistory
	0x003114c6, // n0x14de c0x0000 (---------------)  + I london
	0x00308aca, // n0x14df c0x0000 (---------------)  + I losangeles
	0x0022ec86, // n0x14e0 c0x0000 (---------------)  + I louvre
	0x0029d408, // n0x14e1 c0x0000 (---------------)  + I loyalist
	0x002e6f07, // n0x14e2 c0x0000 (---------------)  + I lucerne
	0x0023554a, // n0x14e3 c0x0000 (---------------)  + I luxembourg
	0x0023c946, // n0x14e4 c0x0000 (---------------)  + I luzern
	0x002128c3, // n0x14e5 c0x0000 (---------------)  + I mad
	0x003197c6, // n0x14e6 c0x0000 (---------------)  + I madrid
	0x00200cc8, // n0x14e7 c0x0000 (---------------)  + I mallorca
	0x0029ad4a, // n0x14e8 c0x0000 (---------------)  + I manchester
	0x00251d47, // n0x14e9 c0x0000 (---------------)  + I mansion
	0x00251d48, // n0x14ea c0x0000 (---------------)  + I mansions
	0x00268e04, // n0x14eb c0x0000 (---------------)  + I manx
	0x00278d07, // n0x14ec c0x0000 (---------------)  + I marburg
	0x00219cc8, // n0x14ed c0x0000 (---------------)  + I maritime
	0x002a46c8, // n0x14ee c0x0000 (---------------)  + I maritimo
	0x00257708, // n0x14ef c0x0000 (---------------)  + I maryland
	0x00280a0a, // n0x14f0 c0x0000 (---------------)  + I marylhurst
	0x00303545, // n0x14f1 c0x0000 (---------------)  + I media
	0x00239607, // n0x14f2 c0x0000 (---------------)  + I medical
	0x00257053, // n0x14f3 c0x0000 (---------------)  + I medizinhistorisches
	0x00259186, // n0x14f4 c0x0000 (---------------)  + I meeres
	0x0036e248, // n0x14f5 c0x0000 (---------------)  + I memorial
	0x00225a49, // n0x14f6 c0x0000 (---------------)  + I mesaverde
	0x00216148, // n0x14f7 c0x0000 (---------------)  + I michigan
	0x00217bcb, // n0x14f8 c0x0000 (---------------)  + I midatlantic
	0x002b94c8, // n0x14f9 c0x0000 (---------------)  + I military
	0x00213e44, // n0x14fa c0x0000 (---------------)  + I mill
	0x0030a546, // n0x14fb c0x0000 (---------------)  + I miners
	0x00300206, // n0x14fc c0x0000 (---------------)  + I mining
	0x002fc409, // n0x14fd c0x0000 (---------------)  + I minnesota
	0x002c11c7, // n0x14fe c0x0000 (---------------)  + I missile
	0x00259e48, // n0x14ff c0x0000 (---------------)  + I missoula
	0x003a08c6, // n0x1500 c0x0000 (---------------)  + I modern
	0x00306004, // n0x1501 c0x0000 (---------------)  + I moma
	0x002c8705, // n0x1502 c0x0000 (---------------)  + I money
	0x002c3608, // n0x1503 c0x0000 (---------------)  + I monmouth
	0x002c3d4a, // n0x1504 c0x0000 (---------------)  + I monticello
	0x002c4008, // n0x1505 c0x0000 (---------------)  + I montreal
	0x002c8e46, // n0x1506 c0x0000 (---------------)  + I moscow
	0x0029b44a, // n0x1507 c0x0000 (---------------)  + I motorcycle
	0x002e7a88, // n0x1508 c0x0000 (---------------)  + I muenchen
	0x002cb908, // n0x1509 c0x0000 (---------------)  + I muenster
	0x002ccc08, // n0x150a c0x0000 (---------------)  + I mulhouse
	0x002cd606, // n0x150b c0x0000 (---------------)  + I muncie
	0x002d0ac6, // n0x150c c0x0000 (---------------)  + I museet
	0x002f418c, // n0x150d c0x0000 (---------------)  + I museumcenter
	0x002d1090, // n0x150e c0x0000 (---------------)  + I museumvereniging
	0x002812c5, // n0x150f c0x0000 (---------------)  + I music
	0x0031bbc8, // n0x1510 c0x0000 (---------------)  + I national
	0x0031bbd0, // n0x1511 c0x0000 (---------------)  + I nationalfirearms
	0x00398550, // n0x1512 c0x0000 (---------------)  + I nationalheritage
	0x002f524e, // n0x1513 c0x0000 (---------------)  + I nativeamerican
	0x002f3e0e, // n0x1514 c0x0000 (---------------)  + I naturalhistory
	0x002f3e14, // n0x1515 c0x0000 (---------------)  + I naturalhistorymuseum
	0x002dcacf, // n0x1516 c0x0000 (---------------)  + I naturalsciences
	0x002dce86, // n0x1517 c0x0000 (---------------)  + I nature
	0x003218d1, // n0x1518 c0x0000 (---------------)  + I naturhistorisches
	0x00325193, // n0x1519 c0x0000 (---------------)  + I natuurwetenschappen
	0x00325608, // n0x151a c0x0000 (---------------)  + I naumburg
	0x00255505, // n0x151b c0x0000 (---------------)  + I naval
	0x0024e708, // n0x151c c0x0000 (---------------)  + I nebraska
	0x002e39c5, // n0x151d c0x0000 (---------------)  + I neues
	0x0022c04c, // n0x151e c0x0000 (---------------)  + I newhampshire
	0x002b10c9, // n0x151f c0x0000 (---------------)  + I newjersey
	0x00231849, // n0x1520 c0x0000 (---------------)  + I newmexico
	0x00245087, // n0x1521 c0x0000 (---------------)  + I newport
	0x0021e609, // n0x1522 c0x0000 (---------------)  + I newspaper
	0x00328187, // n0x1523 c0x0000 (---------------)  + I newyork
	0x0029a5c6, // n0x1524 c0x0000 (---------------)  + I niepce
	0x00356947, // n0x1525 c0x0000 (---------------)  + I norfolk
	0x0023c505, // n0x1526 c0x0000 (---------------)  + I north
	0x0026e2c3, // n0x1527 c0x0000 (---------------)  + I nrw
	0x00329649, // n0x1528 c0x0000 (---------------)  + I nuernberg
	0x0037ba89, // n0x1529 c0x0000 (---------------)  + I nuremberg
	0x0036dcc3, // n0x152a c0x0000 (---------------)  + I nyc
	0x0039f3c4, // n0x152b c0x0000 (---------------)  + I nyny
	0x0031110d, // n0x152c c0x0000 (---------------)  + I oceanographic
	0x0039f9cf, // n0x152d c0x0000 (---------------)  + I oceanographique
	0x002fe985, // n0x152e c0x0000 (---------------)  + I omaha
	0x00319c46, // n0x152f c0x0000 (---------------)  + I online
	0x0039f847, // n0x1530 c0x0000 (---------------)  + I ontario
	0x0033f507, // n0x1531 c0x0000 (---------------)  + I openair
	0x0028a586, // n0x1532 c0x0000 (---------------)  + I oregon
	0x0028a58b, // n0x1533 c0x0000 (---------------)  + I oregontrail
	0x002a4c45, // n0x1534 c0x0000 (---------------)  + I otago
	0x0039d306, // n0x1535 c0x0000 (---------------)  + I oxford
	0x0038ff07, // n0x1536 c0x0000 (---------------)  + I pacific
	0x002714c9, // n0x1537 c0x0000 (---------------)  + I paderborn
	0x00311c06, // n0x1538 c0x0000 (---------------)  + I palace
	0x0020c845, // n0x1539 c0x0000 (---------------)  + I paleo
	0x00245b8b, // n0x153a c0x0000 (---------------)  + I palmsprings
	0x002546c6, // n0x153b c0x0000 (---------------)  + I panama
	0x00277705, // n0x153c c0x0000 (---------------)  + I paris
	0x002b7348, // n0x153d c0x0000 (---------------)  + I pasadena
	0x00373588, // n0x153e c0x0000 (---------------)  + I pharmacy
	0x002d470c, // n0x153f c0x0000 (---------------)  + I philadelphia
	0x002d4710, // n0x1540 c0x0000 (---------------)  + I philadelphiaarea
	0x002d4dc9, // n0x1541 c0x0000 (---------------)  + I philately
	0x002d5207, // n0x1542 c0x0000 (---------------)  + I phoenix
	0x002d564b, // n0x1543 c0x0000 (---------------)  + I photography
	0x002d6ac6, // n0x1544 c0x0000 (---------------)  + I pilots
	0x002d780a, // n0x1545 c0x0000 (---------------)  + I pittsburgh
	0x002d82cb, // n0x1546 c0x0000 (---------------)  + I planetarium
	0x002d86ca, // n0x1547 c0x0000 (---------------)  + I plantation
	0x002d8946, // n0x1548 c0x0000 (---------------)  + I plants
	0x002d9585, // n0x1549 c0x0000 (---------------)  + I plaza
	0x003275c6, // n0x154a c0x0000 (---------------)  + I portal
	0x00279288, // n0x154b c0x0000 (---------------)  + I portland
	0x0024514a, // n0x154c c0x0000 (---------------)  + I portlligat
	0x0036041c, // n0x154d c0x0000 (---------------)  + I posts-and-telecommunications
	0x002e0c8c, // n0x154e c0x0000 (---------------)  + I preservation
	0x002e0f88, // n0x154f c0x0000 (---------------)  + I presidio
	0x00246a05, // n0x1550 c0x0000 (---------------)  + I press
	0x002e3dc7, // n0x1551 c0x0000 (---------------)  + I project
	0x002a0ec6, // n0x1552 c0x0000 (---------------)  + I public
	0x0038d045, // n0x1553 c0x0000 (---------------)  + I pubol
	0x0021d986, // n0x1554 c0x0000 (---------------)  + I quebec
	0x0028a748, // n0x1555 c0x0000 (---------------)  + I railroad
	0x002b4f87, // n0x1556 c0x0000 (---------------)  + I railway
	0x002a1188, // n0x1557 c0x0000 (---------------)  + I research
	0x002a7eca, // n0x1558 c0x0000 (---------------)  + I resistance
	0x0030b2cc, // n0x1559 c0x0000 (---------------)  + I riodejaneiro
	0x0030b549, // n0x155a c0x0000 (---------------)  + I rochester
	0x0038d387, // n0x155b c0x0000 (---------------)  + I rockart
	0x0022cb44, // n0x155c c0x0000 (---------------)  + I roma
	0x00252f46, // n0x155d c0x0000 (---------------)  + I russia
	0x0036cd4a, // n0x155e c0x0000 (---------------)  + I saintlouis
	0x00280e85, // n0x155f c0x0000 (---------------)  + I salem
	0x0031f70c, // n0x1560 c0x0000 (---------------)  + I salvadordali
	0x00320388, // n0x1561 c0x0000 (---------------)  + I salzburg
	0x0023bf08, // n0x1562 c0x0000 (---------------)  + I sandiego
	0x00399b0c, // n0x1563 c0x0000 (---------------)  + I sanfrancisco
	0x0020df8c, // n0x1564 c0x0000 (---------------)  + I santabarbara
	0x0020fd09, // n0x1565 c0x0000 (---------------)  + I santacruz
	0x0020ff47, // n0x1566 c0x0000 (---------------)  + I santafe
	0x002ae88c, // n0x1567 c0x0000 (---------------)  + I saskatchewan
	0x003a5184, // n0x1568 c0x0000 (---------------)  + I satx
	0x0037750a, // n0x1569 c0x0000 (---------------)  + I savannahga
	0x0033cb8c, // n0x156a c0x0000 (---------------)  + I schlesisches
	0x0027234b, // n0x156b c0x0000 (---------------)  + I schoenbrunn
	0x0023100b, // n0x156c c0x0000 (---------------)  + I schokoladen
	0x00232186, // n0x156d c0x0000 (---------------)  + I school
	0x00237b87, // n0x156e c0x0000 (---------------)  + I schweiz
	0x00235f47, // n0x156f c0x0000 (---------------)  + I science
	0x00235f4f, // n0x1570 c0x0000 (---------------)  + I science-fiction
	0x002ed0d1, // n0x1571 c0x0000 (---------------)  + I scienceandhistory
	0x003a3452, // n0x1572 c0x0000 (---------------)  + I scienceandindustry
	0x0024124d, // n0x1573 c0x0000 (---------------)  + I sciencecenter
	0x0024124e, // n0x1574 c0x0000 (---------------)  + I sciencecenters
	0x0024158e, // n0x1575 c0x0000 (---------------)  + I sciencehistory
	0x002dcc88, // n0x1576 c0x0000 (---------------)  + I sciences
	0x002dcc92, // n0x1577 c0x0000 (---------------)  + I sciencesnaturelles
	0x00399d48, // n0x1578 c0x0000 (---------------)  + I scotland
	0x002f9ac7, // n0x1579 c0x0000 (---------------)  + I seaport
	0x0024fe8a, // n0x157a c0x0000 (---------------)  + I settlement
	0x0021f7c8, // n0x157b c0x0000 (---------------)  + I settlers
	0x002582c5, // n0x157c c0x0000 (---------------)  + I shell
	0x002eb88a, // n0x157d c0x0000 (---------------)  + I sherbrooke
	0x00221c07, // n0x157e c0x0000 (---------------)  + I sibenik
	0x00358404, // n0x157f c0x0000 (---------------)  + I silk
	0x00208503, // n0x1580 c0x0000 (---------------)  + I ski
	0x00297b45, // n0x1581 c0x0000 (---------------)  + I skole
	0x0034b987, // n0x1582 c0x0000 (---------------)  + I society
	0x002e1e47, // n0x1583 c0x0000 (---------------)  + I sologne
	0x002b63ce, // n0x1584 c0x0000 (---------------)  + I soundandvision
	0x00302ccd, // n0x1585 c0x0000 (---------------)  + I southcarolina
	0x003067c9, // n0x1586 c0x0000 (---------------)  + I southwest
	0x0020aa85, // n0x1587 c0x0000 (---------------)  + I space
	0x00332903, // n0x1588 c0x0000 (---------------)  + I spy
	0x0027a146, // n0x1589 c0x0000 (---------------)  + I square
	0x00364b45, // n0x158a c0x0000 (---------------)  + I stadt
	0x0027af48, // n0x158b c0x0000 (---------------)  + I stalbans
	0x00322809, // n0x158c c0x0000 (---------------)  + I starnberg
	0x0020a205, // n0x158d c0x0000 (---------------)  + I state
	0x00337b8f, // n0x158e c0x0000 (---------------)  + I stateofdelaware
	0x00255387, // n0x158f c0x0000 (---------------)  + I station
	0x00367605, // n0x1590 c0x0000 (---------------)  + I steam
	0x00229cca, // n0x1591 c0x0000 (---------------)  + I steiermark
	0x0033bd06, // n0x1592 c0x0000 (---------------)  + I stjohn
	0x0029d589, // n0x1593 c0x0000 (---------------)  + I stockholm
	0x003906cc, // n0x1594 c0x0000 (---------------)  + I stpetersburg
	0x002e8d09, // n0x1595 c0x0000 (---------------)  + I stuttgart
	0x0020b646, // n0x1596 c0x0000 (---------------)  + I suisse
	0x00286e8c, // n0x1597 c0x0000 (---------------)  + I surgeonshall
	0x002e9586, // n0x1598 c0x0000 (---------------)  + I surrey
	0x002ebc08, // n0x1599 c0x0000 (---------------)  + I svizzera
	0x002ebe06, // n0x159a c0x0000 (---------------)  + I sweden
	0x00335c06, // n0x159b c0x0000 (---------------)  + I sydney
	0x00355284, // n0x159c c0x0000 (---------------)  + I tank
	0x0025ccc3, // n0x159d c0x0000 (---------------)  + I tcm
	0x002ad44a, // n0x159e c0x0000 (---------------)  + I technology
	0x0022ce51, // n0x159f c0x0000 (---------------)  + I telekommunikation
	0x002b894a, // n0x15a0 c0x0000 (---------------)  + I television
	0x0034aac5, // n0x15a1 c0x0000 (---------------)  + I texas
	0x00382307, // n0x15a2 c0x0000 (---------------)  + I textile
	0x00257a07, // n0x15a3 c0x0000 (---------------)  + I theater
	0x00219dc4, // n0x15a4 c0x0000 (---------------)  + I time
	0x00219dcb, // n0x15a5 c0x0000 (---------------)  + I timekeeping
	0x00206e48, // n0x15a6 c0x0000 (---------------)  + I topology
	0x002b34c6, // n0x15a7 c0x0000 (---------------)  + I torino
	0x00288685, // n0x15a8 c0x0000 (---------------)  + I touch
	0x002dc0c4, // n0x15a9 c0x0000 (---------------)  + I town
	0x0029c509, // n0x15aa c0x0000 (---------------)  + I transport
	0x00353204, // n0x15ab c0x0000 (---------------)  + I tree
	0x0033f9c7, // n0x15ac c0x0000 (---------------)  + I trolley
	0x0032a345, // n0x15ad c0x0000 (---------------)  + I trust
	0x0032a347, // n0x15ae c0x0000 (---------------)  + I trustee
	0x00312ec5, // n0x15af c0x0000 (---------------)  + I uhren
	0x00349683, // n0x15b0 c0x0000 (---------------)  + I ulm
	0x002f9988, // n0x15b1 c0x0000 (---------------)  + I undersea
	0x00309e4a, // n0x15b2 c0x0000 (---------------)  + I university
	0x00244843, // n0x15b3 c0x0000 (---------------)  + I usa
	0x002b7b0a, // n0x15b4 c0x0000 (---------------)  + I usantiques
	0x0028fdc6, // n0x15b5 c0x0000 (---------------)  + I usarts
	0x0033790f, // n0x15b6 c0x0000 (---------------)  + I uscountryestate
	0x0033d389, // n0x15b7 c0x0000 (---------------)  + I usculture
	0x0025df10, // n0x15b8 c0x0000 (---------------)  + I usdecorativearts
	0x0026ecc8, // n0x15b9 c0x0000 (---------------)  + I usgarden
	0x002c96c9, // n0x15ba c0x0000 (---------------)  + I ushistory
	0x0029e207, // n0x15bb c0x0000 (---------------)  + I ushuaia
	0x002de90f, // n0x15bc c0x0000 (---------------)  + I uslivinghistory
	0x002e8844, // n0x15bd c0x0000 (---------------)  + I utah
	0x002aec44, // n0x15be c0x0000 (---------------)  + I uvic
	0x00216c86, // n0x15bf c0x0000 (---------------)  + I valley
	0x002371c6, // n0x15c0 c0x0000 (---------------)  + I vantaa
	0x0031758a, // n0x15c1 c0x0000 (---------------)  + I versailles
	0x0032ae86, // n0x15c2 c0x0000 (---------------)  + I viking
	0x002ed947, // n0x15c3 c0x0000 (---------------)  + I village
	0x002f6d88, // n0x15c4 c0x0000 (---------------)  + I virginia
	0x002f6f87, // n0x15c5 c0x0000 (---------------)  + I virtual
	0x002f7147, // n0x15c6 c0x0000 (---------------)  + I virtuel
	0x0034514a, // n0x15c7 c0x0000 (---------------)  + I vlaanderen
	0x002f97cb, // n0x15c8 c0x0000 (---------------)  + I volkenkunde
	0x00309ac5, // n0x15c9 c0x0000 (---------------)  + I wales
	0x003a3088, // n0x15ca c0x0000 (---------------)  + I wallonie
	0x00203683, // n0x15cb c0x0000 (---------------)  + I war
	0x0023f70c, // n0x15cc c0x0000 (---------------)  + I washingtondc
	0x00375acf, // n0x15cd c0x0000 (---------------)  + I watch-and-clock
	0x002b068d, // n0x15ce c0x0000 (---------------)  + I watchandclock
	0x0023c647, // n0x15cf c0x0000 (---------------)  + I western
	0x00306909, // n0x15d0 c0x0000 (---------------)  + I westfalen
	0x0026e347, // n0x15d1 c0x0000 (---------------)  + I whaling
	0x0035f308, // n0x15d2 c0x0000 (---------------)  + I wildlife
	0x0023260c, // n0x15d3 c0x0000 (---------------)  + I williamsburg
	0x00284bc8, // n0x15d4 c0x0000 (---------------)  + I windmill
	0x00357088, // n0x15d5 c0x0000 (---------------)  + I workshop
	0x0030ea4e, // n0x15d6 c0x0000 (---------------)  + I xn--9dbhblg6di
	0x0031dbd4, // n0x15d7 c0x0000 (---------------)  + I xn--comunicaes-v6a2o
	0x0031e0e4, // n0x15d8 c0x0000 (---------------)  + I xn--correios-e-telecomunicaes-ghc29a
	0x0033be8a, // n0x15d9 c0x0000 (---------------)  + I xn--h1aegh
	0x00358c0b, // n0x15da c0x0000 (---------------)  + I xn--lns-qla
	0x00328244, // n0x15db c0x0000 (---------------)  + I york
	0x00328249, // n0x15dc c0x0000 (---------------)  + I yorkshire
	0x002abc48, // n0x15dd c0x0000 (---------------)  + I yosemite
	0x0024a805, // n0x15de c0x0000 (---------------)  + I youth
	0x00328f8a, // n0x15df c0x0000 (---------------)  + I zoological
	0x0027a307, // n0x15e0 c0x0000 (---------------)  + I zoology
	0x002e2dc4, // n0x15e1 c0x0000 (---------------)  + I aero
	0x00331a83, // n0x15e2 c0x0000 (---------------)  + I biz
	0x00233243, // n0x15e3 c0x0000 (---------------)  + I com
	0x0023c344, // n0x15e4 c0x0000 (---------------)  + I coop
	0x00239103, // n0x15e5 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x15e6 c0x0000 (---------------)  + I gov
	0x00201844, // n0x15e7 c0x0000 (---------------)  + I info
	0x00201503, // n0x15e8 c0x0000 (---------------)  + I int
	0x00207dc3, // n0x15e9 c0x0000 (---------------)  + I mil
	0x002d1086, // n0x15ea c0x0000 (---------------)  + I museum
	0x00200904, // n0x15eb c0x0000 (---------------)  + I name
	0x00223b43, // n0x15ec c0x0000 (---------------)  + I net
	0x00228743, // n0x15ed c0x0000 (---------------)  + I org
	0x00224b03, // n0x15ee c0x0000 (---------------)  + I pro
	0x00200342, // n0x15ef c0x0000 (---------------)  + I ac
	0x00331a83, // n0x15f0 c0x0000 (---------------)  + I biz
	0x0020ce42, // n0x15f1 c0x0000 (---------------)  + I co
	0x00233243, // n0x15f2 c0x0000 (---------------)  + I com
	0x0023c344, // n0x15f3 c0x0000 (---------------)  + I coop
	0x00239103, // n0x15f4 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x15f5 c0x0000 (---------------)  + I gov
	0x00201503, // n0x15f6 c0x0000 (---------------)  + I int
	0x002d1086, // n0x15f7 c0x0000 (---------------)  + I museum
	0x00223b43, // n0x15f8 c0x0000 (---------------)  + I net
	0x00228743, // n0x15f9 c0x0000 (---------------)  + I org
	0x000fe108, // n0x15fa c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x15fb c0x0000 (---------------)  + I com
	0x00239103, // n0x15fc c0x0000 (---------------)  + I edu
	0x00212b03, // n0x15fd c0x0000 (---------------)  + I gob
	0x00223b43, // n0x15fe c0x0000 (---------------)  + I net
	0x00228743, // n0x15ff c0x0000 (---------------)  + I org
	0x000fe108, // n0x1600 c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x1601 c0x0000 (---------------)  + I com
	0x00239103, // n0x1602 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1603 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x1604 c0x0000 (---------------)  + I mil
	0x00200904, // n0x1605 c0x0000 (---------------)  + I name
	0x00223b43, // n0x1606 c0x0000 (---------------)  + I net
	0x00228743, // n0x1607 c0x0000 (---------------)  + I org
	0x0062dd88, // n0x1608 c0x0001 (---------------)  ! I teledata
	0x00200e42, // n0x1609 c0x0000 (---------------)  + I ca
	0x0022f6c2, // n0x160a c0x0000 (---------------)  + I cc
	0x0020ce42, // n0x160b c0x0000 (---------------)  + I co
	0x00233243, // n0x160c c0x0000 (---------------)  + I com
	0x0026ab42, // n0x160d c0x0000 (---------------)  + I dr
	0x002012c2, // n0x160e c0x0000 (---------------)  + I in
	0x00201844, // n0x160f c0x0000 (---------------)  + I info
	0x0020bf04, // n0x1610 c0x0000 (---------------)  + I mobi
	0x002195c2, // n0x1611 c0x0000 (---------------)  + I mx
	0x00200904, // n0x1612 c0x0000 (---------------)  + I name
	0x00200dc2, // n0x1613 c0x0000 (---------------)  + I or
	0x00228743, // n0x1614 c0x0000 (---------------)  + I org
	0x00224b03, // n0x1615 c0x0000 (---------------)  + I pro
	0x00232186, // n0x1616 c0x0000 (---------------)  + I school
	0x002203c2, // n0x1617 c0x0000 (---------------)  + I tv
	0x00202242, // n0x1618 c0x0000 (---------------)  + I us
	0x0020a882, // n0x1619 c0x0000 (---------------)  + I ws
	0x38225983, // n0x161a c0x00e0 (n0x161c-n0x161d)  o I her
	0x38618043, // n0x161b c0x00e1 (n0x161d-n0x161e)  o I his
	0x000580c6, // n0x161c c0x0000 (---------------)  +   forgot
	0x000580c6, // n0x161d c0x0000 (---------------)  +   forgot
	0x002d5e84, // n0x161e c0x0000 (---------------)  + I asso
	0x0011928c, // n0x161f c0x0000 (---------------)  +   at-band-camp
	0x00081bcc, // n0x1620 c0x0000 (---------------)  +   azure-mobile
	0x000c234d, // n0x1621 c0x0000 (---------------)  +   azurewebsites
	0x0002f087, // n0x1622 c0x0000 (---------------)  +   blogdns
	0x00023f48, // n0x1623 c0x0000 (---------------)  +   broke-it
	0x00197f4a, // n0x1624 c0x0000 (---------------)  +   buyshouses
	0x39262e05, // n0x1625 c0x00e4 (n0x1654-n0x1655)  o I cdn77
	0x00062e09, // n0x1626 c0x0000 (---------------)  +   cdn77-ssl
	0x00007f48, // n0x1627 c0x0000 (---------------)  +   cloudapp
	0x0019e90a, // n0x1628 c0x0000 (---------------)  +   cloudfront
	0x00030c4e, // n0x1629 c0x0000 (---------------)  +   cloudfunctions
	0x00142e48, // n0x162a c0x0000 (---------------)  +   dnsalias
	0x0007cf07, // n0x162b c0x0000 (---------------)  +   dnsdojo
	0x00160c07, // n0x162c c0x0000 (---------------)  +   does-it
	0x0016a789, // n0x162d c0x0000 (---------------)  +   dontexist
	0x0013c907, // n0x162e c0x0000 (---------------)  +   dsmynas
	0x00197108, // n0x162f c0x0000 (---------------)  +   dynalias
	0x000f3449, // n0x1630 c0x0000 (---------------)  +   dynathome
	0x000aa38d, // n0x1631 c0x0000 (---------------)  +   endofinternet
	0x00007d48, // n0x1632 c0x0000 (---------------)  +   familyds
	0x39646286, // n0x1633 c0x00e5 (n0x1655-n0x1657)  o I fastly
	0x00062a47, // n0x1634 c0x0000 (---------------)  +   from-az
	0x00063c47, // n0x1635 c0x0000 (---------------)  +   from-co
	0x000688c7, // n0x1636 c0x0000 (---------------)  +   from-la
	0x000709c7, // n0x1637 c0x0000 (---------------)  +   from-ny
	0x0000e482, // n0x1638 c0x0000 (---------------)  +   gb
	0x00049d47, // n0x1639 c0x0000 (---------------)  +   gets-it
	0x0006494c, // n0x163a c0x0000 (---------------)  +   ham-radio-op
	0x00120a07, // n0x163b c0x0000 (---------------)  +   homeftp
	0x000a6806, // n0x163c c0x0000 (---------------)  +   homeip
	0x000a6dc9, // n0x163d c0x0000 (---------------)  +   homelinux
	0x000a8148, // n0x163e c0x0000 (---------------)  +   homeunix
	0x00024202, // n0x163f c0x0000 (---------------)  +   hu
	0x000012c2, // n0x1640 c0x0000 (---------------)  +   in
	0x000068cb, // n0x1641 c0x0000 (---------------)  +   in-the-band
	0x000110c9, // n0x1642 c0x0000 (---------------)  +   is-a-chef
	0x0004ef49, // n0x1643 c0x0000 (---------------)  +   is-a-geek
	0x000862c8, // n0x1644 c0x0000 (---------------)  +   isa-geek
	0x000b00c2, // n0x1645 c0x0000 (---------------)  +   jp
	0x0014ee89, // n0x1646 c0x0000 (---------------)  +   kicks-ass
	0x0001decd, // n0x1647 c0x0000 (---------------)  +   office-on-the
	0x000dd687, // n0x1648 c0x0000 (---------------)  +   podzone
	0x00127bc8, // n0x1649 c0x0000 (---------------)  +   rackmaze
	0x0004344d, // n0x164a c0x0000 (---------------)  +   scrapper-site
	0x00004ec2, // n0x164b c0x0000 (---------------)  +   se
	0x0005abc6, // n0x164c c0x0000 (---------------)  +   selfip
	0x00091b08, // n0x164d c0x0000 (---------------)  +   sells-it
	0x000ccd88, // n0x164e c0x0000 (---------------)  +   servebbs
	0x0008bc88, // n0x164f c0x0000 (---------------)  +   serveftp
	0x000549c8, // n0x1650 c0x0000 (---------------)  +   thruhere
	0x00001b02, // n0x1651 c0x0000 (---------------)  +   uk
	0x001267c6, // n0x1652 c0x0000 (---------------)  +   webhop
	0x00000182, // n0x1653 c0x0000 (---------------)  +   za
	0x000006c1, // n0x1654 c0x0000 (---------------)  +   r
	0x39ae1bc4, // n0x1655 c0x00e6 (n0x1657-n0x1659)  o I prod
	0x39e62f83, // n0x1656 c0x00e7 (n0x1659-n0x165c)  o I ssl
	0x000001c1, // n0x1657 c0x0000 (---------------)  +   a
	0x0000eac6, // n0x1658 c0x0000 (---------------)  +   global
	0x000001c1, // n0x1659 c0x0000 (---------------)  +   a
	0x00000001, // n0x165a c0x0000 (---------------)  +   b
	0x0000eac6, // n0x165b c0x0000 (---------------)  +   global
	0x0024b944, // n0x165c c0x0000 (---------------)  + I arts
	0x00233243, // n0x165d c0x0000 (---------------)  + I com
	0x0024dcc4, // n0x165e c0x0000 (---------------)  + I firm
	0x00201844, // n0x165f c0x0000 (---------------)  + I info
	0x00223b43, // n0x1660 c0x0000 (---------------)  + I net
	0x00225905, // n0x1661 c0x0000 (---------------)  + I other
	0x0021e783, // n0x1662 c0x0000 (---------------)  + I per
	0x0022c2c3, // n0x1663 c0x0000 (---------------)  + I rec
	0x00364cc5, // n0x1664 c0x0000 (---------------)  + I store
	0x0021e243, // n0x1665 c0x0000 (---------------)  + I web
	0x3aa33243, // n0x1666 c0x00ea (n0x1670-n0x1671)  + I com
	0x00239103, // n0x1667 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1668 c0x0000 (---------------)  + I gov
	0x00200041, // n0x1669 c0x0000 (---------------)  + I i
	0x00207dc3, // n0x166a c0x0000 (---------------)  + I mil
	0x0020bf04, // n0x166b c0x0000 (---------------)  + I mobi
	0x00200904, // n0x166c c0x0000 (---------------)  + I name
	0x00223b43, // n0x166d c0x0000 (---------------)  + I net
	0x00228743, // n0x166e c0x0000 (---------------)  + I org
	0x00217283, // n0x166f c0x0000 (---------------)  + I sch
	0x000fe108, // n0x1670 c0x0000 (---------------)  +   blogspot
	0x00200342, // n0x1671 c0x0000 (---------------)  + I ac
	0x00331a83, // n0x1672 c0x0000 (---------------)  + I biz
	0x0020ce42, // n0x1673 c0x0000 (---------------)  + I co
	0x00233243, // n0x1674 c0x0000 (---------------)  + I com
	0x00239103, // n0x1675 c0x0000 (---------------)  + I edu
	0x00212b03, // n0x1676 c0x0000 (---------------)  + I gob
	0x002012c2, // n0x1677 c0x0000 (---------------)  + I in
	0x00201844, // n0x1678 c0x0000 (---------------)  + I info
	0x00201503, // n0x1679 c0x0000 (---------------)  + I int
	0x00207dc3, // n0x167a c0x0000 (---------------)  + I mil
	0x00223b43, // n0x167b c0x0000 (---------------)  + I net
	0x00201383, // n0x167c c0x0000 (---------------)  + I nom
	0x00228743, // n0x167d c0x0000 (---------------)  + I org
	0x0021e243, // n0x167e c0x0000 (---------------)  + I web
	0x000fe108, // n0x167f c0x0000 (---------------)  +   blogspot
	0x00365fc2, // n0x1680 c0x0000 (---------------)  + I bv
	0x0000ce42, // n0x1681 c0x0000 (---------------)  +   co
	0x3ba26782, // n0x1682 c0x00ee (n0x1958-n0x1959)  + I aa
	0x003528c8, // n0x1683 c0x0000 (---------------)  + I aarborte
	0x00226c06, // n0x1684 c0x0000 (---------------)  + I aejrie
	0x002bd6c6, // n0x1685 c0x0000 (---------------)  + I afjord
	0x00226587, // n0x1686 c0x0000 (---------------)  + I agdenes
	0x3be05702, // n0x1687 c0x00ef (n0x1959-n0x195a)  + I ah
	0x3c23ed88, // n0x1688 c0x00f0 (n0x195a-n0x195b)  o I akershus
	0x00351cca, // n0x1689 c0x0000 (---------------)  + I aknoluokta
	0x002624c8, // n0x168a c0x0000 (---------------)  + I akrehamn
	0x00200d02, // n0x168b c0x0000 (---------------)  + I al
	0x00352549, // n0x168c c0x0000 (---------------)  + I alaheadju
	0x00309b07, // n0x168d c0x0000 (---------------)  + I alesund
	0x0021b906, // n0x168e c0x0000 (---------------)  + I algard
	0x00205609, // n0x168f c0x0000 (---------------)  + I alstahaug
	0x00239744, // n0x1690 c0x0000 (---------------)  + I alta
	0x002be146, // n0x1691 c0x0000 (---------------)  + I alvdal
	0x002bdac4, // n0x1692 c0x0000 (---------------)  + I amli
	0x00278404, // n0x1693 c0x0000 (---------------)  + I amot
	0x00259989, // n0x1694 c0x0000 (---------------)  + I andasuolo
	0x002b8206, // n0x1695 c0x0000 (---------------)  + I andebu
	0x002293c5, // n0x1696 c0x0000 (---------------)  + I andoy
	0x00266b05, // n0x1697 c0x0000 (---------------)  + I ardal
	0x00234047, // n0x1698 c0x0000 (---------------)  + I aremark
	0x002b9947, // n0x1699 c0x0000 (---------------)  + I arendal
	0x003549c4, // n0x169a c0x0000 (---------------)  + I arna
	0x002267c6, // n0x169b c0x0000 (---------------)  + I aseral
	0x002e2685, // n0x169c c0x0000 (---------------)  + I asker
	0x0023e085, // n0x169d c0x0000 (---------------)  + I askim
	0x002f1385, // n0x169e c0x0000 (---------------)  + I askoy
	0x00387687, // n0x169f c0x0000 (---------------)  + I askvoll
	0x0022b645, // n0x16a0 c0x0000 (---------------)  + I asnes
	0x0030bb89, // n0x16a1 c0x0000 (---------------)  + I audnedaln
	0x0025d9c5, // n0x16a2 c0x0000 (---------------)  + I aukra
	0x002f9ec4, // n0x16a3 c0x0000 (---------------)  + I aure
	0x00323b07, // n0x16a4 c0x0000 (---------------)  + I aurland
	0x0026a80e, // n0x16a5 c0x0000 (---------------)  + I aurskog-holand
	0x002f3a49, // n0x16a6 c0x0000 (---------------)  + I austevoll
	0x00312b49, // n0x16a7 c0x0000 (---------------)  + I austrheim
	0x00330606, // n0x16a8 c0x0000 (---------------)  + I averoy
	0x002eaac8, // n0x16a9 c0x0000 (---------------)  + I badaddja
	0x002afb0b, // n0x16aa c0x0000 (---------------)  + I bahcavuotna
	0x002d2a0c, // n0x16ab c0x0000 (---------------)  + I bahccavuotna
	0x00268b46, // n0x16ac c0x0000 (---------------)  + I baidar
	0x003706c7, // n0x16ad c0x0000 (---------------)  + I bajddar
	0x0026b905, // n0x16ae c0x0000 (---------------)  + I balat
	0x0022a48a, // n0x16af c0x0000 (---------------)  + I balestrand
	0x00307649, // n0x16b0 c0x0000 (---------------)  + I ballangen
	0x00255089, // n0x16b1 c0x0000 (---------------)  + I balsfjord
	0x00269c86, // n0x16b2 c0x0000 (---------------)  + I bamble
	0x002eb045, // n0x16b3 c0x0000 (---------------)  + I bardu
	0x002804c5, // n0x16b4 c0x0000 (---------------)  + I barum
	0x003517c9, // n0x16b5 c0x0000 (---------------)  + I batsfjord
	0x002f150b, // n0x16b6 c0x0000 (---------------)  + I bearalvahki
	0x0027cbc6, // n0x16b7 c0x0000 (---------------)  + I beardu
	0x0032f586, // n0x16b8 c0x0000 (---------------)  + I beiarn
	0x0020e3c4, // n0x16b9 c0x0000 (---------------)  + I berg
	0x0028d846, // n0x16ba c0x0000 (---------------)  + I bergen
	0x00311f88, // n0x16bb c0x0000 (---------------)  + I berlevag
	0x00200b46, // n0x16bc c0x0000 (---------------)  + I bievat
	0x0038df46, // n0x16bd c0x0000 (---------------)  + I bindal
	0x00205d48, // n0x16be c0x0000 (---------------)  + I birkenes
	0x0020b447, // n0x16bf c0x0000 (---------------)  + I bjarkoy
	0x0020bcc9, // n0x16c0 c0x0000 (---------------)  + I bjerkreim
	0x0020d4c5, // n0x16c1 c0x0000 (---------------)  + I bjugn
	0x000fe108, // n0x16c2 c0x0000 (---------------)  +   blogspot
	0x00212b84, // n0x16c3 c0x0000 (---------------)  + I bodo
	0x0023dc84, // n0x16c4 c0x0000 (---------------)  + I bokn
	0x00213985, // n0x16c5 c0x0000 (---------------)  + I bomlo
	0x0038b709, // n0x16c6 c0x0000 (---------------)  + I bremanger
	0x00224f47, // n0x16c7 c0x0000 (---------------)  + I bronnoy
	0x00224f4b, // n0x16c8 c0x0000 (---------------)  + I bronnoysund
	0x00225e8a, // n0x16c9 c0x0000 (---------------)  + I brumunddal
	0x0022a185, // n0x16ca c0x0000 (---------------)  + I bryne
	0x3c605ac2, // n0x16cb c0x00f1 (n0x195b-n0x195c)  + I bu
	0x0037b407, // n0x16cc c0x0000 (---------------)  + I budejju
	0x3ca2be08, // n0x16cd c0x00f2 (n0x195c-n0x195d)  o I buskerud
	0x002b9187, // n0x16ce c0x0000 (---------------)  + I bygland
	0x002b8545, // n0x16cf c0x0000 (---------------)  + I bykle
	0x0024940a, // n0x16d0 c0x0000 (---------------)  + I cahcesuolo
	0x0000ce42, // n0x16d1 c0x0000 (---------------)  +   co
	0x002db24b, // n0x16d2 c0x0000 (---------------)  + I davvenjarga
	0x0021530a, // n0x16d3 c0x0000 (---------------)  + I davvesiida
	0x0039d446, // n0x16d4 c0x0000 (---------------)  + I deatnu
	0x00273e03, // n0x16d5 c0x0000 (---------------)  + I dep
	0x0037834d, // n0x16d6 c0x0000 (---------------)  + I dielddanuorri
	0x0026a28c, // n0x16d7 c0x0000 (---------------)  + I divtasvuodna
	0x0030808d, // n0x16d8 c0x0000 (---------------)  + I divttasvuotna
	0x0035e605, // n0x16d9 c0x0000 (---------------)  + I donna
	0x00268605, // n0x16da c0x0000 (---------------)  + I dovre
	0x003294c7, // n0x16db c0x0000 (---------------)  + I drammen
	0x0031ff89, // n0x16dc c0x0000 (---------------)  + I drangedal
	0x00351bc6, // n0x16dd c0x0000 (---------------)  + I drobak
	0x0032ad05, // n0x16de c0x0000 (---------------)  + I dyroy
	0x0022f808, // n0x16df c0x0000 (---------------)  + I egersund
	0x0024ea03, // n0x16e0 c0x0000 (---------------)  + I eid
	0x0032ab48, // n0x16e1 c0x0000 (---------------)  + I eidfjord
	0x0028d748, // n0x16e2 c0x0000 (---------------)  + I eidsberg
	0x002bf047, // n0x16e3 c0x0000 (---------------)  + I eidskog
	0x0024ea08, // n0x16e4 c0x0000 (---------------)  + I eidsvoll
	0x002005c9, // n0x16e5 c0x0000 (---------------)  + I eigersund
	0x0023aec7, // n0x16e6 c0x0000 (---------------)  + I elverum
	0x002085c7, // n0x16e7 c0x0000 (---------------)  + I enebakk
	0x00279848, // n0x16e8 c0x0000 (---------------)  + I engerdal
	0x0035cd84, // n0x16e9 c0x0000 (---------------)  + I etne
	0x0035cd87, // n0x16ea c0x0000 (---------------)  + I etnedal
	0x00337008, // n0x16eb c0x0000 (---------------)  + I evenassi
	0x00202a06, // n0x16ec c0x0000 (---------------)  + I evenes
	0x0039978f, // n0x16ed c0x0000 (---------------)  + I evje-og-hornnes
	0x002112c7, // n0x16ee c0x0000 (---------------)  + I farsund
	0x0024cac6, // n0x16ef c0x0000 (---------------)  + I fauske
	0x0024df85, // n0x16f0 c0x0000 (---------------)  + I fedje
	0x00343683, // n0x16f1 c0x0000 (---------------)  + I fet
	0x00343687, // n0x16f2 c0x0000 (---------------)  + I fetsund
	0x00233803, // n0x16f3 c0x0000 (---------------)  + I fhs
	0x0024c406, // n0x16f4 c0x0000 (---------------)  + I finnoy
	0x0024f586, // n0x16f5 c0x0000 (---------------)  + I fitjar
	0x00250246, // n0x16f6 c0x0000 (---------------)  + I fjaler
	0x00291145, // n0x16f7 c0x0000 (---------------)  + I fjell
	0x002659c3, // n0x16f8 c0x0000 (---------------)  + I fla
	0x0037e548, // n0x16f9 c0x0000 (---------------)  + I flakstad
	0x0031c809, // n0x16fa c0x0000 (---------------)  + I flatanger
	0x003654cb, // n0x16fb c0x0000 (---------------)  + I flekkefjord
	0x00376188, // n0x16fc c0x0000 (---------------)  + I flesberg
	0x002525c5, // n0x16fd c0x0000 (---------------)  + I flora
	0x002530c5, // n0x16fe c0x0000 (---------------)  + I floro
	0x3ce34802, // n0x16ff c0x00f3 (n0x195d-n0x195e)  + I fm
	0x00356a09, // n0x1700 c0x0000 (---------------)  + I folkebibl
	0x00256307, // n0x1701 c0x0000 (---------------)  + I folldal
	0x0039d385, // n0x1702 c0x0000 (---------------)  + I forde
	0x00259887, // n0x1703 c0x0000 (---------------)  + I forsand
	0x0025bd86, // n0x1704 c0x0000 (---------------)  + I fosnes
	0x0035d5c5, // n0x1705 c0x0000 (---------------)  + I frana
	0x0036498b, // n0x1706 c0x0000 (---------------)  + I fredrikstad
	0x0025c884, // n0x1707 c0x0000 (---------------)  + I frei
	0x00262085, // n0x1708 c0x0000 (---------------)  + I frogn
	0x002621c7, // n0x1709 c0x0000 (---------------)  + I froland
	0x00276806, // n0x170a c0x0000 (---------------)  + I frosta
	0x00276c45, // n0x170b c0x0000 (---------------)  + I froya
	0x00284007, // n0x170c c0x0000 (---------------)  + I fuoisku
	0x00284947, // n0x170d c0x0000 (---------------)  + I fuossko
	0x0028fd84, // n0x170e c0x0000 (---------------)  + I fusa
	0x0028b38a, // n0x170f c0x0000 (---------------)  + I fylkesbibl
	0x0028b848, // n0x1710 c0x0000 (---------------)  + I fyresdal
	0x003020c9, // n0x1711 c0x0000 (---------------)  + I gaivuotna
	0x00221fc5, // n0x1712 c0x0000 (---------------)  + I galsa
	0x002db486, // n0x1713 c0x0000 (---------------)  + I gamvik
	0x0031214a, // n0x1714 c0x0000 (---------------)  + I gangaviika
	0x00266a06, // n0x1715 c0x0000 (---------------)  + I gaular
	0x0026e5c7, // n0x1716 c0x0000 (---------------)  + I gausdal
	0x00301d8d, // n0x1717 c0x0000 (---------------)  + I giehtavuoatna
	0x00225509, // n0x1718 c0x0000 (---------------)  + I gildeskal
	0x00382fc5, // n0x1719 c0x0000 (---------------)  + I giske
	0x00313407, // n0x171a c0x0000 (---------------)  + I gjemnes
	0x003257c8, // n0x171b c0x0000 (---------------)  + I gjerdrum
	0x00354088, // n0x171c c0x0000 (---------------)  + I gjerstad
	0x0022b207, // n0x171d c0x0000 (---------------)  + I gjesdal
	0x00248b06, // n0x171e c0x0000 (---------------)  + I gjovik
	0x00212507, // n0x171f c0x0000 (---------------)  + I gloppen
	0x0024dec3, // n0x1720 c0x0000 (---------------)  + I gol
	0x00334204, // n0x1721 c0x0000 (---------------)  + I gran
	0x0035a405, // n0x1722 c0x0000 (---------------)  + I grane
	0x003833c7, // n0x1723 c0x0000 (---------------)  + I granvin
	0x00387089, // n0x1724 c0x0000 (---------------)  + I gratangen
	0x0021db48, // n0x1725 c0x0000 (---------------)  + I grimstad
	0x0026e4c5, // n0x1726 c0x0000 (---------------)  + I grong
	0x00314d04, // n0x1727 c0x0000 (---------------)  + I grue
	0x00235785, // n0x1728 c0x0000 (---------------)  + I gulen
	0x0034938d, // n0x1729 c0x0000 (---------------)  + I guovdageaidnu
	0x00202302, // n0x172a c0x0000 (---------------)  + I ha
	0x0036d3c6, // n0x172b c0x0000 (---------------)  + I habmer
	0x0025ab06, // n0x172c c0x0000 (---------------)  + I hadsel
	0x002a858a, // n0x172d c0x0000 (---------------)  + I hagebostad
	0x0035f986, // n0x172e c0x0000 (---------------)  + I halden
	0x0036cc85, // n0x172f c0x0000 (---------------)  + I halsa
	0x0026b145, // n0x1730 c0x0000 (---------------)  + I hamar
	0x0026b147, // n0x1731 c0x0000 (---------------)  + I hamaroy
	0x00374a0c, // n0x1732 c0x0000 (---------------)  + I hammarfeasta
	0x0027b64a, // n0x1733 c0x0000 (---------------)  + I hammerfest
	0x0028d0c6, // n0x1734 c0x0000 (---------------)  + I hapmir
	0x002d09c5, // n0x1735 c0x0000 (---------------)  + I haram
	0x0028d686, // n0x1736 c0x0000 (---------------)  + I hareid
	0x0028d9c7, // n0x1737 c0x0000 (---------------)  + I harstad
	0x0028ed06, // n0x1738 c0x0000 (---------------)  + I hasvik
	0x0029104c, // n0x1739 c0x0000 (---------------)  + I hattfjelldal
	0x00205749, // n0x173a c0x0000 (---------------)  + I haugesund
	0x3d236c07, // n0x173b c0x00f4 (n0x195e-n0x1961)  o I hedmark
	0x00292ac5, // n0x173c c0x0000 (---------------)  + I hemne
	0x00292ac6, // n0x173d c0x0000 (---------------)  + I hemnes
	0x00293008, // n0x173e c0x0000 (---------------)  + I hemsedal
	0x002b24c5, // n0x173f c0x0000 (---------------)  + I herad
	0x002a5bc5, // n0x1740 c0x0000 (---------------)  + I hitra
	0x002a5e08, // n0x1741 c0x0000 (---------------)  + I hjartdal
	0x002a600a, // n0x1742 c0x0000 (---------------)  + I hjelmeland
	0x3d6484c2, // n0x1743 c0x00f5 (n0x1961-n0x1962)  + I hl
	0x3da0fbc2, // n0x1744 c0x00f6 (n0x1962-n0x1963)  + I hm
	0x003770c5, // n0x1745 c0x0000 (---------------)  + I hobol
	0x002d7a43, // n0x1746 c0x0000 (---------------)  + I hof
	0x0036e648, // n0x1747 c0x0000 (---------------)  + I hokksund
	0x00231f43, // n0x1748 c0x0000 (---------------)  + I hol
	0x002a6284, // n0x1749 c0x0000 (---------------)  + I hole
	0x0029d6cb, // n0x174a c0x0000 (---------------)  + I holmestrand
	0x002afec8, // n0x174b c0x0000 (---------------)  + I holtalen
	0x002a8948, // n0x174c c0x0000 (---------------)  + I honefoss
	0x3df20f89, // n0x174d c0x00f7 (n0x1963-n0x1964)  o I hordaland
	0x002a9e09, // n0x174e c0x0000 (---------------)  + I hornindal
	0x002aa286, // n0x174f c0x0000 (---------------)  + I horten
	0x002ab288, // n0x1750 c0x0000 (---------------)  + I hoyanger
	0x002ab489, // n0x1751 c0x0000 (---------------)  + I hoylandet
	0x002ac4c6, // n0x1752 c0x0000 (---------------)  + I hurdal
	0x002ac645, // n0x1753 c0x0000 (---------------)  + I hurum
	0x00363d06, // n0x1754 c0x0000 (---------------)  + I hvaler
	0x002acb89, // n0x1755 c0x0000 (---------------)  + I hyllestad
	0x00354f47, // n0x1756 c0x0000 (---------------)  + I ibestad
	0x0026f346, // n0x1757 c0x0000 (---------------)  + I idrett
	0x0037cc07, // n0x1758 c0x0000 (---------------)  + I inderoy
	0x00351a47, // n0x1759 c0x0000 (---------------)  + I iveland
	0x00234e04, // n0x175a c0x0000 (---------------)  + I ivgu
	0x3e220ec9, // n0x175b c0x00f8 (n0x1964-n0x1965)  + I jan-mayen
	0x002c7148, // n0x175c c0x0000 (---------------)  + I jessheim
	0x00356248, // n0x175d c0x0000 (---------------)  + I jevnaker
	0x00232947, // n0x175e c0x0000 (---------------)  + I jolster
	0x002c2dc6, // n0x175f c0x0000 (---------------)  + I jondal
	0x002feb89, // n0x1760 c0x0000 (---------------)  + I jorpeland
	0x002be607, // n0x1761 c0x0000 (---------------)  + I kafjord
	0x0025b40a, // n0x1762 c0x0000 (---------------)  + I karasjohka
	0x002ee1c8, // n0x1763 c0x0000 (---------------)  + I karasjok
	0x00331787, // n0x1764 c0x0000 (---------------)  + I karlsoy
	0x00355346, // n0x1765 c0x0000 (---------------)  + I karmoy
	0x00229f0a, // n0x1766 c0x0000 (---------------)  + I kautokeino
	0x0027f108, // n0x1767 c0x0000 (---------------)  + I kirkenes
	0x00250905, // n0x1768 c0x0000 (---------------)  + I klabu
	0x00373485, // n0x1769 c0x0000 (---------------)  + I klepp
	0x00386347, // n0x176a c0x0000 (---------------)  + I kommune
	0x002d9089, // n0x176b c0x0000 (---------------)  + I kongsberg
	0x002c9e4b, // n0x176c c0x0000 (---------------)  + I kongsvinger
	0x002d6e88, // n0x176d c0x0000 (---------------)  + I kopervik
	0x0025da49, // n0x176e c0x0000 (---------------)  + I kraanghke
	0x002504c7, // n0x176f c0x0000 (---------------)  + I kragero
	0x002b1a4c, // n0x1770 c0x0000 (---------------)  + I kristiansand
	0x002b208c, // n0x1771 c0x0000 (---------------)  + I kristiansund
	0x002b238a, // n0x1772 c0x0000 (---------------)  + I krodsherad
	0x002b260c, // n0x1773 c0x0000 (---------------)  + I krokstadelva
	0x002bd648, // n0x1774 c0x0000 (---------------)  + I kvafjord
	0x002bd848, // n0x1775 c0x0000 (---------------)  + I kvalsund
	0x002bda44, // n0x1776 c0x0000 (---------------)  + I kvam
	0x002be7c9, // n0x1777 c0x0000 (---------------)  + I kvanangen
	0x002bea09, // n0x1778 c0x0000 (---------------)  + I kvinesdal
	0x002bec4a, // n0x1779 c0x0000 (---------------)  + I kvinnherad
	0x002beec9, // n0x177a c0x0000 (---------------)  + I kviteseid
	0x002bf207, // n0x177b c0x0000 (---------------)  + I kvitsoy
	0x003a580c, // n0x177c c0x0000 (---------------)  + I laakesvuemie
	0x00338106, // n0x177d c0x0000 (---------------)  + I lahppi
	0x00251688, // n0x177e c0x0000 (---------------)  + I langevag
	0x00266ac6, // n0x177f c0x0000 (---------------)  + I lardal
	0x0037d606, // n0x1780 c0x0000 (---------------)  + I larvik
	0x00382ec7, // n0x1781 c0x0000 (---------------)  + I lavagis
	0x002f3c48, // n0x1782 c0x0000 (---------------)  + I lavangen
	0x0026c2cb, // n0x1783 c0x0000 (---------------)  + I leangaviika
	0x002b9047, // n0x1784 c0x0000 (---------------)  + I lebesby
	0x00259649, // n0x1785 c0x0000 (---------------)  + I leikanger
	0x00281e49, // n0x1786 c0x0000 (---------------)  + I leirfjord
	0x0035da87, // n0x1787 c0x0000 (---------------)  + I leirvik
	0x002bdd04, // n0x1788 c0x0000 (---------------)  + I leka
	0x00382447, // n0x1789 c0x0000 (---------------)  + I leksvik
	0x00353546, // n0x178a c0x0000 (---------------)  + I lenvik
	0x00217446, // n0x178b c0x0000 (---------------)  + I lerdal
	0x00308c85, // n0x178c c0x0000 (---------------)  + I lesja
	0x002d1848, // n0x178d c0x0000 (---------------)  + I levanger
	0x002e38c4, // n0x178e c0x0000 (---------------)  + I lier
	0x002e38c6, // n0x178f c0x0000 (---------------)  + I lierne
	0x0027b50b, // n0x1790 c0x0000 (---------------)  + I lillehammer
	0x00330f89, // n0x1791 c0x0000 (---------------)  + I lillesand
	0x00312986, // n0x1792 c0x0000 (---------------)  + I lindas
	0x00320189, // n0x1793 c0x0000 (---------------)  + I lindesnes
	0x00387806, // n0x1794 c0x0000 (---------------)  + I loabat
	0x00259b48, // n0x1795 c0x0000 (---------------)  + I lodingen
	0x00214d03, // n0x1796 c0x0000 (---------------)  + I lom
	0x0038fe45, // n0x1797 c0x0000 (---------------)  + I loppa
	0x00217589, // n0x1798 c0x0000 (---------------)  + I lorenskog
	0x00218d45, // n0x1799 c0x0000 (---------------)  + I loten
	0x002e2ac4, // n0x179a c0x0000 (---------------)  + I lund
	0x00275106, // n0x179b c0x0000 (---------------)  + I lunner
	0x002322c5, // n0x179c c0x0000 (---------------)  + I luroy
	0x002dd446, // n0x179d c0x0000 (---------------)  + I luster
	0x002fb707, // n0x179e c0x0000 (---------------)  + I lyngdal
	0x00212f86, // n0x179f c0x0000 (---------------)  + I lyngen
	0x0029924b, // n0x17a0 c0x0000 (---------------)  + I malatvuopmi
	0x002e5bc7, // n0x17a1 c0x0000 (---------------)  + I malselv
	0x00206506, // n0x17a2 c0x0000 (---------------)  + I malvik
	0x00349e06, // n0x17a3 c0x0000 (---------------)  + I mandal
	0x00234106, // n0x17a4 c0x0000 (---------------)  + I marker
	0x00354989, // n0x17a5 c0x0000 (---------------)  + I marnardal
	0x0021cb8a, // n0x17a6 c0x0000 (---------------)  + I masfjorden
	0x0032f2c5, // n0x17a7 c0x0000 (---------------)  + I masoy
	0x0021f1cd, // n0x17a8 c0x0000 (---------------)  + I matta-varjjat
	0x002a6106, // n0x17a9 c0x0000 (---------------)  + I meland
	0x00213686, // n0x17aa c0x0000 (---------------)  + I meldal
	0x00287286, // n0x17ab c0x0000 (---------------)  + I melhus
	0x0029d385, // n0x17ac c0x0000 (---------------)  + I meloy
	0x0023ecc7, // n0x17ad c0x0000 (---------------)  + I meraker
	0x0029ee07, // n0x17ae c0x0000 (---------------)  + I midsund
	0x002e6bce, // n0x17af c0x0000 (---------------)  + I midtre-gauldal
	0x00207dc3, // n0x17b0 c0x0000 (---------------)  + I mil
	0x002c2d89, // n0x17b1 c0x0000 (---------------)  + I mjondalen
	0x00379389, // n0x17b2 c0x0000 (---------------)  + I mo-i-rana
	0x0022a887, // n0x17b3 c0x0000 (---------------)  + I moareke
	0x0026d447, // n0x17b4 c0x0000 (---------------)  + I modalen
	0x002a7945, // n0x17b5 c0x0000 (---------------)  + I modum
	0x00324b05, // n0x17b6 c0x0000 (---------------)  + I molde
	0x3e65cf8f, // n0x17b7 c0x00f9 (n0x1965-n0x1967)  o I more-og-romsdal
	0x002c9907, // n0x17b8 c0x0000 (---------------)  + I mosjoen
	0x002c9ac8, // n0x17b9 c0x0000 (---------------)  + I moskenes
	0x002ca104, // n0x17ba c0x0000 (---------------)  + I moss
	0x002ca446, // n0x17bb c0x0000 (---------------)  + I mosvik
	0x3ea4a142, // n0x17bc c0x00fa (n0x1967-n0x1968)  + I mr
	0x002cd886, // n0x17bd c0x0000 (---------------)  + I muosat
	0x002d1086, // n0x17be c0x0000 (---------------)  + I museum
	0x0026c60e, // n0x17bf c0x0000 (---------------)  + I naamesjevuemie
	0x0032a98a, // n0x17c0 c0x0000 (---------------)  + I namdalseid
	0x002b74c6, // n0x17c1 c0x0000 (---------------)  + I namsos
	0x0021fb0a, // n0x17c2 c0x0000 (---------------)  + I namsskogan
	0x002c5109, // n0x17c3 c0x0000 (---------------)  + I nannestad
	0x003183c5, // n0x17c4 c0x0000 (---------------)  + I naroy
	0x00389d88, // n0x17c5 c0x0000 (---------------)  + I narviika
	0x003a1306, // n0x17c6 c0x0000 (---------------)  + I narvik
	0x00330dc8, // n0x17c7 c0x0000 (---------------)  + I naustdal
	0x0030aa88, // n0x17c8 c0x0000 (---------------)  + I navuotna
	0x0032624b, // n0x17c9 c0x0000 (---------------)  + I nedre-eiker
	0x00226685, // n0x17ca c0x0000 (---------------)  + I nesna
	0x0022b6c8, // n0x17cb c0x0000 (---------------)  + I nesodden
	0x00205e8c, // n0x17cc c0x0000 (---------------)  + I nesoddtangen
	0x002b8407, // n0x17cd c0x0000 (---------------)  + I nesseby
	0x0024fdc6, // n0x17ce c0x0000 (---------------)  + I nesset
	0x0022eac8, // n0x17cf c0x0000 (---------------)  + I nissedal
	0x00279b48, // n0x17d0 c0x0000 (---------------)  + I nittedal
	0x3ee46d02, // n0x17d1 c0x00fb (n0x1968-n0x1969)  + I nl
	0x002bdf0b, // n0x17d2 c0x0000 (---------------)  + I nord-aurdal
	0x00397549, // n0x17d3 c0x0000 (---------------)  + I nord-fron
	0x00343249, // n0x17d4 c0x0000 (---------------)  + I nord-odal
	0x00382d47, // n0x17d5 c0x0000 (---------------)  + I norddal
	0x00248908, // n0x17d6 c0x0000 (---------------)  + I nordkapp
	0x3f31fdc8, // n0x17d7 c0x00fc (n0x1969-n0x196d)  o I nordland
	0x0026ba8b, // n0x17d8 c0x0000 (---------------)  + I nordre-land
	0x00286149, // n0x17d9 c0x0000 (---------------)  + I nordreisa
	0x0021194d, // n0x17da c0x0000 (---------------)  + I nore-og-uvdal
	0x003289c8, // n0x17db c0x0000 (---------------)  + I notodden
	0x0032d988, // n0x17dc c0x0000 (---------------)  + I notteroy
	0x3f601542, // n0x17dd c0x00fd (n0x196d-n0x196e)  + I nt
	0x003a40c4, // n0x17de c0x0000 (---------------)  + I odda
	0x3fa0ce82, // n0x17df c0x00fe (n0x196e-n0x196f)  + I of
	0x002ee346, // n0x17e0 c0x0000 (---------------)  + I oksnes
	0x3fe02102, // n0x17e1 c0x00ff (n0x196f-n0x1970)  + I ol
	0x0030604a, // n0x17e2 c0x0000 (---------------)  + I omasvuotna
	0x00357206, // n0x17e3 c0x0000 (---------------)  + I oppdal
	0x00221288, // n0x17e4 c0x0000 (---------------)  + I oppegard
	0x002566c8, // n0x17e5 c0x0000 (---------------)  + I orkanger
	0x002eadc6, // n0x17e6 c0x0000 (---------------)  + I orkdal
	0x003389c6, // n0x17e7 c0x0000 (---------------)  + I orland
	0x002e6086, // n0x17e8 c0x0000 (---------------)  + I orskog
	0x0027aec5, // n0x17e9 c0x0000 (---------------)  + I orsta
	0x00240e04, // n0x17ea c0x0000 (---------------)  + I osen
	0x402c5e84, // n0x17eb c0x0100 (n0x1970-n0x1971)  + I oslo
	0x00334dc6, // n0x17ec c0x0000 (---------------)  + I osoyro
	0x0024afc7, // n0x17ed c0x0000 (---------------)  + I osteroy
	0x40798d87, // n0x17ee c0x0101 (n0x1971-n0x1972)  o I ostfold
	0x002cf14b, // n0x17ef c0x0000 (---------------)  + I ostre-toten
	0x0026abc9, // n0x17f0 c0x0000 (---------------)  + I overhalla
	0x0026864a, // n0x17f1 c0x0000 (---------------)  + I ovre-eiker
	0x00319a44, // n0x17f2 c0x0000 (---------------)  + I oyer
	0x0026b288, // n0x17f3 c0x0000 (---------------)  + I oygarden
	0x0026f10d, // n0x17f4 c0x0000 (---------------)  + I oystre-slidre
	0x002dfc09, // n0x17f5 c0x0000 (---------------)  + I porsanger
	0x002dfe48, // n0x17f6 c0x0000 (---------------)  + I porsangu
	0x002e00c9, // n0x17f7 c0x0000 (---------------)  + I porsgrunn
	0x002e17c4, // n0x17f8 c0x0000 (---------------)  + I priv
	0x00205504, // n0x17f9 c0x0000 (---------------)  + I rade
	0x0027f9c5, // n0x17fa c0x0000 (---------------)  + I radoy
	0x0027700b, // n0x17fb c0x0000 (---------------)  + I rahkkeravju
	0x002afe46, // n0x17fc c0x0000 (---------------)  + I raholt
	0x00334c05, // n0x17fd c0x0000 (---------------)  + I raisa
	0x00356cc9, // n0x17fe c0x0000 (---------------)  + I rakkestad
	0x00226888, // n0x17ff c0x0000 (---------------)  + I ralingen
	0x002a0c04, // n0x1800 c0x0000 (---------------)  + I rana
	0x0022a609, // n0x1801 c0x0000 (---------------)  + I randaberg
	0x00248145, // n0x1802 c0x0000 (---------------)  + I rauma
	0x002b9988, // n0x1803 c0x0000 (---------------)  + I rendalen
	0x00208c87, // n0x1804 c0x0000 (---------------)  + I rennebu
	0x00312f48, // n0x1805 c0x0000 (---------------)  + I rennesoy
	0x0027ff86, // n0x1806 c0x0000 (---------------)  + I rindal
	0x0037b2c7, // n0x1807 c0x0000 (---------------)  + I ringebu
	0x0020f789, // n0x1808 c0x0000 (---------------)  + I ringerike
	0x00245d09, // n0x1809 c0x0000 (---------------)  + I ringsaker
	0x00277785, // n0x180a c0x0000 (---------------)  + I risor
	0x003789c5, // n0x180b c0x0000 (---------------)  + I rissa
	0x40a24dc2, // n0x180c c0x0102 (n0x1972-n0x1973)  + I rl
	0x002f9c84, // n0x180d c0x0000 (---------------)  + I roan
	0x0029e885, // n0x180e c0x0000 (---------------)  + I rodoy
	0x003017c6, // n0x180f c0x0000 (---------------)  + I rollag
	0x0031abc5, // n0x1810 c0x0000 (---------------)  + I romsa
	0x00253187, // n0x1811 c0x0000 (---------------)  + I romskog
	0x00297a45, // n0x1812 c0x0000 (---------------)  + I roros
	0x00276844, // n0x1813 c0x0000 (---------------)  + I rost
	0x003306c6, // n0x1814 c0x0000 (---------------)  + I royken
	0x0032ad87, // n0x1815 c0x0000 (---------------)  + I royrvik
	0x0024a186, // n0x1816 c0x0000 (---------------)  + I ruovat
	0x003314c5, // n0x1817 c0x0000 (---------------)  + I rygge
	0x0030a688, // n0x1818 c0x0000 (---------------)  + I salangen
	0x00226e05, // n0x1819 c0x0000 (---------------)  + I salat
	0x00312807, // n0x181a c0x0000 (---------------)  + I saltdal
	0x00344a49, // n0x181b c0x0000 (---------------)  + I samnanger
	0x003310ca, // n0x181c c0x0000 (---------------)  + I sandefjord
	0x00348847, // n0x181d c0x0000 (---------------)  + I sandnes
	0x0034884c, // n0x181e c0x0000 (---------------)  + I sandnessjoen
	0x00229386, // n0x181f c0x0000 (---------------)  + I sandoy
	0x002285c9, // n0x1820 c0x0000 (---------------)  + I sarpsborg
	0x0032b205, // n0x1821 c0x0000 (---------------)  + I sauda
	0x0034f988, // n0x1822 c0x0000 (---------------)  + I sauherad
	0x00212383, // n0x1823 c0x0000 (---------------)  + I sel
	0x00212385, // n0x1824 c0x0000 (---------------)  + I selbu
	0x00335945, // n0x1825 c0x0000 (---------------)  + I selje
	0x0023c187, // n0x1826 c0x0000 (---------------)  + I seljord
	0x40e10842, // n0x1827 c0x0103 (n0x1973-n0x1974)  + I sf
	0x0023ba87, // n0x1828 c0x0000 (---------------)  + I siellak
	0x002c6246, // n0x1829 c0x0000 (---------------)  + I sigdal
	0x00220e06, // n0x182a c0x0000 (---------------)  + I siljan
	0x002ccf46, // n0x182b c0x0000 (---------------)  + I sirdal
	0x00279a86, // n0x182c c0x0000 (---------------)  + I skanit
	0x00307ec8, // n0x182d c0x0000 (---------------)  + I skanland
	0x0024e845, // n0x182e c0x0000 (---------------)  + I skaun
	0x0024cb87, // n0x182f c0x0000 (---------------)  + I skedsmo
	0x0024cb8d, // n0x1830 c0x0000 (---------------)  + I skedsmokorset
	0x00208503, // n0x1831 c0x0000 (---------------)  + I ski
	0x00208505, // n0x1832 c0x0000 (---------------)  + I skien
	0x00229a87, // n0x1833 c0x0000 (---------------)  + I skierva
	0x002d3188, // n0x1834 c0x0000 (---------------)  + I skiptvet
	0x00229645, // n0x1835 c0x0000 (---------------)  + I skjak
	0x00230988, // n0x1836 c0x0000 (---------------)  + I skjervoy
	0x0026dfc6, // n0x1837 c0x0000 (---------------)  + I skodje
	0x00262fc7, // n0x1838 c0x0000 (---------------)  + I slattum
	0x002c1cc5, // n0x1839 c0x0000 (---------------)  + I smola
	0x00226706, // n0x183a c0x0000 (---------------)  + I snaase
	0x00360ac5, // n0x183b c0x0000 (---------------)  + I snasa
	0x002bcd4a, // n0x183c c0x0000 (---------------)  + I snillfjord
	0x00373786, // n0x183d c0x0000 (---------------)  + I snoasa
	0x00234a47, // n0x183e c0x0000 (---------------)  + I sogndal
	0x002bd505, // n0x183f c0x0000 (---------------)  + I sogne
	0x002d8a87, // n0x1840 c0x0000 (---------------)  + I sokndal
	0x002e0984, // n0x1841 c0x0000 (---------------)  + I sola
	0x002e2a46, // n0x1842 c0x0000 (---------------)  + I solund
	0x0035bc85, // n0x1843 c0x0000 (---------------)  + I somna
	0x002b800b, // n0x1844 c0x0000 (---------------)  + I sondre-land
	0x003533c9, // n0x1845 c0x0000 (---------------)  + I songdalen
	0x002da24a, // n0x1846 c0x0000 (---------------)  + I sor-aurdal
	0x00277808, // n0x1847 c0x0000 (---------------)  + I sor-fron
	0x003177c8, // n0x1848 c0x0000 (---------------)  + I sor-odal
	0x002ef68c, // n0x1849 c0x0000 (---------------)  + I sor-varanger
	0x002efec7, // n0x184a c0x0000 (---------------)  + I sorfold
	0x002f2488, // n0x184b c0x0000 (---------------)  + I sorreisa
	0x002fa788, // n0x184c c0x0000 (---------------)  + I sortland
	0x002fc305, // n0x184d c0x0000 (---------------)  + I sorum
	0x002bf48a, // n0x184e c0x0000 (---------------)  + I spjelkavik
	0x00332909, // n0x184f c0x0000 (---------------)  + I spydeberg
	0x41202602, // n0x1850 c0x0104 (n0x1974-n0x1975)  + I st
	0x00202606, // n0x1851 c0x0000 (---------------)  + I stange
	0x0020a204, // n0x1852 c0x0000 (---------------)  + I stat
	0x002de689, // n0x1853 c0x0000 (---------------)  + I stathelle
	0x00254209, // n0x1854 c0x0000 (---------------)  + I stavanger
	0x0021b107, // n0x1855 c0x0000 (---------------)  + I stavern
	0x0024f3c7, // n0x1856 c0x0000 (---------------)  + I steigen
	0x00280c09, // n0x1857 c0x0000 (---------------)  + I steinkjer
	0x0038d988, // n0x1858 c0x0000 (---------------)  + I stjordal
	0x0038d98f, // n0x1859 c0x0000 (---------------)  + I stjordalshalsen
	0x00275c46, // n0x185a c0x0000 (---------------)  + I stokke
	0x0024280b, // n0x185b c0x0000 (---------------)  + I stor-elvdal
	0x0035b185, // n0x185c c0x0000 (---------------)  + I stord
	0x0035b187, // n0x185d c0x0000 (---------------)  + I stordal
	0x0037c2c9, // n0x185e c0x0000 (---------------)  + I storfjord
	0x0022a586, // n0x185f c0x0000 (---------------)  + I strand
	0x0022a587, // n0x1860 c0x0000 (---------------)  + I stranda
	0x003a37c5, // n0x1861 c0x0000 (---------------)  + I stryn
	0x00237984, // n0x1862 c0x0000 (---------------)  + I sula
	0x00235406, // n0x1863 c0x0000 (---------------)  + I suldal
	0x00200704, // n0x1864 c0x0000 (---------------)  + I sund
	0x0030d887, // n0x1865 c0x0000 (---------------)  + I sunndal
	0x002e9388, // n0x1866 c0x0000 (---------------)  + I surnadal
	0x416eaf48, // n0x1867 c0x0105 (n0x1975-n0x1976)  + I svalbard
	0x002eb545, // n0x1868 c0x0000 (---------------)  + I sveio
	0x002eb687, // n0x1869 c0x0000 (---------------)  + I svelvik
	0x003684c9, // n0x186a c0x0000 (---------------)  + I sykkylven
	0x00203c44, // n0x186b c0x0000 (---------------)  + I tana
	0x00203c48, // n0x186c c0x0000 (---------------)  + I tananger
	0x41a64dc8, // n0x186d c0x0106 (n0x1976-n0x1978)  o I telemark
	0x00219dc4, // n0x186e c0x0000 (---------------)  + I time
	0x00238488, // n0x186f c0x0000 (---------------)  + I tingvoll
	0x002dca04, // n0x1870 c0x0000 (---------------)  + I tinn
	0x0023e5c9, // n0x1871 c0x0000 (---------------)  + I tjeldsund
	0x0036e185, // n0x1872 c0x0000 (---------------)  + I tjome
	0x41e00c82, // n0x1873 c0x0107 (n0x1978-n0x1979)  + I tm
	0x00275c85, // n0x1874 c0x0000 (---------------)  + I tokke
	0x00221f05, // n0x1875 c0x0000 (---------------)  + I tolga
	0x0035ebc8, // n0x1876 c0x0000 (---------------)  + I tonsberg
	0x00239f07, // n0x1877 c0x0000 (---------------)  + I torsken
	0x42203902, // n0x1878 c0x0108 (n0x1979-n0x197a)  + I tr
	0x002cb4c5, // n0x1879 c0x0000 (---------------)  + I trana
	0x002847c6, // n0x187a c0x0000 (---------------)  + I tranby
	0x002960c6, // n0x187b c0x0000 (---------------)  + I tranoy
	0x002f9c48, // n0x187c c0x0000 (---------------)  + I troandin
	0x002fe2c8, // n0x187d c0x0000 (---------------)  + I trogstad
	0x0031ab86, // n0x187e c0x0000 (---------------)  + I tromsa
	0x00322446, // n0x187f c0x0000 (---------------)  + I tromso
	0x00357709, // n0x1880 c0x0000 (---------------)  + I trondheim
	0x00358346, // n0x1881 c0x0000 (---------------)  + I trysil
	0x0024910b, // n0x1882 c0x0000 (---------------)  + I tvedestrand
	0x0024fbc5, // n0x1883 c0x0000 (---------------)  + I tydal
	0x0021f706, // n0x1884 c0x0000 (---------------)  + I tynset
	0x0039f5c8, // n0x1885 c0x0000 (---------------)  + I tysfjord
	0x00233406, // n0x1886 c0x0000 (---------------)  + I tysnes
	0x00236546, // n0x1887 c0x0000 (---------------)  + I tysvar
	0x00215b8a, // n0x1888 c0x0000 (---------------)  + I ullensaker
	0x00343e0a, // n0x1889 c0x0000 (---------------)  + I ullensvang
	0x0028d385, // n0x188a c0x0000 (---------------)  + I ulvik
	0x002c9407, // n0x188b c0x0000 (---------------)  + I unjarga
	0x00341f46, // n0x188c c0x0000 (---------------)  + I utsira
	0x42600c02, // n0x188d c0x0109 (n0x197a-n0x197b)  + I va
	0x00229bc7, // n0x188e c0x0000 (---------------)  + I vaapste
	0x00274545, // n0x188f c0x0000 (---------------)  + I vadso
	0x003120c4, // n0x1890 c0x0000 (---------------)  + I vaga
	0x003120c5, // n0x1891 c0x0000 (---------------)  + I vagan
	0x00319946, // n0x1892 c0x0000 (---------------)  + I vagsoy
	0x0032e2c7, // n0x1893 c0x0000 (---------------)  + I vaksdal
	0x00216c85, // n0x1894 c0x0000 (---------------)  + I valle
	0x002542c4, // n0x1895 c0x0000 (---------------)  + I vang
	0x00270708, // n0x1896 c0x0000 (---------------)  + I vanylven
	0x00236605, // n0x1897 c0x0000 (---------------)  + I vardo
	0x00293687, // n0x1898 c0x0000 (---------------)  + I varggat
	0x00358ac5, // n0x1899 c0x0000 (---------------)  + I varoy
	0x00214ac5, // n0x189a c0x0000 (---------------)  + I vefsn
	0x0023dfc4, // n0x189b c0x0000 (---------------)  + I vega
	0x0028c9c9, // n0x189c c0x0000 (---------------)  + I vegarshei
	0x002e24c8, // n0x189d c0x0000 (---------------)  + I vennesla
	0x00372686, // n0x189e c0x0000 (---------------)  + I verdal
	0x00342546, // n0x189f c0x0000 (---------------)  + I verran
	0x00219ac6, // n0x18a0 c0x0000 (---------------)  + I vestby
	0x42b9be88, // n0x18a1 c0x010a (n0x197b-n0x197c)  o I vestfold
	0x002ef507, // n0x18a2 c0x0000 (---------------)  + I vestnes
	0x002ef98d, // n0x18a3 c0x0000 (---------------)  + I vestre-slidre
	0x002f008c, // n0x18a4 c0x0000 (---------------)  + I vestre-toten
	0x002f0689, // n0x18a5 c0x0000 (---------------)  + I vestvagoy
	0x002f08c9, // n0x18a6 c0x0000 (---------------)  + I vevelstad
	0x42f4d602, // n0x18a7 c0x010b (n0x197c-n0x197d)  + I vf
	0x0039adc3, // n0x18a8 c0x0000 (---------------)  + I vgs
	0x002065c3, // n0x18a9 c0x0000 (---------------)  + I vik
	0x00353605, // n0x18aa c0x0000 (---------------)  + I vikna
	0x003834ca, // n0x18ab c0x0000 (---------------)  + I vindafjord
	0x0031aa46, // n0x18ac c0x0000 (---------------)  + I voagat
	0x002f8945, // n0x18ad c0x0000 (---------------)  + I volda
	0x002fbc44, // n0x18ae c0x0000 (---------------)  + I voss
	0x002fbc4b, // n0x18af c0x0000 (---------------)  + I vossevangen
	0x0030f7cc, // n0x18b0 c0x0000 (---------------)  + I xn--andy-ira
	0x0031000c, // n0x18b1 c0x0000 (---------------)  + I xn--asky-ira
	0x00310315, // n0x18b2 c0x0000 (---------------)  + I xn--aurskog-hland-jnb
	0x003138cd, // n0x18b3 c0x0000 (---------------)  + I xn--avery-yua
	0x00314e0f, // n0x18b4 c0x0000 (---------------)  + I xn--bdddj-mrabd
	0x003151d2, // n0x18b5 c0x0000 (---------------)  + I xn--bearalvhki-y4a
	0x0031564f, // n0x18b6 c0x0000 (---------------)  + I xn--berlevg-jxa
	0x00315a12, // n0x18b7 c0x0000 (---------------)  + I xn--bhcavuotna-s4a
	0x00315e93, // n0x18b8 c0x0000 (---------------)  + I xn--bhccavuotna-k7a
	0x0031634d, // n0x18b9 c0x0000 (---------------)  + I xn--bidr-5nac
	0x0031690d, // n0x18ba c0x0000 (---------------)  + I xn--bievt-0qa
	0x00316c8e, // n0x18bb c0x0000 (---------------)  + I xn--bjarky-fya
	0x0031714e, // n0x18bc c0x0000 (---------------)  + I xn--bjddar-pta
	0x003179cc, // n0x18bd c0x0000 (---------------)  + I xn--blt-elab
	0x00317d4c, // n0x18be c0x0000 (---------------)  + I xn--bmlo-gra
	0x0031818b, // n0x18bf c0x0000 (---------------)  + I xn--bod-2na
	0x0031850e, // n0x18c0 c0x0000 (---------------)  + I xn--brnny-wuac
	0x00319f52, // n0x18c1 c0x0000 (---------------)  + I xn--brnnysund-m8ac
	0x0031a80c, // n0x18c2 c0x0000 (---------------)  + I xn--brum-voa
	0x0031af50, // n0x18c3 c0x0000 (---------------)  + I xn--btsfjord-9za
	0x0032b352, // n0x18c4 c0x0000 (---------------)  + I xn--davvenjrga-y4a
	0x0032c20c, // n0x18c5 c0x0000 (---------------)  + I xn--dnna-gra
	0x0032c8cd, // n0x18c6 c0x0000 (---------------)  + I xn--drbak-wua
	0x0032cc0c, // n0x18c7 c0x0000 (---------------)  + I xn--dyry-ira
	0x0032e751, // n0x18c8 c0x0000 (---------------)  + I xn--eveni-0qa01ga
	0x0032f70d, // n0x18c9 c0x0000 (---------------)  + I xn--finny-yua
	0x00332e4d, // n0x18ca c0x0000 (---------------)  + I xn--fjord-lra
	0x0033344a, // n0x18cb c0x0000 (---------------)  + I xn--fl-zia
	0x003336cc, // n0x18cc c0x0000 (---------------)  + I xn--flor-jra
	0x00333fcc, // n0x18cd c0x0000 (---------------)  + I xn--frde-gra
	0x0033490c, // n0x18ce c0x0000 (---------------)  + I xn--frna-woa
	0x0033518c, // n0x18cf c0x0000 (---------------)  + I xn--frya-hra
	0x00338b53, // n0x18d0 c0x0000 (---------------)  + I xn--ggaviika-8ya47h
	0x00339150, // n0x18d1 c0x0000 (---------------)  + I xn--gildeskl-g0a
	0x00339550, // n0x18d2 c0x0000 (---------------)  + I xn--givuotna-8ya
	0x00339e4d, // n0x18d3 c0x0000 (---------------)  + I xn--gjvik-wua
	0x0033a44c, // n0x18d4 c0x0000 (---------------)  + I xn--gls-elac
	0x0033b409, // n0x18d5 c0x0000 (---------------)  + I xn--h-2fa
	0x0033d90d, // n0x18d6 c0x0000 (---------------)  + I xn--hbmer-xqa
	0x0033dc53, // n0x18d7 c0x0000 (---------------)  + I xn--hcesuolo-7ya35b
	0x0033e851, // n0x18d8 c0x0000 (---------------)  + I xn--hgebostad-g3a
	0x0033ec93, // n0x18d9 c0x0000 (---------------)  + I xn--hmmrfeasta-s4ac
	0x0033fb8f, // n0x18da c0x0000 (---------------)  + I xn--hnefoss-q1a
	0x0033ff4c, // n0x18db c0x0000 (---------------)  + I xn--hobl-ira
	0x0034024f, // n0x18dc c0x0000 (---------------)  + I xn--holtlen-hxa
	0x0034060d, // n0x18dd c0x0000 (---------------)  + I xn--hpmir-xqa
	0x00340c0f, // n0x18de c0x0000 (---------------)  + I xn--hyanger-q1a
	0x00340fd0, // n0x18df c0x0000 (---------------)  + I xn--hylandet-54a
	0x00341a4e, // n0x18e0 c0x0000 (---------------)  + I xn--indery-fya
	0x00344c8e, // n0x18e1 c0x0000 (---------------)  + I xn--jlster-bya
	0x003453d0, // n0x18e2 c0x0000 (---------------)  + I xn--jrpeland-54a
	0x0034650d, // n0x18e3 c0x0000 (---------------)  + I xn--karmy-yua
	0x00346e8e, // n0x18e4 c0x0000 (---------------)  + I xn--kfjord-iua
	0x0034720c, // n0x18e5 c0x0000 (---------------)  + I xn--klbu-woa
	0x003482d3, // n0x18e6 c0x0000 (---------------)  + I xn--koluokta-7ya57h
	0x00349f8e, // n0x18e7 c0x0000 (---------------)  + I xn--krager-gya
	0x0034bb50, // n0x18e8 c0x0000 (---------------)  + I xn--kranghke-b0a
	0x0034bf51, // n0x18e9 c0x0000 (---------------)  + I xn--krdsherad-m8a
	0x0034c38f, // n0x18ea c0x0000 (---------------)  + I xn--krehamn-dxa
	0x0034c753, // n0x18eb c0x0000 (---------------)  + I xn--krjohka-hwab49j
	0x0034d18d, // n0x18ec c0x0000 (---------------)  + I xn--ksnes-uua
	0x0034d4cf, // n0x18ed c0x0000 (---------------)  + I xn--kvfjord-nxa
	0x0034d88e, // n0x18ee c0x0000 (---------------)  + I xn--kvitsy-fya
	0x0034e0d0, // n0x18ef c0x0000 (---------------)  + I xn--kvnangen-k0a
	0x0034e4c9, // n0x18f0 c0x0000 (---------------)  + I xn--l-1fa
	0x00350310, // n0x18f1 c0x0000 (---------------)  + I xn--laheadju-7ya
	0x0035094f, // n0x18f2 c0x0000 (---------------)  + I xn--langevg-jxa
	0x00350fcf, // n0x18f3 c0x0000 (---------------)  + I xn--ldingen-q1a
	0x00351392, // n0x18f4 c0x0000 (---------------)  + I xn--leagaviika-52b
	0x00355b4e, // n0x18f5 c0x0000 (---------------)  + I xn--lesund-hua
	0x0035644d, // n0x18f6 c0x0000 (---------------)  + I xn--lgrd-poac
	0x00357a8d, // n0x18f7 c0x0000 (---------------)  + I xn--lhppi-xqa
	0x00357dcd, // n0x18f8 c0x0000 (---------------)  + I xn--linds-pra
	0x0035918d, // n0x18f9 c0x0000 (---------------)  + I xn--loabt-0qa
	0x003594cd, // n0x18fa c0x0000 (---------------)  + I xn--lrdal-sra
	0x00359810, // n0x18fb c0x0000 (---------------)  + I xn--lrenskog-54a
	0x00359c0b, // n0x18fc c0x0000 (---------------)  + I xn--lt-liac
	0x0035a1cc, // n0x18fd c0x0000 (---------------)  + I xn--lten-gra
	0x0035a54c, // n0x18fe c0x0000 (---------------)  + I xn--lury-ira
	0x0035a84c, // n0x18ff c0x0000 (---------------)  + I xn--mely-ira
	0x0035ab4e, // n0x1900 c0x0000 (---------------)  + I xn--merker-kua
	0x00366d90, // n0x1901 c0x0000 (---------------)  + I xn--mjndalen-64a
	0x00368c92, // n0x1902 c0x0000 (---------------)  + I xn--mlatvuopmi-s4a
	0x0036910b, // n0x1903 c0x0000 (---------------)  + I xn--mli-tla
	0x00369b8e, // n0x1904 c0x0000 (---------------)  + I xn--mlselv-iua
	0x00369f0e, // n0x1905 c0x0000 (---------------)  + I xn--moreke-jua
	0x0036ac0e, // n0x1906 c0x0000 (---------------)  + I xn--mosjen-eya
	0x0036b34b, // n0x1907 c0x0000 (---------------)  + I xn--mot-tla
	0x4336b916, // n0x1908 c0x010c (n0x197d-n0x197f)  o I xn--mre-og-romsdal-qqb
	0x0036c98d, // n0x1909 c0x0000 (---------------)  + I xn--msy-ula0h
	0x0036d554, // n0x190a c0x0000 (---------------)  + I xn--mtta-vrjjat-k7af
	0x0036e84d, // n0x190b c0x0000 (---------------)  + I xn--muost-0qa
	0x00370215, // n0x190c c0x0000 (---------------)  + I xn--nmesjevuemie-tcba
	0x0037160d, // n0x190d c0x0000 (---------------)  + I xn--nry-yla5g
	0x00371f8f, // n0x190e c0x0000 (---------------)  + I xn--nttery-byae
	0x0037280f, // n0x190f c0x0000 (---------------)  + I xn--nvuotna-hwa
	0x0037638f, // n0x1910 c0x0000 (---------------)  + I xn--oppegrd-ixa
	0x0037674e, // n0x1911 c0x0000 (---------------)  + I xn--ostery-fya
	0x0037778d, // n0x1912 c0x0000 (---------------)  + I xn--osyro-wua
	0x0037a291, // n0x1913 c0x0000 (---------------)  + I xn--porsgu-sta26f
	0x0037cdcc, // n0x1914 c0x0000 (---------------)  + I xn--rady-ira
	0x0037d0cc, // n0x1915 c0x0000 (---------------)  + I xn--rdal-poa
	0x0037d3cb, // n0x1916 c0x0000 (---------------)  + I xn--rde-ula
	0x0037d98c, // n0x1917 c0x0000 (---------------)  + I xn--rdy-0nab
	0x0037dd4f, // n0x1918 c0x0000 (---------------)  + I xn--rennesy-v1a
	0x0037e112, // n0x1919 c0x0000 (---------------)  + I xn--rhkkervju-01af
	0x0037eacd, // n0x191a c0x0000 (---------------)  + I xn--rholt-mra
	0x0037fa8c, // n0x191b c0x0000 (---------------)  + I xn--risa-5na
	0x0037ff0c, // n0x191c c0x0000 (---------------)  + I xn--risr-ira
	0x0038020d, // n0x191d c0x0000 (---------------)  + I xn--rland-uua
	0x0038054f, // n0x191e c0x0000 (---------------)  + I xn--rlingen-mxa
	0x0038090e, // n0x191f c0x0000 (---------------)  + I xn--rmskog-bya
	0x0038318c, // n0x1920 c0x0000 (---------------)  + I xn--rros-gra
	0x0038374d, // n0x1921 c0x0000 (---------------)  + I xn--rskog-uua
	0x00383a8b, // n0x1922 c0x0000 (---------------)  + I xn--rst-0na
	0x0038404c, // n0x1923 c0x0000 (---------------)  + I xn--rsta-fra
	0x003845cd, // n0x1924 c0x0000 (---------------)  + I xn--ryken-vua
	0x0038490e, // n0x1925 c0x0000 (---------------)  + I xn--ryrvik-bya
	0x00384d89, // n0x1926 c0x0000 (---------------)  + I xn--s-1fa
	0x00385a93, // n0x1927 c0x0000 (---------------)  + I xn--sandnessjen-ogb
	0x0038650d, // n0x1928 c0x0000 (---------------)  + I xn--sandy-yua
	0x0038684d, // n0x1929 c0x0000 (---------------)  + I xn--seral-lra
	0x00386e4c, // n0x192a c0x0000 (---------------)  + I xn--sgne-gra
	0x003872ce, // n0x192b c0x0000 (---------------)  + I xn--skierv-uta
	0x00388d4f, // n0x192c c0x0000 (---------------)  + I xn--skjervy-v1a
	0x0038910c, // n0x192d c0x0000 (---------------)  + I xn--skjk-soa
	0x0038940d, // n0x192e c0x0000 (---------------)  + I xn--sknit-yqa
	0x0038974f, // n0x192f c0x0000 (---------------)  + I xn--sknland-fxa
	0x00389b0c, // n0x1930 c0x0000 (---------------)  + I xn--slat-5na
	0x0038a20c, // n0x1931 c0x0000 (---------------)  + I xn--slt-elab
	0x0038a5cc, // n0x1932 c0x0000 (---------------)  + I xn--smla-hra
	0x0038a8cc, // n0x1933 c0x0000 (---------------)  + I xn--smna-gra
	0x0038af8d, // n0x1934 c0x0000 (---------------)  + I xn--snase-nra
	0x0038b2d2, // n0x1935 c0x0000 (---------------)  + I xn--sndre-land-0cb
	0x0038b94c, // n0x1936 c0x0000 (---------------)  + I xn--snes-poa
	0x0038bc4c, // n0x1937 c0x0000 (---------------)  + I xn--snsa-roa
	0x0038bf51, // n0x1938 c0x0000 (---------------)  + I xn--sr-aurdal-l8a
	0x0038c38f, // n0x1939 c0x0000 (---------------)  + I xn--sr-fron-q1a
	0x0038c74f, // n0x193a c0x0000 (---------------)  + I xn--sr-odal-q1a
	0x0038cb13, // n0x193b c0x0000 (---------------)  + I xn--sr-varanger-ggb
	0x0038e38e, // n0x193c c0x0000 (---------------)  + I xn--srfold-bya
	0x0038e90f, // n0x193d c0x0000 (---------------)  + I xn--srreisa-q1a
	0x0038eccc, // n0x193e c0x0000 (---------------)  + I xn--srum-gra
	0x4378f00e, // n0x193f c0x010d (n0x197f-n0x1980)  o I xn--stfold-9xa
	0x0038f38f, // n0x1940 c0x0000 (---------------)  + I xn--stjrdal-s1a
	0x0038f756, // n0x1941 c0x0000 (---------------)  + I xn--stjrdalshalsen-sqb
	0x00390252, // n0x1942 c0x0000 (---------------)  + I xn--stre-toten-zcb
	0x003918cc, // n0x1943 c0x0000 (---------------)  + I xn--tjme-hra
	0x0039208f, // n0x1944 c0x0000 (---------------)  + I xn--tnsberg-q1a
	0x0039270d, // n0x1945 c0x0000 (---------------)  + I xn--trany-yua
	0x00392a4f, // n0x1946 c0x0000 (---------------)  + I xn--trgstad-r1a
	0x00392e0c, // n0x1947 c0x0000 (---------------)  + I xn--trna-woa
	0x0039310d, // n0x1948 c0x0000 (---------------)  + I xn--troms-zua
	0x0039344d, // n0x1949 c0x0000 (---------------)  + I xn--tysvr-vra
	0x00394cce, // n0x194a c0x0000 (---------------)  + I xn--unjrga-rta
	0x0039604c, // n0x194b c0x0000 (---------------)  + I xn--vads-jra
	0x0039634c, // n0x194c c0x0000 (---------------)  + I xn--vard-jra
	0x00396650, // n0x194d c0x0000 (---------------)  + I xn--vegrshei-c0a
	0x0039a251, // n0x194e c0x0000 (---------------)  + I xn--vestvgy-ixa6o
	0x0039a68b, // n0x194f c0x0000 (---------------)  + I xn--vg-yiab
	0x0039a9cc, // n0x1950 c0x0000 (---------------)  + I xn--vgan-qoa
	0x0039acce, // n0x1951 c0x0000 (---------------)  + I xn--vgsy-qoa0j
	0x0039c391, // n0x1952 c0x0000 (---------------)  + I xn--vre-eiker-k8a
	0x0039c7ce, // n0x1953 c0x0000 (---------------)  + I xn--vrggt-xqad
	0x0039cb4d, // n0x1954 c0x0000 (---------------)  + I xn--vry-yla5g
	0x003a10cb, // n0x1955 c0x0000 (---------------)  + I xn--yer-zna
	0x003a19cf, // n0x1956 c0x0000 (---------------)  + I xn--ygarden-p1a
	0x003a2a94, // n0x1957 c0x0000 (---------------)  + I xn--ystre-slidre-ujb
	0x00245dc2, // n0x1958 c0x0000 (---------------)  + I gs
	0x00245dc2, // n0x1959 c0x0000 (---------------)  + I gs
	0x00202ac3, // n0x195a c0x0000 (---------------)  + I nes
	0x00245dc2, // n0x195b c0x0000 (---------------)  + I gs
	0x00202ac3, // n0x195c c0x0000 (---------------)  + I nes
	0x00245dc2, // n0x195d c0x0000 (---------------)  + I gs
	0x00209f02, // n0x195e c0x0000 (---------------)  + I os
	0x00363d45, // n0x195f c0x0000 (---------------)  + I valer
	0x0039c08c, // n0x1960 c0x0000 (---------------)  + I xn--vler-qoa
	0x00245dc2, // n0x1961 c0x0000 (---------------)  + I gs
	0x00245dc2, // n0x1962 c0x0000 (---------------)  + I gs
	0x00209f02, // n0x1963 c0x0000 (---------------)  + I os
	0x00245dc2, // n0x1964 c0x0000 (---------------)  + I gs
	0x00293485, // n0x1965 c0x0000 (---------------)  + I heroy
	0x003310c5, // n0x1966 c0x0000 (---------------)  + I sande
	0x00245dc2, // n0x1967 c0x0000 (---------------)  + I gs
	0x00245dc2, // n0x1968 c0x0000 (---------------)  + I gs
	0x0020f682, // n0x1969 c0x0000 (---------------)  + I bo
	0x00293485, // n0x196a c0x0000 (---------------)  + I heroy
	0x00313e09, // n0x196b c0x0000 (---------------)  + I xn--b-5ga
	0x0033e54c, // n0x196c c0x0000 (---------------)  + I xn--hery-ira
	0x00245dc2, // n0x196d c0x0000 (---------------)  + I gs
	0x00245dc2, // n0x196e c0x0000 (---------------)  + I gs
	0x00245dc2, // n0x196f c0x0000 (---------------)  + I gs
	0x00245dc2, // n0x1970 c0x0000 (---------------)  + I gs
	0x00363d45, // n0x1971 c0x0000 (---------------)  + I valer
	0x00245dc2, // n0x1972 c0x0000 (---------------)  + I gs
	0x00245dc2, // n0x1973 c0x0000 (---------------)  + I gs
	0x00245dc2, // n0x1974 c0x0000 (---------------)  + I gs
	0x00245dc2, // n0x1975 c0x0000 (---------------)  + I gs
	0x0020f682, // n0x1976 c0x0000 (---------------)  + I bo
	0x00313e09, // n0x1977 c0x0000 (---------------)  + I xn--b-5ga
	0x00245dc2, // n0x1978 c0x0000 (---------------)  + I gs
	0x00245dc2, // n0x1979 c0x0000 (---------------)  + I gs
	0x00245dc2, // n0x197a c0x0000 (---------------)  + I gs
	0x003310c5, // n0x197b c0x0000 (---------------)  + I sande
	0x00245dc2, // n0x197c c0x0000 (---------------)  + I gs
	0x003310c5, // n0x197d c0x0000 (---------------)  + I sande
	0x0033e54c, // n0x197e c0x0000 (---------------)  + I xn--hery-ira
	0x0039c08c, // n0x197f c0x0000 (---------------)  + I xn--vler-qoa
	0x00331a83, // n0x1980 c0x0000 (---------------)  + I biz
	0x00233243, // n0x1981 c0x0000 (---------------)  + I com
	0x00239103, // n0x1982 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1983 c0x0000 (---------------)  + I gov
	0x00201844, // n0x1984 c0x0000 (---------------)  + I info
	0x00223b43, // n0x1985 c0x0000 (---------------)  + I net
	0x00228743, // n0x1986 c0x0000 (---------------)  + I org
	0x00128008, // n0x1987 c0x0000 (---------------)  +   merseine
	0x000aa184, // n0x1988 c0x0000 (---------------)  +   mine
	0x0015cc08, // n0x1989 c0x0000 (---------------)  +   shacknet
	0x00200342, // n0x198a c0x0000 (---------------)  + I ac
	0x4460ce42, // n0x198b c0x0111 (n0x199a-n0x199b)  + I co
	0x00244b03, // n0x198c c0x0000 (---------------)  + I cri
	0x0024f084, // n0x198d c0x0000 (---------------)  + I geek
	0x002060c3, // n0x198e c0x0000 (---------------)  + I gen
	0x00342404, // n0x198f c0x0000 (---------------)  + I govt
	0x002ae586, // n0x1990 c0x0000 (---------------)  + I health
	0x00205c03, // n0x1991 c0x0000 (---------------)  + I iwi
	0x002ea604, // n0x1992 c0x0000 (---------------)  + I kiwi
	0x002719c5, // n0x1993 c0x0000 (---------------)  + I maori
	0x00207dc3, // n0x1994 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1995 c0x0000 (---------------)  + I net
	0x00228743, // n0x1996 c0x0000 (---------------)  + I org
	0x0028458a, // n0x1997 c0x0000 (---------------)  + I parliament
	0x00232186, // n0x1998 c0x0000 (---------------)  + I school
	0x0036a28c, // n0x1999 c0x0000 (---------------)  + I xn--mori-qsa
	0x000fe108, // n0x199a c0x0000 (---------------)  +   blogspot
	0x0020ce42, // n0x199b c0x0000 (---------------)  + I co
	0x00233243, // n0x199c c0x0000 (---------------)  + I com
	0x00239103, // n0x199d c0x0000 (---------------)  + I edu
	0x0027d903, // n0x199e c0x0000 (---------------)  + I gov
	0x00213443, // n0x199f c0x0000 (---------------)  + I med
	0x002d1086, // n0x19a0 c0x0000 (---------------)  + I museum
	0x00223b43, // n0x19a1 c0x0000 (---------------)  + I net
	0x00228743, // n0x19a2 c0x0000 (---------------)  + I org
	0x00224b03, // n0x19a3 c0x0000 (---------------)  + I pro
	0x000030c2, // n0x19a4 c0x0000 (---------------)  +   ae
	0x0002f087, // n0x19a5 c0x0000 (---------------)  +   blogdns
	0x000d4bc8, // n0x19a6 c0x0000 (---------------)  +   blogsite
	0x0000f9ce, // n0x19a7 c0x0000 (---------------)  +   bmoattachments
	0x00089f92, // n0x19a8 c0x0000 (---------------)  +   boldlygoingnowhere
	0x45262e05, // n0x19a9 c0x0114 (n0x19e1-n0x19e3)  o I cdn77
	0x4571d6cc, // n0x19aa c0x0115 (n0x19e3-n0x19e4)  o I cdn77-secure
	0x00142e48, // n0x19ab c0x0000 (---------------)  +   dnsalias
	0x0007cf07, // n0x19ac c0x0000 (---------------)  +   dnsdojo
	0x0001580b, // n0x19ad c0x0000 (---------------)  +   doesntexist
	0x0016a789, // n0x19ae c0x0000 (---------------)  +   dontexist
	0x00142d47, // n0x19af c0x0000 (---------------)  +   doomdns
	0x0013c907, // n0x19b0 c0x0000 (---------------)  +   dsmynas
	0x0007ce07, // n0x19b1 c0x0000 (---------------)  +   duckdns
	0x0000de46, // n0x19b2 c0x0000 (---------------)  +   dvrdns
	0x00197108, // n0x19b3 c0x0000 (---------------)  +   dynalias
	0x45c13206, // n0x19b4 c0x0117 (n0x19e5-n0x19e7)  +   dyndns
	0x000aa38d, // n0x19b5 c0x0000 (---------------)  +   endofinternet
	0x0006b410, // n0x19b6 c0x0000 (---------------)  +   endoftheinternet
	0x46005382, // n0x19b7 c0x0118 (n0x19e7-n0x1a1e)  +   eu
	0x00007d48, // n0x19b8 c0x0000 (---------------)  +   familyds
	0x00069347, // n0x19b9 c0x0000 (---------------)  +   from-me
	0x00098349, // n0x19ba c0x0000 (---------------)  +   game-host
	0x00058186, // n0x19bb c0x0000 (---------------)  +   gotdns
	0x0000c482, // n0x19bc c0x0000 (---------------)  +   hk
	0x0014a8ca, // n0x19bd c0x0000 (---------------)  +   hobby-site
	0x000133c7, // n0x19be c0x0000 (---------------)  +   homedns
	0x00120a07, // n0x19bf c0x0000 (---------------)  +   homeftp
	0x000a6dc9, // n0x19c0 c0x0000 (---------------)  +   homelinux
	0x000a8148, // n0x19c1 c0x0000 (---------------)  +   homeunix
	0x000e060e, // n0x19c2 c0x0000 (---------------)  +   is-a-bruinsfan
	0x0000d78e, // n0x19c3 c0x0000 (---------------)  +   is-a-candidate
	0x0001058f, // n0x19c4 c0x0000 (---------------)  +   is-a-celticsfan
	0x000110c9, // n0x19c5 c0x0000 (---------------)  +   is-a-chef
	0x0004ef49, // n0x19c6 c0x0000 (---------------)  +   is-a-geek
	0x00065e4b, // n0x19c7 c0x0000 (---------------)  +   is-a-knight
	0x0007df8f, // n0x19c8 c0x0000 (---------------)  +   is-a-linux-user
	0x0008cbcc, // n0x19c9 c0x0000 (---------------)  +   is-a-patsfan
	0x000aae0b, // n0x19ca c0x0000 (---------------)  +   is-a-soxfan
	0x000b9ec8, // n0x19cb c0x0000 (---------------)  +   is-found
	0x000cf047, // n0x19cc c0x0000 (---------------)  +   is-lost
	0x0015c0c8, // n0x19cd c0x0000 (---------------)  +   is-saved
	0x000ea8cb, // n0x19ce c0x0000 (---------------)  +   is-very-bad
	0x000ed70c, // n0x19cf c0x0000 (---------------)  +   is-very-evil
	0x000f7c0c, // n0x19d0 c0x0000 (---------------)  +   is-very-good
	0x0011cc8c, // n0x19d1 c0x0000 (---------------)  +   is-very-nice
	0x0013aacd, // n0x19d2 c0x0000 (---------------)  +   is-very-sweet
	0x000862c8, // n0x19d3 c0x0000 (---------------)  +   isa-geek
	0x0014ee89, // n0x19d4 c0x0000 (---------------)  +   kicks-ass
	0x001a0e0b, // n0x19d5 c0x0000 (---------------)  +   misconfused
	0x000dd687, // n0x19d6 c0x0000 (---------------)  +   podzone
	0x000d4a4a, // n0x19d7 c0x0000 (---------------)  +   readmyblog
	0x0005abc6, // n0x19d8 c0x0000 (---------------)  +   selfip
	0x00099d8d, // n0x19d9 c0x0000 (---------------)  +   sellsyourhome
	0x000ccd88, // n0x19da c0x0000 (---------------)  +   servebbs
	0x0008bc88, // n0x19db c0x0000 (---------------)  +   serveftp
	0x00172349, // n0x19dc c0x0000 (---------------)  +   servegame
	0x000e8a0c, // n0x19dd c0x0000 (---------------)  +   stuff-4-sale
	0x00002242, // n0x19de c0x0000 (---------------)  +   us
	0x001267c6, // n0x19df c0x0000 (---------------)  +   webhop
	0x00000182, // n0x19e0 c0x0000 (---------------)  +   za
	0x00000141, // n0x19e1 c0x0000 (---------------)  +   c
	0x00041203, // n0x19e2 c0x0000 (---------------)  +   rsc
	0x45b81386, // n0x19e3 c0x0116 (n0x19e4-n0x19e5)  o I origin
	0x00062f83, // n0x19e4 c0x0000 (---------------)  +   ssl
	0x00010a42, // n0x19e5 c0x0000 (---------------)  +   go
	0x000133c4, // n0x19e6 c0x0000 (---------------)  +   home
	0x00000d02, // n0x19e7 c0x0000 (---------------)  +   al
	0x000d5e84, // n0x19e8 c0x0000 (---------------)  +   asso
	0x00000482, // n0x19e9 c0x0000 (---------------)  +   at
	0x00005782, // n0x19ea c0x0000 (---------------)  +   au
	0x00002e02, // n0x19eb c0x0000 (---------------)  +   be
	0x00104a82, // n0x19ec c0x0000 (---------------)  +   bg
	0x00000e42, // n0x19ed c0x0000 (---------------)  +   ca
	0x00062e02, // n0x19ee c0x0000 (---------------)  +   cd
	0x00000382, // n0x19ef c0x0000 (---------------)  +   ch
	0x0001dac2, // n0x19f0 c0x0000 (---------------)  +   cn
	0x0003cd42, // n0x19f1 c0x0000 (---------------)  +   cy
	0x00000142, // n0x19f2 c0x0000 (---------------)  +   cz
	0x00005582, // n0x19f3 c0x0000 (---------------)  +   de
	0x000489c2, // n0x19f4 c0x0000 (---------------)  +   dk
	0x00039103, // n0x19f5 c0x0000 (---------------)  +   edu
	0x0000cf42, // n0x19f6 c0x0000 (---------------)  +   ee
	0x00000082, // n0x19f7 c0x0000 (---------------)  +   es
	0x00001702, // n0x19f8 c0x0000 (---------------)  +   fi
	0x00040202, // n0x19f9 c0x0000 (---------------)  +   fr
	0x00008a82, // n0x19fa c0x0000 (---------------)  +   gr
	0x0000f742, // n0x19fb c0x0000 (---------------)  +   hr
	0x00024202, // n0x19fc c0x0000 (---------------)  +   hu
	0x00000042, // n0x19fd c0x0000 (---------------)  +   ie
	0x000027c2, // n0x19fe c0x0000 (---------------)  +   il
	0x000012c2, // n0x19ff c0x0000 (---------------)  +   in
	0x00001503, // n0x1a00 c0x0000 (---------------)  +   int
	0x00004e82, // n0x1a01 c0x0000 (---------------)  +   is
	0x000017c2, // n0x1a02 c0x0000 (---------------)  +   it
	0x000b00c2, // n0x1a03 c0x0000 (---------------)  +   jp
	0x0000bdc2, // n0x1a04 c0x0000 (---------------)  +   kr
	0x00008bc2, // n0x1a05 c0x0000 (---------------)  +   lt
	0x00003842, // n0x1a06 c0x0000 (---------------)  +   lu
	0x00006582, // n0x1a07 c0x0000 (---------------)  +   lv
	0x0001a3c2, // n0x1a08 c0x0000 (---------------)  +   mc
	0x00000982, // n0x1a09 c0x0000 (---------------)  +   me
	0x00167282, // n0x1a0a c0x0000 (---------------)  +   mk
	0x00005402, // n0x1a0b c0x0000 (---------------)  +   mt
	0x00025742, // n0x1a0c c0x0000 (---------------)  +   my
	0x00023b43, // n0x1a0d c0x0000 (---------------)  +   net
	0x000026c2, // n0x1a0e c0x0000 (---------------)  +   ng
	0x00046d02, // n0x1a0f c0x0000 (---------------)  +   nl
	0x00001382, // n0x1a10 c0x0000 (---------------)  +   no
	0x00008282, // n0x1a11 c0x0000 (---------------)  +   nz
	0x00077705, // n0x1a12 c0x0000 (---------------)  +   paris
	0x00009442, // n0x1a13 c0x0000 (---------------)  +   pl
	0x000d3242, // n0x1a14 c0x0000 (---------------)  +   pt
	0x00042ec3, // n0x1a15 c0x0000 (---------------)  +   q-a
	0x000020c2, // n0x1a16 c0x0000 (---------------)  +   ro
	0x0000fe82, // n0x1a17 c0x0000 (---------------)  +   ru
	0x00004ec2, // n0x1a18 c0x0000 (---------------)  +   se
	0x000091c2, // n0x1a19 c0x0000 (---------------)  +   si
	0x00008502, // n0x1a1a c0x0000 (---------------)  +   sk
	0x00003902, // n0x1a1b c0x0000 (---------------)  +   tr
	0x00001b02, // n0x1a1c c0x0000 (---------------)  +   uk
	0x00002242, // n0x1a1d c0x0000 (---------------)  +   us
	0x00216f03, // n0x1a1e c0x0000 (---------------)  + I abo
	0x00200342, // n0x1a1f c0x0000 (---------------)  + I ac
	0x00233243, // n0x1a20 c0x0000 (---------------)  + I com
	0x00239103, // n0x1a21 c0x0000 (---------------)  + I edu
	0x00212b03, // n0x1a22 c0x0000 (---------------)  + I gob
	0x0020f543, // n0x1a23 c0x0000 (---------------)  + I ing
	0x00213443, // n0x1a24 c0x0000 (---------------)  + I med
	0x00223b43, // n0x1a25 c0x0000 (---------------)  + I net
	0x00201383, // n0x1a26 c0x0000 (---------------)  + I nom
	0x00228743, // n0x1a27 c0x0000 (---------------)  + I org
	0x002933c3, // n0x1a28 c0x0000 (---------------)  + I sld
	0x000fe108, // n0x1a29 c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x1a2a c0x0000 (---------------)  + I com
	0x00239103, // n0x1a2b c0x0000 (---------------)  + I edu
	0x00212b03, // n0x1a2c c0x0000 (---------------)  + I gob
	0x00207dc3, // n0x1a2d c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1a2e c0x0000 (---------------)  + I net
	0x00201383, // n0x1a2f c0x0000 (---------------)  + I nom
	0x00228743, // n0x1a30 c0x0000 (---------------)  + I org
	0x00233243, // n0x1a31 c0x0000 (---------------)  + I com
	0x00239103, // n0x1a32 c0x0000 (---------------)  + I edu
	0x00228743, // n0x1a33 c0x0000 (---------------)  + I org
	0x00233243, // n0x1a34 c0x0000 (---------------)  + I com
	0x00239103, // n0x1a35 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1a36 c0x0000 (---------------)  + I gov
	0x00200041, // n0x1a37 c0x0000 (---------------)  + I i
	0x00207dc3, // n0x1a38 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1a39 c0x0000 (---------------)  + I net
	0x0023b383, // n0x1a3a c0x0000 (---------------)  + I ngo
	0x00228743, // n0x1a3b c0x0000 (---------------)  + I org
	0x00331a83, // n0x1a3c c0x0000 (---------------)  + I biz
	0x00233243, // n0x1a3d c0x0000 (---------------)  + I com
	0x00239103, // n0x1a3e c0x0000 (---------------)  + I edu
	0x00207d43, // n0x1a3f c0x0000 (---------------)  + I fam
	0x00212b03, // n0x1a40 c0x0000 (---------------)  + I gob
	0x0023c083, // n0x1a41 c0x0000 (---------------)  + I gok
	0x0024ed83, // n0x1a42 c0x0000 (---------------)  + I gon
	0x002a4d03, // n0x1a43 c0x0000 (---------------)  + I gop
	0x0024e183, // n0x1a44 c0x0000 (---------------)  + I gos
	0x0027d903, // n0x1a45 c0x0000 (---------------)  + I gov
	0x00201844, // n0x1a46 c0x0000 (---------------)  + I info
	0x00223b43, // n0x1a47 c0x0000 (---------------)  + I net
	0x00228743, // n0x1a48 c0x0000 (---------------)  + I org
	0x0021e243, // n0x1a49 c0x0000 (---------------)  + I web
	0x002f4bc4, // n0x1a4a c0x0000 (---------------)  + I agro
	0x0022e4c3, // n0x1a4b c0x0000 (---------------)  + I aid
	0x00001d43, // n0x1a4c c0x0000 (---------------)  +   art
	0x00200c43, // n0x1a4d c0x0000 (---------------)  + I atm
	0x00255b88, // n0x1a4e c0x0000 (---------------)  + I augustow
	0x00229f44, // n0x1a4f c0x0000 (---------------)  + I auto
	0x002278ca, // n0x1a50 c0x0000 (---------------)  + I babia-gora
	0x002067c6, // n0x1a51 c0x0000 (---------------)  + I bedzin
	0x00396fc7, // n0x1a52 c0x0000 (---------------)  + I beskidy
	0x0022248a, // n0x1a53 c0x0000 (---------------)  + I bialowieza
	0x00275b09, // n0x1a54 c0x0000 (---------------)  + I bialystok
	0x003a2f47, // n0x1a55 c0x0000 (---------------)  + I bielawa
	0x0020000a, // n0x1a56 c0x0000 (---------------)  + I bieszczady
	0x00331a83, // n0x1a57 c0x0000 (---------------)  + I biz
	0x0037714b, // n0x1a58 c0x0000 (---------------)  + I boleslawiec
	0x00302649, // n0x1a59 c0x0000 (---------------)  + I bydgoszcz
	0x00219bc5, // n0x1a5a c0x0000 (---------------)  + I bytom
	0x002cd6c7, // n0x1a5b c0x0000 (---------------)  + I cieszyn
	0x0000ce42, // n0x1a5c c0x0000 (---------------)  +   co
	0x00233243, // n0x1a5d c0x0000 (---------------)  + I com
	0x00355907, // n0x1a5e c0x0000 (---------------)  + I czeladz
	0x00357445, // n0x1a5f c0x0000 (---------------)  + I czest
	0x002bdbc9, // n0x1a60 c0x0000 (---------------)  + I dlugoleka
	0x00239103, // n0x1a61 c0x0000 (---------------)  + I edu
	0x00226486, // n0x1a62 c0x0000 (---------------)  + I elblag
	0x002bca03, // n0x1a63 c0x0000 (---------------)  + I elk
	0x000c62c3, // n0x1a64 c0x0000 (---------------)  +   gda
	0x000faa86, // n0x1a65 c0x0000 (---------------)  +   gdansk
	0x00129846, // n0x1a66 c0x0000 (---------------)  +   gdynia
	0x00005b87, // n0x1a67 c0x0000 (---------------)  +   gliwice
	0x002114c6, // n0x1a68 c0x0000 (---------------)  + I glogow
	0x00215f85, // n0x1a69 c0x0000 (---------------)  + I gmina
	0x00382c07, // n0x1a6a c0x0000 (---------------)  + I gniezno
	0x00334fc7, // n0x1a6b c0x0000 (---------------)  + I gorlice
	0x47e7d903, // n0x1a6c c0x011f (n0x1aef-n0x1b1e)  + I gov
	0x0032c447, // n0x1a6d c0x0000 (---------------)  + I grajewo
	0x0035d983, // n0x1a6e c0x0000 (---------------)  + I gsm
	0x00309a05, // n0x1a6f c0x0000 (---------------)  + I ilawa
	0x00201844, // n0x1a70 c0x0000 (---------------)  + I info
	0x003a5288, // n0x1a71 c0x0000 (---------------)  + I jaworzno
	0x002af58c, // n0x1a72 c0x0000 (---------------)  + I jelenia-gora
	0x002adc45, // n0x1a73 c0x0000 (---------------)  + I jgora
	0x0031fb46, // n0x1a74 c0x0000 (---------------)  + I kalisz
	0x003557c7, // n0x1a75 c0x0000 (---------------)  + I karpacz
	0x0038d447, // n0x1a76 c0x0000 (---------------)  + I kartuzy
	0x0020d0c7, // n0x1a77 c0x0000 (---------------)  + I kaszuby
	0x00211dc8, // n0x1a78 c0x0000 (---------------)  + I katowice
	0x00264f8f, // n0x1a79 c0x0000 (---------------)  + I kazimierz-dolny
	0x00248845, // n0x1a7a c0x0000 (---------------)  + I kepno
	0x00244c07, // n0x1a7b c0x0000 (---------------)  + I ketrzyn
	0x0039d947, // n0x1a7c c0x0000 (---------------)  + I klodzko
	0x002a63ca, // n0x1a7d c0x0000 (---------------)  + I kobierzyce
	0x0033c289, // n0x1a7e c0x0000 (---------------)  + I kolobrzeg
	0x002ca585, // n0x1a7f c0x0000 (---------------)  + I konin
	0x002caf0a, // n0x1a80 c0x0000 (---------------)  + I konskowola
	0x00126686, // n0x1a81 c0x0000 (---------------)  +   krakow
	0x002bca85, // n0x1a82 c0x0000 (---------------)  + I kutno
	0x00369344, // n0x1a83 c0x0000 (---------------)  + I lapy
	0x00269d86, // n0x1a84 c0x0000 (---------------)  + I lebork
	0x0023eb07, // n0x1a85 c0x0000 (---------------)  + I legnica
	0x00233647, // n0x1a86 c0x0000 (---------------)  + I lezajsk
	0x0022b388, // n0x1a87 c0x0000 (---------------)  + I limanowa
	0x00214d05, // n0x1a88 c0x0000 (---------------)  + I lomza
	0x00357346, // n0x1a89 c0x0000 (---------------)  + I lowicz
	0x0038dec5, // n0x1a8a c0x0000 (---------------)  + I lubin
	0x0036e405, // n0x1a8b c0x0000 (---------------)  + I lukow
	0x00218c84, // n0x1a8c c0x0000 (---------------)  + I mail
	0x002eacc7, // n0x1a8d c0x0000 (---------------)  + I malbork
	0x00307d0a, // n0x1a8e c0x0000 (---------------)  + I malopolska
	0x0020a788, // n0x1a8f c0x0000 (---------------)  + I mazowsze
	0x002ea246, // n0x1a90 c0x0000 (---------------)  + I mazury
	0x00013443, // n0x1a91 c0x0000 (---------------)  +   med
	0x00303545, // n0x1a92 c0x0000 (---------------)  + I media
	0x00231c86, // n0x1a93 c0x0000 (---------------)  + I miasta
	0x003a5a46, // n0x1a94 c0x0000 (---------------)  + I mielec
	0x0026c8c6, // n0x1a95 c0x0000 (---------------)  + I mielno
	0x00207dc3, // n0x1a96 c0x0000 (---------------)  + I mil
	0x0037ed47, // n0x1a97 c0x0000 (---------------)  + I mragowo
	0x0039d8c5, // n0x1a98 c0x0000 (---------------)  + I naklo
	0x00223b43, // n0x1a99 c0x0000 (---------------)  + I net
	0x003a31cd, // n0x1a9a c0x0000 (---------------)  + I nieruchomosci
	0x00201383, // n0x1a9b c0x0000 (---------------)  + I nom
	0x0022b488, // n0x1a9c c0x0000 (---------------)  + I nowaruda
	0x0039f444, // n0x1a9d c0x0000 (---------------)  + I nysa
	0x00276b05, // n0x1a9e c0x0000 (---------------)  + I olawa
	0x002a62c6, // n0x1a9f c0x0000 (---------------)  + I olecko
	0x0023b746, // n0x1aa0 c0x0000 (---------------)  + I olkusz
	0x0021f607, // n0x1aa1 c0x0000 (---------------)  + I olsztyn
	0x0023c3c7, // n0x1aa2 c0x0000 (---------------)  + I opoczno
	0x0024d4c5, // n0x1aa3 c0x0000 (---------------)  + I opole
	0x00228743, // n0x1aa4 c0x0000 (---------------)  + I org
	0x0036c1c7, // n0x1aa5 c0x0000 (---------------)  + I ostroda
	0x002c9009, // n0x1aa6 c0x0000 (---------------)  + I ostroleka
	0x0020c949, // n0x1aa7 c0x0000 (---------------)  + I ostrowiec
	0x0020e80a, // n0x1aa8 c0x0000 (---------------)  + I ostrowwlkp
	0x00247682, // n0x1aa9 c0x0000 (---------------)  + I pc
	0x003099c4, // n0x1aaa c0x0000 (---------------)  + I pila
	0x002d7704, // n0x1aab c0x0000 (---------------)  + I pisz
	0x00213bc7, // n0x1aac c0x0000 (---------------)  + I podhale
	0x0023b948, // n0x1aad c0x0000 (---------------)  + I podlasie
	0x002de109, // n0x1aae c0x0000 (---------------)  + I polkowice
	0x002083c9, // n0x1aaf c0x0000 (---------------)  + I pomorskie
	0x002decc7, // n0x1ab0 c0x0000 (---------------)  + I pomorze
	0x00248346, // n0x1ab1 c0x0000 (---------------)  + I powiat
	0x000e0386, // n0x1ab2 c0x0000 (---------------)  +   poznan
	0x002e17c4, // n0x1ab3 c0x0000 (---------------)  + I priv
	0x002e194a, // n0x1ab4 c0x0000 (---------------)  + I prochowice
	0x002e52c8, // n0x1ab5 c0x0000 (---------------)  + I pruszkow
	0x002e5f49, // n0x1ab6 c0x0000 (---------------)  + I przeworsk
	0x00297506, // n0x1ab7 c0x0000 (---------------)  + I pulawy
	0x00301145, // n0x1ab8 c0x0000 (---------------)  + I radom
	0x0020a648, // n0x1ab9 c0x0000 (---------------)  + I rawa-maz
	0x002c410a, // n0x1aba c0x0000 (---------------)  + I realestate
	0x00286903, // n0x1abb c0x0000 (---------------)  + I rel
	0x0034f406, // n0x1abc c0x0000 (---------------)  + I rybnik
	0x002dedc7, // n0x1abd c0x0000 (---------------)  + I rzeszow
	0x0020b905, // n0x1abe c0x0000 (---------------)  + I sanok
	0x00225d45, // n0x1abf c0x0000 (---------------)  + I sejny
	0x00246b03, // n0x1ac0 c0x0000 (---------------)  + I sex
	0x00357184, // n0x1ac1 c0x0000 (---------------)  + I shop
	0x00373445, // n0x1ac2 c0x0000 (---------------)  + I sklep
	0x00284a47, // n0x1ac3 c0x0000 (---------------)  + I skoczow
	0x002e2605, // n0x1ac4 c0x0000 (---------------)  + I slask
	0x002d1f86, // n0x1ac5 c0x0000 (---------------)  + I slupsk
	0x000ee485, // n0x1ac6 c0x0000 (---------------)  +   sopot
	0x0021d283, // n0x1ac7 c0x0000 (---------------)  + I sos
	0x002b7589, // n0x1ac8 c0x0000 (---------------)  + I sosnowiec
	0x002768cc, // n0x1ac9 c0x0000 (---------------)  + I stalowa-wola
	0x002a294c, // n0x1aca c0x0000 (---------------)  + I starachowice
	0x002caac8, // n0x1acb c0x0000 (---------------)  + I stargard
	0x00265cc7, // n0x1acc c0x0000 (---------------)  + I suwalki
	0x002ebf88, // n0x1acd c0x0000 (---------------)  + I swidnica
	0x002ec58a, // n0x1ace c0x0000 (---------------)  + I swiebodzin
	0x002ecf0b, // n0x1acf c0x0000 (---------------)  + I swinoujscie
	0x00302788, // n0x1ad0 c0x0000 (---------------)  + I szczecin
	0x0031fc48, // n0x1ad1 c0x0000 (---------------)  + I szczytno
	0x00294c06, // n0x1ad2 c0x0000 (---------------)  + I szkola
	0x00249ec5, // n0x1ad3 c0x0000 (---------------)  + I targi
	0x0022afca, // n0x1ad4 c0x0000 (---------------)  + I tarnobrzeg
	0x002247c5, // n0x1ad5 c0x0000 (---------------)  + I tgory
	0x00200c82, // n0x1ad6 c0x0000 (---------------)  + I tm
	0x002c1b87, // n0x1ad7 c0x0000 (---------------)  + I tourism
	0x002a3206, // n0x1ad8 c0x0000 (---------------)  + I travel
	0x0034fe45, // n0x1ad9 c0x0000 (---------------)  + I turek
	0x002ee009, // n0x1ada c0x0000 (---------------)  + I turystyka
	0x003091c5, // n0x1adb c0x0000 (---------------)  + I tychy
	0x00287385, // n0x1adc c0x0000 (---------------)  + I ustka
	0x003095c9, // n0x1add c0x0000 (---------------)  + I walbrzych
	0x00231b06, // n0x1ade c0x0000 (---------------)  + I warmia
	0x0023f588, // n0x1adf c0x0000 (---------------)  + I warszawa
	0x0025a5c3, // n0x1ae0 c0x0000 (---------------)  + I waw
	0x00211606, // n0x1ae1 c0x0000 (---------------)  + I wegrow
	0x00275046, // n0x1ae2 c0x0000 (---------------)  + I wielun
	0x002fe645, // n0x1ae3 c0x0000 (---------------)  + I wlocl
	0x002fe649, // n0x1ae4 c0x0000 (---------------)  + I wloclawek
	0x002b2bc9, // n0x1ae5 c0x0000 (---------------)  + I wodzislaw
	0x00253507, // n0x1ae6 c0x0000 (---------------)  + I wolomin
	0x000fe4c4, // n0x1ae7 c0x0000 (---------------)  +   wroc
	0x002fe4c7, // n0x1ae8 c0x0000 (---------------)  + I wroclaw
	0x002082c9, // n0x1ae9 c0x0000 (---------------)  + I zachpomor
	0x00222685, // n0x1aea c0x0000 (---------------)  + I zagan
	0x00138388, // n0x1aeb c0x0000 (---------------)  +   zakopane
	0x00353e05, // n0x1aec c0x0000 (---------------)  + I zarow
	0x00223c05, // n0x1aed c0x0000 (---------------)  + I zgora
	0x0022f4c9, // n0x1aee c0x0000 (---------------)  + I zgorzelec
	0x00208082, // n0x1aef c0x0000 (---------------)  + I ap
	0x0022e2c4, // n0x1af0 c0x0000 (---------------)  + I griw
	0x00205c82, // n0x1af1 c0x0000 (---------------)  + I ic
	0x00204e82, // n0x1af2 c0x0000 (---------------)  + I is
	0x00269b45, // n0x1af3 c0x0000 (---------------)  + I kmpsp
	0x002ce008, // n0x1af4 c0x0000 (---------------)  + I konsulat
	0x0036ff85, // n0x1af5 c0x0000 (---------------)  + I kppsp
	0x002bf3c3, // n0x1af6 c0x0000 (---------------)  + I kwp
	0x002bf3c5, // n0x1af7 c0x0000 (---------------)  + I kwpsp
	0x002cda83, // n0x1af8 c0x0000 (---------------)  + I mup
	0x00212002, // n0x1af9 c0x0000 (---------------)  + I mw
	0x00267184, // n0x1afa c0x0000 (---------------)  + I oirm
	0x002e7a03, // n0x1afb c0x0000 (---------------)  + I oum
	0x0020aac2, // n0x1afc c0x0000 (---------------)  + I pa
	0x002e3144, // n0x1afd c0x0000 (---------------)  + I pinb
	0x002d7d03, // n0x1afe c0x0000 (---------------)  + I piw
	0x00206ec2, // n0x1aff c0x0000 (---------------)  + I po
	0x00208103, // n0x1b00 c0x0000 (---------------)  + I psp
	0x0028e544, // n0x1b01 c0x0000 (---------------)  + I psse
	0x002b68c3, // n0x1b02 c0x0000 (---------------)  + I pup
	0x00234584, // n0x1b03 c0x0000 (---------------)  + I rzgw
	0x00201002, // n0x1b04 c0x0000 (---------------)  + I sa
	0x00272743, // n0x1b05 c0x0000 (---------------)  + I sdn
	0x002176c3, // n0x1b06 c0x0000 (---------------)  + I sko
	0x00205f02, // n0x1b07 c0x0000 (---------------)  + I so
	0x00332d82, // n0x1b08 c0x0000 (---------------)  + I sr
	0x002b2a09, // n0x1b09 c0x0000 (---------------)  + I starostwo
	0x00204682, // n0x1b0a c0x0000 (---------------)  + I ug
	0x0028ab04, // n0x1b0b c0x0000 (---------------)  + I ugim
	0x002053c2, // n0x1b0c c0x0000 (---------------)  + I um
	0x0020a4c4, // n0x1b0d c0x0000 (---------------)  + I umig
	0x00248304, // n0x1b0e c0x0000 (---------------)  + I upow
	0x002e4644, // n0x1b0f c0x0000 (---------------)  + I uppo
	0x00202242, // n0x1b10 c0x0000 (---------------)  + I us
	0x002431c2, // n0x1b11 c0x0000 (---------------)  + I uw
	0x0020fec3, // n0x1b12 c0x0000 (---------------)  + I uzs
	0x002ecb83, // n0x1b13 c0x0000 (---------------)  + I wif
	0x00244204, // n0x1b14 c0x0000 (---------------)  + I wiih
	0x0025cd84, // n0x1b15 c0x0000 (---------------)  + I winb
	0x002c8f84, // n0x1b16 c0x0000 (---------------)  + I wios
	0x002cae04, // n0x1b17 c0x0000 (---------------)  + I witd
	0x002fdb43, // n0x1b18 c0x0000 (---------------)  + I wiw
	0x002f2083, // n0x1b19 c0x0000 (---------------)  + I wsa
	0x00326604, // n0x1b1a c0x0000 (---------------)  + I wskr
	0x002ffa04, // n0x1b1b c0x0000 (---------------)  + I wuoz
	0x002ffd06, // n0x1b1c c0x0000 (---------------)  + I wzmiuw
	0x00262bc2, // n0x1b1d c0x0000 (---------------)  + I zp
	0x0020ce42, // n0x1b1e c0x0000 (---------------)  + I co
	0x00239103, // n0x1b1f c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1b20 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x1b21 c0x0000 (---------------)  + I net
	0x00228743, // n0x1b22 c0x0000 (---------------)  + I org
	0x00200342, // n0x1b23 c0x0000 (---------------)  + I ac
	0x00331a83, // n0x1b24 c0x0000 (---------------)  + I biz
	0x00233243, // n0x1b25 c0x0000 (---------------)  + I com
	0x00239103, // n0x1b26 c0x0000 (---------------)  + I edu
	0x002025c3, // n0x1b27 c0x0000 (---------------)  + I est
	0x0027d903, // n0x1b28 c0x0000 (---------------)  + I gov
	0x00201844, // n0x1b29 c0x0000 (---------------)  + I info
	0x002b2cc4, // n0x1b2a c0x0000 (---------------)  + I isla
	0x00200904, // n0x1b2b c0x0000 (---------------)  + I name
	0x00223b43, // n0x1b2c c0x0000 (---------------)  + I net
	0x00228743, // n0x1b2d c0x0000 (---------------)  + I org
	0x00224b03, // n0x1b2e c0x0000 (---------------)  + I pro
	0x002e2004, // n0x1b2f c0x0000 (---------------)  + I prof
	0x002b5b43, // n0x1b30 c0x0000 (---------------)  + I aca
	0x002049c3, // n0x1b31 c0x0000 (---------------)  + I bar
	0x002168c3, // n0x1b32 c0x0000 (---------------)  + I cpa
	0x00213083, // n0x1b33 c0x0000 (---------------)  + I eng
	0x002b1983, // n0x1b34 c0x0000 (---------------)  + I jur
	0x00271c03, // n0x1b35 c0x0000 (---------------)  + I law
	0x00213443, // n0x1b36 c0x0000 (---------------)  + I med
	0x00233243, // n0x1b37 c0x0000 (---------------)  + I com
	0x00239103, // n0x1b38 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1b39 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x1b3a c0x0000 (---------------)  + I net
	0x00228743, // n0x1b3b c0x0000 (---------------)  + I org
	0x002db743, // n0x1b3c c0x0000 (---------------)  + I plo
	0x002363c3, // n0x1b3d c0x0000 (---------------)  + I sec
	0x000fe108, // n0x1b3e c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x1b3f c0x0000 (---------------)  + I com
	0x00239103, // n0x1b40 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1b41 c0x0000 (---------------)  + I gov
	0x00201503, // n0x1b42 c0x0000 (---------------)  + I int
	0x00223b43, // n0x1b43 c0x0000 (---------------)  + I net
	0x00242144, // n0x1b44 c0x0000 (---------------)  + I nome
	0x00228743, // n0x1b45 c0x0000 (---------------)  + I org
	0x002a0ec4, // n0x1b46 c0x0000 (---------------)  + I publ
	0x002b8e45, // n0x1b47 c0x0000 (---------------)  + I belau
	0x0020ce42, // n0x1b48 c0x0000 (---------------)  + I co
	0x002024c2, // n0x1b49 c0x0000 (---------------)  + I ed
	0x00210a42, // n0x1b4a c0x0000 (---------------)  + I go
	0x00202ac2, // n0x1b4b c0x0000 (---------------)  + I ne
	0x00200dc2, // n0x1b4c c0x0000 (---------------)  + I or
	0x00233243, // n0x1b4d c0x0000 (---------------)  + I com
	0x0023c344, // n0x1b4e c0x0000 (---------------)  + I coop
	0x00239103, // n0x1b4f c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1b50 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x1b51 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1b52 c0x0000 (---------------)  + I net
	0x00228743, // n0x1b53 c0x0000 (---------------)  + I org
	0x000fe108, // n0x1b54 c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x1b55 c0x0000 (---------------)  + I com
	0x00239103, // n0x1b56 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1b57 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x1b58 c0x0000 (---------------)  + I mil
	0x00200904, // n0x1b59 c0x0000 (---------------)  + I name
	0x00223b43, // n0x1b5a c0x0000 (---------------)  + I net
	0x00228743, // n0x1b5b c0x0000 (---------------)  + I org
	0x00217283, // n0x1b5c c0x0000 (---------------)  + I sch
	0x002d5e84, // n0x1b5d c0x0000 (---------------)  + I asso
	0x000fe108, // n0x1b5e c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x1b5f c0x0000 (---------------)  + I com
	0x00201383, // n0x1b60 c0x0000 (---------------)  + I nom
	0x0024b944, // n0x1b61 c0x0000 (---------------)  + I arts
	0x000fe108, // n0x1b62 c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x1b63 c0x0000 (---------------)  + I com
	0x0024dcc4, // n0x1b64 c0x0000 (---------------)  + I firm
	0x00201844, // n0x1b65 c0x0000 (---------------)  + I info
	0x00201383, // n0x1b66 c0x0000 (---------------)  + I nom
	0x00201542, // n0x1b67 c0x0000 (---------------)  + I nt
	0x00228743, // n0x1b68 c0x0000 (---------------)  + I org
	0x0022c2c3, // n0x1b69 c0x0000 (---------------)  + I rec
	0x00364cc5, // n0x1b6a c0x0000 (---------------)  + I store
	0x00200c82, // n0x1b6b c0x0000 (---------------)  + I tm
	0x002ffb43, // n0x1b6c c0x0000 (---------------)  + I www
	0x00200342, // n0x1b6d c0x0000 (---------------)  + I ac
	0x000fe108, // n0x1b6e c0x0000 (---------------)  +   blogspot
	0x0020ce42, // n0x1b6f c0x0000 (---------------)  + I co
	0x00239103, // n0x1b70 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1b71 c0x0000 (---------------)  + I gov
	0x002012c2, // n0x1b72 c0x0000 (---------------)  + I in
	0x00228743, // n0x1b73 c0x0000 (---------------)  + I org
	0x00200342, // n0x1b74 c0x0000 (---------------)  + I ac
	0x002001c7, // n0x1b75 c0x0000 (---------------)  + I adygeya
	0x0028c445, // n0x1b76 c0x0000 (---------------)  + I altai
	0x00295084, // n0x1b77 c0x0000 (---------------)  + I amur
	0x0037ca86, // n0x1b78 c0x0000 (---------------)  + I amursk
	0x00236d0b, // n0x1b79 c0x0000 (---------------)  + I arkhangelsk
	0x0025a349, // n0x1b7a c0x0000 (---------------)  + I astrakhan
	0x0031fa86, // n0x1b7b c0x0000 (---------------)  + I baikal
	0x00324289, // n0x1b7c c0x0000 (---------------)  + I bashkiria
	0x002d4488, // n0x1b7d c0x0000 (---------------)  + I belgorod
	0x00204ac3, // n0x1b7e c0x0000 (---------------)  + I bir
	0x000fe108, // n0x1b7f c0x0000 (---------------)  +   blogspot
	0x00229507, // n0x1b80 c0x0000 (---------------)  + I bryansk
	0x0034ac88, // n0x1b81 c0x0000 (---------------)  + I buryatia
	0x00329bc3, // n0x1b82 c0x0000 (---------------)  + I cbg
	0x00264784, // n0x1b83 c0x0000 (---------------)  + I chel
	0x0026dd8b, // n0x1b84 c0x0000 (---------------)  + I chelyabinsk
	0x002b0305, // n0x1b85 c0x0000 (---------------)  + I chita
	0x002be488, // n0x1b86 c0x0000 (---------------)  + I chukotka
	0x003364c9, // n0x1b87 c0x0000 (---------------)  + I chuvashia
	0x0025cd03, // n0x1b88 c0x0000 (---------------)  + I cmw
	0x00233243, // n0x1b89 c0x0000 (---------------)  + I com
	0x00202508, // n0x1b8a c0x0000 (---------------)  + I dagestan
	0x002eb107, // n0x1b8b c0x0000 (---------------)  + I dudinka
	0x00327d86, // n0x1b8c c0x0000 (---------------)  + I e-burg
	0x00239103, // n0x1b8d c0x0000 (---------------)  + I edu
	0x00384f47, // n0x1b8e c0x0000 (---------------)  + I fareast
	0x0027d903, // n0x1b8f c0x0000 (---------------)  + I gov
	0x00289106, // n0x1b90 c0x0000 (---------------)  + I grozny
	0x00201503, // n0x1b91 c0x0000 (---------------)  + I int
	0x00230847, // n0x1b92 c0x0000 (---------------)  + I irkutsk
	0x00288007, // n0x1b93 c0x0000 (---------------)  + I ivanovo
	0x00385f47, // n0x1b94 c0x0000 (---------------)  + I izhevsk
	0x002eac45, // n0x1b95 c0x0000 (---------------)  + I jamal
	0x0020b483, // n0x1b96 c0x0000 (---------------)  + I jar
	0x0020c3cb, // n0x1b97 c0x0000 (---------------)  + I joshkar-ola
	0x00332448, // n0x1b98 c0x0000 (---------------)  + I k-uralsk
	0x00225688, // n0x1b99 c0x0000 (---------------)  + I kalmykia
	0x00250706, // n0x1b9a c0x0000 (---------------)  + I kaluga
	0x0021a349, // n0x1b9b c0x0000 (---------------)  + I kamchatka
	0x00325cc7, // n0x1b9c c0x0000 (---------------)  + I karelia
	0x002f8c85, // n0x1b9d c0x0000 (---------------)  + I kazan
	0x00314984, // n0x1b9e c0x0000 (---------------)  + I kchr
	0x00275d48, // n0x1b9f c0x0000 (---------------)  + I kemerovo
	0x002338ca, // n0x1ba0 c0x0000 (---------------)  + I khabarovsk
	0x00233b09, // n0x1ba1 c0x0000 (---------------)  + I khakassia
	0x0024f143, // n0x1ba2 c0x0000 (---------------)  + I khv
	0x0027f805, // n0x1ba3 c0x0000 (---------------)  + I kirov
	0x00272ac3, // n0x1ba4 c0x0000 (---------------)  + I kms
	0x002a6c46, // n0x1ba5 c0x0000 (---------------)  + I koenig
	0x0039b084, // n0x1ba6 c0x0000 (---------------)  + I komi
	0x002fe848, // n0x1ba7 c0x0000 (---------------)  + I kostroma
	0x003860cb, // n0x1ba8 c0x0000 (---------------)  + I krasnoyarsk
	0x0033c145, // n0x1ba9 c0x0000 (---------------)  + I kuban
	0x002b8bc6, // n0x1baa c0x0000 (---------------)  + I kurgan
	0x002ba785, // n0x1bab c0x0000 (---------------)  + I kursk
	0x002bb788, // n0x1bac c0x0000 (---------------)  + I kustanai
	0x002bcbc7, // n0x1bad c0x0000 (---------------)  + I kuzbass
	0x00211c47, // n0x1bae c0x0000 (---------------)  + I lipetsk
	0x002274c7, // n0x1baf c0x0000 (---------------)  + I magadan
	0x00219cc4, // n0x1bb0 c0x0000 (---------------)  + I mari
	0x00222947, // n0x1bb1 c0x0000 (---------------)  + I mari-el
	0x0027c146, // n0x1bb2 c0x0000 (---------------)  + I marine
	0x00207dc3, // n0x1bb3 c0x0000 (---------------)  + I mil
	0x002c6f48, // n0x1bb4 c0x0000 (---------------)  + I mordovia
	0x00253203, // n0x1bb5 c0x0000 (---------------)  + I msk
	0x002cde48, // n0x1bb6 c0x0000 (---------------)  + I murmansk
	0x002d3ac5, // n0x1bb7 c0x0000 (---------------)  + I mytis
	0x0030ac08, // n0x1bb8 c0x0000 (---------------)  + I nakhodka
	0x00239307, // n0x1bb9 c0x0000 (---------------)  + I nalchik
	0x00223b43, // n0x1bba c0x0000 (---------------)  + I net
	0x00391fc3, // n0x1bbb c0x0000 (---------------)  + I nkz
	0x0028bac4, // n0x1bbc c0x0000 (---------------)  + I nnov
	0x00373307, // n0x1bbd c0x0000 (---------------)  + I norilsk
	0x00206143, // n0x1bbe c0x0000 (---------------)  + I nov
	0x002880cb, // n0x1bbf c0x0000 (---------------)  + I novosibirsk
	0x00217683, // n0x1bc0 c0x0000 (---------------)  + I nsk
	0x002531c4, // n0x1bc1 c0x0000 (---------------)  + I omsk
	0x00364d48, // n0x1bc2 c0x0000 (---------------)  + I orenburg
	0x00228743, // n0x1bc3 c0x0000 (---------------)  + I org
	0x002d8045, // n0x1bc4 c0x0000 (---------------)  + I oryol
	0x00297b05, // n0x1bc5 c0x0000 (---------------)  + I oskol
	0x0039d7c6, // n0x1bc6 c0x0000 (---------------)  + I palana
	0x00212605, // n0x1bc7 c0x0000 (---------------)  + I penza
	0x002d3e84, // n0x1bc8 c0x0000 (---------------)  + I perm
	0x002080c2, // n0x1bc9 c0x0000 (---------------)  + I pp
	0x002e6203, // n0x1bca c0x0000 (---------------)  + I ptz
	0x003693ca, // n0x1bcb c0x0000 (---------------)  + I pyatigorsk
	0x0038fd03, // n0x1bcc c0x0000 (---------------)  + I rnd
	0x002d2fc9, // n0x1bcd c0x0000 (---------------)  + I rubtsovsk
	0x00249886, // n0x1bce c0x0000 (---------------)  + I ryazan
	0x0021c788, // n0x1bcf c0x0000 (---------------)  + I sakhalin
	0x0028e086, // n0x1bd0 c0x0000 (---------------)  + I samara
	0x0021adc7, // n0x1bd1 c0x0000 (---------------)  + I saratov
	0x002c9c88, // n0x1bd2 c0x0000 (---------------)  + I simbirsk
	0x0034b188, // n0x1bd3 c0x0000 (---------------)  + I smolensk
	0x002d6803, // n0x1bd4 c0x0000 (---------------)  + I snz
	0x00269c03, // n0x1bd5 c0x0000 (---------------)  + I spb
	0x00220649, // n0x1bd6 c0x0000 (---------------)  + I stavropol
	0x002490c3, // n0x1bd7 c0x0000 (---------------)  + I stv
	0x00341e46, // n0x1bd8 c0x0000 (---------------)  + I surgut
	0x0028c0c6, // n0x1bd9 c0x0000 (---------------)  + I syzran
	0x00317446, // n0x1bda c0x0000 (---------------)  + I tambov
	0x0036bec9, // n0x1bdb c0x0000 (---------------)  + I tatarstan
	0x002fdf44, // n0x1bdc c0x0000 (---------------)  + I test
	0x0020ae83, // n0x1bdd c0x0000 (---------------)  + I tom
	0x00332345, // n0x1bde c0x0000 (---------------)  + I tomsk
	0x0030d249, // n0x1bdf c0x0000 (---------------)  + I tsaritsyn
	0x00211d43, // n0x1be0 c0x0000 (---------------)  + I tsk
	0x0035bb44, // n0x1be1 c0x0000 (---------------)  + I tula
	0x002ef044, // n0x1be2 c0x0000 (---------------)  + I tuva
	0x00360d84, // n0x1be3 c0x0000 (---------------)  + I tver
	0x00321446, // n0x1be4 c0x0000 (---------------)  + I tyumen
	0x0020d2c3, // n0x1be5 c0x0000 (---------------)  + I udm
	0x0020d2c8, // n0x1be6 c0x0000 (---------------)  + I udmurtia
	0x00259f88, // n0x1be7 c0x0000 (---------------)  + I ulan-ude
	0x0033b846, // n0x1be8 c0x0000 (---------------)  + I vdonsk
	0x002f8a8b, // n0x1be9 c0x0000 (---------------)  + I vladikavkaz
	0x002f8dc8, // n0x1bea c0x0000 (---------------)  + I vladimir
	0x002f8fcb, // n0x1beb c0x0000 (---------------)  + I vladivostok
	0x002fb449, // n0x1bec c0x0000 (---------------)  + I volgograd
	0x002fa987, // n0x1bed c0x0000 (---------------)  + I vologda
	0x002fb8c8, // n0x1bee c0x0000 (---------------)  + I voronezh
	0x002fd583, // n0x1bef c0x0000 (---------------)  + I vrn
	0x00398fc6, // n0x1bf0 c0x0000 (---------------)  + I vyatka
	0x0020bb07, // n0x1bf1 c0x0000 (---------------)  + I yakutia
	0x002991c5, // n0x1bf2 c0x0000 (---------------)  + I yamal
	0x00344f89, // n0x1bf3 c0x0000 (---------------)  + I yaroslavl
	0x0031310d, // n0x1bf4 c0x0000 (---------------)  + I yekaterinburg
	0x0021c5d1, // n0x1bf5 c0x0000 (---------------)  + I yuzhno-sakhalinsk
	0x00237d05, // n0x1bf6 c0x0000 (---------------)  + I zgrad
	0x00200342, // n0x1bf7 c0x0000 (---------------)  + I ac
	0x0020ce42, // n0x1bf8 c0x0000 (---------------)  + I co
	0x00233243, // n0x1bf9 c0x0000 (---------------)  + I com
	0x00239103, // n0x1bfa c0x0000 (---------------)  + I edu
	0x002aebc4, // n0x1bfb c0x0000 (---------------)  + I gouv
	0x0027d903, // n0x1bfc c0x0000 (---------------)  + I gov
	0x00201503, // n0x1bfd c0x0000 (---------------)  + I int
	0x00207dc3, // n0x1bfe c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1bff c0x0000 (---------------)  + I net
	0x00233243, // n0x1c00 c0x0000 (---------------)  + I com
	0x00239103, // n0x1c01 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1c02 c0x0000 (---------------)  + I gov
	0x00213443, // n0x1c03 c0x0000 (---------------)  + I med
	0x00223b43, // n0x1c04 c0x0000 (---------------)  + I net
	0x00228743, // n0x1c05 c0x0000 (---------------)  + I org
	0x0028f343, // n0x1c06 c0x0000 (---------------)  + I pub
	0x00217283, // n0x1c07 c0x0000 (---------------)  + I sch
	0x00233243, // n0x1c08 c0x0000 (---------------)  + I com
	0x00239103, // n0x1c09 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1c0a c0x0000 (---------------)  + I gov
	0x00223b43, // n0x1c0b c0x0000 (---------------)  + I net
	0x00228743, // n0x1c0c c0x0000 (---------------)  + I org
	0x00233243, // n0x1c0d c0x0000 (---------------)  + I com
	0x00239103, // n0x1c0e c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1c0f c0x0000 (---------------)  + I gov
	0x00223b43, // n0x1c10 c0x0000 (---------------)  + I net
	0x00228743, // n0x1c11 c0x0000 (---------------)  + I org
	0x00233243, // n0x1c12 c0x0000 (---------------)  + I com
	0x00239103, // n0x1c13 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1c14 c0x0000 (---------------)  + I gov
	0x00201844, // n0x1c15 c0x0000 (---------------)  + I info
	0x00213443, // n0x1c16 c0x0000 (---------------)  + I med
	0x00223b43, // n0x1c17 c0x0000 (---------------)  + I net
	0x00228743, // n0x1c18 c0x0000 (---------------)  + I org
	0x002203c2, // n0x1c19 c0x0000 (---------------)  + I tv
	0x002001c1, // n0x1c1a c0x0000 (---------------)  + I a
	0x00200342, // n0x1c1b c0x0000 (---------------)  + I ac
	0x00200001, // n0x1c1c c0x0000 (---------------)  + I b
	0x00314f02, // n0x1c1d c0x0000 (---------------)  + I bd
	0x000fe108, // n0x1c1e c0x0000 (---------------)  +   blogspot
	0x00220945, // n0x1c1f c0x0000 (---------------)  + I brand
	0x00200141, // n0x1c20 c0x0000 (---------------)  + I c
	0x00033243, // n0x1c21 c0x0000 (---------------)  +   com
	0x00200201, // n0x1c22 c0x0000 (---------------)  + I d
	0x00200081, // n0x1c23 c0x0000 (---------------)  + I e
	0x00201701, // n0x1c24 c0x0000 (---------------)  + I f
	0x00233802, // n0x1c25 c0x0000 (---------------)  + I fh
	0x00233804, // n0x1c26 c0x0000 (---------------)  + I fhsk
	0x00363cc3, // n0x1c27 c0x0000 (---------------)  + I fhv
	0x00200281, // n0x1c28 c0x0000 (---------------)  + I g
	0x002003c1, // n0x1c29 c0x0000 (---------------)  + I h
	0x00200041, // n0x1c2a c0x0000 (---------------)  + I i
	0x00201b41, // n0x1c2b c0x0000 (---------------)  + I k
	0x002f2d87, // n0x1c2c c0x0000 (---------------)  + I komforb
	0x002d704f, // n0x1c2d c0x0000 (---------------)  + I kommunalforbund
	0x002bf6c6, // n0x1c2e c0x0000 (---------------)  + I komvux
	0x00200d41, // n0x1c2f c0x0000 (---------------)  + I l
	0x00268a06, // n0x1c30 c0x0000 (---------------)  + I lanbib
	0x00200441, // n0x1c31 c0x0000 (---------------)  + I m
	0x00200781, // n0x1c32 c0x0000 (---------------)  + I n
	0x0032158e, // n0x1c33 c0x0000 (---------------)  + I naturbruksgymn
	0x00200dc1, // n0x1c34 c0x0000 (---------------)  + I o
	0x00228743, // n0x1c35 c0x0000 (---------------)  + I org
	0x00200581, // n0x1c36 c0x0000 (---------------)  + I p
	0x002a4d85, // n0x1c37 c0x0000 (---------------)  + I parti
	0x002080c2, // n0x1c38 c0x0000 (---------------)  + I pp
	0x00246a05, // n0x1c39 c0x0000 (---------------)  + I press
	0x002006c1, // n0x1c3a c0x0000 (---------------)  + I r
	0x002000c1, // n0x1c3b c0x0000 (---------------)  + I s
	0x002004c1, // n0x1c3c c0x0000 (---------------)  + I t
	0x00200c82, // n0x1c3d c0x0000 (---------------)  + I tm
	0x00200741, // n0x1c3e c0x0000 (---------------)  + I u
	0x00201c41, // n0x1c3f c0x0000 (---------------)  + I w
	0x00200a01, // n0x1c40 c0x0000 (---------------)  + I x
	0x00200241, // n0x1c41 c0x0000 (---------------)  + I y
	0x00200101, // n0x1c42 c0x0000 (---------------)  + I z
	0x000fe108, // n0x1c43 c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x1c44 c0x0000 (---------------)  + I com
	0x00239103, // n0x1c45 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1c46 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x1c47 c0x0000 (---------------)  + I net
	0x00228743, // n0x1c48 c0x0000 (---------------)  + I org
	0x0021e783, // n0x1c49 c0x0000 (---------------)  + I per
	0x00233243, // n0x1c4a c0x0000 (---------------)  + I com
	0x0027d903, // n0x1c4b c0x0000 (---------------)  + I gov
	0x0008e988, // n0x1c4c c0x0000 (---------------)  +   hashbang
	0x00207dc3, // n0x1c4d c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1c4e c0x0000 (---------------)  + I net
	0x00228743, // n0x1c4f c0x0000 (---------------)  + I org
	0x014d8c48, // n0x1c50 c0x0005 (---------------)* o   platform
	0x000fe108, // n0x1c51 c0x0000 (---------------)  +   blogspot
	0x000fe108, // n0x1c52 c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x1c53 c0x0000 (---------------)  + I com
	0x00239103, // n0x1c54 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1c55 c0x0000 (---------------)  + I gov
	0x00223b43, // n0x1c56 c0x0000 (---------------)  + I net
	0x00228743, // n0x1c57 c0x0000 (---------------)  + I org
	0x00201d43, // n0x1c58 c0x0000 (---------------)  + I art
	0x000fe108, // n0x1c59 c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x1c5a c0x0000 (---------------)  + I com
	0x00239103, // n0x1c5b c0x0000 (---------------)  + I edu
	0x002aebc4, // n0x1c5c c0x0000 (---------------)  + I gouv
	0x00228743, // n0x1c5d c0x0000 (---------------)  + I org
	0x00299705, // n0x1c5e c0x0000 (---------------)  + I perso
	0x00309e44, // n0x1c5f c0x0000 (---------------)  + I univ
	0x00233243, // n0x1c60 c0x0000 (---------------)  + I com
	0x00223b43, // n0x1c61 c0x0000 (---------------)  + I net
	0x00228743, // n0x1c62 c0x0000 (---------------)  + I org
	0x0020ce42, // n0x1c63 c0x0000 (---------------)  + I co
	0x00233243, // n0x1c64 c0x0000 (---------------)  + I com
	0x002378c9, // n0x1c65 c0x0000 (---------------)  + I consulado
	0x00239103, // n0x1c66 c0x0000 (---------------)  + I edu
	0x0023b489, // n0x1c67 c0x0000 (---------------)  + I embaixada
	0x0027d903, // n0x1c68 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x1c69 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1c6a c0x0000 (---------------)  + I net
	0x00228743, // n0x1c6b c0x0000 (---------------)  + I org
	0x002e15c8, // n0x1c6c c0x0000 (---------------)  + I principe
	0x00213547, // n0x1c6d c0x0000 (---------------)  + I saotome
	0x00364cc5, // n0x1c6e c0x0000 (---------------)  + I store
	0x002001c7, // n0x1c6f c0x0000 (---------------)  + I adygeya
	0x00236d0b, // n0x1c70 c0x0000 (---------------)  + I arkhangelsk
	0x0020eb88, // n0x1c71 c0x0000 (---------------)  + I balashov
	0x00324289, // n0x1c72 c0x0000 (---------------)  + I bashkiria
	0x00229507, // n0x1c73 c0x0000 (---------------)  + I bryansk
	0x00202508, // n0x1c74 c0x0000 (---------------)  + I dagestan
	0x00289106, // n0x1c75 c0x0000 (---------------)  + I grozny
	0x00288007, // n0x1c76 c0x0000 (---------------)  + I ivanovo
	0x00225688, // n0x1c77 c0x0000 (---------------)  + I kalmykia
	0x00250706, // n0x1c78 c0x0000 (---------------)  + I kaluga
	0x00325cc7, // n0x1c79 c0x0000 (---------------)  + I karelia
	0x00233b09, // n0x1c7a c0x0000 (---------------)  + I khakassia
	0x0037d749, // n0x1c7b c0x0000 (---------------)  + I krasnodar
	0x002b8bc6, // n0x1c7c c0x0000 (---------------)  + I kurgan
	0x002b9ac5, // n0x1c7d c0x0000 (---------------)  + I lenug
	0x002c6f48, // n0x1c7e c0x0000 (---------------)  + I mordovia
	0x00253203, // n0x1c7f c0x0000 (---------------)  + I msk
	0x002cde48, // n0x1c80 c0x0000 (---------------)  + I murmansk
	0x00239307, // n0x1c81 c0x0000 (---------------)  + I nalchik
	0x00206143, // n0x1c82 c0x0000 (---------------)  + I nov
	0x00355647, // n0x1c83 c0x0000 (---------------)  + I obninsk
	0x00212605, // n0x1c84 c0x0000 (---------------)  + I penza
	0x002dda88, // n0x1c85 c0x0000 (---------------)  + I pokrovsk
	0x00274605, // n0x1c86 c0x0000 (---------------)  + I sochi
	0x00269c03, // n0x1c87 c0x0000 (---------------)  + I spb
	0x0034f6c9, // n0x1c88 c0x0000 (---------------)  + I togliatti
	0x002ab687, // n0x1c89 c0x0000 (---------------)  + I troitsk
	0x0035bb44, // n0x1c8a c0x0000 (---------------)  + I tula
	0x002ef044, // n0x1c8b c0x0000 (---------------)  + I tuva
	0x002f8a8b, // n0x1c8c c0x0000 (---------------)  + I vladikavkaz
	0x002f8dc8, // n0x1c8d c0x0000 (---------------)  + I vladimir
	0x002fa987, // n0x1c8e c0x0000 (---------------)  + I vologda
	0x00233243, // n0x1c8f c0x0000 (---------------)  + I com
	0x00239103, // n0x1c90 c0x0000 (---------------)  + I edu
	0x00212b03, // n0x1c91 c0x0000 (---------------)  + I gob
	0x00228743, // n0x1c92 c0x0000 (---------------)  + I org
	0x002437c3, // n0x1c93 c0x0000 (---------------)  + I red
	0x0027d903, // n0x1c94 c0x0000 (---------------)  + I gov
	0x00233243, // n0x1c95 c0x0000 (---------------)  + I com
	0x00239103, // n0x1c96 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1c97 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x1c98 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1c99 c0x0000 (---------------)  + I net
	0x00228743, // n0x1c9a c0x0000 (---------------)  + I org
	0x00200342, // n0x1c9b c0x0000 (---------------)  + I ac
	0x0020ce42, // n0x1c9c c0x0000 (---------------)  + I co
	0x00228743, // n0x1c9d c0x0000 (---------------)  + I org
	0x000fe108, // n0x1c9e c0x0000 (---------------)  +   blogspot
	0x00200342, // n0x1c9f c0x0000 (---------------)  + I ac
	0x0020ce42, // n0x1ca0 c0x0000 (---------------)  + I co
	0x00210a42, // n0x1ca1 c0x0000 (---------------)  + I go
	0x002012c2, // n0x1ca2 c0x0000 (---------------)  + I in
	0x00207dc2, // n0x1ca3 c0x0000 (---------------)  + I mi
	0x00223b43, // n0x1ca4 c0x0000 (---------------)  + I net
	0x00200dc2, // n0x1ca5 c0x0000 (---------------)  + I or
	0x00200342, // n0x1ca6 c0x0000 (---------------)  + I ac
	0x00331a83, // n0x1ca7 c0x0000 (---------------)  + I biz
	0x0020ce42, // n0x1ca8 c0x0000 (---------------)  + I co
	0x00233243, // n0x1ca9 c0x0000 (---------------)  + I com
	0x00239103, // n0x1caa c0x0000 (---------------)  + I edu
	0x00210a42, // n0x1cab c0x0000 (---------------)  + I go
	0x0027d903, // n0x1cac c0x0000 (---------------)  + I gov
	0x00201503, // n0x1cad c0x0000 (---------------)  + I int
	0x00207dc3, // n0x1cae c0x0000 (---------------)  + I mil
	0x00200904, // n0x1caf c0x0000 (---------------)  + I name
	0x00223b43, // n0x1cb0 c0x0000 (---------------)  + I net
	0x0021b843, // n0x1cb1 c0x0000 (---------------)  + I nic
	0x00228743, // n0x1cb2 c0x0000 (---------------)  + I org
	0x002fdf44, // n0x1cb3 c0x0000 (---------------)  + I test
	0x0021e243, // n0x1cb4 c0x0000 (---------------)  + I web
	0x0027d903, // n0x1cb5 c0x0000 (---------------)  + I gov
	0x0020ce42, // n0x1cb6 c0x0000 (---------------)  + I co
	0x00233243, // n0x1cb7 c0x0000 (---------------)  + I com
	0x00239103, // n0x1cb8 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1cb9 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x1cba c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1cbb c0x0000 (---------------)  + I net
	0x00201383, // n0x1cbc c0x0000 (---------------)  + I nom
	0x00228743, // n0x1cbd c0x0000 (---------------)  + I org
	0x00391d87, // n0x1cbe c0x0000 (---------------)  + I agrinet
	0x00233243, // n0x1cbf c0x0000 (---------------)  + I com
	0x00225c07, // n0x1cc0 c0x0000 (---------------)  + I defense
	0x0025d446, // n0x1cc1 c0x0000 (---------------)  + I edunet
	0x00215c43, // n0x1cc2 c0x0000 (---------------)  + I ens
	0x00201703, // n0x1cc3 c0x0000 (---------------)  + I fin
	0x0027d903, // n0x1cc4 c0x0000 (---------------)  + I gov
	0x00221b03, // n0x1cc5 c0x0000 (---------------)  + I ind
	0x00201844, // n0x1cc6 c0x0000 (---------------)  + I info
	0x0036cdc4, // n0x1cc7 c0x0000 (---------------)  + I intl
	0x002d8e06, // n0x1cc8 c0x0000 (---------------)  + I mincom
	0x0021a903, // n0x1cc9 c0x0000 (---------------)  + I nat
	0x00223b43, // n0x1cca c0x0000 (---------------)  + I net
	0x00228743, // n0x1ccb c0x0000 (---------------)  + I org
	0x00299705, // n0x1ccc c0x0000 (---------------)  + I perso
	0x0020e5c4, // n0x1ccd c0x0000 (---------------)  + I rnrt
	0x002300c3, // n0x1cce c0x0000 (---------------)  + I rns
	0x0037ba43, // n0x1ccf c0x0000 (---------------)  + I rnu
	0x002c1b87, // n0x1cd0 c0x0000 (---------------)  + I tourism
	0x00208c05, // n0x1cd1 c0x0000 (---------------)  + I turen
	0x00233243, // n0x1cd2 c0x0000 (---------------)  + I com
	0x00239103, // n0x1cd3 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1cd4 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x1cd5 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1cd6 c0x0000 (---------------)  + I net
	0x00228743, // n0x1cd7 c0x0000 (---------------)  + I org
	0x00202f02, // n0x1cd8 c0x0000 (---------------)  + I av
	0x002ccec3, // n0x1cd9 c0x0000 (---------------)  + I bbs
	0x00286003, // n0x1cda c0x0000 (---------------)  + I bel
	0x00331a83, // n0x1cdb c0x0000 (---------------)  + I biz
	0x51e33243, // n0x1cdc c0x0147 (n0x1ced-n0x1cee)  + I com
	0x0026ab42, // n0x1cdd c0x0000 (---------------)  + I dr
	0x00239103, // n0x1cde c0x0000 (---------------)  + I edu
	0x002060c3, // n0x1cdf c0x0000 (---------------)  + I gen
	0x0027d903, // n0x1ce0 c0x0000 (---------------)  + I gov
	0x00201844, // n0x1ce1 c0x0000 (---------------)  + I info
	0x00332603, // n0x1ce2 c0x0000 (---------------)  + I k12
	0x00248843, // n0x1ce3 c0x0000 (---------------)  + I kep
	0x00207dc3, // n0x1ce4 c0x0000 (---------------)  + I mil
	0x00200904, // n0x1ce5 c0x0000 (---------------)  + I name
	0x522095c2, // n0x1ce6 c0x0148 (n0x1cee-n0x1cef)  + I nc
	0x00223b43, // n0x1ce7 c0x0000 (---------------)  + I net
	0x00228743, // n0x1ce8 c0x0000 (---------------)  + I org
	0x00206ec3, // n0x1ce9 c0x0000 (---------------)  + I pol
	0x0022ce43, // n0x1cea c0x0000 (---------------)  + I tel
	0x002203c2, // n0x1ceb c0x0000 (---------------)  + I tv
	0x0021e243, // n0x1cec c0x0000 (---------------)  + I web
	0x000fe108, // n0x1ced c0x0000 (---------------)  +   blogspot
	0x0027d903, // n0x1cee c0x0000 (---------------)  + I gov
	0x002e2dc4, // n0x1cef c0x0000 (---------------)  + I aero
	0x00331a83, // n0x1cf0 c0x0000 (---------------)  + I biz
	0x0020ce42, // n0x1cf1 c0x0000 (---------------)  + I co
	0x00233243, // n0x1cf2 c0x0000 (---------------)  + I com
	0x0023c344, // n0x1cf3 c0x0000 (---------------)  + I coop
	0x00239103, // n0x1cf4 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1cf5 c0x0000 (---------------)  + I gov
	0x00201844, // n0x1cf6 c0x0000 (---------------)  + I info
	0x00201503, // n0x1cf7 c0x0000 (---------------)  + I int
	0x002e35c4, // n0x1cf8 c0x0000 (---------------)  + I jobs
	0x0020bf04, // n0x1cf9 c0x0000 (---------------)  + I mobi
	0x002d1086, // n0x1cfa c0x0000 (---------------)  + I museum
	0x00200904, // n0x1cfb c0x0000 (---------------)  + I name
	0x00223b43, // n0x1cfc c0x0000 (---------------)  + I net
	0x00228743, // n0x1cfd c0x0000 (---------------)  + I org
	0x00224b03, // n0x1cfe c0x0000 (---------------)  + I pro
	0x002a3206, // n0x1cff c0x0000 (---------------)  + I travel
	0x000569cb, // n0x1d00 c0x0000 (---------------)  +   better-than
	0x00013206, // n0x1d01 c0x0000 (---------------)  +   dyndns
	0x0001e08a, // n0x1d02 c0x0000 (---------------)  +   on-the-web
	0x000fd64a, // n0x1d03 c0x0000 (---------------)  +   worse-than
	0x000fe108, // n0x1d04 c0x0000 (---------------)  +   blogspot
	0x00378c44, // n0x1d05 c0x0000 (---------------)  + I club
	0x00233243, // n0x1d06 c0x0000 (---------------)  + I com
	0x00331a44, // n0x1d07 c0x0000 (---------------)  + I ebiz
	0x00239103, // n0x1d08 c0x0000 (---------------)  + I edu
	0x00298344, // n0x1d09 c0x0000 (---------------)  + I game
	0x0027d903, // n0x1d0a c0x0000 (---------------)  + I gov
	0x0020de03, // n0x1d0b c0x0000 (---------------)  + I idv
	0x00207dc3, // n0x1d0c c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1d0d c0x0000 (---------------)  + I net
	0x00228743, // n0x1d0e c0x0000 (---------------)  + I org
	0x00322ccb, // n0x1d0f c0x0000 (---------------)  + I xn--czrw28b
	0x0039378a, // n0x1d10 c0x0000 (---------------)  + I xn--uc0atv
	0x003a448c, // n0x1d11 c0x0000 (---------------)  + I xn--zf0ao64a
	0x00200342, // n0x1d12 c0x0000 (---------------)  + I ac
	0x0020ce42, // n0x1d13 c0x0000 (---------------)  + I co
	0x00210a42, // n0x1d14 c0x0000 (---------------)  + I go
	0x00234305, // n0x1d15 c0x0000 (---------------)  + I hotel
	0x00201844, // n0x1d16 c0x0000 (---------------)  + I info
	0x00200982, // n0x1d17 c0x0000 (---------------)  + I me
	0x00207dc3, // n0x1d18 c0x0000 (---------------)  + I mil
	0x0020bf04, // n0x1d19 c0x0000 (---------------)  + I mobi
	0x00202ac2, // n0x1d1a c0x0000 (---------------)  + I ne
	0x00200dc2, // n0x1d1b c0x0000 (---------------)  + I or
	0x00207f02, // n0x1d1c c0x0000 (---------------)  + I sc
	0x002203c2, // n0x1d1d c0x0000 (---------------)  + I tv
	0x00131a83, // n0x1d1e c0x0000 (---------------)  +   biz
	0x002ad149, // n0x1d1f c0x0000 (---------------)  + I cherkassy
	0x0028bf48, // n0x1d20 c0x0000 (---------------)  + I cherkasy
	0x0027d789, // n0x1d21 c0x0000 (---------------)  + I chernigov
	0x00287e49, // n0x1d22 c0x0000 (---------------)  + I chernihiv
	0x00374f4a, // n0x1d23 c0x0000 (---------------)  + I chernivtsi
	0x003682ca, // n0x1d24 c0x0000 (---------------)  + I chernovtsy
	0x0020d082, // n0x1d25 c0x0000 (---------------)  + I ck
	0x0021dac2, // n0x1d26 c0x0000 (---------------)  + I cn
	0x0000ce42, // n0x1d27 c0x0000 (---------------)  +   co
	0x00233243, // n0x1d28 c0x0000 (---------------)  + I com
	0x002051c2, // n0x1d29 c0x0000 (---------------)  + I cr
	0x00244dc6, // n0x1d2a c0x0000 (---------------)  + I crimea
	0x00350e42, // n0x1d2b c0x0000 (---------------)  + I cv
	0x0020df02, // n0x1d2c c0x0000 (---------------)  + I dn
	0x0022978e, // n0x1d2d c0x0000 (---------------)  + I dnepropetrovsk
	0x0027278e, // n0x1d2e c0x0000 (---------------)  + I dnipropetrovsk
	0x0027d607, // n0x1d2f c0x0000 (---------------)  + I dominic
	0x00311587, // n0x1d30 c0x0000 (---------------)  + I donetsk
	0x002d73c2, // n0x1d31 c0x0000 (---------------)  + I dp
	0x00239103, // n0x1d32 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1d33 c0x0000 (---------------)  + I gov
	0x00201a82, // n0x1d34 c0x0000 (---------------)  + I if
	0x002012c2, // n0x1d35 c0x0000 (---------------)  + I in
	0x0024008f, // n0x1d36 c0x0000 (---------------)  + I ivano-frankivsk
	0x0021c802, // n0x1d37 c0x0000 (---------------)  + I kh
	0x00234cc7, // n0x1d38 c0x0000 (---------------)  + I kharkiv
	0x0023fa47, // n0x1d39 c0x0000 (---------------)  + I kharkov
	0x00240407, // n0x1d3a c0x0000 (---------------)  + I kherson
	0x002408cc, // n0x1d3b c0x0000 (---------------)  + I khmelnitskiy
	0x0024aacc, // n0x1d3c c0x0000 (---------------)  + I khmelnytskyi
	0x00202984, // n0x1d3d c0x0000 (---------------)  + I kiev
	0x0027f80a, // n0x1d3e c0x0000 (---------------)  + I kirovograd
	0x00238982, // n0x1d3f c0x0000 (---------------)  + I km
	0x0020bdc2, // n0x1d40 c0x0000 (---------------)  + I kr
	0x002b3084, // n0x1d41 c0x0000 (---------------)  + I krym
	0x00255342, // n0x1d42 c0x0000 (---------------)  + I ks
	0x002bd642, // n0x1d43 c0x0000 (---------------)  + I kv
	0x0024ad04, // n0x1d44 c0x0000 (---------------)  + I kyiv
	0x0021b942, // n0x1d45 c0x0000 (---------------)  + I lg
	0x00208bc2, // n0x1d46 c0x0000 (---------------)  + I lt
	0x00250787, // n0x1d47 c0x0000 (---------------)  + I lugansk
	0x00234bc5, // n0x1d48 c0x0000 (---------------)  + I lutsk
	0x00206582, // n0x1d49 c0x0000 (---------------)  + I lv
	0x00240004, // n0x1d4a c0x0000 (---------------)  + I lviv
	0x00367282, // n0x1d4b c0x0000 (---------------)  + I mk
	0x00358908, // n0x1d4c c0x0000 (---------------)  + I mykolaiv
	0x00223b43, // n0x1d4d c0x0000 (---------------)  + I net
	0x00202f88, // n0x1d4e c0x0000 (---------------)  + I nikolaev
	0x00205f42, // n0x1d4f c0x0000 (---------------)  + I od
	0x0023a445, // n0x1d50 c0x0000 (---------------)  + I odesa
	0x00370ec6, // n0x1d51 c0x0000 (---------------)  + I odessa
	0x00228743, // n0x1d52 c0x0000 (---------------)  + I org
	0x00209442, // n0x1d53 c0x0000 (---------------)  + I pl
	0x002de347, // n0x1d54 c0x0000 (---------------)  + I poltava
	0x000080c2, // n0x1d55 c0x0000 (---------------)  +   pp
	0x002e1805, // n0x1d56 c0x0000 (---------------)  + I rivne
	0x0038a0c5, // n0x1d57 c0x0000 (---------------)  + I rovno
	0x0020b7c2, // n0x1d58 c0x0000 (---------------)  + I rv
	0x002286c2, // n0x1d59 c0x0000 (---------------)  + I sb
	0x00206d0a, // n0x1d5a c0x0000 (---------------)  + I sebastopol
	0x0024d34a, // n0x1d5b c0x0000 (---------------)  + I sevastopol
	0x00213e02, // n0x1d5c c0x0000 (---------------)  + I sm
	0x00358884, // n0x1d5d c0x0000 (---------------)  + I sumy
	0x00200a82, // n0x1d5e c0x0000 (---------------)  + I te
	0x00309888, // n0x1d5f c0x0000 (---------------)  + I ternopil
	0x0020fec2, // n0x1d60 c0x0000 (---------------)  + I uz
	0x0029e748, // n0x1d61 c0x0000 (---------------)  + I uzhgorod
	0x002f5bc7, // n0x1d62 c0x0000 (---------------)  + I vinnica
	0x002f6789, // n0x1d63 c0x0000 (---------------)  + I vinnytsia
	0x00202f42, // n0x1d64 c0x0000 (---------------)  + I vn
	0x002fb685, // n0x1d65 c0x0000 (---------------)  + I volyn
	0x0028c405, // n0x1d66 c0x0000 (---------------)  + I yalta
	0x002c4dcb, // n0x1d67 c0x0000 (---------------)  + I zaporizhzhe
	0x002c580c, // n0x1d68 c0x0000 (---------------)  + I zaporizhzhia
	0x002306c8, // n0x1d69 c0x0000 (---------------)  + I zhitomir
	0x002fba48, // n0x1d6a c0x0000 (---------------)  + I zhytomyr
	0x00262bc2, // n0x1d6b c0x0000 (---------------)  + I zp
	0x0021f6c2, // n0x1d6c c0x0000 (---------------)  + I zt
	0x00200342, // n0x1d6d c0x0000 (---------------)  + I ac
	0x000fe108, // n0x1d6e c0x0000 (---------------)  +   blogspot
	0x0020ce42, // n0x1d6f c0x0000 (---------------)  + I co
	0x00233243, // n0x1d70 c0x0000 (---------------)  + I com
	0x00210a42, // n0x1d71 c0x0000 (---------------)  + I go
	0x00202ac2, // n0x1d72 c0x0000 (---------------)  + I ne
	0x00200dc2, // n0x1d73 c0x0000 (---------------)  + I or
	0x00228743, // n0x1d74 c0x0000 (---------------)  + I org
	0x00207f02, // n0x1d75 c0x0000 (---------------)  + I sc
	0x00200342, // n0x1d76 c0x0000 (---------------)  + I ac
	0x5420ce42, // n0x1d77 c0x0150 (n0x1d81-n0x1d82)  + I co
	0x5467d903, // n0x1d78 c0x0151 (n0x1d82-n0x1d83)  + I gov
	0x00312883, // n0x1d79 c0x0000 (---------------)  + I ltd
	0x00200982, // n0x1d7a c0x0000 (---------------)  + I me
	0x00223b43, // n0x1d7b c0x0000 (---------------)  + I net
	0x0038dd03, // n0x1d7c c0x0000 (---------------)  + I nhs
	0x00228743, // n0x1d7d c0x0000 (---------------)  + I org
	0x002d96c3, // n0x1d7e c0x0000 (---------------)  + I plc
	0x002207c6, // n0x1d7f c0x0000 (---------------)  + I police
	0x01617283, // n0x1d80 c0x0005 (---------------)* o I sch
	0x000fe108, // n0x1d81 c0x0000 (---------------)  +   blogspot
	0x0000b747, // n0x1d82 c0x0000 (---------------)  +   service
	0x54e02942, // n0x1d83 c0x0153 (n0x1dc2-n0x1dc5)  + I ak
	0x55200d02, // n0x1d84 c0x0154 (n0x1dc5-n0x1dc8)  + I al
	0x55601d42, // n0x1d85 c0x0155 (n0x1dc8-n0x1dcb)  + I ar
	0x55a03302, // n0x1d86 c0x0156 (n0x1dcb-n0x1dce)  + I as
	0x55e03442, // n0x1d87 c0x0157 (n0x1dce-n0x1dd1)  + I az
	0x56200e42, // n0x1d88 c0x0158 (n0x1dd1-n0x1dd4)  + I ca
	0x5660ce42, // n0x1d89 c0x0159 (n0x1dd4-n0x1dd7)  + I co
	0x56a2af82, // n0x1d8a c0x015a (n0x1dd7-n0x1dda)  + I ct
	0x56e23882, // n0x1d8b c0x015b (n0x1dda-n0x1ddd)  + I dc
	0x57205582, // n0x1d8c c0x015c (n0x1ddd-n0x1de0)  + I de
	0x00272783, // n0x1d8d c0x0000 (---------------)  + I dni
	0x00210083, // n0x1d8e c0x0000 (---------------)  + I fed
	0x57617402, // n0x1d8f c0x015d (n0x1de0-n0x1de3)  + I fl
	0x57a01bc2, // n0x1d90 c0x015e (n0x1de3-n0x1de6)  + I ga
	0x57e0efc2, // n0x1d91 c0x015f (n0x1de6-n0x1de9)  + I gu
	0x582003c2, // n0x1d92 c0x0160 (n0x1de9-n0x1deb)  + I hi
	0x586019c2, // n0x1d93 c0x0161 (n0x1deb-n0x1dee)  + I ia
	0x58a0d9c2, // n0x1d94 c0x0162 (n0x1dee-n0x1df1)  + I id
	0x58e027c2, // n0x1d95 c0x0163 (n0x1df1-n0x1df4)  + I il
	0x592012c2, // n0x1d96 c0x0164 (n0x1df4-n0x1df7)  + I in
	0x000b1f45, // n0x1d97 c0x0000 (---------------)  +   is-by
	0x00226dc3, // n0x1d98 c0x0000 (---------------)  + I isa
	0x0033c884, // n0x1d99 c0x0000 (---------------)  + I kids
	0x59655342, // n0x1d9a c0x0165 (n0x1df7-n0x1dfa)  + I ks
	0x59a36f82, // n0x1d9b c0x0166 (n0x1dfa-n0x1dfd)  + I ky
	0x59e03082, // n0x1d9c c0x0167 (n0x1dfd-n0x1e00)  + I la
	0x0007938b, // n0x1d9d c0x0000 (---------------)  +   land-4-sale
	0x5a200442, // n0x1d9e c0x0168 (n0x1e00-n0x1e03)  + I ma
	0x5aa4dd82, // n0x1d9f c0x016a (n0x1e06-n0x1e09)  + I md
	0x5ae00982, // n0x1da0 c0x016b (n0x1e09-n0x1e0c)  + I me
	0x5b207dc2, // n0x1da1 c0x016c (n0x1e0c-n0x1e0f)  + I mi
	0x5b623b02, // n0x1da2 c0x016d (n0x1e0f-n0x1e12)  + I mn
	0x5ba08442, // n0x1da3 c0x016e (n0x1e12-n0x1e15)  + I mo
	0x5be10f42, // n0x1da4 c0x016f (n0x1e15-n0x1e18)  + I ms
	0x5c205402, // n0x1da5 c0x0170 (n0x1e18-n0x1e1b)  + I mt
	0x5c6095c2, // n0x1da6 c0x0171 (n0x1e1b-n0x1e1e)  + I nc
	0x5ca00782, // n0x1da7 c0x0172 (n0x1e1e-n0x1e20)  + I nd
	0x5ce02ac2, // n0x1da8 c0x0173 (n0x1e20-n0x1e23)  + I ne
	0x5d202e82, // n0x1da9 c0x0174 (n0x1e23-n0x1e26)  + I nh
	0x5d601082, // n0x1daa c0x0175 (n0x1e26-n0x1e29)  + I nj
	0x5da2b882, // n0x1dab c0x0176 (n0x1e29-n0x1e2c)  + I nm
	0x00360a83, // n0x1dac c0x0000 (---------------)  + I nsn
	0x5de09842, // n0x1dad c0x0177 (n0x1e2c-n0x1e2f)  + I nv
	0x5e21c582, // n0x1dae c0x0178 (n0x1e2f-n0x1e32)  + I ny
	0x5e609342, // n0x1daf c0x0179 (n0x1e32-n0x1e35)  + I oh
	0x5ea035c2, // n0x1db0 c0x017a (n0x1e35-n0x1e38)  + I ok
	0x5ee00dc2, // n0x1db1 c0x017b (n0x1e38-n0x1e3b)  + I or
	0x5f20aac2, // n0x1db2 c0x017c (n0x1e3b-n0x1e3e)  + I pa
	0x5f604e02, // n0x1db3 c0x017d (n0x1e3e-n0x1e41)  + I pr
	0x5fa04e42, // n0x1db4 c0x017e (n0x1e41-n0x1e44)  + I ri
	0x5fe07f02, // n0x1db5 c0x017f (n0x1e44-n0x1e47)  + I sc
	0x6022b2c2, // n0x1db6 c0x0180 (n0x1e47-n0x1e49)  + I sd
	0x000e8a0c, // n0x1db7 c0x0000 (---------------)  +   stuff-4-sale
	0x6064fd82, // n0x1db8 c0x0181 (n0x1e49-n0x1e4c)  + I tn
	0x60a73102, // n0x1db9 c0x0182 (n0x1e4c-n0x1e4f)  + I tx
	0x60e03f42, // n0x1dba c0x0183 (n0x1e4f-n0x1e52)  + I ut
	0x61200c02, // n0x1dbb c0x0184 (n0x1e52-n0x1e55)  + I va
	0x616065c2, // n0x1dbc c0x0185 (n0x1e55-n0x1e58)  + I vi
	0x61a6a302, // n0x1dbd c0x0186 (n0x1e58-n0x1e5b)  + I vt
	0x61e01c42, // n0x1dbe c0x0187 (n0x1e5b-n0x1e5e)  + I wa
	0x62205c42, // n0x1dbf c0x0188 (n0x1e5e-n0x1e61)  + I wi
	0x626753c2, // n0x1dc0 c0x0189 (n0x1e61-n0x1e62)  + I wv
	0x62a71c82, // n0x1dc1 c0x018a (n0x1e62-n0x1e65)  + I wy
	0x0022f6c2, // n0x1dc2 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1dc3 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1dc4 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1dc5 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1dc6 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1dc7 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1dc8 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1dc9 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1dca c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1dcb c0x0000 (---------------)  + I cc
	0x00332603, // n0x1dcc c0x0000 (---------------)  + I k12
	0x00272043, // n0x1dcd c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1dce c0x0000 (---------------)  + I cc
	0x00332603, // n0x1dcf c0x0000 (---------------)  + I k12
	0x00272043, // n0x1dd0 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1dd1 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1dd2 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1dd3 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1dd4 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1dd5 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1dd6 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1dd7 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1dd8 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1dd9 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1dda c0x0000 (---------------)  + I cc
	0x00332603, // n0x1ddb c0x0000 (---------------)  + I k12
	0x00272043, // n0x1ddc c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1ddd c0x0000 (---------------)  + I cc
	0x00332603, // n0x1dde c0x0000 (---------------)  + I k12
	0x00272043, // n0x1ddf c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1de0 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1de1 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1de2 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1de3 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1de4 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1de5 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1de6 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1de7 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1de8 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1de9 c0x0000 (---------------)  + I cc
	0x00272043, // n0x1dea c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1deb c0x0000 (---------------)  + I cc
	0x00332603, // n0x1dec c0x0000 (---------------)  + I k12
	0x00272043, // n0x1ded c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1dee c0x0000 (---------------)  + I cc
	0x00332603, // n0x1def c0x0000 (---------------)  + I k12
	0x00272043, // n0x1df0 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1df1 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1df2 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1df3 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1df4 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1df5 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1df6 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1df7 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1df8 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1df9 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1dfa c0x0000 (---------------)  + I cc
	0x00332603, // n0x1dfb c0x0000 (---------------)  + I k12
	0x00272043, // n0x1dfc c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1dfd c0x0000 (---------------)  + I cc
	0x00332603, // n0x1dfe c0x0000 (---------------)  + I k12
	0x00272043, // n0x1dff c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e00 c0x0000 (---------------)  + I cc
	0x5a732603, // n0x1e01 c0x0169 (n0x1e03-n0x1e06)  + I k12
	0x00272043, // n0x1e02 c0x0000 (---------------)  + I lib
	0x00305c04, // n0x1e03 c0x0000 (---------------)  + I chtr
	0x0028be46, // n0x1e04 c0x0000 (---------------)  + I paroch
	0x002e62c3, // n0x1e05 c0x0000 (---------------)  + I pvt
	0x0022f6c2, // n0x1e06 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e07 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e08 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e09 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e0a c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e0b c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e0c c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e0d c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e0e c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e0f c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e10 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e11 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e12 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e13 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e14 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e15 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e16 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e17 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e18 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e19 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e1a c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e1b c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e1c c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e1d c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e1e c0x0000 (---------------)  + I cc
	0x00272043, // n0x1e1f c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e20 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e21 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e22 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e23 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e24 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e25 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e26 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e27 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e28 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e29 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e2a c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e2b c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e2c c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e2d c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e2e c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e2f c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e30 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e31 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e32 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e33 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e34 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e35 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e36 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e37 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e38 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e39 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e3a c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e3b c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e3c c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e3d c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e3e c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e3f c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e40 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e41 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e42 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e43 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e44 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e45 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e46 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e47 c0x0000 (---------------)  + I cc
	0x00272043, // n0x1e48 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e49 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e4a c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e4b c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e4c c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e4d c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e4e c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e4f c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e50 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e51 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e52 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e53 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e54 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e55 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e56 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e57 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e58 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e59 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e5a c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e5b c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e5c c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e5d c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e5e c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e5f c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e60 c0x0000 (---------------)  + I lib
	0x0022f6c2, // n0x1e61 c0x0000 (---------------)  + I cc
	0x0022f6c2, // n0x1e62 c0x0000 (---------------)  + I cc
	0x00332603, // n0x1e63 c0x0000 (---------------)  + I k12
	0x00272043, // n0x1e64 c0x0000 (---------------)  + I lib
	0x63233243, // n0x1e65 c0x018c (n0x1e6b-n0x1e6c)  + I com
	0x00239103, // n0x1e66 c0x0000 (---------------)  + I edu
	0x00255e83, // n0x1e67 c0x0000 (---------------)  + I gub
	0x00207dc3, // n0x1e68 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1e69 c0x0000 (---------------)  + I net
	0x00228743, // n0x1e6a c0x0000 (---------------)  + I org
	0x000fe108, // n0x1e6b c0x0000 (---------------)  +   blogspot
	0x0020ce42, // n0x1e6c c0x0000 (---------------)  + I co
	0x00233243, // n0x1e6d c0x0000 (---------------)  + I com
	0x00223b43, // n0x1e6e c0x0000 (---------------)  + I net
	0x00228743, // n0x1e6f c0x0000 (---------------)  + I org
	0x00233243, // n0x1e70 c0x0000 (---------------)  + I com
	0x00239103, // n0x1e71 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1e72 c0x0000 (---------------)  + I gov
	0x00207dc3, // n0x1e73 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1e74 c0x0000 (---------------)  + I net
	0x00228743, // n0x1e75 c0x0000 (---------------)  + I org
	0x0024b944, // n0x1e76 c0x0000 (---------------)  + I arts
	0x0020ce42, // n0x1e77 c0x0000 (---------------)  + I co
	0x00233243, // n0x1e78 c0x0000 (---------------)  + I com
	0x003830c3, // n0x1e79 c0x0000 (---------------)  + I e12
	0x00239103, // n0x1e7a c0x0000 (---------------)  + I edu
	0x0024dcc4, // n0x1e7b c0x0000 (---------------)  + I firm
	0x00212b03, // n0x1e7c c0x0000 (---------------)  + I gob
	0x0027d903, // n0x1e7d c0x0000 (---------------)  + I gov
	0x00201844, // n0x1e7e c0x0000 (---------------)  + I info
	0x00201503, // n0x1e7f c0x0000 (---------------)  + I int
	0x00207dc3, // n0x1e80 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1e81 c0x0000 (---------------)  + I net
	0x00228743, // n0x1e82 c0x0000 (---------------)  + I org
	0x0022c2c3, // n0x1e83 c0x0000 (---------------)  + I rec
	0x00364cc5, // n0x1e84 c0x0000 (---------------)  + I store
	0x00243703, // n0x1e85 c0x0000 (---------------)  + I tec
	0x0021e243, // n0x1e86 c0x0000 (---------------)  + I web
	0x0020ce42, // n0x1e87 c0x0000 (---------------)  + I co
	0x00233243, // n0x1e88 c0x0000 (---------------)  + I com
	0x00332603, // n0x1e89 c0x0000 (---------------)  + I k12
	0x00223b43, // n0x1e8a c0x0000 (---------------)  + I net
	0x00228743, // n0x1e8b c0x0000 (---------------)  + I org
	0x00200342, // n0x1e8c c0x0000 (---------------)  + I ac
	0x00331a83, // n0x1e8d c0x0000 (---------------)  + I biz
	0x000fe108, // n0x1e8e c0x0000 (---------------)  +   blogspot
	0x00233243, // n0x1e8f c0x0000 (---------------)  + I com
	0x00239103, // n0x1e90 c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1e91 c0x0000 (---------------)  + I gov
	0x002ae586, // n0x1e92 c0x0000 (---------------)  + I health
	0x00201844, // n0x1e93 c0x0000 (---------------)  + I info
	0x00201503, // n0x1e94 c0x0000 (---------------)  + I int
	0x00200904, // n0x1e95 c0x0000 (---------------)  + I name
	0x00223b43, // n0x1e96 c0x0000 (---------------)  + I net
	0x00228743, // n0x1e97 c0x0000 (---------------)  + I org
	0x00224b03, // n0x1e98 c0x0000 (---------------)  + I pro
	0x00233243, // n0x1e99 c0x0000 (---------------)  + I com
	0x00239103, // n0x1e9a c0x0000 (---------------)  + I edu
	0x00223b43, // n0x1e9b c0x0000 (---------------)  + I net
	0x00228743, // n0x1e9c c0x0000 (---------------)  + I org
	0x00233243, // n0x1e9d c0x0000 (---------------)  + I com
	0x00013206, // n0x1e9e c0x0000 (---------------)  +   dyndns
	0x00239103, // n0x1e9f c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1ea0 c0x0000 (---------------)  + I gov
	0x000d1e46, // n0x1ea1 c0x0000 (---------------)  +   mypets
	0x00223b43, // n0x1ea2 c0x0000 (---------------)  + I net
	0x00228743, // n0x1ea3 c0x0000 (---------------)  + I org
	0x0030ba08, // n0x1ea4 c0x0000 (---------------)  + I xn--80au
	0x0030e409, // n0x1ea5 c0x0000 (---------------)  + I xn--90azh
	0x0031b349, // n0x1ea6 c0x0000 (---------------)  + I xn--c1avg
	0x0032a188, // n0x1ea7 c0x0000 (---------------)  + I xn--d1at
	0x00372e88, // n0x1ea8 c0x0000 (---------------)  + I xn--o1ac
	0x00372e89, // n0x1ea9 c0x0000 (---------------)  + I xn--o1ach
	0x00200342, // n0x1eaa c0x0000 (---------------)  + I ac
	0x00208a45, // n0x1eab c0x0000 (---------------)  + I agric
	0x00239743, // n0x1eac c0x0000 (---------------)  + I alt
	0x65a0ce42, // n0x1ead c0x0196 (n0x1ebb-n0x1ebc)  + I co
	0x00239103, // n0x1eae c0x0000 (---------------)  + I edu
	0x0027d903, // n0x1eaf c0x0000 (---------------)  + I gov
	0x0037bc87, // n0x1eb0 c0x0000 (---------------)  + I grondar
	0x00271c03, // n0x1eb1 c0x0000 (---------------)  + I law
	0x00207dc3, // n0x1eb2 c0x0000 (---------------)  + I mil
	0x00223b43, // n0x1eb3 c0x0000 (---------------)  + I net
	0x0023b383, // n0x1eb4 c0x0000 (---------------)  + I ngo
	0x00210383, // n0x1eb5 c0x0000 (---------------)  + I nis
	0x00201383, // n0x1eb6 c0x0000 (---------------)  + I nom
	0x00228743, // n0x1eb7 c0x0000 (---------------)  + I org
	0x00232186, // n0x1eb8 c0x0000 (---------------)  + I school
	0x00200c82, // n0x1eb9 c0x0000 (---------------)  + I tm
	0x0021e243, // n0x1eba c0x0000 (---------------)  + I web
	0x000fe108, // n0x1ebb c0x0000 (---------------)  +   blogspot
}

// children is the list of nodes' children, the parent's wildcard bit and the
// parent's node type. If a node has no children then their children index
// will be in the range [0, 6), depending on the wildcard bit and node type.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 1 bits] wildcard bit
//	[ 2 bits] node type
//	[14 bits] high nodes index (exclusive) of children
//	[14 bits] low nodes index (inclusive) of children
var children = [...]uint32{
	0x00000000, // c0x0000 (---------------)  +
	0x10000000, // c0x0001 (---------------)  !
	0x20000000, // c0x0002 (---------------)  o
	0x40000000, // c0x0003 (---------------)* +
	0x50000000, // c0x0004 (---------------)* !
	0x60000000, // c0x0005 (---------------)* o
	0x01834607, // c0x0006 (n0x0607-n0x060d)  +
	0x0183860d, // c0x0007 (n0x060d-n0x060e)  +
	0x0185860e, // c0x0008 (n0x060e-n0x0616)  +
	0x019b4616, // c0x0009 (n0x0616-n0x066d)  +
	0x019c866d, // c0x000a (n0x066d-n0x0672)  +
	0x019dc672, // c0x000b (n0x0672-n0x0677)  +
	0x019ec677, // c0x000c (n0x0677-n0x067b)  +
	0x01a0867b, // c0x000d (n0x067b-n0x0682)  +
	0x01a0c682, // c0x000e (n0x0682-n0x0683)  +
	0x01a24683, // c0x000f (n0x0683-n0x0689)  +
	0x01a48689, // c0x0010 (n0x0689-n0x0692)  +
	0x01a4c692, // c0x0011 (n0x0692-n0x0693)  +
	0x01a64693, // c0x0012 (n0x0693-n0x0699)  +
	0x01a68699, // c0x0013 (n0x0699-n0x069a)  +
	0x01a8469a, // c0x0014 (n0x069a-n0x06a1)  +
	0x01a886a1, // c0x0015 (n0x06a1-n0x06a2)  +
	0x01ad06a2, // c0x0016 (n0x06a2-n0x06b4)  +
	0x01ad46b4, // c0x0017 (n0x06b4-n0x06b5)  +
	0x01af46b5, // c0x0018 (n0x06b5-n0x06bd)  +
	0x01b086bd, // c0x0019 (n0x06bd-n0x06c2)  +
	0x01b0c6c2, // c0x001a (n0x06c2-n0x06c3)  +
	0x01b3c6c3, // c0x001b (n0x06c3-n0x06cf)  +
	0x01b686cf, // c0x001c (n0x06cf-n0x06da)  +
	0x01b906da, // c0x001d (n0x06da-n0x06e4)  +
	0x01b986e4, // c0x001e (n0x06e4-n0x06e6)  +
	0x01b9c6e6, // c0x001f (n0x06e6-n0x06e7)  +
	0x01c306e7, // c0x0020 (n0x06e7-n0x070c)  +
	0x01c4470c, // c0x0021 (n0x070c-n0x0711)  +
	0x01c58711, // c0x0022 (n0x0711-n0x0716)  +
	0x01c78716, // c0x0023 (n0x0716-n0x071e)  +
	0x01c8871e, // c0x0024 (n0x071e-n0x0722)  +
	0x01c9c722, // c0x0025 (n0x0722-n0x0727)  +
	0x01cc0727, // c0x0026 (n0x0727-n0x0730)  +
	0x01dd8730, // c0x0027 (n0x0730-n0x0776)  +
	0x01ddc776, // c0x0028 (n0x0776-n0x0777)  +
	0x01df0777, // c0x0029 (n0x0777-n0x077c)  +
	0x01e0477c, // c0x002a (n0x077c-n0x0781)  +
	0x01e0c781, // c0x002b (n0x0781-n0x0783)  +
	0x01e1c783, // c0x002c (n0x0783-n0x0787)  +
	0x01e20787, // c0x002d (n0x0787-n0x0788)  +
	0x01e38788, // c0x002e (n0x0788-n0x078e)  +
	0x01e7c78e, // c0x002f (n0x078e-n0x079f)  +
	0x01e8c79f, // c0x0030 (n0x079f-n0x07a3)  +
	0x01e907a3, // c0x0031 (n0x07a3-n0x07a4)  +
	0x01e947a4, // c0x0032 (n0x07a4-n0x07a5)  +
	0x01e987a5, // c0x0033 (n0x07a5-n0x07a6)  +
	0x01ed47a6, // c0x0034 (n0x07a6-n0x07b5)  +
	0x61ed87b5, // c0x0035 (n0x07b5-n0x07b6)* o
	0x01eec7b6, // c0x0036 (n0x07b6-n0x07bb)  +
	0x01efc7bb, // c0x0037 (n0x07bb-n0x07bf)  +
	0x01fb07bf, // c0x0038 (n0x07bf-n0x07ec)  +
	0x21fb47ec, // c0x0039 (n0x07ec-n0x07ed)  o
	0x01fb87ed, // c0x003a (n0x07ed-n0x07ee)  +
	0x01fbc7ee, // c0x003b (n0x07ee-n0x07ef)  +
	0x21fc07ef, // c0x003c (n0x07ef-n0x07f0)  o
	0x21fc47f0, // c0x003d (n0x07f0-n0x07f1)  o
	0x01ff87f1, // c0x003e (n0x07f1-n0x07fe)  +
	0x01ffc7fe, // c0x003f (n0x07fe-n0x07ff)  +
	0x023447ff, // c0x0040 (n0x07ff-n0x08d1)  +
	0x2238c8d1, // c0x0041 (n0x08d1-n0x08e3)  o
	0x023b08e3, // c0x0042 (n0x08e3-n0x08ec)  +
	0x023b88ec, // c0x0043 (n0x08ec-n0x08ee)  +
	0x223bc8ee, // c0x0044 (n0x08ee-n0x08ef)  o
	0x223c08ef, // c0x0045 (n0x08ef-n0x08f0)  o
	0x023dc8f0, // c0x0046 (n0x08f0-n0x08f7)  +
	0x023f48f7, // c0x0047 (n0x08f7-n0x08fd)  +
	0x023f88fd, // c0x0048 (n0x08fd-n0x08fe)  +
	0x024088fe, // c0x0049 (n0x08fe-n0x0902)  +
	0x02410902, // c0x004a (n0x0902-n0x0904)  +
	0x22444904, // c0x004b (n0x0904-n0x0911)  o
	0x02448911, // c0x004c (n0x0911-n0x0912)  +
	0x02450912, // c0x004d (n0x0912-n0x0914)  +
	0x02470914, // c0x004e (n0x0914-n0x091c)  +
	0x0247491c, // c0x004f (n0x091c-n0x091d)  +
	0x0248891d, // c0x0050 (n0x091d-n0x0922)  +
	0x024b0922, // c0x0051 (n0x0922-n0x092c)  +
	0x024d092c, // c0x0052 (n0x092c-n0x0934)  +
	0x02500934, // c0x0053 (n0x0934-n0x0940)  +
	0x02528940, // c0x0054 (n0x0940-n0x094a)  +
	0x0252c94a, // c0x0055 (n0x094a-n0x094b)  +
	0x0255094b, // c0x0056 (n0x094b-n0x0954)  +
	0x02554954, // c0x0057 (n0x0954-n0x0955)  +
	0x02568955, // c0x0058 (n0x0955-n0x095a)  +
	0x0256c95a, // c0x0059 (n0x095a-n0x095b)  +
	0x0258c95b, // c0x005a (n0x095b-n0x0963)  +
	0x02598963, // c0x005b (n0x0963-n0x0966)  +
	0x025f8966, // c0x005c (n0x0966-n0x097e)  +
	0x0261497e, // c0x005d (n0x097e-n0x0985)  +
	0x02620985, // c0x005e (n0x0985-n0x0988)  +
	0x02634988, // c0x005f (n0x0988-n0x098d)  +
	0x0264c98d, // c0x0060 (n0x098d-n0x0993)  +
	0x02660993, // c0x0061 (n0x0993-n0x0998)  +
	0x02678998, // c0x0062 (n0x0998-n0x099e)  +
	0x0269099e, // c0x0063 (n0x099e-n0x09a4)  +
	0x026a89a4, // c0x0064 (n0x09a4-n0x09aa)  +
	0x026c49aa, // c0x0065 (n0x09aa-n0x09b1)  +
	0x026dc9b1, // c0x0066 (n0x09b1-n0x09b7)  +
	0x0273c9b7, // c0x0067 (n0x09b7-n0x09cf)  +
	0x027549cf, // c0x0068 (n0x09cf-n0x09d5)  +
	0x027689d5, // c0x0069 (n0x09d5-n0x09da)  +
	0x027ac9da, // c0x006a (n0x09da-n0x09eb)  +
	0x0282c9eb, // c0x006b (n0x09eb-n0x0a0b)  +
	0x02858a0b, // c0x006c (n0x0a0b-n0x0a16)  +
	0x0285ca16, // c0x006d (n0x0a16-n0x0a17)  +
	0x02864a17, // c0x006e (n0x0a17-n0x0a19)  +
	0x02884a19, // c0x006f (n0x0a19-n0x0a21)  +
	0x02888a21, // c0x0070 (n0x0a21-n0x0a22)  +
	0x028a4a22, // c0x0071 (n0x0a22-n0x0a29)  +
	0x028aca29, // c0x0072 (n0x0a29-n0x0a2b)  +
	0x028e0a2b, // c0x0073 (n0x0a2b-n0x0a38)  +
	0x02908a38, // c0x0074 (n0x0a38-n0x0a42)  +
	0x0290ca42, // c0x0075 (n0x0a42-n0x0a43)  +
	0x02924a43, // c0x0076 (n0x0a43-n0x0a49)  +
	0x0293ca49, // c0x0077 (n0x0a49-n0x0a4f)  +
	0x02960a4f, // c0x0078 (n0x0a4f-n0x0a58)  +
	0x02980a58, // c0x0079 (n0x0a58-n0x0a60)  +
	0x02f44a60, // c0x007a (n0x0a60-n0x0bd1)  +
	0x02f50bd1, // c0x007b (n0x0bd1-n0x0bd4)  +
	0x02f70bd4, // c0x007c (n0x0bd4-n0x0bdc)  +
	0x0312cbdc, // c0x007d (n0x0bdc-n0x0c4b)  +
	0x031fcc4b, // c0x007e (n0x0c4b-n0x0c7f)  +
	0x0326cc7f, // c0x007f (n0x0c7f-n0x0c9b)  +
	0x032c4c9b, // c0x0080 (n0x0c9b-n0x0cb1)  +
	0x033accb1, // c0x0081 (n0x0cb1-n0x0ceb)  +
	0x03404ceb, // c0x0082 (n0x0ceb-n0x0d01)  +
	0x03440d01, // c0x0083 (n0x0d01-n0x0d10)  +
	0x0353cd10, // c0x0084 (n0x0d10-n0x0d4f)  +
	0x03608d4f, // c0x0085 (n0x0d4f-n0x0d82)  +
	0x036a0d82, // c0x0086 (n0x0d82-n0x0da8)  +
	0x03730da8, // c0x0087 (n0x0da8-n0x0dcc)  +
	0x03794dcc, // c0x0088 (n0x0dcc-n0x0de5)  +
	0x039ccde5, // c0x0089 (n0x0de5-n0x0e73)  +
	0x03a84e73, // c0x008a (n0x0e73-n0x0ea1)  +
	0x03b50ea1, // c0x008b (n0x0ea1-n0x0ed4)  +
	0x03b9ced4, // c0x008c (n0x0ed4-n0x0ee7)  +
	0x03c24ee7, // c0x008d (n0x0ee7-n0x0f09)  +
	0x03c60f09, // c0x008e (n0x0f09-n0x0f18)  +
	0x03cb0f18, // c0x008f (n0x0f18-n0x0f2c)  +
	0x03d28f2c, // c0x0090 (n0x0f2c-n0x0f4a)  +
	0x63d2cf4a, // c0x0091 (n0x0f4a-n0x0f4b)* o
	0x63d30f4b, // c0x0092 (n0x0f4b-n0x0f4c)* o
	0x63d34f4c, // c0x0093 (n0x0f4c-n0x0f4d)* o
	0x03db0f4d, // c0x0094 (n0x0f4d-n0x0f6c)  +
	0x03e18f6c, // c0x0095 (n0x0f6c-n0x0f86)  +
	0x03e94f86, // c0x0096 (n0x0f86-n0x0fa5)  +
	0x03f0cfa5, // c0x0097 (n0x0fa5-n0x0fc3)  +
	0x03f90fc3, // c0x0098 (n0x0fc3-n0x0fe4)  +
	0x03ffcfe4, // c0x0099 (n0x0fe4-n0x0fff)  +
	0x04128fff, // c0x009a (n0x0fff-n0x104a)  +
	0x0418104a, // c0x009b (n0x104a-n0x1060)  +
	0x64185060, // c0x009c (n0x1060-n0x1061)* o
	0x0421d061, // c0x009d (n0x1061-n0x1087)  +
	0x042a5087, // c0x009e (n0x1087-n0x10a9)  +
	0x042f10a9, // c0x009f (n0x10a9-n0x10bc)  +
	0x043590bc, // c0x00a0 (n0x10bc-n0x10d6)  +
	0x044010d6, // c0x00a1 (n0x10d6-n0x1100)  +
	0x044c9100, // c0x00a2 (n0x1100-n0x1132)  +
	0x04531132, // c0x00a3 (n0x1132-n0x114c)  +
	0x0464514c, // c0x00a4 (n0x114c-n0x1191)  +
	0x64649191, // c0x00a5 (n0x1191-n0x1192)* o
	0x6464d192, // c0x00a6 (n0x1192-n0x1193)* o
	0x046a9193, // c0x00a7 (n0x1193-n0x11aa)  +
	0x047051aa, // c0x00a8 (n0x11aa-n0x11c1)  +
	0x047951c1, // c0x00a9 (n0x11c1-n0x11e5)  +
	0x048111e5, // c0x00aa (n0x11e5-n0x1204)  +
	0x04855204, // c0x00ab (n0x1204-n0x1215)  +
	0x04939215, // c0x00ac (n0x1215-n0x124e)  +
	0x0496d24e, // c0x00ad (n0x124e-n0x125b)  +
	0x049cd25b, // c0x00ae (n0x125b-n0x1273)  +
	0x04a41273, // c0x00af (n0x1273-n0x1290)  +
	0x04ac9290, // c0x00b0 (n0x1290-n0x12b2)  +
	0x04b092b2, // c0x00b1 (n0x12b2-n0x12c2)  +
	0x04b792c2, // c0x00b2 (n0x12c2-n0x12de)  +
	0x64b7d2de, // c0x00b3 (n0x12de-n0x12df)* o
	0x64b812df, // c0x00b4 (n0x12df-n0x12e0)* o
	0x24b852e0, // c0x00b5 (n0x12e0-n0x12e1)  o
	0x04b9d2e1, // c0x00b6 (n0x12e1-n0x12e7)  +
	0x04bb92e7, // c0x00b7 (n0x12e7-n0x12ee)  +
	0x04bfd2ee, // c0x00b8 (n0x12ee-n0x12ff)  +
	0x04c0d2ff, // c0x00b9 (n0x12ff-n0x1303)  +
	0x04c25303, // c0x00ba (n0x1303-n0x1309)  +
	0x04c9d309, // c0x00bb (n0x1309-n0x1327)  +
	0x04cb1327, // c0x00bc (n0x1327-n0x132c)  +
	0x04cc932c, // c0x00bd (n0x132c-n0x1332)  +
	0x04ced332, // c0x00be (n0x1332-n0x133b)  +
	0x04d0133b, // c0x00bf (n0x133b-n0x1340)  +
	0x04d19340, // c0x00c0 (n0x1340-n0x1346)  +
	0x04d1d346, // c0x00c1 (n0x1346-n0x1347)  +
	0x04d59347, // c0x00c2 (n0x1347-n0x1356)  +
	0x04d6d356, // c0x00c3 (n0x1356-n0x135b)  +
	0x04d7535b, // c0x00c4 (n0x135b-n0x135d)  +
	0x04d7d35d, // c0x00c5 (n0x135d-n0x135f)  +
	0x04d8135f, // c0x00c6 (n0x135f-n0x1360)  +
	0x04da5360, // c0x00c7 (n0x1360-n0x1369)  +
	0x04dc9369, // c0x00c8 (n0x1369-n0x1372)  +
	0x04de1372, // c0x00c9 (n0x1372-n0x1378)  +
	0x04de9378, // c0x00ca (n0x1378-n0x137a)  +
	0x04ded37a, // c0x00cb (n0x137a-n0x137b)  +
	0x04e2137b, // c0x00cc (n0x137b-n0x1388)  +
	0x04e45388, // c0x00cd (n0x1388-n0x1391)  +
	0x04e65391, // c0x00ce (n0x1391-n0x1399)  +
	0x04e81399, // c0x00cf (n0x1399-n0x13a0)  +
	0x04e913a0, // c0x00d0 (n0x13a0-n0x13a4)  +
	0x04ea53a4, // c0x00d1 (n0x13a4-n0x13a9)  +
	0x04ea93a9, // c0x00d2 (n0x13a9-n0x13aa)  +
	0x04eb13aa, // c0x00d3 (n0x13aa-n0x13ac)  +
	0x04ec53ac, // c0x00d4 (n0x13ac-n0x13b1)  +
	0x04ed53b1, // c0x00d5 (n0x13b1-n0x13b5)  +
	0x04ed93b5, // c0x00d6 (n0x13b5-n0x13b6)  +
	0x04ef53b6, // c0x00d7 (n0x13b6-n0x13bd)  +
	0x057853bd, // c0x00d8 (n0x13bd-n0x15e1)  +
	0x057bd5e1, // c0x00d9 (n0x15e1-n0x15ef)  +
	0x057e95ef, // c0x00da (n0x15ef-n0x15fa)  +
	0x058015fa, // c0x00db (n0x15fa-n0x1600)  +
	0x05821600, // c0x00dc (n0x1600-n0x1608)  +
	0x65825608, // c0x00dd (n0x1608-n0x1609)* o
	0x05869609, // c0x00de (n0x1609-n0x161a)  +
	0x0587161a, // c0x00df (n0x161a-n0x161c)  +
	0x2587561c, // c0x00e0 (n0x161c-n0x161d)  o
	0x2587961d, // c0x00e1 (n0x161d-n0x161e)  o
	0x0587d61e, // c0x00e2 (n0x161e-n0x161f)  +
	0x0595161f, // c0x00e3 (n0x161f-n0x1654)  +
	0x25955654, // c0x00e4 (n0x1654-n0x1655)  o
	0x2595d655, // c0x00e5 (n0x1655-n0x1657)  o
	0x25965657, // c0x00e6 (n0x1657-n0x1659)  o
	0x25971659, // c0x00e7 (n0x1659-n0x165c)  o
	0x0599965c, // c0x00e8 (n0x165c-n0x1666)  +
	0x059c1666, // c0x00e9 (n0x1666-n0x1670)  +
	0x059c5670, // c0x00ea (n0x1670-n0x1671)  +
	0x259fd671, // c0x00eb (n0x1671-n0x167f)  o
	0x05a0967f, // c0x00ec (n0x167f-n0x1682)  +
	0x06561682, // c0x00ed (n0x1682-n0x1958)  +
	0x06565958, // c0x00ee (n0x1958-n0x1959)  +
	0x06569959, // c0x00ef (n0x1959-n0x195a)  +
	0x2656d95a, // c0x00f0 (n0x195a-n0x195b)  o
	0x0657195b, // c0x00f1 (n0x195b-n0x195c)  +
	0x2657595c, // c0x00f2 (n0x195c-n0x195d)  o
	0x0657995d, // c0x00f3 (n0x195d-n0x195e)  +
	0x2658595e, // c0x00f4 (n0x195e-n0x1961)  o
	0x06589961, // c0x00f5 (n0x1961-n0x1962)  +
	0x0658d962, // c0x00f6 (n0x1962-n0x1963)  +
	0x26591963, // c0x00f7 (n0x1963-n0x1964)  o
	0x06595964, // c0x00f8 (n0x1964-n0x1965)  +
	0x2659d965, // c0x00f9 (n0x1965-n0x1967)  o
	0x065a1967, // c0x00fa (n0x1967-n0x1968)  +
	0x065a5968, // c0x00fb (n0x1968-n0x1969)  +
	0x265b5969, // c0x00fc (n0x1969-n0x196d)  o
	0x065b996d, // c0x00fd (n0x196d-n0x196e)  +
	0x065bd96e, // c0x00fe (n0x196e-n0x196f)  +
	0x065c196f, // c0x00ff (n0x196f-n0x1970)  +
	0x065c5970, // c0x0100 (n0x1970-n0x1971)  +
	0x265c9971, // c0x0101 (n0x1971-n0x1972)  o
	0x065cd972, // c0x0102 (n0x1972-n0x1973)  +
	0x065d1973, // c0x0103 (n0x1973-n0x1974)  +
	0x065d5974, // c0x0104 (n0x1974-n0x1975)  +
	0x065d9975, // c0x0105 (n0x1975-n0x1976)  +
	0x265e1976, // c0x0106 (n0x1976-n0x1978)  o
	0x065e5978, // c0x0107 (n0x1978-n0x1979)  +
	0x065e9979, // c0x0108 (n0x1979-n0x197a)  +
	0x065ed97a, // c0x0109 (n0x197a-n0x197b)  +
	0x265f197b, // c0x010a (n0x197b-n0x197c)  o
	0x065f597c, // c0x010b (n0x197c-n0x197d)  +
	0x265fd97d, // c0x010c (n0x197d-n0x197f)  o
	0x2660197f, // c0x010d (n0x197f-n0x1980)  o
	0x0661d980, // c0x010e (n0x1980-n0x1987)  +
	0x06629987, // c0x010f (n0x1987-n0x198a)  +
	0x0666998a, // c0x0110 (n0x198a-n0x199a)  +
	0x0666d99a, // c0x0111 (n0x199a-n0x199b)  +
	0x0669199b, // c0x0112 (n0x199b-n0x19a4)  +
	0x067859a4, // c0x0113 (n0x19a4-n0x19e1)  +
	0x2678d9e1, // c0x0114 (n0x19e1-n0x19e3)  o
	0x267919e3, // c0x0115 (n0x19e3-n0x19e4)  o
	0x267959e4, // c0x0116 (n0x19e4-n0x19e5)  o
	0x0679d9e5, // c0x0117 (n0x19e5-n0x19e7)  +
	0x068799e7, // c0x0118 (n0x19e7-n0x1a1e)  +
	0x068a5a1e, // c0x0119 (n0x1a1e-n0x1a29)  +
	0x068c5a29, // c0x011a (n0x1a29-n0x1a31)  +
	0x068d1a31, // c0x011b (n0x1a31-n0x1a34)  +
	0x068f1a34, // c0x011c (n0x1a34-n0x1a3c)  +
	0x06929a3c, // c0x011d (n0x1a3c-n0x1a4a)  +
	0x06bbda4a, // c0x011e (n0x1a4a-n0x1aef)  +
	0x06c79aef, // c0x011f (n0x1aef-n0x1b1e)  +
	0x06c8db1e, // c0x0120 (n0x1b1e-n0x1b23)  +
	0x06cc1b23, // c0x0121 (n0x1b23-n0x1b30)  +
	0x06cddb30, // c0x0122 (n0x1b30-n0x1b37)  +
	0x06cf9b37, // c0x0123 (n0x1b37-n0x1b3e)  +
	0x06d1db3e, // c0x0124 (n0x1b3e-n0x1b47)  +
	0x06d35b47, // c0x0125 (n0x1b47-n0x1b4d)  +
	0x06d51b4d, // c0x0126 (n0x1b4d-n0x1b54)  +
	0x06d75b54, // c0x0127 (n0x1b54-n0x1b5d)  +
	0x06d85b5d, // c0x0128 (n0x1b5d-n0x1b61)  +
	0x06db5b61, // c0x0129 (n0x1b61-n0x1b6d)  +
	0x06dd1b6d, // c0x012a (n0x1b6d-n0x1b74)  +
	0x06fddb74, // c0x012b (n0x1b74-n0x1bf7)  +
	0x07001bf7, // c0x012c (n0x1bf7-n0x1c00)  +
	0x07021c00, // c0x012d (n0x1c00-n0x1c08)  +
	0x07035c08, // c0x012e (n0x1c08-n0x1c0d)  +
	0x07049c0d, // c0x012f (n0x1c0d-n0x1c12)  +
	0x07069c12, // c0x0130 (n0x1c12-n0x1c1a)  +
	0x0710dc1a, // c0x0131 (n0x1c1a-n0x1c43)  +
	0x07129c43, // c0x0132 (n0x1c43-n0x1c4a)  +
	0x07145c4a, // c0x0133 (n0x1c4a-n0x1c51)  +
	0x07149c51, // c0x0134 (n0x1c51-n0x1c52)  +
	0x0714dc52, // c0x0135 (n0x1c52-n0x1c53)  +
	0x07161c53, // c0x0136 (n0x1c53-n0x1c58)  +
	0x07181c58, // c0x0137 (n0x1c58-n0x1c60)  +
	0x0718dc60, // c0x0138 (n0x1c60-n0x1c63)  +
	0x071bdc63, // c0x0139 (n0x1c63-n0x1c6f)  +
	0x0723dc6f, // c0x013a (n0x1c6f-n0x1c8f)  +
	0x07251c8f, // c0x013b (n0x1c8f-n0x1c94)  +
	0x07255c94, // c0x013c (n0x1c94-n0x1c95)  +
	0x0726dc95, // c0x013d (n0x1c95-n0x1c9b)  +
	0x07279c9b, // c0x013e (n0x1c9b-n0x1c9e)  +
	0x0727dc9e, // c0x013f (n0x1c9e-n0x1c9f)  +
	0x07299c9f, // c0x0140 (n0x1c9f-n0x1ca6)  +
	0x072d5ca6, // c0x0141 (n0x1ca6-n0x1cb5)  +
	0x072d9cb5, // c0x0142 (n0x1cb5-n0x1cb6)  +
	0x072f9cb6, // c0x0143 (n0x1cb6-n0x1cbe)  +
	0x07349cbe, // c0x0144 (n0x1cbe-n0x1cd2)  +
	0x07361cd2, // c0x0145 (n0x1cd2-n0x1cd8)  +
	0x073b5cd8, // c0x0146 (n0x1cd8-n0x1ced)  +
	0x073b9ced, // c0x0147 (n0x1ced-n0x1cee)  +
	0x073bdcee, // c0x0148 (n0x1cee-n0x1cef)  +
	0x07401cef, // c0x0149 (n0x1cef-n0x1d00)  +
	0x07411d00, // c0x014a (n0x1d00-n0x1d04)  +
	0x07449d04, // c0x014b (n0x1d04-n0x1d12)  +
	0x07479d12, // c0x014c (n0x1d12-n0x1d1e)  +
	0x075b5d1e, // c0x014d (n0x1d1e-n0x1d6d)  +
	0x075d9d6d, // c0x014e (n0x1d6d-n0x1d76)  +
	0x07605d76, // c0x014f (n0x1d76-n0x1d81)  +
	0x07609d81, // c0x0150 (n0x1d81-n0x1d82)  +
	0x0760dd82, // c0x0151 (n0x1d82-n0x1d83)  +
	0x07709d83, // c0x0152 (n0x1d83-n0x1dc2)  +
	0x07715dc2, // c0x0153 (n0x1dc2-n0x1dc5)  +
	0x07721dc5, // c0x0154 (n0x1dc5-n0x1dc8)  +
	0x0772ddc8, // c0x0155 (n0x1dc8-n0x1dcb)  +
	0x07739dcb, // c0x0156 (n0x1dcb-n0x1dce)  +
	0x07745dce, // c0x0157 (n0x1dce-n0x1dd1)  +
	0x07751dd1, // c0x0158 (n0x1dd1-n0x1dd4)  +
	0x0775ddd4, // c0x0159 (n0x1dd4-n0x1dd7)  +
	0x07769dd7, // c0x015a (n0x1dd7-n0x1dda)  +
	0x07775dda, // c0x015b (n0x1dda-n0x1ddd)  +
	0x07781ddd, // c0x015c (n0x1ddd-n0x1de0)  +
	0x0778dde0, // c0x015d (n0x1de0-n0x1de3)  +
	0x07799de3, // c0x015e (n0x1de3-n0x1de6)  +
	0x077a5de6, // c0x015f (n0x1de6-n0x1de9)  +
	0x077adde9, // c0x0160 (n0x1de9-n0x1deb)  +
	0x077b9deb, // c0x0161 (n0x1deb-n0x1dee)  +
	0x077c5dee, // c0x0162 (n0x1dee-n0x1df1)  +
	0x077d1df1, // c0x0163 (n0x1df1-n0x1df4)  +
	0x077dddf4, // c0x0164 (n0x1df4-n0x1df7)  +
	0x077e9df7, // c0x0165 (n0x1df7-n0x1dfa)  +
	0x077f5dfa, // c0x0166 (n0x1dfa-n0x1dfd)  +
	0x07801dfd, // c0x0167 (n0x1dfd-n0x1e00)  +
	0x0780de00, // c0x0168 (n0x1e00-n0x1e03)  +
	0x07819e03, // c0x0169 (n0x1e03-n0x1e06)  +
	0x07825e06, // c0x016a (n0x1e06-n0x1e09)  +
	0x07831e09, // c0x016b (n0x1e09-n0x1e0c)  +
	0x0783de0c, // c0x016c (n0x1e0c-n0x1e0f)  +
	0x07849e0f, // c0x016d (n0x1e0f-n0x1e12)  +
	0x07855e12, // c0x016e (n0x1e12-n0x1e15)  +
	0x07861e15, // c0x016f (n0x1e15-n0x1e18)  +
	0x0786de18, // c0x0170 (n0x1e18-n0x1e1b)  +
	0x07879e1b, // c0x0171 (n0x1e1b-n0x1e1e)  +
	0x07881e1e, // c0x0172 (n0x1e1e-n0x1e20)  +
	0x0788de20, // c0x0173 (n0x1e20-n0x1e23)  +
	0x07899e23, // c0x0174 (n0x1e23-n0x1e26)  +
	0x078a5e26, // c0x0175 (n0x1e26-n0x1e29)  +
	0x078b1e29, // c0x0176 (n0x1e29-n0x1e2c)  +
	0x078bde2c, // c0x0177 (n0x1e2c-n0x1e2f)  +
	0x078c9e2f, // c0x0178 (n0x1e2f-n0x1e32)  +
	0x078d5e32, // c0x0179 (n0x1e32-n0x1e35)  +
	0x078e1e35, // c0x017a (n0x1e35-n0x1e38)  +
	0x078ede38, // c0x017b (n0x1e38-n0x1e3b)  +
	0x078f9e3b, // c0x017c (n0x1e3b-n0x1e3e)  +
	0x07905e3e, // c0x017d (n0x1e3e-n0x1e41)  +
	0x07911e41, // c0x017e (n0x1e41-n0x1e44)  +
	0x0791de44, // c0x017f (n0x1e44-n0x1e47)  +
	0x07925e47, // c0x0180 (n0x1e47-n0x1e49)  +
	0x07931e49, // c0x0181 (n0x1e49-n0x1e4c)  +
	0x0793de4c, // c0x0182 (n0x1e4c-n0x1e4f)  +
	0x07949e4f, // c0x0183 (n0x1e4f-n0x1e52)  +
	0x07955e52, // c0x0184 (n0x1e52-n0x1e55)  +
	0x07961e55, // c0x0185 (n0x1e55-n0x1e58)  +
	0x0796de58, // c0x0186 (n0x1e58-n0x1e5b)  +
	0x07979e5b, // c0x0187 (n0x1e5b-n0x1e5e)  +
	0x07985e5e, // c0x0188 (n0x1e5e-n0x1e61)  +
	0x07989e61, // c0x0189 (n0x1e61-n0x1e62)  +
	0x07995e62, // c0x018a (n0x1e62-n0x1e65)  +
	0x079ade65, // c0x018b (n0x1e65-n0x1e6b)  +
	0x079b1e6b, // c0x018c (n0x1e6b-n0x1e6c)  +
	0x079c1e6c, // c0x018d (n0x1e6c-n0x1e70)  +
	0x079d9e70, // c0x018e (n0x1e70-n0x1e76)  +
	0x07a1de76, // c0x018f (n0x1e76-n0x1e87)  +
	0x07a31e87, // c0x0190 (n0x1e87-n0x1e8c)  +
	0x07a65e8c, // c0x0191 (n0x1e8c-n0x1e99)  +
	0x07a75e99, // c0x0192 (n0x1e99-n0x1e9d)  +
	0x07a91e9d, // c0x0193 (n0x1e9d-n0x1ea4)  +
	0x07aa9ea4, // c0x0194 (n0x1ea4-n0x1eaa)  +
	0x27aedeaa, // c0x0195 (n0x1eaa-n0x1ebb)  o
	0x07af1ebb, // c0x0196 (n0x1ebb-n0x1ebc)  +
}

// max children 406 (capacity 511)
// max text offset 26999 (capacity 32767)
// max text length 36 (capacity 63)
// max hi 7868 (capacity 16383)
// max lo 7867 (capacity 16383)
