/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument.pass3;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.cobertura.instrument.AbstractFindTouchPointsClassInstrumenter;
import net.sourceforge.cobertura.instrument.FindTouchPointsMethodAdapter;
import net.sourceforge.cobertura.instrument.pass3.AtomicArrayCodeProvider;
import net.sourceforge.cobertura.instrument.pass3.CodeProvider;
import net.sourceforge.cobertura.instrument.pass3.FastArrayCodeProvider;
import net.sourceforge.cobertura.instrument.pass3.InjectCodeTouchPointListener;
import net.sourceforge.cobertura.instrument.tp.ClassMap;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.LocalVariablesSorter;

public class InjectCodeClassInstrumenter
extends AbstractFindTouchPointsClassInstrumenter {
    private final InjectCodeTouchPointListener touchPointListener;
    private final ClassMap classMap;
    private final CodeProvider codeProvider;
    private boolean wasStaticInitMethodVisited = false;
    private final Set<String> ignoredMethods;

    public InjectCodeClassInstrumenter(ClassVisitor cv, Collection<Pattern> ignoreRegexes, boolean threadsafeRigorous, ClassMap classMap, Map<Integer, Map<Integer, Integer>> duplicatedLinesMap, Set<String> ignoredMethods) {
        super(cv, ignoreRegexes, duplicatedLinesMap);
        this.classMap = classMap;
        this.ignoredMethods = ignoredMethods;
        this.codeProvider = threadsafeRigorous ? new AtomicArrayCodeProvider() : new FastArrayCodeProvider();
        this.touchPointListener = new InjectCodeTouchPointListener(classMap, this.codeProvider);
    }

    public void visit(int version, int access, String name, String signature, String supertype, String[] interfaces) {
        super.visit(version, access, name, signature, supertype, interfaces);
        this.codeProvider.generateCountersField(this.cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.ignoredMethods.contains(name + desc)) {
            return mv;
        }
        if ((access & 8) != 0) {
            mv = new GenerateCallCoberturaInitMethodVisitor(mv, this.classMap.getClassName());
            if ("<clinit>".equals(name)) {
                this.wasStaticInitMethodVisited = true;
            }
        }
        FindTouchPointsMethodAdapter instrumenter = new FindTouchPointsMethodAdapter(mv, this.classMap.getClassName(), name, desc, this.eventIdGenerator, (Map<Integer, Map<Integer, Integer>>)this.duplicatedLinesMap, this.lineIdGenerator);
        instrumenter.setTouchPointListener(this.touchPointListener);
        instrumenter.setIgnoreRegexp(this.getIgnoreRegexp());
        LocalVariablesSorter sorter = new LocalVariablesSorter(access, desc, (MethodVisitor)instrumenter);
        int variable = sorter.newLocal(Type.INT_TYPE);
        this.touchPointListener.setLastJumpIdVariableIndex(variable);
        return sorter;
    }

    public void visitEnd() {
        if (!this.wasStaticInitMethodVisited) {
            MethodVisitor mv = super.visitMethod(8, "<clinit>", "()V", null, null);
            mv.visitCode();
            this.codeProvider.generateCallCoberturaInitMethod(mv, this.classMap.getClassName());
            mv.visitInsn(177);
            mv.visitMaxs(3, 0);
            mv.visitEnd();
            this.wasStaticInitMethodVisited = true;
        }
        this.codeProvider.generateCoberturaInitMethod(this.cv, this.classMap.getClassName(), this.classMap.getMaxCounterId() + 1);
        this.codeProvider.generateCoberturaClassMapMethod(this.cv, this.classMap);
        this.codeProvider.generateCoberturaGetAndResetCountersMethod(this.cv, this.classMap.getClassName());
        super.visitEnd();
    }

    private class GenerateCallCoberturaInitMethodVisitor
    extends MethodVisitor {
        private String className;

        public GenerateCallCoberturaInitMethodVisitor(MethodVisitor arg0, String className) {
            super(262144, arg0);
            this.className = className;
        }

        public void visitCode() {
            InjectCodeClassInstrumenter.this.codeProvider.generateCallCoberturaInitMethod(this.mv, this.className);
            super.visitCode();
        }
    }
}

