/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 13:41:15 GMT 2018
 */

package uk.ac.sanger.artemis.cramtools.ref;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.cramtools.ref.PathPattern;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class PathPattern_ESTest extends PathPattern_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      PathPattern pathPattern0 = new PathPattern("%s");
      String string0 = pathPattern0.format("%s");
      assertEquals("%s", string0);
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      PathPattern pathPattern0 = new PathPattern((String) null);
      // Undeclared exception!
      try { 
        pathPattern0.format("");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      PathPattern pathPattern0 = new PathPattern("%s");
      // Undeclared exception!
      try { 
        pathPattern0.format("UUwXszZ F>$8@7/ K7");
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
         //
         // No group 8
         //
         verifyException("java.util.regex.Matcher", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      PathPattern pathPattern0 = new PathPattern("%s");
      // Undeclared exception!
      try { 
        pathPattern0.format("]e9HM(F'/EED4 D^$");
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // Illegal group reference: group index is missing
         //
         verifyException("java.util.regex.Matcher", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      PathPattern pathPattern0 = new PathPattern("nH%1s");
      // Undeclared exception!
      try { 
        pathPattern0.format("nH%1s");
        fail("Expecting exception: RuntimeException");
      
      } catch(RuntimeException e) {
         //
         // Invalid reference location pattern: nH%1s
         //
         verifyException("uk.ac.sanger.artemis.cramtools.ref.PathPattern", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      PathPattern pathPattern0 = new PathPattern("%s");
      String string0 = pathPattern0.format("");
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      PathPattern pathPattern0 = new PathPattern("%1s");
      // Undeclared exception!
      try { 
        pathPattern0.format("");
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }
}
