/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:13:58 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.LogReadListener;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.EmblDocumentEntry;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.MSPcrunchDocumentEntry;
import uk.ac.sanger.artemis.io.MSPcrunchEntryInformation;
import uk.ac.sanger.artemis.io.ReadListener;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.TextDocument;
import uk.ac.sanger.artemis.util.URLDocument;
import uk.ac.sanger.artemis.util.ZipFileDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class MSPcrunchDocumentEntry_ESTest extends MSPcrunchDocumentEntry_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(mSPcrunchEntryInformation0);
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("pSsU1)~E6u yOP`B[");
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(emblStreamSequence0);
      // Undeclared exception!
      try { 
        mSPcrunchDocumentEntry0.makeNativeSequence(fastaStreamSequence0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      LogReadListener logReadListener0 = new LogReadListener("");
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = null;
      try {
        mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry((Document) null, logReadListener0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      MockFile mockFile0 = new MockFile("N;s|>S.");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "");
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = null;
      try {
        mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(zipFileDocument0, (ReadListener) null);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      TextDocument textDocument0 = new TextDocument();
      LogReadListener logReadListener0 = new LogReadListener("jEv.");
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = null;
      try {
        mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(textDocument0, logReadListener0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = null;
      try {
        mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry((Entry) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(simpleEntryInformation0);
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      Object object0 = mSPcrunchDocumentEntry0.makeNativeFeature(genbankStreamFeature0, false);
      assertNotNull(object0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(simpleEntryInformation0);
      boolean boolean0 = mSPcrunchDocumentEntry0.isReadOnly();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      LogReadListener logReadListener0 = new LogReadListener("");
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = null;
      try {
        mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(uRLDocument0, logReadListener0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Could not find: www.someFakeButWellFormedURL.org
         //
         verifyException("org.evosuite.runtime.mock.java.net.EvoHttpURLConnection", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(mSPcrunchEntryInformation0);
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("pSsU1)~E6u yOP`B[");
      StreamSequence streamSequence0 = mSPcrunchDocumentEntry0.makeNativeSequence(emblStreamSequence0);
      assertEquals(0, streamSequence0.getTCount());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(blastEntryInformation0);
      // Undeclared exception!
      try { 
        mSPcrunchDocumentEntry0.makeNativeFeature((Feature) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.MSPcrunchStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(blastEntryInformation0);
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(emblDocumentEntry0, false);
      assertTrue(mSPcrunchDocumentEntry0.isReadOnly());
  }
}
