/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:57:14 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.io.StringWriter;
import javax.swing.text.DefaultEditorKit;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.GenericDocument;
import org.apache.batik.dom.GenericDocumentType;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.util.SVGConstants;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.plot.EntropyAlgorithm;
import uk.ac.sanger.artemis.plot.GCFrameAlgorithm;
import uk.ac.sanger.artemis.plot.GCWindowAlgorithm;
import uk.ac.sanger.artemis.plot.ICDIAlgorithm;
import uk.ac.sanger.artemis.plot.KarlinSigAlgorithm;
import uk.ac.sanger.artemis.plot.LineAttributes;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class BaseAlgorithm_ESTest extends BaseAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      StringWriter stringWriter0 = new StringWriter();
      rawStreamSequence0.writeToStream(stringWriter0);
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      gCWindowAlgorithm0.getMaximumInternal();
      strand0.getTCount();
      gCWindowAlgorithm0.getAverage();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      bases0.getGCount();
      iCDIAlgorithm0.isRevCompDisplay();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      gCFrameAlgorithm0.getDefaultStepSize(1);
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      karlinSigAlgorithm0.getDefaultMaxWindowSize();
      Frame frame0 = null;
      try {
        frame0 = new Frame("");
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(emblStreamSequence0);
      EmblStreamSequence emblStreamSequence1 = new EmblStreamSequence(rawStreamSequence0);
      Bases bases0 = new Bases(emblStreamSequence1);
      Strand strand0 = bases0.getForwardStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      emblStreamSequence1.forceReset();
      entropyAlgorithm0.getDefaultMinWindowSize();
      entropyAlgorithm0.getBases();
      assertFalse(entropyAlgorithm0.isRevCompDisplay());
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("/^~4H8F");
      Bases bases0 = new Bases(fastaStreamSequence0);
      fastaStreamSequence0.forceReset();
      FileSystemHandling.shouldAllThrowIOExceptions();
      bases0.getLength();
      Bases.reverseComplement("/^~4H8F");
      Strand strand0 = bases0.getForwardStrand();
      bases0.reverseComplement();
      fastaStreamSequence0.getSubSequence(1, 1);
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getDefaultStepSize(0);
      entropyAlgorithm0.getDefaultMinWindowSize();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      fastaStreamSequence0.charAt(1);
      float[] floatArray0 = new float[6];
      GenericDocumentType genericDocumentType0 = new GenericDocumentType("VEU/^r9", "@@d@@@@", "y}:e");
      GenericDOMImplementation genericDOMImplementation0 = new GenericDOMImplementation();
      GenericDocument genericDocument0 = new GenericDocument(genericDocumentType0, genericDOMImplementation0);
      SVGGraphics2D sVGGraphics2D0 = new SVGGraphics2D(genericDocument0);
      Graphics graphics0 = sVGGraphics2D0.create(1, 1, 7, (-1017));
      LineAttributes[] lineAttributesArray0 = new LineAttributes[4];
      DefaultTreeCellRenderer defaultTreeCellRenderer0 = new DefaultTreeCellRenderer();
      Color color0 = defaultTreeCellRenderer0.getBackgroundNonSelectionColor();
      LineAttributes lineAttributes0 = new LineAttributes(color0);
      lineAttributesArray0[0] = lineAttributes0;
      LineAttributes lineAttributes1 = new LineAttributes(color0);
      lineAttributesArray0[1] = lineAttributes1;
      LineAttributes lineAttributes2 = new LineAttributes(color0);
      lineAttributesArray0[2] = lineAttributes2;
      LineAttributes lineAttributes3 = new LineAttributes(color0);
      lineAttributesArray0[3] = lineAttributes3;
      iCDIAlgorithm0.drawLegend(graphics0, 1195, 731, lineAttributesArray0, 0);
      floatArray0[0] = (float) 1;
      floatArray0[1] = 0.395F;
      floatArray0[2] = (float) 0;
      floatArray0[3] = (float) 1;
      FileSystemHandling.setPermissions((EvoSuiteFile) null, true, true, true);
      floatArray0[4] = (float) 2;
      floatArray0[5] = (float) 0;
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      gCWindowAlgorithm0.getMaximumInternal();
      gCWindowAlgorithm0.getAverage();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      bases0.getGCount();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      gCFrameAlgorithm0.setRevCompDisplay(false);
      gCFrameAlgorithm0.getDefaultStepSize(1);
      Frame frame0 = null;
      try {
        frame0 = new Frame("");
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("/^~4H8F");
      Bases bases0 = new Bases(fastaStreamSequence0);
      fastaStreamSequence0.forceReset();
      FileSystemHandling.shouldAllThrowIOExceptions();
      bases0.getLength();
      Bases.reverseComplement("/^~4H8F");
      Strand strand0 = bases0.getForwardStrand();
      bases0.reverseComplement();
      fastaStreamSequence0.getSubSequence(1, 1);
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getDefaultStepSize(0);
      entropyAlgorithm0.getDefaultMinWindowSize();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      fastaStreamSequence0.charAt(1);
      float[] floatArray0 = new float[6];
      GenericDocumentType genericDocumentType0 = new GenericDocumentType("VEU/^r9", "@@d@@@@", "y}:e");
      GenericDOMImplementation genericDOMImplementation0 = new GenericDOMImplementation();
      GenericDocument genericDocument0 = new GenericDocument(genericDocumentType0, genericDOMImplementation0);
      SVGGraphics2D sVGGraphics2D0 = new SVGGraphics2D(genericDocument0);
      Graphics graphics0 = sVGGraphics2D0.create(1, 1, 7, (-1017));
      LineAttributes[] lineAttributesArray0 = new LineAttributes[4];
      DefaultTreeCellRenderer defaultTreeCellRenderer0 = new DefaultTreeCellRenderer();
      Color color0 = defaultTreeCellRenderer0.getBackgroundNonSelectionColor();
      LineAttributes lineAttributes0 = new LineAttributes(color0);
      lineAttributesArray0[0] = lineAttributes0;
      LineAttributes lineAttributes1 = new LineAttributes(color0);
      lineAttributesArray0[1] = lineAttributes1;
      LineAttributes lineAttributes2 = new LineAttributes(color0);
      LineAttributes lineAttributes3 = new LineAttributes(color0);
      lineAttributesArray0[3] = lineAttributes3;
      // Undeclared exception!
      try { 
        iCDIAlgorithm0.drawLegend(graphics0, 1195, 731, lineAttributesArray0, 0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      DefaultEditorKit.CopyAction defaultEditorKit_CopyAction0 = new DefaultEditorKit.CopyAction();
      Key key0 = Key.CDS;
      assertEquals(3, key0.length());
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("6");
      rawStreamSequence0.getCharSubSequence(5, 5);
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      Bases.reverseComplement("6");
      gCWindowAlgorithm0.getAverage();
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      
      gCWindowAlgorithm0.setRevCompDisplay(true);
      assertTrue(gCWindowAlgorithm0.isRevCompDisplay());
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      String string0 = SVGConstants.SVG_STEMH_ATTRIBUTE;
      assertEquals("stemh", string0);
  }

  @Test(timeout = 4000)
  public void test8()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      gCWindowAlgorithm0.getMaximumInternal();
      gCWindowAlgorithm0.getAverage();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      bases0.getGCount();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      gCFrameAlgorithm0.getDefaultStepSize(1);
      Frame frame0 = null;
      try {
        frame0 = new Frame("");
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }
}
