#! /bin/sh
#
# skeleton	example file to build /etc/init.d/ scripts.
#		This file should be used to construct scripts for /etc/init.d.
#
#		Written by Miquel van Smoorenburg <miquels@cistron.nl>.
#		Modified for Debian GNU/Linux
#		by Ian Murdock <imurdock@gnu.ai.mit.edu>.
#
# Version:	@(#)skeleton  1.8  03-Mar-1998  miquels@cistron.nl
#
# This file was automatically customized by dh-make on Fri,  4 Jun 1999 14:28:59 +1000

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin


set -e

case "$1" in
  start)
	echo -n "Starting ax25-tools: "
	start-stop-daemon --start --quiet --pidfile /var/run/mheardd.pid \
		--exec /usr/sbin/mheardd
	echo -n " mheardd"
	start-stop-daemon --start --quiet --pidfile /var/run/ax25d.pid \
		--exec /usr/sbin/ax25d
	echo -n " ax25d"
	if [ -f /proc/net/nr ]
	then
	  start-stop-daemon --start --quiet --pidfile /var/run/netromd \
	  	--exec /usr/sbin/netromd
	  echo "."
	  if [ -f /var/ax25/nodesave.data ]
	  then
	    echo -n "Restoring saved netrom nodes"
	    . /var/ax25/nodesave.data
	    rm -f /var/ax25/nodesave.data
	    echo "."
	  fi
	else
	  echo "."
	fi
	;;
  stop)
	echo -n "Stopping ax25-tools: "
	start-stop-daemon --stop --quiet --pidfile /var/run/mheardd.pid \
		--exec /usr/sbin/mheardd
	echo -n " mheardd"
	start-stop-daemon --stop --quiet --pidfile /var/run/ax25d.pid \
		--exec /usr/sbin/ax25d
	echo -n " ax25d"
	if [ -f /proc/net/nr ]
	then
	  start-stop-daemon --stop --quiet --pidfile /var/run/netromd \
	  	--exec /usr/sbin/netromd
	  echo " netromd."
	  echo -n "Saving netrom nodes"
	  /usr/sbin/nodesave /var/ax25/nodesave.data
	  echo "."
	else
	  echo "."
	fi
	;;
  #reload)
	#
	#	If the daemon can reload its config files on the fly
	#	for example by sending it SIGHUP, do it here.
	#
	#	If the daemon responds to changes in its config file
	#	directly anyway, make this a do-nothing entry.
	#
	# echo "Reloading $DESC configuration files."
	# start-stop-daemon --stop --signal 1 --quiet --pidfile \
	#	/var/run/$NAME.pid --exec $DAEMON
  #;;
  restart|force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart".
	#
	echo -n "Restarting ax25-tools: "
	start-stop-daemon --stop --quiet --pidfile /var/run/mheardd.pid \
		--exec /usr/sbin/mheardd
	start-stop-daemon --stop --quiet --pidfile /var/run/ax25d.pid \
		--exec /usr/sbin/ax25d
	if [ -f /proc/net/nr ]
	then
	  start-stop-daemon --stop --quiet --pidfile /var/run/netromd \
	  	--exec /usr/sbin/netromd
	fi
	sleep 1
	start-stop-daemon --start --quiet --pidfile /var/run/mheardd.pid \
		--exec /usr/sbin/mheardd
	echo -n " mheardd"
	start-stop-daemon --start --quiet --pidfile /var/run/ax25d.pid \
		--exec /usr/sbin/ax25d
	echo -n " ax25d"
	if [ -f /proc/net/nr ]
	then
	  start-stop-daemon --start --quiet --pidfile /var/run/netromd \
	  	--exec /usr/sbin/netromd
	  echo "netromd."
	else
	  echo "."
	fi
	;;
  *)
	N=/etc/init.d/ax25-tools
	# echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
