
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsepart.proc"
// Licensed GNU LGPL v2.1 or later: http://www.gnu.org/licenses/lgpl.html
#include <bse/bseplugin.hh>
#include <bse/bseprocedure.hh>
#include <bse/bsepart.hh>
#include <bse/bsesong.hh>
#include "bsecxxplugin.hh"
/* --- insert-note-auto --- */
static void
insert_note_auto_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 9 "bsepart.proc"
 {
#line 11 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++) = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_STANDARD ":scale");
  *(out_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
}
#line 26 "bsepart.proc"
 }
static BseErrorType
#line 26 "bsepart.proc"
insert_note_auto_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 29 "bsepart.proc"
{
#line 30 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note	     = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  BseUndoStack *ustack;
  guint id;
#line 39 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 42 "bsepart.proc"
  
  ustack = bse_item_undo_open (self, "insert-note-auto");
  id = bse_part_insert_note (self, ~0, tick, duration, note, fine_tune, velocity);
  if (id)
    bse_item_push_undo_proc (self, "delete-event", id);
  bse_item_undo_close (ustack);
#line 48 "bsepart.proc"
  
  sfi_value_set_int (out_values++, id);
  return BSE_ERROR_NONE;
}
/* --- insert-note --- */
static void
insert_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 52 "bsepart.proc"
 {
#line 54 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("channel", "Channel", NULL,
			 0, 0, BSE_PART_MAX_CHANNELS, 4, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++) = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_STANDARD ":scale");
  *(out_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
}
#line 71 "bsepart.proc"
 }
static BseErrorType
#line 71 "bsepart.proc"
insert_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 74 "bsepart.proc"
{
#line 75 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    channel   = sfi_value_get_int (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note	     = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  BseUndoStack *ustack;
  guint id;
#line 85 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 88 "bsepart.proc"
  
  ustack = bse_item_undo_open (self, "insert-note");
  id = bse_part_insert_note (self, channel, tick, duration, note, fine_tune, velocity);
  if (id)
    bse_item_push_undo_proc (self, "delete-event", id);
  bse_item_undo_close (ustack);
#line 94 "bsepart.proc"
  
  sfi_value_set_int (out_values++, id);
  return BSE_ERROR_NONE;
}
/* --- insert-control --- */
static void
insert_control_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 98 "bsepart.proc"
 {
#line 100 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("value", "Value", NULL,
			  0.0, -1.0, +1.0, 0.1,
			  SFI_PARAM_STANDARD ":scale");
  *(out_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
}
#line 113 "bsepart.proc"
 }
static BseErrorType
#line 113 "bsepart.proc"
insert_control_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 116 "bsepart.proc"
{
#line 117 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    ctype     = g_value_get_enum (in_values++);
  gfloat   value     = sfi_value_get_real (in_values++);
  BseUndoStack *ustack;
  guint id;
#line 124 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 127 "bsepart.proc"
  
  ustack = bse_item_undo_open (self, "insert-event");
  id = bse_part_insert_control (self, tick, BseMidiSignalType (ctype), value);
  if (id)
    bse_item_push_undo_proc (self, "delete-event", id);
  bse_item_undo_close (ustack);
#line 133 "bsepart.proc"
  
  sfi_value_set_int (out_values++, id);
  return BSE_ERROR_NONE;
}
/* --- change-note --- */
static void
change_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 137 "bsepart.proc"
 {
#line 139 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++) = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_STANDARD ":scale");
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 157 "bsepart.proc"
 }
static BseErrorType
#line 157 "bsepart.proc"
change_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 160 "bsepart.proc"
{
#line 161 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    id	     = sfi_value_get_int (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note	     = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  gboolean success = FALSE;
  BsePartQueryEvent equery;
#line 171 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 174 "bsepart.proc"
  
  if (bse_part_query_event (self, id, &equery) == BSE_PART_EVENT_NOTE)
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "change-note");
      if (equery.tick != tick || equery.duration != duration ||
          equery.note != note || equery.fine_tune != fine_tune ||
          equery.velocity != velocity)
        {
          success = bse_part_change_note (self, id, ~0, tick, duration, note, fine_tune, velocity);
          if (success)
            bse_item_push_undo_proc (self, "change-note", id, equery.tick, equery.duration,
                                     equery.note, equery.fine_tune, equery.velocity);
        }
      else
        success = TRUE;
      bse_item_undo_close (ustack);
    }
#line 191 "bsepart.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_EVENT);
  return BSE_ERROR_NONE;
}
/* --- change-control --- */
static void
change_control_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 195 "bsepart.proc"
 {
#line 197 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("value", "Value", NULL,
			  0.0, -1.0, +1.0, 0.1,
			  SFI_PARAM_STANDARD ":scale");
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 213 "bsepart.proc"
 }
static BseErrorType
#line 213 "bsepart.proc"
change_control_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 216 "bsepart.proc"
{
#line 217 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    id    = sfi_value_get_int (in_values++);
  guint    tick  = sfi_value_get_int (in_values++);
  guint    ctype = g_value_get_enum (in_values++);
  gfloat   value = sfi_value_get_real (in_values++);
  BsePartQueryEvent equery;
  gboolean success = FALSE;
#line 225 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 228 "bsepart.proc"
  
  bse_part_query_event (self, id, &equery);
  if (equery.event_type == BSE_PART_EVENT_CONTROL && !BSE_PART_NOTE_CONTROL (ctype))
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "change-control");
      if (equery.tick != tick || equery.control_type != ctype || equery.control_value != value)
        {
          success = bse_part_change_control (self, id, tick, BseMidiSignalType (ctype), value);
          if (success)
            bse_item_push_undo_proc (self, "change-control", id, equery.tick, equery.control_type, equery.control_value);
        }
      else
        success = TRUE;
      bse_item_undo_close (ustack);
    }
  else if (equery.event_type == BSE_PART_EVENT_NOTE && BSE_PART_NOTE_CONTROL (ctype))
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "change-control");
      BsePartQueryEvent xquery;
      success = bse_part_change_control (self, id, tick, BseMidiSignalType (ctype), value);
      if (success && bse_part_query_event (self, id, &xquery) == BSE_PART_EVENT_NOTE &&
          (equery.fine_tune_value != xquery.fine_tune_value ||
           equery.velocity_value  != xquery.velocity_value))
        switch (ctype)
          {
          case BSE_MIDI_SIGNAL_VELOCITY:
            bse_item_push_undo_proc (self, "change-control", id, equery.tick, ctype, equery.velocity_value);
            break;
          case BSE_MIDI_SIGNAL_FINE_TUNE:
            bse_item_push_undo_proc (self, "change-control", id, equery.tick, ctype, equery.fine_tune_value);
            break;
          default: ;
          }
      bse_item_undo_close (ustack);
    }
#line 263 "bsepart.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_EVENT);
  return BSE_ERROR_NONE;
}
/* --- delete-event --- */
static void
delete_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 267 "bsepart.proc"
 {
#line 269 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 277 "bsepart.proc"
 }
static BseErrorType
#line 277 "bsepart.proc"
delete_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 280 "bsepart.proc"
{
#line 281 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  BsePartQueryEvent equery;
  gboolean deleted = FALSE;
#line 286 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 289 "bsepart.proc"
  
  bse_part_query_event (self, id, &equery);
  if (equery.event_type == BSE_PART_EVENT_NOTE)
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "delete-note");
      deleted = bse_part_delete_note (self, id, equery.channel);
      if (deleted)
        bse_item_push_undo_proc (self, "insert-note", equery.channel, equery.tick, equery.duration,
                                 equery.note, equery.fine_tune, equery.velocity);
      bse_item_undo_close (ustack);
    }
  else if (equery.event_type == BSE_PART_EVENT_CONTROL)
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "delete-control");
      deleted = bse_part_delete_control (self, id);
      if (deleted)
        bse_item_push_undo_proc (self, "insert-control", equery.tick, equery.control_type, equery.control_value);
      bse_item_undo_close (ustack);
    }
#line 308 "bsepart.proc"
  
  g_value_set_enum (out_values++, deleted ? BSE_ERROR_NONE : BSE_ERROR_NO_EVENT);
  return BSE_ERROR_NONE;
}
/* --- is-event-selected --- */
static void
is_event_selected_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 312 "bsepart.proc"
 {
#line 314 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("selected", "Selected", NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 321 "bsepart.proc"
 }
static BseErrorType
#line 321 "bsepart.proc"
is_event_selected_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 324 "bsepart.proc"
{
#line 325 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  gboolean selected = FALSE;
  BsePartQueryEvent equery;
#line 330 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 333 "bsepart.proc"
  
  if (bse_part_query_event (self, id, &equery) != BSE_PART_EVENT_NONE)
    selected = equery.selected;
#line 336 "bsepart.proc"
  
  sfi_value_set_bool (out_values++, selected);
  return BSE_ERROR_NONE;
}
/* --- list-notes-crossing --- */
static void
list_notes_crossing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 340 "bsepart.proc"
 {
#line 342 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_STANDARD);
}
#line 351 "bsepart.proc"
 }
static BseErrorType
#line 351 "bsepart.proc"
list_notes_crossing_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 354 "bsepart.proc"
{
#line 355 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
#line 359 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 362 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes (self, ~0, tick, duration, BSE_MIN_NOTE, BSE_MAX_NOTE, TRUE));
  return BSE_ERROR_NONE;
}
/* --- list-notes-within --- */
static void
list_notes_within_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 366 "bsepart.proc"
 {
#line 368 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("channel", "Channel", NULL,
			 0, 0, BSE_PART_MAX_CHANNELS, 4, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_STANDARD);
}
#line 379 "bsepart.proc"
 }
static BseErrorType
#line 379 "bsepart.proc"
list_notes_within_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 382 "bsepart.proc"
{
#line 383 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    channel  = sfi_value_get_int (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
#line 388 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 391 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes (self, channel, tick, duration, BSE_MIN_NOTE, BSE_MAX_NOTE, FALSE));
  return BSE_ERROR_NONE;
}
/* --- list-controls --- */
static void
list_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 395 "bsepart.proc"
 {
#line 397 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("control_list", "Control List", NULL,
                                BSE_TYPE_PART_CONTROL_SEQ, SFI_PARAM_STANDARD);
}
#line 409 "bsepart.proc"
 }
static BseErrorType
#line 409 "bsepart.proc"
list_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 412 "bsepart.proc"
{
#line 413 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  guint    ctype     = g_value_get_enum (in_values++);
#line 418 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 421 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_controls (self, ~0, tick, duration, BseMidiSignalType (ctype)));
  return BSE_ERROR_NONE;
}
/* --- queue-notes --- */
static void
queue_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 425 "bsepart.proc"
 {
#line 427 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 438 "bsepart.proc"
 }
static BseErrorType
#line 438 "bsepart.proc"
queue_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 441 "bsepart.proc"
{
#line 442 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  gint     min_note = sfi_value_get_note (in_values++);
  gint     max_note = sfi_value_get_note (in_values++);
#line 448 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 451 "bsepart.proc"
  
  bse_part_queue_notes_within (self, tick, duration, min_note, max_note);
  return BSE_ERROR_NONE;
}
/* --- queue-controls --- */
static void
queue_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 455 "bsepart.proc"
 {
#line 457 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
}
#line 464 "bsepart.proc"
 }
static BseErrorType
#line 464 "bsepart.proc"
queue_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 467 "bsepart.proc"
{
#line 468 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
#line 472 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 475 "bsepart.proc"
  
  bse_part_queue_controls (self, tick, duration);
  return BSE_ERROR_NONE;
}
/* --- list-selected-notes --- */
static void
list_selected_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 479 "bsepart.proc"
 {
#line 481 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_STANDARD);
}
#line 486 "bsepart.proc"
 }
static BseErrorType
#line 486 "bsepart.proc"
list_selected_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 489 "bsepart.proc"
{
#line 490 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
#line 492 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 495 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_selected_notes (self));
  return BSE_ERROR_NONE;
}
/* --- list-selected-controls --- */
static void
list_selected_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 499 "bsepart.proc"
 {
#line 501 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("control_list", "Control List", NULL,
                                BSE_TYPE_PART_CONTROL_SEQ, SFI_PARAM_STANDARD);
}
#line 509 "bsepart.proc"
 }
static BseErrorType
#line 509 "bsepart.proc"
list_selected_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 512 "bsepart.proc"
{
#line 513 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    ctype    = g_value_get_enum (in_values++);
#line 516 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 519 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_selected_controls (self, BseMidiSignalType (ctype)));
  return BSE_ERROR_NONE;
}
/* --- check-overlap --- */
static void
check_overlap_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 523 "bsepart.proc"
 {
#line 525 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_STANDARD);
}
#line 535 "bsepart.proc"
 }
static BseErrorType
#line 535 "bsepart.proc"
check_overlap_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 538 "bsepart.proc"
{
#line 539 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  gint     note     = sfi_value_get_note (in_values++);
#line 544 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 547 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes (self, ~0, tick, duration, note, note, TRUE));
  return BSE_ERROR_NONE;
}
/* --- get-notes --- */
static void
get_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 551 "bsepart.proc"
 {
#line 553 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_STANDARD);
}
#line 562 "bsepart.proc"
 }
static BseErrorType
#line 562 "bsepart.proc"
get_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 565 "bsepart.proc"
{
#line 566 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  gint     note     = sfi_value_get_note (in_values++);
#line 570 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 573 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes (self, ~0, tick, 1, note, note, TRUE));
  return BSE_ERROR_NONE;
}
/* --- get-controls --- */
static void
get_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 577 "bsepart.proc"
 {
#line 579 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("control_list", "Control List", NULL,
                                BSE_TYPE_PART_CONTROL_SEQ, SFI_PARAM_STANDARD);
}
#line 589 "bsepart.proc"
 }
static BseErrorType
#line 589 "bsepart.proc"
get_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 592 "bsepart.proc"
{
#line 593 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    ctype    = g_value_get_enum (in_values++);
#line 597 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 600 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_controls (self, ~0, tick, 1, BseMidiSignalType (ctype)));
  return BSE_ERROR_NONE;
}
/* --- get-channel-controls --- */
static void
get_channel_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 604 "bsepart.proc"
 {
#line 606 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("channel", "Channel", NULL,
			 0, 0, BSE_PART_MAX_CHANNELS, 4, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("duration", "Tick Duration", NULL,
                         1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("control_list", "Control List", NULL,
                                BSE_TYPE_PART_CONTROL_SEQ, SFI_PARAM_STANDARD);
}
#line 620 "bsepart.proc"
 }
static BseErrorType
#line 620 "bsepart.proc"
get_channel_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 623 "bsepart.proc"
{
#line 624 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    channel  = sfi_value_get_int (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  guint    ctype    = g_value_get_enum (in_values++);
#line 630 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 633 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_controls (self, channel, tick, duration, BseMidiSignalType (ctype)));
  return BSE_ERROR_NONE;
}
/* --- get-min-note --- */
static void
get_min_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 637 "bsepart.proc"
 {
#line 639 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 644 "bsepart.proc"
 }
static BseErrorType
#line 644 "bsepart.proc"
get_min_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 647 "bsepart.proc"
{
#line 648 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
#line 650 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 653 "bsepart.proc"
  
  sfi_value_set_int (out_values++, BSE_MIN_NOTE);
  return BSE_ERROR_NONE;
}
/* --- get-max-note --- */
static void
get_max_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 657 "bsepart.proc"
 {
#line 659 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 664 "bsepart.proc"
 }
static BseErrorType
#line 664 "bsepart.proc"
get_max_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 667 "bsepart.proc"
{
#line 668 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
#line 670 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 673 "bsepart.proc"
  
  sfi_value_set_int (out_values++, BSE_MAX_NOTE);
  return BSE_ERROR_NONE;
}
/* --- select-notes-exclusive --- */
static void
select_notes_exclusive_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 677 "bsepart.proc"
 {
#line 679 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 690 "bsepart.proc"
 }
static BseErrorType
#line 690 "bsepart.proc"
select_notes_exclusive_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 693 "bsepart.proc"
{
#line 694 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  gint  min_note  = sfi_value_get_note (in_values++);
  gint  max_note  = sfi_value_get_note (in_values++);
#line 700 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  bse_part_select_notes_exclusive (self, ~0, tick, duration, min_note, max_note);
  return BSE_ERROR_NONE;
}
/* --- select-controls-exclusive --- */
static void
select_controls_exclusive_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 706 "bsepart.proc"
 {
#line 708 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
}
#line 718 "bsepart.proc"
 }
static BseErrorType
#line 718 "bsepart.proc"
select_controls_exclusive_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 721 "bsepart.proc"
{
#line 722 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  guint ctype     = g_value_get_enum (in_values++);
#line 727 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  bse_part_select_controls_exclusive (self, tick, duration, BseMidiSignalType (ctype));
  return BSE_ERROR_NONE;
}
/* --- select-controls --- */
static void
select_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 733 "bsepart.proc"
 {
#line 735 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
}
#line 745 "bsepart.proc"
 }
static BseErrorType
#line 745 "bsepart.proc"
select_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 748 "bsepart.proc"
{
#line 749 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  guint ctype     = g_value_get_enum (in_values++);
#line 754 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  bse_part_select_controls (self, tick, duration, BseMidiSignalType (ctype), TRUE);
  return BSE_ERROR_NONE;
}
/* --- select-notes --- */
static void
select_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 760 "bsepart.proc"
 {
#line 762 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 773 "bsepart.proc"
 }
static BseErrorType
#line 773 "bsepart.proc"
select_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 776 "bsepart.proc"
{
#line 777 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  gint  min_note  = sfi_value_get_note (in_values++);
  gint  max_note  = sfi_value_get_note (in_values++);
#line 783 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  bse_part_select_notes (self, ~0, tick, duration, min_note, max_note, TRUE);
  return BSE_ERROR_NONE;
}
/* --- deselect-notes --- */
static void
deselect_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 789 "bsepart.proc"
 {
#line 791 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 802 "bsepart.proc"
 }
static BseErrorType
#line 802 "bsepart.proc"
deselect_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 805 "bsepart.proc"
{
#line 806 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  gint  min_note  = sfi_value_get_note (in_values++);
  gint  max_note  = sfi_value_get_note (in_values++);
#line 812 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  bse_part_select_notes (self, ~0, tick, duration, min_note, max_note, FALSE);
  return BSE_ERROR_NONE;
}
/* --- deselect-controls --- */
static void
deselect_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 818 "bsepart.proc"
 {
#line 820 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
}
#line 830 "bsepart.proc"
 }
static BseErrorType
#line 830 "bsepart.proc"
deselect_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 833 "bsepart.proc"
{
#line 834 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  guint ctype     = g_value_get_enum (in_values++);
#line 839 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  bse_part_select_controls (self, tick, duration, BseMidiSignalType (ctype), FALSE);
  return BSE_ERROR_NONE;
}
/* --- select-event --- */
static void
select_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 845 "bsepart.proc"
 {
#line 847 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
}
#line 852 "bsepart.proc"
 }
static BseErrorType
#line 852 "bsepart.proc"
select_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 855 "bsepart.proc"
{
#line 856 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  BsePartQueryEvent equery;
#line 860 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 863 "bsepart.proc"
  
  bse_part_query_event (self, id, &equery);
  if (equery.event_type == BSE_PART_EVENT_CONTROL)
    bse_part_set_control_selected (self, id, TRUE);
  else if (equery.event_type == BSE_PART_EVENT_NOTE)
    bse_part_set_note_selected (self, id, equery.channel, TRUE);
  else
    return BSE_ERROR_PROC_PARAM_INVAL;
  return BSE_ERROR_NONE;
}
/* --- deselect-event --- */
static void
deselect_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 873 "bsepart.proc"
 {
#line 875 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
}
#line 880 "bsepart.proc"
 }
static BseErrorType
#line 880 "bsepart.proc"
deselect_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 883 "bsepart.proc"
{
#line 884 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  BsePartQueryEvent equery;
#line 888 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 891 "bsepart.proc"
  
  bse_part_query_event (self, id, &equery);
  if (equery.event_type == BSE_PART_EVENT_CONTROL)
    bse_part_set_control_selected (self, id, FALSE);
  else if (equery.event_type == BSE_PART_EVENT_NOTE)
    bse_part_set_note_selected (self, id, equery.channel, FALSE);
  else
    return BSE_ERROR_PROC_PARAM_INVAL;
  return BSE_ERROR_NONE;
}
/* --- get-timing --- */
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 901 "bsepart.proc"
 {
#line 903 "bsepart.proc"
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL, BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_STANDARD);
#line 906 "bsepart.proc"
}  }
static BseErrorType
#line 906 "bsepart.proc"
get_timing_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 909 "bsepart.proc"
{
#line 910 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
  SfiInt   tick = sfi_value_get_int (in_values++);
  BseItem *parent;
  BseSongTiming timing = { 0, };
#line 915 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 918 "bsepart.proc"
  
  parent = BSE_ITEM (self)->parent;
  if (BSE_IS_SONG (parent))
    bse_song_get_timing (BSE_SONG (parent), tick, &timing);
  else
    bse_song_timing_get_default (&timing);
#line 924 "bsepart.proc"
  
  bse_value_set_boxed (out_values++, &timing);
  return BSE_ERROR_NONE;
}
/* --- list-links --- */
static void
list_links_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 928 "bsepart.proc"
 {
#line 930 "bsepart.proc"
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL, BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("link_list", "Link List", NULL,
                                BSE_TYPE_PART_LINK_SEQ, SFI_PARAM_STANDARD);
}
#line 934 "bsepart.proc"
 }
static BseErrorType
#line 934 "bsepart.proc"
list_links_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 937 "bsepart.proc"
{
#line 938 "bsepart.proc"
  
  BsePart *self = (BsePart*) bse_value_get_object (in_values++);
#line 940 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 943 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_links (self));
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_insert_note_auto__fill_strings (BseExportStrings *es)
{
  es->blurb = "Insert a new note into a part with automatic channel selection.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 10;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_insert_note_auto = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BsePart+insert-note-auto", 
    NULL,
    "/Methods/BsePart/General/Insert Note Auto",
    NULL,
    __enode_insert_note_auto__fill_strings,
  },
  0, insert_note_auto_setup, insert_note_auto_exec, 
};
static void
__enode_insert_note__fill_strings (BseExportStrings *es)
{
  es->blurb = "Insert a new note into a part.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 53;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_insert_note = {
  { (BseExportNode*) &__enode_insert_note_auto, BSE_EXPORT_NODE_PROC,
    "BsePart+insert-note", 
    NULL,
    "/Methods/BsePart/General/Insert Note",
    NULL,
    __enode_insert_note__fill_strings,
  },
  0, insert_note_setup, insert_note_exec, 
};
static void
__enode_insert_control__fill_strings (BseExportStrings *es)
{
  es->blurb = "Insert a new control event into a part.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 99;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_insert_control = {
  { (BseExportNode*) &__enode_insert_note, BSE_EXPORT_NODE_PROC,
    "BsePart+insert-control", 
    NULL,
    "/Methods/BsePart/General/Insert Control",
    NULL,
    __enode_insert_control__fill_strings,
  },
  0, insert_control_setup, insert_control_exec, 
};
static void
__enode_change_note__fill_strings (BseExportStrings *es)
{
  es->blurb = "Change an existing note within a part.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 138;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_change_note = {
  { (BseExportNode*) &__enode_insert_control, BSE_EXPORT_NODE_PROC,
    "BsePart+change-note", 
    NULL,
    "/Methods/BsePart/General/Change Note",
    NULL,
    __enode_change_note__fill_strings,
  },
  0, change_note_setup, change_note_exec, 
};
static void
__enode_change_control__fill_strings (BseExportStrings *es)
{
  es->blurb = "Change an existing control event within a part.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 196;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_change_control = {
  { (BseExportNode*) &__enode_change_note, BSE_EXPORT_NODE_PROC,
    "BsePart+change-control", 
    NULL,
    "/Methods/BsePart/General/Change Control",
    NULL,
    __enode_change_control__fill_strings,
  },
  0, change_control_setup, change_control_exec, 
};
static void
__enode_delete_event__fill_strings (BseExportStrings *es)
{
  es->blurb = "Delete an existing event from a part.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 268;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_delete_event = {
  { (BseExportNode*) &__enode_change_control, BSE_EXPORT_NODE_PROC,
    "BsePart+delete-event", 
    NULL,
    "/Methods/BsePart/General/Delete Event",
    NULL,
    __enode_delete_event__fill_strings,
  },
  0, delete_event_setup, delete_event_exec, 
};
static void
__enode_is_event_selected__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether an event is selected.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 313;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_is_event_selected = {
  { (BseExportNode*) &__enode_delete_event, BSE_EXPORT_NODE_PROC,
    "BsePart+is-event-selected", 
    NULL,
    "/Methods/BsePart/General/Is Event Selected",
    NULL,
    __enode_is_event_selected__fill_strings,
  },
  0, is_event_selected_setup, is_event_selected_exec, 
};
static void
__enode_list_notes_crossing__fill_strings (BseExportStrings *es)
{
  es->blurb = "List all notes within or crossing a tick range.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 341;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_list_notes_crossing = {
  { (BseExportNode*) &__enode_is_event_selected, BSE_EXPORT_NODE_PROC,
    "BsePart+list-notes-crossing", 
    NULL,
    "/Methods/BsePart/General/List Notes Crossing",
    NULL,
    __enode_list_notes_crossing__fill_strings,
  },
  0, list_notes_crossing_setup, list_notes_crossing_exec, 
};
static void
__enode_list_notes_within__fill_strings (BseExportStrings *es)
{
  es->blurb = "List all notes within a tick range.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 367;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_list_notes_within = {
  { (BseExportNode*) &__enode_list_notes_crossing, BSE_EXPORT_NODE_PROC,
    "BsePart+list-notes-within", 
    NULL,
    "/Methods/BsePart/General/List Notes Within",
    NULL,
    __enode_list_notes_within__fill_strings,
  },
  0, list_notes_within_setup, list_notes_within_exec, 
};
static void
__enode_list_controls__fill_strings (BseExportStrings *es)
{
  es->blurb = "List all control events within a tick range.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 396;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_list_controls = {
  { (BseExportNode*) &__enode_list_notes_within, BSE_EXPORT_NODE_PROC,
    "BsePart+list-controls", 
    NULL,
    "/Methods/BsePart/General/List Controls",
    NULL,
    __enode_list_controls__fill_strings,
  },
  0, list_controls_setup, list_controls_exec, 
};
static void
__enode_queue_notes__fill_strings (BseExportStrings *es)
{
  es->blurb = "Queue updates for all notes starting within the given rectangle.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 426;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_queue_notes = {
  { (BseExportNode*) &__enode_list_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+queue-notes", 
    NULL,
    "/Methods/BsePart/General/Queue Notes",
    NULL,
    __enode_queue_notes__fill_strings,
  },
  0, queue_notes_setup, queue_notes_exec, 
};
static void
__enode_queue_controls__fill_strings (BseExportStrings *es)
{
  es->blurb = "Queue updates for all control events and notes starting within the given range.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 456;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_queue_controls = {
  { (BseExportNode*) &__enode_queue_notes, BSE_EXPORT_NODE_PROC,
    "BsePart+queue-controls", 
    NULL,
    "/Methods/BsePart/General/Queue Controls",
    NULL,
    __enode_queue_controls__fill_strings,
  },
  0, queue_controls_setup, queue_controls_exec, 
};
static void
__enode_list_selected_notes__fill_strings (BseExportStrings *es)
{
  es->blurb = "List all currently selected notes.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 480;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_list_selected_notes = {
  { (BseExportNode*) &__enode_queue_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+list-selected-notes", 
    NULL,
    "/Methods/BsePart/General/List Selected Notes",
    NULL,
    __enode_list_selected_notes__fill_strings,
  },
  0, list_selected_notes_setup, list_selected_notes_exec, 
};
static void
__enode_list_selected_controls__fill_strings (BseExportStrings *es)
{
  es->blurb = "List all currently selected control events of a specific type.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 500;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_list_selected_controls = {
  { (BseExportNode*) &__enode_list_selected_notes, BSE_EXPORT_NODE_PROC,
    "BsePart+list-selected-controls", 
    NULL,
    "/Methods/BsePart/General/List Selected Controls",
    NULL,
    __enode_list_selected_controls__fill_strings,
  },
  0, list_selected_controls_setup, list_selected_controls_exec, 
};
static void
__enode_check_overlap__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a note would overlap with neighbours.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 524;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_check_overlap = {
  { (BseExportNode*) &__enode_list_selected_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+check-overlap", 
    NULL,
    "/Methods/BsePart/General/Check Overlap",
    NULL,
    __enode_check_overlap__fill_strings,
  },
  0, check_overlap_setup, check_overlap_exec, 
};
static void
__enode_get_notes__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve all notes of specific frequency at or crossing a specific tick.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 552;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_notes = {
  { (BseExportNode*) &__enode_check_overlap, BSE_EXPORT_NODE_PROC,
    "BsePart+get-notes", 
    NULL,
    "/Methods/BsePart/General/Get Notes",
    NULL,
    __enode_get_notes__fill_strings,
  },
  0, get_notes_setup, get_notes_exec, 
};
static void
__enode_get_controls__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve all control events of a specific type at specified tick.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 578;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_controls = {
  { (BseExportNode*) &__enode_get_notes, BSE_EXPORT_NODE_PROC,
    "BsePart+get-controls", 
    NULL,
    "/Methods/BsePart/General/Get Controls",
    NULL,
    __enode_get_controls__fill_strings,
  },
  0, get_controls_setup, get_controls_exec, 
};
static void
__enode_get_channel_controls__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve all control events of a specific type within range of a channel.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 605;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_channel_controls = {
  { (BseExportNode*) &__enode_get_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+get-channel-controls", 
    NULL,
    "/Methods/BsePart/General/Get Channel Controls",
    NULL,
    __enode_get_channel_controls__fill_strings,
  },
  0, get_channel_controls_setup, get_channel_controls_exec, 
};
static void
__enode_get_min_note__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the minimum note supported in this part.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 638;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_min_note = {
  { (BseExportNode*) &__enode_get_channel_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+get-min-note", 
    NULL,
    "/Methods/BsePart/General/Get Min Note",
    NULL,
    __enode_get_min_note__fill_strings,
  },
  0, get_min_note_setup, get_min_note_exec, 
};
static void
__enode_get_max_note__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the maximum note supported in this part.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 658;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_max_note = {
  { (BseExportNode*) &__enode_get_min_note, BSE_EXPORT_NODE_PROC,
    "BsePart+get-max-note", 
    NULL,
    "/Methods/BsePart/General/Get Max Note",
    NULL,
    __enode_get_max_note__fill_strings,
  },
  0, get_max_note_setup, get_max_note_exec, 
};
static void
__enode_select_notes_exclusive__fill_strings (BseExportStrings *es)
{
  es->blurb = "Select all notes within rectangle and deselect all others.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 678;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_select_notes_exclusive = {
  { (BseExportNode*) &__enode_get_max_note, BSE_EXPORT_NODE_PROC,
    "BsePart+select-notes-exclusive", 
    NULL,
    "/Methods/BsePart/General/Select Notes Exclusive",
    NULL,
    __enode_select_notes_exclusive__fill_strings,
  },
  0, select_notes_exclusive_setup, select_notes_exclusive_exec, 
};
static void
__enode_select_controls_exclusive__fill_strings (BseExportStrings *es)
{
  es->blurb = "Select all control events within range and deselect all others.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 707;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_select_controls_exclusive = {
  { (BseExportNode*) &__enode_select_notes_exclusive, BSE_EXPORT_NODE_PROC,
    "BsePart+select-controls-exclusive", 
    NULL,
    "/Methods/BsePart/General/Select Controls Exclusive",
    NULL,
    __enode_select_controls_exclusive__fill_strings,
  },
  0, select_controls_exclusive_setup, select_controls_exclusive_exec, 
};
static void
__enode_select_controls__fill_strings (BseExportStrings *es)
{
  es->blurb = "Select all control events within range.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 734;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_select_controls = {
  { (BseExportNode*) &__enode_select_controls_exclusive, BSE_EXPORT_NODE_PROC,
    "BsePart+select-controls", 
    NULL,
    "/Methods/BsePart/General/Select Controls",
    NULL,
    __enode_select_controls__fill_strings,
  },
  0, select_controls_setup, select_controls_exec, 
};
static void
__enode_select_notes__fill_strings (BseExportStrings *es)
{
  es->blurb = "Select all notes within rectangle.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 761;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_select_notes = {
  { (BseExportNode*) &__enode_select_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+select-notes", 
    NULL,
    "/Methods/BsePart/General/Select Notes",
    NULL,
    __enode_select_notes__fill_strings,
  },
  0, select_notes_setup, select_notes_exec, 
};
static void
__enode_deselect_notes__fill_strings (BseExportStrings *es)
{
  es->blurb = "Deselect all notes within rectangle.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 790;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_deselect_notes = {
  { (BseExportNode*) &__enode_select_notes, BSE_EXPORT_NODE_PROC,
    "BsePart+deselect-notes", 
    NULL,
    "/Methods/BsePart/General/Deselect Notes",
    NULL,
    __enode_deselect_notes__fill_strings,
  },
  0, deselect_notes_setup, deselect_notes_exec, 
};
static void
__enode_deselect_controls__fill_strings (BseExportStrings *es)
{
  es->blurb = "Deselect all controls within given range.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 819;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_deselect_controls = {
  { (BseExportNode*) &__enode_deselect_notes, BSE_EXPORT_NODE_PROC,
    "BsePart+deselect-controls", 
    NULL,
    "/Methods/BsePart/General/Deselect Controls",
    NULL,
    __enode_deselect_controls__fill_strings,
  },
  0, deselect_controls_setup, deselect_controls_exec, 
};
static void
__enode_select_event__fill_strings (BseExportStrings *es)
{
  es->blurb = "Select an existing event.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 846;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_select_event = {
  { (BseExportNode*) &__enode_deselect_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+select-event", 
    NULL,
    "/Methods/BsePart/General/Select Event",
    NULL,
    __enode_select_event__fill_strings,
  },
  0, select_event_setup, select_event_exec, 
};
static void
__enode_deselect_event__fill_strings (BseExportStrings *es)
{
  es->blurb = "Deselect an existing event.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 874;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_deselect_event = {
  { (BseExportNode*) &__enode_select_event, BSE_EXPORT_NODE_PROC,
    "BsePart+deselect-event", 
    NULL,
    "/Methods/BsePart/General/Deselect Event",
    NULL,
    __enode_deselect_event__fill_strings,
  },
  0, deselect_event_setup, deselect_event_exec, 
};
static void
__enode_get_timing__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve song timing information at a specific tick.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 902;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_timing = {
  { (BseExportNode*) &__enode_deselect_event, BSE_EXPORT_NODE_PROC,
    "BsePart+get-timing", 
    NULL,
    "/Methods/BsePart/General/Get Timing",
    NULL,
    __enode_get_timing__fill_strings,
  },
  0, get_timing_setup, get_timing_exec, 
};
static void
__enode_list_links__fill_strings (BseExportStrings *es)
{
  es->blurb = "List all places where parts are used (linked) from tracks, sorted by tick.";
  es->file = "/opt/src/beast/bse/bsepart.proc";
  es->line = 929;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_list_links = {
  { (BseExportNode*) &__enode_get_timing, BSE_EXPORT_NODE_PROC,
    "BsePart+list-links", 
    NULL,
    "/Methods/BsePart/General/List Links",
    NULL,
    __enode_list_links__fill_strings,
  },
  0, list_links_setup, list_links_exec, 
};
extern "C" BseExportNode* bse__builtin_init_bsepart_genprc_cc (void)
{
  return (BseExportNode*) &__enode_list_links;
}

/*
 * Generated data ends here
 */
