/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc;

import com.kreative.ksfl.KSFLUtilities;
import java.util.Arrays;

public class MacResource {
    public int type;
    public short id;
    public String name;
    public boolean compressed;
    public boolean changed;
    public boolean preload;
    public boolean protect;
    public boolean locked;
    public boolean purgeable;
    public boolean sysheap;
    public boolean reserved;
    public byte[] data;
    public static final int OWNER_TYPE_DRVR = 24;
    public static final int OWNER_TYPE_WDEF = 25;
    public static final int OWNER_TYPE_MDEF = 26;
    public static final int OWNER_TYPE_CDEF = 27;
    public static final int OWNER_TYPE_PDEF = 28;
    public static final int OWNER_TYPE_PACK = 29;
    public static final int OWNER_TYPE_RSV1 = 30;
    public static final int OWNER_TYPE_RSV2 = 31;
    public static final int OWNER_TYPE_CDEV = 30;
    public static final int OWNER_ID_CDEV = 1;

    public static boolean isMyType(int type) {
        return true;
    }

    public MacResource(int type, short id, byte[] data) {
        this.type = type;
        this.id = id;
        this.name = "";
        this.data = data;
        this.compressed = false;
        this.changed = false;
        this.preload = false;
        this.protect = false;
        this.locked = false;
        this.purgeable = false;
        this.sysheap = false;
        this.reserved = false;
    }

    public MacResource(int type, short id, String name, byte[] data) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.data = data;
        this.compressed = false;
        this.changed = false;
        this.preload = false;
        this.protect = false;
        this.locked = false;
        this.purgeable = false;
        this.sysheap = false;
        this.reserved = false;
    }

    public MacResource(int type, short id, byte attr, byte[] data) {
        this.type = type;
        this.id = id;
        this.name = "";
        this.data = data;
        this.setAttributes(attr);
    }

    public MacResource(int type, short id, byte attr, String name, byte[] data) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.data = data;
        this.setAttributes(attr);
    }

    public int getOwnerType() {
        return this.id >> 11 & 0x1F;
    }

    public int getOwnerID() {
        return this.id >> 5 & 0x3F;
    }

    public int getSubID() {
        return this.id & 0x1F;
    }

    public void setOwnerType(int ot) {
        this.id = (short)((ot & 0x1F) << 11 | this.id & 0x7FF);
    }

    public void setOwnerID(int oi) {
        this.id = (short)((oi & 0x3F) << 5 | this.id & 0xF81F);
    }

    public void setSubID(int si) {
        this.id = (short)(si & 0x1F | this.id & 0xFFE0);
    }

    public byte getAttributes() {
        byte b = 0;
        if (this.compressed) {
            b = (byte)(b | 1);
        }
        if (this.changed) {
            b = (byte)(b | 2);
        }
        if (this.preload) {
            b = (byte)(b | 4);
        }
        if (this.protect) {
            b = (byte)(b | 8);
        }
        if (this.locked) {
            b = (byte)(b | 0x10);
        }
        if (this.purgeable) {
            b = (byte)(b | 0x20);
        }
        if (this.sysheap) {
            b = (byte)(b | 0x40);
        }
        if (this.reserved) {
            b = (byte)(b | 0x80);
        }
        return b;
    }

    public String getAttributeString() {
        StringBuffer a = new StringBuffer();
        if (this.compressed) {
            a.append("C");
        } else {
            a.append("-");
        }
        if (this.changed) {
            a.append("H");
        } else {
            a.append("-");
        }
        if (this.preload) {
            a.append("L");
        } else {
            a.append("-");
        }
        if (this.protect) {
            a.append("P");
        } else {
            a.append("-");
        }
        if (this.locked) {
            a.append("F");
        } else {
            a.append("-");
        }
        if (this.purgeable) {
            a.append("U");
        } else {
            a.append("-");
        }
        if (this.sysheap) {
            a.append("S");
        } else {
            a.append("-");
        }
        if (this.reserved) {
            a.append("R");
        } else {
            a.append("-");
        }
        return a.toString();
    }

    public void setAttributes(byte b) {
        this.compressed = (b & 1) != 0;
        this.changed = (b & 2) != 0;
        this.preload = (b & 4) != 0;
        this.protect = (b & 8) != 0;
        this.locked = (b & 0x10) != 0;
        this.purgeable = (b & 0x20) != 0;
        this.sysheap = (b & 0x40) != 0;
        this.reserved = (b & 0x80) != 0;
    }

    public void setAttributeString(String a) {
        this.compressed = a.contains("C") || a.contains("c");
        this.changed = a.contains("H") || a.contains("h") || a.contains("N") || a.contains("n");
        this.preload = a.contains("L") || a.contains("l");
        this.protect = a.contains("P") || a.contains("p");
        this.locked = a.contains("F") || a.contains("f");
        this.purgeable = a.contains("U") || a.contains("u") || a.contains("G") || a.contains("g");
        this.sysheap = a.contains("S") || a.contains("s");
        this.reserved = a.contains("R") || a.contains("r");
    }

    public MacResource shallowCopy() {
        return new MacResource(this.type, this.id, this.getAttributes(), this.name, this.data);
    }

    public MacResource deepCopy() {
        return new MacResource(this.type, this.id, this.getAttributes(), new String(this.name), KSFLUtilities.copy(this.data));
    }

    public <R extends MacResource> R shallowRecast(Class<R> resourceSubclass) {
        Class[] fparam = new Class[]{Integer.TYPE, Short.TYPE, Byte.TYPE, String.class, byte[].class};
        Object[] aparam = new Object[]{this.type, this.id, this.getAttributes(), this.name, this.data};
        try {
            return (R)((MacResource)resourceSubclass.getConstructor(fparam).newInstance(aparam));
        }
        catch (Exception e) {
            return null;
        }
    }

    public <R extends MacResource> R deepRecast(Class<R> resourceSubclass) {
        Class[] fparam = new Class[]{Integer.TYPE, Short.TYPE, Byte.TYPE, String.class, byte[].class};
        Object[] aparam = new Object[]{this.type, this.id, this.getAttributes(), new String(this.name), KSFLUtilities.copy(this.data)};
        try {
            return (R)((MacResource)resourceSubclass.getConstructor(fparam).newInstance(aparam));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof MacResource) {
            MacResource other = (MacResource)o;
            return this.type == other.type && this.id == other.id && this.name.equals(other.name) && this.getAttributes() == other.getAttributes() && Arrays.equals(this.data, other.data);
        }
        return false;
    }

    public int hashCode() {
        return this.type ^ (this.id << 16 | this.getAttributes() & 0xFF) ^ this.name.hashCode() ^ Arrays.hashCode(this.data);
    }
}

