//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Axis/BasicAxisItem.h
//! @brief     Defines various axis items
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_AXIS_BASICAXISITEM_H
#define BORNAGAIN_GUI_MODEL_AXIS_BASICAXISITEM_H

#include <QObject>

class Scale;
class QXmlStreamReader;
class QXmlStreamWriter;

class BasicAxisItem : public QObject {
    Q_OBJECT

public:
    explicit BasicAxisItem(QObject* parent = nullptr);
    ~BasicAxisItem() override;

    virtual void writeTo(QXmlStreamWriter* w) const;
    virtual void readFrom(QXmlStreamReader* r);

public:
    virtual std::unique_ptr<Scale> itemToAxis(double scale, const Scale& converted_axis) const;
    std::unique_ptr<Scale> itemToRegularAxis(double scale) const;

    int binCount() const;
    void setBinCount(size_t value);

    double min() const;
    void setMin(double value);

    double max() const;
    void setMax(double value);

    QString title() const;
    void setTitle(const QString& title);

    bool isVisible() const;
    void setVisible(bool b);

signals:
    void axisRangeChanged();
    void axisTitleChanged();
    void axisVisibilityChanged();

private:
    bool m_visible;
    int m_nbins;
    double m_min; // in display units (if angle, then deg)
    double m_max;
    QString m_title;
};

#endif // BORNAGAIN_GUI_MODEL_AXIS_BASICAXISITEM_H
