//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Data/JobStatus.cpp
//! @brief     Implements class JobWorker
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Support/Data/JobStatus.h"
#include "Base/Util/Assert.h"

#include <boost/bimap.hpp>
#include <vector>

namespace {

const std::vector<boost::bimap<JobStatus, QString>::value_type> values = {
    {JobStatus::Idle, "Idle"},         {JobStatus::Running, "Running"},
    {JobStatus::Fitting, "Fitting"},   {JobStatus::Completed, "Completed"},
    {JobStatus::Canceled, "Canceled"}, {JobStatus::Failed, "Failed"}};

const boost::bimap<JobStatus, QString> status2name(values.begin(), values.end());

} // namespace


QString jobStatusToString(JobStatus status)
{
    auto it = status2name.left.find(status);
    ASSERT(it != status2name.left.end());
    return it->second;
}

JobStatus jobStatusFromString(const QString& name)
{
    auto it = status2name.right.find(name);
    ASSERT(it != status2name.right.end());
    return it->second;
}
