//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Resample/Coherence/CoheringSubparticles.cpp
//! @brief     Implements class CoheringSubparticles.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "Resample/Coherence/CoheringSubparticles.h"
#include "Base/Spin/SpinMatrix.h"
#include "Resample/Particle/IReParticle.h"
#include <utility>

CoheringSubparticles::~CoheringSubparticles() = default;

CoheringSubparticles::CoheringSubparticles(double abundance, OwningVector<IReParticle>&& terms)
    : m_abundance(abundance)
    , m_terms(std::move(terms))
{
}

complex_t CoheringSubparticles::summedFF(const DiffuseElement& ele) const
{
    complex_t result = 0.;
    for (const auto& term : m_terms)
        result += term->coherentFF(ele);
    return result;
}

SpinMatrix CoheringSubparticles::summedPolFF(const DiffuseElement& ele) const
{
    SpinMatrix result;
    for (const auto& term : m_terms)
        result += term->coherentPolFF(ele);
    return result;
}

double CoheringSubparticles::radialExtension() const
{
    return m_terms[0]->radialExtension();
}
